#!/bin/sh

ASSIGN_NAME=hw2
STUDENT=$LOGNAME

if test ! "$1" = "" ; then
	 OTHER_STUDENT="$1"
	 echo "Submitting assignment $ASSIGN_NAME for $STUDENT and $OTHER_STUDENT"
	 FILE_NAME=${STUDENT}-${OTHER_STUDENT}-${ASSIGN_NAME}
else
	 echo Submitting assignment $ASSIGN_NAME for $STUDENT
	 FILE_NAME=${STUDENT}-${ASSIGN_NAME}
fi

tar -zcf ./tmpfiles.tgz * || { echo "Submission failed."; exit 1;}
echo Submitting files:
tar -ztf ./tmpfiles.tgz || { echo "Submission failed"; exit 1;}


HWDIR=/usr/class/cs243/hw2submission/${FILE_NAME}
if [ -d ${HWDIR} ]
then
	echo ""
else
	mkdir ${HWDIR}
fi

fs setacl ${HWDIR} system:anyuser none
fs setacl ${HWDIR} ${STUDENT} write
cp ./tmpfiles.tgz ${HWDIR}


if test ${?} != 0 ; then
    echo "Submission failed"
    exit 1
fi

rm ./tmpfiles.tgz

echo Submission Successful!

exit 0
