import java.util.*;
import Compil3r.Quad.*;
import Compil3r.Quad.Operator.*;
import Compil3r.Quad.Operand.*;


public class Liveness implements Flow.Analysis 
{

    public static class VarSet implements Flow.DataflowObject 
	 {
		  private Set set;
		  public static Set universalSet;
		  public VarSet() { set = new TreeSet(); }

		  public void setToTop() { set = new TreeSet(); }
		  public void setToBottom() { set = new TreeSet(universalSet); }

		  public void meetWith (Flow.DataflowObject o) 
		  {
				VarSet a = (VarSet)o;
				set.addAll(a.set);
		  }
		  
		  public void copy (Flow.DataflowObject o) 
		  {
				VarSet a = (VarSet) o;
				set = new TreeSet(a.set);
		  }

		  public boolean equals (Object o) 
		  {
				if (o instanceof VarSet) 
					 {
						  VarSet a = (VarSet) o;
						  return set.equals(a.set);
					 }
				return false;
		  }
	public String toString() 
		  {
				return set.toString();
		  }

		  public void genVar(Object v) {set.add(v);}
		  public void killVar(Object v) {set.remove(v);}
	 }
	 
    private VarSet[] in, out;
    private VarSet entry, exit;

    public void preprocess (ControlFlowGraph cfg) 
	 {
		  System.out.println("Method: "+cfg.getMethod().getName().toString());
		  /* Generate initial conditions. */
		  QuadIterator qit = new QuadIterator(cfg);
		  int max = 0;
		  while (qit.hasNext()) {
				int x = qit.nextQuad().getID();
				if (x > max) max = x;
		  }
		  max += 1;
		  in = new VarSet[max];
		  out = new VarSet[max];
		  qit = new QuadIterator(cfg);
	
		  Set s = new TreeSet();
		  VarSet.universalSet = s;
	
		  /* Arguments are always there. */
		  int numargs = cfg.getMethod().getParamTypes().length;
		  for (int i = 0; i < numargs; i++) {
				s.add("R"+i);
		  }
	
		  while (qit.hasNext()) {
				Quad q = qit.nextQuad();
				int id = q.getID();
				Iterator rit = q.getDefinedRegisters().iterator();
				while (rit.hasNext()) {
					 String v = ((Operand.RegisterOperand)rit.next()).getRegister().toString();
					 s.add(v);
				}
				rit = q.getUsedRegisters().iterator();
				while (rit.hasNext()) {
					 String v = ((Operand.RegisterOperand)rit.next()).getRegister().toString();
					 s.add(v);
				}
		  }
	
		  entry = new VarSet();
		  exit = new VarSet();
		  transferfn.val = new VarSet();
		  for (int i=0; i<in.length; i++) {
				in[i] = new VarSet();
				out[i] = new VarSet();
		  }
	
		  System.out.println("Initialization completed.");
	 }

    public void postprocess (ControlFlowGraph cfg) {
		  System.out.println("entry: "+entry.toString());
		  for (int i=1; i<in.length; i++) {
				System.out.println(i+" in:  "+in[i].toString());
				System.out.println(i+" out: "+out[i].toString());
		  }
		  System.out.println("exit: "+exit.toString());
    }

    /* Is this a forward dataflow analysis? */
    public boolean isForward () { return false; }

    /* Routines for interacting with dataflow values. */

    public Flow.DataflowObject getEntry() 
	 { 
		  Flow.DataflowObject result = newTempVar();
		  result.copy(entry); 
		  return result;
    }
    public Flow.DataflowObject getExit() 
	 { 
		  Flow.DataflowObject result = newTempVar();
		  result.copy(exit); 
		  return result;
    }
    public Flow.DataflowObject getIn(Quad q) 
	 {
		  Flow.DataflowObject result = newTempVar();
		  result.copy(in[q.getID()]); 
		  return result;
    }
    public Flow.DataflowObject getOut(Quad q) 
	 {
		  Flow.DataflowObject result = newTempVar();
		  result.copy(out[q.getID()]); 
		  return result;
    }
    public void setIn(Quad q, Flow.DataflowObject value) 
	 { 
		  in[q.getID()].copy(value); 
    }
    public void setOut(Quad q, Flow.DataflowObject value) 
	 { 
		  out[q.getID()].copy(value); 
    }
    public void setEntry(Flow.DataflowObject value) 
	 { 
		  entry.copy(value); 
    }
    public void setExit(Flow.DataflowObject value) 
	 { 
		  exit.copy(value); 
    }

    public Flow.DataflowObject newTempVar() { return new VarSet(); }

    /* Actually perform the transfer operation on the relevant
     * quad. */

    private TransferFunction transferfn = new TransferFunction ();
    public void processQuad(Quad q) {
		  transferfn.val.copy(out[q.getID()]);
		  transferfn.visitQuad(q);
		  //		  Main.Helper.runPass(q, transferfn);
		  in[q.getID()].copy(transferfn.val);
    }

    /* The QuadVisitor that actually does the computation */
    public static class TransferFunction extends QuadVisitor.EmptyVisitor
    {
		  VarSet val;
		  public void visitQuad(Quad q)
		  {
				//				System.out.println("Visiting "+q);
				Iterator rit = q.getDefinedRegisters().iterator();
				while (rit.hasNext()) {
					 String v =
						  ((Operand.RegisterOperand)rit.next()).getRegister().toString();
					 //					 System.out.println("To kill: "+v);
					 val.killVar(v);
				}
				rit = q.getUsedRegisters().iterator();
				while (rit.hasNext()) {
					 String v = ((Operand.RegisterOperand)rit.next()).getRegister().toString();
					 //					 System.out.println("To add: "+v);
					 val.genVar(v);
				}
		  }
    }
}
