import java.util.*;
import Compil3r.Quad.*;
import Compil3r.Quad.Operator.*;
import Compil3r.Quad.Operand.*;


public class ConstantProp implements Flow.Analysis {

    public static class SingleCP implements Flow.DataflowObject {
 	private int state;
	private int constant;

	public SingleCP() { setUndef(); }

	public void setToTop() { setUndef(); }
	public void setToBottom() { setNAC(); }

	public void meetWith (Flow.DataflowObject o) {
	    SingleCP a = (SingleCP)o;
	    if (a.state == 0) 
		return;
	    if (state == 0) {
		state = a.state;
		constant = a.constant;
		return;
	    }
	    if (state == 2 || a.state == 2) {
		setNAC();
		return;
	    }
	    /* otherwise, both are constants */
	    if (constant == a.constant) {
		return;
	    }
	    setNAC();
	}
	
	public void copy (Flow.DataflowObject o) {
	    SingleCP a = (SingleCP) o;
	    state = a.state;
	    constant = a.constant;
	}

	public boolean equals (Object o) {
	    if (o instanceof SingleCP) {
		SingleCP a = (SingleCP) o;
		if (state != 1) {
		    return a.state == state;
		} else {
		    return a.state == state && a.constant == constant;
		}
	    }
	    return false;
	}
	public String toString() {
	    switch (state) {
	    case 0: return "undef";
	    case 1: return String.valueOf(constant);
	    case 2: return "NAC";
	    default: break;
	    }
	    return ("<invalid state "+state+">");
	}

	public void setUndef() { state = 0; }
	public void setConst(int val) { 
	    state = 1; constant = val;
	}
	public void setNAC() { state = 2; }

	public boolean isUndef() { return state == 0; }
	public boolean isConst() { return state == 1; }
	public boolean isNAC() { return state == 2; }
	public int getConst() { return constant; }
    }

    public static class ConstantPropTable implements Flow.DataflowObject {
	private SortedMap map;

	/* 'core' is used to keep track of which variables we need to
	 * track */
	private static Set core;
	static { core = new HashSet(); }
	public static void reset() { core.clear(); }
	public static void register(String key) {
	    core.add(key);
	}

	public ConstantPropTable() {
	    map = new TreeMap();
	    Iterator it = core.iterator();
	    while (it.hasNext()) {
		map.put(it.next(), new SingleCP());
	    }
	}

	public void setToTop() {
	    Iterator it = map.entrySet().iterator();
	    while (it.hasNext()) {
		((Flow.DataflowObject)(((Map.Entry)it.next()).getValue())).setToTop();
	    }
	}

	public void setToBottom() {
	    Iterator it = map.entrySet().iterator();
	    while (it.hasNext()) {
		((Flow.DataflowObject)(((Map.Entry)it.next()).getValue())).setToBottom();
	    }
	}

	public void meetWith (Flow.DataflowObject o) {
	    ConstantPropTable a = (ConstantPropTable) o;
	    Iterator it = a.map.entrySet().iterator();
	    while (it.hasNext()) {
		Map.Entry e = (Map.Entry)it.next();
		String key = (String)e.getKey();
		SingleCP mine = (SingleCP)map.get(key);
		mine.meetWith((SingleCP)e.getValue());
	    }		
	}

	public void copy (Flow.DataflowObject o) {
	    ConstantPropTable a = (ConstantPropTable) o;
	    Iterator it = a.map.entrySet().iterator();
	    while (it.hasNext()) {
		Map.Entry e = (Map.Entry)it.next();
		String key = (String)e.getKey();
		SingleCP mine = (SingleCP)map.get(key);
		mine.copy((SingleCP)e.getValue());
	    }		
	}

	public String toString() {
	    return map.toString();
	}

	public SingleCP get(String key) {
	    return (SingleCP)map.get(key);
	}

	public boolean equals (Object o) {
	    if (o instanceof ConstantPropTable) {
		return map.equals (((ConstantPropTable)o).map);
	    }
	    return false;
	}
	
	public void setUndef(String key) {
	    get(key).setUndef();
	}
	public void setConst(String key, int val) {
	    get(key).setConst(val);
	}
	public void setNAC(String key) {
	    get(key).setNAC();
	}
	public void transfer(String key, String src) {
	    get(key).copy(get(src));
	}
    }

    private ConstantPropTable[] in, out;
    private ConstantPropTable entry, exit;

    public void preprocess (ControlFlowGraph cfg) {
	System.out.println("Method: "+cfg.getMethod().getName().toString());
	/* Generate initial conditions. */
	QuadIterator qit = new QuadIterator(cfg);
	int max = 0;
	while (qit.hasNext()) {
	    int x = qit.nextQuad().getID();
	    if (x > max) max = x;
	}
	max += 1;
	in = new ConstantPropTable[max];
	out = new ConstantPropTable[max];
	qit = new QuadIterator(cfg);
	
	ConstantPropTable.reset();
	
	/* Arguments are always there. */
	int numargs = cfg.getMethod().getParamTypes().length;
	for (int i = 0; i < numargs; i++) {
	    ConstantPropTable.register("R"+i);
	}
	
	while (qit.hasNext()) {
	    Quad q = qit.nextQuad();
	    int id = q.getID();
	    Iterator rit = q.getDefinedRegisters().iterator();
	    while (rit.hasNext()) {
		String v = ((Operand.RegisterOperand)rit.next()).getRegister().toString();
		ConstantPropTable.register(v);
	    }
	    rit = q.getUsedRegisters().iterator();
	    while (rit.hasNext()) {
		String v = ((Operand.RegisterOperand)rit.next()).getRegister().toString();
		ConstantPropTable.register(v);
	    }
	}
	
	entry = new ConstantPropTable();
	exit = new ConstantPropTable();
	transferfn.val = new ConstantPropTable();
	for (int i=0; i<in.length; i++) {
	    in[i] = new ConstantPropTable();
	    out[i] = new ConstantPropTable();
	}
	
	for (int i=0; i < numargs; i++) {
	    entry.setNAC("R"+i);
	}
	System.out.println("Initialization completed.");
    }

    public void postprocess (ControlFlowGraph cfg) {
	System.out.println("entry: "+entry.toString());
	for (int i=0; i<in.length; i++) {
	    System.out.println(i+" in:  "+in[i].toString());
	    System.out.println(i+" out: "+out[i].toString());
	}
	System.out.println("exit: "+exit.toString());
    }

    /* Is this a forward dataflow analysis? */
    public boolean isForward () { return true; }

    /* Routines for interacting with dataflow values. */

    public Flow.DataflowObject getEntry() { 
	Flow.DataflowObject result = newTempVar();
	result.copy(entry); 
	return result;
    }
    public Flow.DataflowObject getExit() { 
	Flow.DataflowObject result = newTempVar();
	result.copy(exit); 
	return result;
    }
    public Flow.DataflowObject getIn(Quad q) { 
	Flow.DataflowObject result = newTempVar();
	result.copy(in[q.getID()]); 
	return result;
    }
    public Flow.DataflowObject getOut(Quad q) { 
	Flow.DataflowObject result = newTempVar();
	result.copy(out[q.getID()]); 
	return result;
    }
    public void setIn(Quad q, Flow.DataflowObject value) { 
	in[q.getID()].copy(value); 
    }
    public void setOut(Quad q, Flow.DataflowObject value) { 
	out[q.getID()].copy(value); 
    }
    public void setEntry(Flow.DataflowObject value) { 
	entry.copy(value); 
    }
    public void setExit(Flow.DataflowObject value) { 
	exit.copy(value); 
    }

    public Flow.DataflowObject newTempVar() { return new ConstantPropTable(); }

    /* Actually perform the transfer operation on the relevant
     * quad. */

    private TransferFunction transferfn = new TransferFunction ();
    public void processQuad(Quad q) {
	transferfn.val.copy(in[q.getID()]);
	Main.Helper.runPass(q, transferfn);
	out[q.getID()].copy(transferfn.val);
    }

    /* The QuadVisitor that actually does the computation */
    public static class TransferFunction extends QuadVisitor.EmptyVisitor
    {
	ConstantPropTable val;
	public void visitMove (Quad q) {
	    Operand op = Operator.Move.getSrc(q);
	    String key = Operator.Move.getDest(q).getRegister().toString();

	    if (isUndef(op)) {
		val.setUndef(key);
	    } else if (isConst(op)) {
		val.setConst(key, getConst(op));
	    } else {
		val.setNAC(key);
	    }
	}
	public void visitBinary (Quad q) {
	    Operand op1 =  Operator.Binary.getSrc1(q);
	    Operand op2 =  Operator.Binary.getSrc2(q);
	    String key =   Operator.Binary.getDest(q).getRegister().toString();
	    Operator opr = q.getOperator();
	    
	    if (opr == Operator.Binary.ADD_I.INSTANCE) {
		if (isNAC(op1) || isNAC(op2)) {
		    val.setNAC(key);
		} else if (isUndef(op1) || isUndef(op2)) {
		    val.setUndef(key);
		} else { // both must be constant!
		    val.setConst(key, getConst(op1)+getConst(op2));
		}
	    } else {
		val.setNAC(key);
	    }
	}
	public void visitUnary (Quad q) {
	    Operand op = Operator.Unary.getSrc(q);
	    String key = Operator.Unary.getDest(q).getRegister().toString();
	    Operator opr = q.getOperator();
	    
	    if (opr == Operator.Unary.NEG_I.INSTANCE) {
		if (isUndef(op)) {
		    val.setUndef(key);
		} else if (isConst(op)) {
		    val.setConst(key, -getConst(op));
		} else {
		    val.setNAC(key);
		}
	    } else {
		val.setNAC(key);
	    }
	}

	public void visitALoad(Quad q) {
	    String key = Operator.ALoad.getDest(q).getRegister().toString();
	    val.setNAC(key);
	}

	public void visitALength(Quad q) {
	    String key = Operator.ALength.getDest(q).getRegister().toString();
	    val.setNAC(key);
	}

	public void visitGetstatic(Quad q) {
	    String key = Operator.Getstatic.getDest(q).getRegister().toString();
	    val.setNAC(key);
	}

	public void visitGetfield(Quad q) {
	    String key = Operator.Getfield.getDest(q).getRegister().toString();
	    val.setNAC(key);
	}

	public void visitInstanceOf(Quad q) {
	    String key = Operator.InstanceOf.getDest(q).getRegister().toString();
	    val.setNAC(key);
	}

	public void visitNew(Quad q) {
	    String key = Operator.New.getDest(q).getRegister().toString();
	    val.setNAC(key);
	}

	public void visitNewArray(Quad q) {
	    String key = Operator.NewArray.getDest(q).getRegister().toString();
	    val.setNAC(key);
	}

	public void visitInvoke(Quad q) {
	    RegisterOperand op = Operator.Invoke.getDest(q);
	    if (op != null) {
		String key = op.getRegister().toString();
		val.setNAC(key);
	    }
	}

	public void visitJsr(Quad q) {
	    String key = Operator.Jsr.getDest(q).getRegister().toString();
	    val.setNAC(key);
	}

	public void visitCheckCast(Quad q) {
	    String key = Operator.CheckCast.getDest(q).getRegister().toString();
	    val.setNAC(key);
	}

	private boolean isUndef (Operand op) {
	    return (op instanceof RegisterOperand && 
		 val.get(((RegisterOperand)op).getRegister().toString()).isUndef());
	}

	private boolean isConst (Operand op) {
	    return (op instanceof IConstOperand) || 
		(op instanceof RegisterOperand && 
		 val.get(((RegisterOperand)op).getRegister().toString()).isConst());
	}

	private boolean isNAC (Operand op) {
	    return (op instanceof RegisterOperand && 
		 val.get(((RegisterOperand)op).getRegister().toString()).isNAC());
	}

	private int getConst (Operand op) {
	    if (op instanceof IConstOperand) {
		return ((IConstOperand)op).getValue();
	    }
	    if (op instanceof RegisterOperand) {
		SingleCP o = val.get(((RegisterOperand)op).getRegister().toString());
		if (o.state == 1)
		    return o.getConst();
	    }
	    throw new IllegalArgumentException("Tried to getConst a non-Const!");
	}
    }
}
