/*
 * Decompiled with CFR 0.152.
 */
package Util.IO;

import UTF.Utf8;
import Util.IO.ExtendedDataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianOutputStream
implements ExtendedDataOutput {
    private OutputStream out;

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void writeByte(int n) throws IOException {
        this.out.write(n);
    }

    public void writeUByte(int n) throws IOException {
        this.out.write(n);
    }

    public void writeBytes(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            this.out.write(string.charAt(n));
            ++n;
        }
    }

    public void writeChars(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            this.writeChar(string.charAt(n));
            ++n;
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.out.write(bl ? 1 : 0);
    }

    public void writeUTF(String string) throws IOException {
        this.writeShort(string.length());
        this.out.write(Utf8.toUtf8(string));
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToRawIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(d));
    }

    public void writeShort(int n) throws IOException {
        LittleEndianOutputStream.write_s16(this.out, (short)n);
    }

    public void writeUShort(int n) throws IOException {
        LittleEndianOutputStream.write_u16(this.out, (char)n);
    }

    public void writeChar(int n) throws IOException {
        LittleEndianOutputStream.write_u16(this.out, (char)n);
    }

    public void writeInt(int n) throws IOException {
        LittleEndianOutputStream.write_s32(this.out, n);
    }

    public void writeUInt(int n) throws IOException {
        LittleEndianOutputStream.write_u32(this.out, n);
    }

    public void writeLong(long l) throws IOException {
        LittleEndianOutputStream.write_s64(this.out, l);
    }

    public void writeULong(long l) throws IOException {
        LittleEndianOutputStream.write_u64(this.out, l);
    }

    private static final void write_s8(OutputStream outputStream, byte by) throws IOException {
        outputStream.write(by);
    }

    private static final void write_s16(OutputStream outputStream, short s) throws IOException {
        outputStream.write(s);
        outputStream.write(s >> 8);
    }

    private static final void write_u16(OutputStream outputStream, char c) throws IOException {
        outputStream.write(c);
        outputStream.write(c >> 8);
    }

    private static final void write_s32(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n);
        outputStream.write(n >> 8);
        outputStream.write(n >> 16);
        outputStream.write(n >> 24);
    }

    private static final void write_u32(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n);
        outputStream.write(n >> 8);
        outputStream.write(n >> 16);
        outputStream.write(n >> 24);
    }

    private static final void write_s64(OutputStream outputStream, long l) throws IOException {
        int n = (int)l;
        int n2 = (int)(l >> 32);
        outputStream.write(n);
        outputStream.write(n >> 8);
        outputStream.write(n >> 16);
        outputStream.write(n >> 24);
        outputStream.write(n2);
        outputStream.write(n2 >> 8);
        outputStream.write(n2 >> 16);
        outputStream.write(n2 >> 24);
    }

    private static final void write_u64(OutputStream outputStream, long l) throws IOException {
        int n = (int)l;
        int n2 = (int)(l >> 32);
        outputStream.write(n);
        outputStream.write(n >> 8);
        outputStream.write(n >> 16);
        outputStream.write(n >> 24);
        outputStream.write(n2);
        outputStream.write(n2 >> 8);
        outputStream.write(n2 >> 16);
        outputStream.write(n2 >> 24);
    }

    public LittleEndianOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }
}

