/*
 * Decompiled with CFR 0.152.
 */
package Util.Graphs;

import Util.Assert;
import Util.Graphs.Graph;
import Util.Graphs.Navigator;
import Util.Graphs.SCComponent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SCCTopSortedGraph
implements Graph,
Serializable {
    private static Set reached_sccs;
    private static SCComponent first_scc;
    private static SCComponent last_scc;
    private SCComponent first;
    private SCComponent last;

    public final SCComponent getFirst() {
        return this.first;
    }

    public final SCComponent getLast() {
        return this.last;
    }

    public static SCCTopSortedGraph topSort(SCComponent sCComponent) {
        if (sCComponent == null) {
            return new SCCTopSortedGraph(null, null);
        }
        return SCCTopSortedGraph.topSort(Collections.singleton(sCComponent));
    }

    public static SCCTopSortedGraph topSort(Set set) {
        Serializable serializable;
        if (set.isEmpty()) {
            return new SCCTopSortedGraph(null, null);
        }
        reached_sccs = new HashSet();
        first_scc = last_scc = new SCComponent();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            serializable = (SCComponent)iterator.next();
            Assert._assert(reached_sccs.contains(serializable) ^ true, "The roots argument contains no-root sccs.");
            SCCTopSortedGraph.DFS_topsort(serializable);
        }
        last_scc = SCCTopSortedGraph.last_scc.prevTopSort;
        SCCTopSortedGraph.last_scc.nextTopSort = null;
        serializable = new SCCTopSortedGraph(first_scc, last_scc);
        reached_sccs = null;
        first_scc = null;
        last_scc = null;
        return serializable;
    }

    private static final void DFS_topsort(SCComponent sCComponent) {
        if (reached_sccs.contains(sCComponent)) {
            return;
        }
        reached_sccs.add(sCComponent);
        int n = sCComponent.nextLength();
        int n2 = 0;
        while (n2 < n) {
            SCCTopSortedGraph.DFS_topsort(sCComponent.next(n2));
            ++n2;
        }
        sCComponent.nextTopSort = first_scc;
        SCCTopSortedGraph.first_scc.prevTopSort = sCComponent;
        first_scc = sCComponent;
    }

    public Collection getRoots() {
        return Collections.singleton(this.first);
    }

    public Navigator getNavigator() {
        return SCComponent.SCC_NAVIGATOR;
    }

    public List list() {
        return this.first.listTopSort();
    }

    private SCCTopSortedGraph(SCComponent sCComponent, SCComponent sCComponent2) {
        this.first = sCComponent;
        this.last = sCComponent2;
    }
}

