/*
 * Decompiled with CFR 0.152.
 */
package Util.Collections;

import Util.Collections.Factories;
import Util.Collections.ListFactory;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LinearSet
extends AbstractSet
implements Cloneable,
Serializable {
    private List list;
    private ListFactory lf;

    public Iterator iterator() {
        return this.list.iterator();
    }

    public int size() {
        return this.list.size();
    }

    public boolean add(Object object) {
        if (this.list.contains(object)) {
            return false;
        }
        this.list.add(object);
        return true;
    }

    public boolean addAll(Collection collection) {
        HashSet hashSet = new HashSet(this.size() + collection.size());
        hashSet.addAll(this);
        boolean bl = hashSet.addAll(collection);
        this.list = this.lf.makeList(hashSet);
        return bl;
    }

    public boolean remove(Object object) {
        int n = this.list.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.list.remove(n);
        return true;
    }

    public void clear() {
        this.list.clear();
    }

    public Object get(Object object) {
        int n = this.list.indexOf(object);
        if (n == -1) {
            return null;
        }
        return this.list.get(n);
    }

    public Object clone() {
        try {
            LinearSet linearSet = (LinearSet)super.clone();
            linearSet.list = this.lf.makeList(this.list);
            return linearSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public LinearSet() {
        this(Factories.arrayListFactory);
    }

    public LinearSet(int n) {
        this(Factories.arrayListFactory, n);
    }

    public LinearSet(Set set) {
        this(Factories.arrayListFactory, set);
    }

    public LinearSet(ListFactory listFactory) {
        this.list = listFactory.makeList();
        this.lf = listFactory;
    }

    public LinearSet(ListFactory listFactory, int n) {
        this.list = listFactory.makeList(n);
        this.lf = listFactory;
    }

    public LinearSet(ListFactory listFactory, Set set) {
        this.list = listFactory.makeList(set);
        this.lf = listFactory;
    }
}

