/*
 * Decompiled with CFR 0.152.
 */
package Util;

import Util.Assert;
import Util.Collections.UnmodifiableIterator;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class BitString
implements Cloneable,
Serializable {
    private static final int BITS_PER_UNIT = 5;
    private static final int MASK = 31;
    private static final byte[] bytemsb;
    private int[] bits;

    private static final int subscript(int n) {
        return n >> 5;
    }

    public final int firstSet() {
        return this.firstSet(-1);
    }

    public final int firstSet(int n) {
        int n2 = 0;
        if (n >= -1) {
            n2 = n + 1;
        }
        n = n2;
        int n3 = -1 << (n & 0x1F);
        int n4 = BitString.subscript(n);
        while (n4 < this.bits.length) {
            int n5 = this.bits[n4] & n3;
            if (n5 != 0) {
                return (n4 << 5) + (BitString.bsf(n5) - 1);
            }
            ++n4;
            n3 = -1;
        }
        return -1;
    }

    public static final byte popcount(int n) {
        int n2 = n;
        n2 -= n2 >> 1 & 0x55555555;
        int n3 = n2 >> 2 & 0x33333333;
        n2 = (n2 & 0x33333333) + n3;
        n2 = n2 + (n2 >> 4) & 0xF0F0F0F;
        n2 += n2 >> 8;
        n2 += n2 >> 16;
        return (byte)n2;
    }

    public static final byte popcount(long l) {
        long l2 = l;
        l2 -= l2 >> 1 & 0x5555555555555555L;
        long l3 = l2 >> 2 & 0x3333333333333333L;
        l2 = (l2 & 0x3333333333333333L) + l3;
        l2 = l2 + (l2 >> 4) & 0xF0F0F0F0F0F0F0FL;
        l2 += l2 >> 8;
        l2 += l2 >> 16;
        l2 += l2 >> 32;
        return (byte)l2;
    }

    public static final int bsf(int n) {
        int n2 = ~(n | -n);
        return BitString.popcount(n2);
    }

    public static final int bsr(int n) {
        if ((n & 0xFFFF0000) != 0) {
            if ((n & 0xFF000000) != 0) {
                return 24 + bytemsb[n >> 24 & 0xFF];
            }
            return 16 + bytemsb[n >> 16];
        }
        if ((n & 0xFF00) != 0) {
            return 8 + bytemsb[n >> 8];
        }
        return bytemsb[n];
    }

    public final int lastSet(int n) {
        if (--n < 0) {
            return -1;
        }
        int n2 = this.bits.length - 1;
        int n3 = -1;
        if (BitString.subscript(n) < this.bits.length) {
            n2 = BitString.subscript(n);
            n3 = -1 >>> 31 - (n & n3);
        }
        int n4 = n2;
        while (n4 >= 0) {
            int n5 = this.bits[n4] & n3;
            if (n5 != 0) {
                return (n4 << 5) + (BitString.bsr(n5) - 1);
            }
            --n4;
            n3 = -1;
        }
        return -1;
    }

    public final int lastSet() {
        return this.lastSet(this.size());
    }

    public final void setAll() {
        int n = this.bits.length;
        while (n-- > 0) {
            this.bits[n] = -1;
        }
    }

    public final void setUpTo(int n) {
        int n2;
        int n3 = n2 = BitString.subscript(n);
        this.bits[n3] = this.bits[n3] | (1 << (n + 1 & 0x1F)) - 1;
        while (n2-- > 0) {
            this.bits[n2] = -1;
        }
    }

    public final void set(int n) {
        int n2 = BitString.subscript(n);
        this.bits[n2] = this.bits[n2] | 1 << (n & 0x1F);
    }

    public final void clearAll() {
        int n = this.bits.length;
        while (n-- > 0) {
            this.bits[n] = 0;
        }
    }

    public final void clearUpTo(int n) {
        int n2;
        int n3 = n2 = BitString.subscript(n);
        this.bits[n3] = this.bits[n3] & ~((1 << (n + 1 & 0x1F)) - 1);
        while (n2-- > 0) {
            this.bits[n2] = 0;
        }
    }

    public final void clear(int n) {
        int n2 = BitString.subscript(n);
        this.bits[n2] = this.bits[n2] & ~(1 << (n & 0x1F));
    }

    public final boolean get(int n) {
        int n2 = BitString.subscript(n);
        boolean bl = false;
        if ((this.bits[n2] & 1 << (n & 0x1F)) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean and(BitString bitString) {
        if (this == bitString) {
            return false;
        }
        int n = this.bits.length;
        boolean bl = false;
        int n2 = n;
        while (n2-- > 0) {
            int n3 = this.bits[n2];
            int n4 = n2;
            this.bits[n4] = this.bits[n4] & bitString.bits[n2];
            boolean bl2 = false;
            if (n3 != this.bits[n2]) {
                bl2 = true;
            }
            bl |= bl2;
        }
        return bl;
    }

    public final boolean or(BitString bitString) {
        if (this == bitString) {
            return false;
        }
        int n = bitString.bits.length;
        boolean bl = false;
        int n2 = n;
        while (n2-- > 0) {
            int n3 = this.bits[n2];
            int n4 = n2;
            this.bits[n4] = this.bits[n4] | bitString.bits[n2];
            boolean bl2 = false;
            if (n3 != this.bits[n2]) {
                bl2 = true;
            }
            bl |= bl2;
        }
        return bl;
    }

    public final boolean or_upTo(BitString bitString, int n) {
        if (this == bitString) {
            return false;
        }
        int n2 = BitString.subscript(n);
        int n3 = this.bits[n2];
        int n4 = n2;
        this.bits[n4] = this.bits[n4] | bitString.bits[n2] & (1 << (n + 1 & 0x1F)) - 1;
        boolean bl = false;
        if (this.bits[n2] != n3) {
            bl = true;
        }
        boolean bl2 = bl;
        while (n2-- > 0) {
            n3 = this.bits[n2];
            int n5 = n2;
            this.bits[n5] = this.bits[n5] | bitString.bits[n2];
            boolean bl3 = false;
            if (this.bits[n2] != n3) {
                bl3 = true;
            }
            bl2 |= bl3;
        }
        return bl2;
    }

    public final boolean xor(BitString bitString) {
        int n = bitString.bits.length;
        boolean bl = false;
        int n2 = n;
        while (n2-- > 0) {
            int n3 = this.bits[n2];
            int n4 = n2;
            this.bits[n4] = this.bits[n4] ^ bitString.bits[n2];
            boolean bl2 = false;
            if (n3 != this.bits[n2]) {
                bl2 = true;
            }
            bl |= bl2;
        }
        return bl;
    }

    public final boolean minus(BitString bitString) {
        int n = this.bits.length;
        boolean bl = false;
        int n2 = n;
        while (n2-- > 0) {
            int n3 = this.bits[n2];
            int n4 = n2;
            this.bits[n4] = this.bits[n4] & ~bitString.bits[n2];
            boolean bl2 = false;
            if (n3 != this.bits[n2]) {
                bl2 = true;
            }
            bl |= bl2;
        }
        return bl;
    }

    public final boolean intersectionEmpty(BitString bitString) {
        int n;
        int n2 = n = this.bits.length;
        while (n2-- > 0) {
            if ((this.bits[n2] & bitString.bits[n2]) == 0) continue;
            return false;
        }
        return true;
    }

    public final boolean contains(BitString bitString) {
        int n;
        int n2 = n = this.bits.length;
        while (n2-- > 0) {
            if ((this.bits[n2] & bitString.bits[n2]) == bitString.bits[n2]) continue;
            return false;
        }
        return true;
    }

    private static final void shld(int[] nArray, int n, int n2, int n3) {
        boolean bl = false;
        if (n3 >= 0 && n3 < 5) {
            bl = true;
        }
        Assert._assert(bl);
        nArray[n] = nArray[n] << n3 | nArray[n2] << 5 - n3 >> 5 - n3;
    }

    public final void shl(int n) {
        int n2;
        int n3 = n >> 5;
        int n4 = n & 0x1F;
        int n5 = this.bits.length;
        if (n < 0) {
            this.shr(-n);
            return;
        }
        if (n3 > 0) {
            System.arraycopy(this.bits, 0, this.bits, n3, n5 - n3);
            n2 = 0;
            while (n2 < n3) {
                this.bits[n2] = 0;
                ++n2;
            }
        }
        if (n4 > 0) {
            n2 = n5 - 1;
            while (n2 > n3) {
                BitString.shld(this.bits, n2, n2 - 1, n4);
                --n2;
            }
            int n6 = n2;
            this.bits[n6] = this.bits[n6] << n4;
        }
    }

    private static final void shrd(int[] nArray, int n, int n2, int n3) {
        boolean bl = false;
        if (n3 >= 0 && n3 < 5) {
            bl = true;
        }
        Assert._assert(bl);
        nArray[n] = nArray[n] >>> n3 | nArray[n2] >>> 5 - n3 << 5 - n3;
    }

    public final void shr(int n) {
        int n2;
        int n3 = n >> 5;
        int n4 = n & 0x1F;
        int n5 = this.bits.length;
        if (n3 > 0) {
            System.arraycopy(this.bits, n3, this.bits, 0, n5 - n3);
            n2 = n5 - n3;
            while (n2 < n5) {
                this.bits[n2] = 0;
                ++n2;
            }
        }
        if (n4 > 0) {
            n2 = 0;
            while (n2 < n5 - n3 - 1) {
                BitString.shrd(this.bits, n2, n2 + 1, n4);
                ++n2;
            }
            int n6 = n2;
            this.bits[n6] = this.bits[n6] >>> n4;
        }
    }

    public final void copyBits(BitString bitString) {
        System.arraycopy(bitString.bits, 0, this.bits, 0, this.bits.length);
    }

    public final int hashCode() {
        int n = 1234;
        int n2 = this.bits.length;
        while (--n2 >= 0) {
            n ^= this.bits[n2] * (n2 + 1);
        }
        return n;
    }

    public final int length() {
        return this.lastSet() + 1;
    }

    public final int size() {
        return this.bits.length << 5;
    }

    public final boolean equals(Object object) {
        BitString bitString;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        try {
            bitString = (BitString)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.length() != bitString.length()) {
            return false;
        }
        int n = this.bits.length - 1;
        while (n >= 0 && this.bits[n] == 0) {
            --n;
        }
        int n2 = n;
        while (n2 >= 0) {
            if (this.bits[n2] != bitString.bits[n2]) {
                return false;
            }
            --n2;
        }
        return true;
    }

    public final boolean isZero() {
        int n;
        int n2 = n = this.bits.length;
        while (n2-- > 0) {
            if (this.bits[n2] == 0) continue;
            return false;
        }
        return true;
    }

    public final int numberOfOnes() {
        int n = this.bits.length;
        int n2 = 0;
        int n3 = n;
        while (n3-- > 0) {
            n2 += BitString.popcount(this.bits[n3]);
        }
        return n2;
    }

    public final int numberOfOnes(int n) {
        int n2 = BitString.subscript(n);
        int n3 = 0;
        int n4 = n2;
        while (n4-- > 0) {
            n3 += BitString.popcount(this.bits[n4]);
        }
        return n3 += BitString.popcount(this.bits[n2] & (1 << (n + 1 & 0x1F)) - 1);
    }

    public final Object clone() {
        BitString bitString = null;
        try {
            bitString = (BitString)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        bitString.bits = new int[this.bits.length];
        System.arraycopy(this.bits, 0, bitString.bits, 0, bitString.bits.length);
        return bitString;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        stringBuffer.append('{');
        ForwardBitStringIterator forwardBitStringIterator = this.iterator();
        while (forwardBitStringIterator.hasNext()) {
            int n = forwardBitStringIterator.nextIndex();
            if (bl) {
                stringBuffer.append(", ");
            } else {
                bl = true;
            }
            stringBuffer.append(n);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private static final int[] bit_reverse(int n, int[] nArray) {
        int n2 = 1;
        nArray[0] = 0;
        while (n2 < n) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                nArray[n4] = n3 = nArray[n4] * 2;
                nArray[n4 + n2] = n3 + 1;
                ++n4;
            }
            n2 *= 2;
        }
        return nArray;
    }

    public final ForwardBitStringIterator iterator() {
        return new ForwardBitStringIterator();
    }

    public final BackwardBitStringIterator backwardsIterator() {
        return new BackwardBitStringIterator();
    }

    public final BackwardBitStringIterator backwardsIterator(int n) {
        return new BackwardBitStringIterator(n);
    }

    public BitString(int n) {
        this.bits = new int[BitString.subscript(n + 31)];
    }

    static {
        byte[] byArray = new byte[256];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 2;
        byArray[4] = 3;
        byArray[5] = 3;
        byArray[6] = 3;
        byArray[7] = 3;
        byArray[8] = 4;
        byArray[9] = 4;
        byArray[10] = 4;
        byArray[11] = 4;
        byArray[12] = 4;
        byArray[13] = 4;
        byArray[14] = 4;
        byArray[15] = 4;
        byArray[16] = 5;
        byArray[17] = 5;
        byArray[18] = 5;
        byArray[19] = 5;
        byArray[20] = 5;
        byArray[21] = 5;
        byArray[22] = 5;
        byArray[23] = 5;
        byArray[24] = 5;
        byArray[25] = 5;
        byArray[26] = 5;
        byArray[27] = 5;
        byArray[28] = 5;
        byArray[29] = 5;
        byArray[30] = 5;
        byArray[31] = 5;
        byArray[32] = 6;
        byArray[33] = 6;
        byArray[34] = 6;
        byArray[35] = 6;
        byArray[36] = 6;
        byArray[37] = 6;
        byArray[38] = 6;
        byArray[39] = 6;
        byArray[40] = 6;
        byArray[41] = 6;
        byArray[42] = 6;
        byArray[43] = 6;
        byArray[44] = 6;
        byArray[45] = 6;
        byArray[46] = 6;
        byArray[47] = 6;
        byArray[48] = 6;
        byArray[49] = 6;
        byArray[50] = 6;
        byArray[51] = 6;
        byArray[52] = 6;
        byArray[53] = 6;
        byArray[54] = 6;
        byArray[55] = 6;
        byArray[56] = 6;
        byArray[57] = 6;
        byArray[58] = 6;
        byArray[59] = 6;
        byArray[60] = 6;
        byArray[61] = 6;
        byArray[62] = 6;
        byArray[63] = 6;
        byArray[64] = 7;
        byArray[65] = 7;
        byArray[66] = 7;
        byArray[67] = 7;
        byArray[68] = 7;
        byArray[69] = 7;
        byArray[70] = 7;
        byArray[71] = 7;
        byArray[72] = 7;
        byArray[73] = 7;
        byArray[74] = 7;
        byArray[75] = 7;
        byArray[76] = 7;
        byArray[77] = 7;
        byArray[78] = 7;
        byArray[79] = 7;
        byArray[80] = 7;
        byArray[81] = 7;
        byArray[82] = 7;
        byArray[83] = 7;
        byArray[84] = 7;
        byArray[85] = 7;
        byArray[86] = 7;
        byArray[87] = 7;
        byArray[88] = 7;
        byArray[89] = 7;
        byArray[90] = 7;
        byArray[91] = 7;
        byArray[92] = 7;
        byArray[93] = 7;
        byArray[94] = 7;
        byArray[95] = 7;
        byArray[96] = 7;
        byArray[97] = 7;
        byArray[98] = 7;
        byArray[99] = 7;
        byArray[100] = 7;
        byArray[101] = 7;
        byArray[102] = 7;
        byArray[103] = 7;
        byArray[104] = 7;
        byArray[105] = 7;
        byArray[106] = 7;
        byArray[107] = 7;
        byArray[108] = 7;
        byArray[109] = 7;
        byArray[110] = 7;
        byArray[111] = 7;
        byArray[112] = 7;
        byArray[113] = 7;
        byArray[114] = 7;
        byArray[115] = 7;
        byArray[116] = 7;
        byArray[117] = 7;
        byArray[118] = 7;
        byArray[119] = 7;
        byArray[120] = 7;
        byArray[121] = 7;
        byArray[122] = 7;
        byArray[123] = 7;
        byArray[124] = 7;
        byArray[125] = 7;
        byArray[126] = 7;
        byArray[127] = 7;
        byArray[128] = 8;
        byArray[129] = 8;
        byArray[130] = 8;
        byArray[131] = 8;
        byArray[132] = 8;
        byArray[133] = 8;
        byArray[134] = 8;
        byArray[135] = 8;
        byArray[136] = 8;
        byArray[137] = 8;
        byArray[138] = 8;
        byArray[139] = 8;
        byArray[140] = 8;
        byArray[141] = 8;
        byArray[142] = 8;
        byArray[143] = 8;
        byArray[144] = 8;
        byArray[145] = 8;
        byArray[146] = 8;
        byArray[147] = 8;
        byArray[148] = 8;
        byArray[149] = 8;
        byArray[150] = 8;
        byArray[151] = 8;
        byArray[152] = 8;
        byArray[153] = 8;
        byArray[154] = 8;
        byArray[155] = 8;
        byArray[156] = 8;
        byArray[157] = 8;
        byArray[158] = 8;
        byArray[159] = 8;
        byArray[160] = 8;
        byArray[161] = 8;
        byArray[162] = 8;
        byArray[163] = 8;
        byArray[164] = 8;
        byArray[165] = 8;
        byArray[166] = 8;
        byArray[167] = 8;
        byArray[168] = 8;
        byArray[169] = 8;
        byArray[170] = 8;
        byArray[171] = 8;
        byArray[172] = 8;
        byArray[173] = 8;
        byArray[174] = 8;
        byArray[175] = 8;
        byArray[176] = 8;
        byArray[177] = 8;
        byArray[178] = 8;
        byArray[179] = 8;
        byArray[180] = 8;
        byArray[181] = 8;
        byArray[182] = 8;
        byArray[183] = 8;
        byArray[184] = 8;
        byArray[185] = 8;
        byArray[186] = 8;
        byArray[187] = 8;
        byArray[188] = 8;
        byArray[189] = 8;
        byArray[190] = 8;
        byArray[191] = 8;
        byArray[192] = 8;
        byArray[193] = 8;
        byArray[194] = 8;
        byArray[195] = 8;
        byArray[196] = 8;
        byArray[197] = 8;
        byArray[198] = 8;
        byArray[199] = 8;
        byArray[200] = 8;
        byArray[201] = 8;
        byArray[202] = 8;
        byArray[203] = 8;
        byArray[204] = 8;
        byArray[205] = 8;
        byArray[206] = 8;
        byArray[207] = 8;
        byArray[208] = 8;
        byArray[209] = 8;
        byArray[210] = 8;
        byArray[211] = 8;
        byArray[212] = 8;
        byArray[213] = 8;
        byArray[214] = 8;
        byArray[215] = 8;
        byArray[216] = 8;
        byArray[217] = 8;
        byArray[218] = 8;
        byArray[219] = 8;
        byArray[220] = 8;
        byArray[221] = 8;
        byArray[222] = 8;
        byArray[223] = 8;
        byArray[224] = 8;
        byArray[225] = 8;
        byArray[226] = 8;
        byArray[227] = 8;
        byArray[228] = 8;
        byArray[229] = 8;
        byArray[230] = 8;
        byArray[231] = 8;
        byArray[232] = 8;
        byArray[233] = 8;
        byArray[234] = 8;
        byArray[235] = 8;
        byArray[236] = 8;
        byArray[237] = 8;
        byArray[238] = 8;
        byArray[239] = 8;
        byArray[240] = 8;
        byArray[241] = 8;
        byArray[242] = 8;
        byArray[243] = 8;
        byArray[244] = 8;
        byArray[245] = 8;
        byArray[246] = 8;
        byArray[247] = 8;
        byArray[248] = 8;
        byArray[249] = 8;
        byArray[250] = 8;
        byArray[251] = 8;
        byArray[252] = 8;
        byArray[253] = 8;
        byArray[254] = 8;
        byArray[255] = 8;
        bytemsb = byArray;
    }

    public static abstract class BitStringIterator
    extends UnmodifiableIterator {
        public abstract int nextIndex();

        public final Object next() {
            return new Integer(this.nextIndex());
        }
    }

    public class ForwardBitStringIterator
    extends BitStringIterator {
        private int j = 0;
        private int k = 0;
        private int t = BitString.access$0(BitString.this)[0];

        public boolean hasNext() {
            while (this.t == 0) {
                if (this.j == BitString.this.bits.length - 1) {
                    return false;
                }
                this.t = BitString.this.bits[++this.j];
                this.k += 32;
            }
            return true;
        }

        public int nextIndex() {
            while (this.t == 0) {
                if (this.j == BitString.this.bits.length - 1) {
                    throw new NoSuchElementException();
                }
                this.t = BitString.this.bits[++this.j];
                this.k += 32;
            }
            int n = this.t ^ -this.t;
            int n2 = 31 - BitString.popcount(n);
            this.t &= n;
            return this.k + n2;
        }

        ForwardBitStringIterator() {
        }
    }

    public class BackwardBitStringIterator
    extends BitStringIterator {
        private int j;
        private int k;
        private int t;

        public boolean hasNext() {
            while (this.t == 0) {
                if (this.j == 0) {
                    return false;
                }
                this.t = BitString.this.bits[--this.j];
                this.k -= 32;
            }
            return true;
        }

        public int nextIndex() {
            while (this.t == 0) {
                if (this.j == 0) {
                    throw new NoSuchElementException();
                }
                this.t = BitString.this.bits[--this.j];
                this.k -= 32;
            }
            int n = BitString.bsr(this.t) - 1;
            this.t &= ~(1 << n);
            return this.k + n;
        }

        BackwardBitStringIterator(int n) {
            this.j = BitString.subscript(n);
            this.t = BitString.this.bits[this.j];
            this.t &= (1 << (n + 1 & 0x1F)) - 1;
            this.k = this.j << 5;
        }

        BackwardBitStringIterator() {
            this.j = BitString.this.bits.length - 1;
            this.t = BitString.this.bits[this.j];
            this.k = this.j << 5;
        }
    }
}

