/*
 * Decompiled with CFR 0.152.
 */
package Scheduler;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_CompiledCode;
import Clazz.jq_DontAlign;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_NameAndDesc;
import Clazz.jq_Reference;
import Clazz.jq_StaticMethod;
import Main.jq;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Memory.StackAddress;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Scheduler.jq_NativeThread;
import Scheduler.jq_RegisterState;
import UTF.Utf8;
import Util.Assert;
import Util.AtomicCounter;

public class jq_Thread
implements jq_DontAlign {
    public static final int INITIAL_STACK_SIZE = 65536;
    public static AtomicCounter thread_id_factory = new AtomicCounter(1);
    public static final jq_Class _class = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LScheduler/jq_Thread;");
    public static final jq_StaticMethod _destroyCurrentThread = _class.getOrCreateStaticMethod("destroyCurrentThread", "()V");
    public static final jq_InstanceField _thread_switch_enabled = _class.getOrCreateInstanceField("thread_switch_enabled", "I");
    public static final jq_InstanceField _isInterrupted = _class.getOrCreateInstanceField("isInterrupted", "I");
    private final jq_RegisterState registers;
    private volatile int thread_switch_enabled;
    private jq_NativeThread native_thread;
    private Throwable exception_object;
    private final Thread thread_object;
    jq_Thread next;
    private jq_CompiledCode entry_point;
    private boolean isDaemon;
    private boolean hasStarted;
    private boolean isDead;
    boolean wasPreempted;
    private int priority;
    private volatile int isInterrupted;
    private final int thread_id;
    long sleepUntil;

    public Thread getJavaLangThreadObject() {
        return this.thread_object;
    }

    public String toString() {
        return this.thread_object + " (sus: " + this.thread_switch_enabled + ')';
    }

    public jq_RegisterState getRegisterState() {
        return this.registers;
    }

    public jq_NativeThread getNativeThread() {
        return this.native_thread;
    }

    void setNativeThread(jq_NativeThread jq_NativeThread2) {
        this.native_thread = jq_NativeThread2;
    }

    public boolean isThreadSwitchEnabled() {
        boolean bl = false;
        if (this.thread_switch_enabled == 0) {
            bl = true;
        }
        return bl;
    }

    public void disableThreadSwitch() {
        if (!jq.RunningNative) {
            ++this.thread_switch_enabled;
        } else {
            ((HeapAddress)HeapAddress.addressOf(this).offset(_thread_switch_enabled.getOffset())).atomicAdd(1);
        }
    }

    public void enableThreadSwitch() {
        if (!jq.RunningNative) {
            --this.thread_switch_enabled;
        } else {
            ((HeapAddress)HeapAddress.addressOf(this).offset(_thread_switch_enabled.getOffset())).atomicSub(1);
        }
    }

    public void init() {
        Thread thread = this.thread_object;
        jq_Reference jq_Reference2 = jq_Reference.getTypeOf(thread);
        jq_InstanceMethod jq_InstanceMethod2 = jq_Reference2.getVirtualMethod(new jq_NameAndDesc(Utf8.get("run"), Utf8.get("()V")));
        this.entry_point = jq_InstanceMethod2.getDefaultCompiledVersion();
        this.registers.Esp = SystemInterface.allocate_stack(65536);
        this.registers.Eip = this.entry_point.getEntrypoint();
        this.registers.Esp = (StackAddress)this.registers.getEsp().offset(-CodeAddress.size());
        this.registers.Esp = (StackAddress)this.registers.getEsp().offset(-HeapAddress.size());
        this.registers.getEsp().poke(HeapAddress.addressOf(thread));
        this.registers.Esp = (StackAddress)this.registers.getEsp().offset(-CodeAddress.size());
        this.registers.getEsp().poke(_destroyCurrentThread.getDefaultCompiledVersion().getEntrypoint());
    }

    public void start() {
        if (this.entry_point == null) {
            this.init();
        }
        if (this.hasStarted) {
            throw new IllegalThreadStateException();
        }
        this.isDead = false;
        this.hasStarted = true;
        jq_NativeThread.startJavaThread(this);
    }

    public void sleep(long l) throws InterruptedException {
        this.sleepUntil = System.currentTimeMillis() + l;
        do {
            if (this.isInterrupted(true)) {
                throw new InterruptedException();
            }
            this.yield();
        } while (System.currentTimeMillis() < this.sleepUntil);
    }

    public void yield() {
        if (this != Unsafe.getThreadBlock()) {
            SystemInterface.debugwriteln("Yield called on " + this + " from thread " + Unsafe.getThreadBlock());
            Assert.UNREACHABLE();
        }
        this.disableThreadSwitch();
        StackAddress stackAddress = StackAddress.getStackPointer();
        this.registers.Esp = (StackAddress)stackAddress.offset(-CodeAddress.size() - HeapAddress.size());
        this.registers.Ebp = StackAddress.getBasePointer();
        this.registers.ControlWord = 639;
        this.registers.StatusWord = 16384;
        this.registers.TagWord = (char)-1;
        this.getNativeThread().yieldCurrentThread();
    }

    public void yieldTo(jq_Thread jq_Thread2) {
        boolean bl = false;
        if (this == Unsafe.getThreadBlock()) {
            bl = true;
        }
        Assert._assert(bl);
        this.disableThreadSwitch();
        if (jq_Thread2.getNativeThread() != this.getNativeThread()) {
            return;
        }
        StackAddress stackAddress = StackAddress.getStackPointer();
        this.registers.Esp = (StackAddress)stackAddress.offset(-CodeAddress.size() - HeapAddress.size() - HeapAddress.size());
        this.registers.Ebp = StackAddress.getBasePointer();
        this.registers.ControlWord = 639;
        this.registers.StatusWord = 16384;
        this.registers.TagWord = (char)-1;
        this.getNativeThread().yieldCurrentThreadTo(jq_Thread2);
    }

    public void setPriority(int n) {
        boolean bl = false;
        if (n >= 0) {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl2 = false;
        if (n <= 9) {
            bl2 = true;
        }
        Assert._assert(bl2);
        this.priority = n;
    }

    public int getPriority() {
        return this.priority;
    }

    public void stop(Object object) {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public void interrupt() {
        this.isInterrupted = 1;
    }

    public boolean isInterrupted(boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        if (this.isInterrupted != 0) {
            bl3 = bl2 = true;
        }
        if (bl && bl2) {
            this.isInterrupted = 0;
        }
        return bl2;
    }

    public boolean isAlive() {
        return this.isDead ^ true;
    }

    public boolean isDaemon() {
        return this.isDaemon;
    }

    public void setDaemon(boolean bl) {
        this.isDaemon = bl;
    }

    public int countStackFrames() {
        return 0;
    }

    public int getThreadId() {
        return this.thread_id;
    }

    public static void destroyCurrentThread() {
        jq_Thread jq_Thread2 = Unsafe.getThreadBlock();
        jq_Thread2.isDead = true;
        jq_NativeThread.endCurrentJavaThread();
        Assert.UNREACHABLE();
    }

    public jq_Thread(Thread thread) {
        this.thread_object = thread;
        this.registers = new jq_RegisterState();
        this.thread_id = thread_id_factory.increment() << 9;
        boolean bl = false;
        if (this.thread_id > 0) {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl2 = false;
        if (this.thread_id < 2147483136) {
            bl2 = true;
        }
        Assert._assert(bl2);
        this.isDead = true;
        this.priority = 5;
    }
}

