/*
 * Decompiled with CFR 0.152.
 */
package Scheduler;

import Allocator.CodeAllocator;
import Allocator.HeapAllocator;
import Allocator.RuntimeCodeAllocator;
import Allocator.SimpleAllocator;
import Assembler.x86.x86Constants;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_DontAlign;
import Clazz.jq_InstanceMethod;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Debugger.OnlineDebugger;
import GC.GCManager;
import GC.GCVisitor;
import Main.jq;
import Memory.CodeAddress;
import Memory.Heap.SegregatedListHeap;
import Memory.Heap.SizeControl;
import Memory.HeapAddress;
import Memory.StackAddress;
import Run_Time.Debug;
import Run_Time.StackCodeWalker;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Scheduler.ThreadUtils;
import Scheduler.jq_InterrupterThread;
import Scheduler.jq_RegisterState;
import Scheduler.jq_SynchThreadQueue;
import Scheduler.jq_Thread;
import Scheduler.jq_ThreadQueue;
import Util.Assert;
import Util.Strings;
import java.util.Iterator;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class jq_NativeThread
implements x86Constants,
jq_DontAlign {
    public static boolean TRACE = false;
    public static boolean CHECK = false;
    public static final boolean STATISTICS = true;
    public static final jq_NativeThread initial_native_thread = new jq_NativeThread(0);
    public static jq_NativeThread[] native_threads;
    private static volatile int num_of_java_threads;
    private static volatile int num_of_daemon_threads;
    public static final int MAX_NATIVE_THREADS = 16;
    private static boolean all_native_threads_initialized;
    private static boolean all_native_threads_started;
    public static final int NUM_OF_QUEUES = 10;
    public static boolean USE_INTERRUPTER_THREAD;
    public static float TRANSFER_THRESHOLD;
    static final float[] DISTRIBUTION;
    private static boolean has_break_occurred;
    private static jq_NativeThread break_nthread;
    private static jq_Thread break_jthread;
    private static int gcType;
    private static jq_NativeThread gc_nthread;
    private static jq_Thread gc_jthread;
    public static final jq_Class _class;
    public static final jq_InstanceMethod _nativeThreadEntry;
    public static final jq_InstanceMethod _schedulerLoop;
    public static final jq_InstanceMethod _threadSwitch;
    public static final jq_StaticMethod _ctrl_break_handler;
    public static final jq_StaticField _num_of_java_threads;
    public static final jq_StaticField _num_of_daemon_threads;
    private int thread_handle;
    private jq_Thread currentThread;
    private int pid;
    private int preempted_thread_counter;
    private final jq_ThreadQueue[] readyQueue;
    private final jq_ThreadQueue idleQueue;
    private final jq_SynchThreadQueue transferQueue;
    private CodeAllocator myCodeAllocator;
    private HeapAllocator myHeapAllocator;
    StackAddress original_esp;
    StackAddress original_ebp;
    private final int index;
    private final jq_Thread schedulerThread;
    public SizeControl[] sizes;
    public SizeControl[] GC_INDEX_ARRAY;
    public SegregatedListHeap backingSLHeap;
    int chosenAsLeastBusy;
    jq_InterrupterThread it;
    int transferredOut;
    int failedTransferOut;
    Random rng;
    int[] readyQueueLength;
    int preemptedThreadsLength;
    int readyQueueN;
    int transferredIn;

    public static void initInitialNativeThread() {
        jq_NativeThread.initial_native_thread.pid = SystemInterface.init_thread();
        Unsafe.setThreadBlock(jq_NativeThread.initial_native_thread.schedulerThread);
        jq_NativeThread.initial_native_thread.thread_handle = SystemInterface.get_current_thread_handle();
        jq_NativeThread.initial_native_thread.myHeapAllocator.init();
        jq_NativeThread.initial_native_thread.myCodeAllocator.init();
        if (TRACE) {
            SystemInterface.debugwriteln("Initial native thread initialized");
        }
    }

    public static void initNativeThreads(jq_NativeThread jq_NativeThread2, int n) {
        boolean bl = false;
        if (n <= 16) {
            bl = true;
        }
        Assert._assert(bl);
        native_threads = new jq_NativeThread[n];
        jq_NativeThread.native_threads[0] = jq_NativeThread2;
        int n2 = 1;
        while (n2 < n) {
            jq_NativeThread jq_NativeThread3 = jq_NativeThread.native_threads[n2] = new jq_NativeThread(n2);
            jq_NativeThread3.thread_handle = SystemInterface.create_thread(_nativeThreadEntry.getDefaultCompiledVersion().getEntrypoint(), HeapAddress.addressOf(jq_NativeThread3));
            jq_NativeThread3.myHeapAllocator.init();
            jq_NativeThread3.myCodeAllocator.init();
            if (TRACE) {
                SystemInterface.debugwriteln("Native thread " + n2 + " initialized");
            }
            ++n2;
        }
        all_native_threads_initialized = true;
    }

    public static void startNativeThreads() {
        int n = 1;
        while (n < native_threads.length) {
            if (TRACE) {
                SystemInterface.debugwriteln("Native thread " + n + " started");
            }
            native_threads[n].resume();
            ++n;
        }
        all_native_threads_started = true;
    }

    public static boolean allNativeThreadsInitialized() {
        return all_native_threads_initialized;
    }

    public jq_Thread getCurrentThread() {
        return this.currentThread;
    }

    public CodeAllocator getCodeAllocator() {
        return this.myCodeAllocator;
    }

    public HeapAllocator getHeapAllocator() {
        return this.myHeapAllocator;
    }

    public jq_Thread getCurrentJavaThread() {
        return this.currentThread;
    }

    public void resume() {
        SystemInterface.resume_thread(this.thread_handle);
    }

    public void suspend() {
        SystemInterface.suspend_thread(this.thread_handle);
    }

    public boolean getContext(jq_RegisterState jq_RegisterState2) {
        return SystemInterface.get_thread_context(this.pid, jq_RegisterState2);
    }

    public boolean setContext(jq_RegisterState jq_RegisterState2) {
        return SystemInterface.set_thread_context(this.pid, jq_RegisterState2);
    }

    static jq_NativeThread getLeastBusyThread() {
        int n = 0;
        int n2 = jq_NativeThread.native_threads[n].preempted_thread_counter + jq_NativeThread.native_threads[n].transferQueue.length();
        int n3 = 1;
        while (n3 < native_threads.length) {
            int n4 = jq_NativeThread.native_threads[n3].preempted_thread_counter + jq_NativeThread.native_threads[n3].transferQueue.length();
            if (n4 < n2) {
                n2 = n4;
                n = n3;
            }
            ++n3;
        }
        ++jq_NativeThread.native_threads[n].chosenAsLeastBusy;
        return native_threads[n];
    }

    public static void startJavaThread(jq_Thread jq_Thread2) {
        _num_of_java_threads.getAddress().atomicAdd(1);
        if (jq_Thread2.isDaemon()) {
            _num_of_daemon_threads.getAddress().atomicAdd(1);
        }
        jq_NativeThread jq_NativeThread2 = jq_NativeThread.getLeastBusyThread();
        Assert._assert(jq_Thread2.isThreadSwitchEnabled());
        jq_Thread2.disableThreadSwitch();
        CodeAddress codeAddress = jq_Thread2.getRegisterState().getEip();
        if (TRACE) {
            SystemInterface.debugwriteln("Java thread " + jq_Thread2 + " enqueued on native thread " + jq_NativeThread2 + " ip: " + codeAddress.stringRep() + " cc: " + CodeAllocator.getCodeContaining(codeAddress));
        }
        jq_NativeThread2.transferQueue.enqueue(jq_Thread2);
    }

    public static void endCurrentJavaThread() {
        jq_Thread jq_Thread2 = Unsafe.getThreadBlock();
        if (TRACE) {
            SystemInterface.debugwriteln("Ending Java thread " + jq_Thread2);
        }
        jq_Thread2.disableThreadSwitch();
        _num_of_java_threads.getAddress().atomicSub(1);
        if (jq_Thread2.isDaemon()) {
            _num_of_daemon_threads.getAddress().atomicSub(1);
        }
        jq_NativeThread jq_NativeThread2 = jq_Thread2.getNativeThread();
        Unsafe.setThreadBlock(jq_NativeThread2.schedulerThread);
        jq_NativeThread2.currentThread = jq_NativeThread2.schedulerThread;
        CodeAddress codeAddress = _schedulerLoop.getDefaultCompiledVersion().getEntrypoint();
        StackAddress stackAddress = jq_NativeThread2.original_ebp;
        StackAddress stackAddress2 = jq_NativeThread2.original_esp;
        if (TRACE) {
            SystemInterface.debugwriteln("Long jumping back to schedulerLoop, ip:" + codeAddress.stringRep() + " fp: " + stackAddress.stringRep() + " sp: " + stackAddress2.stringRep());
        }
        HeapAddress heapAddress = (HeapAddress)stackAddress2.offset(4).peek();
        boolean bl = false;
        if (heapAddress.asObject() == jq_NativeThread2) {
            bl = true;
        }
        Assert._assert(bl, "arg to schedulerLoop got corrupted: " + heapAddress.stringRep() + " should be " + HeapAddress.addressOf(jq_NativeThread2).stringRep());
        Unsafe.longJump(codeAddress, stackAddress, stackAddress2, 0);
        Assert.UNREACHABLE();
    }

    public void nativeThreadEntry() {
        if (this != initial_native_thread) {
            this.pid = SystemInterface.init_thread();
        }
        Unsafe.setThreadBlock(this.schedulerThread);
        boolean bl = false;
        if (this.currentThread == this.schedulerThread) {
            bl = true;
        }
        Assert._assert(bl);
        if (USE_INTERRUPTER_THREAD) {
            this.it = new jq_InterrupterThread(this);
        } else {
            SystemInterface.set_interval_timer(1, 10);
        }
        StackAddress stackAddress = StackAddress.getStackPointer();
        StackAddress stackAddress2 = StackAddress.getBasePointer();
        this.original_esp = (StackAddress)stackAddress.offset(-CodeAddress.size() - HeapAddress.size());
        this.original_ebp = stackAddress2;
        if (TRACE) {
            SystemInterface.debugwriteln("Started native thread: " + this + " sp: " + this.original_esp.stringRep() + " fp: " + this.original_ebp.stringRep());
        }
        this.schedulerLoop();
        Assert.UNREACHABLE();
    }

    public void schedulerLoop() {
        HeapAddress heapAddress = (HeapAddress)this.original_esp.offset(4).peek();
        boolean bl = false;
        if (heapAddress.asObject() == this) {
            bl = true;
        }
        Assert._assert(bl);
        boolean bl2 = false;
        if (Unsafe.getThreadBlock() == this.schedulerThread) {
            bl2 = true;
        }
        Assert._assert(bl2);
        while (this != initial_native_thread || num_of_daemon_threads != num_of_java_threads) {
            boolean bl3 = false;
            if (this.currentThread == this.schedulerThread) {
                bl3 = true;
            }
            Assert._assert(bl3);
            jq_Thread jq_Thread2 = this.getNextReadyThread();
            if (jq_Thread2 == null) {
                if (TRACE) {
                    SystemInterface.debugwriteln("Native thread " + this + " is idle!");
                }
                SystemInterface.yield();
                continue;
            }
            Assert._assert(jq_Thread2.isThreadSwitchEnabled() ^ true);
            if (TRACE) {
                SystemInterface.debugwriteln("Native thread " + this + " scheduler loop: switching to Java thread " + jq_Thread2);
            }
            this.currentThread = jq_Thread2;
            SystemInterface.set_current_context(jq_Thread2, jq_Thread2.getRegisterState());
            Assert.UNREACHABLE();
        }
        jq_NativeThread.dumpStatistics();
        SystemInterface.die(0);
        Assert.UNREACHABLE();
    }

    public static void dumpStatistics() {
        int n = 0;
        while (n < native_threads.length) {
            native_threads[n].dumpStats();
            ++n;
        }
    }

    public void dumpStats() {
        Debug.write("Native thread ");
        Debug.write(this.index);
        Debug.write(": transferred out=");
        Debug.write(this.transferredOut);
        Debug.write("(");
        Debug.write(this.failedTransferOut);
        Debug.write(" failed) in=");
        Debug.writeln(this.transferredIn);
        Debug.write("               : chosen as least busy=");
        Debug.writeln(this.chosenAsLeastBusy);
        int n = 0;
        while (n < this.readyQueueLength.length) {
            Debug.write("               : average ready queue length ");
            Debug.write(n);
            Debug.write(": ");
            System.err.println((double)this.readyQueueLength[n] / (double)this.readyQueueN);
            ++n;
        }
        Debug.write("               : preempted thread length=");
        System.err.println((double)this.preemptedThreadsLength / (double)this.readyQueueN);
        if (this.it != null) {
            Debug.write("Native thread ");
            Debug.write(this.index);
            Debug.write(": ");
            this.it.dumpStatistics();
        }
    }

    public void threadSwitch() {
        jq_Thread jq_Thread2 = this.currentThread;
        jq_Thread2.wasPreempted = true;
        if (TRACE) {
            SystemInterface.debugwriteln("Timer interrupt in native thread: " + this + " Java thread: " + jq_Thread2);
        }
        this.switchThread();
        Assert.UNREACHABLE();
    }

    public void yieldCurrentThread() {
        jq_Thread jq_Thread2 = this.currentThread;
        jq_Thread2.wasPreempted = false;
        if (TRACE) {
            SystemInterface.debugwriteln("Explicit yield in native thread: " + this + " Java thread: " + jq_Thread2);
        }
        this.switchThread();
        Assert.UNREACHABLE();
    }

    private final void switchThread() {
        jq_Thread jq_Thread2 = this.currentThread;
        Unsafe.setThreadBlock(this.schedulerThread);
        this.currentThread = this.schedulerThread;
        CodeAddress codeAddress = (CodeAddress)StackAddress.getBasePointer().offset(StackAddress.size()).peek();
        if (TRACE) {
            SystemInterface.debugwriteln("Thread switch in native thread: " + this + " Java thread: " + jq_Thread2 + " ip: " + codeAddress.stringRep() + " cc: " + CodeAllocator.getCodeContaining(codeAddress));
        }
        if (jq_Thread2.isThreadSwitchEnabled()) {
            SystemInterface.debugwriteln("Java thread " + jq_Thread2 + " has thread switching enabled on threadSwitch entry!");
            SystemInterface.die(-1);
        }
        boolean bl = false;
        if (jq_Thread2 != this.schedulerThread) {
            bl = true;
        }
        Assert._assert(bl);
        jq_RegisterState jq_RegisterState2 = jq_Thread2.getRegisterState();
        jq_RegisterState2.Eip = (CodeAddress)jq_RegisterState2.getEsp().peek();
        jq_RegisterState2.Esp = (StackAddress)jq_RegisterState2.getEsp().offset(StackAddress.size() + CodeAddress.size());
        jq_Thread jq_Thread3 = this.getNextReadyThread();
        this.transferExtraWork();
        if (jq_Thread3 == null) {
            jq_Thread3 = jq_Thread2;
        } else {
            codeAddress = jq_Thread3.getRegisterState().Eip;
            if (TRACE) {
                SystemInterface.debugwriteln("New ready Java thread: " + jq_Thread3 + " ip: " + codeAddress.stringRep() + " cc: " + CodeAllocator.getCodeContaining(codeAddress));
            }
            int n = jq_Thread2.getPriority();
            this.readyQueue[n].enqueue(jq_Thread2);
            if (jq_Thread2.wasPreempted && !jq_Thread2.isDaemon()) {
                ++this.preempted_thread_counter;
            }
            Assert._assert(jq_Thread3.isThreadSwitchEnabled() ^ true);
        }
        this.currentThread = jq_Thread3;
        SystemInterface.set_current_context(jq_Thread3, jq_Thread3.getRegisterState());
        Assert.UNREACHABLE();
    }

    public void yieldCurrentThreadTo(jq_Thread jq_Thread2) {
        jq_Thread jq_Thread3 = this.currentThread;
        jq_Thread3.wasPreempted = false;
        this.switchThread(jq_Thread2);
        Assert.UNREACHABLE();
    }

    private final void switchThread(jq_Thread jq_Thread2) {
        int n;
        jq_Thread jq_Thread3 = this.currentThread;
        Unsafe.setThreadBlock(this.schedulerThread);
        this.currentThread = this.schedulerThread;
        CodeAddress codeAddress = (CodeAddress)StackAddress.getBasePointer().offset(StackAddress.size()).peek();
        if (TRACE) {
            SystemInterface.debugwriteln("Thread switch in native thread: " + this + " Java thread: " + jq_Thread3 + " ip: " + codeAddress.stringRep() + " cc: " + CodeAllocator.getCodeContaining(codeAddress));
        }
        if (jq_Thread3.isThreadSwitchEnabled()) {
            SystemInterface.debugwriteln("Java thread " + jq_Thread3 + " has thread switching enabled on threadSwitch entry!");
            SystemInterface.die(-1);
        }
        boolean bl = false;
        if (jq_Thread3 != this.schedulerThread) {
            bl = true;
        }
        Assert._assert(bl);
        jq_RegisterState jq_RegisterState2 = jq_Thread3.getRegisterState();
        jq_RegisterState2.Eip = (CodeAddress)jq_RegisterState2.getEsp().peek();
        jq_RegisterState2.Esp = (StackAddress)jq_RegisterState2.getEsp().offset(StackAddress.size() + CodeAddress.size());
        if (jq_Thread3 != jq_Thread2) {
            n = 0;
            while (true) {
                if (n == this.readyQueue.length) {
                    Assert.UNREACHABLE();
                    return;
                }
                boolean bl2 = this.readyQueue[n].remove(jq_Thread2);
                if (bl2) break;
                ++n;
            }
            if (jq_Thread2.wasPreempted && !jq_Thread2.isDaemon()) {
                --this.preempted_thread_counter;
            }
        }
        this.transferExtraWork();
        if (jq_Thread3 != jq_Thread2) {
            codeAddress = jq_Thread2.getRegisterState().Eip;
            if (TRACE) {
                SystemInterface.debugwriteln("New ready Java thread: " + jq_Thread2 + " ip: " + codeAddress.stringRep() + " cc: " + CodeAllocator.getCodeContaining(codeAddress));
            }
            n = jq_Thread3.getPriority();
            this.readyQueue[n].enqueue(jq_Thread3);
            if (jq_Thread3.wasPreempted && !jq_Thread3.isDaemon()) {
                ++this.preempted_thread_counter;
            }
            Assert._assert(jq_Thread2.isThreadSwitchEnabled() ^ true);
        }
        this.currentThread = jq_Thread2;
        SystemInterface.set_current_context(jq_Thread2, jq_Thread2.getRegisterState());
        Assert.UNREACHABLE();
    }

    private final void transferExtraWork() {
        jq_NativeThread jq_NativeThread2 = jq_NativeThread.getLeastBusyThread();
        if (this == jq_NativeThread2) {
            return;
        }
        if ((float)this.preempted_thread_counter * TRANSFER_THRESHOLD > (float)(jq_NativeThread2.preempted_thread_counter + 1)) {
            int n = this.readyQueue.length - 1;
            while (n >= 0) {
                if (this.readyQueue[n].length() > jq_NativeThread2.readyQueue[n].length()) {
                    ++this.transferredOut;
                    jq_Thread jq_Thread2 = this.readyQueue[n].dequeue();
                    Assert._assert(jq_Thread2.isThreadSwitchEnabled() ^ true);
                    if (jq_Thread2.wasPreempted && !jq_Thread2.isDaemon()) {
                        --this.preempted_thread_counter;
                    }
                    jq_NativeThread2.transferQueue.enqueue(jq_Thread2);
                    break;
                }
                --n;
            }
            if (n < 0) {
                ++this.failedTransferOut;
            }
        }
    }

    private final jq_ThreadQueue chooseNextQueue() {
        float f = this.rng.nextFloat();
        int n = 0;
        while (true) {
            if (f < DISTRIBUTION[n]) {
                if (!this.readyQueue[n].isEmpty()) {
                    return this.readyQueue[n];
                }
                int n2 = this.rng.nextBoolean() ? 1 : -1;
                int n3 = n + n2;
                while (n3 < DISTRIBUTION.length && n3 >= 0) {
                    if (!this.readyQueue[n3].isEmpty()) {
                        return this.readyQueue[n3];
                    }
                    n3 += n2;
                }
                n2 = -n2;
                n3 = n + n2;
                while (n3 < DISTRIBUTION.length && n3 >= 0) {
                    if (!this.readyQueue[n3].isEmpty()) {
                        return this.readyQueue[n3];
                    }
                    n3 += n2;
                }
                return null;
            }
            ++n;
        }
    }

    private final jq_Thread getNextReadyThread() {
        if (!this.transferQueue.isEmpty()) {
            ++this.transferredIn;
            jq_Thread jq_Thread2 = this.transferQueue.dequeue();
            jq_Thread2.setNativeThread(this);
            Assert._assert(jq_Thread2.isThreadSwitchEnabled() ^ true);
            return jq_Thread2;
        }
        int n = 0;
        while (n < this.readyQueue.length) {
            int n2 = n;
            this.readyQueueLength[n2] = this.readyQueueLength[n2] + this.readyQueue[n].length();
            ++n;
        }
        this.preemptedThreadsLength += this.preempted_thread_counter;
        ++this.readyQueueN;
        if (CHECK) {
            this.verifyCount();
        }
        jq_ThreadQueue jq_ThreadQueue2 = this.chooseNextQueue();
        while (jq_ThreadQueue2 != null && !jq_ThreadQueue2.isEmpty()) {
            jq_Thread jq_Thread3 = jq_ThreadQueue2.dequeue();
            if (jq_Thread3.wasPreempted && !jq_Thread3.isDaemon()) {
                --this.preempted_thread_counter;
            }
            if (!jq_Thread3.isAlive()) continue;
            boolean bl = false;
            if (jq_Thread3.getNativeThread() == this) {
                bl = true;
            }
            Assert._assert(bl);
            Assert._assert(jq_Thread3.isThreadSwitchEnabled() ^ true);
            return jq_Thread3;
        }
        return null;
    }

    private final void verifyCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.readyQueue.length) {
            Iterator iterator = this.readyQueue[n2].threads();
            while (iterator.hasNext()) {
                jq_Thread jq_Thread2 = (jq_Thread)iterator.next();
                if (!jq_Thread2.wasPreempted || jq_Thread2.isDaemon()) continue;
                ++n;
            }
            ++n2;
        }
        boolean bl = false;
        if (n == this.preempted_thread_counter) {
            bl = true;
        }
        Assert._assert(bl);
    }

    public String toString() {
        return "NT " + this.index + ':' + this.thread_handle + '(' + Strings.hex(this) + ')';
    }

    public int getIndex() {
        return this.index;
    }

    public static void ctrl_break_handler() {
        Unsafe.setThreadBlock(break_jthread);
        jq_NativeThread.break_nthread.thread_handle = SystemInterface.get_current_thread_handle();
        if (!has_break_occurred) {
            jq_NativeThread.break_nthread.myHeapAllocator.init();
            jq_NativeThread.break_nthread.myCodeAllocator.init();
            has_break_occurred = true;
        }
        SystemInterface.debugwriteln("*** BREAK! ***");
        int n = 0;
        while (n < native_threads.length) {
            SystemInterface.suspend_thread(jq_NativeThread.native_threads[n].thread_handle);
            ++n;
        }
        OnlineDebugger.debuggerEntryPoint();
        n = 0;
        while (n < native_threads.length) {
            SystemInterface.resume_thread(jq_NativeThread.native_threads[n].thread_handle);
            ++n;
        }
    }

    public static void dumpAllThreads() {
        jq_RegisterState jq_RegisterState2 = new jq_RegisterState();
        jq_RegisterState2.ContextFlags = 65537;
        int n = 0;
        while (n < native_threads.length) {
            SystemInterface.get_thread_context(jq_NativeThread.native_threads[n].pid, jq_RegisterState2);
            native_threads[n].dump(jq_RegisterState2);
            ++n;
        }
    }

    public static void initBreakThread() {
        break_nthread = new jq_NativeThread(-1);
        Thread thread = new Thread("_break_");
        break_jthread = ThreadUtils.getJQThread(thread);
        break_jthread.disableThreadSwitch();
        break_jthread.setNativeThread(break_nthread);
        if (TRACE) {
            SystemInterface.debugwriteln("Break thread initialized");
        }
    }

    public static void stopTheWorld() {
        jq_Thread jq_Thread2 = Unsafe.getThreadBlock();
        if (TRACE) {
            SystemInterface.debugwriteln("Ending Java thread " + jq_Thread2);
        }
        jq_Thread2.disableThreadSwitch();
        _num_of_java_threads.getAddress().atomicSub(1);
        if (jq_Thread2.isDaemon()) {
            _num_of_daemon_threads.getAddress().atomicSub(1);
        }
        Unsafe.setThreadBlock(gc_jthread);
        jq_NativeThread.gc_nthread.currentThread = gc_jthread;
        jq_NativeThread.gc_nthread.thread_handle = SystemInterface.get_current_thread_handle();
        SystemInterface.debugwriteln("*** GC Starts! ***");
        int n = 0;
        while (n < native_threads.length) {
            SystemInterface.suspend_thread(jq_NativeThread.native_threads[n].thread_handle);
            ++n;
        }
        jq_RegisterState jq_RegisterState2 = new jq_RegisterState();
        jq_RegisterState2.ContextFlags = 65543;
        GCVisitor gCVisitor = (GCVisitor)GCManager.getGC(gcType);
        int n2 = 0;
        while (n2 < native_threads.length) {
            SystemInterface.get_thread_context(jq_NativeThread.native_threads[n2].pid, jq_RegisterState2);
            gCVisitor.visit(jq_RegisterState2);
            if (TRACE) {
                native_threads[n2].dump(jq_RegisterState2);
            }
            ++n2;
        }
    }

    public static void resumeTheFeast() {
        GCVisitor gCVisitor = (GCVisitor)GCManager.getGC(gcType);
        gCVisitor.farewell(native_threads);
        jq_NativeThread.startNativeThreads();
    }

    public static void initGCThread() {
        gc_nthread = new jq_NativeThread(-2);
        Thread thread = new Thread((Runnable)GCManager.getGC(gcType), "_gc_");
        thread.setDaemon(true);
        gc_jthread = ThreadUtils.getJQThread(thread);
        gc_jthread.disableThreadSwitch();
        gc_jthread.setNativeThread(gc_nthread);
        if (TRACE) {
            SystemInterface.debugwriteln("GC thread initialized");
        }
    }

    public void dump(jq_RegisterState jq_RegisterState2) {
        SystemInterface.debugwriteln(this + ": current Java thread = " + this.currentThread);
        StackCodeWalker.stackDump(jq_RegisterState2.Eip, jq_RegisterState2.getEbp());
        int n = 0;
        while (n < this.readyQueue.length) {
            SystemInterface.debugwriteln(this + ": ready queue " + n + " = " + this.readyQueue[n]);
            ++n;
        }
        SystemInterface.debugwriteln(this + ": idle queue = " + this.idleQueue);
        SystemInterface.debugwriteln(this + ": transfer queue = " + this.transferQueue);
    }

    public jq_ThreadQueue getReadyQueue(int n) {
        return this.readyQueue[n];
    }

    public jq_ThreadQueue getIdleQueue() {
        return this.idleQueue;
    }

    public jq_ThreadQueue getTransferQueue() {
        return this.transferQueue;
    }

    private final /* synthetic */ void this() {
        this.rng = new Random();
        this.readyQueueLength = new int[10];
    }

    private jq_NativeThread(int n) {
        this.this();
        this.readyQueue = new jq_ThreadQueue[10];
        int n2 = 0;
        while (n2 < 10) {
            this.readyQueue[n2] = new jq_ThreadQueue();
            ++n2;
        }
        this.idleQueue = new jq_ThreadQueue();
        this.transferQueue = new jq_SynchThreadQueue();
        this.myHeapAllocator = new SimpleAllocator();
        this.myCodeAllocator = new RuntimeCodeAllocator();
        this.index = n;
        this.preempted_thread_counter = 0;
        Thread thread = new Thread("_scheduler_" + n);
        this.currentThread = this.schedulerThread = ThreadUtils.getJQThread(thread);
        if (this.schedulerThread != null) {
            this.schedulerThread.disableThreadSwitch();
            this.schedulerThread.setNativeThread(this);
        } else {
            boolean bl = false;
            if (!jq.IsBootstrapping && !jq.RunningNative) {
                bl = true;
            }
            Assert._assert(bl);
        }
    }

    jq_NativeThread(jq_Thread jq_Thread2) {
        this.this();
        this.readyQueue = null;
        this.idleQueue = null;
        this.transferQueue = null;
        this.myHeapAllocator = new SimpleAllocator();
        this.myCodeAllocator = new RuntimeCodeAllocator();
        this.index = -1;
        this.currentThread = this.schedulerThread = jq_Thread2;
        jq_Thread2.setNativeThread(this);
    }

    static {
        num_of_java_threads = 0;
        num_of_daemon_threads = 0;
        USE_INTERRUPTER_THREAD = false;
        TRANSFER_THRESHOLD = 1.5f;
        DISTRIBUTION = new float[]{0.05f, 0.11f, 0.18f, 0.26f, 0.35f, 0.45f, 0.56f, 0.68f, 0.81f, 1.0f};
        has_break_occurred = false;
        gcType = 4;
        _class = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LScheduler/jq_NativeThread;");
        _nativeThreadEntry = _class.getOrCreateInstanceMethod("nativeThreadEntry", "()V");
        _schedulerLoop = _class.getOrCreateInstanceMethod("schedulerLoop", "()V");
        _threadSwitch = _class.getOrCreateInstanceMethod("threadSwitch", "()V");
        _ctrl_break_handler = _class.getOrCreateStaticMethod("ctrl_break_handler", "()V");
        _num_of_java_threads = _class.getOrCreateStaticField("num_of_java_threads", "I");
        _num_of_daemon_threads = _class.getOrCreateStaticField("num_of_daemon_threads", "I");
    }
}

