/*
 * Decompiled with CFR 0.152.
 */
package Scheduler;

import Allocator.CodeAllocator;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_InstanceMethod;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Memory.StackAddress;
import Run_Time.Debug;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Scheduler.ThreadUtils;
import Scheduler.jq_NativeThread;
import Scheduler.jq_RegisterState;
import Scheduler.jq_Thread;

public class jq_InterrupterThread
extends Thread {
    public static boolean TRACE = false;
    public static final boolean STATISTICS = true;
    public static int QUANTA = 10;
    public static final jq_Class _class = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LScheduler/jq_InterrupterThread;");
    public static final jq_InstanceMethod _run = _class.getOrCreateInstanceMethod("run", "()V");
    private int tid;
    private int pid;
    private jq_NativeThread other_nt;
    private jq_Thread myself;
    private int enabledCount;
    private int disabledCount;

    public void dumpStatistics() {
        Debug.write("enabled=");
        Debug.write(this.enabledCount);
        Debug.write(" disabled=");
        Debug.writeln(this.disabledCount);
    }

    public void run() {
        this.pid = SystemInterface.init_thread();
        Unsafe.setThreadBlock(this.myself);
        SystemInterface.set_thread_priority(this.tid, 15);
        while (true) {
            SystemInterface.msleep(QUANTA);
            this.other_nt.suspend();
            jq_Thread jq_Thread2 = this.other_nt.getCurrentJavaThread();
            if (jq_Thread2.isThreadSwitchEnabled()) {
                ++this.enabledCount;
                if (TRACE) {
                    SystemInterface.debugwriteln("TICK! " + this.other_nt + " Java Thread = " + jq_Thread2);
                }
                jq_Thread2.disableThreadSwitch();
                jq_RegisterState jq_RegisterState2 = jq_Thread2.getRegisterState();
                jq_RegisterState2.ContextFlags = 65547;
                boolean bl = this.other_nt.getContext(jq_RegisterState2);
                if (!bl) {
                    if (TRACE) {
                        SystemInterface.debugwriteln("Failed to get thread context for " + this.other_nt);
                    }
                } else {
                    if (TRACE) {
                        SystemInterface.debugwriteln(this.other_nt + " : " + jq_Thread2 + " ip=" + jq_RegisterState2.Eip.stringRep() + " sp=" + jq_RegisterState2.getEsp().stringRep() + " cc=" + CodeAllocator.getCodeContaining(jq_RegisterState2.Eip));
                    }
                    jq_RegisterState2.Esp = (StackAddress)jq_RegisterState2.getEsp().offset(-HeapAddress.size());
                    jq_RegisterState2.getEsp().poke(HeapAddress.addressOf(this.other_nt));
                    jq_RegisterState2.Esp = (StackAddress)jq_RegisterState2.getEsp().offset(-CodeAddress.size());
                    jq_RegisterState2.getEsp().poke(jq_RegisterState2.Eip);
                    jq_RegisterState2.Eip = jq_NativeThread._threadSwitch.getDefaultCompiledVersion().getEntrypoint();
                    jq_RegisterState2.ContextFlags = 65537;
                    bl = this.other_nt.setContext(jq_RegisterState2);
                    if (!bl) {
                        if (TRACE) {
                            SystemInterface.debugwriteln("Failed to set thread context for " + this.other_nt);
                        }
                    } else if (TRACE) {
                        SystemInterface.debugwriteln(this.other_nt + " : simulating a call to threadSwitch");
                    }
                }
            } else {
                ++this.disabledCount;
            }
            this.other_nt.resume();
        }
    }

    jq_InterrupterThread(jq_NativeThread jq_NativeThread2) {
        this.other_nt = jq_NativeThread2;
        if (TRACE) {
            SystemInterface.debugwriteln("Initialized timer interrupt for native thread " + jq_NativeThread2);
        }
        this.myself = ThreadUtils.getJQThread(this);
        this.myself.disableThreadSwitch();
        this.tid = SystemInterface.create_thread(_run.getDefaultCompiledVersion().getEntrypoint(), HeapAddress.addressOf(this));
        jq_NativeThread jq_NativeThread3 = new jq_NativeThread(this.myself);
        jq_NativeThread3.getCodeAllocator().init();
        jq_NativeThread3.getHeapAllocator().init();
        SystemInterface.resume_thread(this.tid);
    }
}

