/*
 * Decompiled with CFR 0.152.
 */
package Run_Time;

import GC.GCBitsManager;
import Memory.HeapAddress;
import Memory.StackAddress;
import Run_Time.SystemInterface;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StackHeapWalker {
    public static boolean TRACE = false;
    private HeapAddress hp;
    private StackAddress fp;
    private StackAddress sp;
    private ArrayList validHeapAddrs;

    private final boolean gotoNext() {
        if (this.sp.difference(this.fp) != 0) {
            this.sp = (StackAddress)this.sp.offset(4);
        }
        if (this.sp.difference(this.fp) != 0) {
            if (TRACE) {
                SystemInterface.debugwriteln("StackHeapWalker next: fp=" + this.fp.stringRep() + " sp=" + this.sp.stringRep());
            }
            return true;
        }
        do {
            this.fp = (StackAddress)this.fp.peek();
            if (this.fp.isNull()) {
                return false;
            }
            this.sp = (StackAddress)this.sp.offset(8);
        } while (this.sp.difference(this.fp) == 0);
        if (TRACE) {
            SystemInterface.debugwriteln("StackHeapWalker next: fp=" + this.fp.stringRep() + " sp=" + this.sp.stringRep());
        }
        return true;
    }

    private final void scan() {
        if (this.sp == null || this.fp == null) {
            return;
        }
        do {
            HeapAddress heapAddress;
            if (!GCBitsManager.isValidHeapAddr(heapAddress = (HeapAddress)this.sp.peek())) continue;
            this.validHeapAddrs.add(heapAddress);
        } while (this.gotoNext());
    }

    public boolean isValidHeapAddr(HeapAddress heapAddress) {
        return GCBitsManager.isValidHeapAddr(heapAddress);
    }

    public ArrayList getValidHeapAddrs() {
        return this.validHeapAddrs;
    }

    private final /* synthetic */ void this() {
        this.validHeapAddrs = new ArrayList();
    }

    public StackHeapWalker(StackAddress stackAddress, StackAddress stackAddress2) {
        this.this();
        this.sp = stackAddress;
        this.fp = stackAddress2;
        this.hp = null;
        if (stackAddress == null || stackAddress2 == null || stackAddress.isNull() || stackAddress2.isNull() || stackAddress.difference(stackAddress2) > 0) {
            this.fp = null;
            this.sp = null;
        } else if (stackAddress.difference(stackAddress2) == 0 && !this.gotoNext()) {
            stackAddress2 = null;
            stackAddress = null;
        }
        this.scan();
        if (TRACE) {
            SystemInterface.debugwriteln("StackHeapWalker init: fp=" + stackAddress2.stringRep() + " sp=" + stackAddress.stringRep());
        }
    }
}

