/*
 * Decompiled with CFR 0.152.
 */
package Run_Time;

import Allocator.CodeAllocator;
import Clazz.jq_CompiledCode;
import Clazz.jq_Method;
import Memory.CodeAddress;
import Memory.StackAddress;
import Run_Time.SystemInterface;
import UTF.Utf8;
import Util.Strings;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StackCodeWalker
implements Iterator {
    public static boolean TRACE = false;
    CodeAddress ip;
    StackAddress fp;

    public CodeAddress getIP() {
        return this.ip;
    }

    public StackAddress getFP() {
        return this.fp;
    }

    public jq_CompiledCode getCode() {
        return CodeAllocator.getCodeContaining(this.ip);
    }

    public jq_Method getMethod() {
        jq_CompiledCode jq_CompiledCode2 = this.getCode();
        if (jq_CompiledCode2 == null) {
            return null;
        }
        return jq_CompiledCode2.getMethod();
    }

    public int getCodeOffset() {
        jq_CompiledCode jq_CompiledCode2 = this.getCode();
        if (jq_CompiledCode2 == null) {
            return 0;
        }
        CodeAddress codeAddress = this.getIP();
        int n = codeAddress.difference(jq_CompiledCode2.getStart());
        return n;
    }

    public Utf8 getSourceFile() {
        jq_Method jq_Method2 = this.getMethod();
        if (jq_Method2 == null) {
            return null;
        }
        Utf8 utf8 = jq_Method2.getDeclaringClass().getSourceFile();
        return utf8;
    }

    public int getBCIndex() {
        jq_CompiledCode jq_CompiledCode2 = this.getCode();
        if (jq_CompiledCode2 == null) {
            return -1;
        }
        int n = jq_CompiledCode2.getBytecodeIndex(this.ip);
        return n;
    }

    public int getLineNum() {
        jq_Method jq_Method2 = this.getMethod();
        if (jq_Method2 == null) {
            return -1;
        }
        int n = this.getBCIndex();
        int n2 = jq_Method2.getLineNumber(n);
        return n2;
    }

    public void gotoNext() throws NoSuchElementException {
        if (this.fp.isNull()) {
            throw new NoSuchElementException();
        }
        this.ip = (CodeAddress)this.fp.offset(4).peek();
        this.fp = (StackAddress)this.fp.peek();
        if (TRACE) {
            SystemInterface.debugwriteln("StackCodeWalker next: fp=" + this.fp.stringRep() + " ip=" + this.ip.stringRep() + ' ' + this.getCode());
        }
    }

    public boolean hasNext() {
        if (this.fp.isNull()) {
            return false;
        }
        CodeAddress codeAddress = (CodeAddress)this.fp.offset(4).peek();
        if (TRACE) {
            SystemInterface.debugwriteln("StackCodeWalker hasnext: next ip=" + codeAddress.stringRep() + ' ' + CodeAllocator.getCodeContaining(codeAddress));
        }
        return true;
    }

    public Object next() throws NoSuchElementException {
        this.gotoNext();
        return new CodeAllocator.InstructionPointer(this.ip);
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        String string;
        jq_CompiledCode jq_CompiledCode2 = this.getCode();
        CodeAddress codeAddress = this.getIP();
        if (jq_CompiledCode2 != null) {
            jq_Method jq_Method2 = jq_CompiledCode2.getMethod();
            int n = codeAddress.difference(jq_CompiledCode2.getStart());
            if (jq_Method2 != null) {
                Utf8 utf8 = jq_Method2.getDeclaringClass().getSourceFile();
                int n2 = jq_CompiledCode2.getBytecodeIndex(codeAddress);
                int n3 = jq_Method2.getLineNumber(n2);
                string = "\tat " + jq_Method2 + " (" + utf8 + ':' + n3 + " bc:" + n2 + " off:" + Strings.hex(n) + ')';
            } else {
                string = "\tat <unknown cc> (start:" + jq_CompiledCode2.getStart().stringRep() + " off:" + Strings.hex(n) + ')';
            }
        } else {
            string = "\tat <unknown addr> (ip:" + codeAddress.stringRep() + ')';
        }
        return string;
    }

    public static void stackDump(CodeAddress codeAddress, StackAddress stackAddress) {
        StackCodeWalker stackCodeWalker = new StackCodeWalker(codeAddress, stackAddress);
        while (stackCodeWalker.hasNext()) {
            String string = stackCodeWalker.toString();
            SystemInterface.debugwriteln(string);
            stackCodeWalker.gotoNext();
        }
    }

    public StackCodeWalker(CodeAddress codeAddress, StackAddress stackAddress) {
        this.ip = codeAddress;
        this.fp = stackAddress;
        if (TRACE) {
            SystemInterface.debugwriteln("StackCodeWalker init: fp=" + stackAddress.stringRep() + " ip=" + codeAddress.stringRep() + ' ' + this.getCode());
        }
    }
}

