/*
 * Decompiled with CFR 0.152.
 */
package Run_Time;

import Bootstrap.MethodInvocation;
import Clazz.jq_Class;
import Clazz.jq_NameAndDesc;
import Clazz.jq_StaticMethod;
import Main.jq;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Memory.StackAddress;
import Run_Time.Reflection;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Util.Assert;

public class HighResolutionTimer {
    private static boolean native_library_present;
    public static final double TICKS_PER_SECOND = 2.0E9;
    private static long counter_frequency;
    static SystemInterface.ExternalLink QueryPerformanceFrequency;
    static SystemInterface.ExternalLink QueryPerformanceCounter;
    static SystemInterface.ExternalLink gettimeofday;
    static /* synthetic */ Class class$Run_Time$HighResolutionTimer;

    public static native long ticks();

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < 10) {
            System.out.println("Now: " + HighResolutionTimer.now());
            ++n;
        }
    }

    public static final void init() {
        if (QueryPerformanceFrequency != null) {
            counter_frequency = HighResolutionTimer.query_performance_frequency();
        }
    }

    public static final double now() {
        if (QueryPerformanceCounter != null) {
            if (counter_frequency == 0L) {
                HighResolutionTimer.init();
            }
            long l = HighResolutionTimer.query_performance_counter();
            return (double)l / (double)counter_frequency;
        }
        if (gettimeofday != null) {
            long l = HighResolutionTimer.get_time_of_day();
            int n = (int)(l >> 32);
            int n2 = (int)l;
            return (double)n * 1000000.0 + (double)n2;
        }
        if (native_library_present) {
            return (double)HighResolutionTimer.ticks() / 2.0E9;
        }
        return 0.0;
    }

    private static final long query_performance_frequency() {
        try {
            CodeAddress codeAddress = QueryPerformanceFrequency.resolve();
            StackAddress stackAddress = StackAddress.alloca(8);
            Unsafe.pushArgA(stackAddress);
            Unsafe.getThreadBlock().disableThreadSwitch();
            byte by = (byte)Unsafe.invoke(codeAddress);
            Unsafe.getThreadBlock().enableThreadSwitch();
            boolean bl = false;
            if (by != 0) {
                bl = true;
            }
            long l = stackAddress.peek8();
            return l;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0L;
        }
    }

    private static final long query_performance_counter() {
        try {
            CodeAddress codeAddress = QueryPerformanceCounter.resolve();
            StackAddress stackAddress = StackAddress.alloca(8);
            Unsafe.pushArgA(stackAddress);
            Unsafe.getThreadBlock().disableThreadSwitch();
            byte by = (byte)Unsafe.invoke(codeAddress);
            Unsafe.getThreadBlock().enableThreadSwitch();
            boolean bl = false;
            if (by != 0) {
                bl = true;
            }
            long l = stackAddress.peek8();
            return l;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0L;
        }
    }

    private static final long get_time_of_day() {
        try {
            CodeAddress codeAddress = gettimeofday.resolve();
            StackAddress stackAddress = StackAddress.alloca(8);
            Unsafe.pushArgA(HeapAddress.getNull());
            Unsafe.pushArgA(stackAddress);
            Unsafe.getThreadBlock().disableThreadSwitch();
            int n = (int)Unsafe.invoke(codeAddress);
            Unsafe.getThreadBlock().enableThreadSwitch();
            boolean bl = false;
            if (n != 0) {
                bl = true;
            }
            long l = stackAddress.peek8();
            return l;
        }
        catch (Throwable throwable) {
            Assert.UNREACHABLE();
            return 0L;
        }
    }

    public static void boot() {
        SystemInterface.Library library = SystemInterface.registerLibrary("kernel32");
        SystemInterface.Library library2 = SystemInterface.registerLibrary("libc.so.6");
        if (library != null) {
            QueryPerformanceFrequency = library.resolve("QueryPerformanceFrequency");
            QueryPerformanceCounter = library.resolve("QueryPerformanceCounter");
        } else {
            QueryPerformanceCounter = null;
            QueryPerformanceFrequency = null;
        }
        gettimeofday = library2 != null ? library2.resolve("gettimeofday") : null;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            System.loadLibrary("timer");
            native_library_present = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        counter_frequency = 0L;
        if (jq.RunningNative) {
            HighResolutionTimer.boot();
        } else if (jq.on_vm_startup != null) {
            Class clazz = class$Run_Time$HighResolutionTimer;
            if (clazz == null) {
                clazz = class$Run_Time$HighResolutionTimer = HighResolutionTimer.class$("[LRun_Time.HighResolutionTimer;", false);
            }
            jq_Class jq_Class2 = (jq_Class)Reflection.getJQType(clazz);
            jq_StaticMethod jq_StaticMethod2 = jq_Class2.getDeclaredStaticMethod(new jq_NameAndDesc("boot", "()V"));
            MethodInvocation methodInvocation = new MethodInvocation(jq_StaticMethod2, null);
            jq.on_vm_startup.add(methodInvocation);
        }
    }
}

