/*
 * Decompiled with CFR 0.152.
 */
package Memory.Manager;

import Memory.Heap.Heap;
import Memory.HeapAddress;
import Memory.Manager.ScanObject;
import Memory.Manager.ScanStack;
import Run_Time.Unsafe;
import Scheduler.jq_NativeThread;
import Scheduler.jq_Thread;
import Util.Collections.AppendIterator;
import java.util.Iterator;

public class ScanThreads {
    static void scanThreads(Heap heap) {
        jq_NativeThread jq_NativeThread2 = Unsafe.getThreadBlock().getNativeThread();
        int n = Unsafe.getThreadBlock().getThreadId();
        Iterator iterator = jq_NativeThread2.getReadyQueue(0).threads();
        iterator = new AppendIterator(iterator, jq_NativeThread2.getIdleQueue().threads());
        iterator = new AppendIterator(iterator, jq_NativeThread2.getTransferQueue().threads());
        while (iterator.hasNext()) {
            jq_Thread jq_Thread2 = (jq_Thread)iterator.next();
            HeapAddress heapAddress = HeapAddress.addressOf(jq_Thread2);
            if (jq_Thread2 == null) continue;
            if (jq_Thread2.getThreadId() == n) {
                ScanObject.scanObjectOrArray(jq_Thread2);
                ScanObject.scanObjectOrArray(jq_Thread2.getRegisterState());
                ScanStack.scanThreadStack(jq_Thread2, HeapAddress.getNull(), true);
                ScanStack.processRoots();
                continue;
            }
            ScanObject.scanObjectOrArray(jq_Thread2);
            ScanObject.scanObjectOrArray(jq_Thread2.getRegisterState());
            ScanStack.scanThreadStack(jq_Thread2, HeapAddress.getNull(), true);
            ScanStack.processRoots();
        }
    }
}

