/*
 * Decompiled with CFR 0.152.
 */
package Memory.Manager;

import Allocator.DefaultHeapAllocator;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_StaticField;
import Memory.HeapAddress;
import Memory.Manager.GCUtil;
import Memory.Manager.ScanObject;
import Run_Time.Debug;
import java.util.Collection;
import java.util.Iterator;

public class ScanStatics {
    static void scanStatics() {
        Collection collection = PrimordialClassLoader.loader.getAllTypes();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof jq_Class)) continue;
            jq_Class jq_Class2 = (jq_Class)e;
            jq_StaticField[] jq_StaticFieldArray = jq_Class2.getDeclaredStaticFields();
            int n = 0;
            while (n < jq_StaticFieldArray.length) {
                jq_StaticField jq_StaticField2 = jq_StaticFieldArray[n];
                if (jq_StaticField2.getType().isReferenceType()) {
                    HeapAddress heapAddress = jq_StaticField2.getAddress();
                    DefaultHeapAllocator.processPtrField(heapAddress);
                }
                ++n;
            }
        }
    }

    static boolean validateRefs() {
        boolean bl = true;
        Collection collection = PrimordialClassLoader.loader.getAllTypes();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof jq_Class)) continue;
            jq_Class jq_Class2 = (jq_Class)e;
            jq_StaticField[] jq_StaticFieldArray = jq_Class2.getStaticFields();
            int n = 0;
            while (n < jq_StaticFieldArray.length) {
                HeapAddress heapAddress;
                jq_StaticField jq_StaticField2 = jq_StaticFieldArray[n];
                if (jq_StaticField2.getType().isReferenceType() && !(heapAddress = (HeapAddress)jq_StaticField2.getAddress().peek()).isNull() && !GCUtil.validRef(heapAddress)) {
                    Debug.write("\nScanStatics.validateRefs:bad ref in ");
                    jq_StaticField2.getName().debugWrite();
                    Debug.write(" ");
                    jq_StaticField2.getDesc().debugWrite();
                    Debug.write("\n");
                    GCUtil.dumpRef(heapAddress);
                    bl = false;
                }
                ++n;
            }
        }
        return bl;
    }

    static boolean validateRefs(int n) {
        boolean bl = true;
        Collection collection = PrimordialClassLoader.loader.getAllTypes();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof jq_Class)) continue;
            jq_Class jq_Class2 = (jq_Class)e;
            jq_StaticField[] jq_StaticFieldArray = jq_Class2.getStaticFields();
            int n2 = 0;
            while (n2 < jq_StaticFieldArray.length) {
                HeapAddress heapAddress;
                jq_StaticField jq_StaticField2 = jq_StaticFieldArray[n2];
                if (jq_StaticField2.getType().isReferenceType() && ScanObject.validateRefs(heapAddress = (HeapAddress)jq_StaticField2.getAddress().peek(), n)) {
                    Debug.write("ScanStatics.validateRefs: Bad Ref reached from static ");
                    jq_StaticField2.getName().debugWrite();
                    Debug.write(" ");
                    jq_StaticField2.getDesc().debugWrite();
                    Debug.write("\n");
                    bl = false;
                }
                ++n2;
            }
        }
        return bl;
    }

    static void dumpRefs(int n, int n2) {
        Collection collection = PrimordialClassLoader.loader.getAllTypes();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof jq_Class)) continue;
            jq_Class jq_Class2 = (jq_Class)e;
            jq_StaticField[] jq_StaticFieldArray = jq_Class2.getStaticFields();
            int n3 = 0;
            while (n3 < jq_StaticFieldArray.length) {
                HeapAddress heapAddress;
                jq_StaticField jq_StaticField2 = jq_StaticFieldArray[n3];
                if (jq_StaticField2.getType().isReferenceType() && !(heapAddress = (HeapAddress)jq_StaticField2.getAddress().peek()).isNull()) {
                    jq_StaticField2.getName().debugWrite();
                    Debug.write(" ");
                    jq_StaticField2.getDesc().debugWrite();
                    GCUtil.dumpRef(heapAddress);
                }
                ++n3;
            }
        }
    }
}

