/*
 * Decompiled with CFR 0.152.
 */
package Memory.Manager;

import Allocator.CodeAllocator;
import Allocator.DefaultHeapAllocator;
import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_CompiledCode;
import Clazz.jq_Method;
import Clazz.jq_StaticField;
import Memory.Address;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Memory.Manager.CollectorThread;
import Memory.Manager.GCMapIterator;
import Memory.Manager.GCMapIteratorGroup;
import Memory.StackAddress;
import Run_Time.Unsafe;
import Scheduler.jq_Thread;
import java.util.Iterator;

public class ScanStack {
    static final boolean VALIDATE_STACK_REFS = true;
    static final boolean DUMP_STACK_FRAMES = false;
    static final boolean DUMP_STACK_REFS = false;
    static final boolean TRACE_STACKS = false;
    static int stackDumpCount = 0;

    public static void scanThreadStack(jq_Thread jq_Thread2, Address address, boolean bl) {
        StackAddress stackAddress;
        CodeAddress codeAddress;
        Address address2;
        CollectorThread collectorThread = (CollectorThread)Unsafe.getThreadBlock().getJavaLangThreadObject();
        GCMapIteratorGroup gCMapIteratorGroup = collectorThread.iteratorGroup;
        gCMapIteratorGroup.newStackWalk(jq_Thread2);
        if (!address.isNull()) {
            address2 = (StackAddress)address;
            codeAddress = (CodeAddress)address.offset(4).peek();
            stackAddress = (StackAddress)address.peek();
        } else {
            address2 = HeapAddress.getNull();
            codeAddress = jq_Thread2.getRegisterState().getEip();
            stackAddress = jq_Thread2.getRegisterState().getEbp();
        }
        if (!stackAddress.isNull()) {
            while (!stackAddress.peek().isNull()) {
                jq_CompiledCode jq_CompiledCode2 = CodeAllocator.getCodeContaining(codeAddress);
                jq_Method jq_Method2 = jq_CompiledCode2.getMethod();
                int n = codeAddress.difference(jq_CompiledCode2.getEntrypoint());
                GCMapIterator gCMapIterator = gCMapIteratorGroup.selectIterator(jq_CompiledCode2);
                gCMapIterator.setupIterator(jq_CompiledCode2, n, stackAddress);
                StackAddress stackAddress2 = gCMapIterator.getNextReferenceAddress();
                while (!((Address)stackAddress2).isNull()) {
                    DefaultHeapAllocator.processPtrField(stackAddress2);
                    stackAddress2 = gCMapIterator.getNextReferenceAddress();
                }
                gCMapIterator.cleanupPointers();
                address2 = stackAddress;
                codeAddress = (CodeAddress)stackAddress.offset(4).peek();
                stackAddress = (StackAddress)stackAddress.peek();
            }
        }
    }

    public static void processRoots() {
        Iterator iterator = PrimordialClassLoader.loader.getAllTypes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof jq_Class)) continue;
            jq_Class jq_Class2 = (jq_Class)e;
            jq_StaticField[] jq_StaticFieldArray = jq_Class2.getDeclaredStaticFields();
            int n = 0;
            while (n < jq_StaticFieldArray.length) {
                jq_StaticField jq_StaticField2 = jq_StaticFieldArray[n];
                if (jq_StaticField2.getType().isReferenceType()) {
                    HeapAddress heapAddress = jq_StaticField2.getAddress();
                    DefaultHeapAllocator.processPtrField(heapAddress);
                }
                ++n;
            }
        }
    }
}

