/*
 * Decompiled with CFR 0.152.
 */
package Memory.Manager;

import Memory.Manager.CollectorThread;
import Memory.Manager.SynchronizationBarrier;
import Run_Time.Debug;
import Run_Time.HighResolutionTimer;
import Run_Time.SystemInterface;
import Scheduler.jq_NativeThread;

public class Handshake {
    static final int LOCKOUT_GC_WORD = 0xCCCCCCC;
    protected boolean requestFlag;
    protected boolean completionFlag;

    private final void initiateCollection() {
        if (!jq_NativeThread.allNativeThreadsInitialized()) {
            Debug.write(" Garbage collection required before system fully initialized\n");
            Debug.write(" Specify larger than default heapsize on command line\n");
            jq_NativeThread.dumpAllThreads();
            SystemInterface.die(-1);
        }
        int n = jq_NativeThread.native_threads.length;
        CollectorThread.participantCount.reset(0);
        CollectorThread.gcBarrier.resetRendezvous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void requestAndAwaitCompletion() {
        Handshake handshake = this;
        synchronized (handshake) {
            if (this.completionFlag) {
                return;
            }
            if (!this.requestFlag) {
                SynchronizationBarrier.rendezvousStartTime = HighResolutionTimer.now();
                this.requestFlag = true;
                this.initiateCollection();
            }
        }
        Thread.yield();
    }

    synchronized void notifyCompletion() {
        this.completionFlag = true;
    }

    public static void acquireLockoutLock(int n, boolean bl) {
    }

    public static void releaseLockoutLock(int n) {
    }

    public static int queryLockoutLock() {
        return 0;
    }
}

