/*
 * Decompiled with CFR 0.152.
 */
package Memory.Manager;

import Memory.HeapAddress;
import Memory.Manager.CollectorThread;
import Memory.Manager.ScanObject;
import Run_Time.Debug;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Scheduler.jq_NativeThread;

public class GCWorkQueue {
    private static final boolean VALIDATE_BUFFER_PUTS = false;
    private static final boolean trace = false;
    private static final boolean debug = false;
    static final boolean WORKQUEUE_COUNTS = false;
    static final boolean COUNT_GETS_AND_PUTS = false;
    static final boolean MEASURE_WAIT_TIMES = false;
    public static int WORK_BUFFER_SIZE = 4096;
    public static GCWorkQueue workQueue = new GCWorkQueue();
    private int numRealProcessors = 1;
    private int numThreads;
    private int numThreadsWaiting;
    private HeapAddress bufferHead;
    private boolean completionFlag;

    public synchronized void initialSetup(int n) {
        this.numThreads = n;
        this.numThreadsWaiting = 0;
        this.completionFlag = false;
        this.bufferHead = HeapAddress.getNull();
    }

    void reset() {
        boolean bl = false;
        boolean bl2 = false;
        while (this.completionFlag) {
            int n = this.spinABit(5);
        }
    }

    static void resetWorkQBuffers() {
        CollectorThread collectorThread = (CollectorThread)Unsafe.getThreadBlock().getJavaLangThreadObject();
        if (collectorThread.putBufferStart.isNull()) {
            GCWorkQueue.allocatePutBuffer(collectorThread);
        } else {
            collectorThread.putBufferTop = (HeapAddress)collectorThread.putBufferStart.offset(WORK_BUFFER_SIZE - 4);
        }
        if (!collectorThread.getBufferStart.isNull()) {
            GCWorkQueue.freeGetBuffer(collectorThread);
            collectorThread.getBufferStart = HeapAddress.getNull();
        }
        collectorThread.getBufferTop = HeapAddress.getNull();
        collectorThread.getBufferEnd = HeapAddress.getNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addBuffer(HeapAddress heapAddress) {
        GCWorkQueue gCWorkQueue = this;
        synchronized (gCWorkQueue) {
            HeapAddress heapAddress2 = this.bufferHead;
            this.bufferHead = heapAddress;
            heapAddress.poke(heapAddress2);
            if (this.numThreadsWaiting == 0) {
                return;
            }
            this.notify();
            return;
        }
    }

    synchronized HeapAddress getBuffer() {
        if (this.bufferHead.isNull()) {
            return this.bufferHead;
        }
        HeapAddress heapAddress = this.bufferHead;
        this.bufferHead = (HeapAddress)heapAddress.peek();
        return heapAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    HeapAddress getBufferAndWait() {
        boolean bl = false;
        boolean bl2 = false;
        GCWorkQueue gCWorkQueue = this;
        synchronized (gCWorkQueue) {
            if (!this.bufferHead.isNull()) {
                HeapAddress heapAddress = this.bufferHead;
                this.bufferHead = (HeapAddress)heapAddress.peek();
                return heapAddress;
            }
            if (this.numThreads == 1) {
                return HeapAddress.getNull();
            }
            ++this.numThreadsWaiting;
            if (this.numThreadsWaiting == this.numThreads) {
                --this.numThreadsWaiting;
                this.completionFlag = true;
                return HeapAddress.getNull();
            }
        }
        while (true) {
            int n = this.spinABit(5);
            GCWorkQueue gCWorkQueue2 = this;
            synchronized (gCWorkQueue2) {
                if (!this.bufferHead.isNull()) {
                    HeapAddress heapAddress = this.bufferHead;
                    this.bufferHead = (HeapAddress)heapAddress.peek();
                    --this.numThreadsWaiting;
                    return heapAddress;
                }
                if (this.completionFlag) {
                    --this.numThreadsWaiting;
                    if (this.numThreadsWaiting == 0) {
                        this.completionFlag = false;
                    }
                    return HeapAddress.getNull();
                }
            }
        }
    }

    static void putToWorkBuffer(HeapAddress heapAddress) {
        CollectorThread collectorThread = (CollectorThread)Unsafe.getThreadBlock().getJavaLangThreadObject();
        collectorThread.putBufferTop.poke(heapAddress);
        collectorThread.putBufferTop = (HeapAddress)collectorThread.putBufferTop.offset(-4);
        if (collectorThread.putBufferTop.difference(collectorThread.putBufferStart) == 0) {
            workQueue.addBuffer(collectorThread.putBufferStart);
            GCWorkQueue.allocatePutBuffer(collectorThread);
        }
    }

    public static HeapAddress getFromWorkBuffer() {
        CollectorThread collectorThread = (CollectorThread)Unsafe.getThreadBlock().getJavaLangThreadObject();
        collectorThread.getBufferTop = (HeapAddress)collectorThread.getBufferTop.offset(4);
        if (collectorThread.getBufferTop.difference(collectorThread.getBufferEnd) < 0) {
            return (HeapAddress)collectorThread.getBufferTop.peek();
        }
        HeapAddress heapAddress = workQueue.getBuffer();
        if (!heapAddress.isNull()) {
            if (!collectorThread.getBufferStart.isNull()) {
                GCWorkQueue.freeGetBuffer(collectorThread);
            }
            collectorThread.getBufferStart = heapAddress;
            collectorThread.getBufferTop = (HeapAddress)collectorThread.getBufferStart.offset(4);
            collectorThread.getBufferEnd = (HeapAddress)collectorThread.getBufferStart.offset(WORK_BUFFER_SIZE);
            return (HeapAddress)collectorThread.getBufferTop.peek();
        }
        if (collectorThread.putBufferTop.difference(collectorThread.putBufferStart.offset(WORK_BUFFER_SIZE - 4)) < 0) {
            if (!collectorThread.getBufferStart.isNull()) {
                HeapAddress heapAddress2 = collectorThread.putBufferStart;
                collectorThread.putBufferStart = collectorThread.getBufferStart;
                collectorThread.getBufferStart = heapAddress2;
                collectorThread.getBufferEnd = (HeapAddress)collectorThread.getBufferStart.offset(WORK_BUFFER_SIZE);
                heapAddress2 = collectorThread.putBufferTop;
                collectorThread.putBufferTop = (HeapAddress)collectorThread.getBufferTop.offset(-4);
                collectorThread.getBufferTop = heapAddress2;
            } else {
                collectorThread.getBufferStart = collectorThread.putBufferStart;
                collectorThread.getBufferTop = collectorThread.putBufferTop;
                collectorThread.getBufferEnd = (HeapAddress)collectorThread.getBufferStart.offset(WORK_BUFFER_SIZE);
                GCWorkQueue.allocatePutBuffer(collectorThread);
            }
            collectorThread.getBufferTop = (HeapAddress)collectorThread.getBufferTop.offset(4);
            return (HeapAddress)collectorThread.getBufferTop.peek();
        }
        heapAddress = workQueue.getBufferAndWait();
        if (!heapAddress.isNull()) {
            GCWorkQueue.freeGetBuffer(collectorThread);
            collectorThread.getBufferStart = heapAddress;
            collectorThread.getBufferTop = (HeapAddress)collectorThread.getBufferStart.offset(4);
            collectorThread.getBufferEnd = (HeapAddress)collectorThread.getBufferStart.offset(WORK_BUFFER_SIZE);
            return (HeapAddress)collectorThread.getBufferTop.peek();
        }
        collectorThread.getBufferTop = (HeapAddress)collectorThread.getBufferStart.offset(WORK_BUFFER_SIZE - 4);
        return HeapAddress.getNull();
    }

    private static final void allocatePutBuffer(CollectorThread collectorThread) {
        HeapAddress heapAddress;
        if (!collectorThread.extraBuffer.isNull()) {
            heapAddress = collectorThread.extraBuffer;
            collectorThread.extraBuffer = HeapAddress.getNull();
        } else if (!collectorThread.extraBuffer2.isNull()) {
            heapAddress = collectorThread.extraBuffer2;
            collectorThread.extraBuffer2 = HeapAddress.getNull();
        } else {
            heapAddress = (HeapAddress)SystemInterface.syscalloc(WORK_BUFFER_SIZE);
            if (heapAddress.isNull()) {
                Debug.write(" In GCWorkQueue: call to sysMalloc for work buffer returned 0\n");
                SystemInterface.die(1901);
            }
        }
        collectorThread.putBufferStart = heapAddress;
        collectorThread.putBufferTop = (HeapAddress)heapAddress.offset(WORK_BUFFER_SIZE - 4);
    }

    private static final void freeGetBuffer(CollectorThread collectorThread) {
        if (collectorThread.extraBuffer.isNull()) {
            collectorThread.extraBuffer = collectorThread.getBufferStart;
        } else if (collectorThread.extraBuffer2.isNull()) {
            collectorThread.extraBuffer2 = collectorThread.getBufferStart;
        } else {
            SystemInterface.sysfree(collectorThread.getBufferStart);
        }
    }

    private final int spinABit(int n) {
        int n2 = 0;
        if (this.numThreads < this.numRealProcessors) {
            int n3 = 0;
            while (n3 < n * 100) {
                n2 += n3;
                ++n3;
            }
            return n2;
        }
        SystemInterface.yield();
        return 0;
    }

    static void emptyWorkQueue() {
        HeapAddress heapAddress = GCWorkQueue.getFromWorkBuffer();
        while (!heapAddress.isNull()) {
            ScanObject.scanObjectOrArray(heapAddress);
            heapAddress = GCWorkQueue.getFromWorkBuffer();
        }
    }

    static void resetCounters(CollectorThread collectorThread) {
        collectorThread.copyCount = 0;
        collectorThread.rootWorkCount = 0;
        collectorThread.putWorkCount = 0;
        collectorThread.getWorkCount = 0;
        collectorThread.swapBufferCount = 0;
        collectorThread.putBufferCount = 0;
        collectorThread.getBufferCount = 0;
    }

    public static void resetWaitTimes(CollectorThread collectorThread) {
        collectorThread.bufferWaitCount = 0;
        collectorThread.bufferWaitTime = 0.0;
        collectorThread.finishWaitTime = 0.0;
    }

    static void saveAllCounters() {
        int n = 0;
        while (n < jq_NativeThread.native_threads.length) {
            CollectorThread collectorThread = (CollectorThread)jq_NativeThread.native_threads[n].getCurrentThread().getJavaLangThreadObject();
            GCWorkQueue.saveCounters(collectorThread);
            GCWorkQueue.resetCounters(collectorThread);
            ++n;
        }
    }

    static void resetAllCounters() {
        int n = 0;
        while (n < jq_NativeThread.native_threads.length) {
            CollectorThread collectorThread = (CollectorThread)jq_NativeThread.native_threads[n].getCurrentThread().getJavaLangThreadObject();
            GCWorkQueue.resetCounters(collectorThread);
            ++n;
        }
    }

    static void saveCounters(CollectorThread collectorThread) {
        collectorThread.copyCount1 = collectorThread.copyCount;
        collectorThread.rootWorkCount1 = collectorThread.rootWorkCount;
        collectorThread.putWorkCount1 = collectorThread.putWorkCount;
        collectorThread.getWorkCount1 = collectorThread.getWorkCount;
        collectorThread.swapBufferCount1 = collectorThread.swapBufferCount;
        collectorThread.putBufferCount1 = collectorThread.putBufferCount;
        collectorThread.getBufferCount1 = collectorThread.getBufferCount;
        GCWorkQueue.resetCounters(collectorThread);
    }

    static void saveAllWaitTimes() {
        int n = 0;
        while (n < jq_NativeThread.native_threads.length) {
            CollectorThread collectorThread = (CollectorThread)jq_NativeThread.native_threads[n].getCurrentThread().getJavaLangThreadObject();
            GCWorkQueue.saveWaitTimes(collectorThread);
            GCWorkQueue.resetWaitTimes(collectorThread);
            ++n;
        }
    }

    static void resetAllWaitTimes() {
        int n = 0;
        while (n < jq_NativeThread.native_threads.length) {
            CollectorThread collectorThread = (CollectorThread)jq_NativeThread.native_threads[n].getCurrentThread().getJavaLangThreadObject();
            GCWorkQueue.resetWaitTimes(collectorThread);
            ++n;
        }
    }

    static void saveWaitTimes(CollectorThread collectorThread) {
        collectorThread.bufferWaitCount1 = collectorThread.bufferWaitCount;
        collectorThread.bufferWaitTime1 = collectorThread.bufferWaitTime;
        collectorThread.finishWaitTime1 = collectorThread.finishWaitTime;
        GCWorkQueue.resetWaitTimes(collectorThread);
    }

    static void printAllWaitTimes() {
        int n = 0;
        while (n < jq_NativeThread.native_threads.length) {
            CollectorThread collectorThread = (CollectorThread)jq_NativeThread.native_threads[n].getCurrentThread().getJavaLangThreadObject();
            Debug.write(n);
            Debug.write(" number of waits ");
            Debug.write(collectorThread.bufferWaitCount1);
            Debug.write("  buffer wait time ");
            Debug.write((int)(collectorThread.bufferWaitTime1 * 1000000.0));
            Debug.write("(us)  finish wait time ");
            Debug.write((int)(collectorThread.finishWaitTime1 * 1000000.0));
            Debug.write("(us)\n");
            ++n;
        }
    }

    static void printAllCounters() {
        int n = 0;
        while (n < jq_NativeThread.native_threads.length) {
            CollectorThread collectorThread = (CollectorThread)jq_NativeThread.native_threads[n].getCurrentThread().getJavaLangThreadObject();
            Debug.write(n);
            Debug.write(" copied ");
            Debug.write(collectorThread.copyCount1);
            Debug.write(" roots ");
            Debug.write(collectorThread.rootWorkCount1);
            Debug.write(" puts ");
            Debug.write(collectorThread.putWorkCount1);
            Debug.write(" gets ");
            Debug.write(collectorThread.getWorkCount1);
            Debug.write(" put bufs ");
            Debug.write(collectorThread.putBufferCount1);
            Debug.write(" get bufs ");
            Debug.write(collectorThread.getBufferCount1);
            Debug.write(" swaps ");
            Debug.write(collectorThread.swapBufferCount1);
            Debug.write("\n");
            ++n;
        }
    }
}

