/*
 * Decompiled with CFR 0.152.
 */
package Memory.Manager;

import Allocator.ObjectLayoutMethods;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Memory.Heap.BootHeap;
import Memory.Heap.Heap;
import Memory.HeapAddress;
import Run_Time.Debug;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Scheduler.jq_NativeThread;

public class GCUtil {
    private static final boolean TRACE = false;
    static Object vtableForArrayType = jq_Array._class.getVTable();
    static Object vtableForClassType = jq_Class._class.getVTable();
    static Object vtableForPrimitiveType = jq_Primitive._class.getVTable();
    private static final Object outOfMemoryLock = new Object();
    private static boolean outOfMemoryReported = false;

    public static void boot() {
    }

    public static boolean refInVM(HeapAddress heapAddress) {
        return Heap.refInAnyHeap(heapAddress);
    }

    public static boolean addrInVM(HeapAddress heapAddress) {
        return Heap.addrInAnyHeap(heapAddress);
    }

    public static boolean refInBootImage(HeapAddress heapAddress) {
        return BootHeap.INSTANCE.refInHeap(heapAddress);
    }

    public static boolean refInHeap(HeapAddress heapAddress) {
        boolean bl = false;
        if (GCUtil.refInVM(heapAddress) && !GCUtil.refInBootImage(heapAddress)) {
            bl = true;
        }
        return bl;
    }

    public static boolean addrInBootImage(HeapAddress heapAddress) {
        return BootHeap.INSTANCE.addrInHeap(heapAddress);
    }

    public static boolean validType(HeapAddress heapAddress) {
        boolean bl;
        if (!GCUtil.refInVM(heapAddress)) {
            return false;
        }
        Object object = ObjectLayoutMethods.getVTable(heapAddress.asObject());
        boolean bl2 = false;
        if (object == vtableForClassType || object == vtableForArrayType || object == vtableForPrimitiveType) {
            bl2 = true;
        }
        if (!(bl = bl2)) {
            Debug.writeln("vtable is invalid: ", HeapAddress.addressOf(object));
        }
        return bl;
    }

    public static boolean validObject(Object object) {
        return GCUtil.validRef(HeapAddress.addressOf(object));
    }

    public static boolean validRef(HeapAddress heapAddress) {
        if (heapAddress.isNull()) {
            return true;
        }
        if (!GCUtil.refInVM(heapAddress)) {
            Debug.write("validRef: REF outside heap, ref = ");
            Debug.write(heapAddress);
            Debug.write("\n");
            Heap.showAllHeaps();
            return false;
        }
        Object object = ObjectLayoutMethods.getVTable(heapAddress);
        HeapAddress heapAddress2 = HeapAddress.addressOf(object);
        if (!GCUtil.refInVM(heapAddress2)) {
            Debug.write("validRef: vtable outside heap, ref = ");
            Debug.write(heapAddress);
            Debug.write(" tib = ");
            Debug.write(heapAddress2);
            Debug.write("\n");
            return false;
        }
        if (heapAddress2.isNull()) {
            Debug.write("validRef: vtable is Zero! ");
            Debug.write(heapAddress);
            Debug.write("\n");
            return false;
        }
        HeapAddress heapAddress3 = (HeapAddress)heapAddress2.peek();
        if (!GCUtil.validType(heapAddress3)) {
            Debug.write("validRef: invalid TYPE, ref = ");
            Debug.write(heapAddress);
            Debug.write(" tib = ");
            Debug.write(heapAddress2);
            Debug.write(" type = ");
            Debug.write(heapAddress3);
            Debug.write("\n");
            return false;
        }
        return true;
    }

    public static void dumpRef(HeapAddress heapAddress) {
        Debug.write("REF=");
        if (heapAddress.isNull()) {
            Debug.write("NULL\n");
            return;
        }
        Debug.write(heapAddress);
        if (!GCUtil.refInVM(heapAddress)) {
            Debug.write(" (REF OUTSIDE OF HEAP)\n");
            return;
        }
        HeapAddress heapAddress2 = HeapAddress.addressOf(ObjectLayoutMethods.getVTable(heapAddress.asObject()));
        if (!GCUtil.refInVM(heapAddress2)) {
            Debug.write(" (INVALID TIB: CLASS NOT ACCESSIBLE)\n");
            return;
        }
        jq_Reference jq_Reference2 = jq_Reference.getTypeOf(heapAddress.asObject());
        HeapAddress heapAddress3 = HeapAddress.addressOf(jq_Reference2);
        Debug.write(" TYPE=");
        Debug.write(heapAddress3);
        if (!GCUtil.validType(heapAddress3)) {
            Debug.write(" (INVALID TYPE: CLASS NOT ACCESSIBLE)\n");
            return;
        }
        Debug.write(" CLASS=");
        jq_Reference2.getDesc().debugWrite();
        Debug.write("\n");
    }

    public static void printclass(HeapAddress heapAddress) {
        jq_Reference jq_Reference2;
        if (GCUtil.validRef(heapAddress) && GCUtil.validRef(HeapAddress.addressOf(jq_Reference2 = jq_Reference.getTypeOf(heapAddress.asObject())))) {
            jq_Reference2.getDesc().debugWrite();
        }
    }

    static void dumpProcessorsArray() {
        Debug.write("jq_NativeThread.native_threads[]:\n");
        int n = 0;
        while (n < jq_NativeThread.native_threads.length) {
            jq_NativeThread jq_NativeThread2 = jq_NativeThread.native_threads[n];
            Debug.write(" i = ");
            Debug.write(n);
            if (jq_NativeThread2 == null) {
                Debug.write(" st is NULL");
            } else {
                Debug.write(", id = ");
                Debug.write(jq_NativeThread2.getIndex());
                Debug.write(", address = ");
                Debug.write(HeapAddress.addressOf(jq_NativeThread2));
            }
            Debug.write("\n");
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void outOfMemory(String string, int n, String string2) {
        Object object = outOfMemoryLock;
        synchronized (object) {
            if (!outOfMemoryReported) {
                outOfMemoryReported = true;
                Unsafe.getThreadBlock().disableThreadSwitch();
                Debug.writeln("\nOutOfMemoryError");
                Debug.write("Failing heap was ");
                Debug.writeln(string);
                Debug.writeln("Current heap size = ", n / 1024, " Kb");
                Debug.write("Specify a larger heap using ");
                Debug.writeln(string2);
                SystemInterface.die(-5);
            }
        }
        while (true) {
            // Infinite loop
        }
    }
}

