/*
 * Decompiled with CFR 0.152.
 */
package Memory.Heap;

import Clazz.jq_Array;
import Clazz.jq_Class;
import Memory.Heap.Heap;
import Memory.HeapAddress;
import Run_Time.Debug;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Util.Assert;

public class MallocHeap
extends Heap {
    void init() {
    }

    public int totalMemory() {
        return this.getSize();
    }

    public Object atomicAllocateObject(jq_Class jq_Class2) {
        Unsafe.getThreadBlock().disableThreadSwitch();
        Object object = this.allocateObject(jq_Class2);
        Unsafe.getThreadBlock().enableThreadSwitch();
        return object;
    }

    public Object atomicAllocateArray(jq_Array jq_Array2, int n) {
        Unsafe.getThreadBlock().disableThreadSwitch();
        Object object = this.allocateArray(jq_Array2, n);
        Unsafe.getThreadBlock().enableThreadSwitch();
        return object;
    }

    public void atomicFreeArray(Object object) {
        Unsafe.getThreadBlock().disableThreadSwitch();
        HeapAddress heapAddress = (HeapAddress)HeapAddress.addressOf(object).offset(-12);
        this.free(heapAddress);
        Unsafe.getThreadBlock().enableThreadSwitch();
    }

    public void free(HeapAddress heapAddress) {
        SystemInterface.sysfree(heapAddress);
    }

    protected synchronized HeapAddress allocateZeroedMemory(int n) {
        HeapAddress heapAddress = (HeapAddress)SystemInterface.syscalloc(n);
        if (heapAddress.isNull()) {
            Debug.writeln("Panic!  Cannot allocate ", n, "bytes.");
            Assert.UNREACHABLE();
        }
        HeapAddress heapAddress2 = (HeapAddress)heapAddress.offset(n);
        if (this.start.isNull() || heapAddress.difference(this.start) < 0) {
            this.start = heapAddress;
        }
        if (heapAddress2.difference(this.end) > 0) {
            this.end = heapAddress2;
        }
        return heapAddress;
    }

    protected void postAllocationProcessing(Object object) {
    }

    public MallocHeap() {
        super("Malloc Heap");
    }
}

