/*
 * Decompiled with CFR 0.152.
 */
package Memory.Heap;

import Allocator.ObjectLayoutMethods;
import Clazz.jq_Array;
import Memory.Address;
import Memory.Heap.Heap;
import Memory.HeapAddress;
import Run_Time.Debug;
import Run_Time.SystemInterface;
import Util.Assert;

public class ImmortalHeap
extends Heap {
    private HeapAddress allocationCursor;
    private int markValue;

    public void init(int n) {
        this.start = (HeapAddress)SystemInterface.syscalloc(n);
        if (this.start.isNull()) {
            Debug.writeln("Panic!  Cannot allocate ", n, "bytes.");
            Assert.UNREACHABLE();
        }
        this.end = (HeapAddress)this.start.offset(n);
        this.allocationCursor = this.start;
    }

    public int totalMemory() {
        return this.end.difference(this.start);
    }

    public int freeMemory() {
        return this.end.difference(this.allocationCursor);
    }

    public boolean mark(HeapAddress heapAddress) {
        Object object = heapAddress.asObject();
        return ObjectLayoutMethods.testAndMark(object, this.markValue);
    }

    public boolean isLive(HeapAddress heapAddress) {
        Object object = heapAddress.asObject();
        return ObjectLayoutMethods.testMarkBit(object, this.markValue);
    }

    public void startCollect() {
        this.markValue ^= 4;
    }

    public Object allocateAlignedArray(jq_Array jq_Array2, int n, int n2) {
        int n3 = jq_Array2.getInstanceSize(n);
        n3 = Address.alignInt(n3, HeapAddress.logSize());
        Object object = jq_Array2.getVTable();
        int n4 = 12;
        HeapAddress heapAddress = this.allocateZeroedMemory(n3, n2, n4);
        Object object2 = ObjectLayoutMethods.initializeArray(heapAddress, object, n, n3);
        this.postAllocationProcessing(object2);
        return object2;
    }

    protected HeapAddress allocateZeroedMemory(int n) {
        return this.allocateZeroedMemory(n, 2, 0);
    }

    protected HeapAddress allocateZeroedMemory(int n, int n2) {
        return this.allocateZeroedMemory(n, n2, 0);
    }

    protected HeapAddress allocateZeroedMemory(int n, int n2, int n3) {
        HeapAddress heapAddress = this.allocateInternal(n, n2, n3);
        SystemInterface.mem_set(heapAddress, n, (byte)0);
        return heapAddress;
    }

    private final synchronized HeapAddress allocateInternal(int n, int n2, int n3) {
        this.allocationCursor = (HeapAddress)this.allocationCursor.offset(n3);
        HeapAddress heapAddress = this.allocationCursor = (HeapAddress)this.allocationCursor.align(n2);
        this.allocationCursor = (HeapAddress)this.allocationCursor.offset(n - n3);
        if (this.allocationCursor.difference(this.end) > 0) {
            Assert.UNREACHABLE("Immortal heap space exhausted");
        }
        HeapAddress heapAddress2 = (HeapAddress)heapAddress.offset(-n3);
        return heapAddress2;
    }

    protected void postAllocationProcessing(Object object) {
        ObjectLayoutMethods.writeMarkBit(object, this.markValue);
    }

    public ImmortalHeap() {
        super("Immortal Heap");
    }
}

