/*
 * Decompiled with CFR 0.152.
 */
package Memory.Heap;

import Allocator.ObjectLayoutMethods;
import Memory.Heap.Heap;
import Memory.HeapAddress;
import Util.Assert;

public class BootHeap
extends Heap {
    public static final HeapAddress DATA_SECTION_START = HeapAddress.getNull();
    public static final HeapAddress DATA_SECTION_END = HeapAddress.getNull();
    public static final BootHeap INSTANCE = new BootHeap();
    private int markValue;

    static void init() {
        BootHeap.INSTANCE.start = DATA_SECTION_START;
        BootHeap.INSTANCE.end = DATA_SECTION_END;
    }

    protected HeapAddress allocateZeroedMemory(int n) {
        Assert.UNREACHABLE("allocateZeroedMemory on BootHeap forbidden");
        return null;
    }

    protected void postAllocationProcessing(Object object) {
    }

    public boolean mark(HeapAddress heapAddress) {
        Object object = heapAddress.asObject();
        return ObjectLayoutMethods.testAndMark(object, this.markValue);
    }

    public boolean isLive(HeapAddress heapAddress) {
        Object object = heapAddress.asObject();
        return ObjectLayoutMethods.testMarkBit(object, this.markValue);
    }

    public void startCollect() {
        this.markValue ^= 4;
    }

    private BootHeap() {
        super("Boot Image Heap");
    }
}

