/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Allocator.SimpleAllocator;
import Bootstrap.MethodInvocation;
import Bootstrap.PrimordialClassLoader;
import ClassLib.ClassLibInterface;
import Clazz.jq_Class;
import Clazz.jq_NameAndDesc;
import Clazz.jq_StaticMethod;
import Compil3r.CompilationState;
import Main.TraceFlags;
import Main.jq;
import Run_Time.Debug;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Scheduler.jq_InterrupterThread;
import Scheduler.jq_MainThread;
import Scheduler.jq_NativeThread;
import Scheduler.jq_Thread;
import UTF.Utf8;
import Util.Assert;
import Util.Strings;
import java.util.Iterator;

public abstract class JoeqVM {
    public static void boot() throws Throwable {
        Object object;
        Object object2;
        int n;
        try {
            jq_NativeThread.initInitialNativeThread();
            jq_NativeThread.initBreakThread();
            jq_NativeThread.initGCThread();
            CompilationState.DEFAULT = new CompilationState.DynamicCompilation();
            ClassLibInterface.DEFAULT.initializeSystemClass();
        }
        catch (Throwable throwable) {
            SystemInterface.debugwriteln("Exception occurred during virtual machine initialization");
            SystemInterface.debugwriteln("Exception: " + throwable);
            if (System.err != null) {
                throwable.printStackTrace(System.err);
            }
            return;
        }
        int n2 = SystemInterface.main_argc();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            n = SystemInterface.main_argv_length(n3);
            object2 = new byte[n];
            SystemInterface.main_argv(n3, (byte[])object2);
            stringArray[n3] = new String((byte[])object2);
            ++n3;
        }
        String string = ".";
        n = 0;
        block5: while (true) {
            int n4;
            if (n == stringArray.length) {
                JoeqVM.printUsage();
                return;
            }
            if (stringArray[n].equals("-cp") || stringArray[n].equals("-classpath")) {
                string = stringArray[++n];
                ++n;
                if (string == null) continue;
                object2 = PrimordialClassLoader.classpaths(string);
                while (true) {
                    if (!object2.hasNext()) continue block5;
                    String string2 = (String)object2.next();
                    PrimordialClassLoader.loader.addToClasspath(string2);
                }
            }
            if (stringArray[n].equals("-nt") || stringArray[n].equals("-native_threads")) {
                jq.NumOfNativeThreads = Integer.parseInt(stringArray[++n]);
                ++n;
                continue;
            }
            if (stringArray[n].startsWith("-D")) {
                String string3;
                n4 = stringArray[n].indexOf(61);
                if (n4 != -1) {
                    object2 = stringArray[n].substring(2, n4);
                    string3 = stringArray[n].substring(n4 + 1);
                } else {
                    object2 = stringArray[n].substring(2);
                    string3 = "";
                }
                System.setProperty((String)object2, string3);
                ++n;
                continue;
            }
            if (stringArray[n].startsWith("-mx")) {
                object2 = stringArray[n].substring(3);
                int n5 = 1;
                if (((String)object2).endsWith("m") || ((String)object2).endsWith("M")) {
                    n5 = 0x100000;
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                } else if (((String)object2).endsWith("k") || ((String)object2).endsWith("K")) {
                    n5 = 1024;
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                }
                SimpleAllocator.MAX_MEMORY = n4 = n5 * Integer.parseInt((String)object2);
                ++n;
                continue;
            }
            int n6 = TraceFlags.setTraceFlag(stringArray, n);
            if (n == n6) break;
            n = n6;
        }
        if (jq.on_vm_startup != null) {
            Iterator iterator = jq.on_vm_startup.iterator();
            while (iterator.hasNext()) {
                MethodInvocation methodInvocation = (MethodInvocation)iterator.next();
                try {
                    methodInvocation.invoke();
                }
                catch (Throwable throwable) {
                    SystemInterface.debugwriteln("Exception occurred while initializing the virtual machine");
                    SystemInterface.debugwriteln(throwable.toString());
                    throwable.printStackTrace(System.err);
                }
            }
        }
        JoeqVM.handleSystemProperties();
        jq_Thread jq_Thread2 = Unsafe.getThreadBlock();
        jq_NativeThread jq_NativeThread2 = jq_Thread2.getNativeThread();
        jq_NativeThread.initNativeThreads(jq_NativeThread2, jq.NumOfNativeThreads);
        if (jq_Class.TRACE_REPLACE_CLASS) {
            SystemInterface.debugwriteln(Strings.lineSep + "STARTING REPLACEMENT of classes: " + jq_Class.classToReplace);
        }
        Object object3 = jq_Class.classToReplace.iterator();
        while (object3.hasNext()) {
            object = (String)object3.next();
            PrimordialClassLoader.loader.replaceClass((String)object);
        }
        if (jq_Class.TRACE_REPLACE_CLASS) {
            SystemInterface.debugwriteln(Strings.lineSep + "DONE with Classes Replacement!");
        }
        object3 = stringArray[n];
        object = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("L" + ((String)object3).replace('.', '/') + ';');
        ((jq_Class)object).load();
        jq_StaticMethod jq_StaticMethod2 = ((jq_Class)object).getStaticMethod(new jq_NameAndDesc(Utf8.get("main"), Utf8.get("([Ljava/lang/String;)V")));
        if (jq_StaticMethod2 == null) {
            System.err.println("Class " + (String)object3 + " does not contain a main method!");
            return;
        }
        if (!jq_StaticMethod2.isPublic()) {
            System.err.println("Method " + jq_StaticMethod2 + " is not public!");
            return;
        }
        ((jq_Class)object).cls_initialize();
        String[] stringArray2 = new String[stringArray.length - n - 1];
        System.arraycopy(stringArray, n + 1, stringArray2, 0, stringArray2.length);
        jq_MainThread jq_MainThread2 = new jq_MainThread(jq_StaticMethod2, stringArray2);
        jq_MainThread2.start();
        jq_NativeThread.startNativeThreads();
        jq_NativeThread2.nativeThreadEntry();
        Assert.UNREACHABLE();
    }

    public static void handleSystemProperties() {
        String string = System.getProperty("scheduler.quanta");
        if (string != null) {
            try {
                jq_InterrupterThread.QUANTA = Integer.parseInt(string);
                Debug.write("Scheduler quanta is ");
                Debug.writeln(jq_InterrupterThread.QUANTA);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.writeln("Bad scheduler.quanta, ignoring.");
            }
        }
        if ((string = System.getProperty("scheduler.transfer")) != null) {
            try {
                jq_NativeThread.TRANSFER_THRESHOLD = Float.parseFloat(string);
                Debug.write("Scheduler transfer threshold is ");
                System.err.println(jq_NativeThread.TRANSFER_THRESHOLD);
            }
            catch (NumberFormatException numberFormatException) {
                Debug.writeln("Bad scheduler.quanta, ignoring.");
            }
        }
    }

    public static void printUsage() {
        System.out.println("Usage: joeq <classname> <parameters>");
    }
}

