/*
 * Decompiled with CFR 0.152.
 */
package Linker.ELF;

import Linker.ELF.ELF;
import Linker.ELF.ELFConstants;
import Linker.ELF.RelocAEntry;
import Linker.ELF.RelocEntry;
import Linker.ELF.SymbolTableEntry;
import Util.Assert;
import Util.Collections.AppendIterator;
import Util.Strings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class Section
implements ELFConstants {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    protected String name;
    protected int index;
    protected int flags;
    protected int addr;

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public abstract int getType();

    public int getFlags() {
        return this.flags;
    }

    public int getAddr() {
        return this.addr;
    }

    public abstract int getSize();

    public abstract int getLink();

    public abstract int getInfo();

    public abstract int getAddrAlign();

    public abstract int getEntSize();

    public void setIndex(int n) {
        this.index = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setAddr(int n) {
        this.addr = n;
    }

    public void setWrite() {
        this.flags |= 1;
    }

    public void clearWrite() {
        this.flags &= 0xFFFFFFFE;
    }

    public void setAlloc() {
        this.flags |= 2;
    }

    public void clearAlloc() {
        this.flags &= 0xFFFFFFFD;
    }

    public void setExecInstr() {
        this.flags |= 4;
    }

    public void clearExecInstr() {
        this.flags &= 0xFFFFFFFB;
    }

    public void writeHeader(ELF eLF, int n) throws IOException {
        eLF.write_sectionname(this.getName());
        eLF.write_word(this.getType());
        eLF.write_word(this.getFlags());
        eLF.write_addr(this.getAddr());
        eLF.write_off(n);
        eLF.write_word(this.getSize());
        eLF.write_word(this.getLink());
        eLF.write_word(this.getInfo());
        eLF.write_word(this.getAddrAlign());
        eLF.write_word(this.getEntSize());
    }

    public abstract void writeData(ELF var1) throws IOException;

    public abstract void load(UnloadedSection var1, ELF var2) throws IOException;

    public static int getHeaderSize() {
        return 40;
    }

    protected Section(String string, int n, int n2) {
        this.name = string;
        this.flags = n;
        this.addr = n2;
    }

    protected Section(int n, int n2) {
        this.flags = n;
        this.addr = n2;
    }

    public static class UnloadedSection {
        int sectionNameIndex;
        int type;
        int flags;
        int addr;
        int offset;
        int size;
        int link;
        int info;
        int addralign;
        int entsize;

        public void readHeader(ELF eLF) throws IOException {
            this.sectionNameIndex = eLF.read_word();
            this.type = eLF.read_word();
            this.flags = eLF.read_word();
            this.addr = eLF.read_addr();
            this.offset = eLF.read_off();
            this.size = eLF.read_word();
            this.link = eLF.read_word();
            this.info = eLF.read_word();
            this.addralign = eLF.read_word();
            this.entsize = eLF.read_word();
        }

        public Section parseHeader() throws IOException {
            switch (this.type) {
                case 0: {
                    if (this.flags != 0) {
                        System.err.println("Warning! Null section flags is not 0: " + this.flags);
                    }
                    if (this.addr != 0) {
                        System.err.println("Warning! Null section addr is not 0: " + this.addr);
                    }
                    if (this.offset != 0) {
                        System.err.println("Warning! Null section offset is not 0: " + this.offset);
                    }
                    if (this.size != 0) {
                        System.err.println("Warning! Null section size is not 0: " + this.size);
                    }
                    if (this.link != 0) {
                        System.err.println("Warning! Null section link is not SHN_UNDEF: " + this.link);
                    }
                    if (this.info != 0) {
                        System.err.println("Warning! Null section info is not 0: " + this.info);
                    }
                    if (this.addralign != 0) {
                        System.err.println("Warning! Null section addralign is not 0: " + this.addralign);
                    }
                    if (this.entsize != 0) {
                        System.err.println("Warning! Null section entsize is not 0: " + this.entsize);
                    }
                    return NullSection.INSTANCE;
                }
                case 1: {
                    boolean bl = false;
                    if (this.link == 0) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    boolean bl2 = false;
                    if (this.info == 0) {
                        bl2 = true;
                    }
                    Assert._assert(bl2);
                    boolean bl3 = false;
                    if (this.entsize == 0) {
                        bl3 = true;
                    }
                    Assert._assert(bl3);
                    return ProgBitsSectionImpl.empty(this.flags, this.addr, this.addralign);
                }
                case 2: {
                    boolean bl = false;
                    if (this.addralign == 4) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    boolean bl4 = false;
                    if (this.entsize == SymbolTableEntry.getEntrySize()) {
                        bl4 = true;
                    }
                    Assert._assert(bl4);
                    return SymTabSection.empty(this.flags, this.addr);
                }
                case 3: {
                    if (this.link != 0) {
                        System.err.println("Warning! Strtab section link is not SHN_UNDEF: " + this.link);
                    }
                    if (this.info != 0) {
                        System.err.println("Warning! Strtab section info is not 0: " + this.info);
                    }
                    if (this.addralign != 1) {
                        System.err.println("Warning! Strtab section addralign is not 0: " + this.addralign);
                    }
                    if (this.entsize != 0) {
                        System.err.println("Warning! Strtab section entsize is not 0: " + this.entsize);
                    }
                    return StrTabSection.empty(this.flags, this.addr);
                }
                case 4: 
                case 5: 
                case 6: 
                case 11: {
                    Assert.TODO();
                    return null;
                }
                case 7: {
                    if (this.link != 0) {
                        System.err.println("Warning! Note section link is not SHN_UNDEF: " + this.link);
                    }
                    if (this.info != 0) {
                        System.err.println("Warning! Note section info is not 0: " + this.info);
                    }
                    if (this.addralign != 1) {
                        System.err.println("Warning! Note section addralign is not 0: " + this.addralign);
                    }
                    if (this.entsize != 0) {
                        System.err.println("Warning! Note section entsize is not 0: " + this.entsize);
                    }
                    return NoteSection.empty(this.flags, this.addr);
                }
                case 8: {
                    if (this.link != 0) {
                        System.err.println("Warning! Nobits section link is not SHN_UNDEF: " + this.link);
                    }
                    if (this.info != 0) {
                        System.err.println("Warning! Nobits section info is not 0: " + this.info);
                    }
                    if (this.entsize != 0) {
                        System.err.println("Warning! Nobits section entsize is not 0: " + this.entsize);
                    }
                    return NoBitsSection.empty(this.flags, this.addr, this.size, this.addralign);
                }
                case 9: {
                    boolean bl = false;
                    if (this.addralign == 4) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    boolean bl5 = false;
                    if (this.entsize == RelocEntry.getEntrySize()) {
                        bl5 = true;
                    }
                    Assert._assert(bl5);
                    return RelSection.empty(this.flags, this.addr);
                }
            }
            throw new IOException("bad section type: " + Strings.hex(this.type));
        }

        public UnloadedSection(ELF eLF) throws IOException {
            this.readHeader(eLF);
        }
    }

    public static abstract class FakeSection
    extends Section {
        public int getEntSize() {
            Assert.UNREACHABLE();
            return 0;
        }

        public int getInfo() {
            Assert.UNREACHABLE();
            return 0;
        }

        public int getAddrAlign() {
            Assert.UNREACHABLE();
            return 0;
        }

        public int getLink() {
            Assert.UNREACHABLE();
            return 0;
        }

        public int getSize() {
            Assert.UNREACHABLE();
            return 0;
        }

        public int getType() {
            Assert.UNREACHABLE();
            return 0;
        }

        public int getFlags() {
            Assert.UNREACHABLE();
            return 0;
        }

        public int getAddr() {
            Assert.UNREACHABLE();
            return 0;
        }

        public int getIndex() {
            return this.index;
        }

        public void setName(String string) {
            Assert.UNREACHABLE();
        }

        public void setAddr(int n) {
            Assert.UNREACHABLE();
        }

        public void setWrite() {
            Assert.UNREACHABLE();
        }

        public void clearWrite() {
            Assert.UNREACHABLE();
        }

        public void setAlloc() {
            Assert.UNREACHABLE();
        }

        public void clearAlloc() {
            Assert.UNREACHABLE();
        }

        public void setExecInstr() {
            Assert.UNREACHABLE();
        }

        public void clearExecInstr() {
            Assert.UNREACHABLE();
        }

        public void writeData(ELF eLF) throws IOException {
            Assert.UNREACHABLE();
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
            Assert.UNREACHABLE();
        }

        FakeSection(String string, int n) {
            super(string, 0, 0);
            this.index = n;
        }
    }

    public static class AbsSection
    extends FakeSection {
        public static final AbsSection INSTANCE = new AbsSection();

        private AbsSection() {
            super("ABS", 65521);
        }
    }

    public static class NullSection
    extends Section {
        public static final NullSection INSTANCE = new NullSection();

        public int getIndex() {
            return 0;
        }

        public int getType() {
            return 0;
        }

        public int getSize() {
            return 0;
        }

        public int getLink() {
            return 0;
        }

        public int getInfo() {
            return 0;
        }

        public int getAddrAlign() {
            return 0;
        }

        public int getEntSize() {
            return 0;
        }

        public void setIndex(int n) {
            boolean bl = false;
            if (n == 0) {
                bl = true;
            }
            Assert._assert(bl);
        }

        public void setName(String string) {
            Assert._assert(string.equals(""));
        }

        public void setAddr(int n) {
            boolean bl = false;
            if (n == 0) {
                bl = true;
            }
            Assert._assert(bl);
        }

        public void setOffset(int n) {
            boolean bl = false;
            if (n == 0) {
                bl = true;
            }
            Assert._assert(bl);
        }

        public void setWrite() {
            Assert.UNREACHABLE();
        }

        public void setAlloc() {
            Assert.UNREACHABLE();
        }

        public void setExecInstr() {
            Assert.UNREACHABLE();
        }

        public void writeData(ELF eLF) throws IOException {
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
        }

        private NullSection() {
            super("", 0, 0);
        }
    }

    public static abstract class ProgBitsSection
    extends Section {
        public final int getType() {
            return 1;
        }

        public final int getLink() {
            return 0;
        }

        public final int getInfo() {
            return 0;
        }

        public final int getEntSize() {
            return 0;
        }

        public ProgBitsSection(String string, int n, int n2) {
            super(string, n, n2);
        }

        protected ProgBitsSection(int n, int n2) {
            super(n, n2);
        }
    }

    public static class ProgBitsSectionImpl
    extends ProgBitsSection {
        protected int addralign;
        protected byte[] data;

        public final int getSize() {
            return this.data.length;
        }

        public final int getAddr() {
            return this.addr;
        }

        public final int getAddrAlign() {
            return this.addralign;
        }

        public void writeData(ELF eLF) throws IOException {
            eLF.write_bytes(this.data);
        }

        public static ProgBitsSectionImpl empty(int n, int n2, int n3) {
            return new ProgBitsSectionImpl(n, n2, n3);
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
            if (unloadedSection.sectionNameIndex != 0) {
                StrTabSection strTabSection = eLF.getSectionHeaderStringTable();
                if (strTabSection == null) {
                    throw new IOException();
                }
                this.name = strTabSection.getString(unloadedSection.sectionNameIndex);
            }
            this.data = new byte[unloadedSection.size];
            eLF.set_position(unloadedSection.offset);
            eLF.read_bytes(this.data);
        }

        public ProgBitsSectionImpl(String string, int n, int n2, int n3, byte[] byArray) {
            super(string, n, n2);
            this.addralign = n3;
            this.data = byArray;
        }

        protected ProgBitsSectionImpl(int n, int n2, int n3) {
            super(n, n2);
            this.addralign = n3;
        }
    }

    public static class SymTabSection
    extends Section {
        List localSymbols;
        List globalSymbols;
        StrTabSection stringTable;

        public void addSymbol(SymbolTableEntry symbolTableEntry) {
            this.stringTable.addString(symbolTableEntry.getName());
            if (symbolTableEntry.getBind() == 0) {
                this.localSymbols.add(symbolTableEntry);
            } else {
                this.globalSymbols.add(symbolTableEntry);
            }
        }

        public int getSize() {
            return (this.localSymbols.size() + this.globalSymbols.size()) * SymbolTableEntry.getEntrySize();
        }

        public int getAddrAlign() {
            return 4;
        }

        public final int getType() {
            return 2;
        }

        public final int getLink() {
            return this.stringTable.getIndex();
        }

        public final int getInfo() {
            return this.localSymbols.size();
        }

        public final int getEntSize() {
            return SymbolTableEntry.getEntrySize();
        }

        public void setIndices() {
            AppendIterator appendIterator = new AppendIterator(this.localSymbols.iterator(), this.globalSymbols.iterator());
            int n = -1;
            while (appendIterator.hasNext()) {
                SymbolTableEntry symbolTableEntry = (SymbolTableEntry)appendIterator.next();
                symbolTableEntry.setIndex(++n);
            }
        }

        public SymbolTableEntry getSymbolTableEntry(int n) {
            if (n < this.localSymbols.size()) {
                return (SymbolTableEntry)this.localSymbols.get(n);
            }
            return (SymbolTableEntry)this.globalSymbols.get(n -= this.localSymbols.size());
        }

        public void writeData(ELF eLF) throws IOException {
            AppendIterator appendIterator = new AppendIterator(this.localSymbols.iterator(), this.globalSymbols.iterator());
            while (appendIterator.hasNext()) {
                SymbolTableEntry symbolTableEntry = (SymbolTableEntry)appendIterator.next();
                symbolTableEntry.write(eLF, this.stringTable);
            }
        }

        public static SymTabSection empty(int n, int n2) {
            return new SymTabSection(n, n2);
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
            if (unloadedSection.sectionNameIndex != 0) {
                StrTabSection strTabSection = eLF.getSectionHeaderStringTable();
                if (strTabSection == null) {
                    throw new IOException();
                }
                this.name = strTabSection.getString(unloadedSection.sectionNameIndex);
            }
            this.stringTable = (StrTabSection)eLF.getSection(unloadedSection.link);
            eLF.set_position(unloadedSection.offset);
            int n = unloadedSection.size / this.getEntSize();
            if (unloadedSection.size % this.getEntSize() != 0) {
                throw new IOException();
            }
            this.localSymbols = new LinkedList();
            this.globalSymbols = new LinkedList();
            while (--n >= 0) {
                SymbolTableEntry symbolTableEntry = SymbolTableEntry.read(eLF, this.stringTable);
                this.addSymbol(symbolTableEntry);
            }
            if (this.getInfo() != unloadedSection.info) {
                throw new IOException();
            }
        }

        public SymTabSection(String string, int n, int n2, StrTabSection strTabSection) {
            super(string, n, n2);
            this.stringTable = strTabSection;
            this.localSymbols = new LinkedList();
            this.globalSymbols = new LinkedList();
            this.addSymbol(SymbolTableEntry.EmptySymbolTableEntry.INSTANCE);
        }

        protected SymTabSection(int n, int n2) {
            super(n, n2);
        }
    }

    public static class DynSymSection
    extends Section {
        List localSymbols;
        List globalSymbols;
        StrTabSection stringTable;

        public void addSymbol(SymbolTableEntry symbolTableEntry) {
            this.stringTable.addString(symbolTableEntry.getName());
            if (symbolTableEntry.getBind() == 0) {
                this.localSymbols.add(symbolTableEntry);
            } else {
                this.globalSymbols.add(symbolTableEntry);
            }
        }

        public int getSize() {
            return (this.localSymbols.size() + this.globalSymbols.size()) * SymbolTableEntry.getEntrySize();
        }

        public int getAddrAlign() {
            return 4;
        }

        public final int getType() {
            return 11;
        }

        public final int getLink() {
            return this.stringTable.getIndex();
        }

        public final int getInfo() {
            return this.localSymbols.size();
        }

        public final int getEntSize() {
            return SymbolTableEntry.getEntrySize();
        }

        public SymbolTableEntry getSymbolTableEntry(int n) {
            if (n < this.localSymbols.size()) {
                return (SymbolTableEntry)this.localSymbols.get(n);
            }
            return (SymbolTableEntry)this.globalSymbols.get(n -= this.localSymbols.size());
        }

        public void writeData(ELF eLF) throws IOException {
            AppendIterator appendIterator = new AppendIterator(this.localSymbols.iterator(), this.globalSymbols.iterator());
            while (appendIterator.hasNext()) {
                SymbolTableEntry symbolTableEntry = (SymbolTableEntry)appendIterator.next();
                symbolTableEntry.write(eLF, this.stringTable);
            }
        }

        public static DynSymSection empty(int n, int n2) {
            return new DynSymSection(n, n2);
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
            if (unloadedSection.sectionNameIndex != 0) {
                StrTabSection strTabSection = eLF.getSectionHeaderStringTable();
                if (strTabSection == null) {
                    throw new IOException();
                }
                this.name = strTabSection.getString(unloadedSection.sectionNameIndex);
            }
            this.stringTable = (StrTabSection)eLF.getSection(unloadedSection.link);
            eLF.set_position(unloadedSection.offset);
            int n = unloadedSection.size / this.getEntSize();
            if (unloadedSection.size % this.getEntSize() != 0) {
                throw new IOException();
            }
            this.localSymbols = new LinkedList();
            this.globalSymbols = new LinkedList();
            while (--n >= 0) {
                SymbolTableEntry symbolTableEntry = SymbolTableEntry.read(eLF, this.stringTable);
                this.addSymbol(symbolTableEntry);
            }
            if (this.getInfo() != unloadedSection.info) {
                throw new IOException();
            }
        }

        public DynSymSection(String string, int n, int n2, StrTabSection strTabSection) {
            super(string, n, n2);
            this.stringTable = strTabSection;
            this.localSymbols = new LinkedList();
            this.globalSymbols = new LinkedList();
        }

        protected DynSymSection(int n, int n2) {
            super(n, n2);
        }
    }

    public static class StrTabSection
    extends Section {
        protected Map string_map;
        protected byte[] table;

        public final int getType() {
            return 3;
        }

        public final int getLink() {
            return 0;
        }

        public final int getInfo() {
            return 0;
        }

        public final int getEntSize() {
            return 0;
        }

        public final int getNumberOfEntries() {
            return this.string_map.size();
        }

        public void addString(String string) {
            this.string_map.put(string, null);
        }

        public void super_pack() {
            Object object;
            Object object2;
            int n;
            Object object3;
            TreeMap<Object, HashSet<Object>> treeMap = new TreeMap<Object, HashSet<Object>>();
            Iterator<Object> iterator = this.string_map.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                n = -((String)object3).length();
                object2 = new Integer(n);
                HashSet<Object> hashSet = (HashSet<Object>)treeMap.get(object2);
                if (hashSet == null) {
                    hashSet = new HashSet<Object>();
                    treeMap.put(object2, hashSet);
                }
                hashSet.add(object3);
            }
            object3 = new LinkedList();
            iterator = treeMap.entrySet().iterator();
            n = 1;
            while (iterator.hasNext()) {
                object2 = (Map.Entry)iterator.next();
                int n2 = -((Integer)object2.getKey()).intValue();
                if (n2 == 0) break;
                object = (Set)object2.getValue();
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    int n3;
                    String string;
                    block11: {
                        String string2;
                        string = (String)iterator2.next();
                        boolean bl = false;
                        if (string.length() == n2) {
                            bl = true;
                        }
                        Assert._assert(bl);
                        Iterator iterator3 = object3.iterator();
                        do {
                            if (!iterator3.hasNext()) {
                                n3 = n;
                                n += n2 + 1;
                                object3.add(string);
                            } else {
                                string2 = (String)iterator3.next();
                                if (string2.length() != n2) continue;
                                n3 = n;
                                n += n2 + 1;
                                object3.add(string);
                            }
                            break block11;
                        } while (!string2.endsWith(string));
                        n3 = (Integer)this.string_map.get(string2);
                        n3 += string2.length();
                        n3 -= n2;
                    }
                    this.string_map.put(string, new Integer(n3));
                }
            }
            this.table = new byte[n];
            iterator = this.string_map.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = (Map.Entry)iterator.next();
                String string = (String)object2.getKey();
                if (object2.getValue() == null) continue;
                n = (Integer)object2.getValue();
                try {
                    object = string.getBytes(Section.DEFAULT_ENCODING);
                    System.arraycopy(object, 0, this.table, n, ((Object)object).length);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Assert.UNREACHABLE();
                }
            }
        }

        public void pack() {
            Map.Entry entry;
            int n = 1;
            Iterator iterator = this.string_map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2 = iterator.next();
                entry = (String)entry2.getKey();
                if (((String)((Object)entry)).length() == 0) {
                    entry2.setValue(new Integer(0));
                    continue;
                }
                entry2.setValue(new Integer(n));
                n += ((String)((Object)entry)).length() + 1;
            }
            if (n == 1) {
                n = 0;
            }
            this.table = new byte[n];
            int n2 = 1;
            iterator = this.string_map.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                String string = (String)entry.getKey();
                if (string.length() == 0) {
                    boolean bl = false;
                    if ((Integer)entry.getValue() == 0) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    continue;
                }
                try {
                    byte[] byArray = string.getBytes(Section.DEFAULT_ENCODING);
                    boolean bl = false;
                    if (byArray.length == string.length()) {
                        bl = true;
                    }
                    Assert._assert(bl, string);
                    System.arraycopy(byArray, 0, this.table, n2, byArray.length);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Assert.UNREACHABLE();
                }
                boolean bl = false;
                if ((Integer)entry.getValue() == n2) {
                    bl = true;
                }
                Assert._assert(bl, string);
                n2 += string.length() + 1;
            }
            boolean bl = false;
            if (n == 0 || n == n2) {
                bl = true;
            }
            Assert._assert(bl);
        }

        public int getStringIndex(String string) {
            Integer n = (Integer)this.string_map.get(string);
            if (n == null) {
                return 0;
            }
            Assert._assert(this.getString(n).equals(string), string);
            return n;
        }

        public String getString(int n) {
            int n2 = 0;
            while (this.table[n2 + n] != 0) {
                ++n2;
            }
            try {
                return new String(this.table, n, n2, Section.DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.UNREACHABLE();
                return null;
            }
        }

        public int getSize() {
            return this.table.length;
        }

        public int getAddrAlign() {
            return 1;
        }

        public void writeData(ELF eLF) throws IOException {
            eLF.write_bytes(this.table);
        }

        public static StrTabSection empty(int n, int n2) {
            return new StrTabSection(n, n2);
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
            this.table = new byte[unloadedSection.size];
            eLF.set_position(unloadedSection.offset);
            eLF.read_bytes(this.table);
            if (unloadedSection.sectionNameIndex != 0) {
                StrTabSection strTabSection = eLF.getSectionHeaderStringTable();
                if (strTabSection == null) {
                    throw new IOException();
                }
                this.name = strTabSection.getString(unloadedSection.sectionNameIndex);
            }
        }

        public StrTabSection(String string, int n, int n2) {
            super(string, n, n2);
            this.string_map = new HashMap();
        }

        protected StrTabSection(int n, int n2) {
            super(n, n2);
        }
    }

    public static class RelASection
    extends Section {
        protected List relocs;
        protected SymTabSection symbolTable;
        protected Section targetSection;

        public final int getType() {
            return 4;
        }

        public final int getLink() {
            return this.symbolTable.getIndex();
        }

        public final int getInfo() {
            return this.targetSection.getIndex();
        }

        public final int getEntSize() {
            return RelocAEntry.getEntrySize();
        }

        public int getSize() {
            return this.relocs.size() * RelocAEntry.getEntrySize();
        }

        public int getAddrAlign() {
            return 4;
        }

        public void addReloc(RelocAEntry relocAEntry) {
            this.relocs.add(relocAEntry);
        }

        public void writeData(ELF eLF) throws IOException {
            Iterator iterator = this.relocs.iterator();
            while (iterator.hasNext()) {
                RelocAEntry relocAEntry = (RelocAEntry)iterator.next();
                relocAEntry.write(eLF);
            }
        }

        public static RelASection empty(int n, int n2) {
            return new RelASection(n, n2);
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
            if (unloadedSection.sectionNameIndex != 0) {
                StrTabSection strTabSection = eLF.getSectionHeaderStringTable();
                if (strTabSection == null) {
                    throw new IOException();
                }
                this.name = strTabSection.getString(unloadedSection.sectionNameIndex);
            }
            this.symbolTable = (SymTabSection)eLF.getSection(unloadedSection.link);
            this.targetSection = eLF.getSection(unloadedSection.info);
            int n = unloadedSection.size / this.getEntSize();
            if (n % this.getEntSize() != 0) {
                throw new IOException();
            }
            this.relocs = new LinkedList();
            eLF.set_position(unloadedSection.offset);
            while (--n >= 0) {
                RelocAEntry relocAEntry = (RelocAEntry)RelocAEntry.read(eLF, this.symbolTable);
                this.addReloc(relocAEntry);
            }
        }

        public RelASection(String string, int n, int n2, SymTabSection symTabSection, Section section) {
            super(string, n, n2);
            this.symbolTable = symTabSection;
            this.targetSection = section;
            this.relocs = new LinkedList();
        }

        protected RelASection(int n, int n2) {
            super(n, n2);
        }
    }

    public static class HashSection
    extends Section {
        protected int sectionIndex;

        public final int getType() {
            return 5;
        }

        public final int getLink() {
            return this.sectionIndex;
        }

        public final int getInfo() {
            return 0;
        }

        public final int getEntSize() {
            return 0;
        }

        public int getSize() {
            return 0;
        }

        public int getAddrAlign() {
            return 0;
        }

        public void writeData(ELF eLF) throws IOException {
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
        }

        public HashSection(String string, int n, int n2, int n3) {
            super(string, n, n2);
            this.sectionIndex = n3;
        }
    }

    public static class DynamicSection
    extends Section {
        protected int stringTableIndex;

        public final int getType() {
            return 6;
        }

        public final int getLink() {
            return this.stringTableIndex;
        }

        public final int getInfo() {
            return 0;
        }

        public final int getEntSize() {
            return 0;
        }

        public int getSize() {
            return 0;
        }

        public int getAddrAlign() {
            return 0;
        }

        public void writeData(ELF eLF) throws IOException {
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
        }

        public DynamicSection(String string, int n, int n2, int n3) {
            super(string, n, n2);
            this.stringTableIndex = n3;
        }
    }

    public static class NoteSection
    extends Section {
        protected String notename;
        protected byte[] notedesc;
        protected int notetype;

        public final int getType() {
            return 7;
        }

        public final int getLink() {
            return 0;
        }

        public final int getInfo() {
            return 0;
        }

        public final int getEntSize() {
            return 0;
        }

        protected int getNameLength() {
            return this.notename.length() + 4 & 0xFFFFFFFC;
        }

        public int getSize() {
            return 12 + this.getNameLength() + this.notedesc.length;
        }

        public int getAddrAlign() {
            return 1;
        }

        public void writeData(ELF eLF) throws IOException {
            eLF.write_word(this.getNameLength());
            eLF.write_word(this.notedesc.length);
            eLF.write_word(this.notetype);
            byte[] byArray = new byte[this.getNameLength()];
            try {
                byte[] byArray2 = this.notename.getBytes(Section.DEFAULT_ENCODING);
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.UNREACHABLE();
            }
            eLF.write_bytes(byArray);
            eLF.write_bytes(this.notedesc);
        }

        public static NoteSection empty(int n, int n2) {
            return new NoteSection(n, n2);
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
            if (unloadedSection.sectionNameIndex != 0) {
                StrTabSection strTabSection = eLF.getSectionHeaderStringTable();
                if (strTabSection == null) {
                    throw new IOException();
                }
                this.name = strTabSection.getString(unloadedSection.sectionNameIndex);
            }
            eLF.set_position(unloadedSection.offset);
            int n = eLF.read_word();
            int n2 = eLF.read_word();
            this.notetype = eLF.read_word();
            byte[] byArray = new byte[n];
            eLF.read_bytes(byArray);
            try {
                this.notename = new String(byArray, Section.DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Assert.UNREACHABLE();
            }
            this.notedesc = new byte[n2];
            eLF.read_bytes(this.notedesc);
            if (this.getSize() != unloadedSection.size) {
                throw new IOException();
            }
        }

        public NoteSection(String string, int n, int n2, String string2, byte[] byArray, int n3) {
            super(string, n, n2);
            this.notename = string2;
            this.notedesc = byArray;
            this.notetype = n3;
        }

        protected NoteSection(int n, int n2) {
            super(n, n2);
        }
    }

    public static class NoBitsSection
    extends Section {
        protected int size;
        protected int addralign;

        public final int getType() {
            return 8;
        }

        public final int getLink() {
            return 0;
        }

        public final int getInfo() {
            return 0;
        }

        public final int getEntSize() {
            return 0;
        }

        public int getSize() {
            return this.size;
        }

        public int getAddrAlign() {
            return this.addralign;
        }

        public void writeData(ELF eLF) throws IOException {
        }

        public static NoBitsSection empty(int n, int n2, int n3, int n4) {
            return new NoBitsSection(n, n2, n3, n4);
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
            if (unloadedSection.sectionNameIndex != 0) {
                StrTabSection strTabSection = eLF.getSectionHeaderStringTable();
                if (strTabSection == null) {
                    throw new IOException();
                }
                this.name = strTabSection.getString(unloadedSection.sectionNameIndex);
            }
        }

        public NoBitsSection(String string, int n, int n2, int n3, int n4) {
            super(string, n, n2);
            this.size = n3;
            this.addralign = n4;
        }

        protected NoBitsSection(int n, int n2, int n3, int n4) {
            super(n, n2);
            this.size = n3;
            this.addralign = n4;
        }
    }

    public static class RelSection
    extends Section {
        protected List relocs;
        protected SymTabSection symbolTable;
        protected Section targetSection;

        public final int getType() {
            return 9;
        }

        public final int getLink() {
            return this.symbolTable.getIndex();
        }

        public final int getInfo() {
            return this.targetSection.getIndex();
        }

        public final int getEntSize() {
            return RelocEntry.getEntrySize();
        }

        public int getSize() {
            return this.relocs.size() * RelocEntry.getEntrySize();
        }

        public int getAddrAlign() {
            return 4;
        }

        public void addReloc(RelocEntry relocEntry) {
            this.relocs.add(relocEntry);
        }

        public void writeData(ELF eLF) throws IOException {
            Iterator iterator = this.relocs.iterator();
            while (iterator.hasNext()) {
                RelocEntry relocEntry = (RelocEntry)iterator.next();
                relocEntry.write(eLF);
            }
        }

        public static RelSection empty(int n, int n2) {
            return new RelSection(n, n2);
        }

        public void load(UnloadedSection unloadedSection, ELF eLF) throws IOException {
            if (unloadedSection.sectionNameIndex != 0) {
                StrTabSection strTabSection = eLF.getSectionHeaderStringTable();
                if (strTabSection == null) {
                    throw new IOException();
                }
                this.name = strTabSection.getString(unloadedSection.sectionNameIndex);
            }
            this.symbolTable = (SymTabSection)eLF.getSection(unloadedSection.link);
            this.targetSection = eLF.getSection(unloadedSection.info);
            int n = unloadedSection.size / this.getEntSize();
            if (n % this.getEntSize() != 0) {
                throw new IOException();
            }
            this.relocs = new LinkedList();
            eLF.set_position(unloadedSection.offset);
            while (--n >= 0) {
                RelocEntry relocEntry = RelocEntry.read(eLF, this.symbolTable);
                this.addReloc(relocEntry);
            }
        }

        public RelSection(String string, int n, int n2, SymTabSection symTabSection, Section section) {
            super(string, n, n2);
            this.symbolTable = symTabSection;
            this.targetSection = section;
            this.relocs = new LinkedList();
        }

        protected RelSection(int n, int n2) {
            super(n, n2);
        }
    }
}

