/*
 * Decompiled with CFR 0.152.
 */
package Linker.ELF;

import Linker.ELF.ELF;
import Linker.ELF.ELFConstants;
import Linker.ELF.Section;
import Linker.ELF.SymbolTableEntry;
import java.io.IOException;

public class RelocEntry
implements ELFConstants {
    protected int offset;
    protected SymbolTableEntry e;
    protected byte type;

    public final int getOffset() {
        return this.offset;
    }

    public final int getSymbolTableIndex() {
        return this.e.getIndex();
    }

    public final int getType() {
        return this.type;
    }

    public final int getInfo() {
        return this.e.getIndex() << 8 | this.type & 0xFF;
    }

    public void write(ELF eLF) throws IOException {
        eLF.write_addr(this.getOffset());
        eLF.write_word(this.getInfo());
    }

    public static RelocEntry read(ELF eLF, Section.SymTabSection symTabSection) throws IOException {
        int n = eLF.read_addr();
        int n2 = eLF.read_word();
        int n3 = n2 >>> 8;
        byte by = (byte)n2;
        SymbolTableEntry symbolTableEntry = symTabSection.getSymbolTableEntry(n3);
        return new RelocEntry(n, symbolTableEntry, by);
    }

    public static int getEntrySize() {
        return 8;
    }

    public RelocEntry(int n, SymbolTableEntry symbolTableEntry, byte by) {
        this.offset = n;
        this.e = symbolTableEntry;
        this.type = by;
    }
}

