/*
 * Decompiled with CFR 0.152.
 */
package Interpreter;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_Initializer;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Clazz.jq_StaticMethod;
import Clazz.jq_Type;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ExceptionHandler;
import Compil3r.Quad.Operand;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadVisitor;
import Compil3r.Quad.RegisterFactory;
import Memory.Address;
import Run_Time.Arrays;
import Run_Time.Reflection;
import Util.Assert;
import Util.Collections.FilterIterator;
import Util.Templates.ListIterator;
import java.io.FileDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.Permission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class QuadInterpreter
extends QuadVisitor.EmptyVisitor {
    public static boolean TRACE = false;
    public static long num_quads = 0L;
    public static long num_nullchecks = 0L;
    static Set bad_methods;
    static Set bad_classes;
    public static FilterIterator.Filter interpret_filter;
    jq_Method method;
    Map registers = new HashMap();
    ControlFlowGraph cfg;
    RegisterFactory rf;
    BasicBlock current_bb;
    ListIterator.Quad current_iterator;
    Quad current_quad;
    Object return_value;
    Throwable thrown;
    Throwable caught;

    public void visitNullCheck(Quad quad) {
        ++num_nullchecks;
    }

    public void visitQuad(Quad quad) {
        if (TRACE) {
            System.out.println("Registers: " + this.registers);
        }
        if (TRACE) {
            System.out.println("Interpreting: " + quad);
        }
        ++num_quads;
        this.current_quad = quad;
        quad.interpret(this);
    }

    public void setReturnValue(Object object) {
        this.return_value = object;
    }

    public Object getReturnValue() {
        return this.return_value;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable throwable) {
        this.thrown = throwable;
    }

    public Throwable getCaught() {
        return this.caught;
    }

    public RegisterFactory.Register getExceptionRegister() {
        return this.rf.getStack(0, PrimordialClassLoader.getJavaLangObject());
    }

    public QuadInterpreter invokeReflective(jq_Method jq_Method2, Operand.ParamListOperand paramListOperand) {
        if (jq_Method2 instanceof jq_StaticMethod) {
            return this.invokeStaticReflective((jq_StaticMethod)jq_Method2, paramListOperand);
        }
        return this.invokeInstanceReflective((jq_InstanceMethod)jq_Method2, paramListOperand);
    }

    public Object[] generateParamArray(jq_Method jq_Method2, Operand.ParamListOperand paramListOperand) {
        int n = 1 - jq_Method2.isStatic();
        jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
        Object[] objectArray = new Object[paramListOperand.length() - n];
        int n2 = n;
        while (n2 < paramListOperand.length()) {
            if (jq_TypeArray[n2] == jq_Primitive.BYTE) {
                objectArray[n2 - n] = new Byte((byte)this.getReg_I(paramListOperand.get(n2).getRegister()));
            } else if (jq_TypeArray[n2] == jq_Primitive.CHAR) {
                objectArray[n2 - n] = new Character((char)this.getReg_I(paramListOperand.get(n2).getRegister()));
            } else if (jq_TypeArray[n2] == jq_Primitive.SHORT) {
                objectArray[n2 - n] = new Short((short)this.getReg_I(paramListOperand.get(n2).getRegister()));
            } else if (jq_TypeArray[n2] == jq_Primitive.BOOLEAN) {
                boolean bl = false;
                if (this.getReg_I(paramListOperand.get(n2).getRegister()) != 0) {
                    bl = true;
                }
                objectArray[n2 - n] = new Boolean(bl);
            } else {
                objectArray[n2 - n] = this.getReg(paramListOperand.get(n2).getRegister());
            }
            ++n2;
        }
        return objectArray;
    }

    public QuadInterpreter invokeInstanceReflective(jq_InstanceMethod jq_InstanceMethod2, Operand.ParamListOperand paramListOperand) {
        QuadInterpreter quadInterpreter = new QuadInterpreter(jq_InstanceMethod2);
        try {
            Object[] objectArray = this.generateParamArray(jq_InstanceMethod2, paramListOperand);
            if (jq_InstanceMethod2 instanceof jq_Initializer) {
                try {
                    Constructor constructor = (Constructor)Reflection.getJDKMember(jq_InstanceMethod2);
                    constructor.setAccessible(true);
                    UninitializedReference uninitializedReference = (UninitializedReference)this.getReg_A(paramListOperand.get(0).getRegister());
                    boolean bl = false;
                    if (uninitializedReference.k == jq_InstanceMethod2.getDeclaringClass()) {
                        bl = true;
                    }
                    Assert._assert(bl, uninitializedReference.k + " != " + jq_InstanceMethod2.getDeclaringClass());
                    Object t = constructor.newInstance(objectArray);
                    this.replaceUninitializedReferences(t, uninitializedReference);
                }
                catch (InstantiationException instantiationException) {
                    Assert.UNREACHABLE();
                }
                catch (IllegalAccessException illegalAccessException) {
                    Assert.UNREACHABLE();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Assert.UNREACHABLE();
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.handleException(invocationTargetException.getTargetException());
                }
                return quadInterpreter;
            }
            Method method = (Method)Reflection.getJDKMember(jq_InstanceMethod2);
            method.setAccessible(true);
            Object object = method.invoke(this.getReg(paramListOperand.get(0).getRegister()), objectArray);
            quadInterpreter.setReturnValue(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.UNREACHABLE();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.UNREACHABLE();
        }
        catch (InvocationTargetException invocationTargetException) {
            quadInterpreter.setThrown(invocationTargetException.getTargetException());
        }
        return quadInterpreter;
    }

    public QuadInterpreter invokeStaticReflective(jq_StaticMethod jq_StaticMethod2, Operand.ParamListOperand paramListOperand) {
        QuadInterpreter quadInterpreter = new QuadInterpreter(jq_StaticMethod2);
        if (jq_StaticMethod2 == Arrays._multinewarray) {
            int n = this.getReg_I(paramListOperand.get(0).getRegister());
            jq_Type jq_Type2 = (jq_Type)this.getReg_A(paramListOperand.get(1).getRegister());
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n - n2 - 1] = this.getReg_I(paramListOperand.get(n2 + 2).getRegister());
                ++n2;
            }
            n2 = 0;
            while (n2 < nArray.length) {
                jq_Type2.cls_initialize();
                jq_Type2 = ((jq_Array)jq_Type2).getElementType();
                ++n2;
            }
            try {
                quadInterpreter.return_value = Array.newInstance(Reflection.getJDKType(jq_Type2), nArray);
            }
            catch (Throwable throwable) {
                quadInterpreter.setThrown(throwable);
            }
            return quadInterpreter;
        }
        Object[] objectArray = this.generateParamArray(jq_StaticMethod2, paramListOperand);
        try {
            Method method = (Method)Reflection.getJDKMember(jq_StaticMethod2);
            method.setAccessible(true);
            Object object = method.invoke(null, objectArray);
            quadInterpreter.setReturnValue(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.UNREACHABLE();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.UNREACHABLE();
        }
        catch (InvocationTargetException invocationTargetException) {
            quadInterpreter.setThrown(invocationTargetException.getTargetException());
        }
        return quadInterpreter;
    }

    public QuadInterpreter invokeMethod(jq_Method jq_Method2, Operand.ParamListOperand paramListOperand) {
        if (TRACE) {
            System.out.println("Invoking " + jq_Method2);
        }
        jq_Class jq_Class2 = jq_Method2.getDeclaringClass();
        jq_Class2.cls_initialize();
        if (!interpret_filter.isElement(jq_Method2)) {
            return this.invokeReflective(jq_Method2, paramListOperand);
        }
        ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method2);
        QuadInterpreter quadInterpreter = new QuadInterpreter(jq_Method2);
        Object[] objectArray = new Object[paramListOperand.length()];
        int n = 0;
        while (n < paramListOperand.length()) {
            objectArray[n] = this.getReg(paramListOperand.get(n).getRegister());
            ++n;
        }
        quadInterpreter.interpretMethod(jq_Method2, objectArray, controlFlowGraph.getRegisterFactory(), controlFlowGraph);
        if (TRACE) {
            System.out.println("Finished interpreting " + jq_Method2);
        }
        return quadInterpreter;
    }

    public void output() {
        System.out.println("Quad count: " + num_quads);
    }

    public void trapOnSystemExit() {
        SecurityManager securityManager = new SecurityManager(this){
            final /* synthetic */ QuadInterpreter this$0;

            public final void checkAccept(String string, int n) {
            }

            public final void checkAccess(Thread thread) {
            }

            public final void checkAccess(ThreadGroup threadGroup) {
            }

            public final void checkAwtEventQueueAccess(ThreadGroup threadGroup) {
            }

            public final void checkConnect(String string, int n) {
            }

            public final void checkConnect(String string, int n, Object object) {
            }

            public final void checkCreateClassLoader() {
            }

            public final void checkDelete() {
            }

            public final void checkExec(String string) {
            }

            public final void checkExit(int n) {
                this.this$0.output();
            }

            public final void checkLink(String string) {
            }

            public final void checkListen(int n) {
            }

            public final void checkMemberAccess(Class clazz, int n) {
            }

            public final void checkMulticast(InetAddress inetAddress) {
            }

            public final void checkPackageAccess(String string) {
            }

            public final void checkPackageDefinition(String string) {
            }

            public final void checkPermission(Permission permission) {
            }

            public final void checkPermission(Permission permission, Object object) {
            }

            public final void checkPrintJobAccess() {
            }

            public final void checkPropertiesAccess() {
            }

            public final void checkPropertyAccess(String string) {
            }

            public final void checkRead(FileDescriptor fileDescriptor) {
            }

            public final void checkRead(String string) {
            }

            public final void checkRead(String string, Object object) {
            }

            public final void checkSecurityAccess(String string) {
            }

            public final void checkSetFactory() {
            }

            public final void checkSystemClipboardAccess() {
            }

            public final boolean checkTopLevelWindow(Object object) {
                return true;
            }

            public final void checkWrite(FileDescriptor fileDescriptor) {
            }

            public final void checkWrite(String string) {
            }
            {
                this.this$0 = quadInterpreter;
            }
        };
        System.setSecurityManager(securityManager);
    }

    public static QuadInterpreter interpretMethod(jq_Method jq_Method2, Object[] objectArray) {
        QuadInterpreter quadInterpreter = new QuadInterpreter(jq_Method2);
        quadInterpreter.trapOnSystemExit();
        ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method2);
        try {
            quadInterpreter.interpretMethod(jq_Method2, objectArray, controlFlowGraph.getRegisterFactory(), controlFlowGraph);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return quadInterpreter;
    }

    public void interpretMethod(jq_Method jq_Method2, Object[] objectArray, RegisterFactory registerFactory, ControlFlowGraph controlFlowGraph) {
        this.cfg = controlFlowGraph;
        this.rf = registerFactory;
        jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
        int n = 0;
        int n2 = 0;
        while (n < jq_TypeArray.length) {
            RegisterFactory.Register register = registerFactory.getLocal(n2, jq_TypeArray[n]);
            this.registers.put(register, objectArray[n]);
            if (jq_TypeArray[n].getReferenceSize() == 8) {
                ++n2;
            }
            ++n;
            ++n2;
        }
        this.current_bb = controlFlowGraph.entry();
        while (true) {
            this.current_iterator = this.current_bb.iterator();
            while (this.current_iterator.hasNext()) {
                Quad quad = this.current_iterator.nextQuad();
                quad.accept(this);
            }
            if (this.current_bb.isExit()) break;
            this.current_bb = this.current_bb.getFallthroughSuccessor();
        }
    }

    public void branchTo(BasicBlock basicBlock) {
        if (TRACE) {
            System.out.println("Branching to: " + basicBlock);
        }
        this.current_bb = basicBlock;
        this.current_iterator = basicBlock.iterator();
    }

    public void handleException(Throwable throwable) {
        jq_Class jq_Class2 = (jq_Class)jq_Reference.getTypeOf(throwable);
        jq_Class2.prepare();
        ExceptionHandler exceptionHandler = this.current_bb.getExceptionHandlers().mustCatch(jq_Class2);
        if (exceptionHandler != null) {
            this.caught = throwable;
            this.branchTo(exceptionHandler.getEntry());
            if (TRACE) {
                System.out.println("Method " + this.method + " handler " + exceptionHandler + " catches " + throwable);
            }
        } else {
            this.thrown = throwable;
            this.branchTo(this.cfg.exit());
            if (TRACE) {
                System.out.println("Method " + this.method + " does not catch " + throwable);
            }
        }
    }

    public int getReg_I(RegisterFactory.Register register) {
        return (Integer)this.registers.get(register);
    }

    public float getReg_F(RegisterFactory.Register register) {
        return ((Float)this.registers.get(register)).floatValue();
    }

    public long getReg_L(RegisterFactory.Register register) {
        return (Long)this.registers.get(register);
    }

    public double getReg_D(RegisterFactory.Register register) {
        return (Double)this.registers.get(register);
    }

    public Object getReg_A(RegisterFactory.Register register) {
        return this.registers.get(register);
    }

    public Address getReg_P(RegisterFactory.Register register) {
        Assert.TODO();
        return null;
    }

    public Object getReg(RegisterFactory.Register register) {
        return this.registers.get(register);
    }

    public void putReg_I(RegisterFactory.Register register, int n) {
        this.registers.put(register, new Integer(n));
    }

    public void putReg_F(RegisterFactory.Register register, float f) {
        this.registers.put(register, new Float(f));
    }

    public void putReg_L(RegisterFactory.Register register, long l) {
        this.registers.put(register, new Long(l));
    }

    public void putReg_D(RegisterFactory.Register register, double d) {
        this.registers.put(register, new Double(d));
    }

    public void putReg_A(RegisterFactory.Register register, Object object) {
        this.registers.put(register, object);
    }

    public void putReg_P(RegisterFactory.Register register, Address address) {
        Assert.TODO();
    }

    public void putReg(RegisterFactory.Register register, Object object) {
        this.registers.put(register, object);
    }

    public void replaceUninitializedReferences(Object object, UninitializedReference uninitializedReference) {
        Iterator iterator = this.registers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != uninitializedReference) continue;
            entry.setValue(object);
        }
    }

    public String currentLocation() {
        return this.method + ' ' + this.current_bb + " quad#" + this.current_quad.getID();
    }

    public String toString() {
        if (this.thrown != null) {
            return "Thrown exception: " + this.thrown + " (null checks: " + num_nullchecks + " quad count: " + num_quads + ')';
        }
        return "Returned: " + this.return_value + " (null checks: " + num_nullchecks + " quad count: " + num_quads + ')';
    }

    public QuadInterpreter(jq_Method jq_Method2) {
        this.method = jq_Method2;
    }

    static {
        bad_classes = new HashSet();
        bad_classes.add(Reflection._class);
        bad_methods = new HashSet();
        jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("Ljava/io/PrintStream;");
        jq_InstanceMethod jq_InstanceMethod2 = jq_Class2.getOrCreateInstanceMethod("write", "(Ljava/lang/String;)V");
        jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("Ljava/io/OutputStreamWriter;");
        jq_InstanceMethod2 = jq_Class2.getOrCreateInstanceMethod("write", "([CII)V");
        bad_methods.add(jq_InstanceMethod2);
        bad_methods.add(Arrays._multinewarray);
        interpret_filter = new FilterIterator.Filter(){

            public final boolean isElement(Object object) {
                jq_Method jq_Method2 = (jq_Method)object;
                if (jq_Method2.isNative()) {
                    return false;
                }
                if (jq_Method2.getBytecode() == null) {
                    return false;
                }
                if (jq_Method2 instanceof jq_Initializer) {
                    return false;
                }
                if (bad_classes.contains(jq_Method2.getDeclaringClass())) {
                    return false;
                }
                return !bad_methods.contains(jq_Method2);
            }
        };
    }

    public static class UninitializedReference {
        public jq_Class k;

        public String toString() {
            return this.k + " <uninit>";
        }

        public UninitializedReference(jq_Class jq_Class2) {
            this.k = jq_Class2;
        }
    }
}

