/*
 * Decompiled with CFR 0.152.
 */
package GC;

import GC.SimpleRCGC;
import GC.TraceMSGC;
import java.util.Hashtable;

public class GCManager {
    public static final int RC_GC = 1;
    public static final int TR_GC = 2;
    public static final int MS_GC = 4;
    public static final int CP_GC = 8;
    public static final int CNS_GC = 16;
    public static final int INC_GC = 18;
    public static final int GEN_GC = 20;
    public static final int PAL_GC = 65536;
    public static final int DST_GC = 131072;
    private static boolean initialized = false;
    private static Hashtable candidates = new Hashtable();
    private static Runnable defaultTCGC = new TraceMSGC();
    private static Runnable defaultRCGC = new SimpleRCGC();

    public static void initialize() {
        candidates.put(new Integer(0), new TraceMSGC());
        candidates.put(new Integer(1), new SimpleRCGC());
        initialized = true;
    }

    public static void reset() {
        initialized = false;
    }

    public static Object getGC(int n) {
        Object v;
        if (!initialized) {
            GCManager.initialize();
        }
        if ((v = candidates.get(new Integer(n))) != null) {
            return v;
        }
        if ((n & 2) != 0) {
            return defaultTCGC;
        }
        if ((n & 1) != 0) {
            return defaultRCGC;
        }
        return null;
    }
}

