/*
 * Decompiled with CFR 0.152.
 */
package GC;

import Allocator.HeapAllocator;
import GC.GCBits;
import Memory.HeapAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

public class GCBitsManager {
    private static TreeMap pool = new TreeMap();
    private static HashSet units = new HashSet();

    public static void register(GCBits gCBits) {
        pool.put(new HeapAllocator.HeapPointer(gCBits.blockEnd), gCBits);
    }

    public static boolean isValidHeapAddr(HeapAddress heapAddress) {
        HeapAllocator.HeapPointer heapPointer = pool.tailMap(new HeapAllocator.HeapPointer(heapAddress)).firstKey();
        GCBits gCBits = (GCBits)pool.get(heapPointer);
        int n = heapAddress.difference(gCBits.blockHead);
        if (n < 0) {
            return false;
        }
        if (n % 8 != 0 && n % 8 != 4) {
            return false;
        }
        if (n % 8 == 4) {
            return gCBits.isSet((HeapAddress)heapAddress.offset(-12));
        }
        return gCBits.isSet((HeapAddress)heapAddress.offset(-8));
    }

    public static void mark(HeapAddress heapAddress) {
        HeapAllocator.HeapPointer heapPointer = pool.tailMap(new HeapAllocator.HeapPointer(heapAddress)).firstKey();
        GCBits gCBits = (GCBits)pool.get(heapPointer);
        gCBits.mark(heapAddress);
    }

    public static void diff() {
        Iterator iterator = pool.values().iterator();
        while (iterator.hasNext()) {
            GCBits gCBits = (GCBits)iterator.next();
            units.addAll(gCBits.diff());
        }
    }

    public static HashSet getUnits() {
        return units;
    }
}

