/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad.x86;

import Clazz.jq_CompiledCode;
import Clazz.jq_Method;
import Clazz.jq_TryCatch;
import Memory.CodeAddress;
import Memory.HeapAddress;
import Memory.StackAddress;
import Run_Time.ExceptionDeliverer;
import Run_Time.SystemInterface;
import Run_Time.Unsafe;
import Util.Assert;

public class x86QuadExceptionDeliverer
extends ExceptionDeliverer {
    public static boolean TRACE = false;
    public static final x86QuadExceptionDeliverer INSTANCE = new x86QuadExceptionDeliverer();

    public final void deliverToStackFrame(jq_CompiledCode jq_CompiledCode2, Throwable throwable, jq_TryCatch jq_TryCatch2, CodeAddress codeAddress, StackAddress stackAddress) {
        boolean bl = false;
        if (jq_TryCatch2.getExceptionOffset() != 0) {
            bl = true;
        }
        Assert._assert(bl);
        StackAddress stackAddress2 = (StackAddress)stackAddress.offset(jq_TryCatch2.getExceptionOffset());
        if (TRACE) {
            SystemInterface.debugwriteln("poking exception object " + HeapAddress.addressOf(throwable).stringRep() + " into location " + stackAddress2.stringRep());
        }
        stackAddress2.poke(HeapAddress.addressOf(throwable));
        stackAddress2 = (StackAddress)stackAddress.offset(-jq_CompiledCode2.getStackFrameSize());
        Unsafe.longJump(codeAddress, stackAddress, stackAddress2, 0);
    }

    public final Object getThisPointer(jq_CompiledCode jq_CompiledCode2, CodeAddress codeAddress, StackAddress stackAddress) {
        jq_Method jq_Method2 = jq_CompiledCode2.getMethod();
        int n = jq_Method2.getParamWords();
        boolean bl = false;
        if (n >= 1) {
            bl = true;
        }
        Assert._assert(bl);
        return ((HeapAddress)stackAddress.offset(n + 1 << 2).peek()).asObject();
    }

    private x86QuadExceptionDeliverer() {
    }
}

