/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_Type;
import Compil3r.Quad.Operand;
import Util.Assert;
import Util.Collections.AppendIterator;
import Util.Strings;
import java.util.ArrayList;
import java.util.Iterator;

public class RegisterFactory {
    private ArrayList local_I;
    private ArrayList local_F;
    private ArrayList local_L;
    private ArrayList local_D;
    private ArrayList local_A;
    private ArrayList stack_I;
    private ArrayList stack_F;
    private ArrayList stack_L;
    private ArrayList stack_D;
    private ArrayList stack_A;

    public Register getStack(int n, jq_Type jq_Type2) {
        if (jq_Type2.isReferenceType()) {
            return (Register)this.stack_A.get(n);
        }
        if (jq_Type2.isIntLike()) {
            return (Register)this.stack_I.get(n);
        }
        if (jq_Type2 == jq_Primitive.FLOAT) {
            return (Register)this.stack_F.get(n);
        }
        if (jq_Type2 == jq_Primitive.LONG) {
            return (Register)this.stack_L.get(n);
        }
        if (jq_Type2 == jq_Primitive.DOUBLE) {
            return (Register)this.stack_D.get(n);
        }
        Assert.UNREACHABLE();
        return null;
    }

    public Register getNewStack(int n, jq_Type jq_Type2) {
        if (jq_Type2.isReferenceType()) {
            while (n >= this.stack_A.size()) {
                this.stack_A.add(new Register(this.stack_A.size(), true));
            }
            return (Register)this.stack_A.get(n);
        }
        if (jq_Type2.isIntLike()) {
            while (n >= this.stack_I.size()) {
                this.stack_I.add(new Register(this.stack_I.size(), true));
            }
            return (Register)this.stack_I.get(n);
        }
        if (jq_Type2 == jq_Primitive.FLOAT) {
            while (n >= this.stack_F.size()) {
                this.stack_F.add(new Register(this.stack_F.size(), true));
            }
            return (Register)this.stack_F.get(n);
        }
        if (jq_Type2 == jq_Primitive.LONG) {
            while (n >= this.stack_L.size()) {
                this.stack_L.add(new Register(this.stack_L.size(), true));
            }
            return (Register)this.stack_L.get(n);
        }
        if (jq_Type2 == jq_Primitive.DOUBLE) {
            while (n >= this.stack_D.size()) {
                this.stack_D.add(n, new Register(this.stack_D.size(), true));
            }
            return (Register)this.stack_D.get(n);
        }
        Assert.UNREACHABLE();
        return null;
    }

    public Register getLocal(int n, jq_Type jq_Type2) {
        if (jq_Type2.isReferenceType()) {
            return (Register)this.local_A.get(n);
        }
        if (jq_Type2.isIntLike()) {
            return (Register)this.local_I.get(n);
        }
        if (jq_Type2 == jq_Primitive.FLOAT) {
            return (Register)this.local_F.get(n);
        }
        if (jq_Type2 == jq_Primitive.LONG) {
            return (Register)this.local_L.get(n);
        }
        if (jq_Type2 == jq_Primitive.DOUBLE) {
            return (Register)this.local_D.get(n);
        }
        Assert.UNREACHABLE();
        return null;
    }

    public boolean isLocal(Operand operand, int n, jq_Type jq_Type2) {
        if (n >= this.getLocalSize(jq_Type2)) {
            return false;
        }
        if (operand instanceof Operand.RegisterOperand) {
            Register register = ((Operand.RegisterOperand)operand).getRegister();
            if (this.getLocal(n, jq_Type2) == register) {
                return true;
            }
        }
        return false;
    }

    public Register makeTempReg(jq_Type jq_Type2) {
        if (jq_Type2.isReferenceType()) {
            int n = this.stack_A.size();
            this.stack_A.add(n, new Register(n, true));
            return (Register)this.stack_A.get(n);
        }
        if (jq_Type2.isIntLike()) {
            int n = this.stack_I.size();
            this.stack_I.add(n, new Register(n, true));
            return (Register)this.stack_I.get(n);
        }
        if (jq_Type2 == jq_Primitive.FLOAT) {
            int n = this.stack_F.size();
            this.stack_F.add(n, new Register(n, true));
            return (Register)this.stack_F.get(n);
        }
        if (jq_Type2 == jq_Primitive.LONG) {
            int n = this.stack_L.size();
            this.stack_L.add(n, new Register(n, true));
            return (Register)this.stack_L.get(n);
        }
        if (jq_Type2 == jq_Primitive.DOUBLE) {
            int n = this.stack_D.size();
            this.stack_D.add(n, new Register(n, true));
            return (Register)this.stack_D.get(n);
        }
        Assert.UNREACHABLE();
        return null;
    }

    public int getLocalSize(jq_Type jq_Type2) {
        if (jq_Type2.isReferenceType()) {
            return this.local_A.size();
        }
        if (jq_Type2.isIntLike()) {
            return this.local_I.size();
        }
        if (jq_Type2 == jq_Primitive.FLOAT) {
            return this.local_F.size();
        }
        if (jq_Type2 == jq_Primitive.LONG) {
            return this.local_L.size();
        }
        if (jq_Type2 == jq_Primitive.DOUBLE) {
            return this.local_D.size();
        }
        Assert.UNREACHABLE();
        return 0;
    }

    public int getStackSize(jq_Type jq_Type2) {
        if (jq_Type2.isReferenceType()) {
            return this.stack_A.size();
        }
        if (jq_Type2.isIntLike()) {
            return this.stack_I.size();
        }
        if (jq_Type2 == jq_Primitive.FLOAT) {
            return this.stack_F.size();
        }
        if (jq_Type2 == jq_Primitive.LONG) {
            return this.stack_L.size();
        }
        if (jq_Type2 == jq_Primitive.DOUBLE) {
            return this.stack_D.size();
        }
        Assert.UNREACHABLE();
        return 0;
    }

    public static Operand.RegisterOperand makeGuardReg() {
        return new Operand.RegisterOperand(new Register(-1, true), null);
    }

    void renumberRegisterList(ArrayList arrayList, int n) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Register register = (Register)iterator.next();
            register.setNumber(register.getNumber() + n);
        }
    }

    static void fillRegisters(ArrayList arrayList, int n, int n2, boolean bl) {
        boolean bl2 = false;
        if (arrayList.size() == 0) {
            bl2 = true;
        }
        Assert._assert(bl2);
        int n3 = 0;
        while (n3 < n2) {
            arrayList.add(n3, new Register(n + n3, bl));
            ++n3;
        }
    }

    public RegisterFactory deep_copy() {
        RegisterFactory registerFactory = new RegisterFactory();
        registerFactory.local_I = new ArrayList(this.local_I.size());
        RegisterFactory.fillRegisters(registerFactory.local_I, 0, this.local_I.size(), false);
        registerFactory.local_F = new ArrayList(this.local_F.size());
        RegisterFactory.fillRegisters(registerFactory.local_F, 0, this.local_F.size(), false);
        registerFactory.local_L = new ArrayList(this.local_L.size());
        RegisterFactory.fillRegisters(registerFactory.local_L, 0, this.local_L.size(), false);
        registerFactory.local_D = new ArrayList(this.local_D.size());
        RegisterFactory.fillRegisters(registerFactory.local_D, 0, this.local_D.size(), false);
        registerFactory.local_A = new ArrayList(this.local_A.size());
        RegisterFactory.fillRegisters(registerFactory.local_A, 0, this.local_A.size(), false);
        registerFactory.stack_I = new ArrayList(this.stack_I.size());
        RegisterFactory.fillRegisters(registerFactory.stack_I, 0, this.stack_I.size(), true);
        registerFactory.stack_F = new ArrayList(this.stack_F.size());
        RegisterFactory.fillRegisters(registerFactory.stack_F, 0, this.stack_F.size(), true);
        registerFactory.stack_L = new ArrayList(this.stack_L.size());
        RegisterFactory.fillRegisters(registerFactory.stack_L, 0, this.stack_L.size(), true);
        registerFactory.stack_D = new ArrayList(this.stack_D.size());
        RegisterFactory.fillRegisters(registerFactory.stack_D, 0, this.stack_D.size(), true);
        registerFactory.stack_A = new ArrayList(this.stack_A.size());
        RegisterFactory.fillRegisters(registerFactory.stack_A, 0, this.stack_A.size(), true);
        return registerFactory;
    }

    public RegisterFactory merge(RegisterFactory registerFactory) {
        RegisterFactory registerFactory2 = new RegisterFactory();
        registerFactory2.local_I = new ArrayList(registerFactory.local_I.size());
        RegisterFactory.fillRegisters(registerFactory2.local_I, this.local_I.size(), registerFactory.local_I.size(), false);
        registerFactory2.local_F = new ArrayList(registerFactory.local_F.size());
        RegisterFactory.fillRegisters(registerFactory2.local_F, this.local_F.size(), registerFactory.local_F.size(), false);
        registerFactory2.local_L = new ArrayList(registerFactory.local_L.size());
        RegisterFactory.fillRegisters(registerFactory2.local_L, this.local_L.size(), registerFactory.local_L.size(), false);
        registerFactory2.local_D = new ArrayList(registerFactory.local_D.size());
        RegisterFactory.fillRegisters(registerFactory2.local_D, this.local_D.size(), registerFactory.local_D.size(), false);
        registerFactory2.local_A = new ArrayList(registerFactory.local_A.size());
        RegisterFactory.fillRegisters(registerFactory2.local_A, this.local_A.size(), registerFactory.local_A.size(), false);
        registerFactory2.stack_I = new ArrayList(registerFactory.stack_I.size());
        RegisterFactory.fillRegisters(registerFactory2.stack_I, this.stack_I.size(), registerFactory.stack_I.size(), true);
        registerFactory2.stack_F = new ArrayList(registerFactory.stack_F.size());
        RegisterFactory.fillRegisters(registerFactory2.stack_F, this.stack_I.size(), registerFactory.stack_F.size(), true);
        registerFactory2.stack_L = new ArrayList(registerFactory.stack_L.size());
        RegisterFactory.fillRegisters(registerFactory2.stack_L, this.stack_I.size(), registerFactory.stack_L.size(), true);
        registerFactory2.stack_D = new ArrayList(registerFactory.stack_D.size());
        RegisterFactory.fillRegisters(registerFactory2.stack_D, this.stack_I.size(), registerFactory.stack_D.size(), true);
        registerFactory2.stack_A = new ArrayList(registerFactory.stack_A.size());
        RegisterFactory.fillRegisters(registerFactory2.stack_A, this.stack_I.size(), registerFactory.stack_A.size(), true);
        this.local_I.addAll(registerFactory2.local_I);
        this.local_F.addAll(registerFactory2.local_F);
        this.local_L.addAll(registerFactory2.local_L);
        this.local_D.addAll(registerFactory2.local_D);
        this.local_A.addAll(registerFactory2.local_A);
        this.stack_I.addAll(registerFactory2.stack_I);
        this.stack_F.addAll(registerFactory2.stack_F);
        this.stack_L.addAll(registerFactory2.stack_L);
        this.stack_D.addAll(registerFactory2.stack_D);
        this.stack_A.addAll(registerFactory2.stack_A);
        return registerFactory2;
    }

    public int totalSize() {
        return this.local_I.size() + this.local_F.size() + this.local_L.size() + this.local_D.size() + this.local_A.size() + this.stack_I.size() + this.stack_F.size() + this.stack_L.size() + this.stack_D.size() + this.stack_A.size();
    }

    public Iterator iterator() {
        AppendIterator appendIterator = new AppendIterator(this.local_I.iterator(), this.local_F.iterator());
        appendIterator = new AppendIterator(appendIterator, this.local_L.iterator());
        appendIterator = new AppendIterator(appendIterator, this.local_D.iterator());
        appendIterator = new AppendIterator(appendIterator, this.local_A.iterator());
        appendIterator = new AppendIterator(appendIterator, this.stack_I.iterator());
        appendIterator = new AppendIterator(appendIterator, this.stack_F.iterator());
        appendIterator = new AppendIterator(appendIterator, this.stack_L.iterator());
        appendIterator = new AppendIterator(appendIterator, this.stack_D.iterator());
        appendIterator = new AppendIterator(appendIterator, this.stack_A.iterator());
        return appendIterator;
    }

    public String toString() {
        return "Local: (I=" + this.local_I.size() + ",F=" + this.local_F.size() + ",L=" + this.local_L.size() + ",D=" + this.local_D.size() + ",A=" + this.local_A.size() + ") Stack: (I=" + this.stack_I.size() + ",F=" + this.stack_F.size() + ",L=" + this.stack_L.size() + ",D=" + this.stack_D.size() + ",A=" + this.stack_A.size() + ')';
    }

    public String fullDump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Local_I: " + this.local_I);
        stringBuffer.append(Strings.lineSep + "Local_F: " + this.local_F);
        stringBuffer.append(Strings.lineSep + "Local_L: " + this.local_L);
        stringBuffer.append(Strings.lineSep + "Local_D: " + this.local_D);
        stringBuffer.append(Strings.lineSep + "Local_A: " + this.local_A);
        stringBuffer.append(Strings.lineSep + "Stack_I: " + this.stack_I);
        stringBuffer.append(Strings.lineSep + "Stack_F: " + this.stack_F);
        stringBuffer.append(Strings.lineSep + "Stack_L: " + this.stack_L);
        stringBuffer.append(Strings.lineSep + "Stack_D: " + this.stack_D);
        stringBuffer.append(Strings.lineSep + "Stack_A: " + this.stack_A);
        return stringBuffer.toString();
    }

    private RegisterFactory() {
    }

    public RegisterFactory(jq_Method jq_Method2) {
        int n = jq_Method2.getMaxLocals();
        this.local_I = new ArrayList(n);
        this.local_F = new ArrayList(n);
        this.local_L = new ArrayList(n);
        this.local_D = new ArrayList(n);
        this.local_A = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this.local_I.add(new Register(n2, false));
            this.local_F.add(new Register(n2, false));
            this.local_L.add(new Register(n2, false));
            this.local_D.add(new Register(n2, false));
            this.local_A.add(new Register(n2, false));
            ++n2;
        }
        n2 = jq_Method2.getMaxStack();
        this.stack_I = new ArrayList(n2);
        this.stack_F = new ArrayList(n2);
        this.stack_L = new ArrayList(n2);
        this.stack_D = new ArrayList(n2);
        this.stack_A = new ArrayList(n2);
        int n3 = 0;
        while (n3 < n2) {
            this.stack_I.add(new Register(n3, true));
            this.stack_F.add(new Register(n3, true));
            this.stack_L.add(new Register(n3, true));
            this.stack_D.add(new Register(n3, true));
            this.stack_A.add(new Register(n3, true));
            ++n3;
        }
    }

    public static class Register {
        private int id;
        private boolean isTemp;

        public int getNumber() {
            return this.id;
        }

        public void setNumber(int n) {
            this.id = n;
        }

        public boolean isTemp() {
            return this.isTemp;
        }

        public String toString() {
            return (this.isTemp ? "T" : "R") + this.id;
        }

        Register(int n, boolean bl) {
            this.id = n;
            this.isTemp = bl;
        }
    }
}

