/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Class;
import Clazz.jq_Field;
import Clazz.jq_Method;
import Clazz.jq_Type;
import Compil3r.Analysis.FlowInsensitive.MethodSummary;
import Compil3r.Analysis.IPA.ProgramLocation;
import Compil3r.Quad.AndersenPointerAnalysis;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Main.HostedVM;
import Main.TraceFlags;
import Util.Assert;
import Util.Collections.FilterIterator;
import Util.Collections.LinearSet;
import Util.Collections.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class PointerExplorer {
    public static final BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    public static AndersenPointerAnalysis apa;
    public static Map callGraph;
    public static Set rootSet;
    public static Set selectedCallSites;
    public static Map methodToCallSites;
    public static Map toInline;
    public static List inlineCommands;

    public static jq_Method getMethod(Set set) throws IOException {
        int n;
        jq_Method jq_Method2;
        int n2 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            jq_Method2 = (jq_Method)iterator.next();
            System.out.println(++n2 + ": " + jq_Method2);
        }
        while (true) {
            System.out.print("Which method? ");
            iterator = in.readLine();
            try {
                n = Integer.parseInt((String)((Object)iterator));
                if (n >= 1 && n <= n2) break;
                System.out.println("Out of range: " + n);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Not a number: " + (String)((Object)iterator));
            }
        }
        iterator = set.iterator();
        do {
            jq_Method2 = (jq_Method)iterator.next();
        } while (++n2 != n);
        return jq_Method2;
    }

    public static jq_Method getMethod() throws IOException {
        return PointerExplorer.getMethod(null, 0);
    }

    public static jq_Method getMethod(String[] stringArray, int n) throws IOException {
        String string;
        if (stringArray != null && stringArray.length > n) {
            string = stringArray[n];
        } else {
            System.out.print("Enter the name of the class: ");
            string = in.readLine();
        }
        jq_Type jq_Type2 = jq_Type.parseType(string);
        if (!(jq_Type2 instanceof jq_Class)) {
            System.out.println("Error, " + string + " (" + jq_Type2 + ") is not a valid class.");
            System.exit(-1);
        }
        jq_Class jq_Class2 = (jq_Class)jq_Type2;
        jq_Class2.prepare();
        String string2 = stringArray != null && stringArray.length > n + 1 ? stringArray[n + 1] : null;
        return PointerExplorer.getMethod(jq_Class2, string2);
    }

    public static jq_Method getMethod(jq_Class jq_Class2, String string) throws IOException {
        jq_Method jq_Method2;
        block12: {
            int n;
            jq_Method[] jq_MethodArray;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                while (true) {
                    jq_Method[] jq_MethodArray2 = bl ? jq_Class2.getDeclaredStaticMethods() : jq_Class2.getDeclaredInstanceMethods();
                    int n2 = 0;
                    while (n2 < jq_MethodArray2.length) {
                        if (string2.equals(jq_MethodArray2[n2].getName().toString())) {
                            jq_Method2 = jq_MethodArray2[n2];
                            break block12;
                        }
                        ++n2;
                    }
                    if (bl) {
                        System.out.println("Error, no method named " + string2 + " is declared in class " + jq_Class2.getName());
                        System.exit(-1);
                    }
                    bl = true;
                }
            }
            boolean bl = true;
            block4: while (true) {
                System.out.println((bl ? "Static" : "Instance") + " methods:");
                jq_MethodArray = bl ? jq_Class2.getDeclaredStaticMethods() : jq_Class2.getDeclaredInstanceMethods();
                n = 0;
                while (n < jq_MethodArray.length) {
                    System.out.println(n + 1 + ": " + jq_MethodArray[n]);
                    ++n;
                }
                while (true) {
                    System.out.print("Which method, or " + (bl ? "'i' for instance" : "'s' for static") + " methods: ");
                    String string3 = in.readLine();
                    try {
                        if (string3.equalsIgnoreCase("s")) {
                            bl = true;
                            continue block4;
                        }
                        if (string3.equalsIgnoreCase("i")) {
                            bl = false;
                            continue block4;
                        }
                        n = Integer.parseInt(string3);
                        if (n >= 1 && n <= jq_MethodArray.length) break block4;
                        System.out.println("Out of range: " + n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println("Not a number: " + string3);
                    }
                }
                break;
            }
            jq_Method2 = jq_MethodArray[n - 1];
        }
        return jq_Method2;
    }

    public static SortedSet sortByNumberOfTargets(Map map) {
        TreeSet treeSet = new TreeSet(new Comparator(){

            public final int compare(Object object, Object object2) {
                int n;
                Map.Entry entry = (Map.Entry)object;
                MethodSummary.CallSite callSite = (MethodSummary.CallSite)entry.getKey();
                Set set = (Set)entry.getValue();
                Map.Entry entry2 = (Map.Entry)object2;
                MethodSummary.CallSite callSite2 = (MethodSummary.CallSite)entry2.getKey();
                Set set2 = (Set)entry2.getValue();
                int n2 = set.size();
                if (n2 < (n = set2.size())) {
                    return 1;
                }
                if (n2 > n) {
                    return -1;
                }
                return callSite.toString().compareTo(callSite2.toString());
            }
        });
        treeSet.addAll(map.entrySet());
        return treeSet;
    }

    public static void selectCallSites(String string, Iterator iterator, Iterator iterator2) throws IOException {
        int n;
        Object object;
        System.out.println("Call sites with " + string + ": ");
        int n2 = 0;
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            object = (Set)entry.getValue();
            System.out.println(++n2 + ": " + entry.getKey() + '=' + object.size() + " targets");
        }
        while (true) {
            System.out.print("Enter your selection, or 'a' for all: ");
            object = in.readLine();
            if (((String)object).equalsIgnoreCase("a")) {
                n = -1;
                break;
            }
            if (((String)object).equalsIgnoreCase("q")) {
                n = -2;
                break;
            }
            try {
                n = Integer.parseInt((String)object);
                if (n < 1 || n > n2) continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Cannot parse number: " + (String)object);
                continue;
            }
            break;
        }
        int n3 = 0;
        while (n3 < n2) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (n == n3 + 1 || n == -1) {
                selectedCallSites.add(entry.getKey());
            }
            if (n == n3 + 1) {
                System.out.println("Selected " + entry);
            }
            ++n3;
        }
    }

    static void printAllInclusionEdges(HashSet hashSet, MethodSummary.Node node, MethodSummary.Node node2, String string, boolean bl, jq_Field jq_Field2, boolean bl2) throws IOException {
        block24: {
            Object object;
            block23: {
                boolean bl3;
                Object object2;
                Object object3;
                Object object4;
                if (bl2) {
                    System.out.print(string + "Node: " + node2);
                }
                if (node != null && (object = PointerExplorer.apa.edgesToReasons.get(new Pair(node, node2))) != null && bl2) {
                    System.out.print(" from " + object);
                }
                if (hashSet.contains(node2)) {
                    if (bl2) {
                        System.out.println(" <duplicate>, skipping.");
                    }
                    return;
                }
                hashSet.add(node2);
                if (bl2) {
                    System.out.println();
                }
                if (!(node2 instanceof MethodSummary.OutsideNode)) break block23;
                object = (MethodSummary.OutsideNode)node2;
                while (((MethodSummary.OutsideNode)object).skip != null) {
                    if (bl2) {
                        System.out.println(string + object + " equivalent to " + ((MethodSummary.OutsideNode)object).skip);
                    }
                    object = ((MethodSummary.OutsideNode)object).skip;
                }
                if (object instanceof MethodSummary.FieldNode) {
                    object4 = (MethodSummary.FieldNode)object;
                    jq_Field jq_Field3 = ((MethodSummary.FieldNode)object4).getField();
                    object3 = ((MethodSummary.FieldNode)object4).getAccessPathPredecessors();
                    System.out.println(string + "Field " + jq_Field3.getName().toString() + " Parent nodes: " + object3);
                    System.out.print(string + "Type 'w' to find matching writes to parent nodes, 'u' to go up: ");
                    object2 = in.readLine();
                    if (object2 != null) {
                        MethodSummary.Node node3;
                        Iterator iterator;
                        if (((String)object2).equalsIgnoreCase("u")) {
                            iterator = object3.iterator();
                            while (iterator.hasNext()) {
                                node3 = (MethodSummary.Node)iterator.next();
                                PointerExplorer.printAllInclusionEdges(hashSet, null, node3, string + '<', bl, jq_Field3, true);
                            }
                        } else if (((String)object2).equalsIgnoreCase("w")) {
                            iterator = object3.iterator();
                            while (iterator.hasNext()) {
                                node3 = (MethodSummary.Node)iterator.next();
                                PointerExplorer.printAllInclusionEdges(hashSet, null, node3, string + '<', bl, jq_Field3, false);
                            }
                        }
                    }
                }
                if ((object4 = (Set)PointerExplorer.apa.nodeToInclusionEdges.get(object)) == null) break block24;
                boolean bl4 = false;
                if (bl || !bl2) {
                    bl4 = true;
                }
                if (!(bl3 = bl4)) {
                    System.out.print(string + object4.size() + " out edges, print them? ('y' for yes, 'a' for all) ");
                    object3 = in.readLine();
                    if (((String)object3).equalsIgnoreCase("y")) {
                        bl3 = true;
                    } else if (((String)object3).equalsIgnoreCase("a")) {
                        bl3 = true;
                        bl = true;
                    }
                }
                if (bl3) {
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object2 = (MethodSummary.Node)object3.next();
                        PointerExplorer.printAllInclusionEdges(hashSet, (MethodSummary.Node)object, (MethodSummary.Node)object2, string + ' ', bl, null, bl2);
                    }
                }
                break block24;
            }
            object = node2.getNonEscapingEdges(jq_Field2);
            if (object.size() > 0) {
                System.out.println(string + object.size() + " write edges match field " + (jq_Field2 == null ? "[]" : jq_Field2.getName().toString()));
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    MethodSummary.Node node4 = (MethodSummary.Node)iterator.next();
                    PointerExplorer.printAllInclusionEdges(hashSet, null, node4, string + '>', bl, null, bl2);
                }
            }
        }
    }

    public static void recalculateInliningCompleteness() {
        int n = 0;
        Iterator iterator = toInline.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            MethodSummary.CallSite callSite = (MethodSummary.CallSite)entry.getKey();
            InlineSet inlineSet = (InlineSet)entry.getValue();
            Set set = (Set)callGraph.get(callSite);
            if (set == null || !inlineSet.containsAll((Collection)set)) continue;
            ++n;
            inlineSet.is_complete = true;
        }
        System.out.println(n + " inlining sites are complete.");
    }

    public static void doInlining(Set set) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            MethodSummary.CallSite callSite = (MethodSummary.CallSite)entry.getKey();
            MethodSummary methodSummary = MethodSummary.getSummary(CodeCache.getCode(callSite.getCaller().getMethod()));
            ProgramLocation programLocation = callSite.getLocation();
            callSite = new MethodSummary.CallSite(methodSummary, programLocation);
            InlineSet inlineSet = (InlineSet)entry.getValue();
            Iterator iterator2 = inlineSet.iterator();
            if (!iterator2.hasNext()) {
                System.out.println("No targets to inline for " + callSite);
                continue;
            }
            do {
                boolean bl;
                jq_Method jq_Method2 = (jq_Method)iterator2.next();
                boolean bl2 = false;
                if (!iterator2.hasNext() && inlineSet.isComplete()) {
                    bl2 = bl = true;
                }
                if (jq_Method2.getBytecode() == null) continue;
                MethodSummary methodSummary2 = MethodSummary.getSummary(CodeCache.getCode(jq_Method2));
                MethodSummary methodSummary3 = methodSummary.copy();
                MethodSummary methodSummary4 = methodSummary2.copy();
                if (methodSummary == methodSummary2 || methodSummary2.getCalls().contains(programLocation)) {
                    System.out.println("Inlining of recursive call not supported yet: " + callSite);
                    continue;
                }
                if (!methodSummary.getCalls().contains(programLocation)) {
                    System.out.println("Error: cannot find call site " + callSite);
                    continue;
                }
                try {
                    MethodSummary.instantiate(methodSummary, programLocation, methodSummary2, bl);
                }
                catch (Throwable throwable) {
                    System.err.println("EXCEPTION while instantiating " + methodSummary2 + " into " + methodSummary + " mc=" + programLocation);
                    throwable.printStackTrace();
                    MethodSummary.TRACE_INST = true;
                    MethodSummary.TRACE_INTRA = true;
                    MethodSummary.TRACE_INTER = true;
                    MethodSummary.instantiate(methodSummary3, programLocation, methodSummary4, bl);
                }
            } while (iterator2.hasNext());
        }
    }

    static int setDepth(LinkedHashSet linkedHashSet, HashMap hashMap, jq_Method jq_Method2) {
        if (linkedHashSet.contains(jq_Method2)) {
            System.out.println("Attempting to inline recursive cycle: method " + jq_Method2);
            return -1;
        }
        Integer n = (Integer)hashMap.get(jq_Method2);
        if (n != null) {
            return n;
        }
        linkedHashSet.add(jq_Method2);
        HashSet hashSet = (HashSet)methodToCallSites.get(jq_Method2);
        int n2 = 0;
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            block0: while (iterator.hasNext()) {
                MethodSummary.CallSite callSite = (MethodSummary.CallSite)iterator.next();
                InlineSet inlineSet = (InlineSet)toInline.get(callSite);
                Iterator iterator2 = inlineSet.iterator();
                while (iterator2.hasNext()) {
                    jq_Method jq_Method3 = (jq_Method)iterator2.next();
                    int n3 = PointerExplorer.setDepth(linkedHashSet, hashMap, jq_Method3);
                    if (n3 == -1) {
                        System.out.println("Removing call site " + callSite + " from inline set");
                        iterator.remove();
                        toInline.remove(callSite);
                        continue block0;
                    }
                    n2 = Math.max(n2, n3 + 1);
                }
            }
        }
        n = new Integer(n2);
        hashMap.put(jq_Method2, n);
        linkedHashSet.remove(jq_Method2);
        return n2;
    }

    public static Set[] reorderInlineSites(Map map) {
        Object object;
        if (map.isEmpty()) {
            return new Set[0];
        }
        System.out.println("Reordering call sites to inline...");
        methodToCallSites.clear();
        Object object2 = map.keySet().iterator();
        while (object2.hasNext()) {
            object = (MethodSummary.CallSite)object2.next();
            HashSet<MethodSummary.CallSite> hashSet = (HashSet<MethodSummary.CallSite>)methodToCallSites.get(((MethodSummary.CallSite)object).getCaller().getMethod());
            if (hashSet == null) {
                hashSet = new HashSet<MethodSummary.CallSite>();
                methodToCallSites.put(((MethodSummary.CallSite)object).getCaller().getMethod(), hashSet);
            }
            hashSet.add((MethodSummary.CallSite)object);
        }
        System.out.println(methodToCallSites.size() + " methods contain sites to inline");
        object2 = new HashMap();
        object = new LinkedHashSet();
        int n = 0;
        Set[] setArray = methodToCallSites.keySet().iterator();
        while (setArray.hasNext()) {
            jq_Method jq_Method2 = (jq_Method)setArray.next();
            if (((HashMap)object2).containsKey(jq_Method2)) continue;
            int n2 = PointerExplorer.setDepth((LinkedHashSet)object, (HashMap)object2, jq_Method2);
            n = Math.max(n, n2 + 1);
        }
        System.out.println("Longest inlining chain: " + n);
        setArray = new Set[n];
        int n3 = 0;
        while (n3 < n) {
            setArray[n3] = new LinkedHashSet();
            ++n3;
        }
        Iterator iterator = ((HashMap)object2).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            jq_Method jq_Method3 = (jq_Method)entry.getKey();
            Integer n4 = (Integer)entry.getValue();
            Set set = (Set)methodToCallSites.get(jq_Method3);
            if (set == null) continue;
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                MethodSummary.CallSite callSite = (MethodSummary.CallSite)iterator2.next();
                InlineSet inlineSet = (InlineSet)map.get(callSite);
                setArray[n4].add(new Map.Entry(callSite, inlineSet){
                    final /* synthetic */ MethodSummary.CallSite val$cs;
                    final /* synthetic */ InlineSet val$targets;

                    public final Object getKey() {
                        return this.val$cs;
                    }

                    public final Object getValue() {
                        return this.val$targets;
                    }

                    public final Object setValue(Object object) {
                        throw new UnsupportedOperationException();
                    }
                    {
                        this.val$cs = callSite;
                        this.val$targets = inlineSet;
                    }
                });
            }
        }
        return setArray;
    }

    public static void doInlining() {
        if (!toInline.isEmpty()) {
            inlineCommands.add(toInline);
        }
        Iterator iterator = inlineCommands.iterator();
        while (iterator.hasNext()) {
            toInline = (LinkedHashMap)iterator.next();
            System.out.println("Inlining " + toInline.size() + " call sites.");
            Set[] setArray = PointerExplorer.reorderInlineSites(toInline);
            int n = 0;
            while (n < setArray.length) {
                PointerExplorer.doInlining(setArray[n]);
                ++n;
            }
        }
        toInline = new LinkedHashMap();
    }

    static int setDepth_clone(HashMap hashMap, HashMap hashMap2, LinkedHashSet linkedHashSet, HashMap hashMap3, jq_Method jq_Method2) {
        if (linkedHashSet.contains(jq_Method2)) {
            System.out.println("Attempting to clone recursive cycle: method " + jq_Method2);
            return -1;
        }
        Integer n = (Integer)hashMap3.get(jq_Method2);
        if (n != null) {
            return n;
        }
        linkedHashSet.add(jq_Method2);
        Set set = (Set)hashMap.get(jq_Method2);
        int n2 = 0;
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Specialization specialization = (Specialization)iterator.next();
                boolean bl = false;
                if (specialization.target.getMethod() == jq_Method2) {
                    bl = true;
                }
                Assert._assert(bl);
                Set set2 = (Set)hashMap2.get(specialization);
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    ProgramLocation programLocation = (ProgramLocation)iterator2.next();
                    jq_Method jq_Method3 = programLocation.getMethod();
                    int n3 = PointerExplorer.setDepth_clone(hashMap, hashMap2, linkedHashSet, hashMap3, jq_Method3);
                    if (n3 == -1) continue;
                    n2 = Math.max(n2, n3 + 1);
                }
                if (!set2.isEmpty()) continue;
                System.out.println("Removed all specializations for method " + jq_Method2);
                iterator.remove();
            }
        }
        n = new Integer(n2);
        hashMap3.put(jq_Method2, n);
        linkedHashSet.remove(jq_Method2);
        return n2;
    }

    public static void buildCloneCache(HashMap hashMap) {
        Object object;
        Object object2;
        Iterator iterator;
        Object object3;
        Object object4;
        Object object5;
        Map.Entry entry;
        Iterator iterator2;
        int n;
        int n2;
        Object object6;
        Object object7;
        System.out.println(hashMap.size() + " specializations");
        HashMap<jq_Method, LinkedHashSet<Specialization>> hashMap2 = new HashMap<jq_Method, LinkedHashSet<Specialization>>();
        Object object8 = hashMap.keySet().iterator();
        while (object8.hasNext()) {
            object7 = (Specialization)object8.next();
            jq_Method jq_Method2 = ((Specialization)object7).target.getMethod();
            object6 = (LinkedHashSet<Specialization>)hashMap2.get(jq_Method2);
            if (object6 == null) {
                object6 = new LinkedHashSet<Specialization>();
                hashMap2.put(jq_Method2, (LinkedHashSet<Specialization>)object6);
            }
            n2 = object6.add(object7);
            Assert._assert(n2 != 0, ((Specialization)object7).toString());
        }
        System.out.println(hashMap2.size() + " different methods are to be specialized");
        object8 = new LinkedHashSet();
        object7 = new HashMap();
        int n3 = 0;
        object6 = hashMap2.keySet().iterator();
        while (object6.hasNext()) {
            jq_Method jq_Method3 = (jq_Method)object6.next();
            n = PointerExplorer.setDepth_clone(hashMap2, hashMap, (LinkedHashSet)object8, (HashMap)object7, jq_Method3);
            n3 = Math.max(n3, n);
        }
        System.out.println("Max cloning depth: " + n3);
        object6 = new Collection[n3 + 1];
        n2 = 0;
        while (n2 < ((Collection[])object6).length) {
            object6[n2] = new LinkedList();
            ++n2;
        }
        Object object9 = ((HashMap)object7).entrySet().iterator();
        while (object9.hasNext()) {
            Map.Entry entry2 = object9.next();
            iterator2 = (jq_Method)entry2.getKey();
            entry = (Integer)entry2.getValue();
            object6[(Integer)((Object)entry)].add(iterator2);
        }
        object9 = new HashMap();
        n = 0;
        while (n < ((Collection[])object6).length) {
            iterator2 = object6[n];
            entry = iterator2.iterator();
            while (entry.hasNext()) {
                object5 = (jq_Method)entry.next();
                object4 = (Set)hashMap2.get(object5);
                if (object4 == null) continue;
                object3 = CodeCache.getCode((jq_Method)object5);
                iterator = object4.iterator();
                while (iterator.hasNext()) {
                    object2 = (Specialization)iterator.next();
                    object = MethodSummary.getSummary((ControlFlowGraph)object3).copy();
                    boolean bl = false;
                    if (((HashMap)object9).get(object2) == null) {
                        bl = true;
                    }
                    Assert._assert(bl);
                    ((HashMap)object9).put(object2, object);
                }
            }
            ++n;
        }
        n = 0;
        iterator2 = ((HashMap)object9).entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = iterator2.next();
            object5 = (Specialization)entry.getKey();
            object4 = (MethodSummary)entry.getValue();
            object3 = (Set)hashMap.get(object5);
            n += object3.size();
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                MethodSummary.CallSite callSite;
                MethodSummary methodSummary;
                Object object10;
                Object object11;
                object2 = (ProgramLocation)iterator.next();
                object = ((ProgramLocation)object2).getMethod();
                Set set = (Set)hashMap2.get(object);
                if (set != null) {
                    object11 = set.iterator();
                    while (object11.hasNext()) {
                        object10 = (Specialization)object11.next();
                        methodSummary = (MethodSummary)((HashMap)object9).get(object10);
                        callSite = new MethodSummary.CallSite(methodSummary, (ProgramLocation)object2);
                        ControlFlowGraph controlFlowGraph = CodeCache.getCode(((MethodSummary)object4).getMethod());
                        MethodSummary.clone_cache.put(new Pair(controlFlowGraph, callSite), object4);
                    }
                }
                object11 = CodeCache.getCode(((MethodSummary)object4).getMethod());
                object10 = CodeCache.getCode((jq_Method)object);
                methodSummary = MethodSummary.getSummary((ControlFlowGraph)object10);
                callSite = new MethodSummary.CallSite(methodSummary, (ProgramLocation)object2);
                MethodSummary.clone_cache.put(new Pair(object11, callSite), object4);
            }
        }
        System.out.println("Specializing a total of " + n + " call sites.");
    }

    public static void main(String[] stringArray) throws IOException {
        HostedVM.initialize();
        int n = 0;
        int n2 = -1;
        while (n != n2 && n < stringArray.length) {
            n2 = n;
            n = TraceFlags.setTraceFlag(stringArray, n2);
        }
        System.out.println("Select the root method.");
        jq_Method jq_Method2 = PointerExplorer.getMethod(stringArray, n);
        rootSet.add(jq_Method2);
        ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method2);
        apa = new AndersenPointerAnalysis(false);
        apa.addToRootSet(controlFlowGraph);
        System.out.println("Performing initial context-insensitive analysis...");
        long l = System.currentTimeMillis();
        apa.iterate();
        l = System.currentTimeMillis() - l;
        System.out.println("Time to complete: " + l);
        callGraph = apa.getCallGraph();
        SortedSet sortedSet = PointerExplorer.sortByNumberOfTargets(callGraph);
        block7: while (true) {
            Object object;
            Object object2;
            Map.Entry entry;
            Object object3;
            System.out.print("Enter command: ");
            String string = in.readLine();
            if (string == null) {
                System.out.println("Exiting.");
                System.exit(0);
            }
            if (string.startsWith("histogram")) {
                Map map = AndersenPointerAnalysis.buildOriginalCallGraph(callGraph);
                System.out.println("Comparison:");
                System.out.println(AndersenPointerAnalysis.compareWithOriginal(callGraph, map));
                continue;
            }
            if (string.startsWith("stats")) {
                System.out.println(apa.computeStats());
                continue;
            }
            if (string.startsWith("callgraph")) {
                System.out.println(apa.getCallGraph());
                continue;
            }
            if (string.startsWith("addroot")) {
                jq_Method2 = PointerExplorer.getMethod();
                rootSet.add(jq_Method2);
                continue;
            }
            if (string.startsWith("trace summary ")) {
                boolean bl;
                MethodSummary.TRACE_INTRA = bl = string.substring(14).equals("on");
                System.out.println("Trace summary: " + bl);
                continue;
            }
            if (string.startsWith("trace inline ")) {
                boolean bl;
                MethodSummary.TRACE_INTER = bl = string.substring(13).equals("on");
                MethodSummary.TRACE_INST = bl;
                System.out.println("Trace inline: " + bl);
                continue;
            }
            if (string.startsWith("trace andersen ")) {
                boolean bl;
                AndersenPointerAnalysis.TRACE = bl = string.substring(15).equals("on");
                System.out.println("Trace Andersen: " + bl);
                continue;
            }
            if (string.startsWith("inline")) {
                System.out.println("Marking " + selectedCallSites.size() + " call sites for inlining.");
                int n3 = 0;
                object3 = selectedCallSites.iterator();
                while (object3.hasNext()) {
                    entry = (MethodSummary.CallSite)((Object)object3.next());
                    object2 = (Set)callGraph.get(entry);
                    if (object2 == null) {
                        System.out.println("Error: call site " + entry + " not found in call graph.");
                        continue;
                    }
                    object = new InlineSet((Set)object2, true);
                    toInline.put(entry, object);
                    n3 += object2.size();
                }
                System.out.println("Total number of target methods: " + n3);
                continue;
            }
            if (string.startsWith("run")) {
                MethodSummary.clone_cache = null;
                MethodSummary.clearSummaryCache();
                PointerExplorer.doInlining();
                selectedCallSites.clear();
                System.gc();
                apa = new AndersenPointerAnalysis(false);
                Iterator iterator = rootSet.iterator();
                while (iterator.hasNext()) {
                    jq_Method2 = (jq_Method)iterator.next();
                    controlFlowGraph = CodeCache.getCode(jq_Method2);
                    apa.addToRootSet(controlFlowGraph);
                }
                System.out.println("Re-running context-insensitive analysis...");
                l = System.currentTimeMillis();
                try {
                    apa.iterate();
                }
                catch (Throwable throwable) {
                    System.err.println("EXCEPTION while iterating: " + throwable);
                    throwable.printStackTrace();
                }
                l = System.currentTimeMillis() - l;
                System.out.println("Time to complete: " + l);
                callGraph = apa.getCallGraph();
                sortedSet = PointerExplorer.sortByNumberOfTargets(callGraph);
                continue;
            }
            if (string.startsWith("source")) {
                jq_Method jq_Method3 = PointerExplorer.getMethod();
                object3 = new FilterIterator.Filter(jq_Method3){
                    final /* synthetic */ jq_Method val$m2;

                    public final boolean isElement(Object object) {
                        Map.Entry entry = (Map.Entry)object;
                        MethodSummary.CallSite callSite = (MethodSummary.CallSite)entry.getKey();
                        boolean bl = false;
                        if (callSite.getCaller().getMethod() == this.val$m2) {
                            bl = true;
                        }
                        return bl;
                    }
                    {
                        this.val$m2 = jq_Method2;
                    }
                };
                entry = new FilterIterator(sortedSet.iterator(), (FilterIterator.Filter)object3);
                object2 = new FilterIterator(sortedSet.iterator(), (FilterIterator.Filter)object3);
                PointerExplorer.selectCallSites("caller=" + jq_Method2, entry, (Iterator)object2);
                continue;
            }
            if (string.startsWith("targets")) {
                jq_Method2 = PointerExplorer.getMethod();
                int n4 = 0;
                object3 = callGraph.entrySet().iterator();
                while (object3.hasNext()) {
                    entry = object3.next();
                    object2 = (Set)entry.getValue();
                    if (!object2.contains(jq_Method2)) continue;
                    selectedCallSites.add(entry.getKey());
                    ++n4;
                }
                System.out.println("Selected " + n4 + " call sites.");
                continue;
            }
            if (string.startsWith("basepointers")) {
                Iterator iterator = selectedCallSites.iterator();
                block11: while (true) {
                    if (!iterator.hasNext()) continue block7;
                    object3 = (MethodSummary.CallSite)iterator.next();
                    System.out.println("For call site: " + object3);
                    entry = ((MethodSummary.CallSite)object3).getCaller();
                    object2 = new LinkedHashSet();
                    object = new MethodSummary.PassedParameter(((MethodSummary.CallSite)object3).getLocation(), 0);
                    ((MethodSummary)((Object)entry)).getNodesThatCall((MethodSummary.PassedParameter)object, (Set)object2);
                    Iterator iterator2 = ((HashSet)object2).iterator();
                    while (true) {
                        if (!iterator2.hasNext()) continue block11;
                        MethodSummary.Node node = (MethodSummary.Node)iterator2.next();
                        PointerExplorer.printAllInclusionEdges(new HashSet(), null, node, "", false, null, true);
                    }
                    break;
                }
            }
            if (string.startsWith("clearselection")) {
                selectedCallSites.clear();
                continue;
            }
            if (string.startsWith("printselection")) {
                System.out.println(selectedCallSites);
                continue;
            }
            if (string.startsWith("summary")) {
                jq_Method2 = PointerExplorer.getMethod();
                MethodSummary methodSummary = MethodSummary.getSummary(CodeCache.getCode(jq_Method2));
                System.out.println(methodSummary);
                continue;
            }
            if (string.startsWith("printsize ")) {
                try {
                    int n5 = Integer.parseInt(string.substring(10));
                    object3 = new FilterIterator.Filter(n5){
                        final /* synthetic */ int val$size;

                        public final boolean isElement(Object object) {
                            Map.Entry entry = (Map.Entry)object;
                            Set set = (Set)entry.getValue();
                            boolean bl = false;
                            if (set.size() >= this.val$size) {
                                bl = true;
                            }
                            return bl;
                        }
                        {
                            this.val$size = n;
                        }
                    };
                    entry = new FilterIterator(sortedSet.iterator(), (FilterIterator.Filter)object3);
                    while (true) {
                        if (!((FilterIterator)((Object)entry)).hasNext()) continue block7;
                        System.out.println(((FilterIterator)((Object)entry)).next());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid size: " + string.substring(5));
                }
                continue;
            }
            if (string.startsWith("selectmultitarget")) {
                FilterIterator.Filter filter = new FilterIterator.Filter(){

                    public final boolean isElement(Object object) {
                        Map.Entry entry = (Map.Entry)object;
                        Set set = (Set)entry.getValue();
                        boolean bl = false;
                        if (set.size() > 1) {
                            bl = true;
                        }
                        return bl;
                    }
                };
                object3 = new FilterIterator(sortedSet.iterator(), filter);
                while (((FilterIterator)object3).hasNext()) {
                    entry = (Map.Entry)((FilterIterator)object3).next();
                    selectedCallSites.add(entry.getKey());
                }
                System.out.println(selectedCallSites.size() + " call sites selected");
                continue;
            }
            if (string.startsWith("size ")) {
                try {
                    int n6 = Integer.parseInt(string.substring(5));
                    object3 = new FilterIterator.Filter(n6){
                        final /* synthetic */ int val$size;

                        public final boolean isElement(Object object) {
                            Map.Entry entry = (Map.Entry)object;
                            Set set = (Set)entry.getValue();
                            boolean bl = false;
                            if (set.size() == this.val$size) {
                                bl = true;
                            }
                            return bl;
                        }
                        {
                            this.val$size = n;
                        }
                    };
                    entry = new FilterIterator(sortedSet.iterator(), (FilterIterator.Filter)object3);
                    object2 = new FilterIterator(sortedSet.iterator(), (FilterIterator.Filter)object3);
                    PointerExplorer.selectCallSites("size=" + n6, (Iterator)((Object)entry), (Iterator)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Invalid size: " + string.substring(5));
                }
                continue;
            }
            if (string.startsWith("exit") || string.startsWith("quit")) {
                System.exit(0);
            }
            System.out.println("Unknown command: " + string);
        }
    }

    static {
        rootSet = new LinkedHashSet();
        selectedCallSites = new LinkedHashSet();
        methodToCallSites = new HashMap();
        toInline = new LinkedHashMap();
        inlineCommands = new LinkedList();
    }

    public static class InlineSet
    extends AbstractSet {
        final Set backing_set;
        boolean is_complete;

        public boolean isComplete() {
            return this.is_complete;
        }

        public Iterator iterator() {
            return this.backing_set.iterator();
        }

        public int size() {
            return this.backing_set.size();
        }

        public boolean containsAll(Collection collection) {
            return this.backing_set.containsAll(collection);
        }

        public InlineSet(Set set, boolean bl) {
            this.backing_set = set;
            this.is_complete = bl;
        }
    }

    public static class Specialization {
        ControlFlowGraph target;
        Set set;

        public boolean equals(Object object) {
            return this.equals((Specialization)object);
        }

        public boolean equals(Specialization specialization) {
            if (this.target != specialization.target) {
                return false;
            }
            return this.set.equals(specialization.set);
        }

        public int hashCode() {
            return this.target.hashCode() ^ this.set.hashCode();
        }

        public String toString() {
            return "Specialization of " + this.target.getMethod() + " on " + this.set;
        }

        Specialization(ControlFlowGraph controlFlowGraph, SpecializationParameter specializationParameter) {
            this.target = controlFlowGraph;
            this.set = new LinearSet();
            this.set.add(specializationParameter);
        }

        Specialization(ControlFlowGraph controlFlowGraph, Set set) {
            this.target = controlFlowGraph;
            this.set = set;
        }
    }

    public static class SpecializationParameter {
        int paramNum;
        AndersenPointerAnalysis.AccessPath ap;
        Set types;

        public boolean equals(Object object) {
            return this.equals((SpecializationParameter)object);
        }

        public boolean equals(SpecializationParameter specializationParameter) {
            if (this.paramNum != specializationParameter.paramNum || !this.types.equals(specializationParameter.types)) {
                return false;
            }
            if (this.ap == specializationParameter.ap) {
                return true;
            }
            if (this.ap == null || specializationParameter.ap == null) {
                return false;
            }
            return this.ap.equals(specializationParameter.ap);
        }

        public int hashCode() {
            int n = 0;
            if (this.ap != null) {
                n = this.ap.hashCode();
            }
            int n2 = n;
            return this.paramNum ^ this.types.hashCode() ^ n2;
        }

        public String toString() {
            if (this.ap == null) {
                return "Param#" + this.paramNum + " types: " + this.types;
            }
            return "Param#" + this.paramNum + this.ap.toString() + " types: " + this.types;
        }

        SpecializationParameter(int n, AndersenPointerAnalysis.AccessPath accessPath, Set set) {
            this.paramNum = n;
            this.ap = accessPath;
            this.types = set;
        }
    }
}

