/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_InstanceField;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Clazz.jq_StaticField;
import Clazz.jq_Type;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.NullDelegates;
import Compil3r.Quad.Operand;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadVisitor;
import Compil3r.Quad.RegisterFactory;
import Interpreter.QuadInterpreter;
import Main.jq;
import Memory.Address;
import Memory.HeapAddress;
import Run_Time.MathSupport;
import Run_Time.Reflection;
import Run_Time.TypeCheck;
import Util.Assert;
import Util.Templates.UnmodifiableList;
import java.lang.reflect.Array;

public abstract class Operator {
    public static final UnmodifiableList.RegisterOperand noregisters = new UnmodifiableList.RegisterOperand(new Operand.RegisterOperand[0]);
    public static final UnmodifiableList.jq_Class noexceptions = new UnmodifiableList.jq_Class(new jq_Class[0]);
    public static final UnmodifiableList.jq_Class anyexception;
    public static final UnmodifiableList.jq_Class resolutionexceptions;
    public static final UnmodifiableList.jq_Class nullptrexception;
    public static final UnmodifiableList.jq_Class arrayboundsexception;
    public static final UnmodifiableList.jq_Class arithexception;
    public static final UnmodifiableList.jq_Class arraystoreexception;
    public static final UnmodifiableList.jq_Class negativesizeexception;
    public static final UnmodifiableList.jq_Class classcastexceptions;
    public static final UnmodifiableList.jq_Class illegalmonitorstateexception;
    protected static Delegate _delegate;

    public void accept(Quad quad, QuadVisitor quadVisitor) {
        quadVisitor.visitQuad(quad);
    }

    public UnmodifiableList.jq_Class getThrownExceptions() {
        return noexceptions;
    }

    public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
        return noregisters;
    }

    public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
        return noregisters;
    }

    public abstract boolean hasSideEffects();

    public abstract void interpret(Quad var1, QuadInterpreter var2);

    static int getIntOpValue(Operand operand, QuadInterpreter quadInterpreter) {
        if (operand instanceof Operand.RegisterOperand) {
            return ((Number)quadInterpreter.getReg(((Operand.RegisterOperand)operand).getRegister())).intValue();
        }
        return ((Operand.IConstOperand)operand).getValue();
    }

    static float getFloatOpValue(Operand operand, QuadInterpreter quadInterpreter) {
        if (operand instanceof Operand.RegisterOperand) {
            return ((Float)quadInterpreter.getReg(((Operand.RegisterOperand)operand).getRegister())).floatValue();
        }
        return ((Operand.FConstOperand)operand).getValue();
    }

    static long getLongOpValue(Operand operand, QuadInterpreter quadInterpreter) {
        if (operand instanceof Operand.RegisterOperand) {
            return (Long)quadInterpreter.getReg(((Operand.RegisterOperand)operand).getRegister());
        }
        return ((Operand.LConstOperand)operand).getValue();
    }

    static double getDoubleOpValue(Operand operand, QuadInterpreter quadInterpreter) {
        if (operand instanceof Operand.RegisterOperand) {
            return (Double)quadInterpreter.getReg(((Operand.RegisterOperand)operand).getRegister());
        }
        return ((Operand.DConstOperand)operand).getValue();
    }

    static Object getObjectOpValue(Operand operand, QuadInterpreter quadInterpreter) {
        if (operand instanceof Operand.RegisterOperand) {
            return quadInterpreter.getReg(((Operand.RegisterOperand)operand).getRegister());
        }
        return ((Operand.AConstOperand)operand).getValue();
    }

    static Address getAddressOpValue(Operand operand, QuadInterpreter quadInterpreter) {
        if (operand instanceof Operand.RegisterOperand) {
            return (Address)quadInterpreter.getReg(((Operand.RegisterOperand)operand).getRegister());
        }
        return ((Operand.PConstOperand)operand).getValue();
    }

    static Object getWrappedOpValue(Operand operand, QuadInterpreter quadInterpreter) {
        if (operand instanceof Operand.RegisterOperand) {
            return quadInterpreter.getReg(((Operand.RegisterOperand)operand).getRegister());
        }
        if (operand instanceof Operand.AConstOperand) {
            return ((Operand.AConstOperand)operand).getValue();
        }
        if (operand instanceof Operand.PConstOperand) {
            Assert.TODO();
        } else {
            if (operand instanceof Operand.IConstOperand) {
                return new Integer(((Operand.IConstOperand)operand).getValue());
            }
            if (operand instanceof Operand.FConstOperand) {
                return new Float(((Operand.FConstOperand)operand).getValue());
            }
            if (operand instanceof Operand.LConstOperand) {
                return new Long(((Operand.LConstOperand)operand).getValue());
            }
            if (operand instanceof Operand.DConstOperand) {
                return new Double(((Operand.DConstOperand)operand).getValue());
            }
        }
        Assert.UNREACHABLE();
        return null;
    }

    public static UnmodifiableList.RegisterOperand getReg1(Quad quad) {
        return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1());
    }

    public static UnmodifiableList.RegisterOperand getReg1_check(Quad quad) {
        if (quad.getOp1() instanceof Operand.RegisterOperand) {
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1());
        }
        return noregisters;
    }

    public static UnmodifiableList.RegisterOperand getReg2(Quad quad) {
        if (quad.getOp2() instanceof Operand.RegisterOperand) {
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp2());
        }
        return noregisters;
    }

    public static UnmodifiableList.RegisterOperand getReg3(Quad quad) {
        if (quad.getOp3() instanceof Operand.RegisterOperand) {
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp3());
        }
        return noregisters;
    }

    protected static UnmodifiableList.RegisterOperand getReg12(Quad quad) {
        if (quad.getOp1() instanceof Operand.RegisterOperand) {
            if (quad.getOp2() instanceof Operand.RegisterOperand) {
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp2());
            }
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1());
        }
        if (quad.getOp2() instanceof Operand.RegisterOperand) {
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp2());
        }
        return noregisters;
    }

    protected static UnmodifiableList.RegisterOperand getReg23(Quad quad) {
        if (quad.getOp2() instanceof Operand.RegisterOperand) {
            if (quad.getOp3() instanceof Operand.RegisterOperand) {
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp2(), (Operand.RegisterOperand)quad.getOp3());
            }
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp2());
        }
        if (quad.getOp3() instanceof Operand.RegisterOperand) {
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp3());
        }
        return noregisters;
    }

    protected static UnmodifiableList.RegisterOperand getReg24(Quad quad) {
        if (quad.getOp2() instanceof Operand.RegisterOperand) {
            if (quad.getOp4() instanceof Operand.RegisterOperand) {
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp2(), (Operand.RegisterOperand)quad.getOp4());
            }
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp2());
        }
        if (quad.getOp4() instanceof Operand.RegisterOperand) {
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp4());
        }
        return noregisters;
    }

    protected static UnmodifiableList.RegisterOperand getReg124(Quad quad) {
        if (quad.getOp1() instanceof Operand.RegisterOperand) {
            if (quad.getOp2() instanceof Operand.RegisterOperand) {
                if (quad.getOp4() instanceof Operand.RegisterOperand) {
                    return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp2(), (Operand.RegisterOperand)quad.getOp4());
                }
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp2());
            }
            if (quad.getOp4() instanceof Operand.RegisterOperand) {
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp4());
            }
            return noregisters;
        }
        return Operator.getReg24(quad);
    }

    protected static UnmodifiableList.RegisterOperand getReg123(Quad quad) {
        if (quad.getOp1() instanceof Operand.RegisterOperand) {
            if (quad.getOp2() instanceof Operand.RegisterOperand) {
                if (quad.getOp3() instanceof Operand.RegisterOperand) {
                    return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp2(), (Operand.RegisterOperand)quad.getOp3());
                }
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp2());
            }
            if (quad.getOp3() instanceof Operand.RegisterOperand) {
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp3());
            }
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1());
        }
        return Operator.getReg23(quad);
    }

    protected static UnmodifiableList.RegisterOperand getReg234(Quad quad) {
        if (quad.getOp2() instanceof Operand.RegisterOperand) {
            if (quad.getOp3() instanceof Operand.RegisterOperand) {
                if (quad.getOp4() instanceof Operand.RegisterOperand) {
                    return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp2(), (Operand.RegisterOperand)quad.getOp3(), (Operand.RegisterOperand)quad.getOp4());
                }
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp2(), (Operand.RegisterOperand)quad.getOp3());
            }
            if (quad.getOp4() instanceof Operand.RegisterOperand) {
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp2(), (Operand.RegisterOperand)quad.getOp4());
            }
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp2());
        }
        if (quad.getOp3() instanceof Operand.RegisterOperand) {
            if (quad.getOp4() instanceof Operand.RegisterOperand) {
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp3(), (Operand.RegisterOperand)quad.getOp4());
            }
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp3());
        }
        if (quad.getOp4() instanceof Operand.RegisterOperand) {
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp4());
        }
        return noregisters;
    }

    protected static UnmodifiableList.RegisterOperand getReg1234(Quad quad) {
        if (quad.getOp1() instanceof Operand.RegisterOperand) {
            if (quad.getOp2() instanceof Operand.RegisterOperand) {
                if (quad.getOp3() instanceof Operand.RegisterOperand) {
                    if (quad.getOp4() instanceof Operand.RegisterOperand) {
                        return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp2(), (Operand.RegisterOperand)quad.getOp3(), (Operand.RegisterOperand)quad.getOp4());
                    }
                    return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp2(), (Operand.RegisterOperand)quad.getOp3());
                }
                if (quad.getOp4() instanceof Operand.RegisterOperand) {
                    return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp2(), (Operand.RegisterOperand)quad.getOp4());
                }
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp2());
            }
            if (quad.getOp3() instanceof Operand.RegisterOperand) {
                if (quad.getOp4() instanceof Operand.RegisterOperand) {
                    return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp3(), (Operand.RegisterOperand)quad.getOp4());
                }
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp3());
            }
            if (quad.getOp4() instanceof Operand.RegisterOperand) {
                return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1(), (Operand.RegisterOperand)quad.getOp4());
            }
            return new UnmodifiableList.RegisterOperand((Operand.RegisterOperand)quad.getOp1());
        }
        return Operator.getReg234(quad);
    }

    private static final Delegate attemptDelegate(String string) {
        String string2 = "quad-operator delegate";
        try {
            Class<?> clazz = Class.forName(string);
            return (Delegate)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find " + string2 + ' ' + string + ": " + classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Cannot instantiate " + string2 + ' ' + string + ": " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access " + string2 + ' ' + string + ": " + illegalAccessException);
        }
        return null;
    }

    static {
        resolutionexceptions = anyexception = new UnmodifiableList.jq_Class(PrimordialClassLoader.getJavaLangThrowable());
        nullptrexception = new UnmodifiableList.jq_Class(PrimordialClassLoader.getJavaLangNullPointerException());
        arrayboundsexception = new UnmodifiableList.jq_Class(PrimordialClassLoader.getJavaLangArrayIndexOutOfBoundsException());
        arraystoreexception = new UnmodifiableList.jq_Class(PrimordialClassLoader.getJavaLangArrayStoreException());
        negativesizeexception = new UnmodifiableList.jq_Class(PrimordialClassLoader.getJavaLangNegativeArraySizeException());
        arithexception = new UnmodifiableList.jq_Class(PrimordialClassLoader.getJavaLangArithmeticException());
        classcastexceptions = new UnmodifiableList.jq_Class(PrimordialClassLoader.getJavaLangThrowable());
        illegalmonitorstateexception = new UnmodifiableList.jq_Class(PrimordialClassLoader.getJavaLangIllegalMonitorStateException());
        _delegate = null;
        boolean bl = jq.nullVM;
        if (!bl) {
            _delegate = Operator.attemptDelegate("Compil3r.Quad.Delegates$Op");
        }
        if (_delegate == null) {
            _delegate = new NullDelegates.Op();
        }
    }

    public static abstract class Move
    extends Operator {
        public static Quad create(int n, Move move, Operand.RegisterOperand registerOperand, Operand operand) {
            return new Quad(n, move, registerOperand, operand);
        }

        public static Move getMoveOp(jq_Type jq_Type2) {
            if (jq_Type2.isAddressType()) {
                return MOVE_P.INSTANCE;
            }
            if (jq_Type2.isReferenceType()) {
                return MOVE_A.INSTANCE;
            }
            if (jq_Type2.isIntLike()) {
                return MOVE_I.INSTANCE;
            }
            if (jq_Type2 == jq_Primitive.FLOAT) {
                return MOVE_F.INSTANCE;
            }
            if (jq_Type2 == jq_Primitive.LONG) {
                return MOVE_L.INSTANCE;
            }
            if (jq_Type2 == jq_Primitive.DOUBLE) {
                return MOVE_D.INSTANCE;
            }
            Assert.UNREACHABLE();
            return null;
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp2();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public boolean hasSideEffects() {
            return false;
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return Move.getReg1(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return Move.getReg2(quad);
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitMove(quad);
            super.accept(quad, quadVisitor);
        }

        public static class MOVE_I
        extends Move {
            public static final MOVE_I INSTANCE = new MOVE_I();

            public String toString() {
                return "MOVE_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_I(MOVE_I.getDest(quad).getRegister(), MOVE_I.getIntOpValue(MOVE_I.getSrc(quad), quadInterpreter));
            }

            private MOVE_I() {
            }
        }

        public static class MOVE_F
        extends Move {
            public static final MOVE_F INSTANCE = new MOVE_F();

            public String toString() {
                return "MOVE_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_F(MOVE_F.getDest(quad).getRegister(), MOVE_F.getFloatOpValue(MOVE_F.getSrc(quad), quadInterpreter));
            }

            private MOVE_F() {
            }
        }

        public static class MOVE_L
        extends Move {
            public static final MOVE_L INSTANCE = new MOVE_L();

            public String toString() {
                return "MOVE_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_L(MOVE_L.getDest(quad).getRegister(), MOVE_L.getLongOpValue(MOVE_L.getSrc(quad), quadInterpreter));
            }

            private MOVE_L() {
            }
        }

        public static class MOVE_D
        extends Move {
            public static final MOVE_D INSTANCE = new MOVE_D();

            public String toString() {
                return "MOVE_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_D(MOVE_D.getDest(quad).getRegister(), MOVE_D.getDoubleOpValue(MOVE_D.getSrc(quad), quadInterpreter));
            }

            private MOVE_D() {
            }
        }

        public static class MOVE_A
        extends Move {
            public static final MOVE_A INSTANCE = new MOVE_A();

            public String toString() {
                return "MOVE_A";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_A(MOVE_A.getDest(quad).getRegister(), MOVE_A.getObjectOpValue(MOVE_A.getSrc(quad), quadInterpreter));
            }

            private MOVE_A() {
            }
        }

        public static class MOVE_P
        extends Move {
            public static final MOVE_P INSTANCE = new MOVE_P();

            public String toString() {
                return "MOVE_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_P(MOVE_P.getDest(quad).getRegister(), MOVE_P.getAddressOpValue(MOVE_P.getSrc(quad), quadInterpreter));
            }

            private MOVE_P() {
            }
        }
    }

    public static abstract class Binary
    extends Operator {
        public static Quad create(int n, Binary binary, Operand.RegisterOperand registerOperand, Operand operand, Operand operand2) {
            return new Quad(n, binary, registerOperand, operand, operand2);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand getSrc1(Quad quad) {
            return quad.getOp2();
        }

        public static Operand getSrc2(Quad quad) {
            return quad.getOp3();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setSrc1(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setSrc2(Quad quad, Operand operand) {
            quad.setOp3(operand);
        }

        public boolean hasSideEffects() {
            return false;
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return Binary.getReg1(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return Binary.getReg23(quad);
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitBinary(quad);
            super.accept(quad, quadVisitor);
        }

        public static class ADD_I
        extends Binary {
            public static final ADD_I INSTANCE = new ADD_I();

            public String toString() {
                return "ADD_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = ADD_I.getIntOpValue(ADD_I.getSrc1(quad), quadInterpreter) + ADD_I.getIntOpValue(ADD_I.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(ADD_I.getDest(quad).getRegister(), n);
            }

            private ADD_I() {
            }
        }

        public static class SUB_I
        extends Binary {
            public static final SUB_I INSTANCE = new SUB_I();

            public String toString() {
                return "SUB_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = SUB_I.getIntOpValue(SUB_I.getSrc1(quad), quadInterpreter) - SUB_I.getIntOpValue(SUB_I.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(SUB_I.getDest(quad).getRegister(), n);
            }

            private SUB_I() {
            }
        }

        public static class MUL_I
        extends Binary {
            public static final MUL_I INSTANCE = new MUL_I();

            public String toString() {
                return "MUL_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = MUL_I.getIntOpValue(MUL_I.getSrc1(quad), quadInterpreter) * MUL_I.getIntOpValue(MUL_I.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(MUL_I.getDest(quad).getRegister(), n);
            }

            private MUL_I() {
            }
        }

        public static class DIV_I
        extends Binary {
            public static final DIV_I INSTANCE = new DIV_I();

            public String toString() {
                return "DIV_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = DIV_I.getIntOpValue(DIV_I.getSrc1(quad), quadInterpreter) / DIV_I.getIntOpValue(DIV_I.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(DIV_I.getDest(quad).getRegister(), n);
            }

            private DIV_I() {
            }
        }

        public static class REM_I
        extends Binary {
            public static final REM_I INSTANCE = new REM_I();

            public String toString() {
                return "REM_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = REM_I.getIntOpValue(REM_I.getSrc1(quad), quadInterpreter) % REM_I.getIntOpValue(REM_I.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(REM_I.getDest(quad).getRegister(), n);
            }

            private REM_I() {
            }
        }

        public static class AND_I
        extends Binary {
            public static final AND_I INSTANCE = new AND_I();

            public String toString() {
                return "AND_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = AND_I.getIntOpValue(AND_I.getSrc1(quad), quadInterpreter) & AND_I.getIntOpValue(AND_I.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(AND_I.getDest(quad).getRegister(), n);
            }

            private AND_I() {
            }
        }

        public static class OR_I
        extends Binary {
            public static final OR_I INSTANCE = new OR_I();

            public String toString() {
                return "OR_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = OR_I.getIntOpValue(OR_I.getSrc1(quad), quadInterpreter) | OR_I.getIntOpValue(OR_I.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(OR_I.getDest(quad).getRegister(), n);
            }

            private OR_I() {
            }
        }

        public static class XOR_I
        extends Binary {
            public static final XOR_I INSTANCE = new XOR_I();

            public String toString() {
                return "XOR_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = XOR_I.getIntOpValue(XOR_I.getSrc1(quad), quadInterpreter) ^ XOR_I.getIntOpValue(XOR_I.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(XOR_I.getDest(quad).getRegister(), n);
            }

            private XOR_I() {
            }
        }

        public static class SHL_I
        extends Binary {
            public static final SHL_I INSTANCE = new SHL_I();

            public String toString() {
                return "SHL_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = SHL_I.getIntOpValue(SHL_I.getSrc1(quad), quadInterpreter) << SHL_I.getIntOpValue(SHL_I.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(SHL_I.getDest(quad).getRegister(), n);
            }

            private SHL_I() {
            }
        }

        public static class SHR_I
        extends Binary {
            public static final SHR_I INSTANCE = new SHR_I();

            public String toString() {
                return "SHR_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = SHR_I.getIntOpValue(SHR_I.getSrc1(quad), quadInterpreter) >> SHR_I.getIntOpValue(SHR_I.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(SHR_I.getDest(quad).getRegister(), n);
            }

            private SHR_I() {
            }
        }

        public static class USHR_I
        extends Binary {
            public static final USHR_I INSTANCE = new USHR_I();

            public String toString() {
                return "USHR_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = USHR_I.getIntOpValue(USHR_I.getSrc1(quad), quadInterpreter) >>> USHR_I.getIntOpValue(USHR_I.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(USHR_I.getDest(quad).getRegister(), n);
            }

            private USHR_I() {
            }
        }

        public static class SHL_L
        extends Binary {
            public static final SHL_L INSTANCE = new SHL_L();

            public String toString() {
                return "SHL_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l = SHL_L.getLongOpValue(SHL_L.getSrc1(quad), quadInterpreter) << SHL_L.getIntOpValue(SHL_L.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_L(SHL_L.getDest(quad).getRegister(), l);
            }

            private SHL_L() {
            }
        }

        public static class SHR_L
        extends Binary {
            public static final SHR_L INSTANCE = new SHR_L();

            public String toString() {
                return "SHR_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l = SHR_L.getLongOpValue(SHR_L.getSrc1(quad), quadInterpreter) >> SHR_L.getIntOpValue(SHR_L.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_L(SHR_L.getDest(quad).getRegister(), l);
            }

            private SHR_L() {
            }
        }

        public static class USHR_L
        extends Binary {
            public static final USHR_L INSTANCE = new USHR_L();

            public String toString() {
                return "USHR_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l = USHR_L.getLongOpValue(USHR_L.getSrc1(quad), quadInterpreter) >>> USHR_L.getIntOpValue(USHR_L.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_L(USHR_L.getDest(quad).getRegister(), l);
            }

            private USHR_L() {
            }
        }

        public static class ADD_L
        extends Binary {
            public static final ADD_L INSTANCE = new ADD_L();

            public String toString() {
                return "ADD_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l = ADD_L.getLongOpValue(ADD_L.getSrc1(quad), quadInterpreter) + ADD_L.getLongOpValue(ADD_L.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_L(ADD_L.getDest(quad).getRegister(), l);
            }

            private ADD_L() {
            }
        }

        public static class SUB_L
        extends Binary {
            public static final SUB_L INSTANCE = new SUB_L();

            public String toString() {
                return "SUB_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l = SUB_L.getLongOpValue(SUB_L.getSrc1(quad), quadInterpreter) - SUB_L.getLongOpValue(SUB_L.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_L(SUB_L.getDest(quad).getRegister(), l);
            }

            private SUB_L() {
            }
        }

        public static class MUL_L
        extends Binary {
            public static final MUL_L INSTANCE = new MUL_L();

            public String toString() {
                return "MUL_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l = MUL_L.getLongOpValue(MUL_L.getSrc1(quad), quadInterpreter) * MUL_L.getLongOpValue(MUL_L.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_L(MUL_L.getDest(quad).getRegister(), l);
            }

            private MUL_L() {
            }
        }

        public static class DIV_L
        extends Binary {
            public static final DIV_L INSTANCE = new DIV_L();

            public String toString() {
                return "DIV_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l = DIV_L.getLongOpValue(DIV_L.getSrc1(quad), quadInterpreter) / DIV_L.getLongOpValue(DIV_L.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_L(DIV_L.getDest(quad).getRegister(), l);
            }

            private DIV_L() {
            }
        }

        public static class REM_L
        extends Binary {
            public static final REM_L INSTANCE = new REM_L();

            public String toString() {
                return "REM_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l = REM_L.getLongOpValue(REM_L.getSrc1(quad), quadInterpreter) % REM_L.getLongOpValue(REM_L.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_L(REM_L.getDest(quad).getRegister(), l);
            }

            private REM_L() {
            }
        }

        public static class AND_L
        extends Binary {
            public static final AND_L INSTANCE = new AND_L();

            public String toString() {
                return "AND_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l = AND_L.getLongOpValue(AND_L.getSrc1(quad), quadInterpreter) & AND_L.getLongOpValue(AND_L.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_L(AND_L.getDest(quad).getRegister(), l);
            }

            private AND_L() {
            }
        }

        public static class OR_L
        extends Binary {
            public static final OR_L INSTANCE = new OR_L();

            public String toString() {
                return "OR_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l = OR_L.getLongOpValue(OR_L.getSrc1(quad), quadInterpreter) | OR_L.getLongOpValue(OR_L.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_L(OR_L.getDest(quad).getRegister(), l);
            }

            private OR_L() {
            }
        }

        public static class XOR_L
        extends Binary {
            public static final XOR_L INSTANCE = new XOR_L();

            public String toString() {
                return "XOR_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l = XOR_L.getLongOpValue(XOR_L.getSrc1(quad), quadInterpreter) ^ XOR_L.getLongOpValue(XOR_L.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_L(XOR_L.getDest(quad).getRegister(), l);
            }

            private XOR_L() {
            }
        }

        public static class ADD_F
        extends Binary {
            public static final ADD_F INSTANCE = new ADD_F();

            public String toString() {
                return "ADD_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                float f = ADD_F.getFloatOpValue(ADD_F.getSrc1(quad), quadInterpreter) + ADD_F.getFloatOpValue(ADD_F.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_F(ADD_F.getDest(quad).getRegister(), f);
            }

            private ADD_F() {
            }
        }

        public static class SUB_F
        extends Binary {
            public static final SUB_F INSTANCE = new SUB_F();

            public String toString() {
                return "SUB_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                float f = SUB_F.getFloatOpValue(SUB_F.getSrc1(quad), quadInterpreter) - SUB_F.getFloatOpValue(SUB_F.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_F(SUB_F.getDest(quad).getRegister(), f);
            }

            private SUB_F() {
            }
        }

        public static class MUL_F
        extends Binary {
            public static final MUL_F INSTANCE = new MUL_F();

            public String toString() {
                return "MUL_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                float f = MUL_F.getFloatOpValue(MUL_F.getSrc1(quad), quadInterpreter) * MUL_F.getFloatOpValue(MUL_F.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_F(MUL_F.getDest(quad).getRegister(), f);
            }

            private MUL_F() {
            }
        }

        public static class DIV_F
        extends Binary {
            public static final DIV_F INSTANCE = new DIV_F();

            public String toString() {
                return "DIV_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                float f = DIV_F.getFloatOpValue(DIV_F.getSrc1(quad), quadInterpreter) / DIV_F.getFloatOpValue(DIV_F.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_F(DIV_F.getDest(quad).getRegister(), f);
            }

            private DIV_F() {
            }
        }

        public static class REM_F
        extends Binary {
            public static final REM_F INSTANCE = new REM_F();

            public String toString() {
                return "REM_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                float f = REM_F.getFloatOpValue(REM_F.getSrc1(quad), quadInterpreter) % REM_F.getFloatOpValue(REM_F.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_F(REM_F.getDest(quad).getRegister(), f);
            }

            private REM_F() {
            }
        }

        public static class ADD_D
        extends Binary {
            public static final ADD_D INSTANCE = new ADD_D();

            public String toString() {
                return "ADD_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                double d = ADD_D.getDoubleOpValue(ADD_D.getSrc1(quad), quadInterpreter) + ADD_D.getDoubleOpValue(ADD_D.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_D(ADD_D.getDest(quad).getRegister(), d);
            }

            private ADD_D() {
            }
        }

        public static class SUB_D
        extends Binary {
            public static final SUB_D INSTANCE = new SUB_D();

            public String toString() {
                return "SUB_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                double d = SUB_D.getDoubleOpValue(SUB_D.getSrc1(quad), quadInterpreter) - SUB_D.getDoubleOpValue(SUB_D.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_D(SUB_D.getDest(quad).getRegister(), d);
            }

            private SUB_D() {
            }
        }

        public static class MUL_D
        extends Binary {
            public static final MUL_D INSTANCE = new MUL_D();

            public String toString() {
                return "MUL_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                double d = MUL_D.getDoubleOpValue(MUL_D.getSrc1(quad), quadInterpreter) * MUL_D.getDoubleOpValue(MUL_D.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_D(MUL_D.getDest(quad).getRegister(), d);
            }

            private MUL_D() {
            }
        }

        public static class DIV_D
        extends Binary {
            public static final DIV_D INSTANCE = new DIV_D();

            public String toString() {
                return "DIV_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                double d = DIV_D.getDoubleOpValue(DIV_D.getSrc1(quad), quadInterpreter) / DIV_D.getDoubleOpValue(DIV_D.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_D(DIV_D.getDest(quad).getRegister(), d);
            }

            private DIV_D() {
            }
        }

        public static class REM_D
        extends Binary {
            public static final REM_D INSTANCE = new REM_D();

            public String toString() {
                return "REM_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                double d = REM_D.getDoubleOpValue(REM_D.getSrc1(quad), quadInterpreter) % REM_D.getDoubleOpValue(REM_D.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_D(REM_D.getDest(quad).getRegister(), d);
            }

            private REM_D() {
            }
        }

        public static class CMP_L
        extends Binary {
            public static final CMP_L INSTANCE = new CMP_L();

            public String toString() {
                return "CMP_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n;
                long l = CMP_L.getLongOpValue(CMP_L.getSrc1(quad), quadInterpreter);
                long l2 = CMP_L.getLongOpValue(CMP_L.getSrc2(quad), quadInterpreter);
                RegisterFactory.Register register = CMP_L.getDest(quad).getRegister();
                if (l < l2) {
                    n = -1;
                } else {
                    int n2 = 0;
                    if (l == l2) {
                        n2 = 1;
                    }
                    n = 1 - n2;
                }
                quadInterpreter.putReg_I(register, n);
            }

            private CMP_L() {
            }
        }

        public static class CMP_FL
        extends Binary {
            public static final CMP_FL INSTANCE = new CMP_FL();

            public String toString() {
                return "CMP_FL";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n;
                float f = CMP_FL.getFloatOpValue(CMP_FL.getSrc1(quad), quadInterpreter);
                float f2 = CMP_FL.getFloatOpValue(CMP_FL.getSrc2(quad), quadInterpreter);
                RegisterFactory.Register register = CMP_FL.getDest(quad).getRegister();
                if (f < f2) {
                    n = -1;
                } else {
                    int n2 = 0;
                    if (f == f2) {
                        n2 = 1;
                    }
                    n = 1 - n2;
                }
                quadInterpreter.putReg_I(register, n);
            }

            private CMP_FL() {
            }
        }

        public static class CMP_FG
        extends Binary {
            public static final CMP_FG INSTANCE = new CMP_FG();

            public String toString() {
                return "CMP_FG";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                float f = CMP_FG.getFloatOpValue(CMP_FG.getSrc1(quad), quadInterpreter);
                float f2 = CMP_FG.getFloatOpValue(CMP_FG.getSrc2(quad), quadInterpreter);
                RegisterFactory.Register register = CMP_FG.getDest(quad).getRegister();
                int n = 1;
                if (!(f > f2)) {
                    int n2 = 0;
                    if (f == f2) {
                        n2 = 1;
                    }
                    n = n2 + -1;
                }
                quadInterpreter.putReg_I(register, n);
            }

            private CMP_FG() {
            }
        }

        public static class CMP_DL
        extends Binary {
            public static final CMP_DL INSTANCE = new CMP_DL();

            public String toString() {
                return "CMP_DL";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n;
                double d = CMP_DL.getDoubleOpValue(CMP_DL.getSrc1(quad), quadInterpreter);
                double d2 = CMP_DL.getDoubleOpValue(CMP_DL.getSrc2(quad), quadInterpreter);
                RegisterFactory.Register register = CMP_DL.getDest(quad).getRegister();
                if (d < d2) {
                    n = -1;
                } else {
                    int n2 = 0;
                    if (d == d2) {
                        n2 = 1;
                    }
                    n = 1 - n2;
                }
                quadInterpreter.putReg_I(register, n);
            }

            private CMP_DL() {
            }
        }

        public static class CMP_DG
        extends Binary {
            public static final CMP_DG INSTANCE = new CMP_DG();

            public String toString() {
                return "CMP_DG";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                double d = CMP_DG.getDoubleOpValue(CMP_DG.getSrc1(quad), quadInterpreter);
                double d2 = CMP_DG.getDoubleOpValue(CMP_DG.getSrc2(quad), quadInterpreter);
                RegisterFactory.Register register = CMP_DG.getDest(quad).getRegister();
                int n = 1;
                if (!(d > d2)) {
                    int n2 = 0;
                    if (d == d2) {
                        n2 = 1;
                    }
                    n = n2 + -1;
                }
                quadInterpreter.putReg_I(register, n);
            }

            private CMP_DG() {
            }
        }

        public static class ADD_P
        extends Binary {
            public static final ADD_P INSTANCE = new ADD_P();

            public String toString() {
                return "ADD_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = ADD_P.getAddressOpValue(ADD_P.getSrc1(quad), quadInterpreter).offset(ADD_P.getIntOpValue(ADD_P.getSrc2(quad), quadInterpreter));
                quadInterpreter.putReg_P(ADD_P.getDest(quad).getRegister(), address);
            }

            private ADD_P() {
            }
        }

        public static class SUB_P
        extends Binary {
            public static final SUB_P INSTANCE = new SUB_P();

            public String toString() {
                return "SUB_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = SUB_P.getAddressOpValue(SUB_P.getSrc1(quad), quadInterpreter);
                Address address2 = SUB_P.getAddressOpValue(SUB_P.getSrc2(quad), quadInterpreter);
                quadInterpreter.putReg_I(SUB_P.getDest(quad).getRegister(), address.difference(address2));
            }

            private SUB_P() {
            }
        }

        public static class ALIGN_P
        extends Binary {
            public static final ALIGN_P INSTANCE = new ALIGN_P();

            public String toString() {
                return "ALIGN_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = ALIGN_P.getAddressOpValue(ALIGN_P.getSrc1(quad), quadInterpreter).align(ALIGN_P.getIntOpValue(ALIGN_P.getSrc2(quad), quadInterpreter));
                quadInterpreter.putReg_P(ALIGN_P.getDest(quad).getRegister(), address);
            }

            private ALIGN_P() {
            }
        }

        public static class CMP_P
        extends Binary {
            public static final CMP_P INSTANCE = new CMP_P();

            public String toString() {
                return "CMP_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n;
                Address address = CMP_P.getAddressOpValue(CMP_P.getSrc1(quad), quadInterpreter);
                Address address2 = CMP_P.getAddressOpValue(CMP_P.getSrc2(quad), quadInterpreter);
                int n2 = address.difference(address2);
                RegisterFactory.Register register = CMP_P.getDest(quad).getRegister();
                if (n2 < 0) {
                    n = -1;
                } else {
                    int n3 = 0;
                    if (n2 == 0) {
                        n3 = 1;
                    }
                    n = 1 - n3;
                }
                quadInterpreter.putReg_I(register, n);
            }

            private CMP_P() {
            }
        }
    }

    public static abstract class Unary
    extends Operator {
        public static Quad create(int n, Unary unary, Operand.RegisterOperand registerOperand, Operand operand) {
            return new Quad(n, unary, registerOperand, operand);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp2();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public boolean hasSideEffects() {
            return false;
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return Unary.getReg1(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return Unary.getReg2(quad);
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitUnary(quad);
            super.accept(quad, quadVisitor);
        }

        public static class NEG_I
        extends Unary {
            public static final NEG_I INSTANCE = new NEG_I();

            public String toString() {
                return "NEG_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_I(NEG_I.getDest(quad).getRegister(), -NEG_I.getIntOpValue(NEG_I.getSrc(quad), quadInterpreter));
            }

            private NEG_I() {
            }
        }

        public static class NEG_F
        extends Unary {
            public static final NEG_F INSTANCE = new NEG_F();

            public String toString() {
                return "NEG_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_F(NEG_F.getDest(quad).getRegister(), -NEG_F.getFloatOpValue(NEG_F.getSrc(quad), quadInterpreter));
            }

            private NEG_F() {
            }
        }

        public static class NEG_L
        extends Unary {
            public static final NEG_L INSTANCE = new NEG_L();

            public String toString() {
                return "NEG_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_L(NEG_L.getDest(quad).getRegister(), -NEG_L.getLongOpValue(NEG_L.getSrc(quad), quadInterpreter));
            }

            private NEG_L() {
            }
        }

        public static class NEG_D
        extends Unary {
            public static final NEG_D INSTANCE = new NEG_D();

            public String toString() {
                return "NEG_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_D(NEG_D.getDest(quad).getRegister(), -NEG_D.getDoubleOpValue(NEG_D.getSrc(quad), quadInterpreter));
            }

            private NEG_D() {
            }
        }

        public static class INT_2LONG
        extends Unary {
            public static final INT_2LONG INSTANCE = new INT_2LONG();

            public String toString() {
                return "INT_2LONG";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_L(INT_2LONG.getDest(quad).getRegister(), INT_2LONG.getIntOpValue(INT_2LONG.getSrc(quad), quadInterpreter));
            }

            private INT_2LONG() {
            }
        }

        public static class INT_2FLOAT
        extends Unary {
            public static final INT_2FLOAT INSTANCE = new INT_2FLOAT();

            public String toString() {
                return "INT_2FLOAT";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_F(INT_2FLOAT.getDest(quad).getRegister(), INT_2FLOAT.getIntOpValue(INT_2FLOAT.getSrc(quad), quadInterpreter));
            }

            private INT_2FLOAT() {
            }
        }

        public static class INT_2DOUBLE
        extends Unary {
            public static final INT_2DOUBLE INSTANCE = new INT_2DOUBLE();

            public String toString() {
                return "INT_2DOUBLE";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_D(INT_2DOUBLE.getDest(quad).getRegister(), INT_2DOUBLE.getIntOpValue(INT_2DOUBLE.getSrc(quad), quadInterpreter));
            }

            private INT_2DOUBLE() {
            }
        }

        public static class LONG_2INT
        extends Unary {
            public static final LONG_2INT INSTANCE = new LONG_2INT();

            public String toString() {
                return "LONG_2INT";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_I(LONG_2INT.getDest(quad).getRegister(), (int)LONG_2INT.getLongOpValue(LONG_2INT.getSrc(quad), quadInterpreter));
            }

            private LONG_2INT() {
            }
        }

        public static class LONG_2FLOAT
        extends Unary {
            public static final LONG_2FLOAT INSTANCE = new LONG_2FLOAT();

            public String toString() {
                return "LONG_2FLOAT";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_F(LONG_2FLOAT.getDest(quad).getRegister(), LONG_2FLOAT.getLongOpValue(LONG_2FLOAT.getSrc(quad), quadInterpreter));
            }

            private LONG_2FLOAT() {
            }
        }

        public static class LONG_2DOUBLE
        extends Unary {
            public static final LONG_2DOUBLE INSTANCE = new LONG_2DOUBLE();

            public String toString() {
                return "LONG_2DOUBLE";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_D(LONG_2DOUBLE.getDest(quad).getRegister(), LONG_2DOUBLE.getLongOpValue(LONG_2DOUBLE.getSrc(quad), quadInterpreter));
            }

            private LONG_2DOUBLE() {
            }
        }

        public static class FLOAT_2INT
        extends Unary {
            public static final FLOAT_2INT INSTANCE = new FLOAT_2INT();

            public String toString() {
                return "FLOAT_2INT";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_I(FLOAT_2INT.getDest(quad).getRegister(), (int)FLOAT_2INT.getFloatOpValue(FLOAT_2INT.getSrc(quad), quadInterpreter));
            }

            private FLOAT_2INT() {
            }
        }

        public static class FLOAT_2LONG
        extends Unary {
            public static final FLOAT_2LONG INSTANCE = new FLOAT_2LONG();

            public String toString() {
                return "FLOAT_2LONG";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_L(FLOAT_2LONG.getDest(quad).getRegister(), (long)FLOAT_2LONG.getFloatOpValue(FLOAT_2LONG.getSrc(quad), quadInterpreter));
            }

            private FLOAT_2LONG() {
            }
        }

        public static class FLOAT_2DOUBLE
        extends Unary {
            public static final FLOAT_2DOUBLE INSTANCE = new FLOAT_2DOUBLE();

            public String toString() {
                return "FLOAT_2DOUBLE";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_D(FLOAT_2DOUBLE.getDest(quad).getRegister(), FLOAT_2DOUBLE.getFloatOpValue(FLOAT_2DOUBLE.getSrc(quad), quadInterpreter));
            }

            private FLOAT_2DOUBLE() {
            }
        }

        public static class DOUBLE_2INT
        extends Unary {
            public static final DOUBLE_2INT INSTANCE = new DOUBLE_2INT();

            public String toString() {
                return "DOUBLE_2INT";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_I(DOUBLE_2INT.getDest(quad).getRegister(), (int)DOUBLE_2INT.getDoubleOpValue(DOUBLE_2INT.getSrc(quad), quadInterpreter));
            }

            private DOUBLE_2INT() {
            }
        }

        public static class DOUBLE_2LONG
        extends Unary {
            public static final DOUBLE_2LONG INSTANCE = new DOUBLE_2LONG();

            public String toString() {
                return "DOUBLE_2LONG";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_L(DOUBLE_2LONG.getDest(quad).getRegister(), (long)DOUBLE_2LONG.getDoubleOpValue(DOUBLE_2LONG.getSrc(quad), quadInterpreter));
            }

            private DOUBLE_2LONG() {
            }
        }

        public static class DOUBLE_2FLOAT
        extends Unary {
            public static final DOUBLE_2FLOAT INSTANCE = new DOUBLE_2FLOAT();

            public String toString() {
                return "DOUBLE_2FLOAT";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_F(DOUBLE_2FLOAT.getDest(quad).getRegister(), (float)DOUBLE_2FLOAT.getDoubleOpValue(DOUBLE_2FLOAT.getSrc(quad), quadInterpreter));
            }

            private DOUBLE_2FLOAT() {
            }
        }

        public static class INT_2BYTE
        extends Unary {
            public static final INT_2BYTE INSTANCE = new INT_2BYTE();

            public String toString() {
                return "INT_2BYTE";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_I(INT_2BYTE.getDest(quad).getRegister(), (byte)INT_2BYTE.getIntOpValue(INT_2BYTE.getSrc(quad), quadInterpreter));
            }

            private INT_2BYTE() {
            }
        }

        public static class INT_2CHAR
        extends Unary {
            public static final INT_2CHAR INSTANCE = new INT_2CHAR();

            public String toString() {
                return "INT_2CHAR";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_I(INT_2CHAR.getDest(quad).getRegister(), (char)INT_2CHAR.getIntOpValue(INT_2CHAR.getSrc(quad), quadInterpreter));
            }

            private INT_2CHAR() {
            }
        }

        public static class INT_2SHORT
        extends Unary {
            public static final INT_2SHORT INSTANCE = new INT_2SHORT();

            public String toString() {
                return "INT_2SHORT";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_I(INT_2SHORT.getDest(quad).getRegister(), (short)INT_2SHORT.getIntOpValue(INT_2SHORT.getSrc(quad), quadInterpreter));
            }

            private INT_2SHORT() {
            }
        }

        public static class OBJECT_2ADDRESS
        extends Unary {
            public static final OBJECT_2ADDRESS INSTANCE = new OBJECT_2ADDRESS();

            public String toString() {
                return "OBJECT_2ADDRESS";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = OBJECT_2ADDRESS.getObjectOpValue(OBJECT_2ADDRESS.getSrc(quad), quadInterpreter);
                HeapAddress heapAddress = HeapAddress.addressOf(object);
                quadInterpreter.putReg_P(OBJECT_2ADDRESS.getDest(quad).getRegister(), heapAddress);
            }

            private OBJECT_2ADDRESS() {
            }
        }

        public static class ADDRESS_2OBJECT
        extends Unary {
            public static final ADDRESS_2OBJECT INSTANCE = new ADDRESS_2OBJECT();

            public String toString() {
                return "ADDRESS_2OBJECT";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                HeapAddress heapAddress = (HeapAddress)ADDRESS_2OBJECT.getAddressOpValue(ADDRESS_2OBJECT.getSrc(quad), quadInterpreter);
                quadInterpreter.putReg_A(ADDRESS_2OBJECT.getDest(quad).getRegister(), heapAddress.asObject());
            }

            private ADDRESS_2OBJECT() {
            }
        }

        public static class INT_2ADDRESS
        extends Unary {
            public static final INT_2ADDRESS INSTANCE = new INT_2ADDRESS();

            public String toString() {
                return "INT_2ADDRESS";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = INT_2ADDRESS.getIntOpValue(INT_2ADDRESS.getSrc(quad), quadInterpreter);
                HeapAddress heapAddress = HeapAddress.address32(n);
                quadInterpreter.putReg_P(INT_2ADDRESS.getDest(quad).getRegister(), heapAddress);
            }

            private INT_2ADDRESS() {
            }
        }

        public static class ADDRESS_2INT
        extends Unary {
            public static final ADDRESS_2INT INSTANCE = new ADDRESS_2INT();

            public String toString() {
                return "ADDRESS_2INT";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = ADDRESS_2INT.getAddressOpValue(ADDRESS_2INT.getSrc(quad), quadInterpreter);
                quadInterpreter.putReg_I(ADDRESS_2INT.getDest(quad).getRegister(), address.to32BitValue());
            }

            private ADDRESS_2INT() {
            }
        }

        public static class ISNULL_P
        extends Unary {
            public static final ISNULL_P INSTANCE = new ISNULL_P();

            public String toString() {
                return "ISNULL_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = ISNULL_P.getAddressOpValue(ISNULL_P.getSrc(quad), quadInterpreter);
                quadInterpreter.putReg_I(ISNULL_P.getDest(quad).getRegister(), address.isNull() ? 1 : 0);
            }

            private ISNULL_P() {
            }
        }

        public static class FLOAT_2INTBITS
        extends Unary {
            public static final FLOAT_2INTBITS INSTANCE = new FLOAT_2INTBITS();

            public String toString() {
                return "FLOAT_2INTBITS";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_I(FLOAT_2INTBITS.getDest(quad).getRegister(), Float.floatToRawIntBits(FLOAT_2INTBITS.getFloatOpValue(FLOAT_2INTBITS.getSrc(quad), quadInterpreter)));
            }

            private FLOAT_2INTBITS() {
            }
        }

        public static class INTBITS_2FLOAT
        extends Unary {
            public static final INTBITS_2FLOAT INSTANCE = new INTBITS_2FLOAT();

            public String toString() {
                return "INTBITS_2FLOAT";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_F(INTBITS_2FLOAT.getDest(quad).getRegister(), Float.intBitsToFloat(INTBITS_2FLOAT.getIntOpValue(INTBITS_2FLOAT.getSrc(quad), quadInterpreter)));
            }

            private INTBITS_2FLOAT() {
            }
        }

        public static class DOUBLE_2LONGBITS
        extends Unary {
            public static final DOUBLE_2LONGBITS INSTANCE = new DOUBLE_2LONGBITS();

            public String toString() {
                return "DOUBLE_2LONGBITS";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_L(DOUBLE_2LONGBITS.getDest(quad).getRegister(), Double.doubleToRawLongBits(DOUBLE_2LONGBITS.getDoubleOpValue(DOUBLE_2LONGBITS.getSrc(quad), quadInterpreter)));
            }

            private DOUBLE_2LONGBITS() {
            }
        }

        public static class LONGBITS_2DOUBLE
        extends Unary {
            public static final LONGBITS_2DOUBLE INSTANCE = new LONGBITS_2DOUBLE();

            public String toString() {
                return "LONGBITS_2DOUBLE";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_D(LONGBITS_2DOUBLE.getDest(quad).getRegister(), Double.longBitsToDouble(LONGBITS_2DOUBLE.getLongOpValue(LONGBITS_2DOUBLE.getSrc(quad), quadInterpreter)));
            }

            private LONGBITS_2DOUBLE() {
            }
        }
    }

    public static abstract class ALoad
    extends Operator {
        public static Quad create(int n, ALoad aLoad, Operand.RegisterOperand registerOperand, Operand operand, Operand operand2, Operand operand3) {
            return new Quad(n, aLoad, registerOperand, operand, operand2, operand3);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand getBase(Quad quad) {
            return quad.getOp2();
        }

        public static Operand getIndex(Quad quad) {
            return quad.getOp3();
        }

        public static Operand getGuard(Quad quad) {
            return quad.getOp4();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setBase(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setIndex(Quad quad, Operand operand) {
            quad.setOp3(operand);
        }

        public static void setGuard(Quad quad, Operand operand) {
            quad.setOp4(operand);
        }

        public boolean hasSideEffects() {
            return false;
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return ALoad.getReg1(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return ALoad.getReg234(quad);
        }

        public abstract jq_Type getType();

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitALoad(quad);
            quadVisitor.visitArray(quad);
            quadVisitor.visitLoad(quad);
            super.accept(quad, quadVisitor);
        }

        public static class ALOAD_I
        extends ALoad {
            public static final ALOAD_I INSTANCE = new ALOAD_I();

            public String toString() {
                return "ALOAD_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int[] nArray = (int[])ALOAD_I.getObjectOpValue(ALOAD_I.getBase(quad), quadInterpreter);
                int n = ALOAD_I.getIntOpValue(ALOAD_I.getIndex(quad), quadInterpreter);
                quadInterpreter.putReg_I(ALOAD_I.getDest(quad).getRegister(), nArray[n]);
            }

            public jq_Type getType() {
                return jq_Primitive.INT;
            }

            private ALOAD_I() {
            }
        }

        public static class ALOAD_L
        extends ALoad {
            public static final ALOAD_L INSTANCE = new ALOAD_L();

            public String toString() {
                return "ALOAD_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long[] lArray = (long[])ALOAD_L.getObjectOpValue(ALOAD_L.getBase(quad), quadInterpreter);
                int n = ALOAD_L.getIntOpValue(ALOAD_L.getIndex(quad), quadInterpreter);
                quadInterpreter.putReg_L(ALOAD_L.getDest(quad).getRegister(), lArray[n]);
            }

            public jq_Type getType() {
                return jq_Primitive.LONG;
            }

            private ALOAD_L() {
            }
        }

        public static class ALOAD_F
        extends ALoad {
            public static final ALOAD_F INSTANCE = new ALOAD_F();

            public String toString() {
                return "ALOAD_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                float[] fArray = (float[])ALOAD_F.getObjectOpValue(ALOAD_F.getBase(quad), quadInterpreter);
                int n = ALOAD_F.getIntOpValue(ALOAD_F.getIndex(quad), quadInterpreter);
                quadInterpreter.putReg_F(ALOAD_F.getDest(quad).getRegister(), fArray[n]);
            }

            public jq_Type getType() {
                return jq_Primitive.FLOAT;
            }

            private ALOAD_F() {
            }
        }

        public static class ALOAD_D
        extends ALoad {
            public static final ALOAD_D INSTANCE = new ALOAD_D();

            public String toString() {
                return "ALOAD_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                double[] dArray = (double[])ALOAD_D.getObjectOpValue(ALOAD_D.getBase(quad), quadInterpreter);
                int n = ALOAD_D.getIntOpValue(ALOAD_D.getIndex(quad), quadInterpreter);
                quadInterpreter.putReg_D(ALOAD_D.getDest(quad).getRegister(), dArray[n]);
            }

            public jq_Type getType() {
                return jq_Primitive.DOUBLE;
            }

            private ALOAD_D() {
            }
        }

        public static class ALOAD_A
        extends ALoad {
            public static final ALOAD_A INSTANCE = new ALOAD_A();

            public String toString() {
                return "ALOAD_A";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object[] objectArray = (Object[])ALOAD_A.getObjectOpValue(ALOAD_A.getBase(quad), quadInterpreter);
                int n = ALOAD_A.getIntOpValue(ALOAD_A.getIndex(quad), quadInterpreter);
                quadInterpreter.putReg_A(ALOAD_A.getDest(quad).getRegister(), objectArray[n]);
            }

            public jq_Type getType() {
                return PrimordialClassLoader.getJavaLangObject();
            }

            private ALOAD_A() {
            }
        }

        public static class ALOAD_P
        extends ALoad {
            public static final ALOAD_P INSTANCE = new ALOAD_P();

            public String toString() {
                return "ALOAD_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address[] addressArray = (Address[])ALOAD_P.getObjectOpValue(ALOAD_P.getBase(quad), quadInterpreter);
                int n = ALOAD_P.getIntOpValue(ALOAD_P.getIndex(quad), quadInterpreter);
                quadInterpreter.putReg_P(ALOAD_P.getDest(quad).getRegister(), addressArray[n]);
            }

            public jq_Type getType() {
                return Address._class;
            }

            private ALOAD_P() {
            }
        }

        public static class ALOAD_B
        extends ALoad {
            public static final ALOAD_B INSTANCE = new ALOAD_B();

            public String toString() {
                return "ALOAD_B";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = ALOAD_B.getObjectOpValue(ALOAD_B.getBase(quad), quadInterpreter);
                int n = ALOAD_B.getIntOpValue(ALOAD_B.getIndex(quad), quadInterpreter);
                byte by = object instanceof byte[] ? ((byte[])object)[n] : ((boolean[])object)[n];
                quadInterpreter.putReg_D(ALOAD_B.getDest(quad).getRegister(), by);
            }

            public jq_Type getType() {
                return jq_Primitive.BYTE;
            }

            private ALOAD_B() {
            }
        }

        public static class ALOAD_C
        extends ALoad {
            public static final ALOAD_C INSTANCE = new ALOAD_C();

            public String toString() {
                return "ALOAD_C";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                char[] cArray = (char[])ALOAD_C.getObjectOpValue(ALOAD_C.getBase(quad), quadInterpreter);
                int n = ALOAD_C.getIntOpValue(ALOAD_C.getIndex(quad), quadInterpreter);
                quadInterpreter.putReg_I(ALOAD_C.getDest(quad).getRegister(), cArray[n]);
            }

            public jq_Type getType() {
                return jq_Primitive.CHAR;
            }

            private ALOAD_C() {
            }
        }

        public static class ALOAD_S
        extends ALoad {
            public static final ALOAD_S INSTANCE = new ALOAD_S();

            public String toString() {
                return "ALOAD_S";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                short[] sArray = (short[])ALOAD_S.getObjectOpValue(ALOAD_S.getBase(quad), quadInterpreter);
                int n = ALOAD_S.getIntOpValue(ALOAD_S.getIndex(quad), quadInterpreter);
                quadInterpreter.putReg_I(ALOAD_S.getDest(quad).getRegister(), sArray[n]);
            }

            public jq_Type getType() {
                return jq_Primitive.SHORT;
            }

            private ALOAD_S() {
            }
        }
    }

    public static abstract class AStore
    extends Operator {
        public static Quad create(int n, AStore aStore, Operand operand, Operand operand2, Operand operand3, Operand operand4) {
            return new Quad(n, aStore, operand, operand2, operand3, operand4);
        }

        public static Operand getValue(Quad quad) {
            return quad.getOp1();
        }

        public static Operand getBase(Quad quad) {
            return quad.getOp2();
        }

        public static Operand getIndex(Quad quad) {
            return quad.getOp3();
        }

        public static Operand getGuard(Quad quad) {
            return quad.getOp4();
        }

        public static void setValue(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public static void setBase(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setIndex(Quad quad, Operand operand) {
            quad.setOp3(operand);
        }

        public static void setGuard(Quad quad, Operand operand) {
            quad.setOp4(operand);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return AStore.getReg1234(quad);
        }

        public abstract jq_Type getType();

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitAStore(quad);
            quadVisitor.visitArray(quad);
            quadVisitor.visitStore(quad);
            super.accept(quad, quadVisitor);
        }

        public static class ASTORE_I
        extends AStore {
            public static final ASTORE_I INSTANCE = new ASTORE_I();

            public String toString() {
                return "ASTORE_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n;
                int[] nArray = (int[])ASTORE_I.getObjectOpValue(ASTORE_I.getBase(quad), quadInterpreter);
                int n2 = ASTORE_I.getIntOpValue(ASTORE_I.getIndex(quad), quadInterpreter);
                nArray[n2] = n = ASTORE_I.getIntOpValue(ASTORE_I.getValue(quad), quadInterpreter);
            }

            public jq_Type getType() {
                return jq_Primitive.INT;
            }

            private ASTORE_I() {
            }
        }

        public static class ASTORE_L
        extends AStore {
            public static final ASTORE_L INSTANCE = new ASTORE_L();

            public String toString() {
                return "ASTORE_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                long l;
                long[] lArray = (long[])ASTORE_L.getObjectOpValue(ASTORE_L.getBase(quad), quadInterpreter);
                int n = ASTORE_L.getIntOpValue(ASTORE_L.getIndex(quad), quadInterpreter);
                lArray[n] = l = ASTORE_L.getLongOpValue(ASTORE_L.getValue(quad), quadInterpreter);
            }

            public jq_Type getType() {
                return jq_Primitive.LONG;
            }

            private ASTORE_L() {
            }
        }

        public static class ASTORE_F
        extends AStore {
            public static final ASTORE_F INSTANCE = new ASTORE_F();

            public String toString() {
                return "ASTORE_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                float f;
                float[] fArray = (float[])ASTORE_F.getObjectOpValue(ASTORE_F.getBase(quad), quadInterpreter);
                int n = ASTORE_F.getIntOpValue(ASTORE_F.getIndex(quad), quadInterpreter);
                fArray[n] = f = ASTORE_F.getFloatOpValue(ASTORE_F.getValue(quad), quadInterpreter);
            }

            public jq_Type getType() {
                return jq_Primitive.FLOAT;
            }

            private ASTORE_F() {
            }
        }

        public static class ASTORE_D
        extends AStore {
            public static final ASTORE_D INSTANCE = new ASTORE_D();

            public String toString() {
                return "ASTORE_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                double d;
                double[] dArray = (double[])ASTORE_D.getObjectOpValue(ASTORE_D.getBase(quad), quadInterpreter);
                int n = ASTORE_D.getIntOpValue(ASTORE_D.getIndex(quad), quadInterpreter);
                dArray[n] = d = ASTORE_D.getDoubleOpValue(ASTORE_D.getValue(quad), quadInterpreter);
            }

            public jq_Type getType() {
                return jq_Primitive.DOUBLE;
            }

            private ASTORE_D() {
            }
        }

        public static class ASTORE_A
        extends AStore {
            public static final ASTORE_A INSTANCE = new ASTORE_A();

            public String toString() {
                return "ASTORE_A";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object;
                Object[] objectArray = (Object[])ASTORE_A.getObjectOpValue(ASTORE_A.getBase(quad), quadInterpreter);
                int n = ASTORE_A.getIntOpValue(ASTORE_A.getIndex(quad), quadInterpreter);
                objectArray[n] = object = ASTORE_A.getObjectOpValue(ASTORE_A.getValue(quad), quadInterpreter);
            }

            public jq_Type getType() {
                return PrimordialClassLoader.getJavaLangObject();
            }

            private ASTORE_A() {
            }
        }

        public static class ASTORE_P
        extends AStore {
            public static final ASTORE_P INSTANCE = new ASTORE_P();

            public String toString() {
                return "ASTORE_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address;
                Address[] addressArray = (Address[])ASTORE_P.getObjectOpValue(ASTORE_P.getBase(quad), quadInterpreter);
                int n = ASTORE_P.getIntOpValue(ASTORE_P.getIndex(quad), quadInterpreter);
                addressArray[n] = address = ASTORE_P.getAddressOpValue(ASTORE_P.getValue(quad), quadInterpreter);
            }

            public jq_Type getType() {
                return Address._class;
            }

            private ASTORE_P() {
            }
        }

        public static class ASTORE_B
        extends AStore {
            public static final ASTORE_B INSTANCE = new ASTORE_B();

            public String toString() {
                return "ASTORE_B";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = ASTORE_B.getObjectOpValue(ASTORE_B.getBase(quad), quadInterpreter);
                int n = ASTORE_B.getIntOpValue(ASTORE_B.getIndex(quad), quadInterpreter);
                if (object instanceof byte[]) {
                    ((byte[])object)[n] = (byte)ASTORE_B.getIntOpValue(ASTORE_B.getValue(quad), quadInterpreter);
                } else {
                    boolean[] blArray = (boolean[])object;
                    boolean bl = false;
                    if (ASTORE_B.getIntOpValue(ASTORE_B.getValue(quad), quadInterpreter) != 0) {
                        bl = true;
                    }
                    blArray[n] = bl;
                }
            }

            public jq_Type getType() {
                return jq_Primitive.BYTE;
            }

            private ASTORE_B() {
            }
        }

        public static class ASTORE_C
        extends AStore {
            public static final ASTORE_C INSTANCE = new ASTORE_C();

            public String toString() {
                return "ASTORE_C";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                char c;
                char[] cArray = (char[])ASTORE_C.getObjectOpValue(ASTORE_C.getBase(quad), quadInterpreter);
                int n = ASTORE_C.getIntOpValue(ASTORE_C.getIndex(quad), quadInterpreter);
                cArray[n] = c = (char)ASTORE_C.getIntOpValue(ASTORE_C.getValue(quad), quadInterpreter);
            }

            public jq_Type getType() {
                return jq_Primitive.CHAR;
            }

            private ASTORE_C() {
            }
        }

        public static class ASTORE_S
        extends AStore {
            public static final ASTORE_S INSTANCE = new ASTORE_S();

            public String toString() {
                return "ASTORE_S";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                short s;
                short[] sArray = (short[])ASTORE_S.getObjectOpValue(ASTORE_S.getBase(quad), quadInterpreter);
                int n = ASTORE_S.getIntOpValue(ASTORE_S.getIndex(quad), quadInterpreter);
                sArray[n] = s = (short)ASTORE_S.getIntOpValue(ASTORE_S.getValue(quad), quadInterpreter);
            }

            public jq_Type getType() {
                return jq_Primitive.SHORT;
            }

            private ASTORE_S() {
            }
        }
    }

    public static abstract class IntIfCmp
    extends Operator {
        public static Quad create(int n, IntIfCmp intIfCmp, Operand operand, Operand operand2, Operand.ConditionOperand conditionOperand, Operand.TargetOperand targetOperand) {
            return new Quad(n, intIfCmp, operand, operand2, conditionOperand, targetOperand);
        }

        public static Operand getSrc1(Quad quad) {
            return quad.getOp1();
        }

        public static Operand getSrc2(Quad quad) {
            return quad.getOp2();
        }

        public static Operand.ConditionOperand getCond(Quad quad) {
            return (Operand.ConditionOperand)quad.getOp3();
        }

        public static Operand.TargetOperand getTarget(Quad quad) {
            return (Operand.TargetOperand)quad.getOp4();
        }

        public static void setSrc1(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public static void setSrc2(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setCond(Quad quad, Operand.ConditionOperand conditionOperand) {
            quad.setOp3(conditionOperand);
        }

        public static void setTarget(Quad quad, Operand.TargetOperand targetOperand) {
            quad.setOp4(targetOperand);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return IntIfCmp.getReg12(quad);
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitIntIfCmp(quad);
            quadVisitor.visitCondBranch(quad);
            quadVisitor.visitBranch(quad);
            super.accept(quad, quadVisitor);
        }

        public static class IFCMP_I
        extends IntIfCmp {
            public static final IFCMP_I INSTANCE = new IFCMP_I();

            public String toString() {
                return "IFCMP_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                boolean bl;
                int n = IFCMP_I.getIntOpValue(IFCMP_I.getSrc1(quad), quadInterpreter);
                int n2 = IFCMP_I.getIntOpValue(IFCMP_I.getSrc2(quad), quadInterpreter);
                byte by = IFCMP_I.getCond(quad).getCondition();
                switch (by) {
                    case 0: {
                        boolean bl2 = false;
                        if (n == n2) {
                            bl2 = true;
                        }
                        bl = bl2;
                        break;
                    }
                    case 1: {
                        boolean bl3 = false;
                        if (n != n2) {
                            bl3 = true;
                        }
                        bl = bl3;
                        break;
                    }
                    case 2: {
                        boolean bl4 = false;
                        if (n < n2) {
                            bl4 = true;
                        }
                        bl = bl4;
                        break;
                    }
                    case 3: {
                        boolean bl5 = false;
                        if (n >= n2) {
                            bl5 = true;
                        }
                        bl = bl5;
                        break;
                    }
                    case 4: {
                        boolean bl6 = false;
                        if (n <= n2) {
                            bl6 = true;
                        }
                        bl = bl6;
                        break;
                    }
                    case 5: {
                        boolean bl7 = false;
                        if (n > n2) {
                            bl7 = true;
                        }
                        bl = bl7;
                        break;
                    }
                    case 6: {
                        bl = MathSupport.ucmp(n, n2);
                        break;
                    }
                    case 7: {
                        bl = true;
                        break;
                    }
                    default: {
                        Assert.UNREACHABLE();
                        bl = false;
                    }
                }
                if (bl) {
                    quadInterpreter.branchTo(IFCMP_I.getTarget(quad).getTarget());
                }
            }

            private IFCMP_I() {
            }
        }

        public static class IFCMP_A
        extends IntIfCmp {
            public static final IFCMP_A INSTANCE = new IFCMP_A();

            public String toString() {
                return "IFCMP_A";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                boolean bl;
                Object object = IFCMP_A.getObjectOpValue(IFCMP_A.getSrc1(quad), quadInterpreter);
                Object object2 = IFCMP_A.getObjectOpValue(IFCMP_A.getSrc2(quad), quadInterpreter);
                byte by = IFCMP_A.getCond(quad).getCondition();
                switch (by) {
                    case 0: {
                        boolean bl2 = false;
                        if (object == object2) {
                            bl2 = true;
                        }
                        bl = bl2;
                        break;
                    }
                    case 1: {
                        boolean bl3 = false;
                        if (object != object2) {
                            bl3 = true;
                        }
                        bl = bl3;
                        break;
                    }
                    case 7: {
                        bl = true;
                        break;
                    }
                    default: {
                        Assert.UNREACHABLE();
                        bl = false;
                    }
                }
                if (bl) {
                    quadInterpreter.branchTo(IFCMP_A.getTarget(quad).getTarget());
                }
            }

            private IFCMP_A() {
            }
        }

        public static class IFCMP_P
        extends IntIfCmp {
            public static final IFCMP_P INSTANCE = new IFCMP_P();

            public String toString() {
                return "IFCMP_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                boolean bl;
                Address address = IFCMP_P.getAddressOpValue(IFCMP_P.getSrc1(quad), quadInterpreter);
                Address address2 = IFCMP_P.getAddressOpValue(IFCMP_P.getSrc2(quad), quadInterpreter);
                byte by = IFCMP_P.getCond(quad).getCondition();
                switch (by) {
                    case 0: {
                        boolean bl2 = false;
                        if (address.difference(address2) == 0) {
                            bl2 = true;
                        }
                        bl = bl2;
                        break;
                    }
                    case 1: {
                        boolean bl3 = false;
                        if (address.difference(address2) != 0) {
                            bl3 = true;
                        }
                        bl = bl3;
                        break;
                    }
                    case 7: {
                        bl = true;
                        break;
                    }
                    default: {
                        Assert.UNREACHABLE();
                        bl = false;
                    }
                }
                if (bl) {
                    quadInterpreter.branchTo(IFCMP_P.getTarget(quad).getTarget());
                }
            }

            private IFCMP_P() {
            }
        }
    }

    public static abstract class Goto
    extends Operator {
        public static Quad create(int n, Goto goto_, Operand.TargetOperand targetOperand) {
            return new Quad(n, goto_, targetOperand);
        }

        public static Operand.TargetOperand getTarget(Quad quad) {
            return (Operand.TargetOperand)quad.getOp1();
        }

        public static void setTarget(Quad quad, Operand.TargetOperand targetOperand) {
            quad.setOp1(targetOperand);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitGoto(quad);
            quadVisitor.visitBranch(quad);
            super.accept(quad, quadVisitor);
        }

        public static class GOTO
        extends Goto {
            public static final GOTO INSTANCE = new GOTO();

            public String toString() {
                return "GOTO";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.branchTo(GOTO.getTarget(quad).getTarget());
            }

            private GOTO() {
            }
        }
    }

    public static abstract class Jsr
    extends Operator {
        public static Quad create(int n, Jsr jsr, Operand.RegisterOperand registerOperand, Operand.TargetOperand targetOperand, Operand.TargetOperand targetOperand2) {
            return new Quad(n, jsr, registerOperand, targetOperand, targetOperand2);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand.TargetOperand getTarget(Quad quad) {
            return (Operand.TargetOperand)quad.getOp2();
        }

        public static Operand.TargetOperand getSuccessor(Quad quad) {
            return (Operand.TargetOperand)quad.getOp3();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setTarget(Quad quad, Operand.TargetOperand targetOperand) {
            quad.setOp2(targetOperand);
        }

        public static void setSuccessor(Quad quad, Operand.TargetOperand targetOperand) {
            quad.setOp3(targetOperand);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return Jsr.getReg1(quad);
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitJsr(quad);
            quadVisitor.visitBranch(quad);
            super.accept(quad, quadVisitor);
        }

        public static class JSR
        extends Jsr {
            public static final JSR INSTANCE = new JSR();

            public String toString() {
                return "JSR";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                BasicBlock basicBlock = JSR.getSuccessor(quad).getTarget();
                quadInterpreter.putReg(JSR.getDest(quad).getRegister(), basicBlock);
                quadInterpreter.branchTo(JSR.getTarget(quad).getTarget());
            }

            private JSR() {
            }
        }
    }

    public static abstract class Ret
    extends Operator {
        public static Quad create(int n, Ret ret, Operand.RegisterOperand registerOperand) {
            return new Quad(n, ret, registerOperand);
        }

        public static Operand.RegisterOperand getTarget(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static void setTarget(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return Ret.getReg1(quad);
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitRet(quad);
            quadVisitor.visitBranch(quad);
            super.accept(quad, quadVisitor);
        }

        public static class RET
        extends Ret {
            public static final RET INSTANCE = new RET();

            public String toString() {
                return "RET";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                BasicBlock basicBlock = (BasicBlock)quadInterpreter.getReg(RET.getTarget(quad).getRegister());
                quadInterpreter.branchTo(basicBlock);
            }

            private RET() {
            }
        }
    }

    public static abstract class TableSwitch
    extends Operator {
        public static Quad create(int n, TableSwitch tableSwitch, Operand operand, Operand.IConstOperand iConstOperand, Operand.TargetOperand targetOperand, int n2) {
            return new Quad(n, tableSwitch, operand, iConstOperand, targetOperand, new Operand.BasicBlockTableOperand(new BasicBlock[n2]));
        }

        public static void setTarget(Quad quad, int n, BasicBlock basicBlock) {
            ((Operand.BasicBlockTableOperand)quad.getOp4()).set(n, basicBlock);
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp1();
        }

        public static Operand.IConstOperand getLow(Quad quad) {
            return (Operand.IConstOperand)quad.getOp2();
        }

        public static Operand.TargetOperand getDefault(Quad quad) {
            return (Operand.TargetOperand)quad.getOp3();
        }

        public static BasicBlock getTarget(Quad quad, int n) {
            return ((Operand.BasicBlockTableOperand)quad.getOp4()).get(n);
        }

        public static Operand.BasicBlockTableOperand getTargetTable(Quad quad) {
            return (Operand.BasicBlockTableOperand)quad.getOp4();
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public static void setLow(Quad quad, Operand.IConstOperand iConstOperand) {
            quad.setOp2(iConstOperand);
        }

        public static void setDefault(Quad quad, Operand.TargetOperand targetOperand) {
            quad.setOp3(targetOperand);
        }

        public static void setTargetTable(Quad quad, Operand.BasicBlockTableOperand basicBlockTableOperand) {
            quad.setOp4(basicBlockTableOperand);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return TableSwitch.getReg1_check(quad);
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitTableSwitch(quad);
            quadVisitor.visitCondBranch(quad);
            quadVisitor.visitBranch(quad);
            super.accept(quad, quadVisitor);
        }

        public static class TABLESWITCH
        extends TableSwitch {
            public static final TABLESWITCH INSTANCE = new TABLESWITCH();

            public String toString() {
                return "TABLESWITCH";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = TABLESWITCH.getIntOpValue(TABLESWITCH.getSrc(quad), quadInterpreter);
                int n2 = TABLESWITCH.getLow(quad).getValue();
                int n3 = TABLESWITCH.getTargetTable(quad).size() + n2 - 1;
                BasicBlock basicBlock = n < n2 || n > n3 ? TABLESWITCH.getDefault(quad).getTarget() : TABLESWITCH.getTarget(quad, n - n2);
                quadInterpreter.branchTo(basicBlock);
            }

            private TABLESWITCH() {
            }
        }
    }

    public static abstract class LookupSwitch
    extends Operator {
        public static Quad create(int n, LookupSwitch lookupSwitch, Operand operand, Operand.TargetOperand targetOperand, int n2) {
            return new Quad(n, lookupSwitch, operand, targetOperand, new Operand.IntValueTableOperand(new int[n2]), new Operand.BasicBlockTableOperand(new BasicBlock[n2]));
        }

        public static void setMatch(Quad quad, int n, int n2) {
            ((Operand.IntValueTableOperand)quad.getOp3()).set(n, n2);
        }

        public static void setTarget(Quad quad, int n, BasicBlock basicBlock) {
            ((Operand.BasicBlockTableOperand)quad.getOp4()).set(n, basicBlock);
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp1();
        }

        public static Operand.TargetOperand getDefault(Quad quad) {
            return (Operand.TargetOperand)quad.getOp2();
        }

        public static int getMatch(Quad quad, int n) {
            return ((Operand.IntValueTableOperand)quad.getOp3()).get(n);
        }

        public static BasicBlock getTarget(Quad quad, int n) {
            return ((Operand.BasicBlockTableOperand)quad.getOp4()).get(n);
        }

        public static Operand.IntValueTableOperand getValueTable(Quad quad) {
            return (Operand.IntValueTableOperand)quad.getOp3();
        }

        public static Operand.BasicBlockTableOperand getTargetTable(Quad quad) {
            return (Operand.BasicBlockTableOperand)quad.getOp4();
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public static void setDefault(Quad quad, Operand.TargetOperand targetOperand) {
            quad.setOp2(targetOperand);
        }

        public static void setValueTable(Quad quad, Operand.IntValueTableOperand intValueTableOperand) {
            quad.setOp3(intValueTableOperand);
        }

        public static void setTargetTable(Quad quad, Operand.BasicBlockTableOperand basicBlockTableOperand) {
            quad.setOp4(basicBlockTableOperand);
        }

        public static int getSize(Quad quad) {
            return ((Operand.IntValueTableOperand)quad.getOp3()).size();
        }

        public boolean hasSideEffects() {
            return true;
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return LookupSwitch.getReg1_check(quad);
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitLookupSwitch(quad);
            quadVisitor.visitCondBranch(quad);
            quadVisitor.visitBranch(quad);
            super.accept(quad, quadVisitor);
        }

        public static class LOOKUPSWITCH
        extends LookupSwitch {
            public static final LOOKUPSWITCH INSTANCE = new LOOKUPSWITCH();

            public String toString() {
                return "LOOKUPSWITCH";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = LOOKUPSWITCH.getIntOpValue(LOOKUPSWITCH.getSrc(quad), quadInterpreter);
                Operand.IntValueTableOperand intValueTableOperand = LOOKUPSWITCH.getValueTable(quad);
                BasicBlock basicBlock = LOOKUPSWITCH.getDefault(quad).getTarget();
                int n2 = 0;
                while (n2 < intValueTableOperand.size()) {
                    if (n == intValueTableOperand.get(n2)) {
                        basicBlock = LOOKUPSWITCH.getTargetTable(quad).get(n2);
                        break;
                    }
                    ++n2;
                }
                quadInterpreter.branchTo(basicBlock);
            }

            private LOOKUPSWITCH() {
            }
        }
    }

    public static abstract class Return
    extends Operator {
        public static Quad create(int n, Return return_, Operand operand) {
            return new Quad(n, return_, operand);
        }

        public static Quad create(int n, Return return_) {
            return new Quad(n, return_);
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp1();
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitReturn(quad);
            super.accept(quad, quadVisitor);
        }

        public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
            quadInterpreter.setReturnValue(Return.getWrappedOpValue(Return.getSrc(quad), quadInterpreter));
        }

        public static class RETURN_V
        extends Return {
            public static final RETURN_V INSTANCE = new RETURN_V();

            public String toString() {
                return "RETURN_V";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.setReturnValue(null);
            }

            private RETURN_V() {
            }
        }

        public static class RETURN_I
        extends Return {
            public static final RETURN_I INSTANCE = new RETURN_I();

            public String toString() {
                return "RETURN_I";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return RETURN_I.getReg1_check(quad);
            }

            private RETURN_I() {
            }
        }

        public static class RETURN_F
        extends Return {
            public static final RETURN_F INSTANCE = new RETURN_F();

            public String toString() {
                return "RETURN_F";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return RETURN_F.getReg1_check(quad);
            }

            private RETURN_F() {
            }
        }

        public static class RETURN_L
        extends Return {
            public static final RETURN_L INSTANCE = new RETURN_L();

            public String toString() {
                return "RETURN_L";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return RETURN_L.getReg1_check(quad);
            }

            private RETURN_L() {
            }
        }

        public static class RETURN_D
        extends Return {
            public static final RETURN_D INSTANCE = new RETURN_D();

            public String toString() {
                return "RETURN_D";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return RETURN_D.getReg1_check(quad);
            }

            private RETURN_D() {
            }
        }

        public static class RETURN_A
        extends Return {
            public static final RETURN_A INSTANCE = new RETURN_A();

            public String toString() {
                return "RETURN_A";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return RETURN_A.getReg1_check(quad);
            }

            private RETURN_A() {
            }
        }

        public static class RETURN_P
        extends Return {
            public static final RETURN_P INSTANCE = new RETURN_P();

            public String toString() {
                return "RETURN_P";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return RETURN_P.getReg1_check(quad);
            }

            private RETURN_P() {
            }
        }

        public static class THROW_A
        extends Return {
            public static final THROW_A INSTANCE = new THROW_A();

            public String toString() {
                return "THROW_A";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return THROW_A.getReg1_check(quad);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return anyexception;
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.handleException((Throwable)THROW_A.getObjectOpValue(THROW_A.getSrc(quad), quadInterpreter));
            }

            private THROW_A() {
            }
        }
    }

    public static abstract class Getstatic
    extends Operator {
        public static Quad create(int n, Getstatic getstatic, Operand.RegisterOperand registerOperand, Operand.FieldOperand fieldOperand) {
            return new Quad(n, getstatic, registerOperand, fieldOperand);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand.FieldOperand getField(Quad quad) {
            return (Operand.FieldOperand)quad.getOp2();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setField(Quad quad, Operand.FieldOperand fieldOperand) {
            quad.setOp2(fieldOperand);
        }

        public boolean hasSideEffects() {
            return false;
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return Getstatic.getReg1(quad);
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitGetstatic(quad);
            quadVisitor.visitStaticField(quad);
            quadVisitor.visitLoad(quad);
            super.accept(quad, quadVisitor);
        }

        public static class GETSTATIC_I
        extends Getstatic {
            public static final GETSTATIC_I INSTANCE = new GETSTATIC_I();

            public String toString() {
                return "GETSTATIC_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)GETSTATIC_I.getField(quad).getField();
                quadInterpreter.putReg_I(GETSTATIC_I.getDest(quad).getRegister(), Reflection.getstatic_I(jq_StaticField2));
            }

            private GETSTATIC_I() {
            }
        }

        public static class GETSTATIC_F
        extends Getstatic {
            public static final GETSTATIC_F INSTANCE = new GETSTATIC_F();

            public String toString() {
                return "GETSTATIC_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)GETSTATIC_F.getField(quad).getField();
                quadInterpreter.putReg_F(GETSTATIC_F.getDest(quad).getRegister(), Reflection.getstatic_F(jq_StaticField2));
            }

            private GETSTATIC_F() {
            }
        }

        public static class GETSTATIC_L
        extends Getstatic {
            public static final GETSTATIC_L INSTANCE = new GETSTATIC_L();

            public String toString() {
                return "GETSTATIC_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)GETSTATIC_L.getField(quad).getField();
                quadInterpreter.putReg_L(GETSTATIC_L.getDest(quad).getRegister(), Reflection.getstatic_L(jq_StaticField2));
            }

            private GETSTATIC_L() {
            }
        }

        public static class GETSTATIC_D
        extends Getstatic {
            public static final GETSTATIC_D INSTANCE = new GETSTATIC_D();

            public String toString() {
                return "GETSTATIC_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)GETSTATIC_D.getField(quad).getField();
                quadInterpreter.putReg_D(GETSTATIC_D.getDest(quad).getRegister(), Reflection.getstatic_D(jq_StaticField2));
            }

            private GETSTATIC_D() {
            }
        }

        public static class GETSTATIC_A
        extends Getstatic {
            public static final GETSTATIC_A INSTANCE = new GETSTATIC_A();

            public String toString() {
                return "GETSTATIC_A";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)GETSTATIC_A.getField(quad).getField();
                quadInterpreter.putReg_A(GETSTATIC_A.getDest(quad).getRegister(), Reflection.getstatic_A(jq_StaticField2));
            }

            private GETSTATIC_A() {
            }
        }

        public static class GETSTATIC_P
        extends Getstatic {
            public static final GETSTATIC_P INSTANCE = new GETSTATIC_P();

            public String toString() {
                return "GETSTATIC_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)GETSTATIC_P.getField(quad).getField();
                quadInterpreter.putReg_P(GETSTATIC_P.getDest(quad).getRegister(), Reflection.getstatic_P(jq_StaticField2));
            }

            private GETSTATIC_P() {
            }
        }

        public static class GETSTATIC_Z
        extends Getstatic {
            public static final GETSTATIC_Z INSTANCE = new GETSTATIC_Z();

            public String toString() {
                return "GETSTATIC_Z";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)GETSTATIC_Z.getField(quad).getField();
                quadInterpreter.putReg_I(GETSTATIC_Z.getDest(quad).getRegister(), Reflection.getstatic_Z(jq_StaticField2) ? 1 : 0);
            }

            private GETSTATIC_Z() {
            }
        }

        public static class GETSTATIC_B
        extends Getstatic {
            public static final GETSTATIC_B INSTANCE = new GETSTATIC_B();

            public String toString() {
                return "GETSTATIC_B";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)GETSTATIC_B.getField(quad).getField();
                quadInterpreter.putReg_I(GETSTATIC_B.getDest(quad).getRegister(), Reflection.getstatic_B(jq_StaticField2));
            }

            private GETSTATIC_B() {
            }
        }

        public static class GETSTATIC_C
        extends Getstatic {
            public static final GETSTATIC_C INSTANCE = new GETSTATIC_C();

            public String toString() {
                return "GETSTATIC_C";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)GETSTATIC_C.getField(quad).getField();
                quadInterpreter.putReg_I(GETSTATIC_C.getDest(quad).getRegister(), Reflection.getstatic_C(jq_StaticField2));
            }

            private GETSTATIC_C() {
            }
        }

        public static class GETSTATIC_S
        extends Getstatic {
            public static final GETSTATIC_S INSTANCE = new GETSTATIC_S();

            public String toString() {
                return "GETSTATIC_S";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)GETSTATIC_S.getField(quad).getField();
                quadInterpreter.putReg_I(GETSTATIC_S.getDest(quad).getRegister(), Reflection.getstatic_S(jq_StaticField2));
            }

            private GETSTATIC_S() {
            }
        }

        public static class GETSTATIC_I_DYNLINK
        extends GETSTATIC_I {
            public static final GETSTATIC_I_DYNLINK INSTANCE = new GETSTATIC_I_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETSTATIC_I%";
            }

            private GETSTATIC_I_DYNLINK() {
            }
        }

        public static class GETSTATIC_F_DYNLINK
        extends GETSTATIC_F {
            public static final GETSTATIC_F_DYNLINK INSTANCE = new GETSTATIC_F_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETSTATIC_F%";
            }

            private GETSTATIC_F_DYNLINK() {
            }
        }

        public static class GETSTATIC_L_DYNLINK
        extends GETSTATIC_L {
            public static final GETSTATIC_L_DYNLINK INSTANCE = new GETSTATIC_L_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETSTATIC_L%";
            }

            private GETSTATIC_L_DYNLINK() {
            }
        }

        public static class GETSTATIC_D_DYNLINK
        extends GETSTATIC_D {
            public static final GETSTATIC_D_DYNLINK INSTANCE = new GETSTATIC_D_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETSTATIC_D%";
            }

            private GETSTATIC_D_DYNLINK() {
            }
        }

        public static class GETSTATIC_A_DYNLINK
        extends GETSTATIC_A {
            public static final GETSTATIC_A_DYNLINK INSTANCE = new GETSTATIC_A_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETSTATIC_A%";
            }

            private GETSTATIC_A_DYNLINK() {
            }
        }

        public static class GETSTATIC_P_DYNLINK
        extends GETSTATIC_P {
            public static final GETSTATIC_P_DYNLINK INSTANCE = new GETSTATIC_P_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETSTATIC_P%";
            }

            private GETSTATIC_P_DYNLINK() {
            }
        }

        public static class GETSTATIC_Z_DYNLINK
        extends GETSTATIC_Z {
            public static final GETSTATIC_Z_DYNLINK INSTANCE = new GETSTATIC_Z_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETSTATIC_Z%";
            }

            private GETSTATIC_Z_DYNLINK() {
            }
        }

        public static class GETSTATIC_B_DYNLINK
        extends GETSTATIC_B {
            public static final GETSTATIC_B_DYNLINK INSTANCE = new GETSTATIC_B_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETSTATIC_B%";
            }

            private GETSTATIC_B_DYNLINK() {
            }
        }

        public static class GETSTATIC_C_DYNLINK
        extends GETSTATIC_C {
            public static final GETSTATIC_C_DYNLINK INSTANCE = new GETSTATIC_C_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETSTATIC_C%";
            }

            private GETSTATIC_C_DYNLINK() {
            }
        }

        public static class GETSTATIC_S_DYNLINK
        extends GETSTATIC_S {
            public static final GETSTATIC_S_DYNLINK INSTANCE = new GETSTATIC_S_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETSTATIC_S%";
            }

            private GETSTATIC_S_DYNLINK() {
            }
        }
    }

    public static abstract class Putstatic
    extends Operator {
        public static Quad create(int n, Putstatic putstatic, Operand operand, Operand.FieldOperand fieldOperand) {
            return new Quad(n, putstatic, operand, fieldOperand);
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp1();
        }

        public static Operand.FieldOperand getField(Quad quad) {
            return (Operand.FieldOperand)quad.getOp2();
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public static void setField(Quad quad, Operand.FieldOperand fieldOperand) {
            quad.setOp2(fieldOperand);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return Putstatic.getReg1_check(quad);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitPutstatic(quad);
            quadVisitor.visitStaticField(quad);
            quadVisitor.visitStore(quad);
            super.accept(quad, quadVisitor);
        }

        public static class PUTSTATIC_I
        extends Putstatic {
            public static final PUTSTATIC_I INSTANCE = new PUTSTATIC_I();

            public String toString() {
                return "PUTSTATIC_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)PUTSTATIC_I.getField(quad).getField();
                int n = PUTSTATIC_I.getIntOpValue(PUTSTATIC_I.getSrc(quad), quadInterpreter);
                Reflection.putstatic_I(jq_StaticField2, n);
            }

            private PUTSTATIC_I() {
            }
        }

        public static class PUTSTATIC_F
        extends Putstatic {
            public static final PUTSTATIC_F INSTANCE = new PUTSTATIC_F();

            public String toString() {
                return "PUTSTATIC_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)PUTSTATIC_F.getField(quad).getField();
                float f = PUTSTATIC_F.getFloatOpValue(PUTSTATIC_F.getSrc(quad), quadInterpreter);
                Reflection.putstatic_F(jq_StaticField2, f);
            }

            private PUTSTATIC_F() {
            }
        }

        public static class PUTSTATIC_L
        extends Putstatic {
            public static final PUTSTATIC_L INSTANCE = new PUTSTATIC_L();

            public String toString() {
                return "PUTSTATIC_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)PUTSTATIC_L.getField(quad).getField();
                long l = PUTSTATIC_L.getLongOpValue(PUTSTATIC_L.getSrc(quad), quadInterpreter);
                Reflection.putstatic_L(jq_StaticField2, l);
            }

            private PUTSTATIC_L() {
            }
        }

        public static class PUTSTATIC_D
        extends Putstatic {
            public static final PUTSTATIC_D INSTANCE = new PUTSTATIC_D();

            public String toString() {
                return "PUTSTATIC_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)PUTSTATIC_D.getField(quad).getField();
                double d = PUTSTATIC_D.getDoubleOpValue(PUTSTATIC_D.getSrc(quad), quadInterpreter);
                Reflection.putstatic_D(jq_StaticField2, d);
            }

            private PUTSTATIC_D() {
            }
        }

        public static class PUTSTATIC_A
        extends Putstatic {
            public static final PUTSTATIC_A INSTANCE = new PUTSTATIC_A();

            public String toString() {
                return "PUTSTATIC_A";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)PUTSTATIC_A.getField(quad).getField();
                Object object = PUTSTATIC_A.getObjectOpValue(PUTSTATIC_A.getSrc(quad), quadInterpreter);
                Reflection.putstatic_A(jq_StaticField2, object);
            }

            private PUTSTATIC_A() {
            }
        }

        public static class PUTSTATIC_P
        extends Putstatic {
            public static final PUTSTATIC_P INSTANCE = new PUTSTATIC_P();

            public String toString() {
                return "PUTSTATIC_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)PUTSTATIC_P.getField(quad).getField();
                Address address = PUTSTATIC_P.getAddressOpValue(PUTSTATIC_P.getSrc(quad), quadInterpreter);
                Reflection.putstatic_P(jq_StaticField2, address);
            }

            private PUTSTATIC_P() {
            }
        }

        public static class PUTSTATIC_Z
        extends Putstatic {
            public static final PUTSTATIC_Z INSTANCE = new PUTSTATIC_Z();

            public String toString() {
                return "PUTSTATIC_Z";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)PUTSTATIC_Z.getField(quad).getField();
                int n = PUTSTATIC_Z.getIntOpValue(PUTSTATIC_Z.getSrc(quad), quadInterpreter);
                boolean bl = false;
                if (n != 0) {
                    bl = true;
                }
                Reflection.putstatic_Z(jq_StaticField2, bl);
            }

            private PUTSTATIC_Z() {
            }
        }

        public static class PUTSTATIC_B
        extends Putstatic {
            public static final PUTSTATIC_B INSTANCE = new PUTSTATIC_B();

            public String toString() {
                return "PUTSTATIC_B";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)PUTSTATIC_B.getField(quad).getField();
                int n = PUTSTATIC_B.getIntOpValue(PUTSTATIC_B.getSrc(quad), quadInterpreter);
                Reflection.putstatic_B(jq_StaticField2, (byte)n);
            }

            private PUTSTATIC_B() {
            }
        }

        public static class PUTSTATIC_S
        extends Putstatic {
            public static final PUTSTATIC_S INSTANCE = new PUTSTATIC_S();

            public String toString() {
                return "PUTSTATIC_S";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)PUTSTATIC_S.getField(quad).getField();
                int n = PUTSTATIC_S.getIntOpValue(PUTSTATIC_S.getSrc(quad), quadInterpreter);
                Reflection.putstatic_S(jq_StaticField2, (short)n);
            }

            private PUTSTATIC_S() {
            }
        }

        public static class PUTSTATIC_C
        extends Putstatic {
            public static final PUTSTATIC_C INSTANCE = new PUTSTATIC_C();

            public String toString() {
                return "PUTSTATIC_C";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_StaticField jq_StaticField2 = (jq_StaticField)PUTSTATIC_C.getField(quad).getField();
                int n = PUTSTATIC_C.getIntOpValue(PUTSTATIC_C.getSrc(quad), quadInterpreter);
                Reflection.putstatic_C(jq_StaticField2, (char)n);
            }

            private PUTSTATIC_C() {
            }
        }

        public static class PUTSTATIC_I_DYNLINK
        extends PUTSTATIC_I {
            public static final PUTSTATIC_I_DYNLINK INSTANCE = new PUTSTATIC_I_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTSTATIC_I%";
            }

            private PUTSTATIC_I_DYNLINK() {
            }
        }

        public static class PUTSTATIC_F_DYNLINK
        extends PUTSTATIC_F {
            public static final PUTSTATIC_F_DYNLINK INSTANCE = new PUTSTATIC_F_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTSTATIC_F%";
            }

            private PUTSTATIC_F_DYNLINK() {
            }
        }

        public static class PUTSTATIC_L_DYNLINK
        extends PUTSTATIC_L {
            public static final PUTSTATIC_L_DYNLINK INSTANCE = new PUTSTATIC_L_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTSTATIC_L%";
            }

            private PUTSTATIC_L_DYNLINK() {
            }
        }

        public static class PUTSTATIC_D_DYNLINK
        extends PUTSTATIC_D {
            public static final PUTSTATIC_D_DYNLINK INSTANCE = new PUTSTATIC_D_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTSTATIC_D%";
            }

            private PUTSTATIC_D_DYNLINK() {
            }
        }

        public static class PUTSTATIC_A_DYNLINK
        extends PUTSTATIC_A {
            public static final PUTSTATIC_A_DYNLINK INSTANCE = new PUTSTATIC_A_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTSTATIC_A%";
            }

            private PUTSTATIC_A_DYNLINK() {
            }
        }

        public static class PUTSTATIC_P_DYNLINK
        extends PUTSTATIC_P {
            public static final PUTSTATIC_P_DYNLINK INSTANCE = new PUTSTATIC_P_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTSTATIC_P%";
            }

            private PUTSTATIC_P_DYNLINK() {
            }
        }

        public static class PUTSTATIC_Z_DYNLINK
        extends PUTSTATIC_Z {
            public static final PUTSTATIC_Z_DYNLINK INSTANCE = new PUTSTATIC_Z_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTSTATIC_Z%";
            }

            private PUTSTATIC_Z_DYNLINK() {
            }
        }

        public static class PUTSTATIC_B_DYNLINK
        extends PUTSTATIC_B {
            public static final PUTSTATIC_B_DYNLINK INSTANCE = new PUTSTATIC_B_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTSTATIC_B%";
            }

            private PUTSTATIC_B_DYNLINK() {
            }
        }

        public static class PUTSTATIC_C_DYNLINK
        extends PUTSTATIC_C {
            public static final PUTSTATIC_C_DYNLINK INSTANCE = new PUTSTATIC_C_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTSTATIC_C%";
            }

            private PUTSTATIC_C_DYNLINK() {
            }
        }

        public static class PUTSTATIC_S_DYNLINK
        extends PUTSTATIC_S {
            public static final PUTSTATIC_S_DYNLINK INSTANCE = new PUTSTATIC_S_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTSTATIC_S%";
            }

            private PUTSTATIC_S_DYNLINK() {
            }
        }
    }

    public static abstract class Getfield
    extends Operator {
        public static Quad create(int n, Getfield getfield, Operand.RegisterOperand registerOperand, Operand operand, Operand.FieldOperand fieldOperand, Operand operand2) {
            return new Quad(n, getfield, registerOperand, operand, fieldOperand, operand2);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand getBase(Quad quad) {
            return quad.getOp2();
        }

        public static Operand.FieldOperand getField(Quad quad) {
            return (Operand.FieldOperand)quad.getOp3();
        }

        public static Operand getGuard(Quad quad) {
            return quad.getOp4();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setBase(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setField(Quad quad, Operand.FieldOperand fieldOperand) {
            quad.setOp3(fieldOperand);
        }

        public static void setGuard(Quad quad, Operand operand) {
            quad.setOp4(operand);
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return Getfield.getReg1(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return Getfield.getReg24(quad);
        }

        public boolean hasSideEffects() {
            return false;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitGetfield(quad);
            quadVisitor.visitInstanceField(quad);
            quadVisitor.visitLoad(quad);
            super.accept(quad, quadVisitor);
        }

        public static class GETFIELD_I
        extends Getfield {
            public static final GETFIELD_I INSTANCE = new GETFIELD_I();

            public String toString() {
                return "GETFIELD_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = GETFIELD_I.getObjectOpValue(GETFIELD_I.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)GETFIELD_I.getField(quad).getField();
                quadInterpreter.putReg_I(GETFIELD_I.getDest(quad).getRegister(), Reflection.getfield_I(object, jq_InstanceField2));
            }

            private GETFIELD_I() {
            }
        }

        public static class GETFIELD_F
        extends Getfield {
            public static final GETFIELD_F INSTANCE = new GETFIELD_F();

            public String toString() {
                return "GETFIELD_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = GETFIELD_F.getObjectOpValue(GETFIELD_F.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)GETFIELD_F.getField(quad).getField();
                quadInterpreter.putReg_F(GETFIELD_F.getDest(quad).getRegister(), Reflection.getfield_F(object, jq_InstanceField2));
            }

            private GETFIELD_F() {
            }
        }

        public static class GETFIELD_L
        extends Getfield {
            public static final GETFIELD_L INSTANCE = new GETFIELD_L();

            public String toString() {
                return "GETFIELD_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = GETFIELD_L.getObjectOpValue(GETFIELD_L.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)GETFIELD_L.getField(quad).getField();
                quadInterpreter.putReg_L(GETFIELD_L.getDest(quad).getRegister(), Reflection.getfield_L(object, jq_InstanceField2));
            }

            private GETFIELD_L() {
            }
        }

        public static class GETFIELD_D
        extends Getfield {
            public static final GETFIELD_D INSTANCE = new GETFIELD_D();

            public String toString() {
                return "GETFIELD_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = GETFIELD_D.getObjectOpValue(GETFIELD_D.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)GETFIELD_D.getField(quad).getField();
                quadInterpreter.putReg_D(GETFIELD_D.getDest(quad).getRegister(), Reflection.getfield_D(object, jq_InstanceField2));
            }

            private GETFIELD_D() {
            }
        }

        public static class GETFIELD_A
        extends Getfield {
            public static final GETFIELD_A INSTANCE = new GETFIELD_A();

            public String toString() {
                return "GETFIELD_A";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = GETFIELD_A.getObjectOpValue(GETFIELD_A.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)GETFIELD_A.getField(quad).getField();
                quadInterpreter.putReg_A(GETFIELD_A.getDest(quad).getRegister(), Reflection.getfield_A(object, jq_InstanceField2));
            }

            private GETFIELD_A() {
            }
        }

        public static class GETFIELD_P
        extends Getfield {
            public static final GETFIELD_P INSTANCE = new GETFIELD_P();

            public String toString() {
                return "GETFIELD_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = GETFIELD_P.getObjectOpValue(GETFIELD_P.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)GETFIELD_P.getField(quad).getField();
                quadInterpreter.putReg_P(GETFIELD_P.getDest(quad).getRegister(), Reflection.getfield_P(object, jq_InstanceField2));
            }

            private GETFIELD_P() {
            }
        }

        public static class GETFIELD_B
        extends Getfield {
            public static final GETFIELD_B INSTANCE = new GETFIELD_B();

            public String toString() {
                return "GETFIELD_B";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = GETFIELD_B.getObjectOpValue(GETFIELD_B.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)GETFIELD_B.getField(quad).getField();
                quadInterpreter.putReg_I(GETFIELD_B.getDest(quad).getRegister(), Reflection.getfield_B(object, jq_InstanceField2));
            }

            private GETFIELD_B() {
            }
        }

        public static class GETFIELD_C
        extends Getfield {
            public static final GETFIELD_C INSTANCE = new GETFIELD_C();

            public String toString() {
                return "GETFIELD_C";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = GETFIELD_C.getObjectOpValue(GETFIELD_C.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)GETFIELD_C.getField(quad).getField();
                quadInterpreter.putReg_I(GETFIELD_C.getDest(quad).getRegister(), Reflection.getfield_C(object, jq_InstanceField2));
            }

            private GETFIELD_C() {
            }
        }

        public static class GETFIELD_S
        extends Getfield {
            public static final GETFIELD_S INSTANCE = new GETFIELD_S();

            public String toString() {
                return "GETFIELD_S";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = GETFIELD_S.getObjectOpValue(GETFIELD_S.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)GETFIELD_S.getField(quad).getField();
                quadInterpreter.putReg_I(GETFIELD_S.getDest(quad).getRegister(), Reflection.getfield_S(object, jq_InstanceField2));
            }

            private GETFIELD_S() {
            }
        }

        public static class GETFIELD_Z
        extends Getfield {
            public static final GETFIELD_Z INSTANCE = new GETFIELD_Z();

            public String toString() {
                return "GETFIELD_Z";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = GETFIELD_Z.getObjectOpValue(GETFIELD_Z.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)GETFIELD_Z.getField(quad).getField();
                quadInterpreter.putReg_I(GETFIELD_Z.getDest(quad).getRegister(), Reflection.getfield_Z(object, jq_InstanceField2) ? 1 : 0);
            }

            private GETFIELD_Z() {
            }
        }

        public static class GETFIELD_I_DYNLINK
        extends GETFIELD_I {
            public static final GETFIELD_I_DYNLINK INSTANCE = new GETFIELD_I_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETFIELD_I%";
            }

            private GETFIELD_I_DYNLINK() {
            }
        }

        public static class GETFIELD_F_DYNLINK
        extends GETFIELD_F {
            public static final GETFIELD_F_DYNLINK INSTANCE = new GETFIELD_F_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETFIELD_F%";
            }

            private GETFIELD_F_DYNLINK() {
            }
        }

        public static class GETFIELD_L_DYNLINK
        extends GETFIELD_L {
            public static final GETFIELD_L_DYNLINK INSTANCE = new GETFIELD_L_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETFIELD_L%";
            }

            private GETFIELD_L_DYNLINK() {
            }
        }

        public static class GETFIELD_D_DYNLINK
        extends GETFIELD_D {
            public static final GETFIELD_D_DYNLINK INSTANCE = new GETFIELD_D_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETFIELD_D%";
            }

            private GETFIELD_D_DYNLINK() {
            }
        }

        public static class GETFIELD_A_DYNLINK
        extends GETFIELD_A {
            public static final GETFIELD_A_DYNLINK INSTANCE = new GETFIELD_A_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETFIELD_A%";
            }

            private GETFIELD_A_DYNLINK() {
            }
        }

        public static class GETFIELD_P_DYNLINK
        extends GETFIELD_P {
            public static final GETFIELD_P_DYNLINK INSTANCE = new GETFIELD_P_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETFIELD_P%";
            }

            private GETFIELD_P_DYNLINK() {
            }
        }

        public static class GETFIELD_B_DYNLINK
        extends GETFIELD_B {
            public static final GETFIELD_B_DYNLINK INSTANCE = new GETFIELD_B_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETFIELD_B%";
            }

            private GETFIELD_B_DYNLINK() {
            }
        }

        public static class GETFIELD_C_DYNLINK
        extends GETFIELD_C {
            public static final GETFIELD_C_DYNLINK INSTANCE = new GETFIELD_C_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETFIELD_C%";
            }

            private GETFIELD_C_DYNLINK() {
            }
        }

        public static class GETFIELD_S_DYNLINK
        extends GETFIELD_S {
            public static final GETFIELD_S_DYNLINK INSTANCE = new GETFIELD_S_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETFIELD_S%";
            }

            private GETFIELD_S_DYNLINK() {
            }
        }

        public static class GETFIELD_Z_DYNLINK
        extends GETFIELD_Z {
            public static final GETFIELD_Z_DYNLINK INSTANCE = new GETFIELD_Z_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public boolean hasSideEffects() {
                return true;
            }

            public String toString() {
                return "GETFIELD_Z%";
            }

            private GETFIELD_Z_DYNLINK() {
            }
        }
    }

    public static abstract class Putfield
    extends Operator {
        public static Quad create(int n, Putfield putfield, Operand operand, Operand.FieldOperand fieldOperand, Operand operand2, Operand operand3) {
            return new Quad(n, putfield, operand, fieldOperand, operand2, operand3);
        }

        public static Operand getBase(Quad quad) {
            return quad.getOp1();
        }

        public static Operand.FieldOperand getField(Quad quad) {
            return (Operand.FieldOperand)quad.getOp2();
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp3();
        }

        public static Operand getGuard(Quad quad) {
            return quad.getOp4();
        }

        public static void setBase(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public static void setField(Quad quad, Operand.FieldOperand fieldOperand) {
            quad.setOp2(fieldOperand);
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp3(operand);
        }

        public static void setGuard(Quad quad, Operand operand) {
            quad.setOp4(operand);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return Putfield.getReg1234(quad);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitPutfield(quad);
            quadVisitor.visitInstanceField(quad);
            quadVisitor.visitStore(quad);
            super.accept(quad, quadVisitor);
        }

        public static class PUTFIELD_I
        extends Putfield {
            public static final PUTFIELD_I INSTANCE = new PUTFIELD_I();

            public String toString() {
                return "PUTFIELD_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = PUTFIELD_I.getObjectOpValue(PUTFIELD_I.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)PUTFIELD_I.getField(quad).getField();
                Reflection.putfield_I(object, jq_InstanceField2, PUTFIELD_I.getIntOpValue(PUTFIELD_I.getSrc(quad), quadInterpreter));
            }

            private PUTFIELD_I() {
            }
        }

        public static class PUTFIELD_F
        extends Putfield {
            public static final PUTFIELD_F INSTANCE = new PUTFIELD_F();

            public String toString() {
                return "PUTFIELD_F";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = PUTFIELD_F.getObjectOpValue(PUTFIELD_F.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)PUTFIELD_F.getField(quad).getField();
                Reflection.putfield_F(object, jq_InstanceField2, PUTFIELD_F.getFloatOpValue(PUTFIELD_F.getSrc(quad), quadInterpreter));
            }

            private PUTFIELD_F() {
            }
        }

        public static class PUTFIELD_L
        extends Putfield {
            public static final PUTFIELD_L INSTANCE = new PUTFIELD_L();

            public String toString() {
                return "PUTFIELD_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = PUTFIELD_L.getObjectOpValue(PUTFIELD_L.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)PUTFIELD_L.getField(quad).getField();
                Reflection.putfield_L(object, jq_InstanceField2, PUTFIELD_L.getLongOpValue(PUTFIELD_L.getSrc(quad), quadInterpreter));
            }

            private PUTFIELD_L() {
            }
        }

        public static class PUTFIELD_D
        extends Putfield {
            public static final PUTFIELD_D INSTANCE = new PUTFIELD_D();

            public String toString() {
                return "PUTFIELD_D";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = PUTFIELD_D.getObjectOpValue(PUTFIELD_D.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)PUTFIELD_D.getField(quad).getField();
                Reflection.putfield_D(object, jq_InstanceField2, PUTFIELD_D.getDoubleOpValue(PUTFIELD_D.getSrc(quad), quadInterpreter));
            }

            private PUTFIELD_D() {
            }
        }

        public static class PUTFIELD_A
        extends Putfield {
            public static final PUTFIELD_A INSTANCE = new PUTFIELD_A();

            public String toString() {
                return "PUTFIELD_A";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = PUTFIELD_A.getObjectOpValue(PUTFIELD_A.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)PUTFIELD_A.getField(quad).getField();
                Reflection.putfield_A(object, jq_InstanceField2, PUTFIELD_A.getObjectOpValue(PUTFIELD_A.getSrc(quad), quadInterpreter));
            }

            private PUTFIELD_A() {
            }
        }

        public static class PUTFIELD_P
        extends Putfield {
            public static final PUTFIELD_P INSTANCE = new PUTFIELD_P();

            public String toString() {
                return "PUTFIELD_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = PUTFIELD_P.getObjectOpValue(PUTFIELD_P.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)PUTFIELD_P.getField(quad).getField();
                Reflection.putfield_P(object, jq_InstanceField2, PUTFIELD_P.getAddressOpValue(PUTFIELD_P.getSrc(quad), quadInterpreter));
            }

            private PUTFIELD_P() {
            }
        }

        public static class PUTFIELD_B
        extends Putfield {
            public static final PUTFIELD_B INSTANCE = new PUTFIELD_B();

            public String toString() {
                return "PUTFIELD_B";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = PUTFIELD_B.getObjectOpValue(PUTFIELD_B.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)PUTFIELD_B.getField(quad).getField();
                Reflection.putfield_B(object, jq_InstanceField2, (byte)PUTFIELD_B.getIntOpValue(PUTFIELD_B.getSrc(quad), quadInterpreter));
            }

            private PUTFIELD_B() {
            }
        }

        public static class PUTFIELD_C
        extends Putfield {
            public static final PUTFIELD_C INSTANCE = new PUTFIELD_C();

            public String toString() {
                return "PUTFIELD_C";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = PUTFIELD_C.getObjectOpValue(PUTFIELD_C.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)PUTFIELD_C.getField(quad).getField();
                Reflection.putfield_C(object, jq_InstanceField2, (char)PUTFIELD_C.getIntOpValue(PUTFIELD_C.getSrc(quad), quadInterpreter));
            }

            private PUTFIELD_C() {
            }
        }

        public static class PUTFIELD_S
        extends Putfield {
            public static final PUTFIELD_S INSTANCE = new PUTFIELD_S();

            public String toString() {
                return "PUTFIELD_S";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = PUTFIELD_S.getObjectOpValue(PUTFIELD_S.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)PUTFIELD_S.getField(quad).getField();
                Reflection.putfield_S(object, jq_InstanceField2, (short)PUTFIELD_S.getIntOpValue(PUTFIELD_S.getSrc(quad), quadInterpreter));
            }

            private PUTFIELD_S() {
            }
        }

        public static class PUTFIELD_Z
        extends Putfield {
            public static final PUTFIELD_Z INSTANCE = new PUTFIELD_Z();

            public String toString() {
                return "PUTFIELD_Z";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = PUTFIELD_Z.getObjectOpValue(PUTFIELD_Z.getBase(quad), quadInterpreter);
                jq_InstanceField jq_InstanceField2 = (jq_InstanceField)PUTFIELD_Z.getField(quad).getField();
                boolean bl = false;
                if (PUTFIELD_Z.getIntOpValue(PUTFIELD_Z.getSrc(quad), quadInterpreter) != 0) {
                    bl = true;
                }
                Reflection.putfield_Z(object, jq_InstanceField2, bl);
            }

            private PUTFIELD_Z() {
            }
        }

        public static class PUTFIELD_I_DYNLINK
        extends PUTFIELD_I {
            public static final PUTFIELD_I_DYNLINK INSTANCE = new PUTFIELD_I_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTFIELD_I%";
            }

            private PUTFIELD_I_DYNLINK() {
            }
        }

        public static class PUTFIELD_F_DYNLINK
        extends PUTFIELD_F {
            public static final PUTFIELD_F_DYNLINK INSTANCE = new PUTFIELD_F_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTFIELD_F%";
            }

            private PUTFIELD_F_DYNLINK() {
            }
        }

        public static class PUTFIELD_L_DYNLINK
        extends PUTFIELD_L {
            public static final PUTFIELD_L_DYNLINK INSTANCE = new PUTFIELD_L_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTFIELD_L%";
            }

            private PUTFIELD_L_DYNLINK() {
            }
        }

        public static class PUTFIELD_D_DYNLINK
        extends PUTFIELD_D {
            public static final PUTFIELD_D_DYNLINK INSTANCE = new PUTFIELD_D_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTFIELD_D%";
            }

            private PUTFIELD_D_DYNLINK() {
            }
        }

        public static class PUTFIELD_A_DYNLINK
        extends PUTFIELD_A {
            public static final PUTFIELD_A_DYNLINK INSTANCE = new PUTFIELD_A_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTFIELD_A%";
            }

            private PUTFIELD_A_DYNLINK() {
            }
        }

        public static class PUTFIELD_P_DYNLINK
        extends PUTFIELD_P {
            public static final PUTFIELD_P_DYNLINK INSTANCE = new PUTFIELD_P_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTFIELD_P%";
            }

            private PUTFIELD_P_DYNLINK() {
            }
        }

        public static class PUTFIELD_B_DYNLINK
        extends PUTFIELD_B {
            public static final PUTFIELD_B_DYNLINK INSTANCE = new PUTFIELD_B_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTFIELD_B%";
            }

            private PUTFIELD_B_DYNLINK() {
            }
        }

        public static class PUTFIELD_C_DYNLINK
        extends PUTFIELD_C {
            public static final PUTFIELD_C_DYNLINK INSTANCE = new PUTFIELD_C_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTFIELD_C%";
            }

            private PUTFIELD_C_DYNLINK() {
            }
        }

        public static class PUTFIELD_S_DYNLINK
        extends PUTFIELD_S {
            public static final PUTFIELD_S_DYNLINK INSTANCE = new PUTFIELD_S_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTFIELD_S%";
            }

            private PUTFIELD_S_DYNLINK() {
            }
        }

        public static class PUTFIELD_Z_DYNLINK
        extends PUTFIELD_Z {
            public static final PUTFIELD_Z_DYNLINK INSTANCE = new PUTFIELD_Z_DYNLINK();

            public void accept(Quad quad, QuadVisitor quadVisitor) {
                quadVisitor.visitExceptionThrower(quad);
                super.accept(quad, quadVisitor);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return resolutionexceptions;
            }

            public String toString() {
                return "PUTFIELD_Z%";
            }

            private PUTFIELD_Z_DYNLINK() {
            }
        }
    }

    public static abstract class NullCheck
    extends Operator {
        public static Quad create(int n, NullCheck nullCheck, Operand operand, Operand operand2) {
            return new Quad(n, nullCheck, operand, operand2);
        }

        public static Operand getDest(Quad quad) {
            return quad.getOp1();
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp2();
        }

        public static void setDest(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return NullCheck.getReg1_check(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return NullCheck.getReg2(quad);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitNullCheck(quad);
            quadVisitor.visitCheck(quad);
            quadVisitor.visitExceptionThrower(quad);
            super.accept(quad, quadVisitor);
        }

        public UnmodifiableList.jq_Class getThrownExceptions() {
            return nullptrexception;
        }

        public static class NULL_CHECK
        extends NullCheck {
            public static final NULL_CHECK INSTANCE = new NULL_CHECK();

            public String toString() {
                return "NULL_CHECK";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                if (NULL_CHECK.getObjectOpValue(NULL_CHECK.getSrc(quad), quadInterpreter) == null) {
                    quadInterpreter.handleException(new NullPointerException(quadInterpreter.currentLocation()));
                }
            }

            private NULL_CHECK() {
            }
        }
    }

    public static abstract class ZeroCheck
    extends Operator {
        public static Quad create(int n, ZeroCheck zeroCheck, Operand operand, Operand operand2) {
            return new Quad(n, zeroCheck, operand, operand2);
        }

        public static Operand getDest(Quad quad) {
            return quad.getOp1();
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp2();
        }

        public static void setDest(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return ZeroCheck.getReg1_check(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return ZeroCheck.getReg2(quad);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitZeroCheck(quad);
            quadVisitor.visitCheck(quad);
            quadVisitor.visitExceptionThrower(quad);
            super.accept(quad, quadVisitor);
        }

        public UnmodifiableList.jq_Class getThrownExceptions() {
            return arithexception;
        }

        public static class ZERO_CHECK_I
        extends ZeroCheck {
            public static final ZERO_CHECK_I INSTANCE = new ZERO_CHECK_I();

            public String toString() {
                return "ZERO_CHECK_I";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                if (ZERO_CHECK_I.getIntOpValue(ZERO_CHECK_I.getSrc(quad), quadInterpreter) == 0) {
                    quadInterpreter.handleException(new ArithmeticException(quadInterpreter.currentLocation()));
                }
            }

            private ZERO_CHECK_I() {
            }
        }

        public static class ZERO_CHECK_L
        extends ZeroCheck {
            public static final ZERO_CHECK_L INSTANCE = new ZERO_CHECK_L();

            public String toString() {
                return "ZERO_CHECK_L";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                if (ZERO_CHECK_L.getLongOpValue(ZERO_CHECK_L.getSrc(quad), quadInterpreter) == 0L) {
                    quadInterpreter.handleException(new ArithmeticException(quadInterpreter.currentLocation()));
                }
            }

            private ZERO_CHECK_L() {
            }
        }
    }

    public static abstract class BoundsCheck
    extends Operator {
        public static Quad create(int n, BoundsCheck boundsCheck, Operand operand, Operand operand2, Operand operand3) {
            return new Quad(n, boundsCheck, operand, operand2, operand3);
        }

        public static Operand getRef(Quad quad) {
            return quad.getOp1();
        }

        public static Operand getIndex(Quad quad) {
            return quad.getOp2();
        }

        public static Operand getGuard(Quad quad) {
            return quad.getOp3();
        }

        public static void setRef(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public static void setIndex(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setGuard(Quad quad, Operand operand) {
            quad.setOp3(operand);
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return BoundsCheck.getReg3(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return BoundsCheck.getReg123(quad);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitBoundsCheck(quad);
            quadVisitor.visitCheck(quad);
            quadVisitor.visitExceptionThrower(quad);
            super.accept(quad, quadVisitor);
        }

        public UnmodifiableList.jq_Class getThrownExceptions() {
            return arrayboundsexception;
        }

        public static class BOUNDS_CHECK
        extends BoundsCheck {
            public static final BOUNDS_CHECK INSTANCE = new BOUNDS_CHECK();

            public String toString() {
                return "BOUNDS_CHECK";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                int n = BOUNDS_CHECK.getIntOpValue(BOUNDS_CHECK.getIndex(quad), quadInterpreter);
                Object object = BOUNDS_CHECK.getObjectOpValue(BOUNDS_CHECK.getRef(quad), quadInterpreter);
                int n2 = Reflection.arraylength(object);
                if (n < 0 || n >= n2) {
                    quadInterpreter.handleException(new ArrayIndexOutOfBoundsException(quadInterpreter.currentLocation() + " index: " + n + ", length: " + n2));
                }
            }

            private BOUNDS_CHECK() {
            }
        }
    }

    public static abstract class StoreCheck
    extends Operator {
        public static Quad create(int n, StoreCheck storeCheck, Operand operand, Operand operand2, Operand operand3) {
            return new Quad(n, storeCheck, operand, operand2, operand3);
        }

        public static Operand getRef(Quad quad) {
            return quad.getOp1();
        }

        public static Operand getElement(Quad quad) {
            return quad.getOp2();
        }

        public static Operand getGuard(Quad quad) {
            return quad.getOp3();
        }

        public static void setRef(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public static void setElement(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setGuard(Quad quad, Operand operand) {
            quad.setOp3(operand);
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return StoreCheck.getReg3(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return StoreCheck.getReg123(quad);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitStoreCheck(quad);
            quadVisitor.visitTypeCheck(quad);
            quadVisitor.visitCheck(quad);
            quadVisitor.visitExceptionThrower(quad);
            super.accept(quad, quadVisitor);
        }

        public UnmodifiableList.jq_Class getThrownExceptions() {
            return arraystoreexception;
        }

        public static class ASTORE_CHECK
        extends StoreCheck {
            public static final ASTORE_CHECK INSTANCE = new ASTORE_CHECK();

            public String toString() {
                return "ASTORE_CHECK";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object[] objectArray = (Object[])ASTORE_CHECK.getObjectOpValue(ASTORE_CHECK.getRef(quad), quadInterpreter);
                Object object = ASTORE_CHECK.getObjectOpValue(ASTORE_CHECK.getElement(quad), quadInterpreter);
                if (object == null) {
                    return;
                }
                jq_Reference jq_Reference2 = Reflection.getTypeOf(object);
                jq_Reference2.cls_initialize();
                jq_Array jq_Array2 = (jq_Array)Reflection.getTypeOf(objectArray);
                jq_Type jq_Type2 = jq_Array2.getElementType();
                if (!TypeCheck.isAssignable(jq_Reference2, jq_Type2)) {
                    quadInterpreter.handleException(new ArrayStoreException(jq_Reference2 + " into array " + jq_Array2));
                }
            }

            private ASTORE_CHECK() {
            }
        }
    }

    public static abstract class Invoke
    extends Operator {
        public static Quad create(int n, Invoke invoke, Operand.RegisterOperand registerOperand, Operand.MethodOperand methodOperand, int n2) {
            return new Quad(n, invoke, registerOperand, methodOperand, new Operand.ParamListOperand(new Operand.RegisterOperand[n2]));
        }

        public static void setParam(Quad quad, int n, Operand.RegisterOperand registerOperand) {
            ((Operand.ParamListOperand)quad.getOp3()).set(n, registerOperand);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand.MethodOperand getMethod(Quad quad) {
            return (Operand.MethodOperand)quad.getOp2();
        }

        public static Operand.RegisterOperand getParam(Quad quad, int n) {
            return ((Operand.ParamListOperand)quad.getOp3()).get(n);
        }

        public static Operand.ParamListOperand getParamList(Quad quad) {
            return (Operand.ParamListOperand)quad.getOp3();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setMethod(Quad quad, Operand.MethodOperand methodOperand) {
            quad.setOp2(methodOperand);
        }

        public static void setParamList(Quad quad, Operand.ParamListOperand paramListOperand) {
            quad.setOp3(paramListOperand);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            Operand.ParamListOperand paramListOperand = Invoke.getParamList(quad);
            Operand.RegisterOperand[] registerOperandArray = new Operand.RegisterOperand[paramListOperand.length()];
            int n = 0;
            while (n < registerOperandArray.length) {
                registerOperandArray[n] = paramListOperand.get(n);
                ++n;
            }
            return new UnmodifiableList.RegisterOperand(registerOperandArray);
        }

        public abstract boolean isVirtual();

        public abstract byte getType();

        public abstract jq_Type getReturnType();

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitInvoke(quad);
            quadVisitor.visitExceptionThrower(quad);
            super.accept(quad, quadVisitor);
        }

        public UnmodifiableList.jq_Class getThrownExceptions() {
            return anyexception;
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void interpret_virtual(Quad quad, QuadInterpreter quadInterpreter) {
            Operand.ParamListOperand paramListOperand = Invoke.getParamList(quad);
            jq_Method jq_Method2 = Invoke.getMethod(quad).getMethod();
            jq_Reference jq_Reference2 = Reflection.getTypeOf(quadInterpreter.getReg_A(paramListOperand.get(0).getRegister()));
            jq_Reference2.cls_initialize();
            jq_Method2 = jq_Reference2.getVirtualMethod(jq_Method2.getNameAndDesc());
            if (jq_Method2 == null || jq_Method2.isAbstract()) {
                quadInterpreter.handleException(new AbstractMethodError(quadInterpreter.currentLocation()));
                return;
            }
            QuadInterpreter quadInterpreter2 = quadInterpreter.invokeMethod(jq_Method2, paramListOperand);
            if (quadInterpreter2.getThrown() != null) {
                quadInterpreter.handleException(quadInterpreter2.getThrown());
            } else if (Invoke.getDest(quad) != null) {
                Object object = quadInterpreter2.getReturnValue();
                if (jq_Method2.getReturnType() == jq_Primitive.BOOLEAN && object instanceof Boolean) {
                    object = new Integer(((Boolean)object).booleanValue() ? 1 : 0);
                } else if (jq_Method2.getReturnType() == jq_Primitive.CHAR && object instanceof Character) {
                    object = new Integer(((Character)object).charValue());
                }
                quadInterpreter.putReg(Invoke.getDest(quad).getRegister(), object);
            }
        }

        public void interpret_static(Quad quad, QuadInterpreter quadInterpreter) {
            Operand.ParamListOperand paramListOperand = Invoke.getParamList(quad);
            jq_Method jq_Method2 = Invoke.getMethod(quad).getMethod();
            QuadInterpreter quadInterpreter2 = quadInterpreter.invokeMethod(jq_Method2, paramListOperand);
            if (quadInterpreter2.getThrown() != null) {
                quadInterpreter.handleException(quadInterpreter2.getThrown());
            } else if (Invoke.getDest(quad) != null) {
                Object object = quadInterpreter2.getReturnValue();
                if (jq_Method2.getReturnType() == jq_Primitive.BOOLEAN && object instanceof Boolean) {
                    object = new Integer(((Boolean)object).booleanValue() ? 1 : 0);
                } else if (jq_Method2.getReturnType() == jq_Primitive.CHAR && object instanceof Character) {
                    object = new Integer(((Character)object).charValue());
                }
                quadInterpreter.putReg(Invoke.getDest(quad).getRegister(), object);
            }
        }

        public static abstract class InvokeVirtual
        extends Invoke {
            public boolean isVirtual() {
                return true;
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                this.interpret_virtual(quad, quadInterpreter);
            }

            public byte getType() {
                return 0;
            }
        }

        public static abstract class InvokeStatic
        extends Invoke {
            public boolean isVirtual() {
                return false;
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                this.interpret_static(quad, quadInterpreter);
            }

            public byte getType() {
                return 1;
            }
        }

        public static abstract class InvokeInterface
        extends Invoke {
            public boolean isVirtual() {
                return true;
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                this.interpret_virtual(quad, quadInterpreter);
            }

            public byte getType() {
                return 3;
            }
        }

        public static class INVOKEVIRTUAL_V
        extends InvokeVirtual {
            public static final INVOKEVIRTUAL_V INSTANCE = new INVOKEVIRTUAL_V();

            public String toString() {
                return "INVOKEVIRTUAL_V";
            }

            public jq_Type getReturnType() {
                return jq_Primitive.VOID;
            }

            private INVOKEVIRTUAL_V() {
            }
        }

        public static class INVOKEVIRTUAL_I
        extends InvokeVirtual {
            public static final INVOKEVIRTUAL_I INSTANCE = new INVOKEVIRTUAL_I();

            public String toString() {
                return "INVOKEVIRTUAL_I";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEVIRTUAL_I.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.INT;
            }

            private INVOKEVIRTUAL_I() {
            }
        }

        public static class INVOKEVIRTUAL_F
        extends InvokeVirtual {
            public static final INVOKEVIRTUAL_F INSTANCE = new INVOKEVIRTUAL_F();

            public String toString() {
                return "INVOKEVIRTUAL_F";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEVIRTUAL_F.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.FLOAT;
            }

            private INVOKEVIRTUAL_F() {
            }
        }

        public static class INVOKEVIRTUAL_L
        extends InvokeVirtual {
            public static final INVOKEVIRTUAL_L INSTANCE = new INVOKEVIRTUAL_L();

            public String toString() {
                return "INVOKEVIRTUAL_L";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEVIRTUAL_L.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.LONG;
            }

            private INVOKEVIRTUAL_L() {
            }
        }

        public static class INVOKEVIRTUAL_D
        extends InvokeVirtual {
            public static final INVOKEVIRTUAL_D INSTANCE = new INVOKEVIRTUAL_D();

            public String toString() {
                return "INVOKEVIRTUAL_D";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEVIRTUAL_D.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.DOUBLE;
            }

            private INVOKEVIRTUAL_D() {
            }
        }

        public static class INVOKEVIRTUAL_A
        extends InvokeVirtual {
            public static final INVOKEVIRTUAL_A INSTANCE = new INVOKEVIRTUAL_A();

            public String toString() {
                return "INVOKEVIRTUAL_A";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEVIRTUAL_A.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return PrimordialClassLoader.getJavaLangObject();
            }

            private INVOKEVIRTUAL_A() {
            }
        }

        public static class INVOKEVIRTUAL_P
        extends InvokeVirtual {
            public static final INVOKEVIRTUAL_P INSTANCE = new INVOKEVIRTUAL_P();

            public String toString() {
                return "INVOKEVIRTUAL_P";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEVIRTUAL_P.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return Address._class;
            }

            private INVOKEVIRTUAL_P() {
            }
        }

        public static class INVOKESTATIC_V
        extends InvokeStatic {
            public static final INVOKESTATIC_V INSTANCE = new INVOKESTATIC_V();

            public String toString() {
                return "INVOKESTATIC_V";
            }

            public jq_Type getReturnType() {
                return jq_Primitive.VOID;
            }

            private INVOKESTATIC_V() {
            }
        }

        public static class INVOKESTATIC_I
        extends InvokeStatic {
            public static final INVOKESTATIC_I INSTANCE = new INVOKESTATIC_I();

            public String toString() {
                return "INVOKESTATIC_I";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKESTATIC_I.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.INT;
            }

            private INVOKESTATIC_I() {
            }
        }

        public static class INVOKESTATIC_F
        extends InvokeStatic {
            public static final INVOKESTATIC_F INSTANCE = new INVOKESTATIC_F();

            public String toString() {
                return "INVOKESTATIC_F";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKESTATIC_F.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.FLOAT;
            }

            private INVOKESTATIC_F() {
            }
        }

        public static class INVOKESTATIC_L
        extends InvokeStatic {
            public static final INVOKESTATIC_L INSTANCE = new INVOKESTATIC_L();

            public String toString() {
                return "INVOKESTATIC_L";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKESTATIC_L.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.LONG;
            }

            private INVOKESTATIC_L() {
            }
        }

        public static class INVOKESTATIC_D
        extends InvokeStatic {
            public static final INVOKESTATIC_D INSTANCE = new INVOKESTATIC_D();

            public String toString() {
                return "INVOKESTATIC_D";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKESTATIC_D.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.DOUBLE;
            }

            private INVOKESTATIC_D() {
            }
        }

        public static class INVOKESTATIC_A
        extends InvokeStatic {
            public static final INVOKESTATIC_A INSTANCE = new INVOKESTATIC_A();

            public String toString() {
                return "INVOKESTATIC_A";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKESTATIC_A.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return PrimordialClassLoader.getJavaLangObject();
            }

            private INVOKESTATIC_A() {
            }
        }

        public static class INVOKESTATIC_P
        extends InvokeStatic {
            public static final INVOKESTATIC_P INSTANCE = new INVOKESTATIC_P();

            public String toString() {
                return "INVOKESTATIC_P";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKESTATIC_P.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return Address._class;
            }

            private INVOKESTATIC_P() {
            }
        }

        public static class INVOKEVIRTUAL_V_DYNLINK
        extends INVOKEVIRTUAL_V {
            public static final INVOKEVIRTUAL_V_DYNLINK INSTANCE = new INVOKEVIRTUAL_V_DYNLINK();

            public String toString() {
                return "INVOKEVIRTUAL_V%";
            }

            private INVOKEVIRTUAL_V_DYNLINK() {
            }
        }

        public static class INVOKEVIRTUAL_I_DYNLINK
        extends INVOKEVIRTUAL_I {
            public static final INVOKEVIRTUAL_I_DYNLINK INSTANCE = new INVOKEVIRTUAL_I_DYNLINK();

            public String toString() {
                return "INVOKEVIRTUAL_I%";
            }

            private INVOKEVIRTUAL_I_DYNLINK() {
            }
        }

        public static class INVOKEVIRTUAL_F_DYNLINK
        extends INVOKEVIRTUAL_F {
            public static final INVOKEVIRTUAL_F_DYNLINK INSTANCE = new INVOKEVIRTUAL_F_DYNLINK();

            public String toString() {
                return "INVOKEVIRTUAL_F%";
            }

            private INVOKEVIRTUAL_F_DYNLINK() {
            }
        }

        public static class INVOKEVIRTUAL_L_DYNLINK
        extends INVOKEVIRTUAL_L {
            public static final INVOKEVIRTUAL_L_DYNLINK INSTANCE = new INVOKEVIRTUAL_L_DYNLINK();

            public String toString() {
                return "INVOKEVIRTUAL_L%";
            }

            private INVOKEVIRTUAL_L_DYNLINK() {
            }
        }

        public static class INVOKEVIRTUAL_D_DYNLINK
        extends INVOKEVIRTUAL_D {
            public static final INVOKEVIRTUAL_D_DYNLINK INSTANCE = new INVOKEVIRTUAL_D_DYNLINK();

            public String toString() {
                return "INVOKEVIRTUAL_D%";
            }

            private INVOKEVIRTUAL_D_DYNLINK() {
            }
        }

        public static class INVOKEVIRTUAL_A_DYNLINK
        extends INVOKEVIRTUAL_A {
            public static final INVOKEVIRTUAL_A_DYNLINK INSTANCE = new INVOKEVIRTUAL_A_DYNLINK();

            public String toString() {
                return "INVOKEVIRTUAL_A%";
            }

            private INVOKEVIRTUAL_A_DYNLINK() {
            }
        }

        public static class INVOKEVIRTUAL_P_DYNLINK
        extends INVOKEVIRTUAL_P {
            public static final INVOKEVIRTUAL_P_DYNLINK INSTANCE = new INVOKEVIRTUAL_P_DYNLINK();

            public String toString() {
                return "INVOKEVIRTUAL_P%";
            }

            private INVOKEVIRTUAL_P_DYNLINK() {
            }
        }

        public static class INVOKESTATIC_V_DYNLINK
        extends INVOKESTATIC_V {
            public static final INVOKESTATIC_V_DYNLINK INSTANCE = new INVOKESTATIC_V_DYNLINK();

            public String toString() {
                return "INVOKESTATIC_V%";
            }

            private INVOKESTATIC_V_DYNLINK() {
            }
        }

        public static class INVOKESTATIC_I_DYNLINK
        extends INVOKESTATIC_I {
            public static final INVOKESTATIC_I_DYNLINK INSTANCE = new INVOKESTATIC_I_DYNLINK();

            public String toString() {
                return "INVOKESTATIC_I%";
            }

            private INVOKESTATIC_I_DYNLINK() {
            }
        }

        public static class INVOKESTATIC_F_DYNLINK
        extends INVOKESTATIC_F {
            public static final INVOKESTATIC_F_DYNLINK INSTANCE = new INVOKESTATIC_F_DYNLINK();

            public String toString() {
                return "INVOKESTATIC_F%";
            }

            private INVOKESTATIC_F_DYNLINK() {
            }
        }

        public static class INVOKESTATIC_L_DYNLINK
        extends INVOKESTATIC_L {
            public static final INVOKESTATIC_L_DYNLINK INSTANCE = new INVOKESTATIC_L_DYNLINK();

            public String toString() {
                return "INVOKESTATIC_L%";
            }

            private INVOKESTATIC_L_DYNLINK() {
            }
        }

        public static class INVOKESTATIC_D_DYNLINK
        extends INVOKESTATIC_D {
            public static final INVOKESTATIC_D_DYNLINK INSTANCE = new INVOKESTATIC_D_DYNLINK();

            public String toString() {
                return "INVOKESTATIC_D%";
            }

            private INVOKESTATIC_D_DYNLINK() {
            }
        }

        public static class INVOKESTATIC_A_DYNLINK
        extends INVOKESTATIC_A {
            public static final INVOKESTATIC_A_DYNLINK INSTANCE = new INVOKESTATIC_A_DYNLINK();

            public String toString() {
                return "INVOKESTATIC_A%";
            }

            private INVOKESTATIC_A_DYNLINK() {
            }
        }

        public static class INVOKESTATIC_P_DYNLINK
        extends INVOKESTATIC_P {
            public static final INVOKESTATIC_P_DYNLINK INSTANCE = new INVOKESTATIC_P_DYNLINK();

            public String toString() {
                return "INVOKESTATIC_P%";
            }

            private INVOKESTATIC_P_DYNLINK() {
            }
        }

        public static class INVOKESPECIAL_V_DYNLINK
        extends INVOKESTATIC_V {
            public static final INVOKESPECIAL_V_DYNLINK INSTANCE = new INVOKESPECIAL_V_DYNLINK();

            public String toString() {
                return "INVOKESPECIAL_V%";
            }

            private INVOKESPECIAL_V_DYNLINK() {
            }
        }

        public static class INVOKESPECIAL_I_DYNLINK
        extends INVOKESTATIC_I {
            public static final INVOKESPECIAL_I_DYNLINK INSTANCE = new INVOKESPECIAL_I_DYNLINK();

            public String toString() {
                return "INVOKESPECIAL_I%";
            }

            private INVOKESPECIAL_I_DYNLINK() {
            }
        }

        public static class INVOKESPECIAL_F_DYNLINK
        extends INVOKESTATIC_F {
            public static final INVOKESPECIAL_F_DYNLINK INSTANCE = new INVOKESPECIAL_F_DYNLINK();

            public String toString() {
                return "INVOKESPECIAL_F%";
            }

            private INVOKESPECIAL_F_DYNLINK() {
            }
        }

        public static class INVOKESPECIAL_L_DYNLINK
        extends INVOKESTATIC_L {
            public static final INVOKESPECIAL_L_DYNLINK INSTANCE = new INVOKESPECIAL_L_DYNLINK();

            public String toString() {
                return "INVOKESPECIAL_L%";
            }

            private INVOKESPECIAL_L_DYNLINK() {
            }
        }

        public static class INVOKESPECIAL_D_DYNLINK
        extends INVOKESTATIC_D {
            public static final INVOKESPECIAL_D_DYNLINK INSTANCE = new INVOKESPECIAL_D_DYNLINK();

            public String toString() {
                return "INVOKESPECIAL_D%";
            }

            private INVOKESPECIAL_D_DYNLINK() {
            }
        }

        public static class INVOKESPECIAL_A_DYNLINK
        extends INVOKESTATIC_A {
            public static final INVOKESPECIAL_A_DYNLINK INSTANCE = new INVOKESPECIAL_A_DYNLINK();

            public String toString() {
                return "INVOKESPECIAL_A%";
            }

            private INVOKESPECIAL_A_DYNLINK() {
            }
        }

        public static class INVOKESPECIAL_P_DYNLINK
        extends INVOKESTATIC_P {
            public static final INVOKESPECIAL_P_DYNLINK INSTANCE = new INVOKESPECIAL_P_DYNLINK();

            public String toString() {
                return "INVOKESPECIAL_P%";
            }

            private INVOKESPECIAL_P_DYNLINK() {
            }
        }

        public static class INVOKEINTERFACE_V
        extends InvokeInterface {
            public static final INVOKEINTERFACE_V INSTANCE = new INVOKEINTERFACE_V();

            public String toString() {
                return "INVOKEINTERFACE_V";
            }

            public jq_Type getReturnType() {
                return jq_Primitive.VOID;
            }

            private INVOKEINTERFACE_V() {
            }
        }

        public static class INVOKEINTERFACE_I
        extends InvokeInterface {
            public static final INVOKEINTERFACE_I INSTANCE = new INVOKEINTERFACE_I();

            public String toString() {
                return "INVOKEINTERFACE_I";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEINTERFACE_I.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.INT;
            }

            private INVOKEINTERFACE_I() {
            }
        }

        public static class INVOKEINTERFACE_F
        extends InvokeInterface {
            public static final INVOKEINTERFACE_F INSTANCE = new INVOKEINTERFACE_F();

            public String toString() {
                return "INVOKEINTERFACE_F";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEINTERFACE_F.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.FLOAT;
            }

            private INVOKEINTERFACE_F() {
            }
        }

        public static class INVOKEINTERFACE_L
        extends InvokeInterface {
            public static final INVOKEINTERFACE_L INSTANCE = new INVOKEINTERFACE_L();

            public String toString() {
                return "INVOKEINTERFACE_L";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEINTERFACE_L.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.LONG;
            }

            private INVOKEINTERFACE_L() {
            }
        }

        public static class INVOKEINTERFACE_D
        extends InvokeInterface {
            public static final INVOKEINTERFACE_D INSTANCE = new INVOKEINTERFACE_D();

            public String toString() {
                return "INVOKEINTERFACE_D";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEINTERFACE_D.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return jq_Primitive.DOUBLE;
            }

            private INVOKEINTERFACE_D() {
            }
        }

        public static class INVOKEINTERFACE_A
        extends InvokeInterface {
            public static final INVOKEINTERFACE_A INSTANCE = new INVOKEINTERFACE_A();

            public String toString() {
                return "INVOKEINTERFACE_A";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEINTERFACE_A.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return PrimordialClassLoader.getJavaLangObject();
            }

            private INVOKEINTERFACE_A() {
            }
        }

        public static class INVOKEINTERFACE_P
        extends InvokeInterface {
            public static final INVOKEINTERFACE_P INSTANCE = new INVOKEINTERFACE_P();

            public String toString() {
                return "INVOKEINTERFACE_P";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKEINTERFACE_P.getReg1(quad);
            }

            public jq_Type getReturnType() {
                return Address._class;
            }

            private INVOKEINTERFACE_P() {
            }
        }
    }

    public static abstract class New
    extends Operator {
        public static Quad create(int n, New new_, Operand.RegisterOperand registerOperand, Operand.TypeOperand typeOperand) {
            return new Quad(n, new_, registerOperand, typeOperand);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand.TypeOperand getType(Quad quad) {
            return (Operand.TypeOperand)quad.getOp2();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setType(Quad quad, Operand.TypeOperand typeOperand) {
            quad.setOp2(typeOperand);
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return New.getReg1(quad);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitNew(quad);
            quadVisitor.visitAllocation(quad);
            super.accept(quad, quadVisitor);
        }

        public static class NEW
        extends New {
            public static final NEW INSTANCE = new NEW();

            public String toString() {
                return "NEW";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_A(NEW.getDest(quad).getRegister(), new QuadInterpreter.UninitializedReference((jq_Class)NEW.getType(quad).getType()));
            }

            private NEW() {
            }
        }

        public static class NEW_DYNLINK
        extends NEW {
            public static final NEW_DYNLINK INSTANCE = new NEW_DYNLINK();

            public String toString() {
                return "NEW%";
            }

            private NEW_DYNLINK() {
            }
        }
    }

    public static abstract class NewArray
    extends Operator {
        public static Quad create(int n, NewArray newArray, Operand.RegisterOperand registerOperand, Operand operand, Operand.TypeOperand typeOperand) {
            return new Quad(n, newArray, registerOperand, operand, typeOperand);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand getSize(Quad quad) {
            return quad.getOp2();
        }

        public static Operand.TypeOperand getType(Quad quad) {
            return (Operand.TypeOperand)quad.getOp3();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setSize(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setType(Quad quad, Operand.TypeOperand typeOperand) {
            quad.setOp3(typeOperand);
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return NewArray.getReg1(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return NewArray.getReg2(quad);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitNewArray(quad);
            quadVisitor.visitAllocation(quad);
            quadVisitor.visitExceptionThrower(quad);
            super.accept(quad, quadVisitor);
        }

        public UnmodifiableList.jq_Class getThrownExceptions() {
            return negativesizeexception;
        }

        public static class NEWARRAY
        extends NewArray {
            public static final NEWARRAY INSTANCE = new NEWARRAY();

            public String toString() {
                return "NEWARRAY";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_Type jq_Type2 = NEWARRAY.getType(quad).getType();
                int n = NEWARRAY.getIntOpValue(NEWARRAY.getSize(quad), quadInterpreter);
                Object object = Array.newInstance(Reflection.getJDKType(((jq_Array)jq_Type2).getElementType()), n);
                quadInterpreter.putReg_A(NEWARRAY.getDest(quad).getRegister(), object);
            }

            private NEWARRAY() {
            }
        }
    }

    public static abstract class CheckCast
    extends Operator {
        public static Quad create(int n, CheckCast checkCast, Operand.RegisterOperand registerOperand, Operand operand, Operand.TypeOperand typeOperand) {
            return new Quad(n, checkCast, registerOperand, operand, typeOperand);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp2();
        }

        public static Operand.TypeOperand getType(Quad quad) {
            return (Operand.TypeOperand)quad.getOp3();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setType(Quad quad, Operand.TypeOperand typeOperand) {
            quad.setOp3(typeOperand);
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return CheckCast.getReg1(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return CheckCast.getReg2(quad);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitCheckCast(quad);
            quadVisitor.visitTypeCheck(quad);
            quadVisitor.visitCheck(quad);
            quadVisitor.visitExceptionThrower(quad);
            super.accept(quad, quadVisitor);
        }

        public UnmodifiableList.jq_Class getThrownExceptions() {
            return classcastexceptions;
        }

        public static class CHECKCAST
        extends CheckCast {
            public static final CHECKCAST INSTANCE = new CHECKCAST();

            public String toString() {
                return "CHECKCAST";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_Type jq_Type2 = CHECKCAST.getType(quad).getType();
                Assert._assert(jq_Type2.isAddressType() ^ true);
                Object object = CHECKCAST.getObjectOpValue(CHECKCAST.getSrc(quad), quadInterpreter);
                if (object != null) {
                    jq_Reference jq_Reference2 = Reflection.getTypeOf(object);
                    jq_Reference2.cls_initialize();
                    if (!TypeCheck.isAssignable(jq_Reference2, jq_Type2)) {
                        quadInterpreter.handleException(new ClassCastException(jq_Reference2 + " cannot be cast into " + jq_Type2));
                        return;
                    }
                }
                quadInterpreter.putReg_A(CHECKCAST.getDest(quad).getRegister(), object);
            }

            private CHECKCAST() {
            }
        }
    }

    public static abstract class InstanceOf
    extends Operator {
        public static Quad create(int n, InstanceOf instanceOf, Operand.RegisterOperand registerOperand, Operand operand, Operand.TypeOperand typeOperand) {
            return new Quad(n, instanceOf, registerOperand, operand, typeOperand);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp2();
        }

        public static Operand.TypeOperand getType(Quad quad) {
            return (Operand.TypeOperand)quad.getOp3();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setType(Quad quad, Operand.TypeOperand typeOperand) {
            quad.setOp3(typeOperand);
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return InstanceOf.getReg1(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return InstanceOf.getReg2(quad);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitInstanceOf(quad);
            quadVisitor.visitTypeCheck(quad);
            quadVisitor.visitExceptionThrower(quad);
            super.accept(quad, quadVisitor);
        }

        public UnmodifiableList.jq_Class getThrownExceptions() {
            return resolutionexceptions;
        }

        public static class INSTANCEOF
        extends InstanceOf {
            public static final INSTANCEOF INSTANCE = new INSTANCEOF();

            public String toString() {
                return "INSTANCEOF";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                jq_Type jq_Type2 = INSTANCEOF.getType(quad).getType();
                Assert._assert(jq_Type2.isAddressType() ^ true);
                Object object = INSTANCEOF.getObjectOpValue(INSTANCEOF.getSrc(quad), quadInterpreter);
                int n = object == null ? 0 : Reflection.getJDKType(jq_Type2).isAssignableFrom(object.getClass());
                quadInterpreter.putReg_I(INSTANCEOF.getDest(quad).getRegister(), n);
            }

            private INSTANCEOF() {
            }
        }
    }

    public static abstract class ALength
    extends Operator {
        public static Quad create(int n, ALength aLength, Operand.RegisterOperand registerOperand, Operand operand) {
            return new Quad(n, aLength, registerOperand, operand);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp2();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return ALength.getReg1(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return ALength.getReg2(quad);
        }

        public boolean hasSideEffects() {
            return false;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitALength(quad);
            quadVisitor.visitArray(quad);
            super.accept(quad, quadVisitor);
        }

        public static class ARRAYLENGTH
        extends ALength {
            public static final ARRAYLENGTH INSTANCE = new ARRAYLENGTH();

            public String toString() {
                return "ARRAYLENGTH";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Object object = ARRAYLENGTH.getObjectOpValue(ARRAYLENGTH.getSrc(quad), quadInterpreter);
                int n = Reflection.arraylength(object);
                quadInterpreter.putReg_I(ARRAYLENGTH.getDest(quad).getRegister(), n);
            }

            private ARRAYLENGTH() {
            }
        }
    }

    public static abstract class Monitor
    extends Operator {
        public static Quad create(int n, Monitor monitor, Operand operand) {
            return new Quad(n, monitor, null, operand);
        }

        public static Operand getSrc(Quad quad) {
            return quad.getOp2();
        }

        public static void setSrc(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return Monitor.getReg2(quad);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitMonitor(quad);
            quadVisitor.visitExceptionThrower(quad);
            super.accept(quad, quadVisitor);
        }

        public static class MONITORENTER
        extends Monitor {
            public static final MONITORENTER INSTANCE = new MONITORENTER();

            public String toString() {
                return "MONITORENTER";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                _delegate.interpretMonitorEnter(this, quad, quadInterpreter);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return nullptrexception;
            }

            private MONITORENTER() {
            }
        }

        public static class MONITOREXIT
        extends Monitor {
            public static final MONITOREXIT INSTANCE = new MONITOREXIT();

            public String toString() {
                return "MONITOREXIT";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                _delegate.interpretMonitorExit(this, quad, quadInterpreter);
            }

            public UnmodifiableList.jq_Class getThrownExceptions() {
                return illegalmonitorstateexception;
            }

            private MONITOREXIT() {
            }
        }
    }

    public static abstract class MemLoad
    extends Operator {
        public static Quad create(int n, MemLoad memLoad, Operand.RegisterOperand registerOperand, Operand operand) {
            return new Quad(n, memLoad, registerOperand, operand);
        }

        public static Operand.RegisterOperand getDest(Quad quad) {
            return (Operand.RegisterOperand)quad.getOp1();
        }

        public static Operand getAddress(Quad quad) {
            return quad.getOp2();
        }

        public static void setDest(Quad quad, Operand.RegisterOperand registerOperand) {
            quad.setOp1(registerOperand);
        }

        public static void setAddress(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
            return MemLoad.getReg1(quad);
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return MemLoad.getReg2(quad);
        }

        public boolean hasSideEffects() {
            return false;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitMemLoad(quad);
            quadVisitor.visitLoad(quad);
            super.accept(quad, quadVisitor);
        }

        public static class PEEK_P
        extends MemLoad {
            public static final PEEK_P INSTANCE = new PEEK_P();

            public String toString() {
                return "PEEK_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = PEEK_P.getAddressOpValue(PEEK_P.getAddress(quad), quadInterpreter);
                if (jq.RunningNative) {
                    quadInterpreter.putReg_P(PEEK_P.getDest(quad).getRegister(), address.peek());
                }
            }

            private PEEK_P() {
            }
        }

        public static class PEEK_1
        extends MemLoad {
            public static final PEEK_1 INSTANCE = new PEEK_1();

            public String toString() {
                return "PEEK_1";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = PEEK_1.getAddressOpValue(PEEK_1.getAddress(quad), quadInterpreter);
                if (jq.RunningNative) {
                    quadInterpreter.putReg_I(PEEK_1.getDest(quad).getRegister(), address.peek1());
                }
            }

            private PEEK_1() {
            }
        }

        public static class PEEK_2
        extends MemLoad {
            public static final PEEK_2 INSTANCE = new PEEK_2();

            public String toString() {
                return "PEEK_2";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = PEEK_2.getAddressOpValue(PEEK_2.getAddress(quad), quadInterpreter);
                if (jq.RunningNative) {
                    quadInterpreter.putReg_I(PEEK_2.getDest(quad).getRegister(), address.peek2());
                }
            }

            private PEEK_2() {
            }
        }

        public static class PEEK_4
        extends MemLoad {
            public static final PEEK_4 INSTANCE = new PEEK_4();

            public String toString() {
                return "PEEK_4";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = PEEK_4.getAddressOpValue(PEEK_4.getAddress(quad), quadInterpreter);
                if (jq.RunningNative) {
                    quadInterpreter.putReg_I(PEEK_4.getDest(quad).getRegister(), address.peek4());
                }
            }

            private PEEK_4() {
            }
        }

        public static class PEEK_8
        extends MemLoad {
            public static final PEEK_8 INSTANCE = new PEEK_8();

            public String toString() {
                return "PEEK_8";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = PEEK_8.getAddressOpValue(PEEK_8.getAddress(quad), quadInterpreter);
                if (jq.RunningNative) {
                    quadInterpreter.putReg_L(PEEK_8.getDest(quad).getRegister(), address.peek8());
                }
            }

            private PEEK_8() {
            }
        }
    }

    public static abstract class MemStore
    extends Operator {
        public static Quad create(int n, MemStore memStore, Operand operand, Operand operand2) {
            return new Quad(n, memStore, null, operand, operand2);
        }

        public static Operand getAddress(Quad quad) {
            return quad.getOp2();
        }

        public static Operand getValue(Quad quad) {
            return quad.getOp3();
        }

        public static void setAddress(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setValue(Quad quad, Operand operand) {
            quad.setOp3(operand);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
            return MemStore.getReg23(quad);
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitMemStore(quad);
            quadVisitor.visitStore(quad);
            super.accept(quad, quadVisitor);
        }

        public static class POKE_P
        extends MemStore {
            public static final POKE_P INSTANCE = new POKE_P();

            public String toString() {
                return "POKE_P";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = POKE_P.getAddressOpValue(POKE_P.getAddress(quad), quadInterpreter);
                Address address2 = POKE_P.getAddressOpValue(POKE_P.getValue(quad), quadInterpreter);
                if (jq.RunningNative) {
                    address.poke(address2);
                }
            }

            private POKE_P() {
            }
        }

        public static class POKE_1
        extends MemStore {
            public static final POKE_1 INSTANCE = new POKE_1();

            public String toString() {
                return "POKE_1";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = POKE_1.getAddressOpValue(POKE_1.getAddress(quad), quadInterpreter);
                byte by = (byte)POKE_1.getIntOpValue(POKE_1.getValue(quad), quadInterpreter);
                if (jq.RunningNative) {
                    address.poke1(by);
                }
            }

            private POKE_1() {
            }
        }

        public static class POKE_2
        extends MemStore {
            public static final POKE_2 INSTANCE = new POKE_2();

            public String toString() {
                return "POKE_2";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = POKE_2.getAddressOpValue(POKE_2.getAddress(quad), quadInterpreter);
                short s = (short)POKE_2.getIntOpValue(POKE_2.getValue(quad), quadInterpreter);
                if (jq.RunningNative) {
                    address.poke2(s);
                }
            }

            private POKE_2() {
            }
        }

        public static class POKE_4
        extends MemStore {
            public static final POKE_4 INSTANCE = new POKE_4();

            public String toString() {
                return "POKE_4";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = POKE_4.getAddressOpValue(POKE_4.getAddress(quad), quadInterpreter);
                int n = POKE_4.getIntOpValue(POKE_4.getValue(quad), quadInterpreter);
                if (jq.RunningNative) {
                    address.poke4(n);
                }
            }

            private POKE_4() {
            }
        }

        public static class POKE_8
        extends MemStore {
            public static final POKE_8 INSTANCE = new POKE_8();

            public String toString() {
                return "POKE_8";
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Address address = POKE_8.getAddressOpValue(POKE_8.getAddress(quad), quadInterpreter);
                long l = POKE_8.getLongOpValue(POKE_8.getValue(quad), quadInterpreter);
                if (jq.RunningNative) {
                    address.poke8(l);
                }
            }

            private POKE_8() {
            }
        }
    }

    public static abstract class Special
    extends Operator {
        public static Quad create(int n, GET_EXCEPTION gET_EXCEPTION, Operand.RegisterOperand registerOperand) {
            return new Quad(n, gET_EXCEPTION, registerOperand);
        }

        public static Quad create(int n, GET_BASE_POINTER gET_BASE_POINTER, Operand.RegisterOperand registerOperand) {
            return new Quad(n, gET_BASE_POINTER, registerOperand);
        }

        public static Quad create(int n, GET_STACK_POINTER gET_STACK_POINTER, Operand.RegisterOperand registerOperand) {
            return new Quad(n, gET_STACK_POINTER, registerOperand);
        }

        public static Quad create(int n, GET_THREAD_BLOCK gET_THREAD_BLOCK, Operand.RegisterOperand registerOperand) {
            return new Quad(n, gET_THREAD_BLOCK, registerOperand);
        }

        public static Quad create(int n, SET_THREAD_BLOCK sET_THREAD_BLOCK, Operand operand) {
            return new Quad(n, sET_THREAD_BLOCK, null, operand);
        }

        public static Quad create(int n, ALLOCA aLLOCA, Operand.RegisterOperand registerOperand, Operand operand) {
            return new Quad(n, aLLOCA, registerOperand, operand);
        }

        public static Quad create(int n, NOP nOP) {
            return new Quad(n, nOP, null, null);
        }

        public static Quad create(int n, ATOMICADD_I aTOMICADD_I, Operand operand, Operand operand2) {
            return new Quad(n, aTOMICADD_I, null, operand, operand2);
        }

        public static Quad create(int n, ATOMICSUB_I aTOMICSUB_I, Operand operand, Operand operand2) {
            return new Quad(n, aTOMICSUB_I, null, operand, operand2);
        }

        public static Quad create(int n, ATOMICAND_I aTOMICAND_I, Operand operand, Operand operand2) {
            return new Quad(n, aTOMICAND_I, null, operand, operand2);
        }

        public static Quad create(int n, ATOMICCAS4 aTOMICCAS4, Operand.RegisterOperand registerOperand, Operand operand, Operand operand2, Operand operand3) {
            return new Quad(n, aTOMICCAS4, registerOperand, operand, operand2, operand3);
        }

        public static Quad create(int n, ATOMICCAS8 aTOMICCAS8, Operand.RegisterOperand registerOperand, Operand operand, Operand operand2, Operand operand3) {
            return new Quad(n, aTOMICCAS8, registerOperand, operand, operand2, operand3);
        }

        public static Quad create(int n, LONG_JUMP lONG_JUMP, Operand operand, Operand operand2, Operand operand3, Operand operand4) {
            return new Quad(n, lONG_JUMP, operand, operand2, operand3, operand4);
        }

        public static Quad create(int n, POP_FP32 pOP_FP32, Operand.RegisterOperand registerOperand) {
            return new Quad(n, pOP_FP32, registerOperand);
        }

        public static Quad create(int n, POP_FP64 pOP_FP64, Operand.RegisterOperand registerOperand) {
            return new Quad(n, pOP_FP64, registerOperand);
        }

        public static Quad create(int n, PUSH_FP32 pUSH_FP32, Operand operand) {
            return new Quad(n, pUSH_FP32, null, operand);
        }

        public static Quad create(int n, PUSH_FP64 pUSH_FP64, Operand operand) {
            return new Quad(n, pUSH_FP64, null, operand);
        }

        public static Quad create(int n, GET_EAX gET_EAX, Operand.RegisterOperand registerOperand) {
            return new Quad(n, gET_EAX, registerOperand);
        }

        public static Quad create(int n, PUSHARG_I pUSHARG_I, Operand operand) {
            return new Quad(n, pUSHARG_I, null, operand);
        }

        public static Quad create(int n, PUSHARG_P pUSHARG_P, Operand operand) {
            return new Quad(n, pUSHARG_P, null, operand);
        }

        public static Quad create(int n, INVOKE_L iNVOKE_L, Operand.RegisterOperand registerOperand, Operand operand) {
            return new Quad(n, iNVOKE_L, registerOperand, operand);
        }

        public static Quad create(int n, INVOKE_P iNVOKE_P, Operand.RegisterOperand registerOperand, Operand operand) {
            return new Quad(n, iNVOKE_P, registerOperand, operand);
        }

        public static Quad create(int n, ISEQ iSEQ, Operand.RegisterOperand registerOperand) {
            return new Quad(n, iSEQ, registerOperand);
        }

        public static Quad create(int n, ISGE iSGE, Operand.RegisterOperand registerOperand) {
            return new Quad(n, iSGE, registerOperand);
        }

        public static Operand getOp1(Quad quad) {
            return quad.getOp1();
        }

        public static Operand getOp2(Quad quad) {
            return quad.getOp2();
        }

        public static Operand getOp3(Quad quad) {
            return quad.getOp3();
        }

        public static Operand getOp4(Quad quad) {
            return quad.getOp4();
        }

        public static void setOp1(Quad quad, Operand operand) {
            quad.setOp1(operand);
        }

        public static void setOp2(Quad quad, Operand operand) {
            quad.setOp2(operand);
        }

        public static void setOp3(Quad quad, Operand operand) {
            quad.setOp3(operand);
        }

        public static void setOp4(Quad quad, Operand operand) {
            quad.setOp4(operand);
        }

        public boolean hasSideEffects() {
            return true;
        }

        public void accept(Quad quad, QuadVisitor quadVisitor) {
            quadVisitor.visitSpecial(quad);
            super.accept(quad, quadVisitor);
        }

        public static class GET_EXCEPTION
        extends Special {
            public static final GET_EXCEPTION INSTANCE = new GET_EXCEPTION();

            public String toString() {
                return "GET_EXCEPTION";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return GET_EXCEPTION.getReg1(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                quadInterpreter.putReg_A(((Operand.RegisterOperand)GET_EXCEPTION.getOp1(quad)).getRegister(), quadInterpreter.getCaught());
            }

            private GET_EXCEPTION() {
            }
        }

        public static class GET_BASE_POINTER
        extends Special {
            public static final GET_BASE_POINTER INSTANCE = new GET_BASE_POINTER();

            public String toString() {
                return "GET_BASE_POINTER";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return GET_BASE_POINTER.getReg1(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private GET_BASE_POINTER() {
            }
        }

        public static class GET_STACK_POINTER
        extends Special {
            public static final GET_STACK_POINTER INSTANCE = new GET_STACK_POINTER();

            public String toString() {
                return "GET_STACK_POINTER";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return GET_STACK_POINTER.getReg1(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private GET_STACK_POINTER() {
            }
        }

        public static class GET_THREAD_BLOCK
        extends Special {
            public static final GET_THREAD_BLOCK INSTANCE = new GET_THREAD_BLOCK();

            public String toString() {
                return "GET_THREAD_BLOCK";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return GET_THREAD_BLOCK.getReg1(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                _delegate.interpretGetThreadBlock(this, quad, quadInterpreter);
            }

            private GET_THREAD_BLOCK() {
            }
        }

        public static class SET_THREAD_BLOCK
        extends Special {
            public static final SET_THREAD_BLOCK INSTANCE = new SET_THREAD_BLOCK();

            public String toString() {
                return "SET_THREAD_BLOCK";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return SET_THREAD_BLOCK.getReg2(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                _delegate.interpretSetThreadBlock(this, quad, quadInterpreter);
            }

            private SET_THREAD_BLOCK() {
            }
        }

        public static class ATOMICADD_I
        extends Special {
            public static final ATOMICADD_I INSTANCE = new ATOMICADD_I();

            public String toString() {
                return "ATOMICADD_I";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return ATOMICADD_I.getReg23(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                HeapAddress heapAddress = (HeapAddress)ATOMICADD_I.getAddressOpValue(ATOMICADD_I.getOp2(quad), quadInterpreter);
                int n = ATOMICADD_I.getIntOpValue(ATOMICADD_I.getOp3(quad), quadInterpreter);
                heapAddress.atomicAdd(n);
            }

            private ATOMICADD_I() {
            }
        }

        public static class ATOMICSUB_I
        extends Special {
            public static final ATOMICSUB_I INSTANCE = new ATOMICSUB_I();

            public String toString() {
                return "ATOMICSUB_I";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return ATOMICSUB_I.getReg23(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                HeapAddress heapAddress = (HeapAddress)ATOMICSUB_I.getAddressOpValue(ATOMICSUB_I.getOp2(quad), quadInterpreter);
                int n = ATOMICSUB_I.getIntOpValue(ATOMICSUB_I.getOp3(quad), quadInterpreter);
                heapAddress.atomicSub(n);
            }

            private ATOMICSUB_I() {
            }
        }

        public static class ATOMICAND_I
        extends Special {
            public static final ATOMICAND_I INSTANCE = new ATOMICAND_I();

            public String toString() {
                return "ATOMICAND_I";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return ATOMICAND_I.getReg23(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                HeapAddress heapAddress = (HeapAddress)ATOMICAND_I.getAddressOpValue(ATOMICAND_I.getOp2(quad), quadInterpreter);
                int n = ATOMICAND_I.getIntOpValue(ATOMICAND_I.getOp3(quad), quadInterpreter);
                heapAddress.atomicAnd(n);
            }

            private ATOMICAND_I() {
            }
        }

        public static class ATOMICCAS4
        extends Special {
            public static final ATOMICCAS4 INSTANCE = new ATOMICCAS4();

            public String toString() {
                return "ATOMICCAS4";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return ATOMICCAS4.getReg1(quad);
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return ATOMICCAS4.getReg234(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                HeapAddress heapAddress = (HeapAddress)ATOMICCAS4.getAddressOpValue(ATOMICCAS4.getOp2(quad), quadInterpreter);
                int n = ATOMICCAS4.getIntOpValue(ATOMICCAS4.getOp3(quad), quadInterpreter);
                int n2 = ATOMICCAS4.getIntOpValue(ATOMICCAS4.getOp4(quad), quadInterpreter);
                int n3 = heapAddress.atomicCas4(n, n2);
                quadInterpreter.putReg_I(((Operand.RegisterOperand)ATOMICCAS4.getOp1(quad)).getRegister(), n3);
            }

            private ATOMICCAS4() {
            }
        }

        public static class ATOMICCAS8
        extends Special {
            public static final ATOMICCAS8 INSTANCE = new ATOMICCAS8();

            public String toString() {
                return "ATOMICCAS8";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return ATOMICCAS8.getReg1(quad);
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return ATOMICCAS8.getReg234(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                HeapAddress heapAddress = (HeapAddress)ATOMICCAS8.getAddressOpValue(ATOMICCAS8.getOp2(quad), quadInterpreter);
                long l = ATOMICCAS8.getLongOpValue(ATOMICCAS8.getOp3(quad), quadInterpreter);
                long l2 = ATOMICCAS8.getLongOpValue(ATOMICCAS8.getOp4(quad), quadInterpreter);
                long l3 = heapAddress.atomicCas8(l, l2);
                quadInterpreter.putReg_L(((Operand.RegisterOperand)ATOMICCAS8.getOp1(quad)).getRegister(), l3);
            }

            private ATOMICCAS8() {
            }
        }

        public static class ALLOCA
        extends Special {
            public static final ALLOCA INSTANCE = new ALLOCA();

            public String toString() {
                return "ALLOCA";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return ALLOCA.getReg1(quad);
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return ALLOCA.getReg2(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private ALLOCA() {
            }
        }

        public static class LONG_JUMP
        extends Special {
            public static final LONG_JUMP INSTANCE = new LONG_JUMP();

            public String toString() {
                return "LONG_JUMP";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return LONG_JUMP.getReg1234(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private LONG_JUMP() {
            }
        }

        public static class POP_FP32
        extends Special {
            public static final POP_FP32 INSTANCE = new POP_FP32();

            public String toString() {
                return "POP_FP32";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return POP_FP32.getReg1(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private POP_FP32() {
            }
        }

        public static class POP_FP64
        extends Special {
            public static final POP_FP64 INSTANCE = new POP_FP64();

            public String toString() {
                return "POP_FP64";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return POP_FP64.getReg1(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private POP_FP64() {
            }
        }

        public static class PUSH_FP32
        extends Special {
            public static final PUSH_FP32 INSTANCE = new PUSH_FP32();

            public String toString() {
                return "PUSH_FP32";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return PUSH_FP32.getReg2(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private PUSH_FP32() {
            }
        }

        public static class PUSH_FP64
        extends Special {
            public static final PUSH_FP64 INSTANCE = new PUSH_FP64();

            public String toString() {
                return "PUSH_FP64";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return PUSH_FP64.getReg2(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private PUSH_FP64() {
            }
        }

        public static class GET_EAX
        extends Special {
            public static final GET_EAX INSTANCE = new GET_EAX();

            public String toString() {
                return "GET_EAX";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return GET_EAX.getReg1(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                _delegate.interpretGetThreadBlock(this, quad, quadInterpreter);
            }

            private GET_EAX() {
            }
        }

        public static class PUSHARG_I
        extends Special {
            public static final PUSHARG_I INSTANCE = new PUSHARG_I();

            public String toString() {
                return "PUSHARG_I";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return PUSHARG_I.getReg2(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private PUSHARG_I() {
            }
        }

        public static class PUSHARG_P
        extends Special {
            public static final PUSHARG_P INSTANCE = new PUSHARG_P();

            public String toString() {
                return "PUSHARG_P";
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return PUSHARG_P.getReg2(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private PUSHARG_P() {
            }
        }

        public static class INVOKE_L
        extends Special {
            public static final INVOKE_L INSTANCE = new INVOKE_L();

            public String toString() {
                return "INVOKE_L";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKE_L.getReg1(quad);
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return INVOKE_L.getReg2(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private INVOKE_L() {
            }
        }

        public static class INVOKE_P
        extends Special {
            public static final INVOKE_P INSTANCE = new INVOKE_P();

            public String toString() {
                return "INVOKE_P";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return INVOKE_P.getReg1(quad);
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return INVOKE_P.getReg2(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private INVOKE_P() {
            }
        }

        public static class ISEQ
        extends Special {
            public static final ISEQ INSTANCE = new ISEQ();

            public String toString() {
                return "ISEQ";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return ISEQ.getReg1(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private ISEQ() {
            }
        }

        public static class ISGE
        extends Special {
            public static final ISGE INSTANCE = new ISGE();

            public String toString() {
                return "ISGE";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return ISGE.getReg1(quad);
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private ISGE() {
            }
        }

        public static class NOP
        extends Special {
            public static final NOP INSTANCE = new NOP();

            public String toString() {
                return "NOP";
            }

            public UnmodifiableList.RegisterOperand getDefinedRegisters(Quad quad) {
                return null;
            }

            public UnmodifiableList.RegisterOperand getUsedRegisters(Quad quad) {
                return null;
            }

            public void interpret(Quad quad, QuadInterpreter quadInterpreter) {
                Assert.TODO();
            }

            private NOP() {
            }
        }
    }

    static interface Delegate {
        public void interpretGetThreadBlock(Special var1, Quad var2, QuadInterpreter var3);

        public void interpretSetThreadBlock(Special var1, Quad var2, QuadInterpreter var3);

        public void interpretMonitorEnter(Monitor var1, Quad var2, QuadInterpreter var3);

        public void interpretMonitorExit(Monitor var1, Quad var2, QuadInterpreter var3);
    }
}

