/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Class;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_Type;
import Compil3r.Analysis.IPA.ProgramLocation;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.CHACallGraph;
import Compil3r.Quad.CachedCallGraph;
import Compil3r.Quad.CallGraph;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ControlFlowGraphVisitor;
import Compil3r.Quad.Operand;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadIterator;
import Compil3r.Quad.RegisterFactory;
import Interpreter.QuadInterpreter;
import Util.Assert;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedList;

public class MethodInline
implements ControlFlowGraphVisitor {
    public static final boolean TRACE = false;
    public static final boolean TRACE_ORACLE = false;
    public static final boolean TRACE_DECISIONS = false;
    public static final PrintStream out = System.out;
    Oracle oracle;
    CallGraph cg;

    public void visitCFG(ControlFlowGraph controlFlowGraph) {
        Object object;
        Object object2;
        Object object3;
        QuadIterator quadIterator = new QuadIterator(controlFlowGraph);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        while (quadIterator.hasNext()) {
            object3 = quadIterator.nextQuad();
            if (!(((Quad)object3).getOperator() instanceof Operator.Invoke) || (object2 = this.oracle.shouldInline(controlFlowGraph, (BasicBlock)(object = quadIterator.getCurrentBasicBlock()), (Quad)object3)) == null) continue;
            linkedList.add(object);
            linkedList2.add(object3);
            linkedList3.add(object2);
        }
        object3 = linkedList.listIterator();
        object = linkedList2.listIterator();
        object2 = linkedList3.listIterator();
        while (object3.hasNext()) {
            object3.next();
            object.next();
            object2.next();
        }
        while (object3.hasPrevious()) {
            BasicBlock basicBlock = (BasicBlock)object3.previous();
            Quad quad = (Quad)object.previous();
            InliningDecision inliningDecision = (InliningDecision)object2.previous();
            inliningDecision.inlineCall(controlFlowGraph, basicBlock, quad);
            if (!(this.cg instanceof CachedCallGraph) || !(inliningDecision instanceof NoCheckInliningDecision)) continue;
            CachedCallGraph cachedCallGraph = (CachedCallGraph)this.cg;
            jq_Method jq_Method2 = controlFlowGraph.getMethod();
            ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(jq_Method2, quad);
            jq_Method jq_Method3 = ((NoCheckInliningDecision)inliningDecision).callee.getMethod();
            cachedCallGraph.inlineEdge(jq_Method2, quadProgramLocation, jq_Method3);
        }
    }

    public static void inlineNonVirtualCallSite(ControlFlowGraph controlFlowGraph, BasicBlock basicBlock, Quad quad, ControlFlowGraph controlFlowGraph2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Operator.Move move;
        int n = basicBlock.getQuadIndex(quad);
        boolean bl = false;
        if (n != -1) {
            bl = true;
        }
        Assert._assert(bl);
        controlFlowGraph2 = controlFlowGraph.merge(controlFlowGraph2);
        controlFlowGraph2.appendExceptionHandlers(basicBlock.getExceptionHandlers());
        BasicBlock basicBlock2 = controlFlowGraph.createBasicBlock(controlFlowGraph2.exit().getNumberOfPredecessors(), basicBlock.getNumberOfSuccessors(), basicBlock.size() - n, basicBlock.getExceptionHandlers());
        int n2 = basicBlock.size();
        int n3 = n + 1;
        while (n3 < n2) {
            basicBlock2.appendQuad(basicBlock.removeQuad(n + 1));
            ++n3;
        }
        Quad quad2 = basicBlock.removeQuad(n);
        boolean bl2 = false;
        if (quad2 == quad) {
            bl2 = true;
        }
        Assert._assert(bl2);
        boolean bl3 = false;
        if (basicBlock.size() == n) {
            bl3 = true;
        }
        Assert._assert(bl3);
        Operand.ParamListOperand paramListOperand = Operator.Invoke.getParamList(quad);
        jq_Type[] jq_TypeArray = controlFlowGraph2.getMethod().getParamTypes();
        int n4 = 0;
        int n5 = 0;
        while (n4 < jq_TypeArray.length) {
            move = Operator.Move.getMoveOp(jq_TypeArray[n4]);
            object5 = controlFlowGraph2.getRegisterFactory().getLocal(n5, jq_TypeArray[n4]);
            object4 = new Operand.RegisterOperand((RegisterFactory.Register)object5, jq_TypeArray[n4]);
            object3 = paramListOperand.get(n4).getRegister();
            object2 = new Operand.RegisterOperand((RegisterFactory.Register)object3, jq_TypeArray[n4]);
            object = Operator.Move.create(controlFlowGraph.getNewQuadID(), move, (Operand.RegisterOperand)object4, (Operand)object2);
            basicBlock.appendQuad((Quad)object);
            if (jq_TypeArray[n4].getReferenceSize() == 8) {
                ++n5;
            }
            ++n4;
            ++n5;
        }
        Object object6 = basicBlock.getSuccessors().basicBlockIterator();
        while (object6.hasNext()) {
            BasicBlock basicBlock3 = object6.nextBasicBlock();
            basicBlock3.removePredecessor(basicBlock);
            basicBlock3.addPredecessor(basicBlock2);
            basicBlock2.addSuccessor(basicBlock3);
        }
        basicBlock.removeAllSuccessors();
        basicBlock.addSuccessor(controlFlowGraph2.entry().getFallthroughSuccessor());
        controlFlowGraph2.entry().getFallthroughSuccessor().removeAllPredecessors();
        controlFlowGraph2.entry().getFallthroughSuccessor().addPredecessor(basicBlock);
        object6 = Operator.Invoke.getDest(quad);
        RegisterFactory.Register register = null;
        move = null;
        if (object6 != null) {
            register = ((Operand.RegisterOperand)object6).getRegister();
            move = Operator.Move.getMoveOp(controlFlowGraph2.getMethod().getReturnType());
        }
        object5 = controlFlowGraph2.exit().getPredecessors().basicBlockIterator();
        block3: while (object5.hasNext()) {
            object4 = object5.nextBasicBlock();
            while (((BasicBlock)object4).size() == 0) {
                if (((BasicBlock)object4).getNumberOfPredecessors() == 0) continue block3;
                object4 = ((BasicBlock)object4).getFallthroughPredecessor();
            }
            object3 = ((BasicBlock)object4).getLastQuad();
            if (((Quad)object3).getOperator() instanceof Operator.Return.THROW_A) {
                ((BasicBlock)object4).removeAllSuccessors();
                ((BasicBlock)object4).addSuccessor(controlFlowGraph.exit());
                controlFlowGraph.exit().addPredecessor((BasicBlock)object4);
                continue;
            }
            Assert._assert(((Quad)object3).getOperator() instanceof Operator.Return);
            ((BasicBlock)object4).removeQuad((Quad)object3);
            if (register != null) {
                object2 = new Operand.RegisterOperand(register, controlFlowGraph2.getMethod().getReturnType());
                object = Operator.Return.getSrc((Quad)object3).copy();
                Quad quad3 = Operator.Move.create(controlFlowGraph.getNewQuadID(), move, (Operand.RegisterOperand)object2, (Operand)object);
                ((BasicBlock)object4).appendQuad(quad3);
            }
            object2 = Operator.Goto.create(controlFlowGraph.getNewQuadID(), Operator.Goto.GOTO.INSTANCE, new Operand.TargetOperand(basicBlock2));
            ((BasicBlock)object4).appendQuad((Quad)object2);
            ((BasicBlock)object4).removeAllSuccessors();
            ((BasicBlock)object4).addSuccessor(basicBlock2);
            basicBlock2.addPredecessor((BasicBlock)object4);
        }
    }

    public static void inlineVirtualCallSiteWithTypeCheck(ControlFlowGraph controlFlowGraph, BasicBlock basicBlock, Quad quad, ControlFlowGraph controlFlowGraph2, jq_Class jq_Class2) {
        Operand.RegisterOperand registerOperand;
        Object object;
        Object object2;
        Object object3;
        Operator.Move move;
        int n = basicBlock.getQuadIndex(quad);
        boolean bl = false;
        if (n != -1) {
            bl = true;
        }
        Assert._assert(bl);
        controlFlowGraph2 = controlFlowGraph.merge(controlFlowGraph2);
        controlFlowGraph2.appendExceptionHandlers(basicBlock.getExceptionHandlers());
        BasicBlock basicBlock2 = controlFlowGraph.createBasicBlock(controlFlowGraph2.exit().getNumberOfPredecessors() + 1, basicBlock.getNumberOfSuccessors(), basicBlock.size() - n, basicBlock.getExceptionHandlers());
        int n2 = basicBlock.size();
        int n3 = n + 1;
        while (n3 < n2) {
            basicBlock2.appendQuad(basicBlock.removeQuad(n + 1));
            ++n3;
        }
        Quad quad2 = basicBlock.removeQuad(n);
        boolean bl2 = false;
        if (quad2 == quad) {
            bl2 = true;
        }
        Assert._assert(bl2);
        boolean bl3 = false;
        if (basicBlock.size() == n) {
            bl3 = true;
        }
        Assert._assert(bl3);
        BasicBlock basicBlock3 = controlFlowGraph.createBasicBlock(1, 1, 2, basicBlock.getExceptionHandlers());
        basicBlock3.appendQuad(quad2);
        Quad quad3 = Operator.Goto.create(controlFlowGraph.getNewQuadID(), Operator.Goto.GOTO.INSTANCE, new Operand.TargetOperand(basicBlock2));
        basicBlock3.appendQuad(quad3);
        basicBlock3.addSuccessor(basicBlock2);
        basicBlock2.addPredecessor(basicBlock3);
        BasicBlock basicBlock4 = controlFlowGraph.createBasicBlock(1, 1, Operator.Invoke.getParamList(quad).length(), basicBlock.getExceptionHandlers());
        jq_Type jq_Type2 = Operator.Invoke.getParam(quad, 0).getType();
        Operand.RegisterOperand registerOperand2 = new Operand.RegisterOperand(Operator.Invoke.getParam(quad, 0).getRegister(), jq_Type2);
        RegisterFactory.Register register = controlFlowGraph.getRegisterFactory().getNewStack(0, jq_Primitive.BOOLEAN);
        Operand.RegisterOperand registerOperand3 = new Operand.RegisterOperand(register, jq_Primitive.BOOLEAN);
        Operand.TypeOperand typeOperand = new Operand.TypeOperand(jq_Class2);
        quad3 = Operator.InstanceOf.create(controlFlowGraph.getNewQuadID(), Operator.InstanceOf.INSTANCEOF.INSTANCE, registerOperand3, registerOperand2, typeOperand);
        basicBlock.appendQuad(quad3);
        registerOperand3 = new Operand.RegisterOperand(register, jq_Primitive.BOOLEAN);
        Operand.IConstOperand iConstOperand = new Operand.IConstOperand(0);
        Operand.ConditionOperand conditionOperand = new Operand.ConditionOperand(1);
        Operand.TargetOperand targetOperand = new Operand.TargetOperand(basicBlock4);
        quad3 = Operator.IntIfCmp.create(controlFlowGraph.getNewQuadID(), Operator.IntIfCmp.IFCMP_I.INSTANCE, registerOperand3, iConstOperand, conditionOperand, targetOperand);
        basicBlock.appendQuad(quad3);
        Operand.ParamListOperand paramListOperand = Operator.Invoke.getParamList(quad);
        jq_Type[] jq_TypeArray = controlFlowGraph2.getMethod().getParamTypes();
        int n4 = 0;
        int n5 = 0;
        while (n4 < jq_TypeArray.length) {
            move = Operator.Move.getMoveOp(jq_TypeArray[n4]);
            object3 = controlFlowGraph2.getRegisterFactory().getLocal(n5, jq_TypeArray[n4]);
            object2 = new Operand.RegisterOperand((RegisterFactory.Register)object3, jq_TypeArray[n4]);
            object = paramListOperand.get(n4).getRegister();
            registerOperand = new Operand.RegisterOperand((RegisterFactory.Register)object, jq_TypeArray[n4]);
            quad3 = Operator.Move.create(controlFlowGraph.getNewQuadID(), move, (Operand.RegisterOperand)object2, registerOperand);
            basicBlock4.appendQuad(quad3);
            if (jq_TypeArray[n4].getReferenceSize() == 8) {
                ++n5;
            }
            ++n4;
            ++n5;
        }
        Object object4 = basicBlock.getSuccessors().basicBlockIterator();
        while (object4.hasNext()) {
            BasicBlock basicBlock5 = object4.nextBasicBlock();
            basicBlock5.removePredecessor(basicBlock);
            basicBlock5.addPredecessor(basicBlock2);
            basicBlock2.addSuccessor(basicBlock5);
        }
        basicBlock4.addSuccessor(controlFlowGraph2.entry().getFallthroughSuccessor());
        controlFlowGraph2.entry().getFallthroughSuccessor().removeAllPredecessors();
        controlFlowGraph2.entry().getFallthroughSuccessor().addPredecessor(basicBlock4);
        basicBlock.removeAllSuccessors();
        basicBlock.addSuccessor(basicBlock3);
        basicBlock3.addPredecessor(basicBlock);
        basicBlock.addSuccessor(basicBlock4);
        basicBlock4.addPredecessor(basicBlock);
        object4 = Operator.Invoke.getDest(quad);
        RegisterFactory.Register register2 = null;
        move = null;
        if (object4 != null) {
            register2 = ((Operand.RegisterOperand)object4).getRegister();
            move = Operator.Move.getMoveOp(controlFlowGraph2.getMethod().getReturnType());
        }
        object3 = controlFlowGraph2.exit().getPredecessors().basicBlockIterator();
        block3: while (object3.hasNext()) {
            object2 = object3.nextBasicBlock();
            while (((BasicBlock)object2).size() == 0) {
                if (((BasicBlock)object2).getNumberOfPredecessors() == 0) continue block3;
                object2 = ((BasicBlock)object2).getFallthroughPredecessor();
            }
            object = ((BasicBlock)object2).getLastQuad();
            if (((Quad)object).getOperator() instanceof Operator.Return.THROW_A) {
                ((BasicBlock)object2).removeAllSuccessors();
                ((BasicBlock)object2).addSuccessor(controlFlowGraph.exit());
                controlFlowGraph.exit().addPredecessor((BasicBlock)object2);
                continue;
            }
            Assert._assert(((Quad)object).getOperator() instanceof Operator.Return);
            ((BasicBlock)object2).removeQuad((Quad)object);
            if (register2 != null) {
                registerOperand = new Operand.RegisterOperand(register2, controlFlowGraph2.getMethod().getReturnType());
                Operand operand = Operator.Return.getSrc((Quad)object).copy();
                Quad quad4 = Operator.Move.create(controlFlowGraph.getNewQuadID(), move, registerOperand, operand);
                ((BasicBlock)object2).appendQuad(quad4);
            }
            quad3 = Operator.Goto.create(controlFlowGraph.getNewQuadID(), Operator.Goto.GOTO.INSTANCE, new Operand.TargetOperand(basicBlock2));
            ((BasicBlock)object2).appendQuad(quad3);
            ((BasicBlock)object2).removeAllSuccessors();
            ((BasicBlock)object2).addSuccessor(basicBlock2);
            basicBlock2.addPredecessor((BasicBlock)object2);
        }
    }

    public MethodInline(Oracle oracle) {
        this.oracle = oracle;
    }

    public MethodInline(CallGraph callGraph) {
        this(new InlineSmallSingleTargetCalls(callGraph));
        this.cg = callGraph;
    }

    public MethodInline() {
        this(new InlineSmallSingleTargetCalls(CHACallGraph.INSTANCE));
        this.cg = CHACallGraph.INSTANCE;
    }

    public static abstract class InliningDecision {
        public abstract void inlineCall(ControlFlowGraph var1, BasicBlock var2, Quad var3);
    }

    public static final class DontInline
    extends InliningDecision {
        public static final DontInline INSTANCE = new DontInline();

        public final void inlineCall(ControlFlowGraph controlFlowGraph, BasicBlock basicBlock, Quad quad) {
        }

        private DontInline() {
        }
    }

    public static class NoCheckInliningDecision
    extends InliningDecision {
        ControlFlowGraph callee;

        public void inlineCall(ControlFlowGraph controlFlowGraph, BasicBlock basicBlock, Quad quad) {
            MethodInline.inlineNonVirtualCallSite(controlFlowGraph, basicBlock, quad, this.callee);
        }

        public String toString() {
            return this.callee.getMethod().toString();
        }

        public NoCheckInliningDecision(jq_Method jq_Method2) {
            this(CodeCache.getCode(jq_Method2));
        }

        public NoCheckInliningDecision(ControlFlowGraph controlFlowGraph) {
            this.callee = controlFlowGraph;
        }
    }

    public static class TypeCheckInliningDecision
    extends InliningDecision {
        jq_Class expectedType;
        ControlFlowGraph callee;

        public void inlineCall(ControlFlowGraph controlFlowGraph, BasicBlock basicBlock, Quad quad) {
            MethodInline.inlineVirtualCallSiteWithTypeCheck(controlFlowGraph, basicBlock, quad, this.callee, this.expectedType);
        }

        public String toString() {
            return this.callee.getMethod().toString();
        }

        public TypeCheckInliningDecision(jq_Method jq_Method2) {
            this.expectedType = jq_Method2.getDeclaringClass();
            this.callee = CodeCache.getCode(jq_Method2);
        }
    }

    public static class InlineSmallSingleTargetCalls
    implements Oracle {
        public static final int DEFAULT_THRESHOLD = 25;
        protected CallGraph cg;
        int bcThreshold;

        public InliningDecision shouldInline(ControlFlowGraph controlFlowGraph, BasicBlock basicBlock, Quad quad) {
            jq_Method jq_Method2;
            if (Operator.Invoke.getMethod(quad).getMethod().needsDynamicLink(controlFlowGraph.getMethod())) {
                return null;
            }
            Operator.Invoke invoke = (Operator.Invoke)quad.getOperator();
            if (invoke.isVirtual()) {
                ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(controlFlowGraph.getMethod(), quad);
                Collection collection = this.cg.getTargetMethods(quadProgramLocation);
                if (collection.size() != 1) {
                    return null;
                }
                jq_Method2 = (jq_Method)collection.iterator().next();
            } else {
                jq_Method2 = Operator.Invoke.getMethod(quad).getMethod();
            }
            if (jq_Method2.getBytecode() == null) {
                return null;
            }
            if (jq_Method2.getBytecode().length > this.bcThreshold) {
                return null;
            }
            if (jq_Method2 == controlFlowGraph.getMethod()) {
                return null;
            }
            if (!QuadInterpreter.interpret_filter.isElement(jq_Method2)) {
                return null;
            }
            return new NoCheckInliningDecision(jq_Method2);
        }

        public InlineSmallSingleTargetCalls(CallGraph callGraph) {
            this(callGraph, 25);
        }

        public InlineSmallSingleTargetCalls(CallGraph callGraph, int n) {
            this.cg = callGraph;
            this.bcThreshold = n;
        }
    }

    public static interface Oracle {
        public InliningDecision shouldInline(ControlFlowGraph var1, BasicBlock var2, Quad var3);
    }
}

