/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Method;
import Clazz.jq_MethodVisitor;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ControlFlowGraphVisitor;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadIterator;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;

public class DataflowFramework {
    private static final boolean TRACE_DATAFLOW = true;
    private static final boolean TRACE_DATAFLOW_QUADS = false;
    private static final PrintStream DF_OUT = System.err;

    static class DataflowArray
    implements FactCollection {
        private Fact[] _pre;
        private Fact[] _post;
        private Fact _initial;
        private Fact _final;

        public Fact getPre(Quad quad) {
            return this._pre[quad.getID()];
        }

        public Fact getPost(Quad quad) {
            return this._post[quad.getID()];
        }

        public Fact getInitial() {
            return this._initial;
        }

        public Fact getFinal() {
            return this._final;
        }

        public void setPre(Quad quad, Fact fact) {
            this._pre[quad.getID()] = fact;
        }

        public void setPost(Quad quad, Fact fact) {
            this._post[quad.getID()] = fact;
        }

        public void setInitial(Fact fact) {
            this._initial = fact;
        }

        public void setFinal(Fact fact) {
            this._final = fact;
        }

        public DataflowArray(int n) {
            this._pre = new Fact[n];
            this._post = new Fact[n];
            this._initial = null;
            this._final = null;
        }
    }

    static class DataflowHash
    implements FactCollection {
        private HashMap _pre = new HashMap();
        private HashMap _post = new HashMap();
        private Fact _initial = null;
        private Fact _final = null;

        public Fact getPre(Quad quad) {
            return (Fact)this._pre.get(new Integer(quad.getID()));
        }

        public Fact getPost(Quad quad) {
            return (Fact)this._post.get(new Integer(quad.getID()));
        }

        public Fact getInitial() {
            return this._initial;
        }

        public Fact getFinal() {
            return this._final;
        }

        public void setPre(Quad quad, Fact fact) {
            this._pre.put(new Integer(quad.getID()), fact);
        }

        public void setPost(Quad quad, Fact fact) {
            this._post.put(new Integer(quad.getID()), fact);
        }

        public void setInitial(Fact fact) {
            this._initial = fact;
        }

        public void setFinal(Fact fact) {
            this._final = fact;
        }
    }

    static class Intraprocedural
    implements ControlFlowGraphVisitor {
        private FactCollection _dfc;
        private Transfer _transfer;

        private final void determineStorageStyle(ControlFlowGraph controlFlowGraph) {
            int n;
            QuadIterator quadIterator = new QuadIterator(controlFlowGraph);
            int n2 = 0;
            int n3 = Integer.MIN_VALUE;
            int n4 = Integer.MAX_VALUE;
            while (quadIterator.hasNext()) {
                n = quadIterator.nextQuad().getID();
                if (n > n3) {
                    n3 = n;
                }
                if (n < n4) {
                    n4 = n;
                }
                ++n2;
            }
            int n5 = 0;
            if (n4 >= 0 || n3 <= n2 * 2) {
                n5 = 1;
            }
            n = n5;
            DF_OUT.println("Number of quads: " + n2);
            DF_OUT.println("Minimum Quad ID: " + n4);
            DF_OUT.println("Maximum Quad ID: " + n3);
            DF_OUT.println("Using " + (n != 0 ? "array" : "HashMap") + " implementation.");
            this._dfc = n != 0 ? new DataflowArray(n3 + 1) : new DataflowHash();
            this._transfer.registerFactCollection(this._dfc);
        }

        public void visitCFG(ControlFlowGraph controlFlowGraph) {
            this.determineStorageStyle(controlFlowGraph);
            this._transfer.preprocess(controlFlowGraph);
            boolean bl = true;
            while (bl) {
                DF_OUT.println("Beginning a new pass.");
                QuadIterator quadIterator = new QuadIterator(controlFlowGraph);
                bl = false;
                while (quadIterator.hasNext()) {
                    Quad quad = quadIterator.nextQuad();
                    Fact fact = this._dfc.getPre(quad);
                    if (fact != null) {
                        Iterator iterator = quadIterator.predecessors();
                        while (iterator.hasNext()) {
                            Quad quad2 = (Quad)iterator.next();
                            if (quad2 == null) {
                                fact.meetWith(this._dfc.getInitial());
                                continue;
                            }
                            fact.meetWith(this._dfc.getPost(quad2));
                        }
                    }
                    if (!this._transfer.transfer(quad)) continue;
                    bl = true;
                }
            }
            DF_OUT.println("No changes, postprocessing...");
            this._transfer.postprocess(controlFlowGraph);
            DF_OUT.println("Method complete.");
        }

        public Intraprocedural(Transfer transfer) {
            this._transfer = transfer;
            this._dfc = null;
        }
    }

    public static class EmptyAnalysis
    extends jq_MethodVisitor.EmptyVisitor
    implements Transfer {
        ControlFlowGraphVisitor.CodeCacheVisitor ccv = new ControlFlowGraphVisitor.CodeCacheVisitor(new Intraprocedural(this));
        protected FactCollection _fc;

        public void registerFactCollection(FactCollection factCollection) {
            this._fc = factCollection;
        }

        public void preprocess(ControlFlowGraph controlFlowGraph) {
        }

        public boolean transfer(Quad quad) {
            return false;
        }

        public void postprocess(ControlFlowGraph controlFlowGraph) {
        }

        public void visitMethod(jq_Method jq_Method2) {
            DF_OUT.println("Analyzing method: " + jq_Method2.getName());
            this.ccv.visitMethod(jq_Method2);
        }
    }

    static interface FactCollection {
        public Fact getPre(Quad var1);

        public Fact getPost(Quad var1);

        public Fact getInitial();

        public Fact getFinal();

        public void setPre(Quad var1, Fact var2);

        public void setPost(Quad var1, Fact var2);

        public void setInitial(Fact var1);

        public void setFinal(Fact var1);
    }

    static interface Fact {
        public Fact meetWith(Fact var1);

        public Fact deepCopy();
    }

    static interface Transfer {
        public void registerFactCollection(FactCollection var1);

        public void preprocess(ControlFlowGraph var1);

        public boolean transfer(Quad var1);

        public void postprocess(ControlFlowGraph var1);
    }
}

