/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_Type;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.BasicBlockVisitor;
import Compil3r.Quad.ControlFlowGraphNavigator;
import Compil3r.Quad.ExceptionHandler;
import Compil3r.Quad.ExceptionHandlerList;
import Compil3r.Quad.JSRInfo;
import Compil3r.Quad.Operand;
import Compil3r.Quad.Quad;
import Compil3r.Quad.RegisterFactory;
import Util.Assert;
import Util.Collections.FilterIterator;
import Util.Graphs.Graph;
import Util.Graphs.Navigator;
import Util.Strings;
import Util.Templates.List;
import Util.Templates.ListIterator;
import Util.Templates.ListWrapper;
import Util.Templates.UnmodifiableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ControlFlowGraph
implements Graph {
    private final jq_Method method;
    private final BasicBlock start_node;
    private final BasicBlock end_node;
    private final List exception_handlers;
    private final RegisterFactory rf;
    private int bb_counter;
    private int quad_counter;
    Map jsr_map;

    public BasicBlock entry() {
        return this.start_node;
    }

    public BasicBlock exit() {
        return this.end_node;
    }

    public jq_Method getMethod() {
        return this.method;
    }

    public RegisterFactory getRegisterFactory() {
        return this.rf;
    }

    public BasicBlock createBasicBlock(int n, int n2, int n3, ExceptionHandlerList exceptionHandlerList) {
        return BasicBlock.createBasicBlock(++this.bb_counter, n, n2, n3, exceptionHandlerList);
    }

    void updateBBcounter(int n) {
        this.bb_counter = n - 1;
    }

    public int getNumberOfBasicBlocks() {
        return this.bb_counter + 1;
    }

    public int getNumberOfQuads() {
        int n = 0;
        ListIterator.BasicBlock basicBlock = this.reversePostOrderIterator();
        while (basicBlock.hasNext()) {
            BasicBlock basicBlock2 = basicBlock.nextBasicBlock();
            n += basicBlock2.size();
        }
        return n;
    }

    public int getNewQuadID() {
        return ++this.quad_counter;
    }

    public int getMaxQuadID() {
        return this.quad_counter;
    }

    public void addJSRInfo(JSRInfo jSRInfo) {
        if (this.jsr_map == null) {
            this.jsr_map = new HashMap();
        }
        this.jsr_map.put(jSRInfo.entry_block, jSRInfo);
        this.jsr_map.put(jSRInfo.exit_block, jSRInfo);
    }

    public JSRInfo getJSRInfo(BasicBlock basicBlock) {
        return (JSRInfo)this.jsr_map.get(basicBlock);
    }

    public ListIterator.BasicBlock reversePostOrderIterator() {
        return this.reversePostOrderIterator(this.start_node);
    }

    public ListIterator.BasicBlock reversePostOrderOnReverseGraphIterator() {
        return this.reversePostOrderOnReverseGraph(this.end_node).basicBlockIterator();
    }

    public ListIterator.BasicBlock postOrderOnReverseGraphIterator() {
        return this.postOrderOnReverseGraph(this.end_node).basicBlockIterator();
    }

    public ListIterator.BasicBlock reversePostOrderIterator(BasicBlock basicBlock) {
        return this.reversePostOrder(basicBlock).basicBlockIterator();
    }

    public void visitBasicBlocks(BasicBlockVisitor basicBlockVisitor) {
        ListIterator.BasicBlock basicBlock = this.reversePostOrderIterator();
        while (basicBlock.hasNext()) {
            BasicBlock basicBlock2 = basicBlock.nextBasicBlock();
            basicBlockVisitor.visitBasicBlock(basicBlock2);
        }
    }

    public List.BasicBlock reversePostOrder(BasicBlock basicBlock) {
        LinkedList linkedList = new LinkedList();
        boolean[] blArray = new boolean[this.bb_counter + 1];
        this.reversePostOrder_helper(basicBlock, blArray, linkedList, true);
        BasicBlock[] basicBlockArray = new BasicBlock[linkedList.size()];
        basicBlockArray = linkedList.toArray(basicBlockArray);
        return new UnmodifiableList.BasicBlock(basicBlockArray);
    }

    public List.BasicBlock reversePostOrderOnReverseGraph(BasicBlock basicBlock) {
        LinkedList linkedList = new LinkedList();
        boolean[] blArray = new boolean[this.bb_counter + 1];
        this.reversePostOrder_helper(basicBlock, blArray, linkedList, false);
        BasicBlock[] basicBlockArray = new BasicBlock[linkedList.size()];
        basicBlockArray = linkedList.toArray(basicBlockArray);
        return new UnmodifiableList.BasicBlock(basicBlockArray);
    }

    public List.BasicBlock postOrderOnReverseGraph(BasicBlock basicBlock) {
        LinkedList linkedList = new LinkedList();
        boolean[] blArray = new boolean[this.bb_counter + 1];
        this.reversePostOrder_helper(basicBlock, blArray, linkedList, false);
        Collections.reverse(linkedList);
        BasicBlock[] basicBlockArray = new BasicBlock[linkedList.size()];
        basicBlockArray = linkedList.toArray(basicBlockArray);
        return new UnmodifiableList.BasicBlock(basicBlockArray);
    }

    private final void reversePostOrder_helper(BasicBlock basicBlock, boolean[] blArray, LinkedList linkedList, boolean bl) {
        Object object;
        if (blArray[basicBlock.getID()]) {
            return;
        }
        blArray[basicBlock.getID()] = true;
        List.BasicBlock basicBlock2 = bl ? basicBlock.getSuccessors() : basicBlock.getPredecessors();
        ListIterator.BasicBlock basicBlock3 = basicBlock2.basicBlockIterator();
        while (basicBlock3.hasNext()) {
            object = basicBlock3.nextBasicBlock();
            this.reversePostOrder_helper((BasicBlock)object, blArray, linkedList, bl);
        }
        if (bl) {
            object = basicBlock.getExceptionHandlers().exceptionHandlerIterator();
            while (object.hasNext()) {
                ExceptionHandler exceptionHandler = object.nextExceptionHandler();
                BasicBlock basicBlock4 = exceptionHandler.getEntry();
                this.reversePostOrder_helper(basicBlock4, blArray, linkedList, bl);
            }
        } else if (basicBlock.isExceptionHandlerEntry()) {
            object = this.getExceptionHandlersMatchingEntry(basicBlock);
            while (object.hasNext()) {
                ExceptionHandler exceptionHandler = (ExceptionHandler)object.next();
                ListIterator.BasicBlock basicBlock5 = exceptionHandler.getHandledBasicBlocks().basicBlockIterator();
                while (basicBlock5.hasNext()) {
                    BasicBlock basicBlock6 = basicBlock5.nextBasicBlock();
                    this.reversePostOrder_helper(basicBlock6, blArray, linkedList, bl);
                }
            }
        }
        linkedList.addFirst(basicBlock);
    }

    void addExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exception_handlers.add(exceptionHandler);
    }

    public List.ExceptionHandler getExceptionHandlers() {
        return new ListWrapper.ExceptionHandler(this.exception_handlers);
    }

    public Iterator getExceptionHandlersMatchingEntry(BasicBlock basicBlock) {
        BasicBlock basicBlock2 = basicBlock;
        return new FilterIterator(this.exception_handlers.iterator(), new FilterIterator.Filter(this, basicBlock2){
            final /* synthetic */ ControlFlowGraph this$0;
            final /* synthetic */ BasicBlock val$bb;

            public final boolean isElement(Object object) {
                ExceptionHandler exceptionHandler = (ExceptionHandler)object;
                boolean bl = false;
                if (exceptionHandler.getEntry() == this.val$bb) {
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = controlFlowGraph;
                this.val$bb = basicBlock;
            }
        });
    }

    public String fullDump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Control flow graph for " + this.method + ':' + Strings.lineSep);
        ListIterator.BasicBlock basicBlock = this.reversePostOrderIterator();
        while (basicBlock.hasNext()) {
            BasicBlock basicBlock2 = basicBlock.nextBasicBlock();
            stringBuffer.append(basicBlock2.fullDump());
        }
        stringBuffer.append("Exception handlers: " + this.exception_handlers);
        stringBuffer.append(Strings.lineSep + "Register factory: " + this.rf);
        return stringBuffer.toString();
    }

    private final ExceptionHandler copier(HashMap hashMap, ExceptionHandler exceptionHandler) {
        ExceptionHandler exceptionHandler2 = (ExceptionHandler)hashMap.get(exceptionHandler);
        if (exceptionHandler2 != null) {
            return exceptionHandler2;
        }
        exceptionHandler2 = new ExceptionHandler(exceptionHandler.getExceptionType());
        hashMap.put(exceptionHandler, exceptionHandler2);
        exceptionHandler2.setEntry(this.copier(hashMap, exceptionHandler.getEntry()));
        ListIterator.BasicBlock basicBlock = exceptionHandler.getHandledBasicBlocks().basicBlockIterator();
        while (basicBlock.hasNext()) {
            exceptionHandler2.addHandledBasicBlock(this.copier(hashMap, basicBlock.nextBasicBlock()));
        }
        return exceptionHandler2;
    }

    private final ExceptionHandlerList copier(HashMap hashMap, ExceptionHandlerList exceptionHandlerList) {
        if (exceptionHandlerList == null || exceptionHandlerList.size() == 0) {
            return null;
        }
        ExceptionHandlerList exceptionHandlerList2 = (ExceptionHandlerList)hashMap.get(exceptionHandlerList);
        if (exceptionHandlerList2 != null) {
            return exceptionHandlerList2;
        }
        exceptionHandlerList2 = new ExceptionHandlerList();
        hashMap.put(exceptionHandlerList, exceptionHandlerList2);
        exceptionHandlerList2.setHandler(this.copier(hashMap, exceptionHandlerList.getHandler()));
        exceptionHandlerList2.setParent(this.copier(hashMap, exceptionHandlerList.getParent()));
        return exceptionHandlerList2;
    }

    private final void updateOperand(HashMap hashMap, Operand operand) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (operand == null) {
                            return;
                        }
                        if (!(operand instanceof Operand.TargetOperand)) break block7;
                        ((Operand.TargetOperand)operand).setTarget(this.copier(hashMap, ((Operand.TargetOperand)operand).getTarget()));
                        break block8;
                    }
                    if (!(operand instanceof Operand.BasicBlockTableOperand)) break block9;
                    Operand.BasicBlockTableOperand basicBlockTableOperand = (Operand.BasicBlockTableOperand)operand;
                    int n = 0;
                    while (n < basicBlockTableOperand.size()) {
                        basicBlockTableOperand.set(n, this.copier(hashMap, basicBlockTableOperand.get(n)));
                        ++n;
                    }
                    break block8;
                }
                if (!(operand instanceof Operand.RegisterOperand)) break block10;
                Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)operand;
                RegisterFactory.Register register = (RegisterFactory.Register)hashMap.get(registerOperand.getRegister());
                if (register == null) {
                    if (registerOperand.getRegister().getNumber() == -1) {
                        register = RegisterFactory.makeGuardReg().getRegister();
                        hashMap.put(registerOperand.getRegister(), register);
                    } else {
                        Assert.UNREACHABLE(registerOperand.toString());
                    }
                } else {
                    registerOperand.setRegister(register);
                }
                break block8;
            }
            if (!(operand instanceof Operand.ParamListOperand)) break block8;
            Operand.ParamListOperand paramListOperand = (Operand.ParamListOperand)operand;
            int n = 0;
            while (n < paramListOperand.length()) {
                this.updateOperand(hashMap, paramListOperand.get(n));
                ++n;
            }
        }
    }

    private final Quad copier(HashMap hashMap, Quad quad) {
        Quad quad2 = (Quad)hashMap.get(quad);
        if (quad2 != null) {
            return quad2;
        }
        quad2 = quad.copy(++this.quad_counter);
        hashMap.put(quad, quad2);
        this.updateOperand(hashMap, quad2.getOp1());
        this.updateOperand(hashMap, quad2.getOp2());
        this.updateOperand(hashMap, quad2.getOp3());
        this.updateOperand(hashMap, quad2.getOp4());
        return quad2;
    }

    private final BasicBlock copier(HashMap hashMap, BasicBlock basicBlock) {
        BasicBlock basicBlock2 = (BasicBlock)hashMap.get(basicBlock);
        if (basicBlock2 != null) {
            return basicBlock2;
        }
        basicBlock2 = BasicBlock.createBasicBlock(++this.bb_counter, basicBlock.getNumberOfPredecessors(), basicBlock.getNumberOfSuccessors(), basicBlock.size());
        hashMap.put(basicBlock, basicBlock2);
        ExceptionHandlerList exceptionHandlerList = this.copier(hashMap, basicBlock.getExceptionHandlers());
        basicBlock2.setExceptionHandlerList(exceptionHandlerList);
        ListIterator listIterator = basicBlock.getSuccessors().basicBlockIterator();
        while (listIterator.hasNext()) {
            basicBlock2.addSuccessor(this.copier(hashMap, listIterator.nextBasicBlock()));
        }
        listIterator = basicBlock.getPredecessors().basicBlockIterator();
        while (listIterator.hasNext()) {
            basicBlock2.addPredecessor(this.copier(hashMap, listIterator.nextBasicBlock()));
        }
        listIterator = basicBlock.iterator();
        while (listIterator.hasNext()) {
            basicBlock2.appendQuad(this.copier(hashMap, listIterator.nextQuad()));
        }
        return basicBlock2;
    }

    static void addRegistersToMap(HashMap hashMap, RegisterFactory registerFactory, RegisterFactory registerFactory2, jq_Type jq_Type2) {
        int n = registerFactory.getLocalSize(jq_Type2);
        boolean bl = false;
        if (n == registerFactory2.getLocalSize(jq_Type2)) {
            bl = true;
        }
        Assert._assert(bl, n + " != " + registerFactory2.getLocalSize(jq_Type2));
        int n2 = 0;
        while (n2 < n) {
            hashMap.put(registerFactory.getLocal(n2, jq_Type2), registerFactory2.getLocal(n2, jq_Type2));
            ++n2;
        }
        n = registerFactory.getStackSize(jq_Type2);
        boolean bl2 = false;
        if (n == registerFactory2.getStackSize(jq_Type2)) {
            bl2 = true;
        }
        Assert._assert(bl2);
        n2 = 0;
        while (n2 < n) {
            hashMap.put(registerFactory.getStack(n2, jq_Type2), registerFactory2.getStack(n2, jq_Type2));
            ++n2;
        }
    }

    static void addRegistersToMap(HashMap hashMap, RegisterFactory registerFactory, RegisterFactory registerFactory2) {
        ControlFlowGraph.addRegistersToMap(hashMap, registerFactory, registerFactory2, jq_Primitive.INT);
        ControlFlowGraph.addRegistersToMap(hashMap, registerFactory, registerFactory2, jq_Primitive.FLOAT);
        ControlFlowGraph.addRegistersToMap(hashMap, registerFactory, registerFactory2, jq_Primitive.LONG);
        ControlFlowGraph.addRegistersToMap(hashMap, registerFactory, registerFactory2, jq_Primitive.DOUBLE);
        ControlFlowGraph.addRegistersToMap(hashMap, registerFactory, registerFactory2, PrimordialClassLoader.getJavaLangObject());
    }

    public ControlFlowGraph merge(ControlFlowGraph controlFlowGraph) {
        RegisterFactory registerFactory = this.rf.merge(controlFlowGraph.rf);
        ControlFlowGraph controlFlowGraph2 = new ControlFlowGraph(controlFlowGraph.getMethod(), controlFlowGraph.exit().getNumberOfPredecessors(), controlFlowGraph.exception_handlers.size(), registerFactory);
        HashMap<BasicBlock, BasicBlock> hashMap = new HashMap<BasicBlock, BasicBlock>();
        hashMap.put(controlFlowGraph.entry(), controlFlowGraph2.entry());
        hashMap.put(controlFlowGraph.exit(), controlFlowGraph2.exit());
        ControlFlowGraph.addRegistersToMap(hashMap, controlFlowGraph.getRegisterFactory(), registerFactory);
        ListIterator listIterator = controlFlowGraph.getExceptionHandlers().exceptionHandlerIterator();
        while (listIterator.hasNext()) {
            controlFlowGraph2.addExceptionHandler(this.copier(hashMap, listIterator.nextExceptionHandler()));
        }
        controlFlowGraph2.entry().addSuccessor(this.copier(hashMap, controlFlowGraph.entry().getFallthroughSuccessor()));
        listIterator = controlFlowGraph.exit().getPredecessors().basicBlockIterator();
        while (listIterator.hasNext()) {
            controlFlowGraph2.exit().addPredecessor(this.copier(hashMap, listIterator.nextBasicBlock()));
        }
        controlFlowGraph2.bb_counter = this.bb_counter;
        controlFlowGraph2.quad_counter = this.quad_counter;
        return controlFlowGraph2;
    }

    public void appendExceptionHandlers(ExceptionHandlerList exceptionHandlerList) {
        if (exceptionHandlerList == null || exceptionHandlerList.size() == 0) {
            return;
        }
        ListIterator.BasicBlock basicBlock = this.reversePostOrderIterator();
        while (basicBlock.hasNext()) {
            BasicBlock basicBlock2 = basicBlock.nextBasicBlock();
            if (basicBlock2.isEntry() || basicBlock2.isExit()) continue;
            basicBlock2.appendExceptionHandlerList(exceptionHandlerList);
        }
    }

    public Collection getRoots() {
        return Collections.singleton(this.start_node);
    }

    public Navigator getNavigator() {
        return new ControlFlowGraphNavigator(this);
    }

    public ControlFlowGraph(jq_Method jq_Method2, int n, int n2, RegisterFactory registerFactory) {
        this.method = jq_Method2;
        this.start_node = BasicBlock.createStartNode();
        this.end_node = BasicBlock.createEndNode(n);
        this.exception_handlers = new ArrayList(n2);
        this.rf = registerFactory;
        this.bb_counter = 1;
        this.quad_counter = 0;
    }
}

