/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Method;
import Compil3r.Analysis.IPA.ProgramLocation;
import Compil3r.Quad.CallGraph;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadIterator;
import Util.Assert;
import Util.Collections.GenericInvertibleMultiMap;
import Util.Collections.HashWorklist;
import Util.Collections.InvertibleMultiMap;
import Util.Collections.MultiMap;
import Util.Collections.UnmodifiableIterator;
import Util.Collections.UnmodifiableMultiMap;
import Util.Graphs.Graph;
import Util.Graphs.Navigator;
import Util.Strings;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;

public abstract class CallGraph
extends UnmodifiableMultiMap
implements Graph {
    public abstract void setRoots(Collection var1);

    public abstract Collection getRoots();

    public Collection getAllMethods() {
        return this.calculateReachableMethods(this.getRoots());
    }

    public Collection getAllCallSites() {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.getAllMethods().iterator();
        while (iterator.hasNext()) {
            linkedList.addAll(this.getCallSites((jq_Method)iterator.next()));
        }
        return linkedList;
    }

    public abstract Collection getTargetMethods(Object var1, ProgramLocation var2);

    public Collection getTargetMethods(ProgramLocation programLocation) {
        return this.getTargetMethods(null, programLocation);
    }

    public int numberOfTargetMethods(Object object, ProgramLocation programLocation) {
        return this.getTargetMethods(object, programLocation).size();
    }

    public int numberOfTargetMethods(ProgramLocation programLocation) {
        return this.numberOfTargetMethods(null, programLocation);
    }

    public jq_Method getTargetMethod(Object object, ProgramLocation programLocation) {
        Collection collection = this.getTargetMethods(object, programLocation);
        boolean bl = false;
        if (collection.size() == 1) {
            bl = true;
        }
        Assert._assert(bl);
        return (jq_Method)collection.iterator().next();
    }

    public Collection getCallSites(jq_Method jq_Method2) {
        return CallGraph.getCallSites0(jq_Method2);
    }

    public static Collection getCallSites0(jq_Method jq_Method2) {
        jq_Method2.getDeclaringClass().load();
        if (jq_Method2.getBytecode() == null) {
            return Collections.EMPTY_SET;
        }
        ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method2);
        return CallGraph.getCallSites0(controlFlowGraph);
    }

    public Collection getCallSites(ControlFlowGraph controlFlowGraph) {
        return CallGraph.getCallSites0(controlFlowGraph);
    }

    public static Collection getCallSites0(ControlFlowGraph controlFlowGraph) {
        LinkedList<ProgramLocation.QuadProgramLocation> linkedList = new LinkedList<ProgramLocation.QuadProgramLocation>();
        QuadIterator quadIterator = new QuadIterator(controlFlowGraph);
        while (quadIterator.hasNext()) {
            Quad quad = quadIterator.nextQuad();
            if (!(quad.getOperator() instanceof Operator.Invoke)) continue;
            linkedList.add(new ProgramLocation.QuadProgramLocation(controlFlowGraph.getMethod(), quad));
        }
        return linkedList;
    }

    public static Collection getCallSites1(ControlFlowGraph controlFlowGraph) {
        Object object;
        int n = 0;
        QuadIterator quadIterator = new QuadIterator(controlFlowGraph);
        while (quadIterator.hasNext()) {
            object = quadIterator.nextQuad();
            if (!(((Quad)object).getOperator() instanceof Operator.Invoke)) continue;
            ++n;
        }
        int n2 = n;
        object = new QuadIterator(controlFlowGraph);
        return new AbstractSet(n2, (QuadIterator)object){
            final /* synthetic */ int val$size;
            final /* synthetic */ QuadIterator val$i;

            public final int size() {
                return this.val$size;
            }

            public final Iterator iterator() {
                return new UnmodifiableIterator(this){
                    Quad _next;
                    final /* synthetic */ 1 this$0;

                    private final void advance() {
                        while (this.this$0.val$i.hasNext()) {
                            Quad quad = this.this$0.val$i.nextQuad();
                            if (!(quad.getOperator() instanceof Operator.Invoke)) continue;
                            this._next = quad;
                            return;
                        }
                        this._next = null;
                    }

                    public final boolean hasNext() {
                        boolean bl = false;
                        if (this._next != null) {
                            bl = true;
                        }
                        return bl;
                    }

                    public final Object next() {
                        Quad quad = this._next;
                        if (quad == null) {
                            throw new NoSuchElementException();
                        }
                        this.advance();
                        return quad;
                    }

                    private final /* synthetic */ void this() {
                        this.advance();
                    }
                    {
                        this.this$0 = var1_1;
                        this.this();
                    }
                };
            }
            {
                this.val$size = n;
                this.val$i = quadIterator;
            }
        };
    }

    public Collection getCallees(jq_Method jq_Method2) {
        jq_Method2.getDeclaringClass().load();
        if (jq_Method2.getBytecode() == null) {
            return Collections.EMPTY_SET;
        }
        ControlFlowGraph controlFlowGraph = CodeCache.getCode(jq_Method2);
        return this.getCallees(controlFlowGraph);
    }

    public Collection getCallees(ControlFlowGraph controlFlowGraph) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        QuadIterator quadIterator = new QuadIterator(controlFlowGraph);
        while (quadIterator.hasNext()) {
            Quad quad = quadIterator.nextQuad();
            if (!(quad.getOperator() instanceof Operator.Invoke)) continue;
            ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(controlFlowGraph.getMethod(), quad);
            linkedHashSet.addAll(this.getTargetMethods(quadProgramLocation));
        }
        return linkedHashSet;
    }

    public Collection getCallers(jq_Method jq_Method2) {
        LinkedList<ProgramLocation> linkedList = new LinkedList<ProgramLocation>();
        Iterator iterator = this.getAllCallSites().iterator();
        while (iterator.hasNext()) {
            ProgramLocation programLocation = (ProgramLocation)iterator.next();
            if (!this.getTargetMethods(programLocation).contains(jq_Method2)) continue;
            linkedList.add(programLocation);
        }
        return linkedList;
    }

    public Collection getCallerMethods(jq_Method jq_Method2) {
        LinkedList<jq_Method> linkedList = new LinkedList<jq_Method>();
        Iterator iterator = this.getAllCallSites().iterator();
        while (iterator.hasNext()) {
            ProgramLocation programLocation = (ProgramLocation)iterator.next();
            if (!this.getTargetMethods(programLocation).contains(jq_Method2)) continue;
            linkedList.add(programLocation.getMethod());
        }
        return linkedList;
    }

    public Set calculateReachableMethods(Collection collection) {
        HashWorklist hashWorklist = new HashWorklist(true);
        hashWorklist.addAll(collection);
        while (!hashWorklist.isEmpty()) {
            jq_Method jq_Method2 = (jq_Method)hashWorklist.pull();
            Collection collection2 = this.getCallees(jq_Method2);
            hashWorklist.addAll(collection2);
        }
        return hashWorklist.getVisitedSet();
    }

    public String toString() {
        TreeSet treeSet = new TreeSet(new Comparator(this){
            final /* synthetic */ CallGraph this$0;

            public final int compare(Object object, Object object2) {
                int n;
                ProgramLocation programLocation = (ProgramLocation)object;
                Collection collection = this.this$0.getTargetMethods(programLocation);
                ProgramLocation programLocation2 = (ProgramLocation)object2;
                Collection collection2 = this.this$0.getTargetMethods(programLocation2);
                int n2 = collection.size();
                if (n2 < (n = collection2.size())) {
                    return 1;
                }
                if (n2 > n) {
                    return -1;
                }
                return programLocation.toString().compareTo(programLocation2.toString());
            }
            {
                this.this$0 = callGraph;
            }
        });
        treeSet.addAll(this.getAllCallSites());
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            ProgramLocation programLocation = (ProgramLocation)iterator.next();
            Collection collection = this.getTargetMethods(programLocation);
            stringBuffer.append(programLocation.toString());
            stringBuffer.append(": {");
            int n = collection.size();
            stringBuffer.append(n);
            stringBuffer.append("} ");
            stringBuffer.append(collection.toString());
            stringBuffer.append(Strings.lineSep);
        }
        return stringBuffer.toString();
    }

    public Map calculateCallerRelation() {
        Object object;
        Collection collection = this.getRoots();
        HashMap hashMap = new HashMap();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = (jq_Method)object2.next();
            hashMap.put((jq_Method)object, new HashSet());
            linkedList.add(object);
        }
        while (!linkedList.isEmpty()) {
            object2 = (jq_Method)linkedList.removeFirst();
            object = this.getCallSites((jq_Method)object2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ProgramLocation programLocation = (ProgramLocation)iterator.next();
                Collection collection2 = this.getTargetMethods(programLocation);
                Iterator iterator2 = collection2.iterator();
                while (iterator2.hasNext()) {
                    jq_Method jq_Method2 = (jq_Method)iterator.next();
                    HashSet<ProgramLocation> hashSet = (HashSet<ProgramLocation>)hashMap.get(jq_Method2);
                    if (hashSet == null) {
                        hashSet = new HashSet<ProgramLocation>();
                        hashMap.put(jq_Method2, hashSet);
                        linkedList.add(jq_Method2);
                    }
                    hashSet.add(programLocation);
                }
            }
        }
        return hashMap;
    }

    public InvertibleMultiMap calculateEdgeRelation() {
        GenericInvertibleMultiMap genericInvertibleMultiMap = new GenericInvertibleMultiMap();
        Iterator iterator = this.getAllMethods().iterator();
        while (iterator.hasNext()) {
            jq_Method jq_Method2 = (jq_Method)iterator.next();
            Collection collection = genericInvertibleMultiMap.getValues(jq_Method2);
            Collection collection2 = this.getCallSites(jq_Method2);
            collection.addAll(collection2);
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                ProgramLocation programLocation = (ProgramLocation)iterator2.next();
                Collection collection3 = genericInvertibleMultiMap.getValues(programLocation);
                Collection collection4 = this.getTargetMethods(programLocation);
                collection3.addAll(collection4);
            }
        }
        return genericInvertibleMultiMap;
    }

    public Collection[] findDepths() {
        Collection collection = this.getRoots();
        HashSet<jq_Method> hashSet = new HashSet<jq_Method>();
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        hashSet.addAll(collection);
        linkedList2.addAll(collection);
        while (!linkedList2.isEmpty()) {
            linkedList.add(linkedList2);
            LinkedList<jq_Method> linkedList3 = new LinkedList<jq_Method>();
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                jq_Method jq_Method2 = (jq_Method)iterator.next();
                Iterator iterator2 = this.getCallSites(jq_Method2).iterator();
                while (iterator2.hasNext()) {
                    ProgramLocation programLocation = (ProgramLocation)iterator2.next();
                    Iterator iterator3 = this.getTargetMethods(programLocation).iterator();
                    while (iterator3.hasNext()) {
                        jq_Method jq_Method3 = (jq_Method)iterator3.next();
                        if (hashSet.contains(jq_Method3)) continue;
                        hashSet.add(jq_Method3);
                        linkedList3.add(jq_Method3);
                    }
                }
            }
            linkedList2 = linkedList3;
        }
        return linkedList.toArray(new Collection[linkedList.size()]);
    }

    public Navigator getNavigator() {
        return this.getMethodNavigator();
    }

    public Navigator getMethodNavigator() {
        return new CallGraphMethodNavigator();
    }

    public Navigator getCallSiteNavigator() {
        return new CallGraphCSNavigator();
    }

    public MultiMap getCallSiteMap() {
        Set set = (Set)this.getAllMethods();
        CallSiteMap callSiteMap = new CallSiteMap(set);
        return callSiteMap;
    }

    public MultiMap getCallGraphMap() {
        Set set = (Set)this.getAllMethods();
        CallSiteMap callSiteMap = new CallSiteMap(set);
        CallTargetMap callTargetMap = new CallTargetMap((Set)callSiteMap.values());
        return new CallGraphMap(callSiteMap, callTargetMap);
    }

    public Set entrySet() {
        return this.entrySetHelper((Set)this.getAllCallSites());
    }

    public boolean contains(Object object, Object object2) {
        ProgramLocation programLocation = (ProgramLocation)object;
        return this.getTargetMethods(programLocation).contains(object2);
    }

    public Collection getValues(Object object) {
        ProgramLocation programLocation = (ProgramLocation)object;
        return this.getTargetMethods(programLocation);
    }

    public static CallGraph makeCallGraph(Collection collection, Map map) {
        Collection collection2 = collection;
        Map map2 = map;
        return new CallGraph(map2, collection2){
            final /* synthetic */ Map val$callSiteToTargets;
            final /* synthetic */ Collection val$roots;

            public final Collection getTargetMethods(Object object, ProgramLocation programLocation) {
                jq_Method jq_Method2 = programLocation.getTargetMethod();
                if (programLocation.isSingleTarget()) {
                    return Collections.singleton(jq_Method2);
                }
                Collection collection = (Collection)this.val$callSiteToTargets.get(programLocation);
                if (collection != null) {
                    return collection;
                }
                return Collections.EMPTY_SET;
            }

            public final void setRoots(Collection collection) {
                Assert._assert(this.val$roots.equals(collection));
            }

            public final Collection getRoots() {
                return this.val$roots;
            }

            public final Collection getAllCallSites() {
                return this.val$callSiteToTargets.keySet();
            }

            public final Collection getAllMethods() {
                LinkedHashSet<E> linkedHashSet = new LinkedHashSet<E>();
                linkedHashSet.addAll(this.val$roots);
                Iterator<V> iterator = this.val$callSiteToTargets.values().iterator();
                while (iterator.hasNext()) {
                    Collection collection = (Collection)iterator.next();
                    linkedHashSet.addAll(collection);
                }
                return linkedHashSet;
            }
            {
                this.val$callSiteToTargets = map;
                this.val$roots = collection;
            }
        };
    }

    public static class CallSiteMap
    extends UnmodifiableMultiMap {
        public static final CallSiteMap INSTANCE = new CallSiteMap();
        private final Set methods;

        public Set entrySet() {
            if (this.methods == null) {
                throw new UnsupportedOperationException();
            }
            return this.entrySetHelper(this.methods);
        }

        public Collection getValues(Object object) {
            jq_Method jq_Method2 = (jq_Method)object;
            return CallGraph.getCallSites0(jq_Method2);
        }

        public boolean contains(Object object, Object object2) {
            ProgramLocation programLocation = (ProgramLocation)object2;
            if (this.methods != null && !this.methods.contains(object)) {
                return false;
            }
            boolean bl = false;
            if (programLocation.getMethod() == object) {
                bl = true;
            }
            return bl;
        }

        public CallSiteMap(Set set) {
            boolean bl = false;
            if (set != null) {
                bl = true;
            }
            Assert._assert(bl);
            this.methods = set;
        }

        private CallSiteMap() {
            this.methods = null;
        }
    }

    public class CallTargetMap
    extends UnmodifiableMultiMap {
        private final Set callSites;

        public Set entrySet() {
            if (this.callSites == null) {
                throw new UnsupportedOperationException();
            }
            return this.entrySetHelper(this.callSites);
        }

        public Collection getValues(Object object) {
            ProgramLocation programLocation = (ProgramLocation)object;
            return CallGraph.this.getTargetMethods(programLocation);
        }

        public boolean contains(Object object, Object object2) {
            return this.getValues(object).contains(object2);
        }

        public CallTargetMap(Set set) {
            this.callSites = set;
        }

        public CallTargetMap() {
            this.callSites = null;
        }
    }

    public static class CallGraphMap
    extends UnmodifiableMultiMap {
        private final MultiMap methodToCallSite;
        private final MultiMap callSiteToTarget;

        public Set entrySet() {
            return this.entrySetHelper(this.methodToCallSite.keySet());
        }

        public Collection getValues(Object object) {
            Collection collection = this.methodToCallSite.getValues(object);
            Iterator iterator = collection.iterator();
            if (!iterator.hasNext()) {
                return collection;
            }
            Object e = iterator.next();
            if (!iterator.hasNext()) {
                return this.callSiteToTarget.getValues(e);
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            while (true) {
                linkedHashSet.addAll(this.callSiteToTarget.getValues(e));
                if (!iterator.hasNext()) break;
                e = iterator.next();
            }
            return linkedHashSet;
        }

        public boolean contains(Object object, Object object2) {
            return this.getValues(object).contains(object2);
        }

        public CallGraphMap(MultiMap multiMap, MultiMap multiMap2) {
            this.methodToCallSite = multiMap;
            this.callSiteToTarget = multiMap2;
        }
    }

    public class CallGraphMethodNavigator
    implements Navigator {
        public Collection next(Object object) {
            jq_Method jq_Method2 = (jq_Method)object;
            Collection collection = CallGraph.this.getCallees(jq_Method2);
            return collection;
        }

        public Collection prev(Object object) {
            jq_Method jq_Method2 = (jq_Method)object;
            Collection collection = CallGraph.this.getCallerMethods(jq_Method2);
            return collection;
        }
    }

    public class CallGraphCSNavigator
    implements Navigator {
        public Collection next(Object object) {
            if (object instanceof jq_Method) {
                return CallGraph.this.getCallSites((jq_Method)object);
            }
            return CallGraph.this.getTargetMethods((ProgramLocation)object);
        }

        public Collection prev(Object object) {
            if (object instanceof jq_Method) {
                return CallGraph.this.getCallers((jq_Method)object);
            }
            return Collections.singleton(((ProgramLocation)object).getMethod());
        }
    }
}

