/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Method;
import Compil3r.Analysis.IPA.ProgramLocation;
import Compil3r.Quad.CallGraph;
import Compil3r.Quad.ControlFlowGraph;
import Util.Collections.GenericInvertibleMultiMap;
import Util.Collections.GenericMultiMap;
import Util.Collections.InvertibleMultiMap;
import Util.Collections.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class CachedCallGraph
extends CallGraph {
    private final CallGraph delegate;
    private Set methods;
    private MultiMap callSites;
    private InvertibleMultiMap edges;

    public void invalidateCache() {
        Collection collection;
        Object object;
        ProgramLocation programLocation;
        this.edges = new GenericInvertibleMultiMap();
        this.callSites = new GenericMultiMap();
        Iterator<Object> iterator = this.delegate.getAllCallSites().iterator();
        while (iterator.hasNext()) {
            programLocation = (ProgramLocation)iterator.next();
            object = this.edges.getValues(programLocation);
            collection = this.delegate.getTargetMethods(programLocation);
            if (!collection.isEmpty()) {
                object.addAll(collection);
                continue;
            }
            this.callSites.add(programLocation.getMethod(), programLocation);
        }
        this.methods = new HashSet(this.delegate.getRoots());
        iterator = this.edges.keySet().iterator();
        while (iterator.hasNext()) {
            programLocation = (ProgramLocation)iterator.next();
            object = programLocation.getMethod();
            this.methods.add(object);
            this.methods.addAll(this.edges.getValues(programLocation));
            collection = this.callSites.getValues(object);
            collection.add(programLocation);
        }
    }

    public void setRoots(Collection collection) {
        this.delegate.setRoots(collection);
        this.invalidateCache();
    }

    public Set entrySet() {
        if (this.edges == null) {
            this.invalidateCache();
        }
        return this.edges.entrySet();
    }

    public Collection getAllCallSites() {
        if (this.edges == null) {
            this.invalidateCache();
        }
        return this.edges.keySet();
    }

    public Collection getAllMethods() {
        if (this.edges == null) {
            this.invalidateCache();
        }
        return this.methods;
    }

    public Collection getCallees(ControlFlowGraph controlFlowGraph) {
        return this.getCallees(controlFlowGraph.getMethod());
    }

    public Collection getCallees(jq_Method jq_Method2) {
        if (this.edges == null) {
            this.invalidateCache();
        }
        return CachedCallGraph.getFromMultiMap(this.callSites, this.edges, jq_Method2);
    }

    public static Collection getFromMultiMap(MultiMap multiMap, MultiMap multiMap2, jq_Method jq_Method2) {
        Collection collection = multiMap.getValues(jq_Method2);
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return Collections.EMPTY_SET;
        }
        Object e = iterator.next();
        if (!iterator.hasNext()) {
            return multiMap2.getValues(e);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        while (true) {
            linkedHashSet.addAll(multiMap2.getValues(e));
            if (!iterator.hasNext()) break;
            e = iterator.next();
        }
        return linkedHashSet;
    }

    public Collection getCallers(jq_Method jq_Method2) {
        if (this.edges == null) {
            this.invalidateCache();
        }
        MultiMap multiMap = this.edges.invert();
        Collection collection = multiMap.getValues(jq_Method2);
        return collection;
    }

    public Collection getCallerMethods(jq_Method jq_Method2) {
        MultiMap multiMap;
        Collection collection;
        Iterator iterator;
        if (this.edges == null) {
            this.invalidateCache();
        }
        if (!(iterator = (collection = (multiMap = this.edges.invert()).getValues(jq_Method2)).iterator()).hasNext()) {
            return Collections.EMPTY_SET;
        }
        ProgramLocation programLocation = (ProgramLocation)iterator.next();
        if (!iterator.hasNext()) {
            return Collections.singleton(programLocation.getMethod());
        }
        LinkedHashSet<jq_Method> linkedHashSet = new LinkedHashSet<jq_Method>();
        while (true) {
            linkedHashSet.add(programLocation.getMethod());
            if (!iterator.hasNext()) break;
            programLocation = (ProgramLocation)iterator.next();
        }
        return linkedHashSet;
    }

    public Collection getCallSites(ControlFlowGraph controlFlowGraph) {
        return this.getCallSites(controlFlowGraph.getMethod());
    }

    public Collection getCallSites(jq_Method jq_Method2) {
        if (this.callSites == null) {
            this.invalidateCache();
        }
        return this.callSites.getValues(jq_Method2);
    }

    public Collection getTargetMethods(Object object, ProgramLocation programLocation) {
        if (this.edges == null) {
            this.invalidateCache();
        }
        return this.edges.getValues(programLocation);
    }

    public void inlineEdge(jq_Method jq_Method2, ProgramLocation programLocation, jq_Method jq_Method3) {
        this.callSites.remove(jq_Method2, programLocation);
        this.callSites.addAll(jq_Method2, this.callSites.getValues(jq_Method3));
    }

    public Set keySet() {
        if (this.edges == null) {
            this.invalidateCache();
        }
        return this.edges.keySet();
    }

    public Collection getRoots() {
        return this.delegate.getRoots();
    }

    public CachedCallGraph(CallGraph callGraph) {
        this.delegate = callGraph;
    }
}

