/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Method;
import Clazz.jq_NameAndDesc;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Clazz.jq_TryCatchBC;
import Clazz.jq_Type;
import Compil3r.BytecodeAnalysis.BytecodeVisitor;
import Compil3r.BytecodeAnalysis.ControlFlowGraph;
import Compil3r.BytecodeAnalysis.ExceptionHandlerIterator;
import Compil3r.CompilationState;
import Compil3r.Quad.B2QUnsafeIgnorer;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ExceptionHandler;
import Compil3r.Quad.ExceptionHandlerList;
import Compil3r.Quad.JSRInfo;
import Compil3r.Quad.Operand;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Compil3r.Quad.RegisterFactory;
import Main.jq;
import Memory.Address;
import Memory.HeapAddress;
import Memory.StackAddress;
import Run_Time.Arrays;
import Run_Time.Reflection;
import UTF.Utf8;
import Util.Assert;
import Util.Strings;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BytecodeToQuad
extends BytecodeVisitor {
    public static boolean ALWAYS_TRACE = false;
    public static final Utf8 peek = Utf8.get("peek");
    public static final Utf8 peek1 = Utf8.get("peek1");
    public static final Utf8 peek2 = Utf8.get("peek2");
    public static final Utf8 peek4 = Utf8.get("peek4");
    public static final Utf8 peek8 = Utf8.get("peek8");
    public static final Utf8 poke = Utf8.get("poke");
    public static final Utf8 poke1 = Utf8.get("poke1");
    public static final Utf8 poke2 = Utf8.get("poke2");
    public static final Utf8 poke4 = Utf8.get("poke4");
    public static final Utf8 poke8 = Utf8.get("poke8");
    public static final Utf8 offset = Utf8.get("offset");
    public static final Utf8 align = Utf8.get("align");
    public static final Utf8 difference = Utf8.get("difference");
    public static final Utf8 isNull = Utf8.get("isNull");
    public static final Utf8 addressOf = Utf8.get("addressOf");
    public static final Utf8 address32 = Utf8.get("address32");
    public static final Utf8 asObject = Utf8.get("asObject");
    public static final Utf8 asReferenceType = Utf8.get("asReferenceType");
    public static final Utf8 to32BitValue = Utf8.get("to32BitValue");
    public static final Utf8 stringRep = Utf8.get("stringRep");
    public static final Utf8 getNull = Utf8.get("getNull");
    public static final Utf8 size = Utf8.get("size");
    public static final Utf8 getBasePointer = Utf8.get("getBasePointer");
    public static final Utf8 getStackPointer = Utf8.get("getStackPointer");
    public static final Utf8 alloca = Utf8.get("alloca");
    public static final Utf8 atomicAdd = Utf8.get("atomicAdd");
    public static final Utf8 atomicSub = Utf8.get("atomicSub");
    public static final Utf8 atomicCas4 = Utf8.get("atomicCas4");
    public static final Utf8 atomicCas8 = Utf8.get("atomicCas8");
    public static final Utf8 atomicAnd = Utf8.get("atomicAnd");
    public static final Utf8 min = Utf8.get("min");
    public static final Utf8 max = Utf8.get("max");
    public static final boolean ELIM_NULL_CHECKS = true;
    private static UnsafeHelper _unsafe = null;
    private ControlFlowGraph quad_cfg;
    private BasicBlock quad_bb;
    private Compil3r.BytecodeAnalysis.ControlFlowGraph bc_cfg;
    private Compil3r.BytecodeAnalysis.BasicBlock bc_bb;
    private BasicBlock[] quad_bbs;
    private RegisterFactory rf;
    private boolean[] visited;
    private boolean uncond_branch;
    private LinkedList regenerate;
    private HashMap quad2bci;
    private boolean endBasicBlock;
    private boolean endsWithRET;
    Operand currentGuard;
    private AbstractState[] start_states;
    private AbstractState current_state;
    Map jsr_states;

    public String toString() {
        return "BC2Q/" + Strings.left(this.method.getName().toString(), 10);
    }

    public ControlFlowGraph convert() {
        int n;
        int n2;
        Object object;
        this.bc_cfg = Compil3r.BytecodeAnalysis.ControlFlowGraph.computeCFG(this.method);
        this.rf = new RegisterFactory(this.method);
        jq_TryCatchBC[] jq_TryCatchBCArray = this.method.getExceptionTable();
        this.quad_cfg = new ControlFlowGraph(this.method, this.bc_cfg.getExit().getNumberOfPredecessors(), jq_TryCatchBCArray.length, this.rf);
        this.quad_bbs = new BasicBlock[this.bc_cfg.getNumberOfBasicBlocks()];
        this.quad_bbs[0] = this.quad_cfg.entry();
        this.quad_bbs[1] = this.quad_cfg.exit();
        int n3 = 2;
        while (n3 < this.quad_bbs.length) {
            object = this.bc_cfg.getBasicBlock(n3);
            int n4 = ((Compil3r.BytecodeAnalysis.BasicBlock)object).getNumberOfPredecessors();
            n2 = ((Compil3r.BytecodeAnalysis.BasicBlock)object).getNumberOfSuccessors();
            n = ((Compil3r.BytecodeAnalysis.BasicBlock)object).getEnd() - ((Compil3r.BytecodeAnalysis.BasicBlock)object).getStart() + 1;
            this.quad_bbs[n3] = BasicBlock.createBasicBlock(n3, n4, n2, n);
            ++n3;
        }
        this.quad_cfg.updateBBcounter(this.quad_bbs.length);
        n3 = jq_TryCatchBCArray.length - 1;
        while (n3 >= 0) {
            object = jq_TryCatchBCArray[n3];
            Compil3r.BytecodeAnalysis.BasicBlock basicBlock = this.bc_cfg.getBasicBlockByBytecodeIndex(((jq_TryCatchBC)object).getStartPC());
            boolean bl = false;
            if (basicBlock.getStart() < ((jq_TryCatchBC)object).getEndPC()) {
                bl = true;
            }
            Assert._assert(bl);
            BasicBlock basicBlock2 = this.quad_bbs[this.bc_cfg.getBasicBlockByBytecodeIndex((int)((jq_TryCatchBC)object).getHandlerPC()).id];
            basicBlock2.setExceptionHandlerEntry();
            n = (((jq_TryCatchBC)object).getEndPC() == this.method.getBytecode().length ? this.quad_bbs.length : this.bc_cfg.getBasicBlockByBytecodeIndex((int)((jq_TryCatchBC)object).getEndPC()).id) - basicBlock.id;
            ExceptionHandler exceptionHandler = new ExceptionHandler(((jq_TryCatchBC)object).getExceptionType(), n, basicBlock2);
            this.quad_cfg.addExceptionHandler(exceptionHandler);
            ExceptionHandlerList exceptionHandlerList = new ExceptionHandlerList(exceptionHandler, null);
            BasicBlock basicBlock3 = this.quad_bbs[basicBlock.id];
            basicBlock3.addExceptionHandler_first(exceptionHandlerList);
            while (true) {
                basicBlock = this.bc_cfg.getBasicBlock(basicBlock.id + 1);
                basicBlock3 = this.quad_bbs[basicBlock.id];
                if (basicBlock.getStart() >= ((jq_TryCatchBC)object).getEndPC()) break;
                exceptionHandlerList = basicBlock3.addExceptionHandler(exceptionHandlerList);
            }
            --n3;
        }
        this.start_states = new AbstractState[this.quad_bbs.length];
        n3 = 0;
        while (n3 < this.quad_bbs.length) {
            object = this.bc_cfg.getBasicBlock(n3);
            BasicBlock basicBlock = this.quad_bbs[n3];
            n2 = 0;
            while (n2 < ((Compil3r.BytecodeAnalysis.BasicBlock)object).getNumberOfPredecessors()) {
                basicBlock.addPredecessor(this.quad_bbs[((Compil3r.BytecodeAnalysis.BasicBlock)object).getPredecessor((int)n2).id]);
                ++n2;
            }
            n2 = 0;
            while (n2 < ((Compil3r.BytecodeAnalysis.BasicBlock)object).getNumberOfSuccessors()) {
                basicBlock.addSuccessor(this.quad_bbs[((Compil3r.BytecodeAnalysis.BasicBlock)object).getSuccessor((int)n2).id]);
                ++n2;
            }
            ++n3;
        }
        this.start_states[2] = this.allocateInitialState();
        this.current_state = this.allocateEmptyState();
        this.regenerate = new LinkedList();
        this.visited = new boolean[this.quad_bbs.length];
        ControlFlowGraph.RPOBasicBlockIterator rPOBasicBlockIterator = this.bc_cfg.reversePostOrderIterator();
        object = rPOBasicBlockIterator.nextBB();
        boolean bl = false;
        if (object == this.bc_cfg.getEntry()) {
            bl = true;
        }
        Assert._assert(bl);
        while (rPOBasicBlockIterator.hasNext()) {
            Compil3r.BytecodeAnalysis.BasicBlock basicBlock = rPOBasicBlockIterator.nextBB();
            this.visited[basicBlock.id] = true;
            this.traverseBB(basicBlock);
        }
        while (!this.regenerate.isEmpty()) {
            Compil3r.BytecodeAnalysis.BasicBlock basicBlock = (Compil3r.BytecodeAnalysis.BasicBlock)this.regenerate.removeFirst();
            this.traverseBB(basicBlock);
        }
        return this.quad_cfg;
    }

    public void traverseBB(Compil3r.BytecodeAnalysis.BasicBlock basicBlock) {
        Object object;
        if (this.start_states[basicBlock.id] == null) {
            if (this.TRACE) {
                this.out.println("Basic block " + basicBlock + " is unreachable!");
            }
            return;
        }
        if (basicBlock.getStart() == -1) {
            return;
        }
        if (this.TRACE) {
            this.out.println("Visiting " + basicBlock);
        }
        this.quad_bb = this.quad_bbs[basicBlock.id];
        Object object2 = this.quad_bb.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            Object v = this.quad2bci.remove(object);
            boolean bl = false;
            if (v != null) continue;
            bl = true;
        }
        this.quad_bb.removeAllQuads();
        this.bc_bb = basicBlock;
        this.uncond_branch = false;
        this.current_state.overwriteWith(this.start_states[basicBlock.id]);
        if (this.quad_bb.isExceptionHandlerEntry()) {
            object2 = ((Operand.RegisterOperand)this.current_state.peekStack(0)).getType();
            object = this.getStackRegister((jq_Type)object2, 0);
            this.quad_bb.appendQuad(Operator.Special.create(this.quad_cfg.getNewQuadID(), Operator.Special.GET_EXCEPTION.INSTANCE, object));
        }
        if (this.TRACE) {
            this.current_state.dumpState();
        }
        this.endBasicBlock = false;
        this.endsWithRET = false;
        this.i_end = basicBlock.getStart() - 1;
        while (true) {
            this.i_start = this.i_end + 1;
            if (this.isEndOfBB()) break;
            this.visitBytecode();
        }
        this.saveStackIntoRegisters();
        if (!this.endsWithRET) {
            int n = 0;
            while (n < basicBlock.getNumberOfSuccessors()) {
                this.mergeStateWith(basicBlock.getSuccessor(n));
                ++n;
            }
        }
    }

    private final boolean isEndOfBB() {
        boolean bl = false;
        if (this.i_start > this.bc_bb.getEnd() || this.endBasicBlock) {
            bl = true;
        }
        return bl;
    }

    private final void mergeStateWith(Compil3r.BytecodeAnalysis.BasicBlock basicBlock) {
        if (this.start_states[basicBlock.id] == null) {
            if (this.TRACE) {
                this.out.println("Copying current state to " + basicBlock);
            }
            this.start_states[basicBlock.id] = this.current_state.copy();
        } else {
            if (this.TRACE) {
                this.out.println("Merging current state with " + basicBlock);
            }
            if (this.start_states[basicBlock.id].merge(this.current_state, this.rf)) {
                if (this.TRACE) {
                    this.out.println("in set of " + basicBlock + " changed");
                }
                if (this.visited[basicBlock.id]) {
                    if (this.TRACE) {
                        this.out.println("must regenerate code for " + basicBlock);
                    }
                    if (!this.regenerate.contains(basicBlock)) {
                        this.regenerate.add(basicBlock);
                    }
                }
            }
        }
    }

    private final void mergeStateWith(Compil3r.BytecodeAnalysis.ExceptionHandler exceptionHandler) {
        Compil3r.BytecodeAnalysis.BasicBlock basicBlock = exceptionHandler.getEntry();
        if (this.start_states[basicBlock.id] == null) {
            if (this.TRACE) {
                this.out.println("Copying exception state to " + basicBlock);
            }
            this.start_states[basicBlock.id] = this.current_state.copyExceptionHandler(exceptionHandler.getExceptionType(), this.rf);
        } else {
            if (this.TRACE) {
                this.out.println("Merging exception state with " + basicBlock);
            }
            if (this.start_states[basicBlock.id].mergeExceptionHandler(this.current_state, exceptionHandler.getExceptionType(), this.rf)) {
                if (this.TRACE) {
                    this.out.println("in set of exception handler " + basicBlock + " changed");
                }
                if (this.visited[basicBlock.id]) {
                    if (this.TRACE) {
                        this.out.println("must regenerate code for " + basicBlock);
                    }
                    if (!this.regenerate.contains(basicBlock)) {
                        this.regenerate.add(basicBlock);
                    }
                }
            }
        }
    }

    private final void saveStackIntoRegisters() {
        int n = 0;
        while (n < this.current_state.getStackSize()) {
            block3: {
                Object object;
                Object object2;
                Operand operand;
                block4: {
                    operand = this.current_state.peekStack(n);
                    if (operand instanceof DummyOperand) break block3;
                    if (!(operand instanceof Operand.RegisterOperand)) break block4;
                    object2 = (Operand.RegisterOperand)operand;
                    object = this.rf.getStack(this.current_state.getStackSize() - n - 1, ((Operand.RegisterOperand)object2).getType());
                    if (((Operand.RegisterOperand)object2).getRegister() == object) break block3;
                }
                object2 = BytecodeToQuad.getTypeOf(operand);
                object = this.getStackRegister((jq_Type)object2, n);
                Quad quad = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp((jq_Type)object2), (Operand.RegisterOperand)object, operand);
                this.appendQuad(quad);
                this.current_state.pokeStack(n, ((Operand.RegisterOperand)object).copy());
            }
            ++n;
        }
    }

    private final void replaceLocalsOnStack(int n, jq_Type jq_Type2) {
        int n2 = 0;
        while (n2 < this.current_state.getStackSize()) {
            Operand operand = this.current_state.peekStack(n2);
            if (this.rf.isLocal(operand, n, jq_Type2)) {
                Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)operand;
                Operand.RegisterOperand registerOperand2 = this.getStackRegister(jq_Type2, n2);
                registerOperand2.setFlags(registerOperand.getFlags());
                registerOperand2.scratchObject = registerOperand.scratchObject;
                Quad quad = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp(jq_Type2), registerOperand2, registerOperand);
                this.appendQuad(quad);
                this.current_state.pokeStack(n2, registerOperand2.copy());
            }
            ++n2;
        }
    }

    void appendQuad(Quad quad) {
        if (this.TRACE) {
            this.out.println(quad.toString());
        }
        this.quad_bb.appendQuad(quad);
        this.quad2bci.put(quad, new Integer(this.i_start));
    }

    Map getQuadToBytecodeMap() {
        return this.quad2bci;
    }

    Operand.RegisterOperand getStackRegister(jq_Type jq_Type2, int n) {
        if (this.current_state.getStackSize() - n - 1 < 0) {
            System.out.println("Error in " + this.method + " offset " + this.i_start);
            this.current_state.dumpState();
        }
        return new Operand.RegisterOperand(this.rf.getStack(this.current_state.getStackSize() - n - 1, jq_Type2), jq_Type2);
    }

    Operand.RegisterOperand getStackRegister(jq_Type jq_Type2) {
        return this.getStackRegister(jq_Type2, -1);
    }

    Operand.RegisterOperand makeLocal(int n, jq_Type jq_Type2) {
        return new Operand.RegisterOperand(this.rf.getLocal(n, jq_Type2), jq_Type2);
    }

    Operand.RegisterOperand makeLocal(int n, Operand.RegisterOperand registerOperand) {
        jq_Type jq_Type2 = registerOperand.getType();
        return new Operand.RegisterOperand(this.rf.getLocal(n, jq_Type2), jq_Type2, registerOperand.getFlags());
    }

    static boolean hasGuard(Operand.RegisterOperand registerOperand) {
        boolean bl = false;
        if (registerOperand.scratchObject != null) {
            bl = true;
        }
        return bl;
    }

    static void setGuard(Operand.RegisterOperand registerOperand, Operand operand) {
        registerOperand.scratchObject = operand;
    }

    static Operand getGuard(Operand operand) {
        if (operand instanceof Operand.RegisterOperand) {
            Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)operand;
            return (Operand)registerOperand.scratchObject;
        }
        Assert._assert(operand instanceof Operand.AConstOperand);
        return new Operand.UnnecessaryGuardOperand();
    }

    void setCurrentGuard(Operand operand) {
        this.currentGuard = operand;
    }

    void clearCurrentGuard() {
        this.currentGuard = null;
    }

    Operand getCurrentGuard() {
        if (this.currentGuard == null) {
            return null;
        }
        return this.currentGuard.copy();
    }

    public void visitNOP() {
        super.visitNOP();
    }

    public void visitACONST(Object object) {
        super.visitACONST(object);
        this.current_state.push_A(new Operand.AConstOperand(object));
    }

    public void visitICONST(int n) {
        super.visitICONST(n);
        this.current_state.push_I(new Operand.IConstOperand(n));
    }

    public void visitLCONST(long l) {
        super.visitLCONST(l);
        this.current_state.push_L(new Operand.LConstOperand(l));
    }

    public void visitFCONST(float f) {
        super.visitFCONST(f);
        this.current_state.push_F(new Operand.FConstOperand(f));
    }

    public void visitDCONST(double d) {
        super.visitDCONST(d);
        this.current_state.push_D(new Operand.DConstOperand(d));
    }

    public void visitILOAD(int n) {
        super.visitILOAD(n);
        this.current_state.push_I(this.current_state.getLocal_I(n));
    }

    public void visitLLOAD(int n) {
        super.visitLLOAD(n);
        this.current_state.push_L(this.current_state.getLocal_L(n));
    }

    public void visitFLOAD(int n) {
        super.visitFLOAD(n);
        this.current_state.push_F(this.current_state.getLocal_F(n));
    }

    public void visitDLOAD(int n) {
        super.visitDLOAD(n);
        this.current_state.push_D(this.current_state.getLocal_D(n));
    }

    public void visitALOAD(int n) {
        super.visitALOAD(n);
        this.current_state.push(this.current_state.getLocal(n));
    }

    private final void STOREhelper(int n, jq_Type jq_Type2) {
        Operand operand;
        Operand.RegisterOperand registerOperand;
        this.replaceLocalsOnStack(n, jq_Type2);
        Operand operand2 = this.current_state.pop(jq_Type2);
        if (operand2 instanceof Operand.RegisterOperand) {
            registerOperand = this.makeLocal(n, (Operand.RegisterOperand)operand2);
            operand = registerOperand;
        } else {
            operand = operand2;
            registerOperand = this.makeLocal(n, jq_Type2);
        }
        if (jq_Type2.getReferenceSize() == 8) {
            this.current_state.setLocalDual(n, operand);
        } else {
            this.current_state.setLocal(n, operand);
        }
        Quad quad = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp(jq_Type2), registerOperand, operand2);
        this.appendQuad(quad);
    }

    public void visitISTORE(int n) {
        super.visitISTORE(n);
        this.STOREhelper(n, jq_Primitive.INT);
    }

    public void visitLSTORE(int n) {
        super.visitLSTORE(n);
        this.STOREhelper(n, jq_Primitive.LONG);
    }

    public void visitFSTORE(int n) {
        super.visitFSTORE(n);
        this.STOREhelper(n, jq_Primitive.FLOAT);
    }

    public void visitDSTORE(int n) {
        super.visitDSTORE(n);
        this.STOREhelper(n, jq_Primitive.DOUBLE);
    }

    public void visitASTORE(int n) {
        super.visitASTORE(n);
        Operand operand = this.current_state.peekStack(0);
        this.STOREhelper(n, BytecodeToQuad.getTypeOf(operand));
    }

    private final void ALOADhelper(Operator.ALoad aLoad, jq_Type jq_Type2) {
        Operand operand = this.current_state.pop_I();
        Operand operand2 = this.current_state.pop_A();
        this.clearCurrentGuard();
        if (this.performNullCheck(operand2)) {
            if (this.TRACE) {
                System.out.println("Null check triggered on " + operand2);
            }
            return;
        }
        if (this.performBoundsCheck(operand2, operand)) {
            if (this.TRACE) {
                System.out.println("Bounds check triggered on " + operand2 + ' ' + operand);
            }
            return;
        }
        if (jq_Type2.isReferenceType()) {
            jq_Type2 = BytecodeToQuad.getArrayElementTypeOf(operand2);
            Assert._assert(jq_Type2.isAddressType() ^ true);
        }
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Type2);
        Quad quad = Operator.ALoad.create(this.quad_cfg.getNewQuadID(), aLoad, registerOperand, operand2, operand, this.getCurrentGuard());
        this.appendQuad(quad);
        this.current_state.push(registerOperand.copy(), jq_Type2);
    }

    public void visitIALOAD() {
        super.visitIALOAD();
        this.ALOADhelper(Operator.ALoad.ALOAD_I.INSTANCE, jq_Primitive.INT);
    }

    public void visitLALOAD() {
        super.visitLALOAD();
        this.ALOADhelper(Operator.ALoad.ALOAD_L.INSTANCE, jq_Primitive.LONG);
    }

    public void visitFALOAD() {
        super.visitFALOAD();
        this.ALOADhelper(Operator.ALoad.ALOAD_F.INSTANCE, jq_Primitive.FLOAT);
    }

    public void visitDALOAD() {
        super.visitDALOAD();
        this.ALOADhelper(Operator.ALoad.ALOAD_D.INSTANCE, jq_Primitive.DOUBLE);
    }

    public void visitAALOAD() {
        super.visitAALOAD();
        Operand operand = this.current_state.pop_I();
        Operand operand2 = this.current_state.pop_A();
        this.clearCurrentGuard();
        if (this.performNullCheck(operand2)) {
            if (this.TRACE) {
                System.out.println("Null check triggered on " + operand2);
            }
            return;
        }
        if (this.performBoundsCheck(operand2, operand)) {
            if (this.TRACE) {
                System.out.println("Bounds check triggered on " + operand2 + ' ' + operand);
            }
            return;
        }
        jq_Type jq_Type2 = BytecodeToQuad.getArrayElementTypeOf(operand2);
        Operator.ALoad aLoad = jq_Type2.isAddressType() ? Operator.ALoad.ALOAD_P.INSTANCE : Operator.ALoad.ALOAD_A.INSTANCE;
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Type2);
        Quad quad = Operator.ALoad.create(this.quad_cfg.getNewQuadID(), aLoad, registerOperand, operand2, operand, this.getCurrentGuard());
        this.appendQuad(quad);
        this.current_state.push(registerOperand.copy(), jq_Type2);
    }

    public void visitBALOAD() {
        super.visitBALOAD();
        this.ALOADhelper(Operator.ALoad.ALOAD_B.INSTANCE, jq_Primitive.BYTE);
    }

    public void visitCALOAD() {
        super.visitCALOAD();
        this.ALOADhelper(Operator.ALoad.ALOAD_C.INSTANCE, jq_Primitive.CHAR);
    }

    public void visitSALOAD() {
        super.visitSALOAD();
        this.ALOADhelper(Operator.ALoad.ALOAD_S.INSTANCE, jq_Primitive.SHORT);
    }

    private final void ASTOREhelper(Operator.AStore aStore, jq_Type jq_Type2) {
        Operand operand = this.current_state.pop(jq_Type2);
        Operand operand2 = this.current_state.pop_I();
        Operand operand3 = this.current_state.pop_A();
        this.clearCurrentGuard();
        if (this.performNullCheck(operand3)) {
            if (this.TRACE) {
                System.out.println("Null check triggered on " + operand3);
            }
            return;
        }
        if (this.performBoundsCheck(operand3, operand2)) {
            if (this.TRACE) {
                System.out.println("Bounds check triggered on " + operand3 + ' ' + operand2);
            }
            return;
        }
        if (jq_Type2.isReferenceType() && operand3 instanceof Operand.RegisterOperand) {
            if (this.performCheckStore((Operand.RegisterOperand)operand3, operand)) {
                return;
            }
            Assert._assert(jq_Type2.isAddressType() ^ true);
        }
        Quad quad = Operator.AStore.create(this.quad_cfg.getNewQuadID(), aStore, operand, operand3, operand2, this.getCurrentGuard());
        this.appendQuad(quad);
    }

    public void visitIASTORE() {
        super.visitIASTORE();
        this.ASTOREhelper(Operator.AStore.ASTORE_I.INSTANCE, jq_Primitive.INT);
    }

    public void visitLASTORE() {
        super.visitLASTORE();
        this.ASTOREhelper(Operator.AStore.ASTORE_L.INSTANCE, jq_Primitive.LONG);
    }

    public void visitFASTORE() {
        super.visitFASTORE();
        this.ASTOREhelper(Operator.AStore.ASTORE_F.INSTANCE, jq_Primitive.FLOAT);
    }

    public void visitDASTORE() {
        super.visitDASTORE();
        this.ASTOREhelper(Operator.AStore.ASTORE_D.INSTANCE, jq_Primitive.DOUBLE);
    }

    public void visitAASTORE() {
        Operator.AStore aStore;
        Operand operand = this.current_state.pop();
        Operand operand2 = this.current_state.pop_I();
        Operand operand3 = this.current_state.pop_A();
        this.clearCurrentGuard();
        if (this.performNullCheck(operand3)) {
            if (this.TRACE) {
                System.out.println("Null check triggered on " + operand3);
            }
            return;
        }
        if (this.performBoundsCheck(operand3, operand2)) {
            if (this.TRACE) {
                System.out.println("Bounds check triggered on " + operand3 + ' ' + operand2);
            }
            return;
        }
        jq_Type jq_Type2 = BytecodeToQuad.getArrayElementTypeOf(operand3);
        Operator.AStore aStore2 = aStore = jq_Type2.isAddressType() ? Operator.AStore.ASTORE_P.INSTANCE : Operator.AStore.ASTORE_A.INSTANCE;
        if (operand3 instanceof Operand.RegisterOperand && this.performCheckStore((Operand.RegisterOperand)operand3, operand)) {
            return;
        }
        Quad quad = Operator.AStore.create(this.quad_cfg.getNewQuadID(), aStore, operand, operand3, operand2, this.getCurrentGuard());
        this.appendQuad(quad);
    }

    public void visitBASTORE() {
        super.visitBASTORE();
        this.ASTOREhelper(Operator.AStore.ASTORE_B.INSTANCE, jq_Primitive.BYTE);
    }

    public void visitCASTORE() {
        super.visitCASTORE();
        this.ASTOREhelper(Operator.AStore.ASTORE_C.INSTANCE, jq_Primitive.CHAR);
    }

    public void visitSASTORE() {
        super.visitSASTORE();
        this.ASTOREhelper(Operator.AStore.ASTORE_S.INSTANCE, jq_Primitive.SHORT);
    }

    public void visitPOP() {
        super.visitPOP();
        this.current_state.pop();
    }

    public void visitPOP2() {
        super.visitPOP2();
        this.current_state.pop();
        this.current_state.pop();
    }

    public void visitDUP() {
        super.visitDUP();
        Operand operand = this.current_state.pop();
        int n = this.current_state.getStackSize();
        jq_Type jq_Type2 = BytecodeToQuad.getTypeOf(operand);
        Operand.RegisterOperand registerOperand = new Operand.RegisterOperand(this.rf.getNewStack(n + 1, jq_Type2), jq_Type2);
        Quad quad = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp(jq_Type2), registerOperand, operand);
        this.appendQuad(quad);
        this.current_state.push(operand.copy(), jq_Type2);
        this.current_state.push(registerOperand.copy(), jq_Type2);
    }

    private final void do_DUP_x1() {
        Operand operand = this.current_state.pop();
        Operand operand2 = this.current_state.pop();
        int n = this.current_state.getStackSize();
        jq_Type jq_Type2 = BytecodeToQuad.getTypeOf(operand);
        jq_Type jq_Type3 = BytecodeToQuad.getTypeOf(operand2);
        Operand.RegisterOperand registerOperand = new Operand.RegisterOperand(this.rf.getNewStack(n + 2, jq_Type2), jq_Type2);
        Quad quad = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp(jq_Type2), registerOperand, operand);
        this.appendQuad(quad);
        Operand.RegisterOperand registerOperand2 = new Operand.RegisterOperand(this.rf.getNewStack(n + 1, jq_Type3), jq_Type3);
        Quad quad2 = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp(jq_Type3), registerOperand2, operand2);
        this.appendQuad(quad2);
        Operand.RegisterOperand registerOperand3 = new Operand.RegisterOperand(this.rf.getNewStack(n, jq_Type2), jq_Type2);
        Quad quad3 = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp(jq_Type2), registerOperand3, registerOperand.copy());
        this.appendQuad(quad3);
        this.current_state.push(registerOperand3.copy(), jq_Type2);
        this.current_state.push(registerOperand2.copy(), jq_Type3);
        this.current_state.push(registerOperand.copy(), jq_Type2);
    }

    public void visitDUP_x1() {
        super.visitDUP_x1();
        this.do_DUP_x1();
    }

    public void visitDUP_x2() {
        Object object;
        super.visitDUP_x2();
        Operand operand = this.current_state.pop();
        Operand operand2 = this.current_state.pop();
        Operand operand3 = this.current_state.pop();
        int n = this.current_state.getStackSize();
        jq_Type jq_Type2 = BytecodeToQuad.getTypeOf(operand);
        Operand.RegisterOperand registerOperand = new Operand.RegisterOperand(this.rf.getNewStack(n + 3, jq_Type2), jq_Type2);
        Quad quad = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp(jq_Type2), registerOperand, operand);
        this.appendQuad(quad);
        Operand.RegisterOperand registerOperand2 = null;
        jq_Type jq_Type3 = null;
        if (operand2 != DummyOperand.DUMMY) {
            jq_Type3 = BytecodeToQuad.getTypeOf(operand2);
            registerOperand2 = new Operand.RegisterOperand(this.rf.getNewStack(n + 2, jq_Type3), jq_Type3);
            object = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp(jq_Type3), registerOperand2, operand2);
            this.appendQuad((Quad)object);
        }
        object = BytecodeToQuad.getTypeOf(operand3);
        Operand.RegisterOperand registerOperand3 = new Operand.RegisterOperand(this.rf.getNewStack(n + 1, (jq_Type)object), (jq_Type)object);
        Quad quad2 = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp((jq_Type)object), registerOperand3, operand3);
        this.appendQuad(quad2);
        Operand.RegisterOperand registerOperand4 = new Operand.RegisterOperand(this.rf.getNewStack(n, jq_Type2), jq_Type2);
        Quad quad3 = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp(jq_Type2), registerOperand4, registerOperand.copy());
        this.appendQuad(quad3);
        this.current_state.push(registerOperand4.copy(), jq_Type2);
        this.current_state.push(registerOperand3.copy(), (jq_Type)object);
        if (operand2 != DummyOperand.DUMMY) {
            this.current_state.push(registerOperand2.copy(), jq_Type3);
        }
        this.current_state.push(registerOperand.copy(), jq_Type2);
    }

    public void visitDUP2() {
        Object object;
        super.visitDUP2();
        Operand operand = this.current_state.pop();
        Operand operand2 = this.current_state.pop();
        int n = this.current_state.getStackSize();
        Operand.RegisterOperand registerOperand = null;
        jq_Type jq_Type2 = null;
        if (operand != DummyOperand.DUMMY) {
            jq_Type2 = BytecodeToQuad.getTypeOf(operand);
            registerOperand = new Operand.RegisterOperand(this.rf.getNewStack(n + 3, jq_Type2), jq_Type2);
            object = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp(jq_Type2), registerOperand, operand);
            this.appendQuad((Quad)object);
        }
        object = BytecodeToQuad.getTypeOf(operand2);
        Operand.RegisterOperand registerOperand2 = new Operand.RegisterOperand(this.rf.getNewStack(n + 2, (jq_Type)object), (jq_Type)object);
        Quad quad = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp((jq_Type)object), registerOperand2, operand2);
        this.appendQuad(quad);
        this.current_state.push(registerOperand2.copy(), (jq_Type)object);
        if (operand != DummyOperand.DUMMY) {
            this.current_state.push(registerOperand.copy(), jq_Type2);
        }
        this.current_state.push(operand2.copy(), (jq_Type)object);
        if (operand != DummyOperand.DUMMY) {
            this.current_state.push(operand.copy(), jq_Type2);
        }
    }

    public void visitDUP2_x1() {
        super.visitDUP2_x1();
        Operand operand = this.current_state.pop();
        Operand operand2 = this.current_state.pop();
        Operand operand3 = this.current_state.pop();
        this.current_state.push(operand2);
        this.current_state.push(operand);
        this.current_state.push(operand3);
        this.current_state.push(operand2.copy());
        this.current_state.push(operand.copy());
    }

    public void visitDUP2_x2() {
        super.visitDUP2_x2();
        Operand operand = this.current_state.pop();
        Operand operand2 = this.current_state.pop();
        Operand operand3 = this.current_state.pop();
        Operand operand4 = this.current_state.pop();
        this.current_state.push(operand2);
        this.current_state.push(operand);
        this.current_state.push(operand4);
        this.current_state.push(operand3);
        this.current_state.push(operand2.copy());
        this.current_state.push(operand.copy());
    }

    public void visitSWAP() {
        super.visitSWAP();
        this.do_DUP_x1();
        this.current_state.pop();
    }

    private final void BINOPhelper(Operator.Binary binary, jq_Type jq_Type2, jq_Type jq_Type3, jq_Type jq_Type4, boolean bl) {
        Operand operand = this.current_state.pop(jq_Type4);
        Operand operand2 = this.current_state.pop(jq_Type3);
        if (bl && this.performZeroCheck(operand)) {
            if (this.TRACE) {
                System.out.println("Zero check triggered on " + operand);
            }
            return;
        }
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Type2);
        Quad quad = Operator.Binary.create(this.quad_cfg.getNewQuadID(), binary, registerOperand, operand2, operand);
        this.appendQuad(quad);
        this.current_state.push(registerOperand.copy(), jq_Type2);
    }

    public void visitIBINOP(byte by) {
        super.visitIBINOP(by);
        Operator.Binary binary = null;
        boolean bl = false;
        switch (by) {
            case 0: {
                binary = Operator.Binary.ADD_I.INSTANCE;
                break;
            }
            case 1: {
                binary = Operator.Binary.SUB_I.INSTANCE;
                break;
            }
            case 2: {
                binary = Operator.Binary.MUL_I.INSTANCE;
                break;
            }
            case 3: {
                binary = Operator.Binary.DIV_I.INSTANCE;
                bl = true;
                break;
            }
            case 4: {
                binary = Operator.Binary.REM_I.INSTANCE;
                bl = true;
                break;
            }
            case 5: {
                binary = Operator.Binary.AND_I.INSTANCE;
                break;
            }
            case 6: {
                binary = Operator.Binary.OR_I.INSTANCE;
                break;
            }
            case 7: {
                binary = Operator.Binary.XOR_I.INSTANCE;
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.BINOPhelper(binary, jq_Primitive.INT, jq_Primitive.INT, jq_Primitive.INT, bl);
    }

    public void visitLBINOP(byte by) {
        super.visitLBINOP(by);
        Operator.Binary binary = null;
        boolean bl = false;
        switch (by) {
            case 0: {
                binary = Operator.Binary.ADD_L.INSTANCE;
                break;
            }
            case 1: {
                binary = Operator.Binary.SUB_L.INSTANCE;
                break;
            }
            case 2: {
                binary = Operator.Binary.MUL_L.INSTANCE;
                break;
            }
            case 3: {
                binary = Operator.Binary.DIV_L.INSTANCE;
                bl = true;
                break;
            }
            case 4: {
                binary = Operator.Binary.REM_L.INSTANCE;
                bl = true;
                break;
            }
            case 5: {
                binary = Operator.Binary.AND_L.INSTANCE;
                break;
            }
            case 6: {
                binary = Operator.Binary.OR_L.INSTANCE;
                break;
            }
            case 7: {
                binary = Operator.Binary.XOR_L.INSTANCE;
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.BINOPhelper(binary, jq_Primitive.LONG, jq_Primitive.LONG, jq_Primitive.LONG, bl);
    }

    public void visitFBINOP(byte by) {
        super.visitFBINOP(by);
        Operator.Binary binary = null;
        switch (by) {
            case 0: {
                binary = Operator.Binary.ADD_F.INSTANCE;
                break;
            }
            case 1: {
                binary = Operator.Binary.SUB_F.INSTANCE;
                break;
            }
            case 2: {
                binary = Operator.Binary.MUL_F.INSTANCE;
                break;
            }
            case 3: {
                binary = Operator.Binary.DIV_F.INSTANCE;
                break;
            }
            case 4: {
                binary = Operator.Binary.REM_F.INSTANCE;
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.BINOPhelper(binary, jq_Primitive.FLOAT, jq_Primitive.FLOAT, jq_Primitive.FLOAT, false);
    }

    public void visitDBINOP(byte by) {
        super.visitDBINOP(by);
        Operator.Binary binary = null;
        switch (by) {
            case 0: {
                binary = Operator.Binary.ADD_D.INSTANCE;
                break;
            }
            case 1: {
                binary = Operator.Binary.SUB_D.INSTANCE;
                break;
            }
            case 2: {
                binary = Operator.Binary.MUL_D.INSTANCE;
                break;
            }
            case 3: {
                binary = Operator.Binary.DIV_D.INSTANCE;
                break;
            }
            case 4: {
                binary = Operator.Binary.REM_D.INSTANCE;
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.BINOPhelper(binary, jq_Primitive.DOUBLE, jq_Primitive.DOUBLE, jq_Primitive.DOUBLE, false);
    }

    public void UNOPhelper(Operator.Unary unary, jq_Type jq_Type2, jq_Type jq_Type3) {
        Operand operand = this.current_state.pop(jq_Type3);
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Type2);
        Quad quad = Operator.Unary.create(this.quad_cfg.getNewQuadID(), unary, registerOperand, operand);
        this.appendQuad(quad);
        this.current_state.push(registerOperand.copy(), jq_Type2);
    }

    public void visitIUNOP(byte by) {
        super.visitIUNOP(by);
        Operator.Unary.NEG_I nEG_I = null;
        switch (by) {
            case 0: {
                nEG_I = Operator.Unary.NEG_I.INSTANCE;
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.UNOPhelper(nEG_I, jq_Primitive.INT, jq_Primitive.INT);
    }

    public void visitLUNOP(byte by) {
        super.visitLUNOP(by);
        Operator.Unary.NEG_L nEG_L = null;
        switch (by) {
            case 0: {
                nEG_L = Operator.Unary.NEG_L.INSTANCE;
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.UNOPhelper(nEG_L, jq_Primitive.LONG, jq_Primitive.LONG);
    }

    public void visitFUNOP(byte by) {
        super.visitFUNOP(by);
        Operator.Unary.NEG_F nEG_F = null;
        switch (by) {
            case 0: {
                nEG_F = Operator.Unary.NEG_F.INSTANCE;
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.UNOPhelper(nEG_F, jq_Primitive.FLOAT, jq_Primitive.FLOAT);
    }

    public void visitDUNOP(byte by) {
        super.visitDUNOP(by);
        Operator.Unary.NEG_D nEG_D = null;
        switch (by) {
            case 0: {
                nEG_D = Operator.Unary.NEG_D.INSTANCE;
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.UNOPhelper(nEG_D, jq_Primitive.DOUBLE, jq_Primitive.DOUBLE);
    }

    public void visitISHIFT(byte by) {
        super.visitISHIFT(by);
        Operator.Binary binary = null;
        switch (by) {
            case 0: {
                binary = Operator.Binary.SHL_I.INSTANCE;
                break;
            }
            case 1: {
                binary = Operator.Binary.SHR_I.INSTANCE;
                break;
            }
            case 2: {
                binary = Operator.Binary.USHR_I.INSTANCE;
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.BINOPhelper(binary, jq_Primitive.INT, jq_Primitive.INT, jq_Primitive.INT, false);
    }

    public void visitLSHIFT(byte by) {
        super.visitLSHIFT(by);
        Operator.Binary binary = null;
        switch (by) {
            case 0: {
                binary = Operator.Binary.SHL_L.INSTANCE;
                break;
            }
            case 1: {
                binary = Operator.Binary.SHR_L.INSTANCE;
                break;
            }
            case 2: {
                binary = Operator.Binary.USHR_L.INSTANCE;
                break;
            }
            default: {
                Assert.UNREACHABLE();
            }
        }
        this.BINOPhelper(binary, jq_Primitive.LONG, jq_Primitive.LONG, jq_Primitive.INT, false);
    }

    public void visitIINC(int n, int n2) {
        super.visitIINC(n, n2);
        Operand operand = this.current_state.getLocal_I(n);
        this.replaceLocalsOnStack(n, jq_Primitive.INT);
        Operand.RegisterOperand registerOperand = this.makeLocal(n, jq_Primitive.INT);
        Quad quad = Operator.Binary.create(this.quad_cfg.getNewQuadID(), Operator.Binary.ADD_I.INSTANCE, registerOperand, operand, new Operand.IConstOperand(n2));
        this.appendQuad(quad);
        this.current_state.setLocal(n, registerOperand);
    }

    public void visitI2L() {
        super.visitI2L();
        this.UNOPhelper(Operator.Unary.INT_2LONG.INSTANCE, jq_Primitive.LONG, jq_Primitive.INT);
    }

    public void visitI2F() {
        super.visitI2F();
        this.UNOPhelper(Operator.Unary.INT_2FLOAT.INSTANCE, jq_Primitive.FLOAT, jq_Primitive.INT);
    }

    public void visitI2D() {
        super.visitI2D();
        this.UNOPhelper(Operator.Unary.INT_2DOUBLE.INSTANCE, jq_Primitive.DOUBLE, jq_Primitive.INT);
    }

    public void visitL2I() {
        super.visitL2I();
        this.UNOPhelper(Operator.Unary.LONG_2INT.INSTANCE, jq_Primitive.INT, jq_Primitive.LONG);
    }

    public void visitL2F() {
        super.visitL2F();
        this.UNOPhelper(Operator.Unary.LONG_2FLOAT.INSTANCE, jq_Primitive.FLOAT, jq_Primitive.LONG);
    }

    public void visitL2D() {
        super.visitL2D();
        this.UNOPhelper(Operator.Unary.LONG_2DOUBLE.INSTANCE, jq_Primitive.DOUBLE, jq_Primitive.LONG);
    }

    public void visitF2I() {
        super.visitF2I();
        this.UNOPhelper(Operator.Unary.FLOAT_2INT.INSTANCE, jq_Primitive.INT, jq_Primitive.FLOAT);
    }

    public void visitF2L() {
        super.visitF2L();
        this.UNOPhelper(Operator.Unary.FLOAT_2LONG.INSTANCE, jq_Primitive.LONG, jq_Primitive.FLOAT);
    }

    public void visitF2D() {
        super.visitF2D();
        this.UNOPhelper(Operator.Unary.FLOAT_2DOUBLE.INSTANCE, jq_Primitive.DOUBLE, jq_Primitive.FLOAT);
    }

    public void visitD2I() {
        super.visitD2I();
        this.UNOPhelper(Operator.Unary.DOUBLE_2INT.INSTANCE, jq_Primitive.INT, jq_Primitive.DOUBLE);
    }

    public void visitD2L() {
        super.visitD2L();
        this.UNOPhelper(Operator.Unary.DOUBLE_2LONG.INSTANCE, jq_Primitive.LONG, jq_Primitive.DOUBLE);
    }

    public void visitD2F() {
        super.visitD2F();
        this.UNOPhelper(Operator.Unary.DOUBLE_2FLOAT.INSTANCE, jq_Primitive.FLOAT, jq_Primitive.DOUBLE);
    }

    public void visitI2B() {
        super.visitI2B();
        this.UNOPhelper(Operator.Unary.INT_2BYTE.INSTANCE, jq_Primitive.BYTE, jq_Primitive.INT);
    }

    public void visitI2C() {
        super.visitI2C();
        this.UNOPhelper(Operator.Unary.INT_2CHAR.INSTANCE, jq_Primitive.CHAR, jq_Primitive.INT);
    }

    public void visitI2S() {
        super.visitI2S();
        this.UNOPhelper(Operator.Unary.INT_2SHORT.INSTANCE, jq_Primitive.SHORT, jq_Primitive.INT);
    }

    public void visitLCMP2() {
        super.visitLCMP2();
        this.BINOPhelper(Operator.Binary.CMP_L.INSTANCE, jq_Primitive.INT, jq_Primitive.LONG, jq_Primitive.LONG, false);
    }

    public void visitFCMP2(byte by) {
        super.visitFCMP2(by);
        Operator.Binary binary = by == 0 ? Operator.Binary.CMP_FL.INSTANCE : Operator.Binary.CMP_FG.INSTANCE;
        this.BINOPhelper(binary, jq_Primitive.INT, jq_Primitive.FLOAT, jq_Primitive.FLOAT, false);
    }

    public void visitDCMP2(byte by) {
        super.visitDCMP2(by);
        Operator.Binary binary = by == 0 ? Operator.Binary.CMP_DL.INSTANCE : Operator.Binary.CMP_DG.INSTANCE;
        this.BINOPhelper(binary, jq_Primitive.INT, jq_Primitive.DOUBLE, jq_Primitive.DOUBLE, false);
    }

    public void visitIF(byte by, int n) {
        super.visitIF(by, n);
        Operand operand = this.current_state.pop_I();
        this.saveStackIntoRegisters();
        BasicBlock basicBlock = this.quad_bbs[this.bc_cfg.getBasicBlockByBytecodeIndex((int)n).id];
        Operand.ConditionOperand conditionOperand = new Operand.ConditionOperand(by);
        Quad quad = Operator.IntIfCmp.create(this.quad_cfg.getNewQuadID(), Operator.IntIfCmp.IFCMP_I.INSTANCE, operand, new Operand.IConstOperand(0), conditionOperand, new Operand.TargetOperand(basicBlock));
        this.appendQuad(quad);
    }

    public void visitIFREF(byte by, int n) {
        super.visitIFREF(by, n);
        Operand operand = this.current_state.pop();
        this.saveStackIntoRegisters();
        BasicBlock basicBlock = this.quad_bbs[this.bc_cfg.getBasicBlockByBytecodeIndex((int)n).id];
        Operand.ConditionOperand conditionOperand = new Operand.ConditionOperand(by);
        jq_Type jq_Type2 = BytecodeToQuad.getTypeOf(operand);
        Operator.IntIfCmp intIfCmp = jq_Type2.isAddressType() ? Operator.IntIfCmp.IFCMP_P.INSTANCE : Operator.IntIfCmp.IFCMP_A.INSTANCE;
        Operand.Const4Operand const4Operand = jq_Type2.isAddressType() ? new Operand.PConstOperand(null) : new Operand.AConstOperand(null);
        Quad quad = Operator.IntIfCmp.create(this.quad_cfg.getNewQuadID(), intIfCmp, operand, const4Operand, conditionOperand, new Operand.TargetOperand(basicBlock));
        this.appendQuad(quad);
    }

    public void visitIFCMP(byte by, int n) {
        super.visitIFCMP(by, n);
        Operand operand = this.current_state.pop_I();
        Operand operand2 = this.current_state.pop_I();
        this.saveStackIntoRegisters();
        BasicBlock basicBlock = this.quad_bbs[this.bc_cfg.getBasicBlockByBytecodeIndex((int)n).id];
        Operand.ConditionOperand conditionOperand = new Operand.ConditionOperand(by);
        Quad quad = Operator.IntIfCmp.create(this.quad_cfg.getNewQuadID(), Operator.IntIfCmp.IFCMP_I.INSTANCE, operand2, operand, conditionOperand, new Operand.TargetOperand(basicBlock));
        this.appendQuad(quad);
    }

    public void visitIFREFCMP(byte by, int n) {
        Operator.IntIfCmp intIfCmp;
        super.visitIFREFCMP(by, n);
        Operand operand = this.current_state.pop();
        Operand operand2 = this.current_state.pop();
        this.saveStackIntoRegisters();
        BasicBlock basicBlock = this.quad_bbs[this.bc_cfg.getBasicBlockByBytecodeIndex((int)n).id];
        Operand.ConditionOperand conditionOperand = new Operand.ConditionOperand(by);
        jq_Type jq_Type2 = BytecodeToQuad.getTypeOf(operand);
        jq_Type jq_Type3 = BytecodeToQuad.getTypeOf(operand2);
        if (jq_Type2.isAddressType()) {
            if (!jq_Type3.isAddressType() && jq_Type3 != jq_Reference.jq_NullType.NULL_TYPE) {
                Assert.UNREACHABLE("comparing address type " + operand + " with non-address type " + operand2);
            }
            intIfCmp = Operator.IntIfCmp.IFCMP_P.INSTANCE;
        } else if (jq_Type3.isAddressType()) {
            if (jq_Type2 != jq_Reference.jq_NullType.NULL_TYPE) {
                Assert.UNREACHABLE("comparing address type " + operand2 + " with non-address type " + operand);
            }
            intIfCmp = Operator.IntIfCmp.IFCMP_P.INSTANCE;
        } else {
            intIfCmp = Operator.IntIfCmp.IFCMP_A.INSTANCE;
        }
        Quad quad = Operator.IntIfCmp.create(this.quad_cfg.getNewQuadID(), intIfCmp, operand2, operand, conditionOperand, new Operand.TargetOperand(basicBlock));
        this.appendQuad(quad);
    }

    public void visitGOTO(int n) {
        super.visitGOTO(n);
        this.uncond_branch = true;
        this.saveStackIntoRegisters();
        BasicBlock basicBlock = this.quad_bbs[this.bc_cfg.getBasicBlockByBytecodeIndex((int)n).id];
        Quad quad = Operator.Goto.create(this.quad_cfg.getNewQuadID(), Operator.Goto.GOTO.INSTANCE, new Operand.TargetOperand(basicBlock));
        this.appendQuad(quad);
    }

    void setJSRState(Compil3r.BytecodeAnalysis.BasicBlock basicBlock, AbstractState abstractState) {
        this.jsr_states.put(basicBlock, abstractState.copyAfterJSR());
    }

    AbstractState getJSRState(Compil3r.BytecodeAnalysis.BasicBlock basicBlock) {
        return (AbstractState)this.jsr_states.get(basicBlock);
    }

    public void visitJSR(int n) {
        super.visitJSR(n);
        this.uncond_branch = true;
        Compil3r.BytecodeAnalysis.BasicBlock basicBlock = this.bc_cfg.getBasicBlockByBytecodeIndex(n);
        BasicBlock basicBlock2 = this.quad_bbs[basicBlock.id];
        BasicBlock basicBlock3 = this.quad_bbs[this.bc_bb.id + 1];
        Compil3r.BytecodeAnalysis.JSRInfo jSRInfo = this.bc_cfg.getJSRInfo(basicBlock);
        if (jSRInfo == null) {
            if (this.TRACE) {
                this.out.println("jsr with no ret! converting to GOTO.");
            }
            this.current_state.push_A(new Operand.AConstOperand(null));
            this.saveStackIntoRegisters();
            Quad quad = Operator.Goto.create(this.quad_cfg.getNewQuadID(), Operator.Goto.GOTO.INSTANCE, new Operand.TargetOperand(basicBlock2));
            this.appendQuad(quad);
            return;
        }
        boolean bl = false;
        if (this.quad_bbs[jSRInfo.entry_block.id] == basicBlock2) {
            bl = true;
        }
        Assert._assert(bl);
        BasicBlock basicBlock4 = this.quad_bbs[jSRInfo.exit_block.id];
        JSRInfo jSRInfo2 = new JSRInfo(basicBlock2, basicBlock4, jSRInfo.changedLocals);
        this.quad_cfg.addJSRInfo(jSRInfo2);
        this.saveStackIntoRegisters();
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_ReturnAddressType.INSTANCE);
        Quad quad = Operator.Jsr.create(this.quad_cfg.getNewQuadID(), Operator.Jsr.JSR.INSTANCE, registerOperand, new Operand.TargetOperand(basicBlock2), new Operand.TargetOperand(basicBlock3));
        this.appendQuad(quad);
        Compil3r.BytecodeAnalysis.BasicBlock basicBlock5 = this.bc_cfg.getBasicBlock(this.bc_bb.id + 1);
        Compil3r.BytecodeAnalysis.BasicBlock basicBlock6 = jSRInfo.exit_block;
        this.setJSRState(basicBlock5, this.current_state);
        if (this.visited[basicBlock6.id]) {
            if (this.TRACE) {
                this.out.println("marking ret bb " + basicBlock6 + " for regeneration.");
            }
            if (!this.regenerate.contains(basicBlock6)) {
                this.regenerate.add(basicBlock6);
            }
        }
        this.current_state.push(registerOperand.copy());
    }

    public void visitRET(int n) {
        super.visitRET(n);
        this.uncond_branch = true;
        this.saveStackIntoRegisters();
        Operand.RegisterOperand registerOperand = this.makeLocal(n, jq_ReturnAddressType.INSTANCE);
        Quad quad = Operator.Ret.create(this.quad_cfg.getNewQuadID(), Operator.Ret.RET.INSTANCE, registerOperand);
        this.appendQuad(quad);
        this.current_state.setLocal(n, null);
        this.endsWithRET = true;
        Compil3r.BytecodeAnalysis.JSRInfo jSRInfo = this.bc_cfg.getJSRInfo(this.bc_bb);
        int n2 = 0;
        while (n2 < this.bc_bb.getNumberOfSuccessors()) {
            Compil3r.BytecodeAnalysis.BasicBlock basicBlock = this.bc_bb.getSuccessor(n2);
            AbstractState abstractState = this.getJSRState(basicBlock);
            if (abstractState == null) {
                if (this.TRACE) {
                    this.out.println("haven't seen jsr call from " + basicBlock + " yet.");
                }
                if (!this.regenerate.contains(basicBlock)) {
                    this.regenerate.add(basicBlock);
                }
            } else {
                abstractState.mergeAfterJSR(jSRInfo.changedLocals, this.current_state);
                if (this.start_states[basicBlock.id] == null) {
                    if (this.TRACE) {
                        this.out.println("Copying jsr state to " + basicBlock);
                    }
                    this.start_states[basicBlock.id] = abstractState.copy();
                    if (this.visited[basicBlock.id]) {
                        if (this.TRACE) {
                            this.out.println("must regenerate code for " + basicBlock);
                        }
                        if (!this.regenerate.contains(basicBlock)) {
                            this.regenerate.add(basicBlock);
                        }
                    }
                } else {
                    if (this.TRACE) {
                        this.out.println("Merging jsr state with " + basicBlock);
                    }
                    if (this.start_states[basicBlock.id].merge(abstractState, this.rf)) {
                        if (this.TRACE) {
                            this.out.println("in set of " + basicBlock + " changed");
                        }
                        if (this.visited[basicBlock.id]) {
                            if (this.TRACE) {
                                this.out.println("must regenerate code for " + basicBlock);
                            }
                            if (!this.regenerate.contains(basicBlock)) {
                                this.regenerate.add(basicBlock);
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public void visitTABLESWITCH(int n, int n2, int n3, int[] nArray) {
        super.visitTABLESWITCH(n, n2, n3, nArray);
        this.uncond_branch = true;
        Operand operand = this.current_state.pop_I();
        this.saveStackIntoRegisters();
        BasicBlock basicBlock = this.quad_bbs[this.bc_cfg.getBasicBlockByBytecodeIndex((int)n).id];
        boolean bl = false;
        if (n3 - n2 + 1 == nArray.length) {
            bl = true;
        }
        Assert._assert(bl);
        Quad quad = Operator.TableSwitch.create(this.quad_cfg.getNewQuadID(), Operator.TableSwitch.TABLESWITCH.INSTANCE, operand, new Operand.IConstOperand(n2), new Operand.TargetOperand(basicBlock), nArray.length);
        int n4 = 0;
        while (n4 < nArray.length) {
            basicBlock = this.quad_bbs[this.bc_cfg.getBasicBlockByBytecodeIndex((int)nArray[n4]).id];
            Operator.TableSwitch.setTarget(quad, n4, basicBlock);
            ++n4;
        }
        this.appendQuad(quad);
    }

    public void visitLOOKUPSWITCH(int n, int[] nArray, int[] nArray2) {
        super.visitLOOKUPSWITCH(n, nArray, nArray2);
        this.uncond_branch = true;
        Operand operand = this.current_state.pop_I();
        this.saveStackIntoRegisters();
        BasicBlock basicBlock = this.quad_bbs[this.bc_cfg.getBasicBlockByBytecodeIndex((int)n).id];
        Quad quad = Operator.LookupSwitch.create(this.quad_cfg.getNewQuadID(), Operator.LookupSwitch.LOOKUPSWITCH.INSTANCE, operand, new Operand.TargetOperand(basicBlock), nArray.length);
        int n2 = 0;
        while (n2 < nArray.length) {
            Operator.LookupSwitch.setMatch(quad, n2, nArray[n2]);
            basicBlock = this.quad_bbs[this.bc_cfg.getBasicBlockByBytecodeIndex((int)nArray2[n2]).id];
            Operator.LookupSwitch.setTarget(quad, n2, basicBlock);
            ++n2;
        }
        this.appendQuad(quad);
    }

    public void visitIRETURN() {
        super.visitIRETURN();
        this.uncond_branch = true;
        Operand operand = this.current_state.pop_I();
        Quad quad = Operator.Return.create(this.quad_cfg.getNewQuadID(), Operator.Return.RETURN_I.INSTANCE, operand);
        this.appendQuad(quad);
        this.current_state.clearStack();
    }

    public void visitLRETURN() {
        super.visitLRETURN();
        this.uncond_branch = true;
        Operand operand = this.current_state.pop_L();
        Quad quad = Operator.Return.create(this.quad_cfg.getNewQuadID(), Operator.Return.RETURN_L.INSTANCE, operand);
        this.appendQuad(quad);
        this.current_state.clearStack();
    }

    public void visitFRETURN() {
        super.visitFRETURN();
        this.uncond_branch = true;
        Operand operand = this.current_state.pop_F();
        Quad quad = Operator.Return.create(this.quad_cfg.getNewQuadID(), Operator.Return.RETURN_F.INSTANCE, operand);
        this.appendQuad(quad);
        this.current_state.clearStack();
    }

    public void visitDRETURN() {
        super.visitDRETURN();
        this.uncond_branch = true;
        Operand operand = this.current_state.pop_D();
        Quad quad = Operator.Return.create(this.quad_cfg.getNewQuadID(), Operator.Return.RETURN_D.INSTANCE, operand);
        this.appendQuad(quad);
        this.current_state.clearStack();
    }

    public void visitARETURN() {
        Operator.Return.RETURN_P rETURN_P;
        super.visitARETURN();
        this.uncond_branch = true;
        Operand operand = this.current_state.pop();
        jq_Type jq_Type2 = BytecodeToQuad.getTypeOf(operand);
        if (this.method.getReturnType().isAddressType()) {
            rETURN_P = Operator.Return.RETURN_P.INSTANCE;
            boolean bl = false;
            if (jq_Type2.isAddressType() || jq_Type2 == jq_Reference.jq_NullType.NULL_TYPE || this.state.isSubtype(jq_Type2, Address._class) != 0) {
                bl = true;
            }
            Assert._assert(bl, jq_Type2.toString());
        } else {
            rETURN_P = jq_Type2.isAddressType() ? Operator.Return.RETURN_P.INSTANCE : Operator.Return.RETURN_A.INSTANCE;
        }
        Quad quad = Operator.Return.create(this.quad_cfg.getNewQuadID(), rETURN_P, operand);
        this.appendQuad(quad);
        this.current_state.clearStack();
    }

    public void visitVRETURN() {
        super.visitVRETURN();
        this.uncond_branch = true;
        Quad quad = Operator.Return.create(this.quad_cfg.getNewQuadID(), Operator.Return.RETURN_V.INSTANCE);
        this.appendQuad(quad);
        this.current_state.clearStack();
    }

    private final void GETSTATIChelper(jq_StaticField jq_StaticField2, Operator.Getstatic getstatic, Operator.Getstatic getstatic2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_StaticField2 = this.tryResolve(jq_StaticField2));
        Operator.Getstatic getstatic3 = bl ? getstatic : getstatic2;
        jq_Type jq_Type2 = jq_StaticField2.getType();
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Type2);
        Quad quad = Operator.Getstatic.create(this.quad_cfg.getNewQuadID(), getstatic3, registerOperand, new Operand.FieldOperand(jq_StaticField2));
        this.appendQuad(quad);
        this.current_state.push(registerOperand.copy(), jq_Type2);
    }

    public void visitIGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitIGETSTATIC(jq_StaticField2);
        this.GETSTATIChelper(jq_StaticField2, Operator.Getstatic.GETSTATIC_I_DYNLINK.INSTANCE, Operator.Getstatic.GETSTATIC_I.INSTANCE);
    }

    public void visitLGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitLGETSTATIC(jq_StaticField2);
        this.GETSTATIChelper(jq_StaticField2, Operator.Getstatic.GETSTATIC_L_DYNLINK.INSTANCE, Operator.Getstatic.GETSTATIC_L.INSTANCE);
    }

    public void visitFGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitFGETSTATIC(jq_StaticField2);
        this.GETSTATIChelper(jq_StaticField2, Operator.Getstatic.GETSTATIC_F_DYNLINK.INSTANCE, Operator.Getstatic.GETSTATIC_F.INSTANCE);
    }

    public void visitDGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitDGETSTATIC(jq_StaticField2);
        this.GETSTATIChelper(jq_StaticField2, Operator.Getstatic.GETSTATIC_D_DYNLINK.INSTANCE, Operator.Getstatic.GETSTATIC_D.INSTANCE);
    }

    public void visitAGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitAGETSTATIC(jq_StaticField2);
        Operator.Getstatic getstatic = jq_StaticField2.getType().isAddressType() ? Operator.Getstatic.GETSTATIC_P_DYNLINK.INSTANCE : Operator.Getstatic.GETSTATIC_A_DYNLINK.INSTANCE;
        Operator.Getstatic getstatic2 = jq_StaticField2.getType().isAddressType() ? Operator.Getstatic.GETSTATIC_P.INSTANCE : Operator.Getstatic.GETSTATIC_A.INSTANCE;
        this.GETSTATIChelper(jq_StaticField2, getstatic, getstatic2);
    }

    public void visitZGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitZGETSTATIC(jq_StaticField2);
        this.GETSTATIChelper(jq_StaticField2, Operator.Getstatic.GETSTATIC_Z_DYNLINK.INSTANCE, Operator.Getstatic.GETSTATIC_Z.INSTANCE);
    }

    public void visitBGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitBGETSTATIC(jq_StaticField2);
        this.GETSTATIChelper(jq_StaticField2, Operator.Getstatic.GETSTATIC_B_DYNLINK.INSTANCE, Operator.Getstatic.GETSTATIC_B.INSTANCE);
    }

    public void visitCGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitCGETSTATIC(jq_StaticField2);
        this.GETSTATIChelper(jq_StaticField2, Operator.Getstatic.GETSTATIC_C_DYNLINK.INSTANCE, Operator.Getstatic.GETSTATIC_C.INSTANCE);
    }

    public void visitSGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitSGETSTATIC(jq_StaticField2);
        this.GETSTATIChelper(jq_StaticField2, Operator.Getstatic.GETSTATIC_S_DYNLINK.INSTANCE, Operator.Getstatic.GETSTATIC_S.INSTANCE);
    }

    private final void PUTSTATIChelper(jq_StaticField jq_StaticField2, Operator.Putstatic putstatic, Operator.Putstatic putstatic2) {
        boolean bl = this.state.needsDynamicLink(this.method, jq_StaticField2 = this.tryResolve(jq_StaticField2));
        Operator.Putstatic putstatic3 = bl ? putstatic : putstatic2;
        jq_Type jq_Type2 = jq_StaticField2.getType();
        Operand operand = this.current_state.pop(jq_Type2);
        Quad quad = Operator.Putstatic.create(this.quad_cfg.getNewQuadID(), putstatic3, operand, new Operand.FieldOperand(jq_StaticField2));
        this.appendQuad(quad);
    }

    public void visitIPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitIPUTSTATIC(jq_StaticField2);
        this.PUTSTATIChelper(jq_StaticField2, Operator.Putstatic.PUTSTATIC_I_DYNLINK.INSTANCE, Operator.Putstatic.PUTSTATIC_I.INSTANCE);
    }

    public void visitLPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitLPUTSTATIC(jq_StaticField2);
        this.PUTSTATIChelper(jq_StaticField2, Operator.Putstatic.PUTSTATIC_L_DYNLINK.INSTANCE, Operator.Putstatic.PUTSTATIC_L.INSTANCE);
    }

    public void visitFPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitFPUTSTATIC(jq_StaticField2);
        this.PUTSTATIChelper(jq_StaticField2, Operator.Putstatic.PUTSTATIC_F_DYNLINK.INSTANCE, Operator.Putstatic.PUTSTATIC_F.INSTANCE);
    }

    public void visitDPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitDPUTSTATIC(jq_StaticField2);
        this.PUTSTATIChelper(jq_StaticField2, Operator.Putstatic.PUTSTATIC_D_DYNLINK.INSTANCE, Operator.Putstatic.PUTSTATIC_D.INSTANCE);
    }

    public void visitAPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitAPUTSTATIC(jq_StaticField2);
        Operator.Putstatic putstatic = jq_StaticField2.getType().isAddressType() ? Operator.Putstatic.PUTSTATIC_P_DYNLINK.INSTANCE : Operator.Putstatic.PUTSTATIC_A_DYNLINK.INSTANCE;
        Operator.Putstatic putstatic2 = jq_StaticField2.getType().isAddressType() ? Operator.Putstatic.PUTSTATIC_P.INSTANCE : Operator.Putstatic.PUTSTATIC_A.INSTANCE;
        this.PUTSTATIChelper(jq_StaticField2, putstatic, putstatic2);
    }

    public void visitZPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitZPUTSTATIC(jq_StaticField2);
        this.PUTSTATIChelper(jq_StaticField2, Operator.Putstatic.PUTSTATIC_Z_DYNLINK.INSTANCE, Operator.Putstatic.PUTSTATIC_Z.INSTANCE);
    }

    public void visitBPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitBPUTSTATIC(jq_StaticField2);
        this.PUTSTATIChelper(jq_StaticField2, Operator.Putstatic.PUTSTATIC_B_DYNLINK.INSTANCE, Operator.Putstatic.PUTSTATIC_B.INSTANCE);
    }

    public void visitCPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitCPUTSTATIC(jq_StaticField2);
        this.PUTSTATIChelper(jq_StaticField2, Operator.Putstatic.PUTSTATIC_C_DYNLINK.INSTANCE, Operator.Putstatic.PUTSTATIC_C.INSTANCE);
    }

    public void visitSPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitSPUTSTATIC(jq_StaticField2);
        this.PUTSTATIChelper(jq_StaticField2, Operator.Putstatic.PUTSTATIC_S_DYNLINK.INSTANCE, Operator.Putstatic.PUTSTATIC_S.INSTANCE);
    }

    private final void GETFIELDhelper(jq_InstanceField jq_InstanceField2, Operator.Getfield getfield, Operator.Getfield getfield2) {
        jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
        boolean bl = this.state.needsDynamicLink(this.method, jq_InstanceField2);
        Operand operand = this.current_state.pop_A();
        this.clearCurrentGuard();
        if (this.performNullCheck(operand)) {
            if (this.TRACE) {
                System.out.println("Null check triggered on " + operand);
            }
            return;
        }
        jq_Type jq_Type2 = jq_InstanceField2.getType();
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Type2);
        Operator.Getfield getfield3 = bl ? getfield : getfield2;
        Quad quad = Operator.Getfield.create(this.quad_cfg.getNewQuadID(), getfield3, registerOperand, operand, new Operand.FieldOperand(jq_InstanceField2), this.getCurrentGuard());
        this.appendQuad(quad);
        this.current_state.push(registerOperand.copy(), jq_Type2);
    }

    public void visitIGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitIGETFIELD(jq_InstanceField2);
        this.GETFIELDhelper(jq_InstanceField2, Operator.Getfield.GETFIELD_I_DYNLINK.INSTANCE, Operator.Getfield.GETFIELD_I.INSTANCE);
    }

    public void visitLGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitLGETFIELD(jq_InstanceField2);
        this.GETFIELDhelper(jq_InstanceField2, Operator.Getfield.GETFIELD_L_DYNLINK.INSTANCE, Operator.Getfield.GETFIELD_L.INSTANCE);
    }

    public void visitFGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitFGETFIELD(jq_InstanceField2);
        this.GETFIELDhelper(jq_InstanceField2, Operator.Getfield.GETFIELD_F_DYNLINK.INSTANCE, Operator.Getfield.GETFIELD_F.INSTANCE);
    }

    public void visitDGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitDGETFIELD(jq_InstanceField2);
        this.GETFIELDhelper(jq_InstanceField2, Operator.Getfield.GETFIELD_D_DYNLINK.INSTANCE, Operator.Getfield.GETFIELD_D.INSTANCE);
    }

    public void visitAGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitAGETFIELD(jq_InstanceField2);
        Operator.Getfield getfield = jq_InstanceField2.getType().isAddressType() ? Operator.Getfield.GETFIELD_P_DYNLINK.INSTANCE : Operator.Getfield.GETFIELD_A_DYNLINK.INSTANCE;
        Operator.Getfield getfield2 = jq_InstanceField2.getType().isAddressType() ? Operator.Getfield.GETFIELD_P.INSTANCE : Operator.Getfield.GETFIELD_A.INSTANCE;
        this.GETFIELDhelper(jq_InstanceField2, getfield, getfield2);
    }

    public void visitBGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitBGETFIELD(jq_InstanceField2);
        this.GETFIELDhelper(jq_InstanceField2, Operator.Getfield.GETFIELD_B_DYNLINK.INSTANCE, Operator.Getfield.GETFIELD_B.INSTANCE);
    }

    public void visitCGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitCGETFIELD(jq_InstanceField2);
        this.GETFIELDhelper(jq_InstanceField2, Operator.Getfield.GETFIELD_C_DYNLINK.INSTANCE, Operator.Getfield.GETFIELD_C.INSTANCE);
    }

    public void visitSGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitSGETFIELD(jq_InstanceField2);
        this.GETFIELDhelper(jq_InstanceField2, Operator.Getfield.GETFIELD_S_DYNLINK.INSTANCE, Operator.Getfield.GETFIELD_S.INSTANCE);
    }

    public void visitZGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitZGETFIELD(jq_InstanceField2);
        this.GETFIELDhelper(jq_InstanceField2, Operator.Getfield.GETFIELD_Z_DYNLINK.INSTANCE, Operator.Getfield.GETFIELD_Z.INSTANCE);
    }

    private final void PUTFIELDhelper(jq_InstanceField jq_InstanceField2, Operator.Putfield putfield, Operator.Putfield putfield2) {
        jq_InstanceField2 = this.tryResolve(jq_InstanceField2);
        boolean bl = this.state.needsDynamicLink(this.method, jq_InstanceField2);
        Operand operand = this.current_state.pop(jq_InstanceField2.getType());
        Operand operand2 = this.current_state.pop_A();
        this.clearCurrentGuard();
        if (this.performNullCheck(operand2)) {
            if (this.TRACE) {
                System.out.println("Null check triggered on " + operand2);
            }
            return;
        }
        Operator.Putfield putfield3 = bl ? putfield : putfield2;
        Quad quad = Operator.Putfield.create(this.quad_cfg.getNewQuadID(), putfield3, operand2, new Operand.FieldOperand(jq_InstanceField2), operand, this.getCurrentGuard());
        this.appendQuad(quad);
    }

    public void visitIPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitIPUTFIELD(jq_InstanceField2);
        this.PUTFIELDhelper(jq_InstanceField2, Operator.Putfield.PUTFIELD_I_DYNLINK.INSTANCE, Operator.Putfield.PUTFIELD_I.INSTANCE);
    }

    public void visitLPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitLPUTFIELD(jq_InstanceField2);
        this.PUTFIELDhelper(jq_InstanceField2, Operator.Putfield.PUTFIELD_L_DYNLINK.INSTANCE, Operator.Putfield.PUTFIELD_L.INSTANCE);
    }

    public void visitFPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitFPUTFIELD(jq_InstanceField2);
        this.PUTFIELDhelper(jq_InstanceField2, Operator.Putfield.PUTFIELD_F_DYNLINK.INSTANCE, Operator.Putfield.PUTFIELD_F.INSTANCE);
    }

    public void visitDPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitDPUTFIELD(jq_InstanceField2);
        this.PUTFIELDhelper(jq_InstanceField2, Operator.Putfield.PUTFIELD_D_DYNLINK.INSTANCE, Operator.Putfield.PUTFIELD_D.INSTANCE);
    }

    public void visitAPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitAPUTFIELD(jq_InstanceField2);
        Operator.Putfield putfield = jq_InstanceField2.getType().isAddressType() ? Operator.Putfield.PUTFIELD_P_DYNLINK.INSTANCE : Operator.Putfield.PUTFIELD_A_DYNLINK.INSTANCE;
        Operator.Putfield putfield2 = jq_InstanceField2.getType().isAddressType() ? Operator.Putfield.PUTFIELD_P.INSTANCE : Operator.Putfield.PUTFIELD_A.INSTANCE;
        this.PUTFIELDhelper(jq_InstanceField2, putfield, putfield2);
    }

    public void visitBPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitBPUTFIELD(jq_InstanceField2);
        this.PUTFIELDhelper(jq_InstanceField2, Operator.Putfield.PUTFIELD_B_DYNLINK.INSTANCE, Operator.Putfield.PUTFIELD_B.INSTANCE);
    }

    public void visitCPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitCPUTFIELD(jq_InstanceField2);
        this.PUTFIELDhelper(jq_InstanceField2, Operator.Putfield.PUTFIELD_C_DYNLINK.INSTANCE, Operator.Putfield.PUTFIELD_C.INSTANCE);
    }

    public void visitSPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitSPUTFIELD(jq_InstanceField2);
        this.PUTFIELDhelper(jq_InstanceField2, Operator.Putfield.PUTFIELD_S_DYNLINK.INSTANCE, Operator.Putfield.PUTFIELD_S.INSTANCE);
    }

    public void visitZPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitZPUTFIELD(jq_InstanceField2);
        this.PUTFIELDhelper(jq_InstanceField2, Operator.Putfield.PUTFIELD_Z_DYNLINK.INSTANCE, Operator.Putfield.PUTFIELD_Z.INSTANCE);
    }

    private final void ADDRESShelper(jq_Method jq_Method2, Operator.Invoke invoke) {
        Quad quad;
        Utf8 utf8 = jq_Method2.getName();
        if (utf8 == poke) {
            Operand operand = this.current_state.pop_P();
            Operand operand2 = this.current_state.pop_P();
            quad = Operator.MemStore.create(this.quad_cfg.getNewQuadID(), Operator.MemStore.POKE_P.INSTANCE, operand2, operand);
        } else if (utf8 == poke1) {
            Operand operand = this.current_state.pop_I();
            Operand operand3 = this.current_state.pop_P();
            quad = Operator.MemStore.create(this.quad_cfg.getNewQuadID(), Operator.MemStore.POKE_1.INSTANCE, operand3, operand);
        } else if (utf8 == poke2) {
            Operand operand = this.current_state.pop_I();
            Operand operand4 = this.current_state.pop_P();
            quad = Operator.MemStore.create(this.quad_cfg.getNewQuadID(), Operator.MemStore.POKE_2.INSTANCE, operand4, operand);
        } else if (utf8 == poke4) {
            Operand operand = this.current_state.pop_I();
            Operand operand5 = this.current_state.pop_P();
            quad = Operator.MemStore.create(this.quad_cfg.getNewQuadID(), Operator.MemStore.POKE_4.INSTANCE, operand5, operand);
        } else if (utf8 == poke8) {
            Operand operand = this.current_state.pop_L();
            Operand operand6 = this.current_state.pop_P();
            quad = Operator.MemStore.create(this.quad_cfg.getNewQuadID(), Operator.MemStore.POKE_8.INSTANCE, operand6, operand);
        } else if (utf8 == peek) {
            Operand operand = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(Address._class);
            quad = Operator.MemLoad.create(this.quad_cfg.getNewQuadID(), Operator.MemLoad.PEEK_P.INSTANCE, registerOperand, operand);
            this.current_state.push_P(registerOperand);
        } else if (utf8 == peek1) {
            Operand operand = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.BYTE);
            quad = Operator.MemLoad.create(this.quad_cfg.getNewQuadID(), Operator.MemLoad.PEEK_1.INSTANCE, registerOperand, operand);
            this.current_state.push_I(registerOperand);
        } else if (utf8 == peek2) {
            Operand operand = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.SHORT);
            quad = Operator.MemLoad.create(this.quad_cfg.getNewQuadID(), Operator.MemLoad.PEEK_2.INSTANCE, registerOperand, operand);
            this.current_state.push_I(registerOperand);
        } else if (utf8 == peek4) {
            Operand operand = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.INT);
            quad = Operator.MemLoad.create(this.quad_cfg.getNewQuadID(), Operator.MemLoad.PEEK_4.INSTANCE, registerOperand, operand);
            this.current_state.push_I(registerOperand);
        } else if (utf8 == peek8) {
            Operand operand = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.LONG);
            quad = Operator.MemLoad.create(this.quad_cfg.getNewQuadID(), Operator.MemLoad.PEEK_8.INSTANCE, registerOperand, operand);
            this.current_state.push_L(registerOperand);
        } else if (utf8 == offset) {
            Operand operand = this.current_state.pop_I();
            Operand operand7 = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(Address._class);
            quad = Operator.Binary.create(this.quad_cfg.getNewQuadID(), Operator.Binary.ADD_P.INSTANCE, registerOperand, operand7, operand);
            this.current_state.push_P(registerOperand);
        } else if (utf8 == align) {
            Operand operand = this.current_state.pop_I();
            Operand operand8 = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(Address._class);
            quad = Operator.Binary.create(this.quad_cfg.getNewQuadID(), Operator.Binary.ALIGN_P.INSTANCE, registerOperand, operand8, operand);
            this.current_state.push_P(registerOperand);
        } else if (utf8 == difference) {
            Operand operand = this.current_state.pop_P();
            Operand operand9 = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.INT);
            quad = Operator.Binary.create(this.quad_cfg.getNewQuadID(), Operator.Binary.SUB_P.INSTANCE, registerOperand, operand9, operand);
            this.current_state.push_I(registerOperand);
        } else if (utf8 == alloca) {
            Operand operand = this.current_state.pop_I();
            Operand.RegisterOperand registerOperand = this.getStackRegister(StackAddress._class);
            quad = Operator.Special.create(this.quad_cfg.getNewQuadID(), Operator.Special.ALLOCA.INSTANCE, registerOperand, operand);
            this.current_state.push_P(registerOperand);
        } else if (utf8 == isNull) {
            Operand operand = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.BOOLEAN);
            quad = Operator.Unary.create(this.quad_cfg.getNewQuadID(), Operator.Unary.ISNULL_P.INSTANCE, registerOperand, operand);
            this.current_state.push_I(registerOperand);
        } else if (utf8 == addressOf) {
            Operand operand = this.current_state.pop_A();
            Operand.RegisterOperand registerOperand = this.getStackRegister(Address._class);
            quad = Operator.Unary.create(this.quad_cfg.getNewQuadID(), Operator.Unary.OBJECT_2ADDRESS.INSTANCE, registerOperand, operand);
            this.current_state.push_P(registerOperand);
        } else if (utf8 == address32) {
            Operand operand = this.current_state.pop_I();
            Operand.RegisterOperand registerOperand = this.getStackRegister(Address._class);
            quad = Operator.Unary.create(this.quad_cfg.getNewQuadID(), Operator.Unary.INT_2ADDRESS.INSTANCE, registerOperand, operand);
            this.current_state.push_P(registerOperand);
        } else if (utf8 == asObject) {
            Operand operand = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(PrimordialClassLoader.getJavaLangObject());
            quad = Operator.Unary.create(this.quad_cfg.getNewQuadID(), Operator.Unary.ADDRESS_2OBJECT.INSTANCE, registerOperand, operand);
            this.current_state.push_A(registerOperand);
        } else if (utf8 == asReferenceType) {
            Operand operand = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Reference._class);
            quad = Operator.Unary.create(this.quad_cfg.getNewQuadID(), Operator.Unary.ADDRESS_2OBJECT.INSTANCE, registerOperand, operand);
            this.current_state.push_A(registerOperand);
        } else if (utf8 == to32BitValue) {
            Operand operand = this.current_state.pop_P();
            Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.INT);
            quad = Operator.Unary.create(this.quad_cfg.getNewQuadID(), Operator.Unary.ADDRESS_2INT.INSTANCE, registerOperand, operand);
            this.current_state.push_I(registerOperand);
        } else {
            if (utf8 == stringRep) {
                Operand operand = this.current_state.pop_P();
                Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.INT);
                Quad quad2 = Operator.Unary.create(this.quad_cfg.getNewQuadID(), Operator.Unary.ADDRESS_2INT.INSTANCE, registerOperand, operand);
                this.current_state.push_I(registerOperand);
                this.appendQuad(quad2);
                jq_Class jq_Class2 = (jq_Class)PrimordialClassLoader.loader.getOrCreateBSType("LUtil/Strings;");
                jq_StaticMethod jq_StaticMethod2 = jq_Class2.getOrCreateStaticMethod("hex8", "(I)Ljava/lang/String;");
                this.INVOKEhelper(Operator.Invoke.INVOKESTATIC_A.INSTANCE, jq_StaticMethod2, jq_StaticMethod2.getReturnType(), false);
                return;
            }
            if (utf8 == getNull) {
                Operand.PConstOperand pConstOperand = new Operand.PConstOperand(null);
                this.current_state.push_P(pConstOperand);
                return;
            }
            if (utf8 == size) {
                Operand.IConstOperand iConstOperand = new Operand.IConstOperand(HeapAddress.size());
                this.current_state.push_I(iConstOperand);
                return;
            }
            if (utf8 == getBasePointer) {
                Operand.RegisterOperand registerOperand = this.getStackRegister(StackAddress._class);
                quad = Operator.Special.create(this.quad_cfg.getNewQuadID(), Operator.Special.GET_BASE_POINTER.INSTANCE, registerOperand);
                this.current_state.push_P(registerOperand);
            } else if (utf8 == getStackPointer) {
                Operand.RegisterOperand registerOperand = this.getStackRegister(StackAddress._class);
                quad = Operator.Special.create(this.quad_cfg.getNewQuadID(), Operator.Special.GET_STACK_POINTER.INSTANCE, registerOperand);
                this.current_state.push_P(registerOperand);
            } else if (utf8 == atomicAdd) {
                Operand operand = this.current_state.pop_I();
                Operand operand10 = this.current_state.pop_P();
                quad = Operator.Special.create(this.quad_cfg.getNewQuadID(), Operator.Special.ATOMICADD_I.INSTANCE, operand10, operand);
            } else if (utf8 == atomicSub) {
                Operand operand = this.current_state.pop_I();
                Operand operand11 = this.current_state.pop_P();
                quad = Operator.Special.create(this.quad_cfg.getNewQuadID(), Operator.Special.ATOMICSUB_I.INSTANCE, operand11, operand);
            } else if (utf8 == atomicAnd) {
                Operand operand = this.current_state.pop_I();
                Operand operand12 = this.current_state.pop_P();
                quad = Operator.Special.create(this.quad_cfg.getNewQuadID(), Operator.Special.ATOMICAND_I.INSTANCE, operand12, operand);
            } else if (utf8 == atomicCas4) {
                Operand operand = this.current_state.pop_I();
                Operand operand13 = this.current_state.pop_I();
                Operand operand14 = this.current_state.pop_P();
                Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.INT);
                quad = Operator.Special.create(this.quad_cfg.getNewQuadID(), Operator.Special.ATOMICCAS4.INSTANCE, registerOperand, operand14, operand13, operand);
                this.current_state.push_I(registerOperand);
            } else if (utf8 == atomicCas8) {
                Operand operand = this.current_state.pop_L();
                Operand operand15 = this.current_state.pop_L();
                Operand operand16 = this.current_state.pop_P();
                Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.LONG);
                quad = Operator.Special.create(this.quad_cfg.getNewQuadID(), Operator.Special.ATOMICCAS8.INSTANCE, registerOperand, operand16, operand15, operand);
                this.current_state.push_L(registerOperand);
            } else {
                this.INVOKEhelper(invoke, jq_Method2, jq_Method2.getReturnType(), false);
                return;
            }
        }
        this.appendQuad(quad);
        this.mergeStateWithAllExHandlers(false);
    }

    private final void UNSAFEhelper(jq_Method jq_Method2, Operator.Invoke invoke) {
        if (_unsafe.handleMethod(this, this.quad_cfg, this.current_state, jq_Method2, invoke)) {
            this.mergeStateWithAllExHandlers(false);
            if (_unsafe.endsBB(jq_Method2)) {
                this.endBasicBlock = true;
            }
        } else {
            this.INVOKEhelper(invoke, jq_Method2, jq_Method2.getReturnType(), false);
            return;
        }
    }

    private final void INVOKEhelper(Operator.Invoke invoke, jq_Method jq_Method2, jq_Type jq_Type2, boolean bl) {
        jq_Type[] jq_TypeArray = jq_Method2.getParamTypes();
        Operand.RegisterOperand registerOperand = jq_Type2 == jq_Primitive.VOID ? null : this.getStackRegister(jq_Type2, jq_Method2.getParamWords() - 1);
        Quad quad = Operator.Invoke.create(this.quad_cfg.getNewQuadID(), invoke, registerOperand, new Operand.MethodOperand(jq_Method2), jq_TypeArray.length);
        Operand operand = null;
        int n = jq_TypeArray.length;
        while (--n >= 0) {
            Operand.RegisterOperand registerOperand2;
            jq_Type jq_Type3 = jq_TypeArray[n];
            operand = this.current_state.pop(jq_Type3);
            if (operand instanceof Operand.RegisterOperand) {
                registerOperand2 = (Operand.RegisterOperand)operand;
            } else {
                registerOperand2 = this.getStackRegister(jq_Type3);
                Quad quad2 = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.getMoveOp(jq_Type3), registerOperand2, operand);
                this.appendQuad(quad2);
            }
            Operator.Invoke.setParam(quad, n, registerOperand2);
        }
        this.clearCurrentGuard();
        if (bl && this.performNullCheck(operand)) {
            if (this.TRACE) {
                System.out.println("Null check triggered on " + operand);
            }
            return;
        }
        this.appendQuad(quad);
        this.mergeStateWithAllExHandlers(false);
        if (registerOperand != null) {
            this.current_state.push(registerOperand, jq_Type2);
        }
    }

    public void visitIINVOKE(byte by, jq_Method jq_Method2) {
        Operator.Invoke invoke;
        boolean bl;
        super.visitIINVOKE(by, jq_Method2);
        if (_unsafe.isUnsafe(jq_Method2)) {
            this.UNSAFEhelper(jq_Method2, Operator.Invoke.INVOKESTATIC_I.INSTANCE);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            this.ADDRESShelper(jq_Method2, jq_Method2.isStatic() ? Operator.Invoke.INVOKESTATIC_I.INSTANCE : Operator.Invoke.INVOKEVIRTUAL_I.INSTANCE);
            return;
        }
        jq_Method2 = (jq_Method)this.tryResolve(jq_Method2);
        boolean bl2 = this.state.needsDynamicLink(this.method, jq_Method2);
        switch (by) {
            case 0: {
                bl = true;
                if (bl2) {
                    invoke = Operator.Invoke.INVOKEVIRTUAL_I_DYNLINK.INSTANCE;
                    break;
                }
                invoke = Operator.Invoke.INVOKEVIRTUAL_I.INSTANCE;
                break;
            }
            case 1: {
                bl = false;
                if (bl2) {
                    invoke = Operator.Invoke.INVOKESTATIC_I_DYNLINK.INSTANCE;
                    break;
                }
                invoke = Operator.Invoke.INVOKESTATIC_I.INSTANCE;
                break;
            }
            case 2: {
                bl = true;
                Assert._assert(jq_Method2 instanceof jq_InstanceMethod);
                if (bl2) {
                    invoke = Operator.Invoke.INVOKESPECIAL_I_DYNLINK.INSTANCE;
                    break;
                }
                jq_Method2 = jq_Class.getInvokespecialTarget(this.clazz, (jq_InstanceMethod)jq_Method2);
                invoke = Operator.Invoke.INVOKESTATIC_I.INSTANCE;
                break;
            }
            case 3: {
                bl = true;
                invoke = Operator.Invoke.INVOKEINTERFACE_I.INSTANCE;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.INVOKEhelper(invoke, jq_Method2, jq_Primitive.INT, bl);
    }

    public void visitLINVOKE(byte by, jq_Method jq_Method2) {
        Operator.Invoke invoke;
        boolean bl;
        super.visitLINVOKE(by, jq_Method2);
        if (_unsafe.isUnsafe(jq_Method2)) {
            this.UNSAFEhelper(jq_Method2, Operator.Invoke.INVOKESTATIC_L.INSTANCE);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            this.ADDRESShelper(jq_Method2, jq_Method2.isStatic() ? Operator.Invoke.INVOKESTATIC_L.INSTANCE : Operator.Invoke.INVOKEVIRTUAL_L.INSTANCE);
            return;
        }
        jq_Method2 = (jq_Method)this.tryResolve(jq_Method2);
        boolean bl2 = this.state.needsDynamicLink(this.method, jq_Method2);
        switch (by) {
            case 0: {
                bl = true;
                if (bl2) {
                    invoke = Operator.Invoke.INVOKEVIRTUAL_L_DYNLINK.INSTANCE;
                    break;
                }
                invoke = Operator.Invoke.INVOKEVIRTUAL_L.INSTANCE;
                break;
            }
            case 1: {
                bl = false;
                if (bl2) {
                    invoke = Operator.Invoke.INVOKESTATIC_L_DYNLINK.INSTANCE;
                    break;
                }
                invoke = Operator.Invoke.INVOKESTATIC_L.INSTANCE;
                break;
            }
            case 2: {
                bl = true;
                Assert._assert(jq_Method2 instanceof jq_InstanceMethod);
                if (bl2) {
                    invoke = Operator.Invoke.INVOKESPECIAL_L_DYNLINK.INSTANCE;
                    break;
                }
                jq_Method2 = jq_Class.getInvokespecialTarget(this.clazz, (jq_InstanceMethod)jq_Method2);
                invoke = Operator.Invoke.INVOKESTATIC_L.INSTANCE;
                break;
            }
            case 3: {
                bl = true;
                invoke = Operator.Invoke.INVOKEINTERFACE_L.INSTANCE;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.INVOKEhelper(invoke, jq_Method2, jq_Primitive.LONG, bl);
    }

    public void visitFINVOKE(byte by, jq_Method jq_Method2) {
        Operator.Invoke invoke;
        boolean bl;
        super.visitFINVOKE(by, jq_Method2);
        if (_unsafe.isUnsafe(jq_Method2)) {
            this.UNSAFEhelper(jq_Method2, Operator.Invoke.INVOKESTATIC_F.INSTANCE);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            this.ADDRESShelper(jq_Method2, jq_Method2.isStatic() ? Operator.Invoke.INVOKESTATIC_F.INSTANCE : Operator.Invoke.INVOKEVIRTUAL_F.INSTANCE);
            return;
        }
        jq_Method2 = (jq_Method)this.tryResolve(jq_Method2);
        boolean bl2 = this.state.needsDynamicLink(this.method, jq_Method2);
        switch (by) {
            case 0: {
                bl = true;
                if (bl2) {
                    invoke = Operator.Invoke.INVOKEVIRTUAL_F_DYNLINK.INSTANCE;
                    break;
                }
                invoke = Operator.Invoke.INVOKEVIRTUAL_F.INSTANCE;
                break;
            }
            case 1: {
                bl = false;
                if (bl2) {
                    invoke = Operator.Invoke.INVOKESTATIC_F_DYNLINK.INSTANCE;
                    break;
                }
                invoke = Operator.Invoke.INVOKESTATIC_F.INSTANCE;
                break;
            }
            case 2: {
                bl = true;
                Assert._assert(jq_Method2 instanceof jq_InstanceMethod);
                if (bl2) {
                    invoke = Operator.Invoke.INVOKESPECIAL_F_DYNLINK.INSTANCE;
                    break;
                }
                jq_Method2 = jq_Class.getInvokespecialTarget(this.clazz, (jq_InstanceMethod)jq_Method2);
                invoke = Operator.Invoke.INVOKESTATIC_F.INSTANCE;
                break;
            }
            case 3: {
                bl = true;
                invoke = Operator.Invoke.INVOKEINTERFACE_F.INSTANCE;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.INVOKEhelper(invoke, jq_Method2, jq_Primitive.FLOAT, bl);
    }

    public void visitDINVOKE(byte by, jq_Method jq_Method2) {
        Operator.Invoke invoke;
        boolean bl;
        super.visitDINVOKE(by, jq_Method2);
        if (_unsafe.isUnsafe(jq_Method2)) {
            this.UNSAFEhelper(jq_Method2, Operator.Invoke.INVOKESTATIC_D.INSTANCE);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            this.ADDRESShelper(jq_Method2, jq_Method2.isStatic() ? Operator.Invoke.INVOKESTATIC_D.INSTANCE : Operator.Invoke.INVOKEVIRTUAL_D.INSTANCE);
            return;
        }
        jq_Method2 = (jq_Method)this.tryResolve(jq_Method2);
        boolean bl2 = this.state.needsDynamicLink(this.method, jq_Method2);
        switch (by) {
            case 0: {
                bl = true;
                if (bl2) {
                    invoke = Operator.Invoke.INVOKEVIRTUAL_D_DYNLINK.INSTANCE;
                    break;
                }
                invoke = Operator.Invoke.INVOKEVIRTUAL_D.INSTANCE;
                break;
            }
            case 1: {
                bl = false;
                if (bl2) {
                    invoke = Operator.Invoke.INVOKESTATIC_D_DYNLINK.INSTANCE;
                    break;
                }
                invoke = Operator.Invoke.INVOKESTATIC_D.INSTANCE;
                break;
            }
            case 2: {
                bl = true;
                Assert._assert(jq_Method2 instanceof jq_InstanceMethod);
                if (bl2) {
                    invoke = Operator.Invoke.INVOKESPECIAL_D_DYNLINK.INSTANCE;
                    break;
                }
                jq_Method2 = jq_Class.getInvokespecialTarget(this.clazz, (jq_InstanceMethod)jq_Method2);
                invoke = Operator.Invoke.INVOKESTATIC_D.INSTANCE;
                break;
            }
            case 3: {
                bl = true;
                invoke = Operator.Invoke.INVOKEINTERFACE_D.INSTANCE;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.INVOKEhelper(invoke, jq_Method2, jq_Primitive.DOUBLE, bl);
    }

    public void visitAINVOKE(byte by, jq_Method jq_Method2) {
        Operator.Invoke invoke;
        boolean bl;
        super.visitAINVOKE(by, jq_Method2);
        if (_unsafe.isUnsafe(jq_Method2)) {
            this.UNSAFEhelper(jq_Method2, jq_Method2.getReturnType().isAddressType() ? Operator.Invoke.INVOKESTATIC_P.INSTANCE : Operator.Invoke.INVOKESTATIC_A.INSTANCE);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            Operator.Invoke invoke2 = jq_Method2.isStatic() ? (jq_Method2.getReturnType().isAddressType() ? Operator.Invoke.INVOKESTATIC_P.INSTANCE : Operator.Invoke.INVOKESTATIC_A.INSTANCE) : (jq_Method2.getReturnType().isAddressType() ? Operator.Invoke.INVOKEVIRTUAL_P.INSTANCE : Operator.Invoke.INVOKEVIRTUAL_A.INSTANCE);
            this.ADDRESShelper(jq_Method2, invoke2);
            return;
        }
        jq_Method2 = (jq_Method)this.tryResolve(jq_Method2);
        boolean bl2 = this.state.needsDynamicLink(this.method, jq_Method2);
        switch (by) {
            case 0: {
                bl = true;
                if (bl2) {
                    invoke = jq_Method2.getReturnType().isAddressType() ? Operator.Invoke.INVOKEVIRTUAL_P_DYNLINK.INSTANCE : Operator.Invoke.INVOKEVIRTUAL_A_DYNLINK.INSTANCE;
                    break;
                }
                invoke = jq_Method2.getReturnType().isAddressType() ? Operator.Invoke.INVOKEVIRTUAL_P.INSTANCE : Operator.Invoke.INVOKEVIRTUAL_A.INSTANCE;
                break;
            }
            case 1: {
                bl = false;
                if (bl2) {
                    invoke = jq_Method2.getReturnType().isAddressType() ? Operator.Invoke.INVOKESTATIC_P_DYNLINK.INSTANCE : Operator.Invoke.INVOKESTATIC_A_DYNLINK.INSTANCE;
                    break;
                }
                invoke = jq_Method2.getReturnType().isAddressType() ? Operator.Invoke.INVOKESTATIC_P.INSTANCE : Operator.Invoke.INVOKESTATIC_A.INSTANCE;
                break;
            }
            case 2: {
                bl = true;
                Assert._assert(jq_Method2 instanceof jq_InstanceMethod);
                if (bl2) {
                    invoke = jq_Method2.getReturnType().isAddressType() ? Operator.Invoke.INVOKESPECIAL_P_DYNLINK.INSTANCE : Operator.Invoke.INVOKESPECIAL_A_DYNLINK.INSTANCE;
                    break;
                }
                invoke = (jq_Method2 = jq_Class.getInvokespecialTarget(this.clazz, (jq_InstanceMethod)jq_Method2)).getReturnType().isAddressType() ? Operator.Invoke.INVOKESTATIC_P.INSTANCE : Operator.Invoke.INVOKESTATIC_A.INSTANCE;
                break;
            }
            case 3: {
                bl = true;
                invoke = jq_Method2.getReturnType().isAddressType() ? Operator.Invoke.INVOKEINTERFACE_P.INSTANCE : Operator.Invoke.INVOKEINTERFACE_A.INSTANCE;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.INVOKEhelper(invoke, jq_Method2, jq_Method2.getReturnType(), bl);
    }

    public void visitVINVOKE(byte by, jq_Method jq_Method2) {
        Operator.Invoke invoke;
        boolean bl;
        super.visitVINVOKE(by, jq_Method2);
        if (_unsafe.isUnsafe(jq_Method2)) {
            this.UNSAFEhelper(jq_Method2, Operator.Invoke.INVOKESTATIC_V.INSTANCE);
            return;
        }
        if (jq_Method2.getDeclaringClass().isAddressType()) {
            this.ADDRESShelper(jq_Method2, jq_Method2.isStatic() ? Operator.Invoke.INVOKESTATIC_V.INSTANCE : Operator.Invoke.INVOKEVIRTUAL_V.INSTANCE);
            return;
        }
        jq_Method2 = (jq_Method)this.tryResolve(jq_Method2);
        boolean bl2 = this.state.needsDynamicLink(this.method, jq_Method2);
        switch (by) {
            case 0: {
                bl = true;
                if (bl2) {
                    invoke = Operator.Invoke.INVOKEVIRTUAL_V_DYNLINK.INSTANCE;
                    break;
                }
                invoke = Operator.Invoke.INVOKEVIRTUAL_V.INSTANCE;
                break;
            }
            case 1: {
                bl = false;
                if (bl2) {
                    invoke = Operator.Invoke.INVOKESTATIC_V_DYNLINK.INSTANCE;
                    break;
                }
                invoke = Operator.Invoke.INVOKESTATIC_V.INSTANCE;
                break;
            }
            case 2: {
                bl = true;
                Assert._assert(jq_Method2 instanceof jq_InstanceMethod);
                if (bl2) {
                    invoke = Operator.Invoke.INVOKESPECIAL_V_DYNLINK.INSTANCE;
                    break;
                }
                jq_Method2 = jq_Class.getInvokespecialTarget(this.clazz, (jq_InstanceMethod)jq_Method2);
                invoke = Operator.Invoke.INVOKESTATIC_V.INSTANCE;
                break;
            }
            case 3: {
                bl = true;
                invoke = Operator.Invoke.INVOKEINTERFACE_V.INSTANCE;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.INVOKEhelper(invoke, jq_Method2, jq_Method2.getReturnType(), bl);
    }

    public void visitNEW(jq_Type jq_Type2) {
        super.visitNEW(jq_Type2);
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Type2);
        Quad quad = Operator.New.create(this.quad_cfg.getNewQuadID(), Operator.New.NEW.INSTANCE, registerOperand, new Operand.TypeOperand(jq_Type2));
        this.appendQuad(quad);
        this.current_state.push_A(registerOperand);
    }

    public void visitNEWARRAY(jq_Array jq_Array2) {
        super.visitNEWARRAY(jq_Array2);
        Operand operand = this.current_state.pop_I();
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Array2);
        Quad quad = Operator.NewArray.create(this.quad_cfg.getNewQuadID(), Operator.NewArray.NEWARRAY.INSTANCE, registerOperand, operand, new Operand.TypeOperand(jq_Array2));
        this.appendQuad(quad);
        this.mergeStateWithAllExHandlers(false);
        this.current_state.push_A(registerOperand);
    }

    public void visitCHECKCAST(jq_Type jq_Type2) {
        super.visitCHECKCAST(jq_Type2);
        Operand operand = this.current_state.pop();
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Type2);
        if (!jq_Type2.isAddressType()) {
            Quad quad = Operator.CheckCast.create(this.quad_cfg.getNewQuadID(), Operator.CheckCast.CHECKCAST.INSTANCE, registerOperand, operand, new Operand.TypeOperand(jq_Type2));
            this.appendQuad(quad);
            this.mergeStateWithAllExHandlers(false);
            this.current_state.push_A(registerOperand);
        } else {
            this.current_state.push_P(registerOperand);
        }
    }

    public void visitINSTANCEOF(jq_Type jq_Type2) {
        super.visitINSTANCEOF(jq_Type2);
        Assert._assert(jq_Type2.isAddressType() ^ true, this.method.toString());
        Operand operand = this.current_state.pop_A();
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.BOOLEAN);
        Quad quad = Operator.InstanceOf.create(this.quad_cfg.getNewQuadID(), Operator.InstanceOf.INSTANCEOF.INSTANCE, registerOperand, operand, new Operand.TypeOperand(jq_Type2));
        this.appendQuad(quad);
        this.current_state.push_I(registerOperand);
    }

    public void visitARRAYLENGTH() {
        super.visitARRAYLENGTH();
        Operand operand = this.current_state.pop_A();
        this.clearCurrentGuard();
        if (this.performNullCheck(operand)) {
            if (this.TRACE) {
                System.out.println("Null check triggered on " + operand);
            }
            return;
        }
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Primitive.INT);
        Quad quad = Operator.ALength.create(this.quad_cfg.getNewQuadID(), Operator.ALength.ARRAYLENGTH.INSTANCE, registerOperand, operand);
        this.appendQuad(quad);
        this.current_state.push_I(registerOperand);
    }

    public void visitATHROW() {
        super.visitATHROW();
        this.uncond_branch = true;
        Operand operand = this.current_state.pop_A();
        Quad quad = Operator.Return.create(this.quad_cfg.getNewQuadID(), Operator.Return.THROW_A.INSTANCE, operand);
        this.appendQuad(quad);
        this.current_state.clearStack();
    }

    public void visitMONITOR(byte by) {
        super.visitMONITOR(by);
        Operand operand = this.current_state.pop_A();
        Operator.Monitor monitor = by == 0 ? Operator.Monitor.MONITORENTER.INSTANCE : Operator.Monitor.MONITOREXIT.INSTANCE;
        Quad quad = Operator.Monitor.create(this.quad_cfg.getNewQuadID(), monitor, operand);
        this.appendQuad(quad);
        this.mergeStateWithAllExHandlers(false);
    }

    public void visitMULTINEWARRAY(jq_Type jq_Type2, char n) {
        super.visitMULTINEWARRAY(jq_Type2, (char)n);
        Operand.RegisterOperand registerOperand = this.getStackRegister(jq_Type2, n - '\u0001');
        Quad quad = Operator.Invoke.create(this.quad_cfg.getNewQuadID(), Operator.Invoke.INVOKESTATIC_A.INSTANCE, registerOperand, new Operand.MethodOperand(Arrays._multinewarray), n + 2);
        Operand.RegisterOperand registerOperand2 = new Operand.RegisterOperand(this.rf.getNewStack(this.current_state.getStackSize(), jq_Primitive.INT), jq_Primitive.INT);
        Quad quad2 = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.MOVE_I.INSTANCE, registerOperand2, new Operand.IConstOperand(n));
        this.appendQuad(quad2);
        Operator.Invoke.setParam(quad, 0, registerOperand2);
        registerOperand2 = new Operand.RegisterOperand(this.rf.getNewStack(this.current_state.getStackSize() + 1, jq_Type._class), jq_Type._class);
        quad2 = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.MOVE_A.INSTANCE, registerOperand2, new Operand.AConstOperand(jq_Type2));
        this.appendQuad(quad2);
        Operator.Invoke.setParam(quad, 1, registerOperand2);
        int n2 = 0;
        while (n2 < n) {
            Operand operand = this.current_state.pop_I();
            if (operand instanceof Operand.RegisterOperand) {
                registerOperand2 = (Operand.RegisterOperand)operand;
            } else {
                registerOperand2 = this.getStackRegister(jq_Primitive.INT);
                quad2 = Operator.Move.create(this.quad_cfg.getNewQuadID(), Operator.Move.MOVE_I.INSTANCE, registerOperand2, operand);
                this.appendQuad(quad2);
            }
            Operator.Invoke.setParam(quad, n2 + 2, registerOperand2);
            ++n2;
        }
        this.appendQuad(quad);
        this.mergeStateWithAllExHandlers(false);
        this.current_state.push(registerOperand, jq_Type2);
    }

    boolean performNullCheck(Operand operand) {
        if (operand instanceof Operand.AConstOperand) {
            Object object = ((Operand.AConstOperand)operand).getValue();
            if (object != null) {
                this.setCurrentGuard(new Operand.UnnecessaryGuardOperand());
                return false;
            }
            Quad quad = Operator.NullCheck.create(this.quad_cfg.getNewQuadID(), Operator.NullCheck.NULL_CHECK.INSTANCE, null, operand);
            this.appendQuad(quad);
            this.mergeStateWithNullPtrExHandler(false);
            return false;
        }
        Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)operand;
        if (BytecodeToQuad.hasGuard(registerOperand)) {
            Operand operand2 = BytecodeToQuad.getGuard(registerOperand);
            this.setCurrentGuard(operand2);
            return false;
        }
        Operand.RegisterOperand registerOperand2 = this.makeGuardReg();
        Quad quad = Operator.NullCheck.create(this.quad_cfg.getNewQuadID(), Operator.NullCheck.NULL_CHECK.INSTANCE, registerOperand2, registerOperand.copy());
        this.appendQuad(quad);
        this.mergeStateWithNullPtrExHandler(false);
        this.setCurrentGuard(registerOperand2);
        BytecodeToQuad.setGuard(registerOperand, registerOperand2);
        jq_Type jq_Type2 = registerOperand.getType();
        if (jq_Type2.isAddressType()) {
            return false;
        }
        int n = this.getLocalNumber(registerOperand.getRegister(), jq_Type2);
        if (this.rf.isLocal(registerOperand, n, jq_Type2)) {
            Operand operand3 = this.current_state.getLocal_A(n);
            if (operand3 instanceof Operand.RegisterOperand) {
                BytecodeToQuad.setGuard((Operand.RegisterOperand)operand3, registerOperand2);
            }
            this.current_state.setLocal(n, operand3);
            this.replaceLocalsOnStack(n, jq_Type2);
        }
        return false;
    }

    boolean performBoundsCheck(Operand operand, Operand operand2) {
        Quad quad = Operator.BoundsCheck.create(this.quad_cfg.getNewQuadID(), Operator.BoundsCheck.BOUNDS_CHECK.INSTANCE, operand.copy(), operand2.copy(), this.getCurrentGuard());
        this.appendQuad(quad);
        this.mergeStateWithArrayBoundsExHandler(false);
        return false;
    }

    boolean performCheckStore(Operand.RegisterOperand registerOperand, Operand operand) {
        jq_Type jq_Type2 = BytecodeToQuad.getTypeOf(operand);
        if (jq_Type2 == jq_Reference.jq_NullType.NULL_TYPE) {
            return false;
        }
        jq_Type jq_Type3 = BytecodeToQuad.getArrayElementTypeOf(registerOperand);
        if (jq_Type3.isAddressType()) {
            if (jq_Type2.isAddressType() || jq_Type2 == jq_Reference.jq_NullType.NULL_TYPE) {
                return false;
            }
            Assert.UNREACHABLE("Storing non-address value into address array! Array: " + registerOperand + " Type: " + jq_Type2);
        }
        if (jq_Type2.isAddressType()) {
            Assert.UNREACHABLE("Storing address value into non-address array! Array: " + registerOperand + " Type: " + jq_Type2);
        }
        if (registerOperand.isExactType() && this.state.isSubtype(jq_Type2, jq_Type3) == 1) {
            return false;
        }
        jq_Type jq_Type4 = jq_Type3;
        if (jq_Type3.isArrayType()) {
            jq_Type4 = ((jq_Array)jq_Type3).getInnermostElementType();
        }
        if (jq_Type4.isLoaded() && jq_Type4.isFinal() && jq_Type3 == jq_Type2) {
            return false;
        }
        Quad quad = Operator.StoreCheck.create(this.quad_cfg.getNewQuadID(), Operator.StoreCheck.ASTORE_CHECK.INSTANCE, registerOperand.copy(), operand.copy(), this.getCurrentGuard());
        this.appendQuad(quad);
        this.mergeStateWithObjArrayStoreExHandler(false);
        return false;
    }

    boolean performZeroCheck(Operand operand) {
        if (operand instanceof Operand.IConstOperand) {
            int n = ((Operand.IConstOperand)operand).getValue();
            if (n != 0) {
                this.setCurrentGuard(new Operand.UnnecessaryGuardOperand());
                return false;
            }
            Quad quad = Operator.ZeroCheck.create(this.quad_cfg.getNewQuadID(), Operator.ZeroCheck.ZERO_CHECK_I.INSTANCE, null, operand);
            this.appendQuad(quad);
            this.mergeStateWithArithExHandler(false);
            return false;
        }
        if (operand instanceof Operand.LConstOperand) {
            long l = ((Operand.LConstOperand)operand).getValue();
            if (l != 0L) {
                this.setCurrentGuard(new Operand.UnnecessaryGuardOperand());
                return false;
            }
            Quad quad = Operator.ZeroCheck.create(this.quad_cfg.getNewQuadID(), Operator.ZeroCheck.ZERO_CHECK_L.INSTANCE, null, operand);
            this.appendQuad(quad);
            this.mergeStateWithArithExHandler(false);
            return false;
        }
        Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)operand;
        if (BytecodeToQuad.hasGuard(registerOperand)) {
            Operand operand2 = BytecodeToQuad.getGuard(registerOperand);
            this.setCurrentGuard(operand2);
            return false;
        }
        Operand.RegisterOperand registerOperand2 = this.makeGuardReg();
        Operator.ZeroCheck zeroCheck = null;
        if (registerOperand.getType() == jq_Primitive.LONG) {
            zeroCheck = Operator.ZeroCheck.ZERO_CHECK_L.INSTANCE;
        } else if (registerOperand.getType().isIntLike()) {
            zeroCheck = Operator.ZeroCheck.ZERO_CHECK_I.INSTANCE;
        } else {
            Assert.UNREACHABLE("Zero check on " + registerOperand + " type " + registerOperand.getType());
        }
        Quad quad = Operator.ZeroCheck.create(this.quad_cfg.getNewQuadID(), zeroCheck, registerOperand2, registerOperand.copy());
        this.appendQuad(quad);
        this.mergeStateWithArithExHandler(false);
        this.setCurrentGuard(registerOperand2);
        BytecodeToQuad.setGuard(registerOperand, registerOperand2);
        jq_Type jq_Type2 = registerOperand.getType();
        int n = this.getLocalNumber(registerOperand.getRegister(), jq_Type2);
        if (this.rf.isLocal(registerOperand, n, jq_Type2)) {
            Operand operand3 = null;
            if (jq_Type2 == jq_Primitive.LONG) {
                operand3 = this.current_state.getLocal_L(n);
            } else if (jq_Type2.isIntLike()) {
                operand3 = this.current_state.getLocal_I(n);
            } else {
                Assert.UNREACHABLE("Unknown type for local " + n + ' ' + registerOperand + ": " + jq_Type2);
            }
            if (this.TRACE) {
                System.out.println(registerOperand + " is a local variable of type " + jq_Type2 + ": currently " + operand3);
            }
            if (operand3 instanceof Operand.RegisterOperand) {
                BytecodeToQuad.setGuard((Operand.RegisterOperand)operand3, registerOperand2);
            }
            this.current_state.setLocal(n, operand3);
            this.replaceLocalsOnStack(n, jq_Type2);
        }
        return false;
    }

    static jq_Type getTypeOf(Operand operand) {
        if (operand instanceof Operand.IConstOperand) {
            return jq_Primitive.INT;
        }
        if (operand instanceof Operand.FConstOperand) {
            return jq_Primitive.FLOAT;
        }
        if (operand instanceof Operand.LConstOperand) {
            return jq_Primitive.LONG;
        }
        if (operand instanceof Operand.DConstOperand) {
            return jq_Primitive.DOUBLE;
        }
        if (operand instanceof Operand.PConstOperand) {
            return Address._class;
        }
        if (operand instanceof Operand.AConstOperand) {
            Object object = ((Operand.AConstOperand)operand).getValue();
            if (object == null) {
                return jq_Reference.jq_NullType.NULL_TYPE;
            }
            return Reflection.getTypeOf(object);
        }
        Assert._assert(operand instanceof Operand.RegisterOperand, operand.toString() + " is not a RegisterOperand");
        return ((Operand.RegisterOperand)operand).getType();
    }

    static jq_Type getArrayElementTypeOf(Operand operand) {
        if (operand instanceof Operand.RegisterOperand) {
            return ((jq_Array)((Operand.RegisterOperand)operand).getType()).getElementType();
        }
        if (operand instanceof Operand.AConstOperand && ((Operand.AConstOperand)operand).getValue() == null) {
            return PrimordialClassLoader.getJavaLangObject();
        }
        Assert.UNREACHABLE(operand.toString());
        return null;
    }

    void mergeStateWithAllExHandlers(boolean bl) {
        ExceptionHandlerIterator exceptionHandlerIterator = this.bc_bb.getExceptionHandlers();
        while (exceptionHandlerIterator.hasNext()) {
            Compil3r.BytecodeAnalysis.ExceptionHandler exceptionHandler = exceptionHandlerIterator.nextEH();
            this.mergeStateWith(exceptionHandler);
        }
    }

    void mergeStateWithNullPtrExHandler(boolean bl) {
        ExceptionHandlerIterator exceptionHandlerIterator = this.bc_bb.getExceptionHandlers();
        while (exceptionHandlerIterator.hasNext()) {
            Compil3r.BytecodeAnalysis.ExceptionHandler exceptionHandler = exceptionHandlerIterator.nextEH();
            jq_Class jq_Class2 = exceptionHandler.getExceptionType();
            if (jq_Class2 != PrimordialClassLoader.getJavaLangNullPointerException() && jq_Class2 != PrimordialClassLoader.getJavaLangRuntimeException() && jq_Class2 != PrimordialClassLoader.getJavaLangException() && jq_Class2 != PrimordialClassLoader.getJavaLangThrowable() && jq_Class2 != null) continue;
            this.mergeStateWith(exceptionHandler);
            break;
        }
    }

    void mergeStateWithArithExHandler(boolean bl) {
        ExceptionHandlerIterator exceptionHandlerIterator = this.bc_bb.getExceptionHandlers();
        while (exceptionHandlerIterator.hasNext()) {
            Compil3r.BytecodeAnalysis.ExceptionHandler exceptionHandler = exceptionHandlerIterator.nextEH();
            jq_Class jq_Class2 = exceptionHandler.getExceptionType();
            if (jq_Class2 != PrimordialClassLoader.getJavaLangArithmeticException() && jq_Class2 != PrimordialClassLoader.getJavaLangRuntimeException() && jq_Class2 != PrimordialClassLoader.getJavaLangException() && jq_Class2 != PrimordialClassLoader.getJavaLangThrowable() && jq_Class2 != null) continue;
            this.mergeStateWith(exceptionHandler);
            break;
        }
    }

    void mergeStateWithArrayBoundsExHandler(boolean bl) {
        ExceptionHandlerIterator exceptionHandlerIterator = this.bc_bb.getExceptionHandlers();
        while (exceptionHandlerIterator.hasNext()) {
            Compil3r.BytecodeAnalysis.ExceptionHandler exceptionHandler = exceptionHandlerIterator.nextEH();
            jq_Class jq_Class2 = exceptionHandler.getExceptionType();
            if (jq_Class2 != PrimordialClassLoader.getJavaLangArrayIndexOutOfBoundsException() && jq_Class2 != PrimordialClassLoader.getJavaLangIndexOutOfBoundsException() && jq_Class2 != PrimordialClassLoader.getJavaLangRuntimeException() && jq_Class2 != PrimordialClassLoader.getJavaLangException() && jq_Class2 != PrimordialClassLoader.getJavaLangThrowable() && jq_Class2 != null) continue;
            this.mergeStateWith(exceptionHandler);
            break;
        }
    }

    void mergeStateWithObjArrayStoreExHandler(boolean bl) {
        ExceptionHandlerIterator exceptionHandlerIterator = this.bc_bb.getExceptionHandlers();
        while (exceptionHandlerIterator.hasNext()) {
            Compil3r.BytecodeAnalysis.ExceptionHandler exceptionHandler = exceptionHandlerIterator.nextEH();
            jq_Class jq_Class2 = exceptionHandler.getExceptionType();
            if (jq_Class2 != PrimordialClassLoader.getJavaLangArrayStoreException() && jq_Class2 != PrimordialClassLoader.getJavaLangRuntimeException() && jq_Class2 != PrimordialClassLoader.getJavaLangException() && jq_Class2 != PrimordialClassLoader.getJavaLangThrowable() && jq_Class2 != null) continue;
            this.mergeStateWith(exceptionHandler);
            break;
        }
    }

    Operand.RegisterOperand makeGuardReg() {
        return RegisterFactory.makeGuardReg();
    }

    int getLocalNumber(RegisterFactory.Register register, jq_Type jq_Type2) {
        return register.getNumber();
    }

    AbstractState allocateEmptyState() {
        AbstractState abstractState = new AbstractState(this.method.getMaxStack() + '\u0001', this.method.getMaxLocals());
        return abstractState;
    }

    AbstractState allocateInitialState() {
        AbstractState abstractState = new AbstractState(this.method.getMaxStack() + '\u0001', this.method.getMaxLocals());
        jq_Type[] jq_TypeArray = this.method.getParamTypes();
        int n = 0;
        int n2 = -1;
        while (n < jq_TypeArray.length) {
            jq_Type jq_Type2 = jq_TypeArray[n];
            ((AbstractState)abstractState).locals[++n2] = new Operand.RegisterOperand(this.rf.getLocal(n2, jq_Type2), jq_Type2);
            if (jq_Type2.getReferenceSize() == 8) {
                ((AbstractState)abstractState).locals[++n2] = DummyOperand.DUMMY;
            }
            ++n;
        }
        return abstractState;
    }

    private static final UnsafeHelper attemptDelegate(String string) {
        String string2 = "BC2Q delegate";
        try {
            Class<?> clazz = Class.forName(string);
            return (UnsafeHelper)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find " + string2 + ' ' + string + ": " + classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Cannot instantiate " + string2 + ' ' + string + ": " + instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Cannot access " + string2 + ' ' + string + ": " + illegalAccessException);
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.quad2bci = new HashMap();
        this.jsr_states = new HashMap();
    }

    public BytecodeToQuad(jq_Method jq_Method2) {
        this(CompilationState.DEFAULT, jq_Method2);
    }

    public BytecodeToQuad(CompilationState compilationState, jq_Method jq_Method2) {
        super(compilationState, jq_Method2);
        this.this();
        this.TRACE = ALWAYS_TRACE;
    }

    static {
        boolean bl = jq.nullVM;
        if (!bl) {
            _unsafe = BytecodeToQuad.attemptDelegate("Compil3r.Quad.B2QUnsafeHandler");
        }
        if (_unsafe == null) {
            _unsafe = new B2QUnsafeIgnorer();
        }
    }

    static class DummyOperand
    implements Operand {
        static final DummyOperand DUMMY = new DummyOperand();

        public Quad getQuad() {
            Assert.UNREACHABLE();
            return null;
        }

        public void attachToQuad(Quad quad) {
            Assert.UNREACHABLE();
        }

        public Operand copy() {
            return DUMMY;
        }

        public boolean isSimilar(Operand operand) {
            boolean bl = false;
            if (operand == DUMMY) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return "<dummy>";
        }

        private DummyOperand() {
        }
    }

    public class AbstractState {
        private int stackptr;
        private Operand[] stack;
        private Operand[] locals;

        AbstractState copy() {
            AbstractState abstractState = new AbstractState(this.stack.length, this.locals.length);
            System.arraycopy(this.stack, 0, abstractState.stack, 0, this.stackptr);
            System.arraycopy(this.locals, 0, abstractState.locals, 0, this.locals.length);
            abstractState.stackptr = this.stackptr;
            return abstractState;
        }

        AbstractState copyFull() {
            AbstractState abstractState = new AbstractState(this.stack.length, this.locals.length);
            int n = 0;
            while (n < this.stackptr) {
                abstractState.stack[n] = this.stack[n].copy();
                ++n;
            }
            n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] != null) {
                    abstractState.locals[n] = this.locals[n].copy();
                }
                ++n;
            }
            abstractState.stackptr = this.stackptr;
            return abstractState;
        }

        AbstractState copyAfterJSR() {
            AbstractState abstractState = new AbstractState(this.stack.length, this.locals.length);
            int n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] != null) {
                    abstractState.locals[n] = this.locals[n].copy();
                }
                ++n;
            }
            return abstractState;
        }

        AbstractState copyExceptionHandler(jq_Class jq_Class2, RegisterFactory registerFactory) {
            if (jq_Class2 == null) {
                jq_Class2 = PrimordialClassLoader.getJavaLangThrowable();
            }
            AbstractState abstractState = new AbstractState(this.stack.length, this.locals.length);
            abstractState.stackptr = 1;
            Operand.RegisterOperand registerOperand = new Operand.RegisterOperand(registerFactory.getStack(0, jq_Class2), jq_Class2);
            abstractState.stack[0] = registerOperand;
            int n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] != null) {
                    abstractState.locals[n] = this.locals[n].copy();
                }
                ++n;
            }
            return abstractState;
        }

        void overwriteWith(AbstractState abstractState) {
            boolean bl = false;
            if (this.stack.length == abstractState.stack.length) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            if (this.locals.length == abstractState.locals.length) {
                bl2 = true;
            }
            Assert._assert(bl2);
            System.arraycopy(abstractState.stack, 0, this.stack, 0, abstractState.stackptr);
            System.arraycopy(abstractState.locals, 0, this.locals, 0, abstractState.locals.length);
            this.stackptr = abstractState.stackptr;
        }

        void mergeAfterJSR(boolean[] blArray, AbstractState abstractState) {
            int n = 0;
            while (n < this.locals.length) {
                if (blArray[n]) {
                    if (BytecodeToQuad.this.TRACE) {
                        System.out.println("local " + n + " changed in jsr to " + abstractState.locals[n]);
                    }
                    this.locals[n] = abstractState.locals[n] == null ? null : abstractState.locals[n].copy();
                }
                ++n;
            }
            this.stackptr = abstractState.stackptr;
            n = 0;
            while (n < this.stackptr) {
                this.stack[n] = abstractState.stack[n].copy();
                ++n;
            }
        }

        boolean merge(AbstractState abstractState, RegisterFactory registerFactory) {
            Operand operand;
            if (this.stackptr != abstractState.stackptr) {
                throw new VerifyError(this.stackptr + " != " + abstractState.stackptr);
            }
            boolean bl = false;
            if (this.locals.length == abstractState.locals.length) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            int n = 0;
            while (n < this.stackptr) {
                operand = this.meet(this.stack[n], abstractState.stack[n], true, n);
                if (!(operand == this.stack[n] || operand != null && operand.isSimilar(this.stack[n]))) {
                    bl2 = true;
                }
                this.stack[n] = operand;
                ++n;
            }
            n = 0;
            while (n < this.locals.length) {
                operand = this.meet(this.locals[n], abstractState.locals[n], false, n);
                if (!(operand == this.locals[n] || operand != null && operand.isSimilar(this.locals[n]))) {
                    bl2 = true;
                }
                this.locals[n] = operand;
                ++n;
            }
            return bl2;
        }

        boolean mergeExceptionHandler(AbstractState abstractState, jq_Class jq_Class2, RegisterFactory registerFactory) {
            if (jq_Class2 == null) {
                jq_Class2 = PrimordialClassLoader.getJavaLangThrowable();
            }
            boolean bl = false;
            if (this.locals.length == abstractState.locals.length) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            if (this.stackptr == 1) {
                bl2 = true;
            }
            Assert._assert(bl2);
            boolean bl3 = false;
            Operand.RegisterOperand registerOperand = new Operand.RegisterOperand(registerFactory.getStack(0, jq_Class2), jq_Class2);
            Operand operand = this.meet(this.stack[0], registerOperand, true, 0);
            if (!(operand == this.stack[0] || operand != null && operand.isSimilar(this.stack[0]))) {
                bl3 = true;
            }
            this.stack[0] = operand;
            int n = 0;
            while (n < this.locals.length) {
                operand = this.meet(this.locals[n], abstractState.locals[n], false, n);
                if (!(operand == this.locals[n] || operand != null && operand.isSimilar(this.locals[n]))) {
                    bl3 = true;
                }
                this.locals[n] = operand;
                ++n;
            }
            return bl3;
        }

        Operand meet(Operand operand, Operand operand2, boolean bl, int n) {
            if (BytecodeToQuad.this.TRACE) {
                System.out.println("Meeting " + operand + " with " + operand2 + ", " + (bl ? "S" : "L") + n);
            }
            if (operand == operand2) {
                return operand;
            }
            if (operand == null || operand2 == null) {
                return null;
            }
            if (Operand.Util.isConstant(operand)) {
                if (operand.isSimilar(operand2)) {
                    return operand;
                }
                if (operand2 instanceof DummyOperand) {
                    return null;
                }
                jq_Type jq_Type2 = BytecodeToQuad.this.state.findCommonSuperclass(BytecodeToQuad.getTypeOf(operand), BytecodeToQuad.getTypeOf(operand2));
                if (jq_Type2 != null) {
                    Operand.RegisterOperand registerOperand = new Operand.RegisterOperand(bl ? BytecodeToQuad.this.rf.getStack(n, jq_Type2) : BytecodeToQuad.this.rf.getLocal(n, jq_Type2), jq_Type2);
                    return registerOperand;
                }
                return null;
            }
            if (operand instanceof Operand.RegisterOperand) {
                if (operand2 instanceof DummyOperand) {
                    return null;
                }
                Operand.RegisterOperand registerOperand = (Operand.RegisterOperand)operand;
                jq_Type jq_Type3 = registerOperand.getType();
                if (jq_Type3 == jq_ReturnAddressType.INSTANCE) {
                    if (operand2 instanceof Operand.RegisterOperand && ((Operand.RegisterOperand)operand2).getType() == jq_ReturnAddressType.INSTANCE) {
                        return operand;
                    }
                    return null;
                }
                if (operand2 instanceof Operand.RegisterOperand) {
                    Operand.RegisterOperand registerOperand2 = (Operand.RegisterOperand)operand2;
                    jq_Type jq_Type4 = registerOperand2.getType();
                    if (jq_Type3 == jq_Type4) {
                        if (registerOperand.hasMoreConservativeFlags(registerOperand2)) {
                            if (registerOperand.scratchObject == null || ((Operand)registerOperand.scratchObject).isSimilar((Operand)registerOperand2.scratchObject)) {
                                return registerOperand;
                            }
                            Operand.RegisterOperand registerOperand3 = new Operand.RegisterOperand(bl ? BytecodeToQuad.this.rf.getStack(n, jq_Type3) : BytecodeToQuad.this.rf.getLocal(n, jq_Type3), jq_Type3);
                            registerOperand3.setFlags(registerOperand.getFlags());
                            return registerOperand3;
                        }
                        Operand.RegisterOperand registerOperand4 = new Operand.RegisterOperand(bl ? BytecodeToQuad.this.rf.getStack(n, jq_Type3) : BytecodeToQuad.this.rf.getLocal(n, jq_Type3), jq_Type3);
                        if (registerOperand.scratchObject == null || ((Operand)registerOperand.scratchObject).isSimilar((Operand)registerOperand2.scratchObject)) {
                            registerOperand4.scratchObject = registerOperand.scratchObject;
                        }
                        registerOperand4.setFlags(registerOperand.getFlags());
                        registerOperand4.meetFlags(registerOperand2.getFlags());
                        return registerOperand4;
                    }
                    if (jq_Type4 == jq_ReturnAddressType.INSTANCE) {
                        return null;
                    }
                    if (BytecodeToQuad.this.state.isSubtype(jq_Type4, jq_Type3) == 1) {
                        if (!registerOperand.isExactType() && registerOperand.hasMoreConservativeFlags(registerOperand2)) {
                            if (registerOperand.scratchObject == null || ((Operand)registerOperand.scratchObject).isSimilar((Operand)registerOperand2.scratchObject)) {
                                return registerOperand;
                            }
                            Operand.RegisterOperand registerOperand5 = new Operand.RegisterOperand(bl ? BytecodeToQuad.this.rf.getStack(n, jq_Type3) : BytecodeToQuad.this.rf.getLocal(n, jq_Type3), jq_Type3);
                            registerOperand5.setFlags(registerOperand.getFlags());
                            return registerOperand5;
                        }
                        Operand.RegisterOperand registerOperand6 = new Operand.RegisterOperand(bl ? BytecodeToQuad.this.rf.getStack(n, jq_Type3) : BytecodeToQuad.this.rf.getLocal(n, jq_Type3), jq_Type3);
                        if (registerOperand.scratchObject == null || ((Operand)registerOperand.scratchObject).isSimilar((Operand)registerOperand2.scratchObject)) {
                            registerOperand6.scratchObject = registerOperand.scratchObject;
                        }
                        registerOperand6.setFlags(registerOperand.getFlags());
                        registerOperand6.meetFlags(registerOperand2.getFlags());
                        registerOperand6.clearExactType();
                        return registerOperand6;
                    }
                    jq_Type4 = BytecodeToQuad.this.state.findCommonSuperclass(jq_Type3, jq_Type4);
                    if (jq_Type4 != null) {
                        Operand.RegisterOperand registerOperand7 = new Operand.RegisterOperand(bl ? BytecodeToQuad.this.rf.getStack(n, jq_Type4) : BytecodeToQuad.this.rf.getLocal(n, jq_Type4), jq_Type4);
                        if (registerOperand.scratchObject != null && ((Operand)registerOperand.scratchObject).isSimilar((Operand)registerOperand2.scratchObject)) {
                            registerOperand7.scratchObject = registerOperand.scratchObject;
                        }
                        registerOperand7.setFlags(registerOperand.getFlags());
                        registerOperand7.meetFlags(registerOperand2.getFlags());
                        registerOperand7.clearExactType();
                        return registerOperand7;
                    }
                    return null;
                }
                jq_Type jq_Type5 = BytecodeToQuad.getTypeOf(operand2);
                if (jq_Type3 == jq_Type5) {
                    if (registerOperand.scratchObject == null || jq_Type5 != jq_Reference.jq_NullType.NULL_TYPE) {
                        return registerOperand;
                    }
                    Operand.RegisterOperand registerOperand8 = new Operand.RegisterOperand(bl ? BytecodeToQuad.this.rf.getStack(n, jq_Type3) : BytecodeToQuad.this.rf.getLocal(n, jq_Type3), jq_Type3);
                    registerOperand8.setFlags(registerOperand.getFlags());
                    return registerOperand8;
                }
                boolean bl2 = false;
                if (jq_Type5 != jq_ReturnAddressType.INSTANCE) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                if (BytecodeToQuad.this.state.isSubtype(jq_Type5, jq_Type3) == 1) {
                    if (!registerOperand.isExactType()) {
                        if (registerOperand.scratchObject == null || jq_Type5 != jq_Reference.jq_NullType.NULL_TYPE) {
                            return registerOperand;
                        }
                        Operand.RegisterOperand registerOperand9 = new Operand.RegisterOperand(bl ? BytecodeToQuad.this.rf.getStack(n, jq_Type3) : BytecodeToQuad.this.rf.getLocal(n, jq_Type3), jq_Type3);
                        registerOperand9.setFlags(registerOperand.getFlags());
                        return registerOperand9;
                    }
                    Operand.RegisterOperand registerOperand10 = new Operand.RegisterOperand(bl ? BytecodeToQuad.this.rf.getStack(n, jq_Type3) : BytecodeToQuad.this.rf.getLocal(n, jq_Type3), jq_Type3);
                    if (jq_Type5 != jq_Reference.jq_NullType.NULL_TYPE) {
                        registerOperand10.scratchObject = registerOperand.scratchObject;
                    }
                    registerOperand10.setFlags(registerOperand.getFlags());
                    registerOperand10.clearExactType();
                    return registerOperand10;
                }
                jq_Type5 = BytecodeToQuad.this.state.findCommonSuperclass(jq_Type3, jq_Type5);
                if (jq_Type5 != null) {
                    Operand.RegisterOperand registerOperand11 = new Operand.RegisterOperand(bl ? BytecodeToQuad.this.rf.getStack(n, jq_Type5) : BytecodeToQuad.this.rf.getLocal(n, jq_Type5), jq_Type5);
                    if (jq_Type5 != jq_Reference.jq_NullType.NULL_TYPE) {
                        registerOperand11.scratchObject = registerOperand.scratchObject;
                    }
                    registerOperand11.setFlags(registerOperand.getFlags());
                    registerOperand11.clearExactType();
                    return registerOperand11;
                }
                return null;
            }
            if (operand.isSimilar(operand2)) {
                return operand;
            }
            return null;
        }

        int getStackSize() {
            return this.stackptr;
        }

        void push_I(Operand operand) {
            Assert._assert(BytecodeToQuad.getTypeOf(operand).isIntLike());
            this.push(operand);
        }

        void push_F(Operand operand) {
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand) == jq_Primitive.FLOAT) {
                bl = true;
            }
            Assert._assert(bl);
            this.push(operand);
        }

        void push_L(Operand operand) {
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand) == jq_Primitive.LONG) {
                bl = true;
            }
            Assert._assert(bl);
            this.push(operand);
            this.pushDummy();
        }

        void push_D(Operand operand) {
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand) == jq_Primitive.DOUBLE) {
                bl = true;
            }
            Assert._assert(bl);
            this.push(operand);
            this.pushDummy();
        }

        void push_A(Operand operand) {
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand).isReferenceType() && !BytecodeToQuad.getTypeOf(operand).isAddressType()) {
                bl = true;
            }
            Assert._assert(bl);
            this.push(operand);
        }

        void push_P(Operand operand) {
            Assert._assert(BytecodeToQuad.getTypeOf(operand).isAddressType());
            this.push(operand);
        }

        void push(Operand operand, jq_Type jq_Type2) {
            boolean bl = false;
            if (BytecodeToQuad.this.state.isSubtype(BytecodeToQuad.getTypeOf(operand), jq_Type2) == 1) {
                bl = true;
            }
            Assert._assert(bl);
            this.push(operand);
            if (jq_Type2.getReferenceSize() == 8) {
                this.pushDummy();
            }
        }

        void pushDummy() {
            this.push(DummyOperand.DUMMY);
        }

        void push(Operand operand) {
            if (BytecodeToQuad.this.TRACE) {
                System.out.println("Pushing " + operand + " on stack " + this.stackptr);
            }
            this.stack[this.stackptr++] = operand;
        }

        Operand pop_I() {
            Operand operand = this.pop();
            Assert._assert(BytecodeToQuad.getTypeOf(operand).isIntLike());
            return operand;
        }

        Operand pop_F() {
            Operand operand = this.pop();
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand) == jq_Primitive.FLOAT) {
                bl = true;
            }
            Assert._assert(bl);
            return operand;
        }

        Operand pop_L() {
            this.popDummy();
            Operand operand = this.pop();
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand) == jq_Primitive.LONG) {
                bl = true;
            }
            Assert._assert(bl);
            return operand;
        }

        Operand pop_D() {
            this.popDummy();
            Operand operand = this.pop();
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand) == jq_Primitive.DOUBLE) {
                bl = true;
            }
            Assert._assert(bl);
            return operand;
        }

        Operand pop_A() {
            Operand operand = this.pop();
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand).isReferenceType() && !BytecodeToQuad.getTypeOf(operand).isAddressType()) {
                bl = true;
            }
            Assert._assert(bl);
            return operand;
        }

        Operand pop_P() {
            Operand operand = this.pop();
            if (operand instanceof Operand.AConstOperand) {
                operand = new Operand.PConstOperand(null);
            }
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand).isAddressType() || BytecodeToQuad.this.state.isSubtype(BytecodeToQuad.getTypeOf(operand), Address._class) != 0) {
                bl = true;
            }
            Assert._assert(bl);
            return operand;
        }

        void popDummy() {
            Operand operand = this.pop();
            boolean bl = false;
            if (operand == DummyOperand.DUMMY) {
                bl = true;
            }
            Assert._assert(bl);
        }

        Operand pop(jq_Type jq_Type2) {
            if (jq_Type2.getReferenceSize() == 8) {
                this.popDummy();
            }
            Operand operand = this.pop();
            if (jq_Type2.isAddressType()) {
                if (operand instanceof Operand.AConstOperand) {
                    operand = new Operand.PConstOperand(null);
                }
                jq_Type jq_Type3 = BytecodeToQuad.getTypeOf(operand);
                boolean bl = false;
                if (jq_Type3 == jq_Reference.jq_NullType.NULL_TYPE || jq_Type3.isAddressType() || BytecodeToQuad.this.state.isSubtype(jq_Type3, Address._class) != 0) {
                    bl = true;
                }
                Assert._assert(bl);
            }
            return operand;
        }

        Operand pop() {
            if (BytecodeToQuad.this.TRACE) {
                System.out.println("Popping " + this.stack[this.stackptr - 1] + " from stack " + (this.stackptr - 1));
            }
            return this.stack[--this.stackptr];
        }

        Operand peekStack(int n) {
            return this.stack[this.stackptr - n - 1];
        }

        void pokeStack(int n, Operand operand) {
            this.stack[this.stackptr - n - 1] = operand;
        }

        void clearStack() {
            this.stackptr = 0;
        }

        Operand getLocal_I(int n) {
            Operand operand = this.getLocal(n);
            Assert._assert(BytecodeToQuad.getTypeOf(operand).isIntLike());
            return operand;
        }

        Operand getLocal_F(int n) {
            Operand operand = this.getLocal(n);
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand) == jq_Primitive.FLOAT) {
                bl = true;
            }
            Assert._assert(bl);
            return operand;
        }

        Operand getLocal_L(int n) {
            Operand operand = this.getLocal(n);
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand) == jq_Primitive.LONG) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            if (this.getLocal(n + 1) == DummyOperand.DUMMY) {
                bl2 = true;
            }
            Assert._assert(bl2);
            return operand;
        }

        Operand getLocal_D(int n) {
            Operand operand = this.getLocal(n);
            boolean bl = false;
            if (BytecodeToQuad.getTypeOf(operand) == jq_Primitive.DOUBLE) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            if (this.getLocal(n + 1) == DummyOperand.DUMMY) {
                bl2 = true;
            }
            Assert._assert(bl2);
            return operand;
        }

        Operand getLocal_A(int n) {
            Operand operand = this.getLocal(n);
            Assert._assert(BytecodeToQuad.getTypeOf(operand).isReferenceType());
            Assert._assert(BytecodeToQuad.getTypeOf(operand).isAddressType() ^ true);
            return operand;
        }

        Operand getLocal(int n) {
            return this.locals[n].copy();
        }

        void setLocal(int n, Operand operand) {
            this.locals[n] = operand;
        }

        void setLocalDual(int n, Operand operand) {
            this.locals[n] = operand;
            this.locals[n + 1] = DummyOperand.DUMMY;
        }

        void dumpState() {
            System.out.print("Locals:");
            int n = 0;
            while (n < this.locals.length) {
                if (this.locals[n] != null) {
                    System.out.print(" L" + n + ':' + this.locals[n]);
                }
                ++n;
            }
            System.out.print("\nStack: ");
            n = 0;
            while (n < this.stackptr) {
                System.out.print(" S" + n + ':' + this.stack[n]);
                ++n;
            }
            System.out.println();
        }

        private AbstractState(int n, int n2) {
            this.stack = new Operand[n];
            this.locals = new Operand[n2];
        }
    }

    public static class jq_ReturnAddressType
    extends jq_Reference {
        public static final jq_ReturnAddressType INSTANCE = new jq_ReturnAddressType();
        private BasicBlock returnTarget;

        public boolean isAddressType() {
            return false;
        }

        public String getJDKName() {
            return this.desc.toString();
        }

        public String getJDKDesc() {
            return this.getJDKName();
        }

        public jq_Class[] getInterfaces() {
            Assert.UNREACHABLE();
            return null;
        }

        public jq_Class getInterface(Utf8 utf8) {
            Assert.UNREACHABLE();
            return null;
        }

        public boolean implementsInterface(jq_Class jq_Class2) {
            Assert.UNREACHABLE();
            return false;
        }

        public jq_InstanceMethod getVirtualMethod(jq_NameAndDesc jq_NameAndDesc2) {
            Assert.UNREACHABLE();
            return null;
        }

        public String getName() {
            return "<retaddr>";
        }

        public String shortName() {
            return "<retaddr>";
        }

        public boolean isClassType() {
            Assert.UNREACHABLE();
            return false;
        }

        public boolean isArrayType() {
            Assert.UNREACHABLE();
            return false;
        }

        public boolean isFinal() {
            Assert.UNREACHABLE();
            return false;
        }

        public jq_Reference getDirectPrimarySupertype() {
            Assert.UNREACHABLE();
            return null;
        }

        public int getDepth() {
            Assert.UNREACHABLE();
            return 0;
        }

        public void load() {
            Assert.UNREACHABLE();
        }

        public void verify() {
            Assert.UNREACHABLE();
        }

        public void prepare() {
            Assert.UNREACHABLE();
        }

        public void sf_initialize() {
            Assert.UNREACHABLE();
        }

        public void compile() {
            Assert.UNREACHABLE();
        }

        public void cls_initialize() {
            Assert.UNREACHABLE();
        }

        public String toString() {
            return "<retaddr> (target=" + this.returnTarget + ')';
        }

        public boolean equals(Object object) {
            if (!(object instanceof jq_ReturnAddressType)) {
                return false;
            }
            return ((jq_ReturnAddressType)object).returnTarget.equals(this.returnTarget);
        }

        public int hashCode() {
            if (this.returnTarget == null) {
                return 0;
            }
            return this.returnTarget.hashCode();
        }

        private jq_ReturnAddressType() {
            super(Utf8.get("L&ReturnAddress;"), PrimordialClassLoader.loader);
        }

        private jq_ReturnAddressType(BasicBlock basicBlock) {
            super(Utf8.get("L&ReturnAddress;"), PrimordialClassLoader.loader);
            this.returnTarget = basicBlock;
        }
    }

    static interface UnsafeHelper {
        public boolean isUnsafe(jq_Method var1);

        public boolean endsBB(jq_Method var1);

        public boolean handleMethod(BytecodeToQuad var1, ControlFlowGraph var2, AbstractState var3, jq_Method var4, Operator.Invoke var5);
    }
}

