/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Quad;

import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Compil3r.Quad.BytecodeToQuad;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.Operand;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Memory.Address;
import Memory.CodeAddress;
import Memory.StackAddress;
import Run_Time.Unsafe;
import Scheduler.jq_Thread;
import Util.Assert;

class B2QUnsafeHandler
implements BytecodeToQuad.UnsafeHelper {
    public boolean isUnsafe(jq_Method jq_Method2) {
        boolean bl = false;
        if (jq_Method2.getDeclaringClass() == Unsafe._class) {
            bl = true;
        }
        return bl;
    }

    public boolean endsBB(jq_Method jq_Method2) {
        boolean bl = false;
        if (jq_Method2 == Unsafe._longJump) {
            bl = true;
        }
        return bl;
    }

    public boolean handleMethod(BytecodeToQuad bytecodeToQuad, ControlFlowGraph controlFlowGraph, BytecodeToQuad.AbstractState abstractState, jq_Method jq_Method2, Operator.Invoke invoke) {
        Quad quad;
        if (jq_Method2 == Unsafe._floatToIntBits) {
            Operand operand = abstractState.pop_F();
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(jq_Primitive.INT);
            quad = Operator.Unary.create(controlFlowGraph.getNewQuadID(), Operator.Unary.FLOAT_2INTBITS.INSTANCE, registerOperand, operand);
            abstractState.push_I(registerOperand);
        } else if (jq_Method2 == Unsafe._intBitsToFloat) {
            Operand operand = abstractState.pop_I();
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(jq_Primitive.FLOAT);
            quad = Operator.Unary.create(controlFlowGraph.getNewQuadID(), Operator.Unary.INTBITS_2FLOAT.INSTANCE, registerOperand, operand);
            abstractState.push_F(registerOperand);
        } else if (jq_Method2 == Unsafe._doubleToLongBits) {
            Operand operand = abstractState.pop_D();
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(jq_Primitive.LONG);
            quad = Operator.Unary.create(controlFlowGraph.getNewQuadID(), Operator.Unary.DOUBLE_2LONGBITS.INSTANCE, registerOperand, operand);
            abstractState.push_L(registerOperand);
        } else if (jq_Method2 == Unsafe._longBitsToDouble) {
            Operand operand = abstractState.pop_L();
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(jq_Primitive.DOUBLE);
            quad = Operator.Unary.create(controlFlowGraph.getNewQuadID(), Operator.Unary.LONGBITS_2DOUBLE.INSTANCE, registerOperand, operand);
            abstractState.push_D(registerOperand);
        } else if (jq_Method2 == Unsafe._getThreadBlock) {
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(jq_Thread._class);
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.GET_THREAD_BLOCK.INSTANCE, registerOperand);
            abstractState.push_A(registerOperand);
        } else if (jq_Method2 == Unsafe._setThreadBlock) {
            Operand operand = abstractState.pop_A();
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.SET_THREAD_BLOCK.INSTANCE, operand);
        } else if (jq_Method2 == Unsafe._longJump) {
            Operand operand = abstractState.pop_I();
            Operand operand2 = abstractState.pop(StackAddress._class);
            Operand operand3 = abstractState.pop(StackAddress._class);
            Operand operand4 = abstractState.pop(CodeAddress._class);
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.LONG_JUMP.INSTANCE, operand4, operand3, operand2, operand);
        } else if (jq_Method2 == Unsafe._popFP32) {
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(jq_Primitive.FLOAT);
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.POP_FP32.INSTANCE, registerOperand);
            abstractState.push_F(registerOperand);
        } else if (jq_Method2 == Unsafe._popFP64) {
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(jq_Primitive.DOUBLE);
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.POP_FP64.INSTANCE, registerOperand);
            abstractState.push_D(registerOperand);
        } else if (jq_Method2 == Unsafe._pushFP32) {
            Operand operand = abstractState.pop_F();
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.PUSH_FP32.INSTANCE, operand);
        } else if (jq_Method2 == Unsafe._pushFP64) {
            Operand operand = abstractState.pop_D();
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.PUSH_FP64.INSTANCE, operand);
        } else if (jq_Method2 == Unsafe._EAX) {
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(jq_Primitive.INT);
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.GET_EAX.INSTANCE, registerOperand);
            abstractState.push_I(registerOperand);
        } else if (jq_Method2 == Unsafe._pushArg) {
            Operand operand = abstractState.pop_I();
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.PUSHARG_I.INSTANCE, operand);
        } else if (jq_Method2 == Unsafe._pushArgA) {
            Operand operand = abstractState.pop_P();
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.PUSHARG_P.INSTANCE, operand);
        } else if (jq_Method2 == Unsafe._invoke) {
            Operand operand = abstractState.pop_P();
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(jq_Primitive.LONG);
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.INVOKE_L.INSTANCE, registerOperand, operand);
            abstractState.push_L(registerOperand);
        } else if (jq_Method2 == Unsafe._invokeA) {
            Operand operand = abstractState.pop_P();
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(Address._class);
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.INVOKE_P.INSTANCE, registerOperand, operand);
            abstractState.push_P(registerOperand);
        } else if (jq_Method2 == Unsafe._isEQ) {
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(jq_Primitive.BOOLEAN);
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.ISEQ.INSTANCE, registerOperand);
            abstractState.push_I(registerOperand);
        } else if (jq_Method2 == Unsafe._isGE) {
            Operand.RegisterOperand registerOperand = bytecodeToQuad.getStackRegister(jq_Primitive.BOOLEAN);
            quad = Operator.Special.create(controlFlowGraph.getNewQuadID(), Operator.Special.ISGE.INSTANCE, registerOperand);
            abstractState.push_I(registerOperand);
        } else {
            System.err.println(jq_Method2.toString());
            Assert.UNREACHABLE();
            return false;
        }
        bytecodeToQuad.appendQuad(quad);
        return true;
    }

    B2QUnsafeHandler() {
    }
}

