/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Dataflow;

import Compil3r.Dataflow.Problem;
import Compil3r.Dataflow.WorklistSolver;
import Util.Collections.BinHeapPriorityQueue;
import Util.Collections.MapFactory;
import Util.Collections.MaxPriorityQueue;
import Util.Graphs.Graph;
import Util.Graphs.Traversals;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PriorityQueueSolver
extends WorklistSolver {
    protected Map nodesToPriorities;
    protected MaxPriorityQueue worklist;

    public void initialize(Problem problem, Graph graph) {
        this.initialize(problem, graph, Traversals.reversePostOrder(graph.getNavigator(), graph.getRoots()));
    }

    public void initialize(Problem problem, Graph graph, List list) {
        super.initialize(problem, graph);
        this.initializeTraversalOrder(list);
    }

    protected void initializeTraversalOrder(List list) {
        int n = list.size();
        this.nodesToPriorities = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.nodesToPriorities.put(e, new Integer(n));
            --n;
        }
    }

    public Iterator allLocations() {
        return this.nodesToPriorities.keySet().iterator();
    }

    protected void initializeWorklist() {
        this.worklist = new BinHeapPriorityQueue(this.nodesToPriorities.size());
        Iterator iterator = this.nodesToPriorities.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            if (this.boundaries.contains(k)) continue;
            int n = (Integer)entry.getValue();
            this.worklist.insert(k, n);
        }
    }

    protected boolean hasNext() {
        return this.worklist.isEmpty() ^ true;
    }

    protected Object pull() {
        return this.worklist.deleteMax();
    }

    protected void pushAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            int n = (Integer)this.nodesToPriorities.get(e);
            this.worklist.insert(e, n);
        }
    }

    public PriorityQueueSolver(MapFactory mapFactory) {
        super(mapFactory);
    }

    public PriorityQueueSolver() {
    }
}

