/*
 * Decompiled with CFR 0.152.
 */
package Compil3r;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Class;
import Clazz.jq_Member;
import Clazz.jq_Method;
import Clazz.jq_Type;
import Compil3r.CompilationConstants;
import Compil3r.Quad.Operator;
import Compil3r.Quad.Quad;
import Main.jq;
import Run_Time.TypeCheck;
import UTF.Utf8;
import Util.Templates.List;
import Util.Templates.UnmodifiableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public abstract class CompilationState
implements CompilationConstants {
    public static CompilationState DEFAULT = jq.nullVM ? new StaticCompilation() : (jq.IsBootstrapping ? new BootstrapCompilation() : new DynamicCompilation());
    public static final boolean VerifyAssertions = true;

    public abstract boolean needsDynamicLink(jq_Method var1, jq_Member var2);

    public abstract boolean needsDynamicLink(jq_Method var1, jq_Type var2);

    public abstract jq_Member tryResolve(jq_Member var1);

    public abstract jq_Member resolve(jq_Member var1);

    public abstract byte isSubtype(jq_Type var1, jq_Type var2);

    public abstract jq_Type findCommonSuperclass(jq_Type var1, jq_Type var2);

    public abstract byte declaresInterface(jq_Class var1, Collection var2);

    public abstract byte implementsInterface(jq_Class var1, jq_Class var2);

    public abstract jq_Type getOrCreateType(Utf8 var1);

    public List.jq_Class getThrownExceptions(Quad quad) {
        return quad.getOperator().getThrownExceptions();
    }

    public static class StaticCompilation
    extends CompilationState {
        public static boolean ASSUME_CORRECT_EXCEPTIONS = true;
        private static HashMap cachedThrownExcListByMethod = new HashMap();
        private static final jq_Class[] defaultThrowables = new jq_Class[]{PrimordialClassLoader.getJavaLangRuntimeException(), PrimordialClassLoader.getJavaLangError()};

        public boolean needsDynamicLink(jq_Method jq_Method2, jq_Member jq_Member2) {
            if (jq_Member2.isPrepared()) {
                return false;
            }
            jq_Member2.getDeclaringClass().prepare();
            return jq_Member2.isPrepared() ^ true;
        }

        public boolean needsDynamicLink(jq_Method jq_Method2, jq_Type jq_Type2) {
            jq_Type2.prepare();
            return jq_Type2.isPrepared() ^ true;
        }

        public jq_Member tryResolve(jq_Member jq_Member2) {
            try {
                jq_Member2 = jq_Member2.resolve();
            }
            catch (Error error) {
                // empty catch block
            }
            return jq_Member2;
        }

        public jq_Member resolve(jq_Member jq_Member2) {
            return jq_Member2.resolve();
        }

        public byte isSubtype(jq_Type jq_Type2, jq_Type jq_Type3) {
            jq_Type2.prepare();
            jq_Type3.prepare();
            return (byte)(jq_Type2.isSubtypeOf(jq_Type3) ? 1 : 0);
        }

        public jq_Type findCommonSuperclass(jq_Type jq_Type2, jq_Type jq_Type3) {
            return TypeCheck.findCommonSuperclass(jq_Type2, jq_Type3, true);
        }

        public byte declaresInterface(jq_Class jq_Class2, Collection collection) {
            return TypeCheck.declaresInterface(jq_Class2, collection, true);
        }

        public byte implementsInterface(jq_Class jq_Class2, jq_Class jq_Class3) {
            jq_Class2.prepare();
            jq_Class3.prepare();
            return (byte)(jq_Class2.isSubtypeOf(jq_Class3) ? 1 : 0);
        }

        public jq_Type getOrCreateType(Utf8 utf8) {
            return PrimordialClassLoader.loader.getOrCreateBSType(utf8);
        }

        public List.jq_Class getThrownExceptions(Quad quad) {
            if (quad.getOperator() == Operator.CheckCast.CHECKCAST.INSTANCE) {
                return new UnmodifiableList.jq_Class(PrimordialClassLoader.getJavaLangClassCastException());
            }
            if (ASSUME_CORRECT_EXCEPTIONS && quad.getOperator() instanceof Operator.Invoke) {
                jq_Method jq_Method2 = (jq_Method)this.resolve(Operator.Invoke.getMethod(quad).getMethod());
                UnmodifiableList.jq_Class jq_Class2 = (UnmodifiableList.jq_Class)cachedThrownExcListByMethod.get(jq_Method2);
                if (jq_Class2 != null) {
                    return jq_Class2;
                }
                jq_Class[] jq_ClassArray = jq_Method2.getThrownExceptionsTable();
                int n = defaultThrowables.length;
                if (jq_ClassArray != null) {
                    n += jq_ClassArray.length;
                }
                jq_Class[] jq_ClassArray2 = new jq_Class[n];
                System.arraycopy(defaultThrowables, 0, jq_ClassArray2, 0, defaultThrowables.length);
                if (jq_ClassArray != null) {
                    System.arraycopy(jq_ClassArray, 0, jq_ClassArray2, defaultThrowables.length, jq_ClassArray.length);
                }
                jq_Class2 = new UnmodifiableList.jq_Class(jq_ClassArray2);
                cachedThrownExcListByMethod.put(jq_Method2, jq_Class2);
                return jq_Class2;
            }
            return super.getThrownExceptions(quad);
        }
    }

    public static class BootstrapCompilation
    extends CompilationState {
        Set boot_types;

        public void setBootTypes(Set set) {
            this.boot_types = set;
        }

        public boolean needsDynamicLink(jq_Method jq_Method2, jq_Member jq_Member2) {
            if (jq_Member2.isPrepared()) {
                return false;
            }
            boolean bl = false;
            if (this.boot_types == null || !this.boot_types.contains(jq_Member2.getDeclaringClass())) {
                bl = true;
            }
            return bl;
        }

        public boolean needsDynamicLink(jq_Method jq_Method2, jq_Type jq_Type2) {
            if (jq_Type2.isPrepared()) {
                return false;
            }
            boolean bl = false;
            if (this.boot_types == null || !this.boot_types.contains(jq_Type2)) {
                bl = true;
            }
            return bl;
        }

        public jq_Member tryResolve(jq_Member jq_Member2) {
            try {
                jq_Member2 = jq_Member2.resolve();
            }
            catch (Error error) {
                // empty catch block
            }
            return jq_Member2;
        }

        public jq_Member resolve(jq_Member jq_Member2) {
            return jq_Member2.resolve();
        }

        public byte isSubtype(jq_Type jq_Type2, jq_Type jq_Type3) {
            return TypeCheck.isAssignable_noload(jq_Type2, jq_Type3);
        }

        public jq_Type findCommonSuperclass(jq_Type jq_Type2, jq_Type jq_Type3) {
            return TypeCheck.findCommonSuperclass(jq_Type2, jq_Type3, false);
        }

        public byte declaresInterface(jq_Class jq_Class2, Collection collection) {
            return TypeCheck.declaresInterface(jq_Class2, collection, false);
        }

        public byte implementsInterface(jq_Class jq_Class2, jq_Class jq_Class3) {
            return TypeCheck.implementsInterface_noload(jq_Class2, jq_Class3);
        }

        public jq_Type getOrCreateType(Utf8 utf8) {
            return PrimordialClassLoader.loader.getOrCreateBSType(utf8);
        }
    }

    public static class DynamicCompilation
    extends CompilationState {
        public boolean needsDynamicLink(jq_Method jq_Method2, jq_Member jq_Member2) {
            if (jq_Member2.isStatic() && jq_Method2.getDeclaringClass() != jq_Member2.getDeclaringClass() && !jq_Member2.getDeclaringClass().isClsInitialized()) {
                return true;
            }
            if (jq_Member2 instanceof jq_Method) {
                return jq_Member2.isInitialized() ^ true;
            }
            return jq_Member2.isPrepared() ^ true;
        }

        public boolean needsDynamicLink(jq_Method jq_Method2, jq_Type jq_Type2) {
            boolean bl = false;
            if (jq_Method2.getDeclaringClass() != jq_Type2 && !jq_Type2.isClsInitialized()) {
                bl = true;
            }
            return bl;
        }

        public jq_Member tryResolve(jq_Member jq_Member2) {
            if (jq_Member2.getDeclaringClass().isPrepared()) {
                try {
                    jq_Member2 = jq_Member2.resolve();
                }
                catch (Error error) {
                    // empty catch block
                }
            }
            return jq_Member2;
        }

        public jq_Member resolve(jq_Member jq_Member2) {
            try {
                jq_Member2 = jq_Member2.resolve();
            }
            catch (Error error) {
                // empty catch block
            }
            return jq_Member2;
        }

        public byte isSubtype(jq_Type jq_Type2, jq_Type jq_Type3) {
            return TypeCheck.isAssignable_noload(jq_Type2, jq_Type3);
        }

        public jq_Type findCommonSuperclass(jq_Type jq_Type2, jq_Type jq_Type3) {
            return TypeCheck.findCommonSuperclass(jq_Type2, jq_Type3, false);
        }

        public byte declaresInterface(jq_Class jq_Class2, Collection collection) {
            return TypeCheck.declaresInterface(jq_Class2, collection, false);
        }

        public byte implementsInterface(jq_Class jq_Class2, jq_Class jq_Class3) {
            return TypeCheck.implementsInterface_noload(jq_Class2, jq_Class3);
        }

        public jq_Type getOrCreateType(Utf8 utf8) {
            return PrimordialClassLoader.loader.getOrCreateBSType(utf8);
        }
    }
}

