/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.BytecodeAnalysis;

import Clazz.jq_InstanceField;
import Clazz.jq_Method;
import Clazz.jq_StaticField;
import Clazz.jq_Type;
import Compil3r.BytecodeAnalysis.BasicBlock;
import Compil3r.BytecodeAnalysis.BytecodeVisitor;
import Compil3r.BytecodeAnalysis.ControlFlowGraph;
import Compil3r.BytecodeAnalysis.ExceptionHandler;
import Compil3r.BytecodeAnalysis.ExceptionHandlerIterator;
import Util.Assert;
import java.util.Stack;

public class StackDepthVisitor
extends BytecodeVisitor {
    protected int currentStackDepth;
    protected final ControlFlowGraph cfg;

    public void go() {
        BasicBlock basicBlock;
        int n = this.cfg.getNumberOfBasicBlocks();
        int n2 = 0;
        while (n2 < n) {
            basicBlock = this.cfg.getBasicBlock(n2);
            basicBlock.startingStackDepth = -1;
            ++n2;
        }
        Stack<Object> stack = new Stack<Object>();
        basicBlock = this.cfg.getEntry();
        basicBlock.startingStackDepth = 0;
        stack.push(basicBlock);
        while (!stack.isEmpty()) {
            Object object;
            basicBlock = (BasicBlock)stack.pop();
            this.currentStackDepth = basicBlock.startingStackDepth;
            this.visitBasicBlock(basicBlock);
            int n3 = 0;
            while (n3 < basicBlock.getNumberOfSuccessors()) {
                object = basicBlock.getSuccessor(n3);
                if (((BasicBlock)object).startingStackDepth == -1) {
                    ((BasicBlock)object).startingStackDepth = this.currentStackDepth;
                    stack.push(object);
                } else {
                    boolean bl = false;
                    if (((BasicBlock)object).startingStackDepth == this.currentStackDepth) {
                        bl = true;
                    }
                    Assert._assert(bl);
                }
                ++n3;
            }
            ExceptionHandlerIterator exceptionHandlerIterator = basicBlock.getExceptionHandlers();
            while (exceptionHandlerIterator.hasNext()) {
                object = exceptionHandlerIterator.nextEH();
                BasicBlock basicBlock2 = ((ExceptionHandler)object).getEntry();
                if (basicBlock2.startingStackDepth == -1) {
                    basicBlock2.startingStackDepth = 1;
                    stack.push(basicBlock2);
                    continue;
                }
                boolean bl = false;
                if (basicBlock2.startingStackDepth == 1) {
                    bl = true;
                }
                Assert._assert(bl);
            }
        }
    }

    public void visitBasicBlock(BasicBlock basicBlock) {
        if (this.TRACE) {
            this.out.println("Visiting " + basicBlock);
        }
        this.i_end = basicBlock.getStart() - 1;
        while (true) {
            this.i_start = this.i_end + 1;
            if (this.isEndOfBB(basicBlock)) break;
            this.visitBytecode();
        }
    }

    private final boolean isEndOfBB(BasicBlock basicBlock) {
        boolean bl = false;
        if (this.i_start > basicBlock.getEnd()) {
            bl = true;
        }
        return bl;
    }

    public void visitACONST(Object object) {
        super.visitACONST(object);
        ++this.currentStackDepth;
    }

    public void visitICONST(int n) {
        super.visitICONST(n);
        ++this.currentStackDepth;
    }

    public void visitLCONST(long l) {
        super.visitLCONST(l);
        this.currentStackDepth += 2;
    }

    public void visitFCONST(float f) {
        super.visitFCONST(f);
        ++this.currentStackDepth;
    }

    public void visitDCONST(double d) {
        super.visitDCONST(d);
        this.currentStackDepth += 2;
    }

    public void visitILOAD(int n) {
        super.visitILOAD(n);
        ++this.currentStackDepth;
    }

    public void visitLLOAD(int n) {
        super.visitLLOAD(n);
        this.currentStackDepth += 2;
    }

    public void visitFLOAD(int n) {
        super.visitFLOAD(n);
        ++this.currentStackDepth;
    }

    public void visitDLOAD(int n) {
        super.visitDLOAD(n);
        this.currentStackDepth += 2;
    }

    public void visitALOAD(int n) {
        super.visitALOAD(n);
        ++this.currentStackDepth;
    }

    public void visitISTORE(int n) {
        super.visitISTORE(n);
        --this.currentStackDepth;
    }

    public void visitLSTORE(int n) {
        super.visitLSTORE(n);
        this.currentStackDepth -= 2;
    }

    public void visitFSTORE(int n) {
        super.visitFSTORE(n);
        --this.currentStackDepth;
    }

    public void visitDSTORE(int n) {
        super.visitDSTORE(n);
        this.currentStackDepth -= 2;
    }

    public void visitASTORE(int n) {
        super.visitASTORE(n);
        --this.currentStackDepth;
    }

    public void visitIALOAD() {
        super.visitIALOAD();
        --this.currentStackDepth;
    }

    public void visitFALOAD() {
        super.visitFALOAD();
        --this.currentStackDepth;
    }

    public void visitAALOAD() {
        super.visitAALOAD();
        --this.currentStackDepth;
    }

    public void visitBALOAD() {
        super.visitBALOAD();
        --this.currentStackDepth;
    }

    public void visitCALOAD() {
        super.visitCALOAD();
        --this.currentStackDepth;
    }

    public void visitSALOAD() {
        super.visitSALOAD();
        --this.currentStackDepth;
    }

    public void visitIASTORE() {
        super.visitIASTORE();
        this.currentStackDepth -= 3;
    }

    public void visitLASTORE() {
        super.visitLASTORE();
        this.currentStackDepth -= 4;
    }

    public void visitFASTORE() {
        super.visitFASTORE();
        this.currentStackDepth -= 3;
    }

    public void visitDASTORE() {
        super.visitDASTORE();
        this.currentStackDepth -= 4;
    }

    public void visitAASTORE() {
        super.visitAASTORE();
        this.currentStackDepth -= 3;
    }

    public void visitBASTORE() {
        super.visitBASTORE();
        this.currentStackDepth -= 3;
    }

    public void visitCASTORE() {
        super.visitCASTORE();
        this.currentStackDepth -= 3;
    }

    public void visitSASTORE() {
        super.visitSASTORE();
        this.currentStackDepth -= 3;
    }

    public void visitPOP() {
        super.visitPOP();
        --this.currentStackDepth;
    }

    public void visitPOP2() {
        super.visitPOP2();
        this.currentStackDepth -= 2;
    }

    public void visitDUP() {
        super.visitDUP();
        ++this.currentStackDepth;
    }

    public void visitDUP_x1() {
        super.visitDUP_x1();
        ++this.currentStackDepth;
    }

    public void visitDUP_x2() {
        super.visitDUP_x2();
        ++this.currentStackDepth;
    }

    public void visitDUP2() {
        super.visitDUP2();
        this.currentStackDepth += 2;
    }

    public void visitDUP2_x1() {
        super.visitDUP2_x1();
        this.currentStackDepth += 2;
    }

    public void visitDUP2_x2() {
        super.visitDUP2_x2();
        this.currentStackDepth += 2;
    }

    public void visitIBINOP(byte by) {
        super.visitIBINOP(by);
        --this.currentStackDepth;
    }

    public void visitLBINOP(byte by) {
        super.visitLBINOP(by);
        this.currentStackDepth -= 2;
    }

    public void visitFBINOP(byte by) {
        super.visitFBINOP(by);
        --this.currentStackDepth;
    }

    public void visitDBINOP(byte by) {
        super.visitDBINOP(by);
        this.currentStackDepth -= 2;
    }

    public void visitISHIFT(byte by) {
        super.visitISHIFT(by);
        --this.currentStackDepth;
    }

    public void visitLSHIFT(byte by) {
        super.visitLSHIFT(by);
        --this.currentStackDepth;
    }

    public void visitI2L() {
        super.visitI2L();
        ++this.currentStackDepth;
    }

    public void visitI2D() {
        super.visitI2D();
        ++this.currentStackDepth;
    }

    public void visitL2I() {
        super.visitL2I();
        --this.currentStackDepth;
    }

    public void visitL2F() {
        super.visitL2F();
        --this.currentStackDepth;
    }

    public void visitF2L() {
        super.visitF2L();
        ++this.currentStackDepth;
    }

    public void visitF2D() {
        super.visitF2D();
        ++this.currentStackDepth;
    }

    public void visitD2I() {
        super.visitD2I();
        --this.currentStackDepth;
    }

    public void visitD2F() {
        super.visitD2F();
        --this.currentStackDepth;
    }

    public void visitLCMP2() {
        super.visitLCMP2();
        this.currentStackDepth -= 3;
    }

    public void visitFCMP2(byte by) {
        super.visitFCMP2(by);
        --this.currentStackDepth;
    }

    public void visitDCMP2(byte by) {
        super.visitDCMP2(by);
        this.currentStackDepth -= 3;
    }

    public void visitIF(byte by, int n) {
        super.visitIF(by, n);
        --this.currentStackDepth;
    }

    public void visitIFREF(byte by, int n) {
        super.visitIFREF(by, n);
        --this.currentStackDepth;
    }

    public void visitIFCMP(byte by, int n) {
        super.visitIFCMP(by, n);
        this.currentStackDepth -= 2;
    }

    public void visitIFREFCMP(byte by, int n) {
        super.visitIFREFCMP(by, n);
        this.currentStackDepth -= 2;
    }

    public void visitJSR(int n) {
        super.visitJSR(n);
        ++this.currentStackDepth;
    }

    public void visitTABLESWITCH(int n, int n2, int n3, int[] nArray) {
        super.visitTABLESWITCH(n, n2, n3, nArray);
        --this.currentStackDepth;
    }

    public void visitLOOKUPSWITCH(int n, int[] nArray, int[] nArray2) {
        super.visitLOOKUPSWITCH(n, nArray, nArray2);
        --this.currentStackDepth;
    }

    public void visitIRETURN() {
        super.visitIRETURN();
        this.currentStackDepth = 0;
    }

    public void visitLRETURN() {
        super.visitLRETURN();
        this.currentStackDepth = 0;
    }

    public void visitFRETURN() {
        super.visitFRETURN();
        this.currentStackDepth = 0;
    }

    public void visitDRETURN() {
        super.visitDRETURN();
        this.currentStackDepth = 0;
    }

    public void visitARETURN() {
        super.visitARETURN();
        this.currentStackDepth = 0;
    }

    public void visitVRETURN() {
        super.visitVRETURN();
        this.currentStackDepth = 0;
    }

    public void visitIGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitIGETSTATIC(jq_StaticField2);
        ++this.currentStackDepth;
    }

    public void visitLGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitLGETSTATIC(jq_StaticField2);
        this.currentStackDepth += 2;
    }

    public void visitFGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitFGETSTATIC(jq_StaticField2);
        ++this.currentStackDepth;
    }

    public void visitDGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitDGETSTATIC(jq_StaticField2);
        this.currentStackDepth += 2;
    }

    public void visitAGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitAGETSTATIC(jq_StaticField2);
        ++this.currentStackDepth;
    }

    public void visitZGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitZGETSTATIC(jq_StaticField2);
        ++this.currentStackDepth;
    }

    public void visitBGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitBGETSTATIC(jq_StaticField2);
        ++this.currentStackDepth;
    }

    public void visitCGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitCGETSTATIC(jq_StaticField2);
        ++this.currentStackDepth;
    }

    public void visitSGETSTATIC(jq_StaticField jq_StaticField2) {
        super.visitSGETSTATIC(jq_StaticField2);
        ++this.currentStackDepth;
    }

    public void visitIPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitIPUTSTATIC(jq_StaticField2);
        --this.currentStackDepth;
    }

    public void visitLPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitLPUTSTATIC(jq_StaticField2);
        this.currentStackDepth -= 2;
    }

    public void visitFPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitFPUTSTATIC(jq_StaticField2);
        --this.currentStackDepth;
    }

    public void visitDPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitDPUTSTATIC(jq_StaticField2);
        this.currentStackDepth -= 2;
    }

    public void visitAPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitAPUTSTATIC(jq_StaticField2);
        --this.currentStackDepth;
    }

    public void visitZPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitZPUTSTATIC(jq_StaticField2);
        --this.currentStackDepth;
    }

    public void visitBPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitBPUTSTATIC(jq_StaticField2);
        --this.currentStackDepth;
    }

    public void visitCPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitCPUTSTATIC(jq_StaticField2);
        --this.currentStackDepth;
    }

    public void visitSPUTSTATIC(jq_StaticField jq_StaticField2) {
        super.visitSPUTSTATIC(jq_StaticField2);
        --this.currentStackDepth;
    }

    public void visitLGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitLGETFIELD(jq_InstanceField2);
        ++this.currentStackDepth;
    }

    public void visitDGETFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitDGETFIELD(jq_InstanceField2);
        ++this.currentStackDepth;
    }

    public void visitIPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitIPUTFIELD(jq_InstanceField2);
        this.currentStackDepth -= 2;
    }

    public void visitLPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitLPUTFIELD(jq_InstanceField2);
        this.currentStackDepth -= 3;
    }

    public void visitFPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitFPUTFIELD(jq_InstanceField2);
        this.currentStackDepth -= 2;
    }

    public void visitDPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitDPUTFIELD(jq_InstanceField2);
        this.currentStackDepth -= 3;
    }

    public void visitAPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitAPUTFIELD(jq_InstanceField2);
        this.currentStackDepth -= 2;
    }

    public void visitBPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitBPUTFIELD(jq_InstanceField2);
        this.currentStackDepth -= 2;
    }

    public void visitCPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitCPUTFIELD(jq_InstanceField2);
        this.currentStackDepth -= 2;
    }

    public void visitSPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitSPUTFIELD(jq_InstanceField2);
        this.currentStackDepth -= 2;
    }

    public void visitZPUTFIELD(jq_InstanceField jq_InstanceField2) {
        super.visitZPUTFIELD(jq_InstanceField2);
        this.currentStackDepth -= 2;
    }

    public void visitIINVOKE(byte by, jq_Method jq_Method2) {
        super.visitIINVOKE(by, jq_Method2);
        this.currentStackDepth -= jq_Method2.getParamWords() - 1;
    }

    public void visitLINVOKE(byte by, jq_Method jq_Method2) {
        super.visitLINVOKE(by, jq_Method2);
        this.currentStackDepth -= jq_Method2.getParamWords() - 2;
    }

    public void visitFINVOKE(byte by, jq_Method jq_Method2) {
        super.visitFINVOKE(by, jq_Method2);
        this.currentStackDepth -= jq_Method2.getParamWords() - 1;
    }

    public void visitDINVOKE(byte by, jq_Method jq_Method2) {
        super.visitDINVOKE(by, jq_Method2);
        this.currentStackDepth -= jq_Method2.getParamWords() - 2;
    }

    public void visitAINVOKE(byte by, jq_Method jq_Method2) {
        super.visitAINVOKE(by, jq_Method2);
        this.currentStackDepth -= jq_Method2.getParamWords() - 1;
    }

    public void visitVINVOKE(byte by, jq_Method jq_Method2) {
        super.visitVINVOKE(by, jq_Method2);
        this.currentStackDepth -= jq_Method2.getParamWords();
    }

    public void visitNEW(jq_Type jq_Type2) {
        super.visitNEW(jq_Type2);
        ++this.currentStackDepth;
    }

    public void visitATHROW() {
        super.visitATHROW();
        this.currentStackDepth = 0;
    }

    public void visitMONITOR(byte by) {
        super.visitMONITOR(by);
        --this.currentStackDepth;
    }

    public void visitMULTINEWARRAY(jq_Type jq_Type2, char c) {
        super.visitMULTINEWARRAY(jq_Type2, c);
        this.currentStackDepth -= c - '\u0001';
    }

    public StackDepthVisitor(jq_Method jq_Method2, ControlFlowGraph controlFlowGraph) {
        super(jq_Method2);
        this.cfg = controlFlowGraph;
    }
}

