/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.BytecodeAnalysis;

import Bootstrap.PrimordialClassLoader;
import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_ClassFileConstants;
import Clazz.jq_ConstantPool;
import Clazz.jq_Field;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_LineNumberBC;
import Clazz.jq_Member;
import Clazz.jq_MemberReference;
import Clazz.jq_Method;
import Clazz.jq_NameAndDesc;
import Clazz.jq_Primitive;
import Clazz.jq_Reference;
import Clazz.jq_StaticField;
import Clazz.jq_TryCatchBC;
import Clazz.jq_Type;
import UTF.Utf8;
import Util.Assert;
import Util.Collections.LinearSet;
import Util.IO.ByteSequence;
import Util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public interface Bytecodes {

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class Instruction
    implements Cloneable,
    Serializable {
        protected short length;
        protected short opcode;

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(this.opcode);
        }

        public String toString(boolean bl) {
            if (bl) {
                return jq_ClassFileConstants.OPCODE_NAMES[this.opcode] + '[' + this.opcode + "](" + this.length + ')';
            }
            return jq_ClassFileConstants.OPCODE_NAMES[this.opcode];
        }

        public String toString() {
            return this.toString(true);
        }

        public Instruction copy() {
            Instruction instruction = null;
            if (InstructionConstants.INSTRUCTIONS[this.getOpcode()] != null) {
                instruction = this;
            } else {
                try {
                    instruction = (Instruction)this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    System.err.println(cloneNotSupportedException);
                }
            }
            return instruction;
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
        }

        public static final Instruction readInstruction(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence) throws IOException {
            Class<?> clazz;
            boolean bl = false;
            short s = (short)byteSequence.readUnsignedByte();
            Instruction instruction = null;
            if (s == 196) {
                bl = true;
                s = (short)byteSequence.readUnsignedByte();
            }
            if (InstructionConstants.INSTRUCTIONS[s] != null) {
                return InstructionConstants.INSTRUCTIONS[s];
            }
            try {
                clazz = Class.forName(Instruction.className(s));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new BytecodeException("Illegal opcode detected.");
            }
            try {
                instruction = (Instruction)clazz.newInstance();
                if (bl && !(instruction instanceof LocalVariableInstruction) && !(instruction instanceof IINC) && !(instruction instanceof RET)) {
                    throw new Exception("Illegal opcode after wide: " + s);
                }
                instruction.setOpcode(s);
                instruction.initFromFile(jq_ConstantPool2, byteSequence, bl);
            }
            catch (Exception exception) {
                throw new BytecodeException(exception.toString());
            }
            return instruction;
        }

        private static final String className(short s) {
            String string = jq_ClassFileConstants.OPCODE_NAMES[s].toUpperCase();
            try {
                int n = string.length();
                char c = string.charAt(n - 2);
                char c2 = string.charAt(n - 1);
                if (c == '_' && c2 >= '0' && c2 <= '5') {
                    string = string.substring(0, n - 2);
                }
                if (string.equals("ICONST_M1")) {
                    string = "ICONST";
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                System.err.println(stringIndexOutOfBoundsException);
            }
            return "Compil3r.BytecodeAnalysis.Bytecodes$" + string;
        }

        public int consumeStack() {
            return jq_ClassFileConstants.CONSUME_STACK[this.opcode];
        }

        public int produceStack() {
            return jq_ClassFileConstants.PRODUCE_STACK[this.opcode];
        }

        public short getOpcode() {
            return this.opcode;
        }

        public int getLength() {
            return this.length;
        }

        private final void setOpcode(short s) {
            this.opcode = s;
        }

        void dispose() {
        }

        public abstract void accept(Visitor var1);

        private final /* synthetic */ void this() {
            this.length = 1;
            this.opcode = (short)-1;
        }

        Instruction() {
            this.this();
        }

        public Instruction(short s, short s2) {
            this.this();
            this.length = s2;
            this.opcode = s;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class InstructionHandle
    implements Serializable {
        private static InstructionHandle ih_list = null;
        InstructionHandle next;
        InstructionHandle prev;
        Instruction instruction;
        protected int i_position;
        private Set targeters;
        private Map attributes;
        static /* synthetic */ Class class$Compil3r$BytecodeAnalysis$Bytecodes$BranchHandle;

        public final InstructionHandle getNext() {
            return this.next;
        }

        public final InstructionHandle getPrev() {
            return this.prev;
        }

        public final Instruction getInstruction() {
            return this.instruction;
        }

        public void setInstruction(Instruction instruction) {
            if (instruction == null) {
                throw new BytecodeException("Assigning null to handle");
            }
            Class<?> clazz = this.getClass();
            Class clazz2 = class$Compil3r$BytecodeAnalysis$Bytecodes$BranchHandle;
            if (clazz2 == null) {
                clazz2 = class$Compil3r$BytecodeAnalysis$Bytecodes$BranchHandle = InstructionHandle.class$("[LCompil3r.BytecodeAnalysis.Bytecodes$BranchHandle;", false);
            }
            if (clazz != clazz2 && instruction instanceof BranchInstruction) {
                throw new BytecodeException("Assigning branch instruction " + instruction + " to plain handle");
            }
            if (this.instruction != null) {
                this.instruction.dispose();
            }
            this.instruction = instruction;
        }

        public Instruction swapInstruction(Instruction instruction) {
            Instruction instruction2 = this.instruction;
            this.instruction = instruction;
            return instruction2;
        }

        static final InstructionHandle getInstructionHandle(Instruction instruction) {
            if (ih_list == null) {
                return new InstructionHandle(instruction);
            }
            InstructionHandle instructionHandle = ih_list;
            ih_list = instructionHandle.next;
            instructionHandle.setInstruction(instruction);
            return instructionHandle;
        }

        protected int updatePosition(int n, int n2) {
            this.i_position += n;
            return 0;
        }

        public int getPosition() {
            return this.i_position;
        }

        void setPosition(int n) {
            this.i_position = n;
        }

        protected void addHandle() {
            this.next = ih_list;
            ih_list = this;
        }

        void dispose() {
            this.prev = null;
            this.next = null;
            this.instruction.dispose();
            this.instruction = null;
            this.i_position = -1;
            this.attributes = null;
            this.removeAllTargeters();
            this.addHandle();
        }

        public void removeAllTargeters() {
            if (this.targeters != null) {
                this.targeters.clear();
            }
        }

        public void removeTargeter(InstructionTargeter instructionTargeter) {
            this.targeters.remove(instructionTargeter);
        }

        public void addTargeter(InstructionTargeter instructionTargeter) {
            if (this.targeters == null) {
                this.targeters = new LinearSet();
            }
            this.targeters.add(instructionTargeter);
        }

        public boolean hasTargeters() {
            boolean bl = false;
            if (this.targeters != null && this.targeters.size() > 0) {
                bl = true;
            }
            return bl;
        }

        public Set getTargeters() {
            if (!this.hasTargeters()) {
                return null;
            }
            return Collections.unmodifiableSet(this.targeters);
        }

        public String toString(boolean bl) {
            return Strings.format(this.i_position, 4, false, ' ') + ": " + this.instruction.toString(bl);
        }

        public String toString() {
            return this.toString(true);
        }

        public void addAttribute(Object object, Object object2) {
            if (this.attributes == null) {
                this.attributes = new HashMap(3);
            }
            this.attributes.put(object, object2);
        }

        public void removeAttribute(Object object) {
            if (this.attributes != null) {
                this.attributes.remove(object);
            }
        }

        public Object getAttribute(Object object) {
            if (this.attributes != null) {
                return this.attributes.get(object);
            }
            return null;
        }

        public void accept(Visitor visitor) {
            this.instruction.accept(visitor);
        }

        static /* synthetic */ Class class$(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            this.i_position = -1;
        }

        protected InstructionHandle(Instruction instruction) {
            this.this();
            this.setInstruction(instruction);
        }
    }

    public static final class BranchHandle
    extends InstructionHandle {
        private static BranchHandle bh_list = null;
        private BranchInstruction bi;

        static final BranchHandle getBranchHandle(BranchInstruction branchInstruction) {
            if (bh_list == null) {
                return new BranchHandle(branchInstruction);
            }
            BranchHandle branchHandle = bh_list;
            bh_list = (BranchHandle)branchHandle.next;
            branchHandle.setInstruction(branchInstruction);
            return branchHandle;
        }

        protected final void addHandle() {
            this.next = bh_list;
            bh_list = this;
        }

        public final int getPosition() {
            return this.bi.position;
        }

        final void setPosition(int n) {
            this.i_position = this.bi.position = n;
        }

        protected final int updatePosition(int n, int n2) {
            int n3 = this.bi.updatePosition(n, n2);
            this.i_position = this.bi.position;
            return n3;
        }

        public final void setTarget(InstructionHandle instructionHandle) {
            this.bi.setTarget(instructionHandle);
        }

        public final void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
            this.bi.updateTarget(instructionHandle, instructionHandle2);
        }

        public final InstructionHandle getTarget() {
            return this.bi.getTarget();
        }

        public final void setInstruction(Instruction instruction) {
            super.setInstruction(instruction);
            if (!(instruction instanceof BranchInstruction)) {
                throw new BytecodeException("Assigning " + instruction + " to branch handle which is not a branch instruction");
            }
            this.bi = (BranchInstruction)instruction;
        }

        private BranchHandle(BranchInstruction branchInstruction) {
            super(branchInstruction);
            this.bi = branchInstruction;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class InstructionList
    implements Serializable {
        private InstructionHandle start;
        private InstructionHandle end;
        private int length;
        private int[] byte_positions;
        private List observers;

        public boolean isEmpty() {
            boolean bl = false;
            if (this.start == null) {
                bl = true;
            }
            return bl;
        }

        public static InstructionHandle findHandle(List list, int[] nArray, int n) {
            int n2 = 0;
            int n3 = nArray.length - 1;
            do {
                int n4 = (n2 + n3) / 2;
                int n5 = nArray[n4];
                while (n5 == -1 && n4 >= n2 && n4 > 0) {
                    n5 = nArray[--n4];
                }
                if (n4 < n2) {
                    n4 = (n2 + n3) / 2;
                    n5 = nArray[n4];
                    while (n5 == -1 && n4 <= n3 && n4 < nArray.length) {
                        n5 = nArray[++n4];
                    }
                    if (n4 > n3) {
                        return null;
                    }
                }
                if (n5 == n) {
                    return (InstructionHandle)list.get(n4);
                }
                if (n < n5) {
                    n3 = n4 - 1;
                    continue;
                }
                n2 = n4 + 1;
            } while (n2 <= n3);
            return null;
        }

        public InstructionHandle findHandle(int n) {
            List list = this.getInstructionHandles();
            return InstructionList.findHandle(list, this.byte_positions, n);
        }

        public InstructionHandle append(InstructionHandle instructionHandle, InstructionList instructionList) {
            if (instructionList == null) {
                throw new BytecodeException("Appending null InstructionList");
            }
            if (instructionList.isEmpty()) {
                return instructionHandle;
            }
            InstructionHandle instructionHandle2 = instructionHandle.next;
            InstructionHandle instructionHandle3 = instructionList.start;
            instructionHandle.next = instructionList.start;
            instructionList.start.prev = instructionHandle;
            instructionList.end.next = instructionHandle2;
            if (instructionHandle2 != null) {
                instructionHandle2.prev = instructionList.end;
            } else {
                this.end = instructionList.end;
            }
            this.length += instructionList.length;
            instructionList.clear();
            return instructionHandle3;
        }

        public InstructionHandle append(Instruction instruction, InstructionList instructionList) {
            InstructionHandle instructionHandle = this.findInstruction2(instruction);
            if (instructionHandle == null) {
                throw new BytecodeException("Instruction " + instruction + " is not contained in this list.");
            }
            return this.append(instructionHandle, instructionList);
        }

        public InstructionHandle append(InstructionList instructionList) {
            if (instructionList == null) {
                throw new BytecodeException("Appending null InstructionList");
            }
            if (instructionList.isEmpty()) {
                return null;
            }
            if (this.isEmpty()) {
                this.start = instructionList.start;
                this.end = instructionList.end;
                this.length = instructionList.length;
                instructionList.clear();
                return this.start;
            }
            return this.append(this.end, instructionList);
        }

        private final void append(InstructionHandle instructionHandle) {
            if (this.isEmpty()) {
                this.start = this.end = instructionHandle;
                instructionHandle.prev = null;
                instructionHandle.next = null;
            } else {
                this.end.next = instructionHandle;
                instructionHandle.prev = this.end;
                instructionHandle.next = null;
                this.end = instructionHandle;
            }
            ++this.length;
        }

        public InstructionHandle append(Instruction instruction) {
            InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(instruction);
            this.append(instructionHandle);
            return instructionHandle;
        }

        public BranchHandle append(BranchInstruction branchInstruction) {
            BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
            this.append(branchHandle);
            return branchHandle;
        }

        public InstructionHandle append(Instruction instruction, Instruction instruction2) {
            return this.append(instruction, new InstructionList(instruction2));
        }

        public InstructionHandle append(Instruction instruction, CompoundInstruction compoundInstruction) {
            return this.append(instruction, compoundInstruction.getInstructionList());
        }

        public InstructionHandle append(CompoundInstruction compoundInstruction) {
            return this.append(compoundInstruction.getInstructionList());
        }

        public InstructionHandle append(InstructionHandle instructionHandle, CompoundInstruction compoundInstruction) {
            return this.append(instructionHandle, compoundInstruction.getInstructionList());
        }

        public InstructionHandle append(InstructionHandle instructionHandle, Instruction instruction) {
            return this.append(instructionHandle, new InstructionList(instruction));
        }

        public BranchHandle append(InstructionHandle instructionHandle, BranchInstruction branchInstruction) {
            BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
            InstructionList instructionList = new InstructionList();
            instructionList.append(branchHandle);
            this.append(instructionHandle, instructionList);
            return branchHandle;
        }

        public InstructionHandle insert(InstructionHandle instructionHandle, InstructionList instructionList) {
            if (instructionList == null) {
                throw new BytecodeException("Inserting null InstructionList");
            }
            if (instructionList.isEmpty()) {
                return instructionHandle;
            }
            InstructionHandle instructionHandle2 = instructionHandle.prev;
            InstructionHandle instructionHandle3 = instructionList.start;
            instructionHandle.prev = instructionList.end;
            instructionList.end.next = instructionHandle;
            instructionList.start.prev = instructionHandle2;
            if (instructionHandle2 != null) {
                instructionHandle2.next = instructionList.start;
            } else {
                this.start = instructionList.start;
            }
            this.length += instructionList.length;
            instructionList.clear();
            return instructionHandle3;
        }

        public InstructionHandle insert(InstructionList instructionList) {
            if (this.isEmpty()) {
                this.append(instructionList);
                return this.start;
            }
            return this.insert(this.start, instructionList);
        }

        private final void insert(InstructionHandle instructionHandle) {
            if (this.isEmpty()) {
                this.start = this.end = instructionHandle;
                instructionHandle.prev = null;
                instructionHandle.next = null;
            } else {
                this.start.prev = instructionHandle;
                instructionHandle.next = this.start;
                instructionHandle.prev = null;
                this.start = instructionHandle;
            }
            ++this.length;
        }

        public InstructionHandle insert(Instruction instruction, InstructionList instructionList) {
            InstructionHandle instructionHandle = this.findInstruction1(instruction);
            if (instructionHandle == null) {
                throw new BytecodeException("Instruction " + instruction + " is not contained in this list.");
            }
            return this.insert(instructionHandle, instructionList);
        }

        public InstructionHandle insert(Instruction instruction) {
            InstructionHandle instructionHandle = InstructionHandle.getInstructionHandle(instruction);
            this.insert(instructionHandle);
            return instructionHandle;
        }

        public BranchHandle insert(BranchInstruction branchInstruction) {
            BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
            this.insert(branchHandle);
            return branchHandle;
        }

        public InstructionHandle insert(Instruction instruction, Instruction instruction2) {
            return this.insert(instruction, new InstructionList(instruction2));
        }

        public InstructionHandle insert(Instruction instruction, CompoundInstruction compoundInstruction) {
            return this.insert(instruction, compoundInstruction.getInstructionList());
        }

        public InstructionHandle insert(CompoundInstruction compoundInstruction) {
            return this.insert(compoundInstruction.getInstructionList());
        }

        public InstructionHandle insert(InstructionHandle instructionHandle, Instruction instruction) {
            return this.insert(instructionHandle, new InstructionList(instruction));
        }

        public InstructionHandle insert(InstructionHandle instructionHandle, CompoundInstruction compoundInstruction) {
            return this.insert(instructionHandle, compoundInstruction.getInstructionList());
        }

        public BranchHandle insert(InstructionHandle instructionHandle, BranchInstruction branchInstruction) {
            BranchHandle branchHandle = BranchHandle.getBranchHandle(branchInstruction);
            InstructionList instructionList = new InstructionList();
            instructionList.append(branchHandle);
            this.insert(instructionHandle, instructionList);
            return branchHandle;
        }

        public void move(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3) {
            if (instructionHandle == null || instructionHandle2 == null) {
                throw new BytecodeException("Invalid null handle: From " + instructionHandle + " to " + instructionHandle2);
            }
            if (instructionHandle3 == instructionHandle || instructionHandle3 == instructionHandle2) {
                throw new BytecodeException("Invalid range: From " + instructionHandle + " to " + instructionHandle2 + " contains target " + instructionHandle3);
            }
            InstructionHandle instructionHandle4 = instructionHandle;
            while (instructionHandle4 != instructionHandle2.next) {
                if (instructionHandle4 == null) {
                    throw new BytecodeException("Invalid range: From " + instructionHandle + " to " + instructionHandle2);
                }
                if (instructionHandle4 == instructionHandle3) {
                    throw new BytecodeException("Invalid range: From " + instructionHandle + " to " + instructionHandle2 + " contains target " + instructionHandle3);
                }
                instructionHandle4 = instructionHandle4.next;
            }
            instructionHandle4 = instructionHandle.prev;
            InstructionHandle instructionHandle5 = instructionHandle2.next;
            if (instructionHandle4 != null) {
                instructionHandle4.next = instructionHandle5;
            } else {
                this.start = instructionHandle5;
            }
            if (instructionHandle5 != null) {
                instructionHandle5.prev = instructionHandle4;
            } else {
                this.end = instructionHandle4;
            }
            instructionHandle2.next = null;
            instructionHandle.prev = null;
            if (instructionHandle3 == null) {
                instructionHandle2.next = this.start;
                this.start = instructionHandle;
            } else {
                instructionHandle5 = instructionHandle3.next;
                instructionHandle3.next = instructionHandle;
                instructionHandle.prev = instructionHandle3;
                instructionHandle2.next = instructionHandle5;
                if (instructionHandle5 != null) {
                    instructionHandle5.prev = instructionHandle2;
                }
            }
        }

        public void move(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
            this.move(instructionHandle, instructionHandle, instructionHandle2);
        }

        private final void remove(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) throws TargetLostException {
            InstructionHandle instructionHandle3;
            InstructionHandle instructionHandle4;
            if (instructionHandle == null && instructionHandle2 == null) {
                instructionHandle3 = instructionHandle4 = this.start;
                this.end = null;
                this.start = null;
            } else {
                if (instructionHandle == null) {
                    instructionHandle3 = this.start;
                    this.start = instructionHandle2;
                } else {
                    instructionHandle3 = instructionHandle.next;
                    instructionHandle.next = instructionHandle2;
                }
                if (instructionHandle2 == null) {
                    instructionHandle4 = this.end;
                    this.end = instructionHandle;
                } else {
                    instructionHandle4 = instructionHandle2.prev;
                    instructionHandle2.prev = instructionHandle;
                }
            }
            instructionHandle3.prev = null;
            instructionHandle4.next = null;
            LinkedList<InstructionHandle> linkedList = new LinkedList<InstructionHandle>();
            Serializable serializable = instructionHandle3;
            while (serializable != null) {
                ((InstructionHandle)serializable).getInstruction().dispose();
                serializable = ((InstructionHandle)serializable).next;
            }
            serializable = new StringBuffer("{ ");
            InstructionHandle instructionHandle5 = instructionHandle3;
            while (instructionHandle5 != null) {
                instructionHandle2 = instructionHandle5.next;
                --this.length;
                if (instructionHandle5.hasTargeters()) {
                    linkedList.add(instructionHandle5);
                    ((StringBuffer)serializable).append(instructionHandle5.toString(true) + ' ');
                    instructionHandle5.prev = null;
                    instructionHandle5.next = null;
                } else {
                    instructionHandle5.dispose();
                }
                instructionHandle5 = instructionHandle2;
            }
            ((StringBuffer)serializable).append("}");
            if (!linkedList.isEmpty()) {
                throw new TargetLostException(linkedList, ((StringBuffer)serializable).toString());
            }
        }

        public void delete(InstructionHandle instructionHandle) throws TargetLostException {
            this.remove(instructionHandle.prev, instructionHandle.next);
        }

        public void delete(Instruction instruction) throws TargetLostException {
            InstructionHandle instructionHandle = this.findInstruction1(instruction);
            if (instructionHandle == null) {
                throw new BytecodeException("Instruction " + instruction + " is not contained in this list.");
            }
            this.delete(instructionHandle);
        }

        public void delete(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) throws TargetLostException {
            this.remove(instructionHandle.prev, instructionHandle2.next);
        }

        public void delete(Instruction instruction, Instruction instruction2) throws TargetLostException {
            InstructionHandle instructionHandle = this.findInstruction1(instruction);
            if (instructionHandle == null) {
                throw new BytecodeException("Instruction " + instruction + " is not contained in this list.");
            }
            InstructionHandle instructionHandle2 = this.findInstruction2(instruction2);
            if (instructionHandle2 == null) {
                throw new BytecodeException("Instruction " + instruction2 + " is not contained in this list.");
            }
            this.delete(instructionHandle, instructionHandle2);
        }

        private final InstructionHandle findInstruction1(Instruction instruction) {
            InstructionHandle instructionHandle = this.start;
            while (instructionHandle != null) {
                if (instructionHandle.instruction == instruction) {
                    return instructionHandle;
                }
                instructionHandle = instructionHandle.next;
            }
            return null;
        }

        private final InstructionHandle findInstruction2(Instruction instruction) {
            InstructionHandle instructionHandle = this.end;
            while (instructionHandle != null) {
                if (instructionHandle.instruction == instruction) {
                    return instructionHandle;
                }
                instructionHandle = instructionHandle.prev;
            }
            return null;
        }

        public boolean contains(InstructionHandle instructionHandle) {
            if (instructionHandle == null) {
                return false;
            }
            InstructionHandle instructionHandle2 = this.start;
            while (instructionHandle2 != null) {
                if (instructionHandle2 == instructionHandle) {
                    return true;
                }
                instructionHandle2 = instructionHandle2.next;
            }
            return false;
        }

        public boolean contains(Instruction instruction) {
            boolean bl = false;
            if (this.findInstruction1(instruction) != null) {
                bl = true;
            }
            return bl;
        }

        public void setPositions() {
            this.setPositions(false);
        }

        public void setPositions(boolean bl) {
            Instruction instruction;
            InstructionHandle instructionHandle;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int[] nArray = new int[this.length];
            if (bl) {
                instructionHandle = this.start;
                while (instructionHandle != null) {
                    instruction = instructionHandle.instruction;
                    if (instruction instanceof BranchInstruction) {
                        Instruction instruction2 = ((BranchInstruction)instruction).getTarget().instruction;
                        if (!this.contains(instruction2)) {
                            throw new BytecodeException("Branch target of " + jq_ClassFileConstants.OPCODE_NAMES[instruction.opcode] + ':' + instruction2 + " not in instruction list");
                        }
                        if (instruction instanceof Select) {
                            List list = ((Select)instruction).getTargets();
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                instruction2 = (Instruction)iterator.next();
                                if (this.contains(instruction2)) continue;
                                throw new BytecodeException("Branch target of " + jq_ClassFileConstants.OPCODE_NAMES[instruction.opcode] + ':' + instruction2 + " not in instruction list");
                            }
                        }
                        if (!(instructionHandle instanceof BranchHandle)) {
                            throw new BytecodeException("Branch instruction " + jq_ClassFileConstants.OPCODE_NAMES[instruction.opcode] + ':' + instruction2 + " not contained in BranchHandle.");
                        }
                    }
                    instructionHandle = instructionHandle.next;
                }
            }
            instructionHandle = this.start;
            while (instructionHandle != null) {
                instruction = instructionHandle.instruction;
                instructionHandle.setPosition(n3);
                nArray[n4++] = n3;
                switch (instruction.getOpcode()) {
                    case 167: 
                    case 168: {
                        n += 2;
                        break;
                    }
                    case 170: 
                    case 171: {
                        n += 3;
                    }
                }
                n3 += instruction.getLength();
                instructionHandle = instructionHandle.next;
            }
            instructionHandle = this.start;
            while (instructionHandle != null) {
                n2 += instructionHandle.updatePosition(n2, n);
                instructionHandle = instructionHandle.next;
            }
            n4 = 0;
            n3 = 0;
            instructionHandle = this.start;
            while (instructionHandle != null) {
                instruction = instructionHandle.instruction;
                instructionHandle.setPosition(n3);
                nArray[n4++] = n3;
                n3 += instruction.getLength();
                instructionHandle = instructionHandle.next;
            }
            this.byte_positions = new int[n4];
            System.arraycopy(nArray, 0, this.byte_positions, 0, n4);
        }

        public byte[] getByteCode() {
            this.setPositions();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                InstructionHandle instructionHandle = this.start;
                while (instructionHandle != null) {
                    Instruction instruction = instructionHandle.instruction;
                    instruction.dump(dataOutputStream);
                    instructionHandle = instructionHandle.next;
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                return null;
            }
            return byteArrayOutputStream.toByteArray();
        }

        public List getInstructions(jq_ConstantPool jq_ConstantPool2) {
            byte[] byArray = this.getByteCode();
            ByteSequence byteSequence = new ByteSequence(byArray);
            ArrayList<Instruction> arrayList = new ArrayList<Instruction>(byArray.length);
            try {
                while (byteSequence.available() > 0) {
                    arrayList.add(Instruction.readInstruction(jq_ConstantPool2, byteSequence));
                }
            }
            catch (IOException iOException) {
                throw new BytecodeException(iOException.toString());
            }
            return arrayList;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            InstructionHandle instructionHandle = this.start;
            while (instructionHandle != null) {
                stringBuffer.append(instructionHandle.toString(bl) + Strings.lineSep);
                instructionHandle = instructionHandle.next;
            }
            return stringBuffer.toString();
        }

        public Enumeration elements() {
            return new Enumeration(this){
                private InstructionHandle ih;
                final /* synthetic */ InstructionList this$0;

                public final Object nextElement() {
                    if (this.ih == null) {
                        throw new NoSuchElementException();
                    }
                    InstructionHandle instructionHandle = this.ih;
                    this.ih = this.ih.next;
                    return instructionHandle;
                }

                public final boolean hasMoreElements() {
                    boolean bl = false;
                    if (this.ih != null) {
                        bl = true;
                    }
                    return bl;
                }

                private final /* synthetic */ void this() {
                    this.ih = InstructionList.access$0(this.this$0);
                }
                {
                    this.this$0 = instructionList;
                    this.this();
                }
            };
        }

        public ListIterator iterator() {
            return new ListIterator(this){
                private InstructionHandle lastReturned;
                private InstructionHandle next;
                private int nextIndex;
                final /* synthetic */ InstructionList this$0;

                public final boolean hasNext() {
                    boolean bl = false;
                    if (this.nextIndex != InstructionList.access$1(this.this$0)) {
                        bl = true;
                    }
                    return bl;
                }

                public final Object next() {
                    if (this.nextIndex == InstructionList.access$1(this.this$0)) {
                        throw new NoSuchElementException();
                    }
                    this.lastReturned = this.next;
                    this.next = this.next.next;
                    ++this.nextIndex;
                    return this.lastReturned;
                }

                public final boolean hasPrevious() {
                    boolean bl = false;
                    if (this.nextIndex != 0) {
                        bl = true;
                    }
                    return bl;
                }

                public final Object previous() {
                    if (this.nextIndex == 0) {
                        throw new NoSuchElementException();
                    }
                    this.next = this.nextIndex == InstructionList.access$1(this.this$0) ? InstructionList.access$2(this.this$0) : this.next.prev;
                    --this.nextIndex;
                    this.lastReturned = this.next;
                    return this.lastReturned;
                }

                public final int nextIndex() {
                    return this.nextIndex;
                }

                public final int previousIndex() {
                    return this.nextIndex - 1;
                }

                public final void remove() {
                    if (this.lastReturned == null) {
                        throw new IllegalStateException("remove or add called before remove");
                    }
                    if (this.next == this.lastReturned) {
                        this.next = this.lastReturned.next;
                    } else {
                        --this.nextIndex;
                    }
                    try {
                        this.this$0.delete(this.lastReturned);
                    }
                    catch (TargetLostException targetLostException) {
                        throw new IllegalStateException("Target lost: " + targetLostException);
                    }
                    this.lastReturned = null;
                }

                public final void set(Object object) {
                    InstructionHandle instructionHandle;
                    if (this.lastReturned == null) {
                        throw new IllegalStateException("remove or add called before set");
                    }
                    if (object instanceof BranchInstruction) {
                        instructionHandle = this.this$0.insert(this.lastReturned, (BranchInstruction)object);
                    } else if (object instanceof Instruction) {
                        instructionHandle = this.this$0.insert(this.lastReturned, (Instruction)object);
                    } else {
                        InstructionList instructionList = new InstructionList();
                        InstructionList.access$3(instructionList, (InstructionHandle)object);
                        instructionHandle = this.this$0.insert(this.lastReturned, instructionList);
                    }
                    if (this.lastReturned == this.next) {
                        this.next = instructionHandle;
                    }
                    this.this$0.redirectBranches(this.lastReturned, instructionHandle);
                    try {
                        this.this$0.delete(this.lastReturned);
                    }
                    catch (TargetLostException targetLostException) {
                        throw new IllegalStateException("Target lost: " + targetLostException);
                    }
                    this.lastReturned = instructionHandle;
                }

                public final void add(Object object) {
                    if (this.lastReturned == null) {
                        throw new IllegalStateException("remove or add called before add");
                    }
                    ++this.nextIndex;
                    if (object instanceof BranchInstruction) {
                        this.this$0.insert(this.next, (BranchInstruction)object);
                    } else if (object instanceof Instruction) {
                        this.this$0.insert(this.next, (Instruction)object);
                    } else {
                        InstructionList instructionList = new InstructionList();
                        InstructionList.access$3(instructionList, (InstructionHandle)object);
                        this.this$0.insert(this.next, instructionList);
                    }
                    this.lastReturned = null;
                }

                private final /* synthetic */ void this() {
                    this.lastReturned = InstructionList.access$0(this.this$0);
                    this.next = InstructionList.access$0(this.this$0);
                    this.nextIndex = 0;
                }
                {
                    this.this$0 = instructionList;
                    this.this();
                }
            };
        }

        public List getInstructionHandles() {
            ArrayList<InstructionHandle> arrayList = new ArrayList<InstructionHandle>(this.length);
            if (this.byte_positions.length != this.length) {
                this.byte_positions = new int[this.length];
            }
            InstructionHandle instructionHandle = this.start;
            int n = 0;
            while (n < this.length) {
                arrayList.add(instructionHandle);
                this.byte_positions[n] = instructionHandle.getPosition();
                instructionHandle = instructionHandle.next;
                ++n;
            }
            return arrayList;
        }

        public int[] getInstructionPositions() {
            return this.byte_positions;
        }

        public InstructionList copy() {
            Instruction instruction;
            Serializable serializable;
            HashMap<InstructionHandle, InstructionHandle> hashMap = new HashMap<InstructionHandle, InstructionHandle>();
            InstructionList instructionList = new InstructionList();
            InstructionHandle instructionHandle = this.start;
            while (instructionHandle != null) {
                serializable = instructionHandle.instruction;
                instruction = serializable.copy();
                if (instruction instanceof BranchInstruction) {
                    hashMap.put(instructionHandle, instructionList.append((BranchInstruction)instruction));
                } else {
                    hashMap.put(instructionHandle, instructionList.append(instruction));
                }
                instructionHandle = instructionHandle.next;
            }
            instructionHandle = this.start;
            serializable = instructionList.start;
            while (instructionHandle != null) {
                instruction = instructionHandle.instruction;
                Instruction instruction2 = ((InstructionHandle)serializable).instruction;
                if (instruction instanceof BranchInstruction) {
                    BranchInstruction branchInstruction = (BranchInstruction)instruction;
                    BranchInstruction branchInstruction2 = (BranchInstruction)instruction2;
                    InstructionHandle instructionHandle2 = branchInstruction.getTarget();
                    branchInstruction2.setTarget((InstructionHandle)hashMap.get(instructionHandle2));
                    if (branchInstruction instanceof Select) {
                        Select select = (Select)branchInstruction;
                        Select select2 = (Select)branchInstruction2;
                        List list = select.getTargets();
                        int n = 0;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            select2.setTarget(n, (InstructionHandle)hashMap.get(iterator.next()));
                            ++n;
                        }
                    }
                }
                instructionHandle = instructionHandle.next;
                serializable = ((InstructionHandle)serializable).next;
            }
            return instructionList;
        }

        private final void clear() {
            this.end = null;
            this.start = null;
            this.length = 0;
        }

        public void dispose() {
            InstructionHandle instructionHandle = this.end;
            while (instructionHandle != null) {
                instructionHandle.dispose();
                instructionHandle = instructionHandle.prev;
            }
            this.clear();
        }

        public InstructionHandle getStart() {
            return this.start;
        }

        public InstructionHandle getEnd() {
            return this.end;
        }

        public int getLength() {
            return this.length;
        }

        public int size() {
            return this.length;
        }

        public void redirectBranches(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
            InstructionHandle instructionHandle3 = this.start;
            while (instructionHandle3 != null) {
                Instruction instruction = instructionHandle3.getInstruction();
                if (instruction instanceof BranchInstruction) {
                    BranchInstruction branchInstruction = (BranchInstruction)instruction;
                    InstructionHandle instructionHandle4 = branchInstruction.getTarget();
                    if (instructionHandle4 == instructionHandle) {
                        branchInstruction.setTarget(instructionHandle2);
                    }
                    if (branchInstruction instanceof Select) {
                        List list = ((Select)branchInstruction).getTargets();
                        Select select = (Select)branchInstruction;
                        int n = 0;
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            if (iterator.next() == instructionHandle) {
                                select.setTarget(n, instructionHandle2);
                            }
                            ++n;
                        }
                    }
                }
                instructionHandle3 = instructionHandle3.next;
            }
        }

        public void redirectExceptionHandlers(CodeException[] codeExceptionArray, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
            int n = 0;
            while (n < codeExceptionArray.length) {
                if (codeExceptionArray[n].getStartPC() == instructionHandle) {
                    codeExceptionArray[n].setStartPC(instructionHandle2);
                }
                if (codeExceptionArray[n].getEndPC() == instructionHandle) {
                    codeExceptionArray[n].setEndPC(instructionHandle2);
                }
                if (codeExceptionArray[n].getHandlerPC() == instructionHandle) {
                    codeExceptionArray[n].setHandlerPC(instructionHandle2);
                }
                ++n;
            }
        }

        public void addObserver(InstructionListObserver instructionListObserver) {
            if (this.observers == null) {
                this.observers = new LinkedList();
            }
            this.observers.add(instructionListObserver);
        }

        public void removeObserver(InstructionListObserver instructionListObserver) {
            if (this.observers != null) {
                this.observers.remove(instructionListObserver);
            }
        }

        public void update() {
            if (this.observers != null) {
                Iterator iterator = this.observers.iterator();
                while (iterator.hasNext()) {
                    ((InstructionListObserver)iterator.next()).notify(this);
                }
            }
        }

        public void accept(Visitor visitor) {
            InstructionHandle instructionHandle = this.start;
            while (instructionHandle != null) {
                instructionHandle.accept(visitor);
                instructionHandle = instructionHandle.next;
            }
        }

        static /* synthetic */ InstructionHandle access$0(InstructionList instructionList) {
            return instructionList.start;
        }

        static /* synthetic */ int access$1(InstructionList instructionList) {
            return instructionList.length;
        }

        static /* synthetic */ InstructionHandle access$2(InstructionList instructionList) {
            return instructionList.end;
        }

        static /* synthetic */ void access$3(InstructionList instructionList, InstructionHandle instructionHandle) {
            instructionList.append(instructionHandle);
        }

        private final /* synthetic */ void this() {
            this.start = null;
            this.end = null;
            this.length = 0;
        }

        public InstructionList() {
            this.this();
        }

        public InstructionList(Instruction instruction) {
            this.this();
            this.append(instruction);
        }

        public InstructionList(BranchInstruction branchInstruction) {
            this.this();
            this.append(branchInstruction);
        }

        public InstructionList(CompoundInstruction compoundInstruction) {
            this.this();
            this.append(compoundInstruction.getInstructionList());
        }

        public InstructionList(jq_Method jq_Method2) {
            this(jq_Method2.getDeclaringClass().getCP(), jq_Method2.getBytecode());
        }

        public InstructionList(jq_ConstantPool jq_ConstantPool2, byte[] byArray) {
            Instruction instruction;
            int n;
            this.this();
            ByteSequence byteSequence = new ByteSequence(byArray);
            ArrayList<InstructionHandle> arrayList = new ArrayList<InstructionHandle>(byArray.length);
            int[] nArray = new int[byArray.length];
            int n2 = 0;
            try {
                while (byteSequence.available() > 0) {
                    nArray[n2] = n = byteSequence.getIndex();
                    instruction = Instruction.readInstruction(jq_ConstantPool2, byteSequence);
                    InstructionHandle instructionHandle = instruction instanceof BranchInstruction ? this.append((BranchInstruction)instruction) : this.append(instruction);
                    instructionHandle.setPosition(n);
                    arrayList.add(instructionHandle);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new BytecodeException(iOException.toString());
            }
            this.byte_positions = new int[n2];
            System.arraycopy(nArray, 0, this.byte_positions, 0, n2);
            n = 0;
            while (n < n2) {
                if (arrayList.get(n) instanceof BranchHandle) {
                    instruction = (BranchInstruction)((BranchHandle)arrayList.get((int)n)).instruction;
                    int n3 = ((BranchInstruction)instruction).position + ((BranchInstruction)instruction).getIndex();
                    InstructionHandle instructionHandle = InstructionList.findHandle(arrayList, this.byte_positions, n3);
                    if (instructionHandle == null) {
                        throw new BytecodeException("Couldn't find target " + n3 + " for branch: " + instruction);
                    }
                    ((BranchInstruction)instruction).setTarget(instructionHandle);
                    if (instruction instanceof Select) {
                        Select select = (Select)instruction;
                        int[] nArray2 = select.getIndices();
                        int n4 = 0;
                        while (n4 < nArray2.length) {
                            n3 = ((BranchInstruction)instruction).position + nArray2[n4];
                            instructionHandle = InstructionList.findHandle(arrayList, this.byte_positions, n3);
                            if (instructionHandle == null) {
                                throw new BytecodeException("Couldn't find target " + n3 + " for switch: " + instruction);
                            }
                            select.setTarget(n4, instructionHandle);
                            ++n4;
                        }
                    }
                }
                ++n;
            }
        }
    }

    public static final class TargetLostException
    extends Exception {
        private List targets;

        public final List getTargets() {
            return this.targets;
        }

        TargetLostException(List list, String string) {
            super(string);
            this.targets = list;
        }
    }

    public static class ARRAYLENGTH
    extends Instruction
    implements ExceptionThrower,
    StackProducer {
        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitStackProducer(this);
            visitor.visitARRAYLENGTH(this);
        }

        public ARRAYLENGTH() {
            super((short)190, (short)1);
        }
    }

    public static class AALOAD
    extends ArrayInstruction
    implements StackProducer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitAALOAD(this);
        }

        public AALOAD() {
            super((short)50);
        }
    }

    public static class AASTORE
    extends ArrayInstruction
    implements StackConsumer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitAASTORE(this);
        }

        public AASTORE() {
            super((short)83);
        }
    }

    public static class ACONST_NULL
    extends Instruction
    implements StackProducer,
    PushInstruction,
    TypedInstruction {
        public jq_Type getType() {
            return jq_Reference.jq_NullType.NULL_TYPE;
        }

        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitPushInstruction(this);
            visitor.visitTypedInstruction(this);
            visitor.visitACONST_NULL(this);
        }

        public ACONST_NULL() {
            super((short)1, (short)1);
        }
    }

    public static class ALOAD
    extends LoadInstruction
    implements StackProducer,
    PushInstruction,
    TypedInstruction {
        public void accept(Visitor visitor) {
            super.accept(visitor);
            visitor.visitALOAD(this);
        }

        ALOAD() {
            super((short)25, (short)42);
        }

        public ALOAD(int n) {
            super((short)25, (short)42, n);
        }
    }

    public static class ANEWARRAY
    extends CPInstruction
    implements AllocationInstruction,
    ExceptionThrower,
    StackProducer,
    TypedInstruction {
        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitAllocationInstruction(this);
            visitor.visitExceptionThrower(this);
            visitor.visitStackProducer(this);
            visitor.visitTypedInstruction(this);
            visitor.visitCPInstruction(this);
            visitor.visitANEWARRAY(this);
        }

        ANEWARRAY() {
        }

        public ANEWARRAY(jq_Array jq_Array2) {
            super((short)189, jq_Array2);
        }
    }

    public static class ARETURN
    extends ReturnInstruction
    implements TypedInstruction,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackConsumer(this);
            visitor.visitReturnInstruction(this);
            visitor.visitARETURN(this);
        }

        public ARETURN() {
            super((short)176);
        }
    }

    public static class ASTORE
    extends StoreInstruction {
        public void accept(Visitor visitor) {
            super.accept(visitor);
            visitor.visitASTORE(this);
        }

        ASTORE() {
            super((short)58, (short)75);
        }

        public ASTORE(int n) {
            super((short)58, (short)75, n);
        }
    }

    public static class ATHROW
    extends Instruction
    implements UnconditionalBranch,
    ExceptionThrower {
        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitUnconditionalBranch(this);
            visitor.visitExceptionThrower(this);
            visitor.visitATHROW(this);
        }

        public ATHROW() {
            super((short)191, (short)1);
        }
    }

    public static class BALOAD
    extends ArrayInstruction
    implements StackProducer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitBALOAD(this);
        }

        public BALOAD() {
            super((short)51);
        }
    }

    public static class BASTORE
    extends ArrayInstruction
    implements StackConsumer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitBASTORE(this);
        }

        public BASTORE() {
            super((short)84);
        }
    }

    public static class BIPUSH
    extends Instruction
    implements PushInstruction,
    StackProducer,
    TypedInstruction,
    ConstantPushInstruction {
        private byte b;

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            super.dump(dataOutputStream);
            dataOutputStream.writeByte(this.b);
        }

        public String toString(boolean bl) {
            return super.toString(bl) + ' ' + this.b;
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.length = (short)2;
            this.b = byteSequence.readByte();
        }

        public Number getValue() {
            return new Integer(this.b);
        }

        public jq_Type getType() {
            return jq_Primitive.BYTE;
        }

        public void accept(Visitor visitor) {
            visitor.visitPushInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitTypedInstruction(this);
            visitor.visitConstantPushInstruction(this);
            visitor.visitBIPUSH(this);
        }

        BIPUSH() {
        }

        public BIPUSH(byte by) {
            super((short)16, (short)2);
            this.b = by;
        }
    }

    public static class BREAKPOINT
    extends Instruction {
        public void accept(Visitor visitor) {
            visitor.visitBREAKPOINT(this);
        }

        public BREAKPOINT() {
            super((short)202, (short)1);
        }
    }

    public static class CALOAD
    extends ArrayInstruction
    implements StackProducer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitCALOAD(this);
        }

        public CALOAD() {
            super((short)52);
        }
    }

    public static class CASTORE
    extends ArrayInstruction
    implements StackConsumer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitCASTORE(this);
        }

        public CASTORE() {
            super((short)85);
        }
    }

    public static class CHECKCAST
    extends CPInstruction
    implements LoadClass,
    ExceptionThrower,
    StackProducer,
    StackConsumer,
    TypedInstruction {
        public Set getExceptions() {
            return null;
        }

        public jq_Class getLoadClassType() {
            jq_Type jq_Type2 = this.getType();
            if (jq_Type2 instanceof jq_Array) {
                jq_Type2 = ((jq_Array)jq_Type2).getInnermostElementType();
            }
            return jq_Type2 instanceof jq_Class ? (jq_Class)jq_Type2 : null;
        }

        public void accept(Visitor visitor) {
            visitor.visitLoadClass(this);
            visitor.visitExceptionThrower(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitTypedInstruction(this);
            visitor.visitCPInstruction(this);
            visitor.visitCHECKCAST(this);
        }

        CHECKCAST() {
        }

        public CHECKCAST(jq_Type jq_Type2) {
            super((short)192, jq_Type2);
        }
    }

    public static class D2F
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitD2F(this);
        }

        public D2F() {
            super((short)144);
        }
    }

    public static class D2I
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitD2I(this);
        }

        public D2I() {
            super((short)142);
        }
    }

    public static class D2L
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitD2L(this);
        }

        public D2L() {
            super((short)143);
        }
    }

    public static class DADD
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitDADD(this);
        }

        public DADD() {
            super((short)99);
        }
    }

    public static class DALOAD
    extends ArrayInstruction
    implements StackProducer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitDALOAD(this);
        }

        public DALOAD() {
            super((short)49);
        }
    }

    public static class DASTORE
    extends ArrayInstruction
    implements StackConsumer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitDASTORE(this);
        }

        public DASTORE() {
            super((short)82);
        }
    }

    public static class DCMPG
    extends Instruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public jq_Type getType() {
            return jq_Primitive.DOUBLE;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitDCMPG(this);
        }

        public DCMPG() {
            super((short)152, (short)1);
        }
    }

    public static class DCMPL
    extends Instruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public jq_Type getType() {
            return jq_Primitive.DOUBLE;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitDCMPL(this);
        }

        public DCMPL() {
            super((short)151, (short)1);
        }
    }

    public static class DCONST
    extends Instruction
    implements PushInstruction,
    StackProducer,
    TypedInstruction,
    ConstantPushInstruction {
        private double value;

        public Number getValue() {
            return new Double(this.value);
        }

        public jq_Type getType() {
            return jq_Primitive.DOUBLE;
        }

        public void accept(Visitor visitor) {
            visitor.visitPushInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitTypedInstruction(this);
            visitor.visitConstantPushInstruction(this);
            visitor.visitDCONST(this);
        }

        DCONST() {
        }

        public DCONST(double d) {
            super((short)14, (short)1);
            if (d == 0.0) {
                this.opcode = (short)14;
            } else if (d == 1.0) {
                this.opcode = (short)15;
            } else {
                throw new BytecodeException("DCONST can be used only for 0.0 and 1.0: " + d);
            }
            this.value = d;
        }
    }

    public static class DDIV
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitDDIV(this);
        }

        public DDIV() {
            super((short)111);
        }
    }

    public static class DLOAD
    extends LoadInstruction {
        public void accept(Visitor visitor) {
            super.accept(visitor);
            visitor.visitDLOAD(this);
        }

        DLOAD() {
            super((short)24, (short)38);
        }

        public DLOAD(int n) {
            super((short)24, (short)38, n);
        }
    }

    public static class DMUL
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitDMUL(this);
        }

        public DMUL() {
            super((short)107);
        }
    }

    public static class DNEG
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitDNEG(this);
        }

        public DNEG() {
            super((short)119);
        }
    }

    public static class DREM
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitDREM(this);
        }

        public DREM() {
            super((short)115);
        }
    }

    public static class DRETURN
    extends ReturnInstruction
    implements TypedInstruction,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackConsumer(this);
            visitor.visitReturnInstruction(this);
            visitor.visitDRETURN(this);
        }

        public DRETURN() {
            super((short)175);
        }
    }

    public static class DSTORE
    extends StoreInstruction {
        public void accept(Visitor visitor) {
            super.accept(visitor);
            visitor.visitDSTORE(this);
        }

        DSTORE() {
            super((short)57, (short)71);
        }

        public DSTORE(int n) {
            super((short)57, (short)71, n);
        }
    }

    public static class DSUB
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitDSUB(this);
        }

        public DSUB() {
            super((short)103);
        }
    }

    public static class DUP2
    extends StackInstruction
    implements StackProducer,
    PushInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitPushInstruction(this);
            visitor.visitStackInstruction(this);
            visitor.visitDUP2(this);
        }

        public DUP2() {
            super((short)92);
        }
    }

    public static class DUP2_X1
    extends StackInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackInstruction(this);
            visitor.visitDUP2_X1(this);
        }

        public DUP2_X1() {
            super((short)93);
        }
    }

    public static class DUP2_X2
    extends StackInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackInstruction(this);
            visitor.visitDUP2_X2(this);
        }

        public DUP2_X2() {
            super((short)94);
        }
    }

    public static class DUP
    extends StackInstruction
    implements StackProducer,
    PushInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitPushInstruction(this);
            visitor.visitStackInstruction(this);
            visitor.visitDUP(this);
        }

        public DUP() {
            super((short)89);
        }
    }

    public static class DUP_X1
    extends StackInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackInstruction(this);
            visitor.visitDUP_X1(this);
        }

        public DUP_X1() {
            super((short)90);
        }
    }

    public static class DUP_X2
    extends StackInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackInstruction(this);
            visitor.visitDUP_X2(this);
        }

        public DUP_X2() {
            super((short)91);
        }
    }

    public static class F2D
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitF2D(this);
        }

        public F2D() {
            super((short)141);
        }
    }

    public static class F2I
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitF2I(this);
        }

        public F2I() {
            super((short)139);
        }
    }

    public static class F2L
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitF2L(this);
        }

        public F2L() {
            super((short)140);
        }
    }

    public static class FADD
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitFADD(this);
        }

        public FADD() {
            super((short)98);
        }
    }

    public static class FALOAD
    extends ArrayInstruction
    implements StackProducer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitFALOAD(this);
        }

        public FALOAD() {
            super((short)48);
        }
    }

    public static class FASTORE
    extends ArrayInstruction
    implements StackConsumer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitFASTORE(this);
        }

        public FASTORE() {
            super((short)81);
        }
    }

    public static class FCMPG
    extends Instruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public jq_Type getType() {
            return jq_Primitive.FLOAT;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitFCMPG(this);
        }

        public FCMPG() {
            super((short)150, (short)1);
        }
    }

    public static class FCMPL
    extends Instruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public jq_Type getType() {
            return jq_Primitive.FLOAT;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitFCMPL(this);
        }

        public FCMPL() {
            super((short)149, (short)1);
        }
    }

    public static class FCONST
    extends Instruction
    implements PushInstruction,
    StackProducer,
    TypedInstruction,
    ConstantPushInstruction {
        private float value;

        public Number getValue() {
            return new Float(this.value);
        }

        public jq_Type getType() {
            return jq_Primitive.FLOAT;
        }

        public void accept(Visitor visitor) {
            visitor.visitPushInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitTypedInstruction(this);
            visitor.visitConstantPushInstruction(this);
            visitor.visitFCONST(this);
        }

        FCONST() {
        }

        public FCONST(float f) {
            super((short)11, (short)1);
            if ((double)f == 0.0) {
                this.opcode = (short)11;
            } else if ((double)f == 1.0) {
                this.opcode = (short)12;
            } else if ((double)f == (double)2) {
                this.opcode = (short)13;
            } else {
                throw new BytecodeException("FCONST can be used only for 0.0, 1.0 and 2.0: " + f);
            }
            this.value = f;
        }
    }

    public static class FDIV
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitFDIV(this);
        }

        public FDIV() {
            super((short)110);
        }
    }

    public static class FLOAD
    extends LoadInstruction {
        public void accept(Visitor visitor) {
            super.accept(visitor);
            visitor.visitFLOAD(this);
        }

        FLOAD() {
            super((short)23, (short)34);
        }

        public FLOAD(int n) {
            super((short)23, (short)34, n);
        }
    }

    public static class FMUL
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitFMUL(this);
        }

        public FMUL() {
            super((short)106);
        }
    }

    public static class FNEG
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitFNEG(this);
        }

        public FNEG() {
            super((short)118);
        }
    }

    public static class FREM
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitFREM(this);
        }

        public FREM() {
            super((short)114);
        }
    }

    public static class FRETURN
    extends ReturnInstruction
    implements TypedInstruction,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackConsumer(this);
            visitor.visitReturnInstruction(this);
            visitor.visitFRETURN(this);
        }

        public FRETURN() {
            super((short)174);
        }
    }

    public static class FSTORE
    extends StoreInstruction {
        public void accept(Visitor visitor) {
            super.accept(visitor);
            visitor.visitFSTORE(this);
        }

        FSTORE() {
            super((short)56, (short)67);
        }

        public FSTORE(int n) {
            super((short)56, (short)67, n);
        }
    }

    public static class FSUB
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitFSUB(this);
        }

        public FSUB() {
            super((short)102);
        }
    }

    public static class GETFIELD
    extends FieldInstruction
    implements ExceptionThrower,
    StackConsumer,
    StackProducer,
    TypedInstruction,
    LoadClass {
        public int produceStack() {
            return this.getFieldSize();
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.o = jq_ConstantPool2.getAsInstanceField((char)byteSequence.readUnsignedShort());
            this.length = (short)3;
        }

        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitStackConsumer(this);
            visitor.visitStackProducer(this);
            visitor.visitTypedInstruction(this);
            visitor.visitLoadClass(this);
            visitor.visitCPInstruction(this);
            visitor.visitFieldOrMethod(this);
            visitor.visitFieldInstruction(this);
            visitor.visitGETFIELD(this);
        }

        GETFIELD() {
        }

        public GETFIELD(jq_InstanceField jq_InstanceField2) {
            super((short)180, jq_InstanceField2);
        }
    }

    public static class GETSTATIC
    extends FieldInstruction
    implements ExceptionThrower,
    StackProducer,
    PushInstruction,
    TypedInstruction,
    LoadClass {
        public int produceStack() {
            return this.getFieldSize();
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.o = jq_ConstantPool2.getAsStaticField((char)byteSequence.readUnsignedShort());
            this.length = (short)3;
        }

        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitStackProducer(this);
            visitor.visitPushInstruction(this);
            visitor.visitTypedInstruction(this);
            visitor.visitLoadClass(this);
            visitor.visitCPInstruction(this);
            visitor.visitFieldOrMethod(this);
            visitor.visitFieldInstruction(this);
            visitor.visitGETSTATIC(this);
        }

        GETSTATIC() {
        }

        public GETSTATIC(jq_StaticField jq_StaticField2) {
            super((short)178, jq_StaticField2);
        }
    }

    public static class GOTO
    extends GotoInstruction
    implements VariableLengthInstruction,
    UnconditionalBranch {
        public void dump(DataOutputStream dataOutputStream) throws IOException {
            this.index = this.getTargetOffset();
            if (this.opcode == 167) {
                super.dump(dataOutputStream);
            } else {
                this.index = this.getTargetOffset();
                dataOutputStream.writeByte(this.opcode);
                dataOutputStream.writeInt(this.index);
            }
        }

        protected int updatePosition(int n, int n2) {
            int n3 = this.getTargetOffset();
            this.position += n;
            if (Math.abs(n3) >= Short.MAX_VALUE - n2) {
                this.opcode = (short)200;
                this.length = (short)5;
                return 2;
            }
            return 0;
        }

        public void accept(Visitor visitor) {
            visitor.visitVariableLengthInstruction(this);
            visitor.visitUnconditionalBranch(this);
            visitor.visitBranchInstruction(this);
            visitor.visitGotoInstruction(this);
            visitor.visitGOTO(this);
        }

        GOTO() {
        }

        public GOTO(InstructionHandle instructionHandle) {
            super((short)167, instructionHandle);
        }
    }

    public static class GOTO_W
    extends GotoInstruction
    implements UnconditionalBranch {
        public void dump(DataOutputStream dataOutputStream) throws IOException {
            this.index = this.getTargetOffset();
            dataOutputStream.writeByte(this.opcode);
            dataOutputStream.writeInt(this.index);
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.index = byteSequence.readInt();
            this.length = (short)5;
        }

        public void accept(Visitor visitor) {
            visitor.visitUnconditionalBranch(this);
            visitor.visitBranchInstruction(this);
            visitor.visitGotoInstruction(this);
            visitor.visitGOTO_W(this);
        }

        GOTO_W() {
        }

        public GOTO_W(InstructionHandle instructionHandle) {
            super((short)200, instructionHandle);
            this.length = (short)5;
        }
    }

    public static class I2B
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitI2B(this);
        }

        public I2B() {
            super((short)145);
        }
    }

    public static class I2C
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitI2C(this);
        }

        public I2C() {
            super((short)146);
        }
    }

    public static class I2D
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitI2D(this);
        }

        public I2D() {
            super((short)135);
        }
    }

    public static class I2F
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitI2F(this);
        }

        public I2F() {
            super((short)134);
        }
    }

    public static class I2L
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitI2L(this);
        }

        public I2L() {
            super((short)133);
        }
    }

    public static class I2S
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitI2S(this);
        }

        public I2S() {
            super((short)147);
        }
    }

    public static class IADD
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitIADD(this);
        }

        public IADD() {
            super((short)96);
        }
    }

    public static class IALOAD
    extends ArrayInstruction
    implements StackProducer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitIALOAD(this);
        }

        public IALOAD() {
            super((short)46);
        }
    }

    public static class IAND
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitIAND(this);
        }

        public IAND() {
            super((short)126);
        }
    }

    public static class IASTORE
    extends ArrayInstruction
    implements StackConsumer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitIASTORE(this);
        }

        public IASTORE() {
            super((short)79);
        }
    }

    public static class ICONST
    extends Instruction
    implements PushInstruction,
    StackProducer,
    TypedInstruction,
    ConstantPushInstruction {
        private int value;

        public Number getValue() {
            return new Integer(this.value);
        }

        public jq_Type getType() {
            return jq_Primitive.INT;
        }

        public void accept(Visitor visitor) {
            visitor.visitPushInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitTypedInstruction(this);
            visitor.visitConstantPushInstruction(this);
            visitor.visitICONST(this);
        }

        ICONST() {
        }

        public ICONST(int n) {
            super((short)3, (short)1);
            if (n < -1 || n > 5) {
                throw new BytecodeException("ICONST can be used only for value between -1 and 5: " + n);
            }
            this.opcode = (short)(3 + n);
            this.value = n;
        }
    }

    public static class IDIV
    extends ArithmeticInstruction
    implements ExceptionThrower,
    TypedInstruction,
    StackProducer,
    StackConsumer {
        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitIDIV(this);
        }

        public IDIV() {
            super((short)108);
        }
    }

    public static class IF_ACMPEQ
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IF_ACMPNE(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIF_ACMPEQ(this);
        }

        IF_ACMPEQ() {
        }

        public IF_ACMPEQ(InstructionHandle instructionHandle) {
            super((short)165, instructionHandle);
        }
    }

    public static class IF_ACMPNE
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IF_ACMPEQ(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIF_ACMPNE(this);
        }

        IF_ACMPNE() {
        }

        public IF_ACMPNE(InstructionHandle instructionHandle) {
            super((short)166, instructionHandle);
        }
    }

    public static class IFEQ
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IFNE(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIFEQ(this);
        }

        IFEQ() {
        }

        public IFEQ(InstructionHandle instructionHandle) {
            super((short)153, instructionHandle);
        }
    }

    public static class IFGE
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IFLT(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIFGE(this);
        }

        IFGE() {
        }

        public IFGE(InstructionHandle instructionHandle) {
            super((short)156, instructionHandle);
        }
    }

    public static class IFGT
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IFLE(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIFGT(this);
        }

        IFGT() {
        }

        public IFGT(InstructionHandle instructionHandle) {
            super((short)157, instructionHandle);
        }
    }

    public static class IF_ICMPEQ
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IF_ICMPNE(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIF_ICMPEQ(this);
        }

        IF_ICMPEQ() {
        }

        public IF_ICMPEQ(InstructionHandle instructionHandle) {
            super((short)159, instructionHandle);
        }
    }

    public static class IF_ICMPGE
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IF_ICMPLT(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIF_ICMPGE(this);
        }

        IF_ICMPGE() {
        }

        public IF_ICMPGE(InstructionHandle instructionHandle) {
            super((short)162, instructionHandle);
        }
    }

    public static class IF_ICMPGT
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IF_ICMPLE(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIF_ICMPGT(this);
        }

        IF_ICMPGT() {
        }

        public IF_ICMPGT(InstructionHandle instructionHandle) {
            super((short)163, instructionHandle);
        }
    }

    public static class IF_ICMPLE
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IF_ICMPGT(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIF_ICMPLE(this);
        }

        IF_ICMPLE() {
        }

        public IF_ICMPLE(InstructionHandle instructionHandle) {
            super((short)164, instructionHandle);
        }
    }

    public static class IF_ICMPLT
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IF_ICMPGE(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIF_ICMPLT(this);
        }

        IF_ICMPLT() {
        }

        public IF_ICMPLT(InstructionHandle instructionHandle) {
            super((short)161, instructionHandle);
        }
    }

    public static class IF_ICMPNE
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IF_ICMPEQ(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIF_ICMPNE(this);
        }

        IF_ICMPNE() {
        }

        public IF_ICMPNE(InstructionHandle instructionHandle) {
            super((short)160, instructionHandle);
        }
    }

    public static class IFLE
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IFGT(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIFLE(this);
        }

        IFLE() {
        }

        public IFLE(InstructionHandle instructionHandle) {
            super((short)158, instructionHandle);
        }
    }

    public static class IFLT
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IFGE(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIFLT(this);
        }

        IFLT() {
        }

        public IFLT(InstructionHandle instructionHandle) {
            super((short)155, instructionHandle);
        }
    }

    public static class IFNE
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IFEQ(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIFNE(this);
        }

        IFNE() {
        }

        public IFNE(InstructionHandle instructionHandle) {
            super((short)154, instructionHandle);
        }
    }

    public static class IFNONNULL
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IFNULL(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIFNONNULL(this);
        }

        IFNONNULL() {
        }

        public IFNONNULL(InstructionHandle instructionHandle) {
            super((short)199, instructionHandle);
        }
    }

    public static class IFNULL
    extends IfInstruction
    implements StackConsumer {
        public IfInstruction negate() {
            return new IFNONNULL(this.target);
        }

        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitIfInstruction(this);
            visitor.visitIFNULL(this);
        }

        IFNULL() {
        }

        public IFNULL(InstructionHandle instructionHandle) {
            super((short)198, instructionHandle);
        }
    }

    public static class IINC
    extends LocalVariableInstruction {
        private boolean wide;
        private int c;

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            if (this.wide) {
                dataOutputStream.writeByte(196);
            }
            dataOutputStream.writeByte(this.opcode);
            if (this.wide) {
                dataOutputStream.writeShort(this.n);
                dataOutputStream.writeShort(this.c);
            } else {
                dataOutputStream.writeByte(this.n);
                dataOutputStream.writeByte(this.c);
            }
        }

        private final void setWide() {
            boolean bl = false;
            if (this.n > Short.MAX_VALUE || Math.abs(this.c) > 127) {
                bl = true;
            }
            this.wide = bl;
            this.length = this.wide ? (short)6 : (short)3;
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.wide = bl;
            if (bl) {
                this.length = (short)6;
                this.n = byteSequence.readUnsignedShort();
                this.c = byteSequence.readShort();
            } else {
                this.length = (short)3;
                this.n = byteSequence.readUnsignedByte();
                this.c = byteSequence.readByte();
            }
        }

        public String toString(boolean bl) {
            return super.toString(bl) + ' ' + this.c;
        }

        public final void setIndex(int n) {
            if (n < 0) {
                throw new BytecodeException("Negative index value: " + n);
            }
            this.n = n;
            this.setWide();
        }

        public final int getIncrement() {
            return this.c;
        }

        public final void setIncrement(int n) {
            this.c = n;
            this.setWide();
        }

        public void accept(Visitor visitor) {
            visitor.visitLocalVariableInstruction(this);
            visitor.visitIINC(this);
        }

        IINC() {
        }

        public IINC(int n, int n2) {
            this.opcode = (short)132;
            this.length = (short)3;
            this.setIndex(n);
            this.setIncrement(n2);
        }
    }

    public static class ILOAD
    extends LoadInstruction {
        public void accept(Visitor visitor) {
            super.accept(visitor);
            visitor.visitILOAD(this);
        }

        ILOAD() {
            super((short)21, (short)26);
        }

        public ILOAD(int n) {
            super((short)21, (short)26, n);
        }
    }

    public static class IMUL
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitIMUL(this);
        }

        public IMUL() {
            super((short)104);
        }
    }

    public static class INEG
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitINEG(this);
        }

        public INEG() {
            super((short)116);
        }
    }

    public static class INSTANCEOF
    extends CPInstruction
    implements LoadClass,
    ExceptionThrower,
    StackProducer,
    StackConsumer,
    TypedInstruction {
        public Set getExceptions() {
            return null;
        }

        public jq_Class getLoadClassType() {
            jq_Type jq_Type2 = this.getType();
            if (jq_Type2 instanceof jq_Array) {
                jq_Type2 = ((jq_Array)jq_Type2).getInnermostElementType();
            }
            return jq_Type2 instanceof jq_Class ? (jq_Class)jq_Type2 : null;
        }

        public void accept(Visitor visitor) {
            visitor.visitLoadClass(this);
            visitor.visitExceptionThrower(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitTypedInstruction(this);
            visitor.visitCPInstruction(this);
            visitor.visitINSTANCEOF(this);
        }

        INSTANCEOF() {
        }

        public INSTANCEOF(jq_Type jq_Type2) {
            super((short)193, jq_Type2);
        }
    }

    public static final class INVOKEINTERFACE
    extends InvokeInstruction
    implements ExceptionThrower,
    TypedInstruction,
    StackConsumer,
    StackProducer,
    LoadClass {
        private int nargs;

        public final void dump(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(this.opcode);
            dataOutputStream.writeShort(this.index);
            dataOutputStream.writeByte(this.nargs);
            dataOutputStream.writeByte(0);
        }

        public final int getNoArguments() {
            return this.nargs;
        }

        public final int getCount() {
            return this.nargs;
        }

        protected final void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.o = jq_ConstantPool2.getAsInstanceMethod((char)byteSequence.readUnsignedShort());
            this.length = (short)5;
            this.nargs = byteSequence.readUnsignedByte();
            byteSequence.readByte();
        }

        public final String toString() {
            return super.toString() + ' ' + this.nargs;
        }

        public final int consumeStack() {
            return this.nargs;
        }

        public final Set getExceptions() {
            return null;
        }

        public final void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitStackConsumer(this);
            visitor.visitStackProducer(this);
            visitor.visitLoadClass(this);
            visitor.visitCPInstruction(this);
            visitor.visitFieldOrMethod(this);
            visitor.visitInvokeInstruction(this);
            visitor.visitINVOKEINTERFACE(this);
        }

        INVOKEINTERFACE() {
        }

        public INVOKEINTERFACE(jq_Method jq_Method2, int n) {
            super((short)185, jq_Method2);
            this.length = (short)5;
            if (n < 1) {
                throw new BytecodeException("Number of arguments must be > 0 " + n);
            }
            this.nargs = n;
        }
    }

    public static class INVOKESPECIAL
    extends InvokeInstruction
    implements ExceptionThrower,
    TypedInstruction,
    StackConsumer,
    StackProducer,
    LoadClass {
        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.o = jq_ConstantPool2.getAsInstanceMethod((char)byteSequence.readUnsignedShort());
            this.length = (short)3;
        }

        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitStackConsumer(this);
            visitor.visitStackProducer(this);
            visitor.visitLoadClass(this);
            visitor.visitCPInstruction(this);
            visitor.visitFieldOrMethod(this);
            visitor.visitInvokeInstruction(this);
            visitor.visitINVOKESPECIAL(this);
        }

        INVOKESPECIAL() {
        }

        public INVOKESPECIAL(jq_Method jq_Method2) {
            super((short)183, jq_Method2);
        }
    }

    public static class INVOKESTATIC
    extends InvokeInstruction
    implements ExceptionThrower,
    TypedInstruction,
    StackConsumer,
    StackProducer,
    LoadClass {
        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.o = jq_ConstantPool2.getAsStaticMethod((char)byteSequence.readUnsignedShort());
            this.length = (short)3;
        }

        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitStackConsumer(this);
            visitor.visitStackProducer(this);
            visitor.visitLoadClass(this);
            visitor.visitCPInstruction(this);
            visitor.visitFieldOrMethod(this);
            visitor.visitInvokeInstruction(this);
            visitor.visitINVOKESTATIC(this);
        }

        INVOKESTATIC() {
        }

        public INVOKESTATIC(jq_Method jq_Method2) {
            super((short)184, jq_Method2);
        }
    }

    public static class INVOKEVIRTUAL
    extends InvokeInstruction
    implements ExceptionThrower,
    TypedInstruction,
    StackConsumer,
    StackProducer,
    LoadClass {
        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.o = jq_ConstantPool2.getAsInstanceMethod((char)byteSequence.readUnsignedShort());
            this.length = (short)3;
        }

        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitStackConsumer(this);
            visitor.visitStackProducer(this);
            visitor.visitLoadClass(this);
            visitor.visitCPInstruction(this);
            visitor.visitFieldOrMethod(this);
            visitor.visitInvokeInstruction(this);
            visitor.visitINVOKEVIRTUAL(this);
        }

        INVOKEVIRTUAL() {
        }

        public INVOKEVIRTUAL(jq_Method jq_Method2) {
            super((short)182, jq_Method2);
        }
    }

    public static class IOR
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitIOR(this);
        }

        public IOR() {
            super((short)128);
        }
    }

    public static class IREM
    extends ArithmeticInstruction
    implements ExceptionThrower,
    TypedInstruction,
    StackProducer,
    StackConsumer {
        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitIREM(this);
        }

        public IREM() {
            super((short)112);
        }
    }

    public static class IRETURN
    extends ReturnInstruction
    implements TypedInstruction,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackConsumer(this);
            visitor.visitReturnInstruction(this);
            visitor.visitIRETURN(this);
        }

        public IRETURN() {
            super((short)172);
        }
    }

    public static class ISHL
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitISHL(this);
        }

        public ISHL() {
            super((short)120);
        }
    }

    public static class ISHR
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitISHR(this);
        }

        public ISHR() {
            super((short)122);
        }
    }

    public static class ISTORE
    extends StoreInstruction {
        public void accept(Visitor visitor) {
            super.accept(visitor);
            visitor.visitISTORE(this);
        }

        ISTORE() {
            super((short)54, (short)59);
        }

        public ISTORE(int n) {
            super((short)54, (short)59, n);
        }
    }

    public static class ISUB
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitISUB(this);
        }

        public ISUB() {
            super((short)100);
        }
    }

    public static class IUSHR
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitIUSHR(this);
        }

        public IUSHR() {
            super((short)124);
        }
    }

    public static class IXOR
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitIXOR(this);
        }

        public IXOR() {
            super((short)130);
        }
    }

    public static class JSR
    extends JsrInstruction
    implements StackProducer,
    VariableLengthInstruction {
        public void dump(DataOutputStream dataOutputStream) throws IOException {
            this.index = this.getTargetOffset();
            if (this.opcode == 168) {
                super.dump(dataOutputStream);
            } else {
                this.index = this.getTargetOffset();
                dataOutputStream.writeByte(this.opcode);
                dataOutputStream.writeInt(this.index);
            }
        }

        protected int updatePosition(int n, int n2) {
            int n3 = this.getTargetOffset();
            this.position += n;
            if (Math.abs(n3) >= Short.MAX_VALUE - n2) {
                this.opcode = (short)201;
                this.length = (short)5;
                return 2;
            }
            return 0;
        }

        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitVariableLengthInstruction(this);
            visitor.visitBranchInstruction(this);
            visitor.visitJsrInstruction(this);
            visitor.visitJSR(this);
        }

        JSR() {
        }

        public JSR(InstructionHandle instructionHandle) {
            super((short)168, instructionHandle);
        }
    }

    public static class JSR_W
    extends JsrInstruction
    implements StackProducer {
        public void dump(DataOutputStream dataOutputStream) throws IOException {
            this.index = this.getTargetOffset();
            dataOutputStream.writeByte(this.opcode);
            dataOutputStream.writeInt(this.index);
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.index = byteSequence.readInt();
            this.length = (short)5;
        }

        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitJsrInstruction(this);
            visitor.visitJSR_W(this);
        }

        JSR_W() {
        }

        public JSR_W(InstructionHandle instructionHandle) {
            super((short)201, instructionHandle);
            this.length = (short)5;
        }
    }

    public static class L2D
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitL2D(this);
        }

        public L2D() {
            super((short)138);
        }
    }

    public static class L2F
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitL2F(this);
        }

        public L2F() {
            super((short)137);
        }
    }

    public static class L2I
    extends ConversionInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitConversionInstruction(this);
            visitor.visitL2I(this);
        }

        public L2I() {
            super((short)136);
        }
    }

    public static class LADD
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLADD(this);
        }

        public LADD() {
            super((short)97);
        }
    }

    public static class LALOAD
    extends ArrayInstruction
    implements StackProducer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitLALOAD(this);
        }

        public LALOAD() {
            super((short)47);
        }
    }

    public static class LAND
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLAND(this);
        }

        public LAND() {
            super((short)127);
        }
    }

    public static class LASTORE
    extends ArrayInstruction
    implements StackConsumer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitLASTORE(this);
        }

        public LASTORE() {
            super((short)80);
        }
    }

    public static class LCMP
    extends Instruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public jq_Type getType() {
            return jq_Primitive.LONG;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitLCMP(this);
        }

        public LCMP() {
            super((short)148, (short)1);
        }
    }

    public static class LCONST
    extends Instruction
    implements PushInstruction,
    StackProducer,
    TypedInstruction,
    ConstantPushInstruction {
        private long value;

        public Number getValue() {
            return new Long(this.value);
        }

        public jq_Type getType() {
            return jq_Primitive.LONG;
        }

        public void accept(Visitor visitor) {
            visitor.visitPushInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitTypedInstruction(this);
            visitor.visitConstantPushInstruction(this);
            visitor.visitLCONST(this);
        }

        LCONST() {
        }

        public LCONST(long l) {
            super((short)9, (short)1);
            if (l == 0L) {
                this.opcode = (short)9;
            } else if (l == 1L) {
                this.opcode = (short)10;
            } else {
                throw new BytecodeException("LCONST can be used only for 0 and 1: " + l);
            }
            this.value = l;
        }
    }

    public static class LDC2_W
    extends CPInstruction
    implements StackProducer,
    PushInstruction,
    TypedInstruction {
        public jq_Type getType() {
            if (this.o instanceof Long) {
                return jq_Primitive.LONG;
            }
            if (this.o instanceof Double) {
                return jq_Primitive.DOUBLE;
            }
            throw new RuntimeException("Unknown constant type " + this.o.getClass());
        }

        public Number getValue() {
            return (Number)this.getObject();
        }

        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitPushInstruction(this);
            visitor.visitTypedInstruction(this);
            visitor.visitCPInstruction(this);
            visitor.visitLDC2_W(this);
        }

        LDC2_W() {
        }

        public LDC2_W(Object object) {
            super((short)20, object);
        }
    }

    public static class LDC
    extends CPInstruction
    implements PushInstruction,
    ExceptionThrower,
    TypedInstruction {
        protected final void setSize() {
            if (this.index <= '\u007f') {
                this.opcode = (short)18;
                this.length = (short)2;
            } else {
                this.opcode = (short)19;
                this.length = (short)3;
            }
        }

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(this.opcode);
            if (this.length == 2) {
                dataOutputStream.writeByte(this.index);
            } else {
                dataOutputStream.writeShort(this.index);
            }
        }

        public final void setIndex(jq_ConstantPool.ConstantPoolRebuilder constantPoolRebuilder) {
            super.setIndex(constantPoolRebuilder);
            this.setSize();
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.length = (short)2;
            this.o = jq_ConstantPool2.get((char)byteSequence.readUnsignedByte());
        }

        public Object getValue() {
            return this.getObject();
        }

        public jq_Type getType() {
            if (this.o instanceof String) {
                return PrimordialClassLoader.getJavaLangString();
            }
            if (this.o instanceof Float) {
                return jq_Primitive.FLOAT;
            }
            if (this.o instanceof Integer) {
                return jq_Primitive.INT;
            }
            throw new RuntimeException("Unknown or invalid constant type " + this.o.getClass() + " at " + this.index);
        }

        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitPushInstruction(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitCPInstruction(this);
            visitor.visitLDC(this);
        }

        LDC() {
        }

        public LDC(Object object) {
            super((short)19, object);
            this.setSize();
        }
    }

    public static class LDC_W
    extends LDC {
        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.o = jq_ConstantPool2.get((char)byteSequence.readUnsignedShort());
            this.length = (short)3;
        }

        LDC_W() {
        }

        public LDC_W(Object object) {
            super(object);
        }
    }

    public static class LDIV
    extends ArithmeticInstruction
    implements ExceptionThrower,
    TypedInstruction,
    StackProducer,
    StackConsumer {
        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLDIV(this);
        }

        public LDIV() {
            super((short)109);
        }
    }

    public static class LLOAD
    extends LoadInstruction {
        public void accept(Visitor visitor) {
            super.accept(visitor);
            visitor.visitLLOAD(this);
        }

        LLOAD() {
            super((short)22, (short)30);
        }

        public LLOAD(int n) {
            super((short)22, (short)30, n);
        }
    }

    public static class LMUL
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLMUL(this);
        }

        public LMUL() {
            super((short)105);
        }
    }

    public static class LNEG
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLNEG(this);
        }

        public LNEG() {
            super((short)117);
        }
    }

    public static class LOOKUPSWITCH
    extends Select {
        public void dump(DataOutputStream dataOutputStream) throws IOException {
            super.dump(dataOutputStream);
            dataOutputStream.writeInt(this.match_length);
            int n = 0;
            while (n < this.match_length) {
                dataOutputStream.writeInt(this.match[n]);
                this.indices[n] = this.getTargetOffset((InstructionHandle)this.targets.get(n));
                dataOutputStream.writeInt(this.indices[n]);
                ++n;
            }
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            super.initFromFile(jq_ConstantPool2, byteSequence, bl);
            this.match_length = byteSequence.readInt();
            this.fixed_length = (short)(9 + this.match_length * 8);
            this.length = (short)(this.fixed_length + this.padding);
            this.match = new int[this.match_length];
            this.indices = new int[this.match_length];
            this.targets = new ArrayList(this.match_length);
            int n = 0;
            while (n < this.match_length) {
                this.match[n] = byteSequence.readInt();
                this.indices[n] = byteSequence.readInt();
                this.targets.add(null);
                ++n;
            }
        }

        public void accept(Visitor visitor) {
            visitor.visitVariableLengthInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitSelect(this);
            visitor.visitLOOKUPSWITCH(this);
        }

        LOOKUPSWITCH() {
        }

        public LOOKUPSWITCH(int[] nArray, ArrayList arrayList, InstructionHandle instructionHandle) {
            super((short)171, nArray, arrayList, instructionHandle);
            this.length = (short)(9 + this.match_length * 8);
            this.fixed_length = this.length;
        }
    }

    public static class LOR
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLOR(this);
        }

        public LOR() {
            super((short)129);
        }
    }

    public static class LREM
    extends ArithmeticInstruction
    implements ExceptionThrower,
    TypedInstruction,
    StackProducer,
    StackConsumer {
        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLREM(this);
        }

        public LREM() {
            super((short)113);
        }
    }

    public static class LRETURN
    extends ReturnInstruction
    implements TypedInstruction,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackConsumer(this);
            visitor.visitReturnInstruction(this);
            visitor.visitLRETURN(this);
        }

        public LRETURN() {
            super((short)173);
        }
    }

    public static class LSHL
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLSHL(this);
        }

        public LSHL() {
            super((short)121);
        }
    }

    public static class LSHR
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLSHR(this);
        }

        public LSHR() {
            super((short)123);
        }
    }

    public static class LSTORE
    extends StoreInstruction {
        public void accept(Visitor visitor) {
            super.accept(visitor);
            visitor.visitLSTORE(this);
        }

        LSTORE() {
            super((short)55, (short)63);
        }

        public LSTORE(int n) {
            super((short)55, (short)63, n);
        }
    }

    public static class LSUB
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLSUB(this);
        }

        public LSUB() {
            super((short)101);
        }
    }

    public static class LUSHR
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLUSHR(this);
        }

        public LUSHR() {
            super((short)125);
        }
    }

    public static class LXOR
    extends ArithmeticInstruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitStackConsumer(this);
            visitor.visitArithmeticInstruction(this);
            visitor.visitLXOR(this);
        }

        public LXOR() {
            super((short)131);
        }
    }

    public static class MONITORENTER
    extends Instruction
    implements ExceptionThrower,
    StackConsumer {
        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitStackConsumer(this);
            visitor.visitMONITORENTER(this);
        }

        public MONITORENTER() {
            super((short)194, (short)1);
        }
    }

    public static class MONITOREXIT
    extends Instruction
    implements ExceptionThrower,
    StackConsumer {
        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitStackConsumer(this);
            visitor.visitMONITOREXIT(this);
        }

        public MONITOREXIT() {
            super((short)195, (short)1);
        }
    }

    public static class MULTIANEWARRAY
    extends CPInstruction
    implements AllocationInstruction,
    ExceptionThrower,
    TypedInstruction {
        private short dimensions;

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(this.opcode);
            dataOutputStream.writeShort(this.index);
            dataOutputStream.writeByte(this.dimensions);
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            super.initFromFile(jq_ConstantPool2, byteSequence, bl);
            this.dimensions = byteSequence.readByte();
            this.length = (short)4;
        }

        public final short getDimensions() {
            return this.dimensions;
        }

        public String toString(boolean bl) {
            return super.toString(bl) + ' ' + this.index + ' ' + this.dimensions;
        }

        public String toString() {
            return super.toString() + ' ' + this.dimensions;
        }

        public int consumeStack() {
            return this.dimensions;
        }

        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitAllocationInstruction(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitCPInstruction(this);
            visitor.visitMULTIANEWARRAY(this);
        }

        MULTIANEWARRAY() {
        }

        public MULTIANEWARRAY(jq_Type jq_Type2, short s) {
            super((short)197, jq_Type2);
            if (s < 1) {
                throw new BytecodeException("Invalid dimensions value: " + s);
            }
            this.dimensions = s;
            this.length = (short)4;
        }
    }

    public static class NEWARRAY
    extends Instruction
    implements AllocationInstruction,
    ExceptionThrower,
    StackProducer {
        private jq_Array type;

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(this.opcode);
            dataOutputStream.writeByte(jq_Array.getTypecode(this.type));
        }

        public final byte getTypecode() {
            return jq_Array.getTypecode(this.type);
        }

        public final jq_Type getType() {
            return this.type;
        }

        public String toString(boolean bl) {
            return super.toString(bl) + ' ' + this.type;
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.type = jq_Array.getPrimitiveArrayType(byteSequence.readByte());
            this.length = (short)2;
        }

        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitAllocationInstruction(this);
            visitor.visitExceptionThrower(this);
            visitor.visitStackProducer(this);
            visitor.visitNEWARRAY(this);
        }

        NEWARRAY() {
        }

        public NEWARRAY(byte by) {
            super((short)188, (short)2);
            this.type = jq_Array.getPrimitiveArrayType(by);
        }

        public NEWARRAY(jq_Array jq_Array2) {
            super((short)188, (short)2);
            Assert._assert(jq_Array2.getElementType().isPrimitiveType());
            this.type = jq_Array2;
        }
    }

    public static class NEW
    extends CPInstruction
    implements LoadClass,
    AllocationInstruction,
    ExceptionThrower,
    StackProducer,
    TypedInstruction {
        public Set getExceptions() {
            return null;
        }

        public jq_Class getLoadClassType() {
            return (jq_Class)this.getObject();
        }

        public void accept(Visitor visitor) {
            visitor.visitLoadClass(this);
            visitor.visitAllocationInstruction(this);
            visitor.visitExceptionThrower(this);
            visitor.visitStackProducer(this);
            visitor.visitTypedInstruction(this);
            visitor.visitCPInstruction(this);
            visitor.visitNEW(this);
        }

        NEW() {
        }

        public NEW(jq_Type jq_Type2) {
            super((short)187, jq_Type2);
        }
    }

    public static class NOP
    extends Instruction {
        public void accept(Visitor visitor) {
            visitor.visitNOP(this);
        }

        public NOP() {
            super((short)0, (short)1);
        }
    }

    public static class POP2
    extends StackInstruction
    implements PopInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitPopInstruction(this);
            visitor.visitStackInstruction(this);
            visitor.visitPOP2(this);
        }

        public POP2() {
            super((short)88);
        }
    }

    public static class POP
    extends StackInstruction
    implements PopInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitPopInstruction(this);
            visitor.visitStackInstruction(this);
            visitor.visitPOP(this);
        }

        public POP() {
            super((short)87);
        }
    }

    public static final class PUSH
    implements CompoundInstruction,
    VariableLengthInstruction {
        private Instruction instruction;

        public final InstructionList getInstructionList() {
            return new InstructionList(this.instruction);
        }

        public final Instruction getInstruction() {
            return this.instruction;
        }

        public final String toString() {
            return this.instruction.toString() + " (PUSH)";
        }

        public PUSH(int n) {
            if (n >= -1 && n <= 5) {
                this.instruction = InstructionConstants.INSTRUCTIONS[3 + n];
            } else if (n >= -128 && n <= 127) {
                this.instruction = new BIPUSH((byte)n);
            } else if (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE) {
                this.instruction = new SIPUSH((short)n);
            } else {
                Integer n2 = new Integer(n);
                this.instruction = new LDC(n2);
            }
        }

        public PUSH(boolean bl) {
            this.instruction = InstructionConstants.INSTRUCTIONS[3 + bl];
        }

        public PUSH(float f) {
            if ((double)f == 0.0) {
                this.instruction = InstructionConstants.FCONST_0;
            } else if ((double)f == 1.0) {
                this.instruction = InstructionConstants.FCONST_1;
            } else if ((double)f == (double)2) {
                this.instruction = InstructionConstants.FCONST_2;
            } else {
                Float f2 = new Float(f);
                this.instruction = new LDC(f2);
            }
        }

        public PUSH(long l) {
            if (l == 0L) {
                this.instruction = InstructionConstants.LCONST_0;
            } else if (l == 1L) {
                this.instruction = InstructionConstants.LCONST_1;
            } else {
                Long l2 = new Long(l);
                this.instruction = new LDC2_W(l2);
            }
        }

        public PUSH(double d) {
            if (d == 0.0) {
                this.instruction = InstructionConstants.DCONST_0;
            } else if (d == 1.0) {
                this.instruction = InstructionConstants.DCONST_1;
            } else {
                Double d2 = new Double(d);
                this.instruction = new LDC2_W(d2);
            }
        }

        public PUSH(jq_ConstantPool.ConstantPoolRebuilder constantPoolRebuilder, String string) {
            if (string == null) {
                this.instruction = InstructionConstants.ACONST_NULL;
            } else {
                constantPoolRebuilder.addString(string);
                this.instruction = new LDC(string);
            }
        }

        public PUSH(Number number) {
            if (number instanceof Integer || number instanceof Short || number instanceof Byte) {
                this.instruction = new PUSH((int)number.intValue()).instruction;
            } else if (number instanceof Double) {
                this.instruction = new PUSH((double)number.doubleValue()).instruction;
            } else if (number instanceof Float) {
                this.instruction = new PUSH((float)number.floatValue()).instruction;
            } else if (number instanceof Long) {
                this.instruction = new PUSH((long)number.longValue()).instruction;
            } else {
                throw new BytecodeException("What's this: " + number);
            }
        }

        public PUSH(Character c) {
            this((int)c.charValue());
        }

        public PUSH(Boolean bl) {
            this((boolean)bl);
        }
    }

    public static class PUTFIELD
    extends FieldInstruction
    implements ExceptionThrower,
    TypedInstruction,
    LoadClass {
        public int consumeStack() {
            return this.getFieldSize() + 1;
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.o = jq_ConstantPool2.getAsInstanceField((char)byteSequence.readUnsignedShort());
            this.length = (short)3;
        }

        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitLoadClass(this);
            visitor.visitCPInstruction(this);
            visitor.visitFieldOrMethod(this);
            visitor.visitFieldInstruction(this);
            visitor.visitPUTFIELD(this);
        }

        PUTFIELD() {
        }

        public PUTFIELD(jq_InstanceField jq_InstanceField2) {
            super((short)181, jq_InstanceField2);
        }
    }

    public static class PUTSTATIC
    extends FieldInstruction
    implements ExceptionThrower,
    StackConsumer,
    PopInstruction,
    TypedInstruction,
    LoadClass {
        public int consumeStack() {
            return this.getFieldSize();
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.o = jq_ConstantPool2.getAsStaticField((char)byteSequence.readUnsignedShort());
            this.length = (short)3;
        }

        public Set getExceptions() {
            return null;
        }

        public void accept(Visitor visitor) {
            visitor.visitExceptionThrower(this);
            visitor.visitStackConsumer(this);
            visitor.visitPopInstruction(this);
            visitor.visitTypedInstruction(this);
            visitor.visitLoadClass(this);
            visitor.visitCPInstruction(this);
            visitor.visitFieldOrMethod(this);
            visitor.visitFieldInstruction(this);
            visitor.visitPUTSTATIC(this);
        }

        PUTSTATIC() {
        }

        public PUTSTATIC(jq_StaticField jq_StaticField2) {
            super((short)179, jq_StaticField2);
        }
    }

    public static class RET
    extends Instruction
    implements IndexedInstruction,
    TypedInstruction {
        private boolean wide;
        private int index;

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            if (this.wide) {
                dataOutputStream.writeByte(196);
            }
            dataOutputStream.writeByte(this.opcode);
            if (this.wide) {
                dataOutputStream.writeShort(this.index);
            } else {
                dataOutputStream.writeByte(this.index);
            }
        }

        private final void setWide() {
            boolean bl = false;
            if (this.index > 127) {
                bl = true;
            }
            this.wide = bl;
            this.length = this.wide ? (short)4 : (short)2;
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.wide = bl;
            if (bl) {
                this.index = byteSequence.readUnsignedShort();
                this.length = (short)4;
            } else {
                this.index = byteSequence.readUnsignedByte();
                this.length = (short)2;
            }
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            if (n < 0) {
                throw new BytecodeException("Negative index value: " + n);
            }
            this.index = n;
            this.setWide();
        }

        public String toString(boolean bl) {
            return super.toString(bl) + ' ' + this.index;
        }

        public jq_Type getType() {
            return jq_ReturnAddressType.NO_TARGET;
        }

        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitRET(this);
        }

        RET() {
        }

        public RET(int n) {
            super((short)169, (short)2);
            this.setIndex(n);
        }
    }

    public static class RETURN
    extends ReturnInstruction
    implements TypedInstruction,
    StackConsumer {
        public void accept(Visitor visitor) {
            visitor.visitTypedInstruction(this);
            visitor.visitStackConsumer(this);
            visitor.visitReturnInstruction(this);
            visitor.visitRETURN(this);
        }

        public RETURN() {
            super((short)177);
        }
    }

    public static class SALOAD
    extends ArrayInstruction
    implements StackProducer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitSALOAD(this);
        }

        public SALOAD() {
            super((short)53);
        }
    }

    public static class SASTORE
    extends ArrayInstruction
    implements StackConsumer,
    ExceptionThrower,
    TypedInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitExceptionThrower(this);
            visitor.visitTypedInstruction(this);
            visitor.visitArrayInstruction(this);
            visitor.visitSASTORE(this);
        }

        public SASTORE() {
            super((short)86);
        }
    }

    public static class SIPUSH
    extends Instruction
    implements PushInstruction,
    StackProducer,
    TypedInstruction,
    ConstantPushInstruction {
        private short b;

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            super.dump(dataOutputStream);
            dataOutputStream.writeShort(this.b);
        }

        public String toString(boolean bl) {
            return super.toString(bl) + ' ' + this.b;
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.length = (short)3;
            this.b = byteSequence.readShort();
        }

        public Number getValue() {
            return new Integer(this.b);
        }

        public jq_Type getType() {
            return jq_Primitive.SHORT;
        }

        public void accept(Visitor visitor) {
            visitor.visitPushInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitTypedInstruction(this);
            visitor.visitConstantPushInstruction(this);
            visitor.visitSIPUSH(this);
        }

        SIPUSH() {
        }

        public SIPUSH(short s) {
            super((short)17, (short)3);
            this.b = s;
        }
    }

    public static class SWAP
    extends StackInstruction
    implements StackConsumer,
    StackProducer {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitStackProducer(this);
            visitor.visitStackInstruction(this);
            visitor.visitSWAP(this);
        }

        public SWAP() {
            super((short)95);
        }
    }

    public static final class SWITCH
    implements CompoundInstruction {
        private int[] match;
        private ArrayList targets;
        private Select instruction;
        private int match_length;

        private final void fillup(int n, InstructionHandle instructionHandle) {
            int n2 = this.match_length + this.match_length * n;
            int[] nArray = new int[n2];
            ArrayList arrayList = new ArrayList(n2);
            int n3 = 1;
            nArray[0] = this.match[0];
            arrayList.add(this.targets.get(0));
            int n4 = 1;
            while (n4 < this.match_length) {
                int n5 = this.match[n4 - 1];
                int n6 = this.match[n4] - n5;
                int n7 = 1;
                while (n7 < n6) {
                    nArray[n3] = n5 + n7;
                    arrayList.add(instructionHandle);
                    ++n3;
                    ++n7;
                }
                nArray[n3] = this.match[n4];
                arrayList.add(this.targets.get(n4));
                ++n3;
                ++n4;
            }
            this.match = new int[n3];
            System.arraycopy(nArray, 0, this.match, 0, n3);
            this.targets = arrayList;
            arrayList.trimToSize();
        }

        private final void sort(int n, int n2) {
            int n3 = n;
            int n4 = n2;
            int n5 = this.match[(n + n2) / 2];
            while (true) {
                if (this.match[n3] < n5) {
                    ++n3;
                    continue;
                }
                while (n5 < this.match[n4]) {
                    --n4;
                }
                if (n3 <= n4) {
                    int n6 = this.match[n3];
                    this.match[n3] = this.match[n4];
                    this.match[n4] = n6;
                    Object e = this.targets.get(n3);
                    this.targets.set(n3, this.targets.get(n4));
                    this.targets.set(n4, e);
                    ++n3;
                    --n4;
                }
                if (n3 > n4) break;
            }
            if (n < n4) {
                this.sort(n, n4);
            }
            if (n3 < n2) {
                this.sort(n3, n2);
            }
        }

        private final boolean matchIsOrdered(int n) {
            int n2 = 1;
            while (n2 < this.match_length) {
                if (this.match[n2] - this.match[n2 - 1] > n) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public final InstructionList getInstructionList() {
            return new InstructionList(this.instruction);
        }

        public final Instruction getInstruction() {
            return this.instruction;
        }

        public SWITCH(int[] nArray, ArrayList arrayList, InstructionHandle instructionHandle, int n) {
            this.match = (int[])nArray.clone();
            this.targets = (ArrayList)arrayList.clone();
            this.match_length = nArray.length;
            if (this.match_length < 2) {
                this.instruction = new TABLESWITCH(nArray, arrayList, instructionHandle);
            } else {
                this.sort(0, this.match_length - 1);
                if (this.matchIsOrdered(n)) {
                    this.fillup(n, instructionHandle);
                    this.instruction = new TABLESWITCH(this.match, this.targets, instructionHandle);
                } else {
                    this.instruction = new LOOKUPSWITCH(this.match, this.targets, instructionHandle);
                }
            }
        }

        public SWITCH(int[] nArray, ArrayList arrayList, InstructionHandle instructionHandle) {
            this(nArray, arrayList, instructionHandle, 1);
        }
    }

    public static class TABLESWITCH
    extends Select
    implements VariableLengthInstruction,
    StackProducer {
        public void dump(DataOutputStream dataOutputStream) throws IOException {
            super.dump(dataOutputStream);
            int n = 0;
            if (this.match_length > 0) {
                n = this.match[0];
            }
            int n2 = n;
            dataOutputStream.writeInt(n2);
            int n3 = 0;
            if (this.match_length > 0) {
                n3 = this.match[this.match_length - 1];
            }
            int n4 = n3;
            dataOutputStream.writeInt(n4);
            int n5 = 0;
            while (n5 < this.match_length) {
                this.indices[n5] = this.getTargetOffset((InstructionHandle)this.targets.get(n5));
                dataOutputStream.writeInt(this.indices[n5]);
                ++n5;
            }
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            super.initFromFile(jq_ConstantPool2, byteSequence, bl);
            int n = byteSequence.readInt();
            int n2 = byteSequence.readInt();
            this.match_length = n2 - n + 1;
            this.fixed_length = (short)(13 + this.match_length * 4);
            this.length = (short)(this.fixed_length + this.padding);
            this.match = new int[this.match_length];
            this.indices = new int[this.match_length];
            this.targets = new ArrayList(this.match_length);
            int n3 = n;
            while (n3 <= n2) {
                this.match[n3 - n] = n3;
                ++n3;
            }
            n3 = 0;
            while (n3 < this.match_length) {
                this.indices[n3] = byteSequence.readInt();
                this.targets.add(null);
                ++n3;
            }
        }

        public void accept(Visitor visitor) {
            visitor.visitVariableLengthInstruction(this);
            visitor.visitStackProducer(this);
            visitor.visitBranchInstruction(this);
            visitor.visitSelect(this);
            visitor.visitTABLESWITCH(this);
        }

        TABLESWITCH() {
        }

        public TABLESWITCH(int[] nArray, ArrayList arrayList, InstructionHandle instructionHandle) {
            super((short)170, nArray, arrayList, instructionHandle);
            this.length = (short)(13 + this.match_length * 4);
            this.fixed_length = this.length;
        }
    }

    public static abstract class ArithmeticInstruction
    extends Instruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public jq_Type getType() {
            switch (this.opcode) {
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: 
                case 119: {
                    return jq_Primitive.DOUBLE;
                }
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: 
                case 118: {
                    return jq_Primitive.FLOAT;
                }
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 116: 
                case 120: 
                case 122: 
                case 124: 
                case 126: 
                case 128: 
                case 130: {
                    return jq_Primitive.INT;
                }
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 117: 
                case 121: 
                case 123: 
                case 125: 
                case 127: 
                case 129: 
                case 131: {
                    return jq_Primitive.LONG;
                }
            }
            throw new BytecodeException("Unknown type " + this.opcode);
        }

        ArithmeticInstruction() {
        }

        protected ArithmeticInstruction(short s) {
            super(s, (short)1);
        }
    }

    public static abstract class ArrayInstruction
    extends Instruction
    implements ExceptionThrower,
    TypedInstruction {
        public Set getExceptions() {
            return null;
        }

        public jq_Type getType() {
            switch (this.opcode) {
                case 46: 
                case 79: {
                    return jq_Primitive.INT;
                }
                case 52: 
                case 85: {
                    return jq_Primitive.CHAR;
                }
                case 51: 
                case 84: {
                    return jq_Primitive.BYTE;
                }
                case 53: 
                case 86: {
                    return jq_Primitive.SHORT;
                }
                case 47: 
                case 80: {
                    return jq_Primitive.LONG;
                }
                case 49: 
                case 82: {
                    return jq_Primitive.DOUBLE;
                }
                case 48: 
                case 81: {
                    return jq_Primitive.FLOAT;
                }
                case 50: 
                case 83: {
                    return PrimordialClassLoader.getJavaLangObject();
                }
            }
            throw new BytecodeException("Oops: unknown case in switch" + this.opcode);
        }

        ArrayInstruction() {
        }

        protected ArrayInstruction(short s) {
            super(s, (short)1);
        }
    }

    public static abstract class BranchInstruction
    extends Instruction
    implements InstructionTargeter {
        protected int index;
        protected InstructionHandle target;
        protected int position;

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(this.opcode);
            this.index = this.getTargetOffset();
            if (Math.abs(this.index) >= Short.MAX_VALUE) {
                throw new BytecodeException("Branch target offset too large for short");
            }
            dataOutputStream.writeShort(this.index);
        }

        protected int getTargetOffset(InstructionHandle instructionHandle) {
            if (instructionHandle == null) {
                throw new BytecodeException("Target of " + super.toString(true) + " is invalid null handle");
            }
            int n = instructionHandle.getPosition();
            if (n < 0) {
                throw new BytecodeException("Invalid branch target position offset for " + super.toString(true) + ':' + n + ':' + instructionHandle);
            }
            return n - this.position;
        }

        protected int getTargetOffset() {
            return this.getTargetOffset(this.target);
        }

        protected int updatePosition(int n, int n2) {
            this.position += n;
            return 0;
        }

        public String toString(boolean bl) {
            String string = super.toString(bl);
            String string2 = "null";
            if (bl) {
                if (this.target != null) {
                    string2 = this.target.getInstruction() == this ? "<points to itself>" : (this.target.getInstruction() == null ? "<null instruction!!!?>" : this.target.getInstruction().toString(false));
                }
            } else if (this.target != null) {
                this.index = this.getTargetOffset();
                string2 = "" + (this.index + this.position);
            }
            return string + " -> " + string2;
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.length = (short)3;
            this.index = byteSequence.readShort();
        }

        public final int getIndex() {
            return this.index;
        }

        public InstructionHandle getTarget() {
            return this.target;
        }

        public void setTarget(InstructionHandle instructionHandle) {
            BranchInstruction.notifyTarget(this.target, instructionHandle, this);
            this.target = instructionHandle;
        }

        static final void notifyTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionTargeter instructionTargeter) {
            if (instructionHandle != null) {
                instructionHandle.removeTargeter(instructionTargeter);
            }
            if (instructionHandle2 != null) {
                instructionHandle2.addTargeter(instructionTargeter);
            }
        }

        public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
            if (this.target != instructionHandle) {
                throw new BytecodeException("Not targeting " + instructionHandle + ", but " + this.target);
            }
            this.setTarget(instructionHandle2);
        }

        public boolean containsTarget(InstructionHandle instructionHandle) {
            boolean bl = false;
            if (this.target == instructionHandle) {
                bl = true;
            }
            return bl;
        }

        void dispose() {
            this.setTarget(null);
            this.index = -1;
            this.position = -1;
        }

        BranchInstruction() {
        }

        protected BranchInstruction(short s, InstructionHandle instructionHandle) {
            super(s, (short)3);
            this.setTarget(instructionHandle);
        }
    }

    public static abstract class ConversionInstruction
    extends Instruction
    implements TypedInstruction,
    StackProducer,
    StackConsumer {
        public jq_Type getType() {
            switch (this.opcode) {
                case 136: 
                case 139: 
                case 142: {
                    return jq_Primitive.INT;
                }
                case 134: 
                case 137: 
                case 144: {
                    return jq_Primitive.FLOAT;
                }
                case 133: 
                case 140: 
                case 143: {
                    return jq_Primitive.LONG;
                }
                case 135: 
                case 138: 
                case 141: {
                    return jq_Primitive.DOUBLE;
                }
                case 145: {
                    return jq_Primitive.BYTE;
                }
                case 146: {
                    return jq_Primitive.CHAR;
                }
                case 147: {
                    return jq_Primitive.SHORT;
                }
            }
            throw new BytecodeException("Unknown type " + this.opcode);
        }

        ConversionInstruction() {
        }

        protected ConversionInstruction(short s) {
            super(s, (short)1);
        }
    }

    public static abstract class CPInstruction
    extends Instruction
    implements TypedInstruction {
        protected Object o;
        protected char index;

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            boolean bl = false;
            if (this.index != '\u0000') {
                bl = true;
            }
            Assert._assert(bl);
            dataOutputStream.writeByte(this.opcode);
            dataOutputStream.writeChar(this.index);
        }

        public String toString(boolean bl) {
            return super.toString(bl) + ' ' + this.index;
        }

        public String toString() {
            return jq_ClassFileConstants.OPCODE_NAMES[this.opcode] + ' ' + this.getObject();
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.o = jq_ConstantPool2.get((char)byteSequence.readUnsignedShort());
            Assert._assert(this.o instanceof jq_MemberReference ^ true);
            this.length = (short)3;
        }

        public final int getIndex() {
            return this.index;
        }

        public void setIndex(jq_ConstantPool.ConstantPoolRebuilder constantPoolRebuilder) {
            this.index = constantPoolRebuilder.get(this.o);
            if (this.index == '\u0000') {
                throw new BytecodeException("Zero constant pool index");
            }
        }

        public Object getObject() {
            return this.o;
        }

        public void setObject(Object object) {
            this.o = object;
        }

        public jq_Type getType() {
            return (jq_Type)this.getObject();
        }

        CPInstruction() {
        }

        protected CPInstruction(short s, Object object) {
            super(s, (short)3);
            this.o = object;
            boolean bl = false;
            if (object != null) {
                bl = true;
            }
            Assert._assert(bl);
        }
    }

    public static abstract class FieldInstruction
    extends FieldOrMethod
    implements TypedInstruction {
        public String toString() {
            return jq_ClassFileConstants.OPCODE_NAMES[this.opcode] + ' ' + this.getField();
        }

        public jq_Field getField() {
            return (jq_Field)this.getObject();
        }

        protected int getFieldSize() {
            return this.getField().getWidth() >> 2;
        }

        public jq_Type getType() {
            return this.getFieldType();
        }

        public jq_Type getFieldType() {
            return this.getField().getType();
        }

        public String getFieldName() {
            return this.getName();
        }

        FieldInstruction() {
        }

        protected FieldInstruction(short s, jq_Field jq_Field2) {
            super(s, jq_Field2);
        }
    }

    public static abstract class FieldOrMethod
    extends CPInstruction
    implements LoadClass {
        public String getSignature() {
            jq_Member jq_Member2 = (jq_Member)this.getObject();
            return jq_Member2.getDesc().toString();
        }

        public String getName() {
            jq_Member jq_Member2 = (jq_Member)this.getObject();
            return jq_Member2.getName().toString();
        }

        public String getClassName() {
            jq_Member jq_Member2 = (jq_Member)this.getObject();
            return jq_Member2.getDeclaringClass().getName().toString();
        }

        public jq_Class getClassType() {
            jq_Member jq_Member2 = (jq_Member)this.getObject();
            return jq_Member2.getDeclaringClass();
        }

        public jq_Class getLoadClassType() {
            return this.getClassType();
        }

        protected abstract void initFromFile(jq_ConstantPool var1, ByteSequence var2, boolean var3) throws IOException;

        FieldOrMethod() {
        }

        protected FieldOrMethod(short s, jq_Member jq_Member2) {
            super(s, jq_Member2);
        }
    }

    public static abstract class GotoInstruction
    extends BranchInstruction
    implements UnconditionalBranch {
        GotoInstruction(short s, InstructionHandle instructionHandle) {
            super(s, instructionHandle);
        }

        GotoInstruction() {
        }
    }

    public static abstract class IfInstruction
    extends BranchInstruction
    implements StackConsumer {
        public abstract IfInstruction negate();

        IfInstruction() {
        }

        protected IfInstruction(short s, InstructionHandle instructionHandle) {
            super(s, instructionHandle);
        }
    }

    public static abstract class InvokeInstruction
    extends FieldOrMethod
    implements ExceptionThrower,
    TypedInstruction,
    StackConsumer,
    StackProducer {
        public String toString() {
            return jq_ClassFileConstants.OPCODE_NAMES[this.opcode] + ' ' + this.getMethod();
        }

        public jq_Method getMethod() {
            return (jq_Method)this.getObject();
        }

        public int consumeStack() {
            return this.getMethod().getParamWords();
        }

        public int produceStack() {
            return this.getMethod().getReturnWords();
        }

        public jq_Type getType() {
            return this.getMethod().getReturnType();
        }

        public String getMethodName() {
            return this.getName();
        }

        public jq_Type getReturnType() {
            return this.getMethod().getReturnType();
        }

        public jq_Type[] getArgumentTypes() {
            return this.getMethod().getParamTypes();
        }

        InvokeInstruction() {
        }

        protected InvokeInstruction(short s, jq_Method jq_Method2) {
            super(s, jq_Method2);
        }
    }

    public static abstract class JsrInstruction
    extends BranchInstruction
    implements UnconditionalBranch,
    TypedInstruction,
    StackProducer {
        public jq_Type getType() {
            return new jq_ReturnAddressType(this.physicalSuccessor());
        }

        public InstructionHandle physicalSuccessor() {
            InstructionHandle instructionHandle = this.target;
            while (instructionHandle.getPrev() != null) {
                instructionHandle = instructionHandle.getPrev();
            }
            while (instructionHandle.getInstruction() != this) {
                instructionHandle = instructionHandle.getNext();
            }
            InstructionHandle instructionHandle2 = instructionHandle;
            while (instructionHandle != null) {
                if ((instructionHandle = instructionHandle.getNext()) == null || instructionHandle.getInstruction() != this) continue;
                throw new RuntimeException("physicalSuccessor() called on a shared JsrInstruction.");
            }
            return instructionHandle2.getNext();
        }

        JsrInstruction(short s, InstructionHandle instructionHandle) {
            super(s, instructionHandle);
        }

        JsrInstruction() {
        }
    }

    public static abstract class LoadInstruction
    extends LocalVariableInstruction
    implements PushInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackProducer(this);
            visitor.visitPushInstruction(this);
            visitor.visitTypedInstruction(this);
            visitor.visitLocalVariableInstruction(this);
            visitor.visitLoadInstruction(this);
        }

        LoadInstruction(short s, short s2) {
            super(s, s2);
        }

        protected LoadInstruction(short s, short s2, int n) {
            super(s, s2, n);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class LocalVariableInstruction
    extends Instruction
    implements TypedInstruction,
    IndexedInstruction {
        protected int n;
        private short c_tag;
        private short canon_tag;

        private final boolean wide() {
            boolean bl = false;
            if (this.n > 127) {
                bl = true;
            }
            return bl;
        }

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            if (this.wide()) {
                dataOutputStream.writeByte(196);
            }
            dataOutputStream.writeByte(this.opcode);
            if (this.length > 1) {
                if (this.wide()) {
                    dataOutputStream.writeShort(this.n);
                } else {
                    dataOutputStream.writeByte(this.n);
                }
            }
        }

        public String toString(boolean bl) {
            if (this.opcode >= 26 && this.opcode <= 45 || this.opcode >= 59 && this.opcode <= 78) {
                return super.toString(bl);
            }
            return super.toString(bl) + ' ' + this.n;
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            if (bl) {
                this.n = byteSequence.readUnsignedShort();
                this.length = (short)4;
            } else if (this.opcode >= 21 && this.opcode <= 25 || this.opcode >= 54 && this.opcode <= 58) {
                this.n = byteSequence.readUnsignedByte();
                this.length = (short)2;
            } else if (this.opcode <= 45) {
                this.n = (this.opcode - 26) % 4;
                this.length = 1;
            } else {
                this.n = (this.opcode - 59) % 4;
                this.length = 1;
            }
        }

        public final int getIndex() {
            return this.n;
        }

        public void setIndex(int n) {
            if (n < 0 || n > Short.MAX_VALUE) {
                throw new BytecodeException("Illegal value: " + n);
            }
            this.n = n;
            if (n >= 0 && n <= 3) {
                this.opcode = (short)(this.c_tag + n);
                this.length = 1;
            } else {
                this.opcode = this.canon_tag;
                this.length = this.wide() ? (short)4 : (short)2;
            }
        }

        public short getCanonicalTag() {
            return this.canon_tag;
        }

        public final jq_Type getType() {
            switch (this.canon_tag) {
                case 21: 
                case 54: {
                    return jq_Primitive.INT;
                }
                case 22: 
                case 55: {
                    return jq_Primitive.LONG;
                }
                case 24: 
                case 57: {
                    return jq_Primitive.DOUBLE;
                }
                case 23: 
                case 56: {
                    return jq_Primitive.FLOAT;
                }
                case 25: 
                case 58: {
                    return PrimordialClassLoader.getJavaLangObject();
                }
            }
            throw new BytecodeException("Oops: unknown case in switch" + this.canon_tag);
        }

        private final /* synthetic */ void this() {
            this.n = -1;
            this.c_tag = (short)-1;
            this.canon_tag = (short)-1;
        }

        LocalVariableInstruction(short s, short s2) {
            this.this();
            this.canon_tag = s;
            this.c_tag = s2;
        }

        LocalVariableInstruction() {
            this.this();
        }

        protected LocalVariableInstruction(short s, short s2, int n) {
            super(s, (short)2);
            this.this();
            this.c_tag = s2;
            this.canon_tag = s;
            this.setIndex(n);
        }
    }

    public static abstract class ReturnInstruction
    extends Instruction
    implements ExceptionThrower,
    TypedInstruction,
    StackConsumer {
        public jq_Type getType() {
            switch (this.opcode) {
                case 172: {
                    return jq_Primitive.INT;
                }
                case 173: {
                    return jq_Primitive.LONG;
                }
                case 174: {
                    return jq_Primitive.FLOAT;
                }
                case 175: {
                    return jq_Primitive.DOUBLE;
                }
                case 176: {
                    return PrimordialClassLoader.getJavaLangObject();
                }
                case 177: {
                    return jq_Primitive.VOID;
                }
            }
            throw new BytecodeException("Unknown type " + this.opcode);
        }

        public Set getExceptions() {
            return null;
        }

        ReturnInstruction() {
        }

        protected ReturnInstruction(short s) {
            super(s, (short)1);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class Select
    extends BranchInstruction
    implements VariableLengthInstruction,
    StackProducer {
        protected int[] match;
        protected int[] indices;
        protected ArrayList targets;
        protected int fixed_length;
        protected int match_length;
        protected int padding;

        protected int updatePosition(int n, int n2) {
            this.position += n;
            short s = this.length;
            this.padding = (4 - (this.position + 1) % 4) % 4;
            this.length = (short)(this.fixed_length + this.padding);
            return this.length - s;
        }

        public void dump(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(this.opcode);
            int n = 0;
            while (n < this.padding) {
                dataOutputStream.writeByte(0);
                ++n;
            }
            this.index = this.getTargetOffset();
            dataOutputStream.writeInt(this.index);
        }

        protected void initFromFile(jq_ConstantPool jq_ConstantPool2, ByteSequence byteSequence, boolean bl) throws IOException {
            this.padding = (4 - byteSequence.getIndex() % 4) % 4;
            int n = 0;
            while (n < this.padding) {
                byte by = byteSequence.readByte();
                if (by != 0) {
                    throw new BytecodeException("Padding byte != 0: " + by);
                }
                ++n;
            }
            this.index = byteSequence.readInt();
        }

        public String toString(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer(super.toString(bl));
            if (bl) {
                int n = 0;
                while (n < this.match_length) {
                    String string = "null";
                    if (this.targets.get(n) != null) {
                        string = ((InstructionHandle)this.targets.get(n)).getInstruction().toString();
                    }
                    stringBuffer.append("(" + this.match[n] + ", " + string + " = {" + this.indices[n] + "})");
                    ++n;
                }
            } else {
                stringBuffer.append(" ...");
            }
            return stringBuffer.toString();
        }

        public void setTarget(int n, InstructionHandle instructionHandle) {
            Select.notifyTarget((InstructionHandle)this.targets.get(n), instructionHandle, this);
            this.targets.set(n, instructionHandle);
        }

        public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
            boolean bl = false;
            if (this.target == instructionHandle) {
                bl = true;
                this.setTarget(instructionHandle2);
            }
            int n = 0;
            while (n < this.targets.size()) {
                if (this.targets.get(n) == instructionHandle) {
                    bl = true;
                    this.setTarget(n, instructionHandle2);
                }
                ++n;
            }
            if (!bl) {
                throw new BytecodeException("Not targeting " + instructionHandle);
            }
        }

        public boolean containsTarget(InstructionHandle instructionHandle) {
            if (this.target == instructionHandle) {
                return true;
            }
            int n = 0;
            while (n < this.targets.size()) {
                if (this.targets.get(n) == instructionHandle) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        void dispose() {
            super.dispose();
            int n = 0;
            while (n < this.targets.size()) {
                ((InstructionHandle)this.targets.get(n)).removeTargeter(this);
                ++n;
            }
        }

        public int[] getMatchs() {
            return this.match;
        }

        public int[] getIndices() {
            return this.indices;
        }

        public List getTargets() {
            return this.targets;
        }

        private final /* synthetic */ void this() {
            this.padding = 0;
        }

        Select() {
            this.this();
        }

        Select(short s, int[] nArray, ArrayList arrayList, InstructionHandle instructionHandle) {
            super(s, instructionHandle);
            this.this();
            this.targets = arrayList;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Select.notifyTarget(null, (InstructionHandle)iterator.next(), this);
            }
            this.match = nArray;
            this.match_length = nArray.length;
            if (this.match_length != arrayList.size()) {
                throw new BytecodeException("Match and target array have not the same length");
            }
            this.indices = new int[this.match_length];
        }
    }

    public static abstract class StackInstruction
    extends Instruction {
        StackInstruction() {
        }

        protected StackInstruction(short s) {
            super(s, (short)1);
        }
    }

    public static abstract class StoreInstruction
    extends LocalVariableInstruction
    implements PopInstruction {
        public void accept(Visitor visitor) {
            visitor.visitStackConsumer(this);
            visitor.visitPopInstruction(this);
            visitor.visitStoreInstruction(this);
            visitor.visitTypedInstruction(this);
            visitor.visitLocalVariableInstruction(this);
            visitor.visitStoreInstruction(this);
        }

        StoreInstruction(short s, short s2) {
            super(s, s2);
        }

        protected StoreInstruction(short s, short s2, int n) {
            super(s, s2, n);
        }
    }

    public static class BytecodeException
    extends RuntimeException {
        public BytecodeException() {
        }

        public BytecodeException(String string) {
            super(string);
        }
    }

    public static class jq_ReturnAddressType
    extends jq_Reference {
        public static final jq_ReturnAddressType NO_TARGET = new jq_ReturnAddressType();
        private InstructionHandle returnTarget;

        public boolean isAddressType() {
            return false;
        }

        public String getJDKName() {
            return this.desc.toString();
        }

        public String getJDKDesc() {
            return this.getJDKName();
        }

        public jq_Class[] getInterfaces() {
            Assert.UNREACHABLE();
            return null;
        }

        public jq_Class getInterface(Utf8 utf8) {
            Assert.UNREACHABLE();
            return null;
        }

        public boolean implementsInterface(jq_Class jq_Class2) {
            Assert.UNREACHABLE();
            return false;
        }

        public jq_InstanceMethod getVirtualMethod(jq_NameAndDesc jq_NameAndDesc2) {
            Assert.UNREACHABLE();
            return null;
        }

        public String getName() {
            Assert.UNREACHABLE();
            return null;
        }

        public String shortName() {
            Assert.UNREACHABLE();
            return null;
        }

        public boolean isClassType() {
            Assert.UNREACHABLE();
            return false;
        }

        public boolean isArrayType() {
            Assert.UNREACHABLE();
            return false;
        }

        public boolean isFinal() {
            Assert.UNREACHABLE();
            return false;
        }

        public jq_Reference getDirectPrimarySupertype() {
            Assert.UNREACHABLE();
            return null;
        }

        public int getDepth() {
            Assert.UNREACHABLE();
            return 0;
        }

        public void load() {
            Assert.UNREACHABLE();
        }

        public void verify() {
            Assert.UNREACHABLE();
        }

        public void prepare() {
            Assert.UNREACHABLE();
        }

        public void sf_initialize() {
            Assert.UNREACHABLE();
        }

        public void compile() {
            Assert.UNREACHABLE();
        }

        public void cls_initialize() {
            Assert.UNREACHABLE();
        }

        public String toString() {
            return "ReturnAddress (target=" + this.returnTarget + ')';
        }

        public boolean equals(Object object) {
            if (!(object instanceof jq_ReturnAddressType)) {
                return false;
            }
            return ((jq_ReturnAddressType)object).returnTarget.equals(this.returnTarget);
        }

        public int hashCode() {
            return this.returnTarget.hashCode();
        }

        private jq_ReturnAddressType() {
            super(Utf8.get("L&ReturnAddress;"), PrimordialClassLoader.loader);
        }

        private jq_ReturnAddressType(InstructionHandle instructionHandle) {
            super(Utf8.get("L&ReturnAddress;"), PrimordialClassLoader.loader);
            this.returnTarget = instructionHandle;
        }
    }

    public static class CodeException {
        private InstructionHandle start;
        private InstructionHandle end;
        private InstructionHandle handler;
        private jq_Class type;

        public InstructionHandle getStartPC() {
            return this.start;
        }

        public void setStartPC(InstructionHandle instructionHandle) {
            this.start = instructionHandle;
        }

        public InstructionHandle getEndPC() {
            return this.end;
        }

        public void setEndPC(InstructionHandle instructionHandle) {
            this.end = instructionHandle;
        }

        public InstructionHandle getHandlerPC() {
            return this.handler;
        }

        public void setHandlerPC(InstructionHandle instructionHandle) {
            this.handler = instructionHandle;
        }

        public jq_TryCatchBC finish() {
            boolean bl = false;
            if (this.start.getPosition() >= 0) {
                bl = true;
            }
            Assert._assert(bl);
            boolean bl2 = false;
            if (this.end.getPosition() + this.end.getInstruction().getLength() > 0) {
                bl2 = true;
            }
            Assert._assert(bl2);
            boolean bl3 = false;
            if (this.handler.getPosition() >= 0) {
                bl3 = true;
            }
            Assert._assert(bl3);
            return new jq_TryCatchBC((char)this.start.getPosition(), (char)(this.end.getPosition() + this.end.getInstruction().getLength()), (char)this.handler.getPosition(), this.type);
        }

        public CodeException(InstructionList instructionList, byte[] byArray, jq_TryCatchBC jq_TryCatchBC2) {
            this.start = instructionList.findHandle(jq_TryCatchBC2.getStartPC());
            if (jq_TryCatchBC2.getEndPC() == byArray.length) {
                this.end = instructionList.getEnd();
            } else {
                this.end = instructionList.findHandle(jq_TryCatchBC2.getEndPC());
                this.end = this.end.getPrev();
            }
            this.handler = instructionList.findHandle(jq_TryCatchBC2.getHandlerPC());
            this.type = jq_TryCatchBC2.getExceptionType();
        }

        public CodeException(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, jq_Class jq_Class2, InstructionHandle instructionHandle3) {
            this.start = instructionHandle;
            this.end = instructionHandle2;
            this.type = jq_Class2;
            this.handler = instructionHandle3;
        }
    }

    public static class LineNumber {
        private InstructionHandle start;
        private char num;

        public InstructionHandle getStartPC() {
            return this.start;
        }

        public void setStartPC(InstructionHandle instructionHandle) {
            this.start = instructionHandle;
        }

        public jq_LineNumberBC finish() {
            char c = this.start == null ? (char)'\u0000' : (char)this.start.getPosition();
            return new jq_LineNumberBC(c, this.num);
        }

        public LineNumber(InstructionList instructionList, jq_LineNumberBC jq_LineNumberBC2) {
            this.start = instructionList.findHandle(jq_LineNumberBC2.getStartPC());
            if (this.start == null) {
                System.out.println("Cannot find index " + jq_LineNumberBC2.getStartPC() + " in " + instructionList);
            }
            this.num = jq_LineNumberBC2.getLineNum();
        }
    }

    public static abstract class EmptyVisitor
    implements Visitor {
        public void visitStackInstruction(StackInstruction stackInstruction) {
        }

        public void visitLocalVariableInstruction(LocalVariableInstruction localVariableInstruction) {
        }

        public void visitBranchInstruction(BranchInstruction branchInstruction) {
        }

        public void visitLoadClass(LoadClass loadClass) {
        }

        public void visitFieldInstruction(FieldInstruction fieldInstruction) {
        }

        public void visitIfInstruction(IfInstruction ifInstruction) {
        }

        public void visitConversionInstruction(ConversionInstruction conversionInstruction) {
        }

        public void visitPopInstruction(PopInstruction popInstruction) {
        }

        public void visitJsrInstruction(JsrInstruction jsrInstruction) {
        }

        public void visitGotoInstruction(GotoInstruction gotoInstruction) {
        }

        public void visitStoreInstruction(StoreInstruction storeInstruction) {
        }

        public void visitTypedInstruction(TypedInstruction typedInstruction) {
        }

        public void visitSelect(Select select) {
        }

        public void visitUnconditionalBranch(UnconditionalBranch unconditionalBranch) {
        }

        public void visitPushInstruction(PushInstruction pushInstruction) {
        }

        public void visitArithmeticInstruction(ArithmeticInstruction arithmeticInstruction) {
        }

        public void visitCPInstruction(CPInstruction cPInstruction) {
        }

        public void visitInvokeInstruction(InvokeInstruction invokeInstruction) {
        }

        public void visitArrayInstruction(ArrayInstruction arrayInstruction) {
        }

        public void visitAllocationInstruction(AllocationInstruction allocationInstruction) {
        }

        public void visitReturnInstruction(ReturnInstruction returnInstruction) {
        }

        public void visitFieldOrMethod(FieldOrMethod fieldOrMethod) {
        }

        public void visitConstantPushInstruction(ConstantPushInstruction constantPushInstruction) {
        }

        public void visitExceptionThrower(ExceptionThrower exceptionThrower) {
        }

        public void visitLoadInstruction(LoadInstruction loadInstruction) {
        }

        public void visitVariableLengthInstruction(VariableLengthInstruction variableLengthInstruction) {
        }

        public void visitStackProducer(StackProducer stackProducer) {
        }

        public void visitStackConsumer(StackConsumer stackConsumer) {
        }

        public void visitACONST_NULL(ACONST_NULL aCONST_NULL) {
        }

        public void visitGETSTATIC(GETSTATIC gETSTATIC) {
        }

        public void visitIF_ICMPLT(IF_ICMPLT iF_ICMPLT) {
        }

        public void visitMONITOREXIT(MONITOREXIT mONITOREXIT) {
        }

        public void visitIFLT(IFLT iFLT) {
        }

        public void visitLSTORE(LSTORE lSTORE) {
        }

        public void visitPOP2(POP2 pOP2) {
        }

        public void visitBASTORE(BASTORE bASTORE) {
        }

        public void visitISTORE(ISTORE iSTORE) {
        }

        public void visitCHECKCAST(CHECKCAST cHECKCAST) {
        }

        public void visitFCMPG(FCMPG fCMPG) {
        }

        public void visitI2F(I2F i2F) {
        }

        public void visitATHROW(ATHROW aTHROW) {
        }

        public void visitDCMPL(DCMPL dCMPL) {
        }

        public void visitARRAYLENGTH(ARRAYLENGTH aRRAYLENGTH) {
        }

        public void visitDUP(DUP dUP) {
        }

        public void visitINVOKESTATIC(INVOKESTATIC iNVOKESTATIC) {
        }

        public void visitLCONST(LCONST lCONST) {
        }

        public void visitDREM(DREM dREM) {
        }

        public void visitIFGE(IFGE iFGE) {
        }

        public void visitCALOAD(CALOAD cALOAD) {
        }

        public void visitLASTORE(LASTORE lASTORE) {
        }

        public void visitI2D(I2D i2D) {
        }

        public void visitDADD(DADD dADD) {
        }

        public void visitINVOKESPECIAL(INVOKESPECIAL iNVOKESPECIAL) {
        }

        public void visitIAND(IAND iAND) {
        }

        public void visitPUTFIELD(PUTFIELD pUTFIELD) {
        }

        public void visitILOAD(ILOAD iLOAD) {
        }

        public void visitDLOAD(DLOAD dLOAD) {
        }

        public void visitDCONST(DCONST dCONST) {
        }

        public void visitNEW(NEW nEW) {
        }

        public void visitIFNULL(IFNULL iFNULL) {
        }

        public void visitLSUB(LSUB lSUB) {
        }

        public void visitL2I(L2I l2I) {
        }

        public void visitISHR(ISHR iSHR) {
        }

        public void visitTABLESWITCH(TABLESWITCH tABLESWITCH) {
        }

        public void visitIINC(IINC iINC) {
        }

        public void visitDRETURN(DRETURN dRETURN) {
        }

        public void visitFSTORE(FSTORE fSTORE) {
        }

        public void visitDASTORE(DASTORE dASTORE) {
        }

        public void visitIALOAD(IALOAD iALOAD) {
        }

        public void visitDDIV(DDIV dDIV) {
        }

        public void visitIF_ICMPGE(IF_ICMPGE iF_ICMPGE) {
        }

        public void visitLAND(LAND lAND) {
        }

        public void visitIDIV(IDIV iDIV) {
        }

        public void visitLOR(LOR lOR) {
        }

        public void visitCASTORE(CASTORE cASTORE) {
        }

        public void visitFREM(FREM fREM) {
        }

        public void visitLDC(LDC lDC) {
        }

        public void visitBIPUSH(BIPUSH bIPUSH) {
        }

        public void visitDSTORE(DSTORE dSTORE) {
        }

        public void visitF2L(F2L f2L) {
        }

        public void visitFMUL(FMUL fMUL) {
        }

        public void visitLLOAD(LLOAD lLOAD) {
        }

        public void visitJSR(JSR jSR) {
        }

        public void visitFSUB(FSUB fSUB) {
        }

        public void visitSASTORE(SASTORE sASTORE) {
        }

        public void visitALOAD(ALOAD aLOAD) {
        }

        public void visitDUP2_X2(DUP2_X2 dUP2_X2) {
        }

        public void visitRETURN(RETURN rETURN) {
        }

        public void visitDALOAD(DALOAD dALOAD) {
        }

        public void visitSIPUSH(SIPUSH sIPUSH) {
        }

        public void visitDSUB(DSUB dSUB) {
        }

        public void visitL2F(L2F l2F) {
        }

        public void visitIF_ICMPGT(IF_ICMPGT iF_ICMPGT) {
        }

        public void visitF2D(F2D f2D) {
        }

        public void visitI2L(I2L i2L) {
        }

        public void visitIF_ACMPNE(IF_ACMPNE iF_ACMPNE) {
        }

        public void visitPOP(POP pOP) {
        }

        public void visitI2S(I2S i2S) {
        }

        public void visitIFEQ(IFEQ iFEQ) {
        }

        public void visitSWAP(SWAP sWAP) {
        }

        public void visitIOR(IOR iOR) {
        }

        public void visitIREM(IREM iREM) {
        }

        public void visitIASTORE(IASTORE iASTORE) {
        }

        public void visitNEWARRAY(NEWARRAY nEWARRAY) {
        }

        public void visitINVOKEINTERFACE(INVOKEINTERFACE iNVOKEINTERFACE) {
        }

        public void visitINEG(INEG iNEG) {
        }

        public void visitLCMP(LCMP lCMP) {
        }

        public void visitJSR_W(JSR_W jSR_W) {
        }

        public void visitMULTIANEWARRAY(MULTIANEWARRAY mULTIANEWARRAY) {
        }

        public void visitDUP_X2(DUP_X2 dUP_X2) {
        }

        public void visitSALOAD(SALOAD sALOAD) {
        }

        public void visitIFNONNULL(IFNONNULL iFNONNULL) {
        }

        public void visitDMUL(DMUL dMUL) {
        }

        public void visitIFNE(IFNE iFNE) {
        }

        public void visitIF_ICMPLE(IF_ICMPLE iF_ICMPLE) {
        }

        public void visitLDC2_W(LDC2_W lDC2_W) {
        }

        public void visitGETFIELD(GETFIELD gETFIELD) {
        }

        public void visitLADD(LADD lADD) {
        }

        public void visitNOP(NOP nOP) {
        }

        public void visitFALOAD(FALOAD fALOAD) {
        }

        public void visitINSTANCEOF(INSTANCEOF iNSTANCEOF) {
        }

        public void visitIFLE(IFLE iFLE) {
        }

        public void visitLXOR(LXOR lXOR) {
        }

        public void visitLRETURN(LRETURN lRETURN) {
        }

        public void visitFCONST(FCONST fCONST) {
        }

        public void visitIUSHR(IUSHR iUSHR) {
        }

        public void visitBALOAD(BALOAD bALOAD) {
        }

        public void visitDUP2(DUP2 dUP2) {
        }

        public void visitIF_ACMPEQ(IF_ACMPEQ iF_ACMPEQ) {
        }

        public void visitMONITORENTER(MONITORENTER mONITORENTER) {
        }

        public void visitLSHL(LSHL lSHL) {
        }

        public void visitDCMPG(DCMPG dCMPG) {
        }

        public void visitD2L(D2L d2L) {
        }

        public void visitL2D(L2D l2D) {
        }

        public void visitRET(RET rET) {
        }

        public void visitIFGT(IFGT iFGT) {
        }

        public void visitIXOR(IXOR iXOR) {
        }

        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL iNVOKEVIRTUAL) {
        }

        public void visitFASTORE(FASTORE fASTORE) {
        }

        public void visitIRETURN(IRETURN iRETURN) {
        }

        public void visitIF_ICMPNE(IF_ICMPNE iF_ICMPNE) {
        }

        public void visitFLOAD(FLOAD fLOAD) {
        }

        public void visitLDIV(LDIV lDIV) {
        }

        public void visitPUTSTATIC(PUTSTATIC pUTSTATIC) {
        }

        public void visitAALOAD(AALOAD aALOAD) {
        }

        public void visitD2I(D2I d2I) {
        }

        public void visitIF_ICMPEQ(IF_ICMPEQ iF_ICMPEQ) {
        }

        public void visitAASTORE(AASTORE aASTORE) {
        }

        public void visitARETURN(ARETURN aRETURN) {
        }

        public void visitDUP2_X1(DUP2_X1 dUP2_X1) {
        }

        public void visitFNEG(FNEG fNEG) {
        }

        public void visitGOTO_W(GOTO_W gOTO_W) {
        }

        public void visitD2F(D2F d2F) {
        }

        public void visitGOTO(GOTO gOTO) {
        }

        public void visitISUB(ISUB iSUB) {
        }

        public void visitF2I(F2I f2I) {
        }

        public void visitDNEG(DNEG dNEG) {
        }

        public void visitICONST(ICONST iCONST) {
        }

        public void visitFDIV(FDIV fDIV) {
        }

        public void visitI2B(I2B i2B) {
        }

        public void visitLNEG(LNEG lNEG) {
        }

        public void visitLREM(LREM lREM) {
        }

        public void visitIMUL(IMUL iMUL) {
        }

        public void visitIADD(IADD iADD) {
        }

        public void visitLSHR(LSHR lSHR) {
        }

        public void visitLOOKUPSWITCH(LOOKUPSWITCH lOOKUPSWITCH) {
        }

        public void visitDUP_X1(DUP_X1 dUP_X1) {
        }

        public void visitFCMPL(FCMPL fCMPL) {
        }

        public void visitI2C(I2C i2C) {
        }

        public void visitLMUL(LMUL lMUL) {
        }

        public void visitLUSHR(LUSHR lUSHR) {
        }

        public void visitISHL(ISHL iSHL) {
        }

        public void visitLALOAD(LALOAD lALOAD) {
        }

        public void visitASTORE(ASTORE aSTORE) {
        }

        public void visitANEWARRAY(ANEWARRAY aNEWARRAY) {
        }

        public void visitFRETURN(FRETURN fRETURN) {
        }

        public void visitFADD(FADD fADD) {
        }

        public void visitBREAKPOINT(BREAKPOINT bREAKPOINT) {
        }
    }

    public static interface InstructionListObserver {
        public void notify(InstructionList var1);
    }

    public static interface AllocationInstruction {
    }

    public static interface CompoundInstruction {
        public InstructionList getInstructionList();
    }

    public static interface ConstantPushInstruction
    extends PushInstruction,
    TypedInstruction {
        public Number getValue();
    }

    public static interface ExceptionThrower {
        public Set getExceptions();
    }

    public static interface IndexedInstruction {
        public int getIndex();

        public void setIndex(int var1);
    }

    public static interface InstructionTargeter {
        public boolean containsTarget(InstructionHandle var1);

        public void updateTarget(InstructionHandle var1, InstructionHandle var2);
    }

    public static interface LoadClass {
        public jq_Class getLoadClassType();

        public jq_Type getType();
    }

    public static interface PopInstruction
    extends StackConsumer {
    }

    public static interface PushInstruction
    extends StackProducer {
    }

    public static interface StackConsumer {
        public int consumeStack();
    }

    public static interface StackProducer {
        public int produceStack();
    }

    public static interface TypedInstruction {
        public jq_Type getType();
    }

    public static interface UnconditionalBranch {
    }

    public static interface VariableLengthInstruction {
    }

    public static interface InstructionConstants {
        public static final Instruction NOP = new NOP();
        public static final Instruction ACONST_NULL = new ACONST_NULL();
        public static final Instruction ICONST_M1 = new ICONST(-1);
        public static final Instruction ICONST_0 = new ICONST(0);
        public static final Instruction ICONST_1 = new ICONST(1);
        public static final Instruction ICONST_2 = new ICONST(2);
        public static final Instruction ICONST_3 = new ICONST(3);
        public static final Instruction ICONST_4 = new ICONST(4);
        public static final Instruction ICONST_5 = new ICONST(5);
        public static final Instruction LCONST_0 = new LCONST(0L);
        public static final Instruction LCONST_1 = new LCONST(1L);
        public static final Instruction FCONST_0 = new FCONST(0.0f);
        public static final Instruction FCONST_1 = new FCONST(1.0f);
        public static final Instruction FCONST_2 = new FCONST(2.0f);
        public static final Instruction DCONST_0 = new DCONST(0.0);
        public static final Instruction DCONST_1 = new DCONST(1.0);
        public static final ArrayInstruction IALOAD = new IALOAD();
        public static final ArrayInstruction LALOAD = new LALOAD();
        public static final ArrayInstruction FALOAD = new FALOAD();
        public static final ArrayInstruction DALOAD = new DALOAD();
        public static final ArrayInstruction AALOAD = new AALOAD();
        public static final ArrayInstruction BALOAD = new BALOAD();
        public static final ArrayInstruction CALOAD = new CALOAD();
        public static final ArrayInstruction SALOAD = new SALOAD();
        public static final ArrayInstruction IASTORE = new IASTORE();
        public static final ArrayInstruction LASTORE = new LASTORE();
        public static final ArrayInstruction FASTORE = new FASTORE();
        public static final ArrayInstruction DASTORE = new DASTORE();
        public static final ArrayInstruction AASTORE = new AASTORE();
        public static final ArrayInstruction BASTORE = new BASTORE();
        public static final ArrayInstruction CASTORE = new CASTORE();
        public static final ArrayInstruction SASTORE = new SASTORE();
        public static final StackInstruction POP = new POP();
        public static final StackInstruction POP2 = new POP2();
        public static final StackInstruction DUP = new DUP();
        public static final StackInstruction DUP_X1 = new DUP_X1();
        public static final StackInstruction DUP_X2 = new DUP_X2();
        public static final StackInstruction DUP2 = new DUP2();
        public static final StackInstruction DUP2_X1 = new DUP2_X1();
        public static final StackInstruction DUP2_X2 = new DUP2_X2();
        public static final StackInstruction SWAP = new SWAP();
        public static final ArithmeticInstruction IADD = new IADD();
        public static final ArithmeticInstruction LADD = new LADD();
        public static final ArithmeticInstruction FADD = new FADD();
        public static final ArithmeticInstruction DADD = new DADD();
        public static final ArithmeticInstruction ISUB = new ISUB();
        public static final ArithmeticInstruction LSUB = new LSUB();
        public static final ArithmeticInstruction FSUB = new FSUB();
        public static final ArithmeticInstruction DSUB = new DSUB();
        public static final ArithmeticInstruction IMUL = new IMUL();
        public static final ArithmeticInstruction LMUL = new LMUL();
        public static final ArithmeticInstruction FMUL = new FMUL();
        public static final ArithmeticInstruction DMUL = new DMUL();
        public static final ArithmeticInstruction IDIV = new IDIV();
        public static final ArithmeticInstruction LDIV = new LDIV();
        public static final ArithmeticInstruction FDIV = new FDIV();
        public static final ArithmeticInstruction DDIV = new DDIV();
        public static final ArithmeticInstruction IREM = new IREM();
        public static final ArithmeticInstruction LREM = new LREM();
        public static final ArithmeticInstruction FREM = new FREM();
        public static final ArithmeticInstruction DREM = new DREM();
        public static final ArithmeticInstruction INEG = new INEG();
        public static final ArithmeticInstruction LNEG = new LNEG();
        public static final ArithmeticInstruction FNEG = new FNEG();
        public static final ArithmeticInstruction DNEG = new DNEG();
        public static final ArithmeticInstruction ISHL = new ISHL();
        public static final ArithmeticInstruction LSHL = new LSHL();
        public static final ArithmeticInstruction ISHR = new ISHR();
        public static final ArithmeticInstruction LSHR = new LSHR();
        public static final ArithmeticInstruction IUSHR = new IUSHR();
        public static final ArithmeticInstruction LUSHR = new LUSHR();
        public static final ArithmeticInstruction IAND = new IAND();
        public static final ArithmeticInstruction LAND = new LAND();
        public static final ArithmeticInstruction IOR = new IOR();
        public static final ArithmeticInstruction LOR = new LOR();
        public static final ArithmeticInstruction IXOR = new IXOR();
        public static final ArithmeticInstruction LXOR = new LXOR();
        public static final ConversionInstruction I2L = new I2L();
        public static final ConversionInstruction I2F = new I2F();
        public static final ConversionInstruction I2D = new I2D();
        public static final ConversionInstruction L2I = new L2I();
        public static final ConversionInstruction L2F = new L2F();
        public static final ConversionInstruction L2D = new L2D();
        public static final ConversionInstruction F2I = new F2I();
        public static final ConversionInstruction F2L = new F2L();
        public static final ConversionInstruction F2D = new F2D();
        public static final ConversionInstruction D2I = new D2I();
        public static final ConversionInstruction D2L = new D2L();
        public static final ConversionInstruction D2F = new D2F();
        public static final ConversionInstruction I2B = new I2B();
        public static final ConversionInstruction I2C = new I2C();
        public static final ConversionInstruction I2S = new I2S();
        public static final Instruction LCMP = new LCMP();
        public static final Instruction FCMPL = new FCMPL();
        public static final Instruction FCMPG = new FCMPG();
        public static final Instruction DCMPL = new DCMPL();
        public static final Instruction DCMPG = new DCMPG();
        public static final ReturnInstruction IRETURN = new IRETURN();
        public static final ReturnInstruction LRETURN = new LRETURN();
        public static final ReturnInstruction FRETURN = new FRETURN();
        public static final ReturnInstruction DRETURN = new DRETURN();
        public static final ReturnInstruction ARETURN = new ARETURN();
        public static final ReturnInstruction RETURN = new RETURN();
        public static final Instruction ARRAYLENGTH = new ARRAYLENGTH();
        public static final Instruction ATHROW = new ATHROW();
        public static final Instruction MONITORENTER = new MONITORENTER();
        public static final Instruction MONITOREXIT = new MONITOREXIT();
        public static final LocalVariableInstruction THIS;
        public static final LocalVariableInstruction ALOAD_0;
        public static final LocalVariableInstruction ALOAD_1;
        public static final LocalVariableInstruction ALOAD_2;
        public static final LocalVariableInstruction ILOAD_0;
        public static final LocalVariableInstruction ILOAD_1;
        public static final LocalVariableInstruction ILOAD_2;
        public static final LocalVariableInstruction ASTORE_0;
        public static final LocalVariableInstruction ASTORE_1;
        public static final LocalVariableInstruction ASTORE_2;
        public static final LocalVariableInstruction ISTORE_0;
        public static final LocalVariableInstruction ISTORE_1;
        public static final LocalVariableInstruction ISTORE_2;
        public static final Instruction[] INSTRUCTIONS;
        public static final Clinit bla;

        static {
            ALOAD_0 = THIS = new ALOAD(0);
            ALOAD_1 = new ALOAD(1);
            ALOAD_2 = new ALOAD(2);
            ILOAD_0 = new ILOAD(0);
            ILOAD_1 = new ILOAD(1);
            ILOAD_2 = new ILOAD(2);
            ASTORE_0 = new ASTORE(0);
            ASTORE_1 = new ASTORE(1);
            ASTORE_2 = new ASTORE(2);
            ISTORE_0 = new ISTORE(0);
            ISTORE_1 = new ISTORE(1);
            ISTORE_2 = new ISTORE(2);
            INSTRUCTIONS = new Instruction[256];
            bla = new Clinit();
        }

        public static class Clinit {
            Clinit() {
                InstructionConstants.INSTRUCTIONS[0] = NOP;
                InstructionConstants.INSTRUCTIONS[1] = ACONST_NULL;
                InstructionConstants.INSTRUCTIONS[2] = ICONST_M1;
                InstructionConstants.INSTRUCTIONS[3] = ICONST_0;
                InstructionConstants.INSTRUCTIONS[4] = ICONST_1;
                InstructionConstants.INSTRUCTIONS[5] = ICONST_2;
                InstructionConstants.INSTRUCTIONS[6] = ICONST_3;
                InstructionConstants.INSTRUCTIONS[7] = ICONST_4;
                InstructionConstants.INSTRUCTIONS[8] = ICONST_5;
                InstructionConstants.INSTRUCTIONS[9] = LCONST_0;
                InstructionConstants.INSTRUCTIONS[10] = LCONST_1;
                InstructionConstants.INSTRUCTIONS[11] = FCONST_0;
                InstructionConstants.INSTRUCTIONS[12] = FCONST_1;
                InstructionConstants.INSTRUCTIONS[13] = FCONST_2;
                InstructionConstants.INSTRUCTIONS[14] = DCONST_0;
                InstructionConstants.INSTRUCTIONS[15] = DCONST_1;
                InstructionConstants.INSTRUCTIONS[46] = IALOAD;
                InstructionConstants.INSTRUCTIONS[47] = LALOAD;
                InstructionConstants.INSTRUCTIONS[48] = FALOAD;
                InstructionConstants.INSTRUCTIONS[49] = DALOAD;
                InstructionConstants.INSTRUCTIONS[50] = AALOAD;
                InstructionConstants.INSTRUCTIONS[51] = BALOAD;
                InstructionConstants.INSTRUCTIONS[52] = CALOAD;
                InstructionConstants.INSTRUCTIONS[53] = SALOAD;
                InstructionConstants.INSTRUCTIONS[79] = IASTORE;
                InstructionConstants.INSTRUCTIONS[80] = LASTORE;
                InstructionConstants.INSTRUCTIONS[81] = FASTORE;
                InstructionConstants.INSTRUCTIONS[82] = DASTORE;
                InstructionConstants.INSTRUCTIONS[83] = AASTORE;
                InstructionConstants.INSTRUCTIONS[84] = BASTORE;
                InstructionConstants.INSTRUCTIONS[85] = CASTORE;
                InstructionConstants.INSTRUCTIONS[86] = SASTORE;
                InstructionConstants.INSTRUCTIONS[87] = POP;
                InstructionConstants.INSTRUCTIONS[88] = POP2;
                InstructionConstants.INSTRUCTIONS[89] = DUP;
                InstructionConstants.INSTRUCTIONS[90] = DUP_X1;
                InstructionConstants.INSTRUCTIONS[91] = DUP_X2;
                InstructionConstants.INSTRUCTIONS[92] = DUP2;
                InstructionConstants.INSTRUCTIONS[93] = DUP2_X1;
                InstructionConstants.INSTRUCTIONS[94] = DUP2_X2;
                InstructionConstants.INSTRUCTIONS[95] = SWAP;
                InstructionConstants.INSTRUCTIONS[96] = IADD;
                InstructionConstants.INSTRUCTIONS[97] = LADD;
                InstructionConstants.INSTRUCTIONS[98] = FADD;
                InstructionConstants.INSTRUCTIONS[99] = DADD;
                InstructionConstants.INSTRUCTIONS[100] = ISUB;
                InstructionConstants.INSTRUCTIONS[101] = LSUB;
                InstructionConstants.INSTRUCTIONS[102] = FSUB;
                InstructionConstants.INSTRUCTIONS[103] = DSUB;
                InstructionConstants.INSTRUCTIONS[104] = IMUL;
                InstructionConstants.INSTRUCTIONS[105] = LMUL;
                InstructionConstants.INSTRUCTIONS[106] = FMUL;
                InstructionConstants.INSTRUCTIONS[107] = DMUL;
                InstructionConstants.INSTRUCTIONS[108] = IDIV;
                InstructionConstants.INSTRUCTIONS[109] = LDIV;
                InstructionConstants.INSTRUCTIONS[110] = FDIV;
                InstructionConstants.INSTRUCTIONS[111] = DDIV;
                InstructionConstants.INSTRUCTIONS[112] = IREM;
                InstructionConstants.INSTRUCTIONS[113] = LREM;
                InstructionConstants.INSTRUCTIONS[114] = FREM;
                InstructionConstants.INSTRUCTIONS[115] = DREM;
                InstructionConstants.INSTRUCTIONS[116] = INEG;
                InstructionConstants.INSTRUCTIONS[117] = LNEG;
                InstructionConstants.INSTRUCTIONS[118] = FNEG;
                InstructionConstants.INSTRUCTIONS[119] = DNEG;
                InstructionConstants.INSTRUCTIONS[120] = ISHL;
                InstructionConstants.INSTRUCTIONS[121] = LSHL;
                InstructionConstants.INSTRUCTIONS[122] = ISHR;
                InstructionConstants.INSTRUCTIONS[123] = LSHR;
                InstructionConstants.INSTRUCTIONS[124] = IUSHR;
                InstructionConstants.INSTRUCTIONS[125] = LUSHR;
                InstructionConstants.INSTRUCTIONS[126] = IAND;
                InstructionConstants.INSTRUCTIONS[127] = LAND;
                InstructionConstants.INSTRUCTIONS[128] = IOR;
                InstructionConstants.INSTRUCTIONS[129] = LOR;
                InstructionConstants.INSTRUCTIONS[130] = IXOR;
                InstructionConstants.INSTRUCTIONS[131] = LXOR;
                InstructionConstants.INSTRUCTIONS[133] = I2L;
                InstructionConstants.INSTRUCTIONS[134] = I2F;
                InstructionConstants.INSTRUCTIONS[135] = I2D;
                InstructionConstants.INSTRUCTIONS[136] = L2I;
                InstructionConstants.INSTRUCTIONS[137] = L2F;
                InstructionConstants.INSTRUCTIONS[138] = L2D;
                InstructionConstants.INSTRUCTIONS[139] = F2I;
                InstructionConstants.INSTRUCTIONS[140] = F2L;
                InstructionConstants.INSTRUCTIONS[141] = F2D;
                InstructionConstants.INSTRUCTIONS[142] = D2I;
                InstructionConstants.INSTRUCTIONS[143] = D2L;
                InstructionConstants.INSTRUCTIONS[144] = D2F;
                InstructionConstants.INSTRUCTIONS[145] = I2B;
                InstructionConstants.INSTRUCTIONS[146] = I2C;
                InstructionConstants.INSTRUCTIONS[147] = I2S;
                InstructionConstants.INSTRUCTIONS[148] = LCMP;
                InstructionConstants.INSTRUCTIONS[149] = FCMPL;
                InstructionConstants.INSTRUCTIONS[150] = FCMPG;
                InstructionConstants.INSTRUCTIONS[151] = DCMPL;
                InstructionConstants.INSTRUCTIONS[152] = DCMPG;
                InstructionConstants.INSTRUCTIONS[172] = IRETURN;
                InstructionConstants.INSTRUCTIONS[173] = LRETURN;
                InstructionConstants.INSTRUCTIONS[174] = FRETURN;
                InstructionConstants.INSTRUCTIONS[175] = DRETURN;
                InstructionConstants.INSTRUCTIONS[176] = ARETURN;
                InstructionConstants.INSTRUCTIONS[177] = RETURN;
                InstructionConstants.INSTRUCTIONS[190] = ARRAYLENGTH;
                InstructionConstants.INSTRUCTIONS[191] = ATHROW;
                InstructionConstants.INSTRUCTIONS[194] = MONITORENTER;
                InstructionConstants.INSTRUCTIONS[195] = MONITOREXIT;
            }
        }
    }

    public static interface Visitor {
        public void visitStackInstruction(StackInstruction var1);

        public void visitLocalVariableInstruction(LocalVariableInstruction var1);

        public void visitBranchInstruction(BranchInstruction var1);

        public void visitLoadClass(LoadClass var1);

        public void visitFieldInstruction(FieldInstruction var1);

        public void visitIfInstruction(IfInstruction var1);

        public void visitConversionInstruction(ConversionInstruction var1);

        public void visitPopInstruction(PopInstruction var1);

        public void visitStoreInstruction(StoreInstruction var1);

        public void visitTypedInstruction(TypedInstruction var1);

        public void visitSelect(Select var1);

        public void visitJsrInstruction(JsrInstruction var1);

        public void visitGotoInstruction(GotoInstruction var1);

        public void visitUnconditionalBranch(UnconditionalBranch var1);

        public void visitPushInstruction(PushInstruction var1);

        public void visitArithmeticInstruction(ArithmeticInstruction var1);

        public void visitCPInstruction(CPInstruction var1);

        public void visitInvokeInstruction(InvokeInstruction var1);

        public void visitArrayInstruction(ArrayInstruction var1);

        public void visitAllocationInstruction(AllocationInstruction var1);

        public void visitReturnInstruction(ReturnInstruction var1);

        public void visitFieldOrMethod(FieldOrMethod var1);

        public void visitConstantPushInstruction(ConstantPushInstruction var1);

        public void visitExceptionThrower(ExceptionThrower var1);

        public void visitLoadInstruction(LoadInstruction var1);

        public void visitVariableLengthInstruction(VariableLengthInstruction var1);

        public void visitStackProducer(StackProducer var1);

        public void visitStackConsumer(StackConsumer var1);

        public void visitACONST_NULL(ACONST_NULL var1);

        public void visitGETSTATIC(GETSTATIC var1);

        public void visitIF_ICMPLT(IF_ICMPLT var1);

        public void visitMONITOREXIT(MONITOREXIT var1);

        public void visitIFLT(IFLT var1);

        public void visitLSTORE(LSTORE var1);

        public void visitPOP2(POP2 var1);

        public void visitBASTORE(BASTORE var1);

        public void visitISTORE(ISTORE var1);

        public void visitCHECKCAST(CHECKCAST var1);

        public void visitFCMPG(FCMPG var1);

        public void visitI2F(I2F var1);

        public void visitATHROW(ATHROW var1);

        public void visitDCMPL(DCMPL var1);

        public void visitARRAYLENGTH(ARRAYLENGTH var1);

        public void visitDUP(DUP var1);

        public void visitINVOKESTATIC(INVOKESTATIC var1);

        public void visitLCONST(LCONST var1);

        public void visitDREM(DREM var1);

        public void visitIFGE(IFGE var1);

        public void visitCALOAD(CALOAD var1);

        public void visitLASTORE(LASTORE var1);

        public void visitI2D(I2D var1);

        public void visitDADD(DADD var1);

        public void visitINVOKESPECIAL(INVOKESPECIAL var1);

        public void visitIAND(IAND var1);

        public void visitPUTFIELD(PUTFIELD var1);

        public void visitILOAD(ILOAD var1);

        public void visitDLOAD(DLOAD var1);

        public void visitDCONST(DCONST var1);

        public void visitNEW(NEW var1);

        public void visitIFNULL(IFNULL var1);

        public void visitLSUB(LSUB var1);

        public void visitL2I(L2I var1);

        public void visitISHR(ISHR var1);

        public void visitTABLESWITCH(TABLESWITCH var1);

        public void visitIINC(IINC var1);

        public void visitDRETURN(DRETURN var1);

        public void visitFSTORE(FSTORE var1);

        public void visitDASTORE(DASTORE var1);

        public void visitIALOAD(IALOAD var1);

        public void visitDDIV(DDIV var1);

        public void visitIF_ICMPGE(IF_ICMPGE var1);

        public void visitLAND(LAND var1);

        public void visitIDIV(IDIV var1);

        public void visitLOR(LOR var1);

        public void visitCASTORE(CASTORE var1);

        public void visitFREM(FREM var1);

        public void visitLDC(LDC var1);

        public void visitBIPUSH(BIPUSH var1);

        public void visitDSTORE(DSTORE var1);

        public void visitF2L(F2L var1);

        public void visitFMUL(FMUL var1);

        public void visitLLOAD(LLOAD var1);

        public void visitJSR(JSR var1);

        public void visitFSUB(FSUB var1);

        public void visitSASTORE(SASTORE var1);

        public void visitALOAD(ALOAD var1);

        public void visitDUP2_X2(DUP2_X2 var1);

        public void visitRETURN(RETURN var1);

        public void visitDALOAD(DALOAD var1);

        public void visitSIPUSH(SIPUSH var1);

        public void visitDSUB(DSUB var1);

        public void visitL2F(L2F var1);

        public void visitIF_ICMPGT(IF_ICMPGT var1);

        public void visitF2D(F2D var1);

        public void visitI2L(I2L var1);

        public void visitIF_ACMPNE(IF_ACMPNE var1);

        public void visitPOP(POP var1);

        public void visitI2S(I2S var1);

        public void visitIFEQ(IFEQ var1);

        public void visitSWAP(SWAP var1);

        public void visitIOR(IOR var1);

        public void visitIREM(IREM var1);

        public void visitIASTORE(IASTORE var1);

        public void visitNEWARRAY(NEWARRAY var1);

        public void visitINVOKEINTERFACE(INVOKEINTERFACE var1);

        public void visitINEG(INEG var1);

        public void visitLCMP(LCMP var1);

        public void visitJSR_W(JSR_W var1);

        public void visitMULTIANEWARRAY(MULTIANEWARRAY var1);

        public void visitDUP_X2(DUP_X2 var1);

        public void visitSALOAD(SALOAD var1);

        public void visitIFNONNULL(IFNONNULL var1);

        public void visitDMUL(DMUL var1);

        public void visitIFNE(IFNE var1);

        public void visitIF_ICMPLE(IF_ICMPLE var1);

        public void visitLDC2_W(LDC2_W var1);

        public void visitGETFIELD(GETFIELD var1);

        public void visitLADD(LADD var1);

        public void visitNOP(NOP var1);

        public void visitFALOAD(FALOAD var1);

        public void visitINSTANCEOF(INSTANCEOF var1);

        public void visitIFLE(IFLE var1);

        public void visitLXOR(LXOR var1);

        public void visitLRETURN(LRETURN var1);

        public void visitFCONST(FCONST var1);

        public void visitIUSHR(IUSHR var1);

        public void visitBALOAD(BALOAD var1);

        public void visitDUP2(DUP2 var1);

        public void visitIF_ACMPEQ(IF_ACMPEQ var1);

        public void visitMONITORENTER(MONITORENTER var1);

        public void visitLSHL(LSHL var1);

        public void visitDCMPG(DCMPG var1);

        public void visitD2L(D2L var1);

        public void visitL2D(L2D var1);

        public void visitRET(RET var1);

        public void visitIFGT(IFGT var1);

        public void visitIXOR(IXOR var1);

        public void visitINVOKEVIRTUAL(INVOKEVIRTUAL var1);

        public void visitFASTORE(FASTORE var1);

        public void visitIRETURN(IRETURN var1);

        public void visitIF_ICMPNE(IF_ICMPNE var1);

        public void visitFLOAD(FLOAD var1);

        public void visitLDIV(LDIV var1);

        public void visitPUTSTATIC(PUTSTATIC var1);

        public void visitAALOAD(AALOAD var1);

        public void visitD2I(D2I var1);

        public void visitIF_ICMPEQ(IF_ICMPEQ var1);

        public void visitAASTORE(AASTORE var1);

        public void visitARETURN(ARETURN var1);

        public void visitDUP2_X1(DUP2_X1 var1);

        public void visitFNEG(FNEG var1);

        public void visitGOTO_W(GOTO_W var1);

        public void visitD2F(D2F var1);

        public void visitGOTO(GOTO var1);

        public void visitISUB(ISUB var1);

        public void visitF2I(F2I var1);

        public void visitDNEG(DNEG var1);

        public void visitICONST(ICONST var1);

        public void visitFDIV(FDIV var1);

        public void visitI2B(I2B var1);

        public void visitLNEG(LNEG var1);

        public void visitLREM(LREM var1);

        public void visitIMUL(IMUL var1);

        public void visitIADD(IADD var1);

        public void visitLSHR(LSHR var1);

        public void visitLOOKUPSWITCH(LOOKUPSWITCH var1);

        public void visitDUP_X1(DUP_X1 var1);

        public void visitFCMPL(FCMPL var1);

        public void visitI2C(I2C var1);

        public void visitLMUL(LMUL var1);

        public void visitLUSHR(LUSHR var1);

        public void visitISHL(ISHL var1);

        public void visitLALOAD(LALOAD var1);

        public void visitASTORE(ASTORE var1);

        public void visitANEWARRAY(ANEWARRAY var1);

        public void visitFRETURN(FRETURN var1);

        public void visitFADD(FADD var1);

        public void visitBREAKPOINT(BREAKPOINT var1);
    }
}

