/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.BytecodeAnalysis;

import Clazz.jq_Array;
import Clazz.jq_Class;
import Clazz.jq_ClassFileConstants;
import Clazz.jq_InstanceField;
import Clazz.jq_InstanceMethod;
import Clazz.jq_Member;
import Clazz.jq_Method;
import Clazz.jq_Primitive;
import Clazz.jq_StaticField;
import Clazz.jq_StaticMethod;
import Clazz.jq_Type;
import Compil3r.CompilationConstants;
import Compil3r.CompilationState;
import Util.Assert;
import Util.Strings;
import java.io.PrintStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BytecodeVisitor
implements jq_ClassFileConstants,
CompilationConstants {
    public static final byte BINOP_ADD = 0;
    public static final byte BINOP_SUB = 1;
    public static final byte BINOP_MUL = 2;
    public static final byte BINOP_DIV = 3;
    public static final byte BINOP_REM = 4;
    public static final byte BINOP_AND = 5;
    public static final byte BINOP_OR = 6;
    public static final byte BINOP_XOR = 7;
    public static final String[] binopnames = new String[]{"ADD", "SUB", "MUL", "DIV", "REM", "AND", "OR", "XOR"};
    public static final byte UNOP_NEG = 0;
    public static final String[] unopnames = new String[]{"NEG"};
    public static final byte SHIFT_LEFT = 0;
    public static final byte SHIFT_RIGHT = 1;
    public static final byte SHIFT_URIGHT = 2;
    public static final String[] shiftopnames = new String[]{"LEFT", "RIGHT", "URIGHT"};
    public static final byte CMP_L = 0;
    public static final byte CMP_G = 1;
    public static final String[] fcmpopnames = new String[]{"L", "G"};
    public static final byte CMP_EQ = 0;
    public static final byte CMP_NE = 1;
    public static final byte CMP_LT = 2;
    public static final byte CMP_GE = 3;
    public static final byte CMP_LE = 4;
    public static final byte CMP_GT = 5;
    public static final byte CMP_AE = 6;
    public static final byte CMP_UNCOND = 7;
    public static final String[] cmpopnames = new String[]{"EQ", "NE", "LT", "GE", "LE", "GT", "AE", "UNCOND"};
    public static final byte INVOKE_VIRTUAL = 0;
    public static final byte INVOKE_STATIC = 1;
    public static final byte INVOKE_SPECIAL = 2;
    public static final byte INVOKE_INTERFACE = 3;
    public static final String[] invokeopnames = new String[]{"VIRTUAL", "STATIC", "SPECIAL", "INTERFACE"};
    public static final byte MONITOR_ENTER = 0;
    public static final byte MONITOR_EXIT = 1;
    public static final String[] monitoropnames = new String[]{"ENTER", "EXIT"};
    protected final CompilationState state;
    protected final jq_Class clazz;
    protected final jq_Method method;
    protected final byte[] bcs;
    protected int i_start;
    protected int i_end;
    protected boolean TRACE;
    protected PrintStream out;

    public void forwardTraversal() throws VerifyError {
        this.i_end = -1;
        while (true) {
            this.i_start = this.i_end + 1;
            if (this.i_start >= this.bcs.length) break;
            this.visitBytecode();
        }
    }

    public jq_StaticField tryResolve(jq_StaticField jq_StaticField2) {
        try {
            jq_StaticField jq_StaticField3 = (jq_StaticField)this.state.tryResolve(jq_StaticField2);
            if (jq_StaticField2 != jq_StaticField3) {
                this.updateMemberReference(jq_StaticField3, (byte)14);
            }
            return jq_StaticField3;
        }
        catch (Error error) {
            System.err.println("Method " + this.method + " bc index " + this.i_start + ": Error when resolving " + jq_StaticField2 + ": " + error);
            throw error;
        }
    }

    public jq_InstanceField tryResolve(jq_InstanceField jq_InstanceField2) {
        try {
            jq_InstanceField jq_InstanceField3 = (jq_InstanceField)this.state.tryResolve(jq_InstanceField2);
            if (jq_InstanceField2 != jq_InstanceField3) {
                this.updateMemberReference(jq_InstanceField3, (byte)15);
            }
            return jq_InstanceField3;
        }
        catch (Error error) {
            System.err.println("Method " + this.method + " bc index " + this.i_start + ": Error when resolving " + jq_InstanceField2 + ": " + error);
            throw error;
        }
    }

    public jq_StaticMethod tryResolve(jq_StaticMethod jq_StaticMethod2) {
        try {
            jq_StaticMethod jq_StaticMethod3 = (jq_StaticMethod)this.state.tryResolve(jq_StaticMethod2);
            if (jq_StaticMethod2 != jq_StaticMethod3) {
                this.updateMemberReference(jq_StaticMethod3, (byte)16);
            }
            return jq_StaticMethod3;
        }
        catch (Error error) {
            System.err.println("Method " + this.method + " bc index " + this.i_start + ": Error when resolving " + jq_StaticMethod2 + ": " + error);
            throw error;
        }
    }

    public jq_InstanceMethod tryResolve(jq_InstanceMethod jq_InstanceMethod2) {
        try {
            jq_InstanceMethod jq_InstanceMethod3 = (jq_InstanceMethod)this.state.tryResolve(jq_InstanceMethod2);
            if (jq_InstanceMethod2 != jq_InstanceMethod3) {
                this.updateMemberReference(jq_InstanceMethod3, (byte)17);
            }
            return jq_InstanceMethod3;
        }
        catch (Error error) {
            System.err.println("Method " + this.method + " bc index " + this.i_start + ": Error when resolving " + jq_InstanceMethod2 + ": " + error);
            throw error;
        }
    }

    public jq_Member tryResolve(jq_Member jq_Member2) {
        try {
            jq_Member jq_Member3 = this.state.tryResolve(jq_Member2);
            if (jq_Member2 != jq_Member3) {
                int n = 0;
                if (jq_Member2 instanceof jq_InstanceField) {
                    n = 15;
                } else if (jq_Member2 instanceof jq_StaticField) {
                    n = 14;
                } else if (jq_Member2 instanceof jq_InstanceMethod) {
                    n = 17;
                } else if (jq_Member2 instanceof jq_StaticMethod) {
                    n = 16;
                } else {
                    Assert.UNREACHABLE();
                }
                this.updateMemberReference(jq_Member3, (byte)n);
            }
            return jq_Member3;
        }
        catch (Error error) {
            System.err.println("Method " + this.method + " bc index " + this.i_start + ": Error when resolving " + jq_Member2 + ": " + error);
            throw error;
        }
    }

    public void updateCPIndex(char c) {
        int n = this.i_end - this.i_start;
        char c2 = (char)(this.bcs[this.i_start] & 0xFF);
        switch (n) {
            case 1: {
                boolean bl = false;
                if (c2 == '\u0012') {
                    bl = true;
                }
                Assert._assert(bl);
                boolean bl2 = false;
                if (c <= '\u007f') {
                    bl2 = true;
                }
                Assert._assert(bl2);
                this.bcs[this.i_end] = (byte)c;
                break;
            }
            case 2: {
                boolean bl = false;
                if (c2 == '\u0013' || c2 == '\u0014' || c2 == '\u00b2' || c2 == '\u00b3' || c2 == '\u00b4' || c2 == '\u00b5' || c2 == '\u00b6' || c2 == '\u00b7' || c2 == '\u00b8' || c2 == '\u00bb' || c2 == '\u00bd' || c2 == '\u00c0' || c2 == '\u00c1') {
                    bl = true;
                }
                Assert._assert(bl);
                this.bcs[this.i_end - 1] = (byte)(c >> 8);
                this.bcs[this.i_end] = (byte)c;
                break;
            }
            case 3: {
                boolean bl = false;
                if (c2 == '\u00c5') {
                    bl = true;
                }
                Assert._assert(bl);
                this.bcs[this.i_end - 2] = (byte)(c >> 8);
                this.bcs[this.i_end - 1] = (byte)c;
                break;
            }
            case 4: {
                boolean bl = false;
                if (c2 == '\u00b9') {
                    bl = true;
                }
                Assert._assert(bl);
                this.bcs[this.i_end - 3] = (byte)(c >> 8);
                this.bcs[this.i_end - 2] = (byte)c;
                break;
            }
            default: {
                Assert.UNREACHABLE(Strings.hex(c2));
                return;
            }
        }
    }

    public void updateMemberReference(jq_Member jq_Member2, byte by) {
        char c;
        int n = this.i_end - this.i_start;
        char c2 = (char)(this.bcs[this.i_start] & 0xFF);
        switch (n) {
            case 1: {
                boolean bl = false;
                if (c2 == '\u0012') {
                    bl = true;
                }
                Assert._assert(bl);
                --this.i_end;
                c = this.getUnsignedByte();
                break;
            }
            case 2: {
                boolean bl = false;
                if (c2 == '\u0013' || c2 == '\u0014' || c2 == '\u00b2' || c2 == '\u00b3' || c2 == '\u00b4' || c2 == '\u00b5' || c2 == '\u00b6' || c2 == '\u00b7' || c2 == '\u00b8' || c2 == '\u00bb' || c2 == '\u00bd' || c2 == '\u00c0' || c2 == '\u00c1') {
                    bl = true;
                }
                Assert._assert(bl);
                this.i_end -= 2;
                c = this.getUnsignedWord();
                break;
            }
            case 3: {
                boolean bl = false;
                if (c2 == '\u00c5') {
                    bl = true;
                }
                Assert._assert(bl);
                this.i_end -= 3;
                c = this.getUnsignedWord();
                this.getUnsignedByte();
                break;
            }
            case 4: {
                boolean bl = false;
                if (c2 == '\u00b9') {
                    bl = true;
                }
                Assert._assert(bl);
                this.i_end -= 4;
                c = this.getUnsignedWord();
                this.getUnsignedByte();
                this.getSignedByte();
                break;
            }
            default: {
                Assert.UNREACHABLE(Strings.hex(c2));
                return;
            }
        }
        this.clazz.getCP().set(c, jq_Member2, by);
    }

    public void visitBytecode() throws VerifyError {
        char c = this.getUnsignedByte();
        block0 : switch (c) {
            case '\u0000': {
                this.visitNOP();
                break;
            }
            case '\u0001': {
                this.visitACONST(null);
                break;
            }
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '\b': {
                this.visitICONST(c - 3);
                break;
            }
            case '\t': 
            case '\n': {
                this.visitLCONST(c - 9);
                break;
            }
            case '\u000b': {
                this.visitFCONST(0.0f);
                break;
            }
            case '\f': {
                this.visitFCONST(1.0f);
                break;
            }
            case '\r': {
                this.visitFCONST(2.0f);
                break;
            }
            case '\u000e': {
                this.visitDCONST(0.0);
                break;
            }
            case '\u000f': {
                this.visitDCONST(1.0);
                break;
            }
            case '\u0010': {
                byte by = this.getSignedByte();
                this.visitICONST(by);
                break;
            }
            case '\u0011': {
                short s = this.getSignedWord();
                this.visitICONST(s);
                break;
            }
            case '\u0012': {
                char c2 = this.getUnsignedByte();
                byte by = this.clazz.getCPtag(c2);
                if (by == 3) {
                    this.visitICONST(this.clazz.getCPasInt(c2));
                    break;
                }
                if (by == 4) {
                    this.visitFCONST(this.clazz.getCPasFloat(c2).floatValue());
                    break;
                }
                if (by == 8) {
                    this.visitACONST(this.clazz.getCPasString(c2));
                    break;
                }
                throw new VerifyError();
            }
            case '\u0013': {
                char c3 = this.getUnsignedWord();
                byte by = this.clazz.getCPtag(c3);
                if (by == 3) {
                    this.visitICONST(this.clazz.getCPasInt(c3));
                    break;
                }
                if (by == 4) {
                    this.visitFCONST(this.clazz.getCPasFloat(c3).floatValue());
                    break;
                }
                if (by == 8) {
                    this.visitACONST(this.clazz.getCPasString(c3));
                    break;
                }
                throw new VerifyError();
            }
            case '\u0014': {
                char c4 = this.getUnsignedWord();
                byte by = this.clazz.getCPtag(c4);
                if (by == 5) {
                    this.visitLCONST(this.clazz.getCPasLong(c4));
                    break;
                }
                if (by == 6) {
                    this.visitDCONST(this.clazz.getCPasDouble(c4));
                    break;
                }
                throw new VerifyError();
            }
            case '\u0015': {
                char c5 = this.getUnsignedByte();
                this.visitILOAD(c5);
                break;
            }
            case '\u0017': {
                char c6 = this.getUnsignedByte();
                this.visitFLOAD(c6);
                break;
            }
            case '\u0019': {
                char c7 = this.getUnsignedByte();
                this.visitALOAD(c7);
                break;
            }
            case '\u0016': {
                char c8 = this.getUnsignedByte();
                this.visitLLOAD(c8);
                break;
            }
            case '\u0018': {
                char c9 = this.getUnsignedByte();
                this.visitDLOAD(c9);
                break;
            }
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': {
                int n = c - 26;
                this.visitILOAD(n);
                break;
            }
            case '\"': 
            case '#': 
            case '$': 
            case '%': {
                int n = c - 34;
                this.visitFLOAD(n);
                break;
            }
            case '*': 
            case '+': 
            case ',': 
            case '-': {
                int n = c - 42;
                this.visitALOAD(n);
                break;
            }
            case '\u001e': 
            case '\u001f': 
            case ' ': 
            case '!': {
                int n = c - 30;
                this.visitLLOAD(n);
                break;
            }
            case '&': 
            case '\'': 
            case '(': 
            case ')': {
                int n = c - 38;
                this.visitDLOAD(n);
                break;
            }
            case '.': {
                this.visitPEI();
                this.visitIALOAD();
                break;
            }
            case '0': {
                this.visitPEI();
                this.visitFALOAD();
                break;
            }
            case '2': {
                this.visitPEI();
                this.visitAALOAD();
                break;
            }
            case '/': {
                this.visitPEI();
                this.visitLALOAD();
                break;
            }
            case '1': {
                this.visitPEI();
                this.visitDALOAD();
                break;
            }
            case '3': {
                this.visitPEI();
                this.visitBALOAD();
                break;
            }
            case '4': {
                this.visitPEI();
                this.visitCALOAD();
                break;
            }
            case '5': {
                this.visitPEI();
                this.visitSALOAD();
                break;
            }
            case '6': {
                char c10 = this.getUnsignedByte();
                this.visitISTORE(c10);
                break;
            }
            case '8': {
                char c11 = this.getUnsignedByte();
                this.visitFSTORE(c11);
                break;
            }
            case ':': {
                char c12 = this.getUnsignedByte();
                this.visitASTORE(c12);
                break;
            }
            case '7': {
                char c13 = this.getUnsignedByte();
                this.visitLSTORE(c13);
                break;
            }
            case '9': {
                char c14 = this.getUnsignedByte();
                this.visitDSTORE(c14);
                break;
            }
            case ';': 
            case '<': 
            case '=': 
            case '>': {
                int n = c - 59;
                this.visitISTORE(n);
                break;
            }
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                int n = c - 67;
                this.visitFSTORE(n);
                break;
            }
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': {
                int n = c - 75;
                this.visitASTORE(n);
                break;
            }
            case '?': 
            case '@': 
            case 'A': 
            case 'B': {
                int n = c - 63;
                this.visitLSTORE(n);
                break;
            }
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': {
                int n = c - 71;
                this.visitDSTORE(n);
                break;
            }
            case 'O': {
                this.visitPEI();
                this.visitIASTORE();
                break;
            }
            case 'Q': {
                this.visitPEI();
                this.visitFASTORE();
                break;
            }
            case 'P': {
                this.visitPEI();
                this.visitLASTORE();
                break;
            }
            case 'R': {
                this.visitPEI();
                this.visitDASTORE();
                break;
            }
            case 'S': {
                this.visitPEI();
                this.visitAASTORE();
                break;
            }
            case 'T': {
                this.visitPEI();
                this.visitBASTORE();
                break;
            }
            case 'U': {
                this.visitPEI();
                this.visitCASTORE();
                break;
            }
            case 'V': {
                this.visitPEI();
                this.visitSASTORE();
                break;
            }
            case 'W': {
                this.visitPOP();
                break;
            }
            case 'X': {
                this.visitPOP2();
                break;
            }
            case 'Y': {
                this.visitDUP();
                break;
            }
            case 'Z': {
                this.visitDUP_x1();
                break;
            }
            case '[': {
                this.visitDUP_x2();
                break;
            }
            case '\\': {
                this.visitDUP2();
                break;
            }
            case ']': {
                this.visitDUP2_x1();
                break;
            }
            case '^': {
                this.visitDUP2_x2();
                break;
            }
            case '_': {
                this.visitSWAP();
                break;
            }
            case '`': {
                this.visitIBINOP((byte)0);
                break;
            }
            case 'a': {
                this.visitLBINOP((byte)0);
                break;
            }
            case 'b': {
                this.visitFBINOP((byte)0);
                break;
            }
            case 'c': {
                this.visitDBINOP((byte)0);
                break;
            }
            case 'd': {
                this.visitIBINOP((byte)1);
                break;
            }
            case 'e': {
                this.visitLBINOP((byte)1);
                break;
            }
            case 'f': {
                this.visitFBINOP((byte)1);
                break;
            }
            case 'g': {
                this.visitDBINOP((byte)1);
                break;
            }
            case 'h': {
                this.visitIBINOP((byte)2);
                break;
            }
            case 'i': {
                this.visitLBINOP((byte)2);
                break;
            }
            case 'j': {
                this.visitFBINOP((byte)2);
                break;
            }
            case 'k': {
                this.visitDBINOP((byte)2);
                break;
            }
            case 'l': {
                this.visitPEI();
                this.visitIBINOP((byte)3);
                break;
            }
            case 'm': {
                this.visitPEI();
                this.visitLBINOP((byte)3);
                break;
            }
            case 'n': {
                this.visitFBINOP((byte)3);
                break;
            }
            case 'o': {
                this.visitDBINOP((byte)3);
                break;
            }
            case 'p': {
                this.visitPEI();
                this.visitIBINOP((byte)4);
                break;
            }
            case 'q': {
                this.visitPEI();
                this.visitLBINOP((byte)4);
                break;
            }
            case 'r': {
                this.visitFBINOP((byte)4);
                break;
            }
            case 's': {
                this.visitDBINOP((byte)4);
                break;
            }
            case 't': {
                this.visitIUNOP((byte)0);
                break;
            }
            case 'u': {
                this.visitLUNOP((byte)0);
                break;
            }
            case 'v': {
                this.visitFUNOP((byte)0);
                break;
            }
            case 'w': {
                this.visitDUNOP((byte)0);
                break;
            }
            case 'x': {
                this.visitISHIFT((byte)0);
                break;
            }
            case 'y': {
                this.visitLSHIFT((byte)0);
                break;
            }
            case 'z': {
                this.visitISHIFT((byte)1);
                break;
            }
            case '{': {
                this.visitLSHIFT((byte)1);
                break;
            }
            case '|': {
                this.visitISHIFT((byte)2);
                break;
            }
            case '}': {
                this.visitLSHIFT((byte)2);
                break;
            }
            case '~': {
                this.visitIBINOP((byte)5);
                break;
            }
            case '\u007f': {
                this.visitLBINOP((byte)5);
                break;
            }
            case '\u0080': {
                this.visitIBINOP((byte)6);
                break;
            }
            case '\u0081': {
                this.visitLBINOP((byte)6);
                break;
            }
            case '\u0082': {
                this.visitIBINOP((byte)7);
                break;
            }
            case '\u0083': {
                this.visitLBINOP((byte)7);
                break;
            }
            case '\u0084': {
                char c15 = this.getUnsignedByte();
                byte by = this.getSignedByte();
                this.visitIINC(c15, by);
                break;
            }
            case '\u0085': {
                this.visitI2L();
                break;
            }
            case '\u0086': {
                this.visitI2F();
                break;
            }
            case '\u0087': {
                this.visitI2D();
                break;
            }
            case '\u0088': {
                this.visitL2I();
                break;
            }
            case '\u0089': {
                this.visitL2F();
                break;
            }
            case '\u008a': {
                this.visitL2D();
                break;
            }
            case '\u008b': {
                this.visitF2I();
                break;
            }
            case '\u008c': {
                this.visitF2L();
                break;
            }
            case '\u008d': {
                this.visitF2D();
                break;
            }
            case '\u008e': {
                this.visitD2I();
                break;
            }
            case '\u008f': {
                this.visitD2L();
                break;
            }
            case '\u0090': {
                this.visitD2F();
                break;
            }
            case '\u0091': {
                this.visitI2B();
                break;
            }
            case '\u0092': {
                this.visitI2C();
                break;
            }
            case '\u0093': {
                this.visitI2S();
                break;
            }
            case '\u0094': {
                this.visitLCMP2();
                break;
            }
            case '\u0095': {
                this.visitFCMP2((byte)0);
                break;
            }
            case '\u0096': {
                this.visitFCMP2((byte)1);
                break;
            }
            case '\u0097': {
                this.visitDCMP2((byte)0);
                break;
            }
            case '\u0098': {
                this.visitDCMP2((byte)1);
                break;
            }
            case '\u0099': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIF((byte)0, n);
                break;
            }
            case '\u00c6': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIFREF((byte)0, n);
                break;
            }
            case '\u009a': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIF((byte)1, n);
                break;
            }
            case '\u00c7': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIFREF((byte)1, n);
                break;
            }
            case '\u009b': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIF((byte)2, n);
                break;
            }
            case '\u009c': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIF((byte)3, n);
                break;
            }
            case '\u009d': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIF((byte)5, n);
                break;
            }
            case '\u009e': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIF((byte)4, n);
                break;
            }
            case '\u009f': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIFCMP((byte)0, n);
                break;
            }
            case '\u00a5': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIFREFCMP((byte)0, n);
                break;
            }
            case '\u00a0': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIFCMP((byte)1, n);
                break;
            }
            case '\u00a6': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIFREFCMP((byte)1, n);
                break;
            }
            case '\u00a1': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIFCMP((byte)2, n);
                break;
            }
            case '\u00a2': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIFCMP((byte)3, n);
                break;
            }
            case '\u00a3': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIFCMP((byte)5, n);
                break;
            }
            case '\u00a4': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitIFCMP((byte)4, n);
                break;
            }
            case '\u00a7': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitGOTO(n);
                break;
            }
            case '\u00a8': {
                short s = this.getSignedWord();
                int n = this.i_start + s;
                this.visitJSR(n);
                break;
            }
            case '\u00a9': {
                char c16 = this.getUnsignedByte();
                this.visitRET(c16);
                break;
            }
            case '\u00aa': {
                int n = this.i_end + 1 & 3;
                if (n != 0) {
                    this.i_end += 4 - n;
                }
                int n2 = this.getSignedDWord();
                int n3 = this.i_start + n2;
                int n4 = this.getSignedDWord();
                int n5 = this.getSignedDWord();
                int n6 = n5 - n4 + 1;
                int[] nArray = new int[n6];
                int n7 = 0;
                while (n7 < n6) {
                    n2 = this.getSignedDWord();
                    nArray[n7] = this.i_start + n2;
                    ++n7;
                }
                this.visitTABLESWITCH(n3, n4, n5, nArray);
                break;
            }
            case '\u00ab': {
                int n = this.i_end + 1 & 3;
                if (n != 0) {
                    this.i_end += 4 - n;
                }
                int n8 = this.getSignedDWord();
                int n9 = this.i_start + n8;
                int n10 = this.getSignedDWord();
                int[] nArray = new int[n10];
                int[] nArray2 = new int[n10];
                int n11 = 0;
                while (n11 < n10) {
                    nArray[n11] = this.getSignedDWord();
                    int n12 = this.getSignedDWord();
                    nArray2[n11] = this.i_start + n12;
                    ++n11;
                }
                this.visitLOOKUPSWITCH(n9, nArray, nArray2);
                break;
            }
            case '\u00ac': {
                this.visitIRETURN();
                break;
            }
            case '\u00ae': {
                this.visitFRETURN();
                break;
            }
            case '\u00b0': {
                this.visitARETURN();
                break;
            }
            case '\u00ad': {
                this.visitLRETURN();
                break;
            }
            case '\u00af': {
                this.visitDRETURN();
                break;
            }
            case '\u00b1': {
                this.visitVRETURN();
                break;
            }
            case '\u00b2': {
                this.visitPEI();
                char c17 = this.getUnsignedWord();
                jq_StaticField jq_StaticField2 = this.clazz.getCPasStaticField(c17);
                jq_Type jq_Type2 = jq_StaticField2.getType();
                if (jq_Type2.isReferenceType()) {
                    this.visitAGETSTATIC(jq_StaticField2);
                    break;
                }
                if (jq_Type2 == jq_Primitive.INT) {
                    this.visitIGETSTATIC(jq_StaticField2);
                    break;
                }
                if (jq_Type2 == jq_Primitive.FLOAT) {
                    this.visitFGETSTATIC(jq_StaticField2);
                    break;
                }
                if (jq_Type2 == jq_Primitive.LONG) {
                    this.visitLGETSTATIC(jq_StaticField2);
                    break;
                }
                if (jq_Type2 == jq_Primitive.DOUBLE) {
                    this.visitDGETSTATIC(jq_StaticField2);
                    break;
                }
                if (jq_Type2 == jq_Primitive.BOOLEAN) {
                    this.visitZGETSTATIC(jq_StaticField2);
                    break;
                }
                if (jq_Type2 == jq_Primitive.BYTE) {
                    this.visitBGETSTATIC(jq_StaticField2);
                    break;
                }
                if (jq_Type2 == jq_Primitive.CHAR) {
                    this.visitCGETSTATIC(jq_StaticField2);
                    break;
                }
                if (jq_Type2 == jq_Primitive.SHORT) {
                    this.visitSGETSTATIC(jq_StaticField2);
                    break;
                }
                Assert.UNREACHABLE();
                break;
            }
            case '\u00b3': {
                this.visitPEI();
                char c18 = this.getUnsignedWord();
                jq_StaticField jq_StaticField3 = this.clazz.getCPasStaticField(c18);
                jq_Type jq_Type3 = jq_StaticField3.getType();
                if (jq_Type3.isReferenceType()) {
                    this.visitAPUTSTATIC(jq_StaticField3);
                    break;
                }
                if (jq_Type3 == jq_Primitive.INT) {
                    this.visitIPUTSTATIC(jq_StaticField3);
                    break;
                }
                if (jq_Type3 == jq_Primitive.FLOAT) {
                    this.visitFPUTSTATIC(jq_StaticField3);
                    break;
                }
                if (jq_Type3 == jq_Primitive.LONG) {
                    this.visitLPUTSTATIC(jq_StaticField3);
                    break;
                }
                if (jq_Type3 == jq_Primitive.DOUBLE) {
                    this.visitDPUTSTATIC(jq_StaticField3);
                    break;
                }
                if (jq_Type3 == jq_Primitive.BOOLEAN) {
                    this.visitZPUTSTATIC(jq_StaticField3);
                    break;
                }
                if (jq_Type3 == jq_Primitive.BYTE) {
                    this.visitBPUTSTATIC(jq_StaticField3);
                    break;
                }
                if (jq_Type3 == jq_Primitive.CHAR) {
                    this.visitCPUTSTATIC(jq_StaticField3);
                    break;
                }
                if (jq_Type3 == jq_Primitive.SHORT) {
                    this.visitSPUTSTATIC(jq_StaticField3);
                    break;
                }
                Assert.UNREACHABLE();
                break;
            }
            case '\u00b4': {
                this.visitPEI();
                char c19 = this.getUnsignedWord();
                jq_InstanceField jq_InstanceField2 = this.clazz.getCPasInstanceField(c19);
                jq_Type jq_Type4 = jq_InstanceField2.getType();
                if (jq_Type4.isReferenceType()) {
                    this.visitAGETFIELD(jq_InstanceField2);
                    break;
                }
                if (jq_Type4 == jq_Primitive.INT) {
                    this.visitIGETFIELD(jq_InstanceField2);
                    break;
                }
                if (jq_Type4 == jq_Primitive.FLOAT) {
                    this.visitFGETFIELD(jq_InstanceField2);
                    break;
                }
                if (jq_Type4 == jq_Primitive.LONG) {
                    this.visitLGETFIELD(jq_InstanceField2);
                    break;
                }
                if (jq_Type4 == jq_Primitive.DOUBLE) {
                    this.visitDGETFIELD(jq_InstanceField2);
                    break;
                }
                if (jq_Type4 == jq_Primitive.BYTE) {
                    this.visitBGETFIELD(jq_InstanceField2);
                    break;
                }
                if (jq_Type4 == jq_Primitive.CHAR) {
                    this.visitCGETFIELD(jq_InstanceField2);
                    break;
                }
                if (jq_Type4 == jq_Primitive.SHORT) {
                    this.visitSGETFIELD(jq_InstanceField2);
                    break;
                }
                if (jq_Type4 == jq_Primitive.BOOLEAN) {
                    this.visitZGETFIELD(jq_InstanceField2);
                    break;
                }
                Assert.UNREACHABLE();
                break;
            }
            case '\u00b5': {
                this.visitPEI();
                char c20 = this.getUnsignedWord();
                jq_InstanceField jq_InstanceField3 = this.clazz.getCPasInstanceField(c20);
                jq_Type jq_Type5 = jq_InstanceField3.getType();
                if (jq_Type5.isReferenceType()) {
                    this.visitAPUTFIELD(jq_InstanceField3);
                    break;
                }
                if (jq_Type5 == jq_Primitive.INT) {
                    this.visitIPUTFIELD(jq_InstanceField3);
                    break;
                }
                if (jq_Type5 == jq_Primitive.FLOAT) {
                    this.visitFPUTFIELD(jq_InstanceField3);
                    break;
                }
                if (jq_Type5 == jq_Primitive.LONG) {
                    this.visitLPUTFIELD(jq_InstanceField3);
                    break;
                }
                if (jq_Type5 == jq_Primitive.DOUBLE) {
                    this.visitDPUTFIELD(jq_InstanceField3);
                    break;
                }
                if (jq_Type5 == jq_Primitive.BYTE) {
                    this.visitBPUTFIELD(jq_InstanceField3);
                    break;
                }
                if (jq_Type5 == jq_Primitive.CHAR) {
                    this.visitCPUTFIELD(jq_InstanceField3);
                    break;
                }
                if (jq_Type5 == jq_Primitive.SHORT) {
                    this.visitSPUTFIELD(jq_InstanceField3);
                    break;
                }
                if (jq_Type5 == jq_Primitive.BOOLEAN) {
                    this.visitZPUTFIELD(jq_InstanceField3);
                    break;
                }
                Assert.UNREACHABLE();
                break;
            }
            case '\u00b6': {
                this.visitPEI();
                char c21 = this.getUnsignedWord();
                jq_InstanceMethod jq_InstanceMethod2 = this.clazz.getCPasInstanceMethod(c21);
                jq_Type jq_Type6 = jq_InstanceMethod2.getReturnType();
                if (jq_Type6 == jq_Primitive.VOID) {
                    this.visitVINVOKE((byte)0, jq_InstanceMethod2);
                    break;
                }
                if (jq_Type6.isReferenceType()) {
                    this.visitAINVOKE((byte)0, jq_InstanceMethod2);
                    break;
                }
                if (jq_Type6 == jq_Primitive.FLOAT) {
                    this.visitFINVOKE((byte)0, jq_InstanceMethod2);
                    break;
                }
                if (jq_Type6 == jq_Primitive.LONG) {
                    this.visitLINVOKE((byte)0, jq_InstanceMethod2);
                    break;
                }
                if (jq_Type6 == jq_Primitive.DOUBLE) {
                    this.visitDINVOKE((byte)0, jq_InstanceMethod2);
                    break;
                }
                this.visitIINVOKE((byte)0, jq_InstanceMethod2);
                break;
            }
            case '\u00b7': {
                this.visitPEI();
                char c22 = this.getUnsignedWord();
                jq_InstanceMethod jq_InstanceMethod3 = this.clazz.getCPasInstanceMethod(c22);
                jq_Type jq_Type7 = jq_InstanceMethod3.getReturnType();
                if (jq_Type7 == jq_Primitive.VOID) {
                    this.visitVINVOKE((byte)2, jq_InstanceMethod3);
                    break;
                }
                if (jq_Type7.isReferenceType()) {
                    this.visitAINVOKE((byte)2, jq_InstanceMethod3);
                    break;
                }
                if (jq_Type7 == jq_Primitive.FLOAT) {
                    this.visitFINVOKE((byte)2, jq_InstanceMethod3);
                    break;
                }
                if (jq_Type7 == jq_Primitive.LONG) {
                    this.visitLINVOKE((byte)2, jq_InstanceMethod3);
                    break;
                }
                if (jq_Type7 == jq_Primitive.DOUBLE) {
                    this.visitDINVOKE((byte)2, jq_InstanceMethod3);
                    break;
                }
                this.visitIINVOKE((byte)2, jq_InstanceMethod3);
                break;
            }
            case '\u00b8': {
                this.visitPEI();
                char c23 = this.getUnsignedWord();
                jq_StaticMethod jq_StaticMethod2 = this.clazz.getCPasStaticMethod(c23);
                jq_Type jq_Type8 = jq_StaticMethod2.getReturnType();
                if (jq_Type8 == jq_Primitive.VOID) {
                    this.visitVINVOKE((byte)1, jq_StaticMethod2);
                    break;
                }
                if (jq_Type8.isReferenceType()) {
                    this.visitAINVOKE((byte)1, jq_StaticMethod2);
                    break;
                }
                if (jq_Type8 == jq_Primitive.FLOAT) {
                    this.visitFINVOKE((byte)1, jq_StaticMethod2);
                    break;
                }
                if (jq_Type8 == jq_Primitive.LONG) {
                    this.visitLINVOKE((byte)1, jq_StaticMethod2);
                    break;
                }
                if (jq_Type8 == jq_Primitive.DOUBLE) {
                    this.visitDINVOKE((byte)1, jq_StaticMethod2);
                    break;
                }
                this.visitIINVOKE((byte)1, jq_StaticMethod2);
                break;
            }
            case '\u00b9': {
                this.visitPEI();
                char c24 = this.getUnsignedWord();
                jq_InstanceMethod jq_InstanceMethod4 = this.clazz.getCPasInstanceMethod(c24);
                this.getUnsignedByte();
                this.getSignedByte();
                jq_Type jq_Type9 = jq_InstanceMethod4.getReturnType();
                if (jq_Type9 == jq_Primitive.VOID) {
                    this.visitVINVOKE((byte)3, jq_InstanceMethod4);
                    break;
                }
                if (jq_Type9.isReferenceType()) {
                    this.visitAINVOKE((byte)3, jq_InstanceMethod4);
                    break;
                }
                if (jq_Type9 == jq_Primitive.FLOAT) {
                    this.visitFINVOKE((byte)3, jq_InstanceMethod4);
                    break;
                }
                if (jq_Type9 == jq_Primitive.LONG) {
                    this.visitLINVOKE((byte)3, jq_InstanceMethod4);
                    break;
                }
                if (jq_Type9 == jq_Primitive.DOUBLE) {
                    this.visitDINVOKE((byte)3, jq_InstanceMethod4);
                    break;
                }
                this.visitIINVOKE((byte)3, jq_InstanceMethod4);
                break;
            }
            case '\u00ba': {
                throw new VerifyError();
            }
            case '\u00bb': {
                char c25 = this.getUnsignedWord();
                jq_Type jq_Type10 = this.clazz.getCPasType(c25);
                this.visitNEW(jq_Type10);
                break;
            }
            case '\u00bc': {
                this.visitPEI();
                byte by = this.getSignedByte();
                jq_Array jq_Array2 = jq_Array.getPrimitiveArrayType(by);
                jq_Array2.load();
                jq_Array2.prepare();
                this.visitNEWARRAY(jq_Array2);
                break;
            }
            case '\u00bd': {
                this.visitPEI();
                char c26 = this.getUnsignedWord();
                jq_Type jq_Type11 = this.clazz.getCPasType(c26);
                jq_Array jq_Array3 = jq_Type11.getArrayTypeForElementType();
                jq_Array3.load();
                jq_Array3.prepare();
                this.visitNEWARRAY(jq_Array3);
                break;
            }
            case '\u00be': {
                this.visitPEI();
                this.visitARRAYLENGTH();
                break;
            }
            case '\u00bf': {
                this.visitPEI();
                this.visitATHROW();
                break;
            }
            case '\u00c0': {
                this.visitPEI();
                char c27 = this.getUnsignedWord();
                jq_Type jq_Type12 = this.clazz.getCPasType(c27);
                this.visitCHECKCAST(jq_Type12);
                break;
            }
            case '\u00c1': {
                this.visitPEI();
                char c28 = this.getUnsignedWord();
                jq_Type jq_Type13 = this.clazz.getCPasType(c28);
                this.visitINSTANCEOF(jq_Type13);
                break;
            }
            case '\u00c2': {
                this.visitPEI();
                this.visitMONITOR((byte)0);
                break;
            }
            case '\u00c3': {
                this.visitPEI();
                this.visitMONITOR((byte)1);
                break;
            }
            case '\u00c4': {
                char c29 = this.getUnsignedByte();
                char c30 = this.getUnsignedWord();
                switch (c29) {
                    case '\u0015': {
                        this.visitILOAD(c30);
                        break block0;
                    }
                    case '\u0017': {
                        this.visitFLOAD(c30);
                        break block0;
                    }
                    case '\u0019': {
                        this.visitALOAD(c30);
                        break block0;
                    }
                    case '\u0016': {
                        this.visitLLOAD(c30);
                        break block0;
                    }
                    case '\u0018': {
                        this.visitDLOAD(c30);
                        break block0;
                    }
                    case '6': {
                        this.visitISTORE(c30);
                        break block0;
                    }
                    case '8': {
                        this.visitFSTORE(c30);
                        break block0;
                    }
                    case ':': {
                        this.visitASTORE(c30);
                        break block0;
                    }
                    case '7': {
                        this.visitLSTORE(c30);
                        break block0;
                    }
                    case '9': {
                        this.visitDSTORE(c30);
                        break block0;
                    }
                    case '\u0084': {
                        short s = this.getSignedWord();
                        this.visitIINC(c30, s);
                        break block0;
                    }
                    case '\u009a': {
                        this.visitRET(c30);
                        break block0;
                    }
                }
                throw new VerifyError();
            }
            case '\u00c5': {
                this.visitPEI();
                char c31 = this.getUnsignedWord();
                char c32 = this.getUnsignedByte();
                jq_Type jq_Type14 = this.clazz.getCPasType(c31);
                jq_Type14.load();
                jq_Type14.prepare();
                this.visitMULTINEWARRAY(jq_Type14, c32);
                break;
            }
            case '\u00c8': {
                int n = this.getSignedDWord();
                int n13 = this.i_start + n;
                this.visitGOTO(n13);
                break;
            }
            case '\u00c9': {
                int n = this.getSignedDWord();
                int n14 = this.i_start + n;
                this.visitJSR(n14);
                break;
            }
            default: {
                throw new VerifyError();
            }
        }
    }

    public void visitPEI() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " is a PEI");
        }
    }

    public void visitNOP() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " NOP");
        }
    }

    public void visitACONST(Object object) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ACONST \"" + object + '\"');
        }
    }

    public void visitICONST(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ICONST " + n);
        }
    }

    public void visitLCONST(long l) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LCONST " + l);
        }
    }

    public void visitFCONST(float f) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FCONST " + f);
        }
    }

    public void visitDCONST(double d) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DCONST " + d);
        }
    }

    public void visitILOAD(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ILOAD " + n);
        }
    }

    public void visitLLOAD(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LLOAD " + n);
        }
    }

    public void visitFLOAD(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FLOAD " + n);
        }
    }

    public void visitDLOAD(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DLOAD " + n);
        }
    }

    public void visitALOAD(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ALOAD " + n);
        }
    }

    public void visitISTORE(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ISTORE " + n);
        }
    }

    public void visitLSTORE(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LSTORE " + n);
        }
    }

    public void visitFSTORE(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FSTORE " + n);
        }
    }

    public void visitDSTORE(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DSTORE " + n);
        }
    }

    public void visitASTORE(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ASTORE " + n);
        }
    }

    public void visitIALOAD() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IALOAD");
        }
    }

    public void visitLALOAD() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LALOAD");
        }
    }

    public void visitFALOAD() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FALOAD");
        }
    }

    public void visitDALOAD() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DALOAD");
        }
    }

    public void visitAALOAD() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " AALOAD");
        }
    }

    public void visitBALOAD() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " BALOAD");
        }
    }

    public void visitCALOAD() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " CALOAD");
        }
    }

    public void visitSALOAD() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " SALOAD");
        }
    }

    public void visitIASTORE() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IASTORE");
        }
    }

    public void visitLASTORE() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LASTORE");
        }
    }

    public void visitFASTORE() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FASTORE");
        }
    }

    public void visitDASTORE() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DASTORE");
        }
    }

    public void visitAASTORE() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " AASTORE");
        }
    }

    public void visitBASTORE() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " BASTORE");
        }
    }

    public void visitCASTORE() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " CASTORE");
        }
    }

    public void visitSASTORE() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " SASTORE");
        }
    }

    public void visitPOP() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " POP");
        }
    }

    public void visitPOP2() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " POP2");
        }
    }

    public void visitDUP() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DUP");
        }
    }

    public void visitDUP_x1() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DUP_x1");
        }
    }

    public void visitDUP_x2() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DUP_x2");
        }
    }

    public void visitDUP2() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DUP2");
        }
    }

    public void visitDUP2_x1() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DUP2_x1");
        }
    }

    public void visitDUP2_x2() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DUP2_x2");
        }
    }

    public void visitSWAP() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " SWAP");
        }
    }

    public void visitIBINOP(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " I" + binopnames[by]);
        }
    }

    public void visitLBINOP(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " L" + binopnames[by]);
        }
    }

    public void visitFBINOP(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " F" + binopnames[by]);
        }
    }

    public void visitDBINOP(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " D" + binopnames[by]);
        }
    }

    public void visitIUNOP(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " I" + binopnames[by]);
        }
    }

    public void visitLUNOP(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " L" + binopnames[by]);
        }
    }

    public void visitFUNOP(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " F" + binopnames[by]);
        }
    }

    public void visitDUNOP(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " D" + binopnames[by]);
        }
    }

    public void visitISHIFT(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ISHIFT " + shiftopnames[by]);
        }
    }

    public void visitLSHIFT(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LSHIFT " + shiftopnames[by]);
        }
    }

    public void visitIINC(int n, int n2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IINC " + n + ' ' + n2);
        }
    }

    public void visitI2L() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " I2L");
        }
    }

    public void visitI2F() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " I2F");
        }
    }

    public void visitI2D() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " I2D");
        }
    }

    public void visitL2I() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " L2I");
        }
    }

    public void visitL2F() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " L2F");
        }
    }

    public void visitL2D() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " L2D");
        }
    }

    public void visitF2I() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " F2I");
        }
    }

    public void visitF2L() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " F2L");
        }
    }

    public void visitF2D() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " F2D");
        }
    }

    public void visitD2I() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " D2I");
        }
    }

    public void visitD2L() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " D2L");
        }
    }

    public void visitD2F() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " D2F");
        }
    }

    public void visitI2B() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " I2B");
        }
    }

    public void visitI2C() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " I2C");
        }
    }

    public void visitI2S() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " I2S");
        }
    }

    public void visitLCMP2() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LCMP2");
        }
    }

    public void visitFCMP2(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FCMP2 " + fcmpopnames[by]);
        }
    }

    public void visitDCMP2(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DCMP2 " + fcmpopnames[by]);
        }
    }

    public void visitIF(byte by, int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IF" + cmpopnames[by] + ' ' + n);
        }
    }

    public void visitIFREF(byte by, int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IFREF" + cmpopnames[by] + ' ' + n);
        }
    }

    public void visitIFCMP(byte by, int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IFCMP" + cmpopnames[by] + ' ' + n);
        }
    }

    public void visitIFREFCMP(byte by, int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IFREFCMP" + cmpopnames[by] + ' ' + n);
        }
    }

    public void visitGOTO(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " GOTO " + n);
        }
    }

    public void visitJSR(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " JSR " + n);
        }
    }

    public void visitRET(int n) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " RET " + n);
        }
    }

    public void visitTABLESWITCH(int n, int n2, int n3, int[] nArray) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " TABLESWITCH(" + n2 + ".." + n3 + ",def:" + n + ')');
        }
    }

    public void visitLOOKUPSWITCH(int n, int[] nArray, int[] nArray2) {
        boolean bl = false;
        if (nArray.length == nArray2.length) {
            bl = true;
        }
        Assert._assert(bl);
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LOOKUPSWITCH(" + nArray.length + " entries,def:" + n + ')');
        }
    }

    public void visitIRETURN() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IRETURN");
        }
    }

    public void visitLRETURN() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LRETURN");
        }
    }

    public void visitFRETURN() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FRETURN");
        }
    }

    public void visitDRETURN() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DRETURN");
        }
    }

    public void visitARETURN() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ARETURN");
        }
    }

    public void visitVRETURN() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " VRETURN");
        }
    }

    public void visitIGETSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IGETSTATIC " + jq_StaticField2);
        }
    }

    public void visitLGETSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LGETSTATIC " + jq_StaticField2);
        }
    }

    public void visitFGETSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FGETSTATIC " + jq_StaticField2);
        }
    }

    public void visitDGETSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DGETSTATIC " + jq_StaticField2);
        }
    }

    public void visitAGETSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " AGETSTATIC " + jq_StaticField2);
        }
    }

    public void visitZGETSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ZGETSTATIC " + jq_StaticField2);
        }
    }

    public void visitBGETSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " BGETSTATIC " + jq_StaticField2);
        }
    }

    public void visitCGETSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " CGETSTATIC " + jq_StaticField2);
        }
    }

    public void visitSGETSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " SGETSTATIC " + jq_StaticField2);
        }
    }

    public void visitIPUTSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IPUTSTATIC " + jq_StaticField2);
        }
    }

    public void visitLPUTSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LPUTSTATIC " + jq_StaticField2);
        }
    }

    public void visitFPUTSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FPUTSTATIC " + jq_StaticField2);
        }
    }

    public void visitDPUTSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DPUTSTATIC " + jq_StaticField2);
        }
    }

    public void visitAPUTSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " APUTSTATIC " + jq_StaticField2);
        }
    }

    public void visitZPUTSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ZPUTSTATIC " + jq_StaticField2);
        }
    }

    public void visitBPUTSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " BPUTSTATIC " + jq_StaticField2);
        }
    }

    public void visitCPUTSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " CPUTSTATIC " + jq_StaticField2);
        }
    }

    public void visitSPUTSTATIC(jq_StaticField jq_StaticField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " SPUTSTATIC " + jq_StaticField2);
        }
    }

    public void visitIGETFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IGETFIELD " + jq_InstanceField2);
        }
    }

    public void visitLGETFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LGETFIELD " + jq_InstanceField2);
        }
    }

    public void visitFGETFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FGETFIELD " + jq_InstanceField2);
        }
    }

    public void visitDGETFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DGETFIELD " + jq_InstanceField2);
        }
    }

    public void visitAGETFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " AGETFIELD " + jq_InstanceField2);
        }
    }

    public void visitBGETFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " BGETFIELD " + jq_InstanceField2);
        }
    }

    public void visitCGETFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " CGETFIELD " + jq_InstanceField2);
        }
    }

    public void visitSGETFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " SGETFIELD " + jq_InstanceField2);
        }
    }

    public void visitZGETFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ZGETFIELD " + jq_InstanceField2);
        }
    }

    public void visitIPUTFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IPUTFIELD " + jq_InstanceField2);
        }
    }

    public void visitLPUTFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LPUTFIELD " + jq_InstanceField2);
        }
    }

    public void visitFPUTFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FPUTFIELD " + jq_InstanceField2);
        }
    }

    public void visitDPUTFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DPUTFIELD " + jq_InstanceField2);
        }
    }

    public void visitAPUTFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " APUTFIELD " + jq_InstanceField2);
        }
    }

    public void visitBPUTFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " BPUTFIELD " + jq_InstanceField2);
        }
    }

    public void visitCPUTFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " CPUTFIELD " + jq_InstanceField2);
        }
    }

    public void visitSPUTFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " SPUTFIELD " + jq_InstanceField2);
        }
    }

    public void visitZPUTFIELD(jq_InstanceField jq_InstanceField2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ZPUTFIELD " + jq_InstanceField2);
        }
    }

    public void visitIINVOKE(byte by, jq_Method jq_Method2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " IINVOKE" + invokeopnames[by] + ' ' + jq_Method2);
        }
    }

    public void visitLINVOKE(byte by, jq_Method jq_Method2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " LINVOKE" + invokeopnames[by] + ' ' + jq_Method2);
        }
    }

    public void visitFINVOKE(byte by, jq_Method jq_Method2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " FINVOKE" + invokeopnames[by] + ' ' + jq_Method2);
        }
    }

    public void visitDINVOKE(byte by, jq_Method jq_Method2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " DINVOKE" + invokeopnames[by] + ' ' + jq_Method2);
        }
    }

    public void visitAINVOKE(byte by, jq_Method jq_Method2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " AINVOKE" + invokeopnames[by] + ' ' + jq_Method2);
        }
    }

    public void visitVINVOKE(byte by, jq_Method jq_Method2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " VINVOKE" + invokeopnames[by] + ' ' + jq_Method2);
        }
    }

    public void visitNEW(jq_Type jq_Type2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " NEW " + jq_Type2);
        }
    }

    public void visitNEWARRAY(jq_Array jq_Array2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " NEWARRAY " + jq_Array2);
        }
    }

    public void visitCHECKCAST(jq_Type jq_Type2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " CHECKCAST " + jq_Type2);
        }
    }

    public void visitINSTANCEOF(jq_Type jq_Type2) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " INSTANCEOF " + jq_Type2);
        }
    }

    public void visitARRAYLENGTH() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ARRAYLENGTH");
        }
    }

    public void visitATHROW() {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " ATHROW");
        }
    }

    public void visitMONITOR(byte by) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " MONITOR " + monitoropnames[by]);
        }
    }

    public void visitMULTINEWARRAY(jq_Type jq_Type2, char c) {
        if (this.TRACE) {
            this.out.println(this + ": " + this.i_start + " MULTINEWARRAY " + jq_Type2 + " (dim:" + c + ')');
        }
    }

    private final byte getSignedByte() {
        return this.bcs[++this.i_end];
    }

    private final char getUnsignedByte() {
        return (char)(this.bcs[++this.i_end] & 0xFF);
    }

    private final short getSignedWord() {
        int n = this.bcs[++this.i_end] << 8;
        return (short)(n |= this.bcs[++this.i_end] & 0xFF);
    }

    private final char getUnsignedWord() {
        int n = (this.bcs[++this.i_end] & 0xFF) << 8;
        return (char)(n |= this.bcs[++this.i_end] & 0xFF);
    }

    private final int getSignedDWord() {
        int n = this.bcs[++this.i_end] << 24;
        n |= (this.bcs[++this.i_end] & 0xFF) << 16;
        n |= (this.bcs[++this.i_end] & 0xFF) << 8;
        return n |= this.bcs[++this.i_end] & 0xFF;
    }

    private final /* synthetic */ void this() {
        this.TRACE = false;
        this.out = System.out;
    }

    public BytecodeVisitor(jq_Method jq_Method2) {
        this(CompilationState.DEFAULT, jq_Method2);
    }

    public BytecodeVisitor(CompilationState compilationState, jq_Method jq_Method2) {
        this.this();
        this.state = compilationState;
        this.clazz = jq_Method2.getDeclaringClass();
        this.method = jq_Method2;
        this.bcs = jq_Method2.getBytecode();
        boolean bl = false;
        if (this.bcs != null) {
            bl = true;
        }
        Assert._assert(bl, "Method " + this.method + " has no bytecode!");
    }
}

