/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPSSA.Utils;

import Clazz.jq_Method;
import Compil3r.Analysis.IPA.ProgramLocation;
import Compil3r.Analysis.IPSSA.DominatorQuery;
import Compil3r.Quad.BasicBlock;
import Compil3r.Quad.BasicBlockVisitor;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.ControlFlowGraph;
import Compil3r.Quad.ControlFlowGraphVisitor;
import Compil3r.Quad.Dominators;
import Compil3r.Quad.Quad;
import Compil3r.Quad.QuadIterator;
import Util.Assert;
import Util.SyntheticGraphs.Graph;
import Util.Templates.ListIterator;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimpleDominatorQuery
implements DominatorQuery {
    private jq_Method _m;
    private ControlFlowGraph _cfg;
    private HashMap _bb2nodeMap;
    private HashMap _quad2BBMap;
    private boolean _verbose;

    private final void buildBB2NodeMap(Dominators.DominatorNode dominatorNode, HashMap hashMap) {
        BasicBlock basicBlock = dominatorNode.getBasicBlock();
        boolean bl = false;
        if (basicBlock != null) {
            bl = true;
        }
        Assert._assert(bl);
        hashMap.put(basicBlock, dominatorNode);
        List list = dominatorNode.getChildren();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Dominators.DominatorNode dominatorNode2 = (Dominators.DominatorNode)iterator.next();
            this.buildBB2NodeMap(dominatorNode2, hashMap);
        }
    }

    private final void buildQuad2BBMap(HashMap hashMap) {
        this._cfg.visitBasicBlocks(new BasicBlockVisitor(this, hashMap){
            final /* synthetic */ SimpleDominatorQuery this$0;
            final /* synthetic */ HashMap val$map;

            public final void visitBasicBlock(BasicBlock basicBlock) {
                Quad quad = basicBlock.getLastQuad();
                if (quad == null) {
                    return;
                }
                int n = 0;
                while (n <= basicBlock.getQuadIndex(quad)) {
                    Quad quad2 = basicBlock.getQuad(n);
                    this.val$map.put(quad2, basicBlock);
                    ++n;
                }
            }
            {
                this.this$0 = simpleDominatorQuery;
                this.val$map = hashMap;
            }
        });
    }

    public Quad getImmediateDominator(Quad quad) {
        BasicBlock basicBlock = (BasicBlock)this._quad2BBMap.get(quad);
        boolean bl = false;
        if (basicBlock != null) {
            bl = true;
        }
        Assert._assert(bl);
        int n = basicBlock.getQuadIndex(quad);
        if (n > 0) {
            return basicBlock.getQuad(n - 1);
        }
        Dominators.DominatorNode dominatorNode = (Dominators.DominatorNode)this._bb2nodeMap.get(basicBlock);
        boolean bl2 = false;
        if (dominatorNode != null) {
            bl2 = true;
        }
        Assert._assert(bl2);
        Dominators.DominatorNode dominatorNode2 = dominatorNode.getParent();
        if (dominatorNode2 != null) {
            return dominatorNode2.getBasicBlock().getLastQuad();
        }
        return null;
    }

    public boolean isTop(Quad quad) {
        boolean bl = false;
        if (this.getImmediateDominator(quad) == null) {
            bl = true;
        }
        return bl;
    }

    public void getDominanceFrontier(Quad quad, Set set) {
        boolean bl = false;
        if (set != null) {
            bl = true;
        }
        Assert._assert(bl);
        Dominators.DominatorNode dominatorNode = this.getNode(quad);
        this.processChildren(dominatorNode.getBasicBlock(), dominatorNode, set);
        if (this._verbose) {
            System.err.println("Dominance frontier for " + quad.toString_short() + " is: ");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Quad quad2 = (Quad)iterator.next();
                System.err.print(quad2.toString() + ' ');
            }
            System.err.println("");
        }
    }

    private final void processChildren(BasicBlock basicBlock, Dominators.DominatorNode dominatorNode, Set set) {
        Object object;
        BasicBlock basicBlock2 = dominatorNode.getBasicBlock();
        if (basicBlock2.size() == 0) {
            return;
        }
        ListIterator.BasicBlock basicBlock3 = basicBlock2.getSuccessors().basicBlockIterator();
        while (basicBlock3.hasNext()) {
            object = basicBlock3.nextBasicBlock();
            Assert._assert(this.dominates(basicBlock, basicBlock));
            Assert._assert(this.dominates((BasicBlock)object, (BasicBlock)object));
            if (this.dominates(basicBlock, (BasicBlock)object, true)) continue;
            set.add(((BasicBlock)object).getQuad(0));
            break;
        }
        object = dominatorNode.getChildren().iterator();
        while (object.hasNext()) {
            Dominators.DominatorNode dominatorNode2 = (Dominators.DominatorNode)object.next();
            boolean bl = false;
            if (dominatorNode2 != dominatorNode) {
                bl = true;
            }
            Assert._assert(bl);
            this.processChildren(basicBlock, dominatorNode2, set);
        }
    }

    private final boolean dominates(BasicBlock basicBlock, BasicBlock basicBlock2) {
        return this.dominates(basicBlock, basicBlock2, false);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean dominates(BasicBlock var1_1, BasicBlock var2_2, boolean var3_3) {
        var4_4 = (Dominators.DominatorNode)this._bb2nodeMap.get(var1_1);
        var5_5 = (Dominators.DominatorNode)this._bb2nodeMap.get(var2_2);
        if (var3_3 || var1_1 != var2_2) ** GOTO lbl7
        return true;
lbl-1000:
        // 1 sources

        {
            if ((var5_5 = var5_5.getParent()) != var4_4) continue;
            return true;
lbl7:
            // 2 sources

            ** while (var5_5 != null)
        }
lbl8:
        // 1 sources

        return false;
    }

    private final Dominators.DominatorNode getNode(Quad quad) {
        BasicBlock basicBlock = (BasicBlock)this._quad2BBMap.get(quad);
        boolean bl = false;
        if (basicBlock != null) {
            bl = true;
        }
        Assert._assert(bl, "No matching basic block for " + quad);
        Dominators.DominatorNode dominatorNode = (Dominators.DominatorNode)this._bb2nodeMap.get(basicBlock);
        boolean bl2 = false;
        if (dominatorNode != null) {
            bl2 = true;
        }
        Assert._assert(bl2);
        return dominatorNode;
    }

    public void getIteratedDominanceFrontier(Quad quad, Set set) {
        this.getDominanceFrontier(quad, set);
        boolean bl = false;
        int n = 1;
        do {
            bl = false;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Quad quad2 = (Quad)iterator.next();
                int n2 = set.size();
                this.getDominanceFrontier(quad2, set);
                boolean bl2 = false;
                if (set.size() >= n2) {
                    bl2 = true;
                }
                Assert._assert(bl2);
                if (set.size() == n2) continue;
                bl = true;
            }
            ++n;
        } while (bl);
    }

    public void printDot(PrintStream printStream) {
        Graph graph = new Graph(this._m.toString(), new Graph.Direction("LR"));
        QuadIterator quadIterator = new QuadIterator(this._cfg);
        while (quadIterator.hasNext()) {
            Quad quad = (Quad)quadIterator.next();
            ProgramLocation.QuadProgramLocation quadProgramLocation = new ProgramLocation.QuadProgramLocation(this._m, quad);
            String string = quadProgramLocation.getSourceFile().toString() + ':' + quadProgramLocation.getLineNumber();
            graph.addNode(quad.getID(), quad.toString_short() + "\\l" + string);
            Quad quad2 = this.getImmediateDominator(quad);
            if (quad2 == null) continue;
            graph.addNode(quad2.getID(), quad2.toString_short());
            graph.addEdge(quad.getID(), quad2.getID());
        }
        graph.printDot(printStream);
    }

    public BasicBlock getBasicBlock(Quad quad) {
        return (BasicBlock)this._quad2BBMap.get(quad);
    }

    private final /* synthetic */ void this() {
        this._verbose = false;
    }

    public SimpleDominatorQuery(jq_Method jq_Method2) {
        this.this();
        this._m = jq_Method2;
        this._cfg = CodeCache.getCode(jq_Method2);
        Dominators dominators = new Dominators(true);
        dominators.visitMethod(jq_Method2);
        Dominators.DominatorNode dominatorNode = dominators.computeTree();
        this._bb2nodeMap = new HashMap();
        this.buildBB2NodeMap(dominatorNode, this._bb2nodeMap);
        this._quad2BBMap = new HashMap();
        this.buildQuad2BBMap(this._quad2BBMap);
    }

    public static class TestSimpleDominatorQuery
    implements ControlFlowGraphVisitor {
        public void visitCFG(ControlFlowGraph controlFlowGraph) {
            SimpleDominatorQuery simpleDominatorQuery = new SimpleDominatorQuery(controlFlowGraph.getMethod());
            simpleDominatorQuery.printDot(System.out);
        }

        public static void Main(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                boolean bl = false;
                if (string == "-v") {
                    bl = true;
                }
                ++n;
            }
        }

        public TestSimpleDominatorQuery() {
            CodeCache.AlwaysMap = true;
        }
    }
}

