/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPSSA;

import Clazz.jq_Method;
import Compil3r.Analysis.IPSSA.ContextSet;
import Compil3r.Analysis.IPSSA.SSADefinition;
import Compil3r.Analysis.IPSSA.SSAIterator;
import Compil3r.Analysis.IPSSA.Utils.DefinitionSet;
import Compil3r.Analysis.IPSSA.Utils.IteratorHelper;
import Compil3r.Quad.Quad;
import Util.Assert;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Vector;

public abstract class SSAValue {
    protected SSADefinition _destination;

    public SSADefinition getDestination() {
        return this._destination;
    }

    void setDestination(SSADefinition sSADefinition) {
        this._destination = sSADefinition;
    }

    public Quad getQuad() {
        return this.getDestination().getQuad();
    }

    public abstract SSAIterator.DefinitionIterator getUsedDefinitionIterator();

    public abstract String toString();

    public static class Copy
    extends SSAValue {
        SSADefinition _definition;

        public SSAIterator.DefinitionIterator getUsedDefinitionIterator() {
            return new SSAIterator.DefinitionIterator(new IteratorHelper.SingleIterator(this._definition));
        }

        public SSADefinition getDefinition() {
            return this._definition;
        }

        public String toString() {
            return "(" + this._definition + ')';
        }

        private Copy(SSADefinition sSADefinition) {
            this._definition = sSADefinition;
            sSADefinition.appendUse(this);
        }

        public static class FACTORY {
            static Copy create_copy(SSADefinition sSADefinition) {
                return new Copy(sSADefinition);
            }
        }
    }

    public static class Alloc
    extends SSAValue {
        Quad _quad;

        public SSAIterator.DefinitionIterator getUsedDefinitionIterator() {
            return new SSAIterator.DefinitionIterator(IteratorHelper.EmptyIterator.FACTORY.get());
        }

        public String toString() {
            return "Alloc @ " + this._quad;
        }

        private Alloc(Quad quad) {
            this._quad = quad;
        }

        public static class FACTORY {
            public static Alloc createAlloc(Quad quad) {
                return new Alloc(quad);
            }
        }
    }

    public static abstract class Terminal
    extends SSAValue {
    }

    public static abstract class Constant
    extends Terminal {
        public SSAIterator.DefinitionIterator getUsedDefinitionIterator() {
            return new SSAIterator.DefinitionIterator(IteratorHelper.EmptyIterator.FACTORY.get());
        }
    }

    public static class UnknownConstant
    extends Constant {
        public String toString() {
            return "<Unknown>";
        }

        private UnknownConstant() {
        }

        public static class FACTORY {
            static UnknownConstant _sample = null;

            public static UnknownConstant create_unknown_contant() {
                if (_sample == null) {
                    _sample = new UnknownConstant();
                }
                return _sample;
            }
        }
    }

    public static class NullConstant
    extends Constant {
        public String toString() {
            return "<Null>";
        }

        private NullConstant() {
        }

        public static class FACTORY {
            static NullConstant _sample = null;

            public static NullConstant create_null_contant() {
                if (_sample == null) {
                    _sample = new NullConstant();
                }
                return _sample;
            }
        }
    }

    public static abstract class Normal
    extends Terminal {
        public abstract SSAIterator.DefinitionIterator getUsedDefinitionIterator();
    }

    public static class UseCollection
    extends Normal {
        DefinitionSet _usedDefinitions = new DefinitionSet();

        public SSAIterator.DefinitionIterator getUsedDefinitionIterator() {
            return this._usedDefinitions.getDefinitionIterator();
        }

        public void addUsedDefinition(SSADefinition sSADefinition) {
            this._usedDefinitions.add(sSADefinition);
            sSADefinition.appendUse(this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("{ ");
            SSAIterator.DefinitionIterator definitionIterator = this.getUsedDefinitionIterator();
            while (definitionIterator.hasNext()) {
                SSADefinition sSADefinition = definitionIterator.nextDefinition();
                stringBuffer.append(sSADefinition.toString());
                stringBuffer.append(" ");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }

        private UseCollection() {
        }

        public static class FACTORY {
            static UseCollection createUseCollection() {
                return new UseCollection();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class Phi
    extends SSAValue {
        protected Vector _definitions;
        protected LinkedHashSet _usedDefinitions;

        public int getDefinitionCount() {
            return this._definitions.size();
        }

        public SSADefinition getDefinition(int n) {
            return (SSADefinition)this._definitions.get(n);
        }

        public Iterator getDefinitionIterator() {
            return this._definitions.iterator();
        }

        public SSAIterator.DefinitionIterator getUsedDefinitionIterator() {
            return new SSAIterator.DefinitionIterator(this._usedDefinitions.iterator());
        }

        public abstract String getLetter();

        public String toString() {
            String string = this.getLetter() + '(';
            int n = 0;
            while (n < this._definitions.size()) {
                SSADefinition sSADefinition = this.getDefinition(n);
                string = string + sSADefinition.toString() + ", ";
                ++n;
            }
            if (this._definitions.size() > 0) {
                string = string.substring(0, string.length() - 2);
            }
            return string + ')';
        }

        private final /* synthetic */ void this() {
            this._definitions = new Vector();
            this._usedDefinitions = new LinkedHashSet();
        }

        public Phi() {
            this.this();
        }
    }

    public static class Predicate {
        public static String UNKNOWN = "<unknown>";
        private String _predicate;

        public String toString() {
            return this._predicate;
        }

        public static Predicate True() {
            return null;
        }

        public Predicate(String string) {
            this._predicate = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class Predicated
    extends Phi {
        protected Vector _predicates;

        public Predicate getPredicate(int n) {
            return (Predicate)this._predicates.get(n);
        }

        public void add(SSADefinition sSADefinition, String string) {
            this._definitions.addElement(sSADefinition);
            this._predicates.addElement(string);
            sSADefinition.appendUse(this);
            this._usedDefinitions.add(sSADefinition);
        }

        public String toString() {
            boolean bl = false;
            if (this._predicates.size() == this._definitions.size()) {
                bl = true;
            }
            Assert._assert(bl);
            String string = this.getLetter() + '(';
            int n = 0;
            while (n < this._definitions.size()) {
                SSADefinition sSADefinition = this.getDefinition(n);
                Predicate predicate = this.getPredicate(n);
                string = predicate == null ? string + '<' + sSADefinition + ">, " : string + '<' + sSADefinition + ", " + predicate.toString() + ">, ";
                ++n;
            }
            if (this._definitions.size() > 0) {
                string = string.substring(0, string.length() - 2);
            }
            return string + ')';
        }

        private final /* synthetic */ void this() {
            this._predicates = new Vector();
        }

        public Predicated() {
            this.this();
        }
    }

    public static class OmegaPhi
    extends Phi {
        public String getLetter() {
            return "omega";
        }

        public void addUsedDefinition(SSADefinition sSADefinition) {
            this._definitions.addElement(sSADefinition);
            sSADefinition.appendUse(this);
            this._usedDefinitions.add(sSADefinition);
        }
    }

    public static class SigmaPhi
    extends Phi {
        private ContextSet _context;

        public String getLetter() {
            return "sigma";
        }

        protected void setContext(ContextSet contextSet) {
            this._context = contextSet;
        }

        protected ContextSet getContext() {
            return this._context;
        }

        public SigmaPhi(ContextSet contextSet, SSADefinition sSADefinition, SSADefinition sSADefinition2) {
            this.setContext(contextSet);
            this._definitions.add(sSADefinition);
            this._definitions.add(sSADefinition2);
            this._usedDefinitions.add(sSADefinition);
            this._usedDefinitions.add(sSADefinition2);
            sSADefinition2.appendUse(this);
            sSADefinition.appendUse(this);
        }
    }

    public static class Gamma
    extends Predicated {
        public String getLetter() {
            return "gamma";
        }
    }

    public static abstract class IPPhi
    extends Phi {
    }

    public static class FormalIn
    extends IPPhi {
        protected Vector _callers = new Vector();

        Quad getCaller(int n) {
            return (Quad)this._callers.get(n);
        }

        void add(SSADefinition sSADefinition, Quad quad) {
            this._definitions.addElement(sSADefinition);
            this._callers.addElement(quad);
            this._usedDefinitions.add(sSADefinition);
            sSADefinition.appendUse(this);
        }

        public String getLetter() {
            return "iota";
        }

        public String toString() {
            String string = this.getLetter() + '(';
            int n = 0;
            while (n < this._definitions.size()) {
                SSADefinition sSADefinition = this.getDefinition(n);
                Quad quad = this.getCaller(n);
                string = string + '<' + sSADefinition.toString() + ", " + quad + ">, ";
                ++n;
            }
            if (this._definitions.size() > 0) {
                string = string.substring(0, string.length() - 2);
            }
            return string + ')';
        }

        public boolean hasCallSite(Quad quad) {
            return this._callers.contains(quad);
        }

        FormalIn() {
        }
    }

    public static class ActualOut
    extends IPPhi {
        protected Vector _callees = new Vector();

        jq_Method getCallee(int n) {
            return (jq_Method)this._callees.get(n);
        }

        void add(SSADefinition sSADefinition, jq_Method jq_Method2) {
            this._definitions.addElement(sSADefinition);
            this._callees.addElement(jq_Method2);
            this._usedDefinitions.add(sSADefinition);
            sSADefinition.appendUse(this);
        }

        public String getLetter() {
            return "rho";
        }

        public String toString() {
            String string = this.getLetter() + '(';
            int n = 0;
            while (n < this._definitions.size()) {
                SSADefinition sSADefinition = this.getDefinition(n);
                jq_Method jq_Method2 = this.getCallee(n);
                string = string + '<' + sSADefinition.toString() + ", " + jq_Method2 + ">, ";
                ++n;
            }
            if (this._definitions.size() > 0) {
                string = string.substring(0, string.length() - 2);
            }
            return string + ')';
        }

        ActualOut() {
        }
    }
}

