/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPSSA;

import Clazz.jq_LocalVarTableEntry;
import Clazz.jq_Method;
import Clazz.jq_NameAndDesc;
import Compil3r.Analysis.IPA.PA;
import Compil3r.Quad.CodeCache;
import Compil3r.Quad.Quad;
import Compil3r.Quad.RegisterFactory;
import Util.Assert;
import java.util.HashMap;

public interface SSALocation {
    public String toString(PA var1);

    public static class Temporary
    implements SSALocation {
        public String toString(PA pA) {
            return null;
        }

        public String toString() {
            return "temp";
        }

        private Temporary() {
        }

        public static class FACTORY {
            private static Temporary INSTANCE = new Temporary();

            public static Temporary get() {
                return INSTANCE;
            }
        }
    }

    public static class Unique
    implements SSALocation {
        private static long _count = 0L;
        private long _id;

        public String toString(PA pA) {
            return null;
        }

        public String toString() {
            return "uniq" + this._id;
        }

        private Unique(long l) {
            this._id = l;
        }

        public static class FACTORY {
            public static Unique get() {
                long l = _count;
                _count = l + 1L;
                return new Unique(l);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class LocalLocation
    implements SSALocation {
        private RegisterFactory.Register _reg;
        private String _name;

        public RegisterFactory.Register getRegister() {
            return this._reg;
        }

        public String toString(PA pA) {
            return this.toString();
        }

        public String toString() {
            return this._reg.toString();
        }

        public String getName(jq_Method jq_Method2, Quad quad) {
            if (this._reg.isTemp()) {
                return null;
            }
            if (this._name != null) {
                return this._name;
            }
            Integer n = (Integer)CodeCache.getBCMap(jq_Method2).get(quad);
            if (n == null) {
                return null;
            }
            int n2 = n;
            jq_LocalVarTableEntry jq_LocalVarTableEntry2 = jq_Method2.getLocalVarTableEntry(n2, this._reg.getNumber());
            if (jq_LocalVarTableEntry2 == null) {
                return null;
            }
            jq_NameAndDesc jq_NameAndDesc2 = jq_LocalVarTableEntry2.getNameAndDesc();
            if (jq_NameAndDesc2 == null) {
                return null;
            }
            this._name = jq_NameAndDesc2.getName().toString();
            return this._name;
        }

        private final /* synthetic */ void this() {
            this._name = null;
        }

        private LocalLocation(RegisterFactory.Register register) {
            this.this();
            boolean bl = false;
            if (register != null) {
                bl = true;
            }
            Assert._assert(bl);
            this._reg = register;
        }

        public static class FACTORY {
            static HashMap _locationMap = new HashMap();

            public static LocalLocation createLocalLocation(RegisterFactory.Register register) {
                LocalLocation localLocation = (LocalLocation)_locationMap.get(register);
                if (localLocation == null) {
                    localLocation = new LocalLocation(register);
                    _locationMap.put(register, localLocation);
                }
                return localLocation;
            }
        }
    }
}

