/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPSSA;

import Clazz.jq_Method;
import Compil3r.Analysis.IPSSA.SSAIterator;
import Compil3r.Analysis.IPSSA.SSALocation;
import Compil3r.Analysis.IPSSA.SSAValue;
import Compil3r.Analysis.IPSSA.Utils.DefinitionSet;
import Compil3r.Quad.Quad;
import java.util.HashMap;
import java.util.LinkedHashSet;

public class SSADefinition {
    protected SSALocation _location;
    int _version;
    LinkedHashSet _uses;
    long _id;
    jq_Method _method;
    Quad _quad;

    public SSALocation getLocation() {
        return this._location;
    }

    public int getVersion() {
        return this._version;
    }

    public jq_Method getMethod() {
        return this._method;
    }

    public Quad getQuad() {
        return this._quad;
    }

    public String toString() {
        String string = this._location.toString() + '_' + this._version;
        if (!(this._location instanceof SSALocation.LocalLocation)) {
            return string;
        }
        SSALocation.LocalLocation localLocation = (SSALocation.LocalLocation)this._location;
        String string2 = localLocation.getName(this._method, this._quad);
        return string2 == null ? string : string + '(' + string2 + ')';
    }

    public long getID() {
        return this._id;
    }

    public SSAIterator.ValueIterator getUseIterator() {
        return new SSAIterator.ValueIterator(this._uses.iterator());
    }

    public void appendUse(SSAValue sSAValue) {
        this._uses.add(sSAValue);
    }

    private SSADefinition(SSALocation sSALocation, int n, Quad quad, jq_Method jq_Method2, long l) {
        this._location = sSALocation;
        this._version = n;
        this._quad = quad;
        this._method = jq_Method2;
        this._id = l;
        this._uses = new LinkedHashSet();
    }

    public static class Helper {
        protected static HashMap _versionMap = new HashMap();
        protected static long _globalID;
        protected static DefinitionSet _definitionCache;

        static SSADefinition create_ssa_definition(SSALocation sSALocation, Quad quad, jq_Method jq_Method2) {
            Object object;
            int n = 0;
            if (_versionMap.containsKey(sSALocation)) {
                object = (Integer)_versionMap.get(sSALocation);
                n = (Integer)object;
                _versionMap.put(sSALocation, new Integer(n + 1));
            } else {
                _versionMap.put(sSALocation, new Integer(1));
            }
            object = new SSADefinition(sSALocation, n, quad, jq_Method2, _globalID++);
            _definitionCache.add(object);
            return object;
        }

        public static SSAIterator.DefinitionIterator getAllDefinitionIterator() {
            return _definitionCache.getDefinitionIterator();
        }

        public static SSADefinition lookupDefinition(String string) {
            SSAIterator.DefinitionIterator definitionIterator = Helper.getAllDefinitionIterator();
            while (definitionIterator.hasNext()) {
                SSADefinition sSADefinition = definitionIterator.nextDefinition();
                if (!sSADefinition.toString().equals(string)) continue;
                return sSADefinition;
            }
            return null;
        }

        static {
            _definitionCache = new DefinitionSet();
        }
    }
}

