/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPSSA;

import Clazz.jq_Method;
import Compil3r.Analysis.IPSSA.SSABindingVisitor;
import Compil3r.Analysis.IPSSA.SSADefinition;
import Compil3r.Analysis.IPSSA.SSALocation;
import Compil3r.Analysis.IPSSA.SSAProcInfo;
import Compil3r.Analysis.IPSSA.SSAValue;
import Compil3r.Quad.Quad;

public class SSABinding {
    protected Quad _quad;
    protected SSADefinition _destination;
    protected SSAValue _value;

    public void setValue(SSAValue sSAValue) {
        this._value = sSAValue;
        this._value.setDestination(this._destination);
    }

    public boolean isComplete() {
        boolean bl = false;
        if (this._value != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isValid() {
        boolean bl = false;
        if ((this._value == null || this._destination == this._value.getDestination()) && this._quad == this._destination.getQuad()) {
            bl = true;
        }
        return bl;
    }

    public SSADefinition getDestination() {
        return this._destination;
    }

    public SSAValue getValue() {
        return this._value;
    }

    public Quad getQuad() {
        return this._destination.getQuad();
    }

    public void accept(SSABindingVisitor sSABindingVisitor) {
        sSABindingVisitor.visit(this);
    }

    public String toString() {
        return this._destination.toString() + " = " + (this._value == null ? "<incomplete>" : this._value.toString());
    }

    public SSABinding(Quad quad, SSADefinition sSADefinition, SSAValue sSAValue) {
        this._quad = quad;
        this._destination = sSADefinition;
        this._value = sSAValue;
        sSAValue.setDestination(sSADefinition);
    }

    public SSABinding(Quad quad, SSALocation sSALocation, SSAValue sSAValue, jq_Method jq_Method2) {
        SSADefinition sSADefinition;
        this._quad = quad;
        this._value = sSAValue;
        this._destination = sSADefinition = SSAProcInfo.Helper.create_ssa_definition(sSALocation, quad, jq_Method2);
        if (sSAValue != null) {
            sSAValue.setDestination(sSADefinition);
        }
    }
}

