/*
 * Decompiled with CFR 0.152.
 */
package Compil3r.Analysis.IPSSA;

import Compil3r.Analysis.IPSSA.ContextSet;
import Compil3r.Analysis.IPSSA.SSADefinition;
import Compil3r.Analysis.IPSSA.SSAIterator;
import Compil3r.Analysis.IPSSA.SSAValue;
import Compil3r.Analysis.IPSSA.Utils.IteratorHelper;
import Util.Assert;
import Util.Collections.LinearSet;
import Util.SyntheticGraphs.Graph;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class DefinitionGraph {
    private HashSet _nodes;
    protected int _edgeCount;

    protected void addNode(SSADefinition sSADefinition) {
        this._nodes.add(sSADefinition);
    }

    public int getEdgeCount() {
        return this._edgeCount;
    }

    public int getNodeCount() {
        return this._nodes.size();
    }

    public abstract void addEdge(SSADefinition var1, SSADefinition var2, EdgeInfo var3);

    public abstract boolean isRootNode(SSADefinition var1);

    public abstract boolean isTerminalNode(SSADefinition var1);

    public Set getRoots() {
        LinearSet linearSet = new LinearSet();
        Iterator iterator = this._nodes.iterator();
        while (iterator.hasNext()) {
            SSADefinition sSADefinition = (SSADefinition)iterator.next();
            if (!this.isRootNode(sSADefinition)) continue;
            linearSet.add(sSADefinition);
        }
        return linearSet;
    }

    public Set getTerminals() {
        LinearSet linearSet = new LinearSet();
        Iterator iterator = this._nodes.iterator();
        while (iterator.hasNext()) {
            SSADefinition sSADefinition = (SSADefinition)iterator.next();
            if (!this.isTerminalNode(sSADefinition)) continue;
            linearSet.add(sSADefinition);
        }
        return linearSet;
    }

    public abstract SSAIterator.DefinitionIterator getReached(SSADefinition var1);

    public abstract SSAIterator.DefinitionIterator getAllReached(SSADefinition var1);

    public abstract SSAIterator.DefinitionIterator getReaching(SSADefinition var1);

    public abstract SSAIterator.DefinitionIterator getAllReaching(SSADefinition var1);

    public String toString() {
        return "DefinitionGraph: " + this._nodes.size() + "nodes, " + this._edgeCount + " edges";
    }

    public void printDot(PrintStream printStream) {
        this.printDot(this._nodes.iterator(), printStream, true);
    }

    public void printReachedToDot(SSADefinition sSADefinition, PrintStream printStream) {
        this.printDot(new IteratorHelper.SingleIterator(sSADefinition), printStream, true);
    }

    public void printReachingToDot(SSADefinition sSADefinition, PrintStream printStream) {
        this.printDot(new IteratorHelper.SingleIterator(sSADefinition), printStream, false);
    }

    protected void printDot(Iterator iterator, PrintStream printStream, boolean bl) {
        Graph graph = new Graph();
        while (iterator.hasNext()) {
            SSADefinition sSADefinition = (SSADefinition)iterator.next();
            new Object(this, bl){
                final /* synthetic */ DefinitionGraph this$0;
                final /* synthetic */ boolean val$direction;

                final void makeDotAux(Graph graph, SSADefinition sSADefinition) {
                    SSAIterator.DefinitionIterator definitionIterator;
                    graph.addNode(sSADefinition.getID(), sSADefinition.toString());
                    SSAIterator.DefinitionIterator definitionIterator2 = definitionIterator = this.val$direction ? this.this$0.getReached(sSADefinition) : this.this$0.getReaching(sSADefinition);
                    if (definitionIterator != null) {
                        while (definitionIterator.hasNext()) {
                            SSADefinition sSADefinition2 = (SSADefinition)definitionIterator.next();
                            graph.addEdge(sSADefinition.getID(), sSADefinition2.getID());
                            this.makeDotAux(graph, sSADefinition2);
                        }
                    }
                }
                {
                    this.this$0 = definitionGraph;
                    this.val$direction = bl;
                }
            }.makeDotAux(graph, sSADefinition);
            graph.printDot(printStream);
        }
    }

    public void addEdge(SSADefinition sSADefinition, SSADefinition sSADefinition2) {
        this.addEdge(sSADefinition, sSADefinition2, PredicateEdge.TrueEdge.FACTORY.get());
    }

    public abstract EdgeInfo getEdgeInfo(SSADefinition var1, SSADefinition var2);

    private final /* synthetic */ void this() {
        this._edgeCount = 0;
    }

    public DefinitionGraph() {
        this.this();
        this._nodes = new HashSet();
    }

    class EmptyEdge
    implements EdgeInfo {
        EmptyEdge() {
        }
    }

    static class PredicateEdge
    implements EdgeInfo {
        SSAValue.Predicate _predicate;

        PredicateEdge(SSAValue.Predicate predicate) {
            this._predicate = predicate;
        }

        static class TrueEdge
        extends PredicateEdge {
            SSAValue.Predicate _predicate;

            private TrueEdge() {
                super(SSAValue.Predicate.True());
            }

            static class FACTORY {
                static TrueEdge _sample;

                static TrueEdge get() {
                    if (_sample == null) {
                        _sample = new TrueEdge();
                    }
                    return _sample;
                }

                FACTORY() {
                }
            }
        }
    }

    class ContextEdge
    implements EdgeInfo {
        ContextSet _context;

        ContextEdge(ContextSet contextSet) {
            this._context = contextSet;
        }
    }

    class IPEdge
    implements EdgeInfo {
        IPEdge() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class EfficientDefinitionGraph
    extends DefinitionGraph {
        private HashMap _adjacencyLists;
        private HashMap _reverseAdjacencyLists;

        public void addEdge(SSADefinition sSADefinition, SSADefinition sSADefinition2, EdgeInfo edgeInfo) {
            HashMap<SSADefinition, EdgeInfo> hashMap = (HashMap<SSADefinition, EdgeInfo>)this._adjacencyLists.get(sSADefinition2);
            if (hashMap == null) {
                hashMap = new HashMap<SSADefinition, EdgeInfo>();
                this._adjacencyLists.put(sSADefinition2, hashMap);
            }
            Assert._assert(hashMap.containsKey(sSADefinition) ^ true, "Already have a an edge " + sSADefinition.toString() + " -> " + sSADefinition2.toString() + " with edge information " + edgeInfo.toString());
            hashMap.put(sSADefinition, edgeInfo);
            LinkedList<SSADefinition> linkedList = (LinkedList<SSADefinition>)this._reverseAdjacencyLists.get(sSADefinition);
            if (linkedList == null) {
                linkedList = new LinkedList<SSADefinition>();
            }
            linkedList.addLast(sSADefinition2);
            ++this._edgeCount;
        }

        public EdgeInfo getEdgeInfo(SSADefinition sSADefinition, SSADefinition sSADefinition2) {
            HashMap hashMap = (HashMap)this._adjacencyLists.get(sSADefinition2);
            if (hashMap == null) {
                return null;
            }
            return (EdgeInfo)hashMap.get(sSADefinition);
        }

        public boolean isTerminalNode(SSADefinition sSADefinition) {
            LinkedList linkedList = (LinkedList)this._reverseAdjacencyLists.get(sSADefinition);
            if (linkedList == null) {
                return true;
            }
            return linkedList.isEmpty();
        }

        public boolean isRootNode(SSADefinition sSADefinition) {
            HashMap hashMap = (HashMap)this._adjacencyLists.get(sSADefinition);
            if (hashMap == null) {
                return true;
            }
            return hashMap.isEmpty();
        }

        public SSAIterator.DefinitionIterator getReached(SSADefinition sSADefinition) {
            LinkedList linkedList = (LinkedList)this._reverseAdjacencyLists.get(sSADefinition);
            if (linkedList == null) {
                return null;
            }
            return new SSAIterator.DefinitionIterator(linkedList.iterator());
        }

        public SSAIterator.DefinitionIterator getAllReached(SSADefinition sSADefinition) {
            HashSet hashSet = new HashSet();
            new Object(this){
                final /* synthetic */ EfficientDefinitionGraph this$0;

                final Set getReachedAux(SSADefinition sSADefinition, Set set) {
                    set.add(sSADefinition);
                    SSAIterator.DefinitionIterator definitionIterator = this.this$0.getReached(sSADefinition);
                    if (definitionIterator != null) {
                        while (definitionIterator.hasNext()) {
                            SSADefinition sSADefinition2 = (SSADefinition)definitionIterator.next();
                            this.getReachedAux(sSADefinition2, set);
                        }
                    }
                    return set;
                }
                {
                    this.this$0 = efficientDefinitionGraph;
                }
            }.getReachedAux(sSADefinition, hashSet);
            return new SSAIterator.DefinitionIterator(hashSet.iterator());
        }

        public SSAIterator.DefinitionIterator getReaching(SSADefinition sSADefinition) {
            HashMap hashMap = (HashMap)this._adjacencyLists.get(sSADefinition);
            if (hashMap == null) {
                return null;
            }
            return new SSAIterator.DefinitionIterator(hashMap.values().iterator());
        }

        public SSAIterator.DefinitionIterator getAllReaching(SSADefinition sSADefinition) {
            HashSet hashSet = new HashSet();
            new Object(this){
                final /* synthetic */ EfficientDefinitionGraph this$0;

                final Set getReachingAux(SSADefinition sSADefinition, Set set) {
                    set.add(sSADefinition);
                    SSAIterator.DefinitionIterator definitionIterator = this.this$0.getReaching(sSADefinition);
                    if (definitionIterator != null) {
                        while (definitionIterator.hasNext()) {
                            SSADefinition sSADefinition2 = (SSADefinition)definitionIterator.next();
                            this.getReachingAux(sSADefinition2, set);
                        }
                    }
                    return set;
                }
                {
                    this.this$0 = efficientDefinitionGraph;
                }
            }.getReachingAux(sSADefinition, hashSet);
            return new SSAIterator.DefinitionIterator(hashSet.iterator());
        }

        private final /* synthetic */ void this() {
            this._adjacencyLists = new HashMap();
            this._reverseAdjacencyLists = new HashMap();
        }

        EfficientDefinitionGraph() {
            this.this();
        }
    }

    public static interface EdgeInfo {
    }
}

